unit WTPreview;

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
//                        Part of WindowsTree                              //
//                       Listeur d'arborescences                           //
//  2001 - 2011  Alain JAFFRE               http://jack.r.free.fr          //
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
//                          Update history                                 //
//                                                                         //
//                                                                         //
//                                                                         //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

{***************************************************************************}
{ Ce logiciel est un logiciel libre. Vous pouvez le diffuser et/ou le       }
{ modifier suivant les termes de la GNU General Public License telle que    }
{ publie par la Free Software Foundation, soit la version 2 de cette        }
{ license, soit ( votre convenance) une version ultrieure.                }
{                                                                           }
{ Ce programme est diffus dans l'espoir qu'il sera utile, mais SANS AUCUNE }
{ GARANTIE, sans mme une garantie implicite de COMMERCIALISABILITE ou      }
{ d'ADEQUATION A UN USAGE PARTICULIER. Voyez la GNU General Public License  }
{ pour plus de dtails.                                                     }
{                                                                           }
{ Vous devriez avoir reu une copie de la GNU General Public License avec   }
{ ce programme, veuillez consulter <http://www.gnu.org/licenses/>           }
{***************************************************************************}

{***************************************************************************}
{ This program is free software. You can redistribute it and/or modify it   }
{ under the terms of the GNU Public License as published by the             }
{ Free Software Foundation, either version 2 of the license, or             }
{ (at your option) any later version.                                       }
{                                                                           }
{ This program is distributed in the hope it will be useful, but WITHOUT    }
{ ANY WARRANTY, without even the implied warranty of MERCHANTABILITY or     }
{ FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for  }
{ more details.                                                             }
{                                                                           }
{ You should have received a copy of the GNU General Public License along   }
{ with this program, if not, see <http://www.gnu.org/licenses/>.            }
{***************************************************************************}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, ImgList, ToolWin, ActnList, Menus,
  XPMenu,
  RichEditPrintPreview;

type
  TFrmPreview = class(TForm)
{ Toolbar }
    TBarNavigation: TToolBar;
    IlNavigation: TImageList;
    TBtnFirst: TToolButton;
    TBtnPrior: TToolButton;
    TBtnNext: TToolButton;
    TBtnLast: TToolButton;
    TbnSpacer1: TToolButton;
    TBtnZoomMinus: TToolButton;
    TBtnZoomPlus: TToolButton;
    TbnSpacer2: TToolButton;
    TBtnFullPage: TToolButton;
    TBtnPageWidth: TToolButton;
    TbnSpacer3: TToolButton;
    TBtnMiseEnPage: TToolButton;
    TbtnPrinterSetup: TToolButton;
    TBtnPrint: TToolButton;
{ Status bar }
    SBarApercu: TStatusBar;
{ Actions }
    ALstApercu: TActionList;
    ActFirstPage: TAction;
    ActPreviousPage: TAction;
    ActNextPage: TAction;
    ActLastPage: TAction;
    ActZoomMinus: TAction;
    ActZoomPlus: TAction;
    ActAdjustScale: TAction;
    ActFullPage: TAction;
    ActPageWidth: TAction;
    ActShowMargins: TAction;
    ActPreviewSetup: TAction;
    ActPrint: TAction;
{ Popup scale }
    PopupMenuZoom: TPopupMenu;
    MnuFullPage: TMenuItem;
    MnuPageWidth: TMenuItem;
    MnuSpacer1: TMenuItem;
    Mnu25pourcent: TMenuItem;
    Mnu50pourcent: TMenuItem;
    Mnu75pourcent: TMenuItem;
    Mnu100pourcent: TMenuItem;
    Mnu125pourcent: TMenuItem;
    Mnu150pourcent: TMenuItem;
    Mnu175pourcent: TMenuItem;
    Mnu200pourcent: TMenuItem;
    Mnu300pourcent: TMenuItem;
    Mnu400pourcent: TMenuItem;
{ Dialogs }
    PrintDlg: TPrintDialog;
    PrinterSetupDlg: TPrinterSetupDialog;
{ Form }
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormShow(Sender: TObject);
{ Action }
    procedure ActFirstPageExecute(Sender: TObject);
    procedure ActPreviousPageExecute(Sender: TObject);
    procedure ActNextPageExecute(Sender: TObject);
    procedure ActLastPageExecute(Sender: TObject);
    procedure ActZoomMinusExecute(Sender: TObject);
    procedure ActZoomPlusExecute(Sender: TObject);
    procedure ActAdjustScaleExecute(Sender: TObject);
    procedure ActFullPageExecute(Sender: TObject);
    procedure ActPageWidthExecute(Sender: TObject);
    procedure ActShowMarginsExecute(Sender: TObject);
    procedure ActPreviewSetupExecute(Sender: TObject);
    procedure ActPrintExecute(Sender: TObject);
  private
    { Dclarations prives }
    XPMenu: TXPMenu;
    procedure ApplyLanguage;
    procedure ApplyConfig;
    procedure UpdateUI;
    procedure PreviewScaleChange(Sender: TObject; Scale: single);
    procedure Printing(Sender: TObject; Page: integer);
  public
    { Dclarations publiques }
    RichEditPrintPreview: TRichEditPrintPreview;
  end;

var
  FrmPreview: TFrmPreview;

implementation

{$R *.DFM}

uses
  WTConfig, WTLng;

{------------------------------------------------------------------------------}
{ Form                                                                         }
{------------------------------------------------------------------------------}

procedure TFrmPreview.FormCreate(Sender: TObject);
begin
  // XP menu style
  XPMenu := TXPMenu.Create(Self);
  with XPMenu do
  begin
    Name := 'XPMenu';
    DimLevel := 30;
    GrayLevel := 10;
    Font.Charset := ANSI_CHARSET;
    Font.Color := clMenuText;
    Font.Height := -11;
    Font.Name := 'Microsoft Sans Serif';
    Font.Style := [];
    Color := clBtnFace;
    DrawMenuBar := False;
    IconBackColor := clBtnFace;
    MenuBarColor := clBtnFace;
    SelectColor := clHighlight;
    SelectBorderColor := clHighlight;
    SelectFontColor := clMenuText;
    DisabledColor := clInactiveCaption;
    SeparatorColor := clBtnFace;
    CheckedColor := clHighlight;
    IconWidth := 24;
    DrawSelect := True;
    UseSystemColors := True;
    UseDimColor := False;
    OverrideOwnerDraw := False;
    Gradient := False;
    FlatMenu := True;
    AutoDetect := True;
    Active := True;
    Left := 56;
    Top := 120;
  end;

  RichEditPrintPreview:= TRichEditPrintPreview.Create(self);
  with RichEditPrintPreview do
  begin
    Parent:= Self;
    Align:= alClient;
    RichEdit:= nil;
    ShowMargin:= true;
    MarginInMM:= true;
  end;
  ApplyConfig;
  ApplyLanguage;

  RichEditPrintPreview.OnScaleChange:= PreviewScaleChange;
  RichEditPrintPreview.OnPrint:= Printing;

  ActShowMargins.Checked:= RichEditPrintPreview.ShowMargin;
end;

{------------------------------------------------------------------------------}

procedure TFrmPreview.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  RichEditPrintPreview.Free;
end;

{------------------------------------------------------------------------------}

procedure TFrmPreview.FormShow(Sender: TObject);
begin
  RichEditPrintPreview.Reset;
  RichEditPrintPreview.Display;
  PreviewScaleChange(self,RichEditPrintPreview.Scale);
  UpdateUI;
end;

{------------------------------------------------------------------------------}
{ Actions                                                                      }
{------------------------------------------------------------------------------}

procedure TFrmPreview.ActFirstPageExecute(Sender: TObject);
begin
  RichEditPrintPreview.FirstPage;
  UpdateUI;
end;

{------------------------------------------------------------------------------}

procedure TFrmPreview.ActPreviousPageExecute(Sender: TObject);
begin
  RichEditPrintPreview.PreviousPage;
  UpdateUI;
end;

{------------------------------------------------------------------------------}

procedure TFrmPreview.ActNextPageExecute(Sender: TObject);
begin
  RichEditPrintPreview.NextPage;
  UpdateUI;
end;

{------------------------------------------------------------------------------}

procedure TFrmPreview.ActLastPageExecute(Sender: TObject);
begin
  RichEditPrintPreview.LastPage;
  UpdateUI;
end;

{------------------------------------------------------------------------------}

procedure TFrmPreview.ActZoomMinusExecute(Sender: TObject);
begin
  RichEditPrintPreview.Scale:= RichEditPrintPreview.Scale / 2;
end;

{------------------------------------------------------------------------------}

procedure TFrmPreview.ActZoomPlusExecute(Sender: TObject);
begin
  RichEditPrintPreview.Scale:= RichEditPrintPreview.Scale * 2;
end;

{------------------------------------------------------------------------------}

procedure TFrmPreview.ActAdjustScaleExecute(Sender: TObject);
begin
  with Sender as TMenuItem do
  begin
    RichEditPrintPreview.ScaleMode:= smScaled;
    RichEditPrintPreview.Scale:= Tag / 100;
  end;
end;

{------------------------------------------------------------------------------}

procedure TFrmPreview.ActFullPageExecute(Sender: TObject);
begin
  RichEditPrintPreview.ScaleMode:= smWholePage;
end;

{------------------------------------------------------------------------------}

procedure TFrmPreview.ActPageWidthExecute(Sender: TObject);
begin
  RichEditPrintPreview.ScaleMode:= smPageWidth;
end;

{------------------------------------------------------------------------------}

procedure TFrmPreview.ActShowMarginsExecute(Sender: TObject);
begin
  ActShowMargins.Checked:= not ActShowMargins.Checked;
  RichEditPrintPreview.ShowMargin:= ActShowMargins.Checked;
end;

{------------------------------------------------------------------------------}

procedure TFrmPreview.ActPreviewSetupExecute(Sender: TObject);
begin
  with TFrmConfig.Create(Application) do
  try
    SelectedTab:= 2;
    Showmodal;
  finally
    Free;
  end;
  ApplyConfig;
  RichEditPrintPreview.Display;
end;

{------------------------------------------------------------------------------}

procedure TFrmPreview.ActPrintExecute(Sender: TObject);
// Print
var
  NbOfPages: integer;
begin
  with PrintDlg do
  begin
    // General
    Options:= [];
    PrintRange:= prAllPages;
    // If more then one page
    NbOfPages:= RichEditPrintPreview.NumberOfPages;
    if NbOfPages > 1 then
    begin
      Options:= Options + [poPageNums];
      FromPage:= 1;
      MinPage:= 1;
      ToPage:= NbOfPages;
      MaxPage:= ToPage;
    end;
  end;

  if PrintDlg.Execute then
  begin
    Screen.Cursor:= crHourGlass;
    RichEditPrintPreview.Reset;
    case PrintDlg.PrintRange of
      prAllPages  : RichEditPrintPreview.Print(1,-1);
    else // prPageNums
      RichEditPrintPreview.Print(PrintDlg.FromPage,PrintDlg.ToPage);
    end;
    Screen.Cursor:= crDefault;
  end;
end;

{------------------------------------------------------------------------------}
{ Private                                                                      }
{------------------------------------------------------------------------------}

procedure TFrmPreview.ApplyLanguage;
begin
  Caption:= GetMsg(0151);
  TBtnFirst.Hint:= GetMsg(0152);
  TBtnPrior.Hint:= GetMsg(0153);
  TBtnNext.Hint:= GetMsg(0154);
  TBtnLast.Hint:= GetMsg(0155);
  TBtnZoomMinus.Hint:= GetMsg(0156);
  TBtnZoomPlus.Hint:= GetMsg(0157);
  TBtnFullPage.Hint:= GetMsg(0158);
  TBtnPageWidth.Hint:= GetMsg(0159);
  TBtnMiseEnPage.Hint:= GetMsg(0160);
  TbtnPrinterSetup.Hint:= GetMsg(0161);
  TBtnPrint.Hint:= GetMsg(0162);
  MnuFullPage.Caption:= GetMsg(0163);
  MnuPageWidth.Caption:= GetMsg(0164);
end;

{------------------------------------------------------------------------------}

procedure TFrmPreview.ApplyConfig;
begin
  with RichEditPrintPreview do
  begin
    TopMargin:= Config.TopMargin;
    BottomMargin:= Config.BottomMargin;
    LeftMargin:= Config.LeftMargin;
    RightMargin:= Config.RightMargin;
    HeaderHeight:= Config.HeaderMargin;
    FooterHeight:= Config.FooterMargin;
    SetHeaderText(Config.HeaderLeft, Config.HeaderCenter, Config.HeaderRight);
    SetFooterText(Config.FooterLeft, Config.FooterCenter, Config.FooterRight);
  end;
end;

{------------------------------------------------------------------------------}

procedure TFrmPreview.UpdateUI;
begin
  // Page
  ActFirstPage.Enabled:= RichEditPrintPreview.CurrentPage > 1;
  ActPreviousPage.Enabled:= ActFirstPage.Enabled;
  ActNextPage.Enabled:=
    RichEditPrintPreview.CurrentPage < RichEditPrintPreview.NumberOfPages;
  ActLastPage.Enabled:= ActNextPage.Enabled;
  SBarApercu.SimplePanel:= false;
  SBarApercu.Panels[0].Text:= 'Page ' + IntToStr(RichEditPrintPreview.CurrentPage)
    + ' of ' + IntToStr(RichEditPrintPreview.NumberOfPages);
end;

{------------------------------------------------------------------------------}

procedure TFrmPreview.PreviewScaleChange(Sender: TObject; Scale: single);
begin
  SBarApercu.Panels[1].Text:= 'Scale ' + FloatToStrF(Scale,ffFixed, 10, 3);
  ActZoomMinus.Enabled:= Scale > RichEditPrintPreview.MinScale;
  ActZoomPlus.Enabled:= Scale < RichEditPrintPreview.MaxScale;
end;

{------------------------------------------------------------------------------}

procedure TFrmPreview.Printing(Sender: TObject; Page: integer);
begin
  SBarApercu.Panels[2].Text:= 'Printing page ' + IntToStr(Page);
end;

{------------------------------------------------------------------------------}
{ Public                                                                       }
{------------------------------------------------------------------------------}

end.
