unit WTLng;

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
//                        Part of WindowsTree                              //
//                       Listeur d'arborescences                           //
//  2001 - 2011  Alain JAFFRE               http://jack.r.free.fr          //
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
//                          Update history                                 //
//                                                                         //
//                                                                         //
//                                                                         //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

{***************************************************************************}
{ Ce logiciel est un logiciel libre. Vous pouvez le diffuser et/ou le       }
{ modifier suivant les termes de la GNU General Public License telle que    }
{ publie par la Free Software Foundation, soit la version 2 de cette        }
{ license, soit ( votre convenance) une version ultrieure.                }
{                                                                           }
{ Ce programme est diffus dans l'espoir qu'il sera utile, mais SANS AUCUNE }
{ GARANTIE, sans mme une garantie implicite de COMMERCIALISABILITE ou      }
{ d'ADEQUATION A UN USAGE PARTICULIER. Voyez la GNU General Public License  }
{ pour plus de dtails.                                                     }
{                                                                           }
{ Vous devriez avoir reu une copie de la GNU General Public License avec   }
{ ce programme, veuillez consulter <http://www.gnu.org/licenses/>           }
{***************************************************************************}

{***************************************************************************}
{ This program is free software. You can redistribute it and/or modify it   }
{ under the terms of the GNU Public License as published by the             }
{ Free Software Foundation, either version 2 of the license, or             }
{ (at your option) any later version.                                       }
{                                                                           }
{ This program is distributed in the hope it will be useful, but WITHOUT    }
{ ANY WARRANTY, without even the implied warranty of MERCHANTABILITY or     }
{ FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for  }
{ more details.                                                             }
{                                                                           }
{ You should have received a copy of the GNU General Public License along   }
{ with this program, if not, see <http://www.gnu.org/licenses/>.            }
{***************************************************************************}

interface

const
  RefLng = 'english'; // Default language
  LngExt = '.lng';    // File extension used with language files
  HelpExt = '.hlp';   // File extension used with help files

  MaxMsg = 200;       // Maximum number of stored messages

var
  Msg: array[0..MaxMsg] of string;

  function LowerCaseText(AText: string): string;
  function FirstUpperText(AText: string): string;
  function ClearShortcutText(AText: string): string;

  procedure CreateLanguageFile;
  function ExistLanguage(ALanguage: string): boolean;
  procedure LoadLanguage(ALanguage: string);
  function GetMsg(Num: longint): string;

implementation

uses
  Forms, SysUtils, WTMain, WTConfig;

{*****************************************************************************}
{ Language file utilities                                                     }
{*****************************************************************************}

function LowerCaseText(AText: string): string;
// Change all to lower case
begin
  result:= AnsiLowerCase(AText);
end;

{------------------------------------------------------------------------------}

function FirstUpperText(AText: string): string;
// Put first character in upper case, other lower case
var
  FirstChar: string;
begin
  AText:= LowerCaseText(AText);
  FirstChar:= AText[1];
  FirstChar:= AnsiUpperCase(FirstChar);
  system.Delete(AText,1,1);
  result:= FirstChar + AText;
end;

{------------------------------------------------------------------------------}

function ClearShortcutText(AText: string): string;
// Remove '&' corresponding to shortcut identification and change to lower case
var
  APos: integer;
begin
  AText:= AnsiLowerCase(AText);
  APos:= pos('&',AText);
  if APos<>0 then System.delete(AText,APos,1);
  result:= AText;
end;

{*****************************************************************************}
{ Messages management                                                         }
{*****************************************************************************}

procedure ClearMsg;
// Clear all messages
var
  N: integer;
begin
  for N:= 0 to MaxMsg do Msg[N]:= '';
end;

{------------------------------------------------------------------------------}

procedure StoreMsg(ANumber: longint;AText: string);
// Store a new message in the list
begin
  Msg[ANumber]:= AText;
end;

{------------------------------------------------------------------------------}

function GetMsg(Num: longint): string;
begin
  result:= Msg[Num];
end;

{*****************************************************************************}
{ Language file creation                                                      }
{*****************************************************************************}

procedure CreateLanguageFile;
// Create the basic language file
var
  LngFile: textfile;
  LngFilename: TFilename;

  procedure CreateHeader;
  begin
    writeln(LngFile,'{----------------------------------------------------------------------------}');
    writeln(LngFile,'{ WindowsTree language file                                                  }');
    writeln(LngFile,'{ Tested version: 1.6.0                                                      }');
    writeln(LngFile,'{ Language: English                                                          }');
    writeln(LngFile,'{                                                                            }');
    writeln(LngFile,'{ For other language, copy that file and rename it with the new language name}');
    writeln(LngFile,'{ but keep the lng extension                                                 }');
    writeln(LngFile,'{ Use only pure ASCII character for the file name                            }');
    writeln(LngFile,'{ Example: for french, the file will be francais.lng                         }');
    writeln(LngFile,'{                                                                            }');
    writeln(LngFile,'{ Lines starting by { are comments.                                          }');
    writeln(LngFile,'{ Do not modify before #.                                                    }');
    writeln(LngFile,'{ Tranlate all the text after #.                                             }');
    writeln(LngFile,'{ The & caracter is put just before the short key which will be used with Alt}');
    writeln(LngFile,'{----------------------------------------------------------------------------}');
  end;

  procedure CreateMainMenu;
  begin
    writeln(LngFile,'{----------------------------------------------------------------------------}');
    writeln(LngFile,'{ Main menu                                                                  }');
    writeln(LngFile,'{----------------------------------------------------------------------------}');
    writeln(LngFile,'0001#&File');
    writeln(LngFile,'0002#&Options');
    writeln(LngFile,'0003#Help');
  end;

  procedure CreateActions;
  begin
    writeln(LngFile,'{----------------------------------------------------------------------------}');
    writeln(LngFile,'{ Actions                                                                    }');
    writeln(LngFile,'{----------------------------------------------------------------------------}');
    writeln(LngFile,'0011#Bold');
    writeln(LngFile,'0012#Change to bold while editing tree');
    writeln(LngFile,'0013#Italic');
    writeln(LngFile,'0014#Change to italic while editing tree');
    writeln(LngFile,'0015#Underline');
    writeln(LngFile,'0016#Change to underline while editing tree');
    writeln(LngFile,'{--------------------------------------}');
    writeln(LngFile,'0021#Select a folder ...');
    writeln(LngFile,'0022#Select root folder to scan');
    writeln(LngFile,'0023#Print pre&view ...');
    writeln(LngFile,'0024#Tree print preview');
    writeln(LngFile,'0025#&Print ...');
    writeln(LngFile,'0026#Print tree');
    writeln(LngFile,'0027#Refresh');
    writeln(LngFile,'0028#Rescan with current setup');
    writeln(LngFile,'0029#Stop');
    writeln(LngFile,'0030#Stop folder scan');
    writeln(LngFile,'0031#Save as &RTF ...');
    writeln(LngFile,'0032#Save tree in RTF (rich text)');
    writeln(LngFile,'0033#Save as &TXT ...');
    writeln(LngFile,'0034#Save tree in text format');
    writeln(LngFile,'0035#Save as Utf8 text ...');
    writeln(LngFile,'0036#Save tree in Utf8 text format');
    writeln(LngFile,'0037#&Quit');
    writeln(LngFile,'0038#Exit application');
    writeln(LngFile,'{--------------------------------------}');
    writeln(LngFile,'0041#Select font');
    writeln(LngFile,'0042#Select used font');
    writeln(LngFile,'{--------------------------------------}');
    writeln(LngFile,'0051#Help ...');
    writeln(LngFile,'0052#Application help');
    writeln(LngFile,'0053#About ...');
    writeln(LngFile,'0054#Application informations');
    writeln(LngFile,'{--------------------------------------}');
    writeln(LngFile,'0061#Preferencies');
    writeln(LngFile,'0062#User preferencies configuration');
    writeln(LngFile,'0063#Language');
    writeln(LngFile,'0064#Change user interface language');
    writeln(LngFile,'{--------------------------------------}');
  end;

  procedure CreateUI;
  begin
    writeln(LngFile,'0071#Modify');
    writeln(LngFile,'0072#Enable to edit obtained tree');
    writeln(LngFile,'0073#Font used during tree edition');
    writeln(LngFile,'0074#Size of the font used during tree edition');
    writeln(LngFile,'0075#Colour of the font used during tree edition');
    writeln(LngFile,'{--------------------------------------}');
    writeln(LngFile,'0081#Sort');
    writeln(LngFile,'0082#None');
    writeln(LngFile,'0083#Alpha');
    writeln(LngFile,'0084#Size');
    writeln(LngFile,'0085#Date');
    writeln(LngFile,'{--------------------------------------}');
    writeln(LngFile,'0091#Display');
    writeln(LngFile,'0092#Empty folder');
    writeln(LngFile,'0093#Files');
    writeln(LngFile,'0094#Sizes');
    writeln(LngFile,'0095#Time / date');
    writeln(LngFile,'0096#Checksum');
    writeln(LngFile,'{--------------------------------------}');
    writeln(LngFile,'0101#Filter to use');
    writeln(LngFile,'0102#Mask');
    writeln(LngFile,'0103#Separate different mask by a semicolon');
    writeln(LngFile,'0104#Size');
    writeln(LngFile,'0105#Kb');
    writeln(LngFile,'0106#Max depth');
    writeln(LngFile,'{--------------------------------------}');
  end;

  procedure CreateMessages;
  begin
    writeln(LngFile,'1001#Selected folder :');
    writeln(LngFile,'1002#Li:');
    writeln(LngFile,'1003#Col:');
    writeln(LngFile,'1004#Read only');
    writeln(LngFile,'1005#Insert');
    writeln(LngFile,'1006#Overwrite');
    writeln(LngFile,'1007#Modified');
    writeln(LngFile,'{--------------------------------------}');
    writeln(LngFile,'1021#Tree starting from :');
    writeln(LngFile,'1022#Build on');
    writeln(LngFile,'1023#at');
    writeln(LngFile,'1024#Serial number');
    writeln(LngFile,'{--------------------------------------}');
    writeln(LngFile,'1031#RTF files');
    writeln(LngFile,'1032#All files');
    writeln(LngFile,'1033#TXT files');
    writeln(LngFile,'1034#File exist. Replace ?');
    writeln(LngFile,'{--------------------------------------}');
    writeln(LngFile,'1041#Select tree root folder');
    writeln(LngFile,'1042#Root folder input');
    writeln(LngFile,'{--------------------------------------}');
    writeln(LngFile,'1051#Error');
    writeln(LngFile,'1052#Removable disk');
    writeln(LngFile,'1053#Hard disk');
    writeln(LngFile,'1054#Network drive');
    writeln(LngFile,'1055#CD-ROM');
    writeln(LngFile,'1056#Memory disk');
    writeln(LngFile,'1057#Unknown disk');
    writeln(LngFile,'{--------------------------------------}');
  end;

  procedure CreateConfig;
  begin
    writeln(LngFile,'1101#Configuration');
    writeln(LngFile,'1102#&Ok');
    writeln(LngFile,'1103#&Cancel');
    writeln(LngFile,'1111#General');
    writeln(LngFile,'1112#Allow to print a page range');
    writeln(LngFile,'1113#Highlight (slower)');
    writeln(LngFile,'1114#File numbering in folder');
    writeln(LngFile,'1115#Space after folder between tree lines');
    writeln(LngFile,'1116#Space after file between tree lines');
    writeln(LngFile,'1117#Save last use');
    writeln(LngFile,'1121#Highlighting');
    writeln(LngFile,'1122#Tree');
    writeln(LngFile,'1123#Folder');
    writeln(LngFile,'1124#File');
    writeln(LngFile,'1125#Size');
    writeln(LngFile,'1126#Date / time');
    writeln(LngFile,'1131#Margings (mm)');
    writeln(LngFile,'1132#Page header');
    writeln(LngFile,'1133#Page footer');
    writeln(LngFile,'1134#Top');
    writeln(LngFile,'1135#Left');
    writeln(LngFile,'1136#Right');
    writeln(LngFile,'1137#Bottom');
    writeln(LngFile,'1141#Page header / footer');
    writeln(LngFile,'1142#Page header:');
    writeln(LngFile,'1143#Left');
    writeln(LngFile,'1144#Center');
    writeln(LngFile,'1145#Right');
    writeln(LngFile,'1146#Page footer:');
    writeln(LngFile,'1147#Left');
    writeln(LngFile,'1148#Center');
    writeln(LngFile,'1149#Right');
    writeln(LngFile,'{--------------------------------------}');
    writeln(LngFile,'1151#Print preview');
    writeln(LngFile,'1152#Go to first page');
    writeln(LngFile,'1153#Go to previous page');
    writeln(LngFile,'1154#Go to next page');
    writeln(LngFile,'1155#Go to last page');
    writeln(LngFile,'1156#Reduce zoom');
    writeln(LngFile,'1157#Increase zoom');
    writeln(LngFile,'1158#Display full page');
    writeln(LngFile,'1159#Display full width');
    writeln(LngFile,'1160#Display margins');
    writeln(LngFile,'1161#Configure margins, page header and footer');
    writeln(LngFile,'1162#Print');
    writeln(LngFile,'1163#Full page');
    writeln(LngFile,'1164#Page width');
    writeln(LngFile,'{--------------------------------------}');
    writeln(LngFile,'1171#Miscellaneous');
    writeln(LngFile,'1172#Hash algorithm');
    writeln(LngFile,'1173#Unknown folder');
    writeln(LngFile,'{--------------------------------------}');
  end;

  procedure CreateHelpInfo;
  begin
    writeln(LngFile,'1181#If you check modify checkbox, below functions are available');
    writeln(LngFile,'1182#in the tree:');
    writeln(LngFile,'1183#tree vertical character addition');
    writeln(LngFile,'1184#tree horizontal character addition');
    writeln(LngFile,'1185#tree middle character addition');
    writeln(LngFile,'1186#tree ending character addition');
    writeln(LngFile,'1187#add a new line below the cursor');
    writeln(LngFile,'1188#In the print preview dialog, following codes can be used');
    writeln(LngFile,'1189#in page header and footer:');
    writeln(LngFile,'1190#root tree fullname');
    writeln(LngFile,'1191#printing day');
    writeln(LngFile,'1192#printing month');
    writeln(LngFile,'1193#printing year (4 digits)');
    writeln(LngFile,'1194#printing hours');
    writeln(LngFile,'1195#printing minutes');
    writeln(LngFile,'1196#printing secondes');
    writeln(LngFile,'1197#Current printed page number');
    writeln(LngFile,'1198#number of page to print');
    writeln(LngFile,'{--------------------------------------}');
  end;

begin
  LngFilename:= AppliDir + RefLng + LngExt;
  AssignFile(LngFile,LngFilename);
  rewrite(LngFile);

  CreateHeader;
  CreateMainMenu;
  CreateActions;
  CreateUI;
  CreateMessages;
  CreateConfig;
  CreateHelpInfo;

  closefile(LngFile);
end;

{*****************************************************************************}
{ Language file management                                                    }
{*****************************************************************************}

function ExistLanguage(ALanguage: string): boolean;
var
  LngFilename: TFilename;
begin
  LngFilename:= AppliDir + ALanguage + LngExt;
  result:= FileExists(LngFilename);
end;

{------------------------------------------------------------------------------}

procedure ParseLine(ALine: string; var ANumber: longint; var AText: string);
// Divide a line Number#Text into 2 different entities ANumber and AText
var
  N: integer;
begin
  N:= pos('#',ALine);
  if N <> 0 then
  begin
    ANumber:= StrToInt(copy(ALine,1,N-1));
    delete(ALine,1,N);
    AText:= ALine;
  end
  else
  begin
    ANumber:= 0;
    AText:= '';
  end;
end;

{------------------------------------------------------------------------------}

procedure ProcessLine(ALine: string);
// Process a line of a language file
var
  ANumber: longint;
  AText: string;
begin
  ParseLine(ALine,ANumber,AText);
  case ANumber of
    // Main menu
    0001: FrmMain.MnuFile.Caption:= AText;
    0002: FrmMain.MnuOption.Caption:= AText;
    0003: FrmMain.MnuHelp.Caption:= AText;
    // Actions
    0011: FrmMain.ActCommentBold.Caption:= AText;
    0012: FrmMain.ActCommentBold.Hint:= AText;
    0013: FrmMain.ActCommentItalic.Caption:= AText;
    0014: FrmMain.ActCommentItalic.Hint:= AText;
    0015: FrmMain.ActCommentUnderline.Caption:= AText;
    0016: FrmMain.ActCommentUnderline.Hint:= AText;

    0021: FrmMain.ActSelectDir.Caption:= AText;
    0022: FrmMain.ActSelectDir.Hint:= AText;
    0023: FrmMain.ActPrintPreview.Caption:= AText;
    0024: FrmMain.ActPrintPreview.Hint:= AText;
    0025: FrmMain.ActPrint.Caption:= AText;
    0026: FrmMain.ActPrint.Hint:= AText;
    0027: FrmMain.ActRefresh.Caption:= AText;
    0028: FrmMain.ActRefresh.Hint:= AText;
    0029: FrmMain.ActStop.Caption:= AText;
    0030: FrmMain.ActStop.Hint:= AText;
    0031: FrmMain.ActSaveRtf.Caption:= AText;
    0032: FrmMain.ActSaveRtf.Hint:= AText;
    0033: FrmMain.ActSaveTxt.Caption:= AText;
    0034: FrmMain.ActSaveTxt.Hint:= AText;
    0035: FrmMain.ActSaveUtf8Txt.Caption:= AText;
    0036: FrmMain.ActSaveUtf8Txt.Hint:= AText;
    0037: FrmMain.ActQuit.Caption:= AText;
    0038: FrmMain.ActQuit.Hint:= AText;
    0039: FrmMain.ActInputDir.Caption:= AText;
    0040: FrmMain.ActInputDir.Hint:= AText;

    0041: FrmMain.ActSelectFont.Caption:= AText;
    0042: FrmMain.ActSelectFont.Hint:= AText;

    0051: FrmMain.ActHelp.Caption:= AText;
    0052: FrmMain.ActHelp.Hint:= AText;
    0053: FrmMain.ActAbout.Caption:= AText;
    0054: FrmMain.ActAbout.Hint:= AText;

    0061: FrmMain.ActPreference.Caption:= AText;
    0062: FrmMain.ActPreference.Hint:= AText;
    0063: FrmMain.ActLanguage.Caption:= AText;
    0064: FrmMain.ActLanguage.Hint:= AText;
    // UI
    0071: FrmMain.CbxComment.Caption:= AText;
    0072: FrmMain.CbxComment.Hint:= AText;
    0073: FrmMain.CbxCommentFont.Hint:= AText;
    0074: FrmMain.CbxCommentSize.Hint:= AText;
    0075: FrmMain.ColorBoxComment.Hint:= AText;

    0081: FrmMain.PnlSortTitle.Caption:= AText;
    0082: FrmMain.RbtnNone.Caption:= AText;
    0083: FrmMain.RbtnAlpha.Caption:= AText;
    0084: FrmMain.RbtnSize.Caption:= AText;
    0085: FrmMain.RbtnDate.Caption:= AText;

    0091: FrmMain.PnlDisplayTitle.Caption:= AText;
    0092: FrmMain.CbxEmptyFolder.Caption:= AText;
    0093: FrmMain.CbxFile.Caption:= AText;
    0094: FrmMain.CbxSize.Caption:= AText;
    0095: FrmMain.CbxDate.Caption:= AText;
    0096: FrmMain.CbxHash.Caption:= AText;

    0101: FrmMain.PnlFilterTitle.Caption:= AText;
    0102: FrmMain.CbxMask.Caption:= AText;
    0103: FrmMain.EdtMask.Hint:= AText;
    0104: FrmMain.CbxSizeRange.Caption:= AText;
    0105: begin
            FrmMain.LblMinSize.Caption:= AText;
            FrmMain.LblMaxSize.Caption:= AText;
          end;
    0106: FrmMain.LblMaxDepth.Caption:= AText;
  else
    if (ANumber > 1000) and (ANumber <(1000 + MaxMsg)) then
     StoreMsg(ANumber mod 1000,AText);
  end;
end;

{------------------------------------------------------------------------------}

procedure LoadLanguage(ALanguage: string);
// Load the corresponding language for GUI and help
var
  ALine: string;
  LngFile: textfile;
  LngFilename: TFilename;
  HelpFilename: TFilename;
begin
  // Language file
  ALanguage:= LowerCaseText(ALanguage);
  if not ExistLanguage(ALanguage) then ALanguage:= RefLng;
  LngFilename:= AppliDir + ALanguage + LngExt;
  // Load language data
  AssignFile(LngFile,LngFilename);
  reset(LngFile);
  while not Eof(LngFile) do
  begin
    readln(LngFile,ALine);
    ALine:= trim(ALine);
    if ((ALine<>'') and (ALine[1]<>'{')) then  ProcessLine(ALine);
  end;
  closefile(LngFile);

  // Help file
  HelpFilename:= AppliDir + ALanguage + HelpExt;
  if FileExists(HelpFilename) then
  begin
    Application.HelpFile:= HelpFilename;
  end
  else
  begin
    Application.HelpFile:= '';
  end;

  // Update tool bar menu
  FrmMain.TbrMenu.Menu:= nil;
  FrmMain.TbrMenu.Menu:= FrmMain.MainMenu;
end;

end.
