unit WTConfig;

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
//                        Part of WindowsTree                              //
//                       Listeur d'arborescences                           //
//  2001 - 2011  Alain JAFFRE               http://jack.r.free.fr          //
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
//                          Update history                                 //
//                                                                         //
//                                                                         //
//                                                                         //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

{***************************************************************************}
{ Ce logiciel est un logiciel libre. Vous pouvez le diffuser et/ou le       }
{ modifier suivant les termes de la GNU General Public License telle que    }
{ publie par la Free Software Foundation, soit la version 2 de cette        }
{ license, soit ( votre convenance) une version ultrieure.                }
{                                                                           }
{ Ce programme est diffus dans l'espoir qu'il sera utile, mais SANS AUCUNE }
{ GARANTIE, sans mme une garantie implicite de COMMERCIALISABILITE ou      }
{ d'ADEQUATION A UN USAGE PARTICULIER. Voyez la GNU General Public License  }
{ pour plus de dtails.                                                     }
{                                                                           }
{ Vous devriez avoir reu une copie de la GNU General Public License avec   }
{ ce programme, veuillez consulter <http://www.gnu.org/licenses/>           }
{***************************************************************************}

{***************************************************************************}
{ This program is free software. You can redistribute it and/or modify it   }
{ under the terms of the GNU Public License as published by the             }
{ Free Software Foundation, either version 2 of the license, or             }
{ (at your option) any later version.                                       }
{                                                                           }
{ This program is distributed in the hope it will be useful, but WITHOUT    }
{ ANY WARRANTY, without even the implied warranty of MERCHANTABILITY or     }
{ FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for  }
{ more details.                                                             }
{                                                                           }
{ You should have received a copy of the GNU General Public License along   }
{ with this program, if not, see <http://www.gnu.org/licenses/>.            }
{***************************************************************************}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, Buttons, ComCtrls, ImgList, ToolWin,
  IniFiles, Spin,
  XPMenu, JvExStdCtrls, JvCombobox, JvColorCombo;

const
  ConfigFilename= 'WindowsTree.ini';

  General= 'General';
  Highlight= 'Highlight';
  LastUse= 'LastUse';
  PrintPreview= 'PrintPreview';
  Miscellaneous= 'Miscellaneous';

type
  TConfig = record
    PageRange: boolean;
    Highlighting: boolean;
    FileNumbering: boolean;
    SaveLastUse: boolean;
    SpaceLinesDir: integer;
    SpaceLinesFile: integer;

    TreeBold: boolean;
    TreeItalic: boolean;
    TreeUnderline: boolean;
    TreeColor: TColor;

    DirBold: boolean;
    DirItalic: boolean;
    DirUnderline: boolean;
    DirColor: TColor;

    FileBold: boolean;
    FileItalic: boolean;
    FileUnderline: boolean;
    FileColor: TColor;

    SizeBold: boolean;
    SizeItalic: boolean;
    SizeUnderline: boolean;
    SizeColor: TColor;

    DateBold: boolean;
    DateItalic: boolean;
    DateUnderline: boolean;
    DateColor: TColor;

    HashBold: boolean;
    HashItalic: boolean;
    HashUnderline: boolean;
    HashColor: TColor;

    HeaderMargin: single;
    FooterMargin: single;
    TopMargin: single;
    BottomMargin: single;
    LeftMargin: single;
    RightMargin: single;

    HeaderLeft: string;
    HeaderCenter: string;
    HeaderRight: string;
    FooterLeft: string;
    FooterCenter: string;
    FooterRight: string;

    HashType: integer;
  end;

  TLastUse = record
    Root: string;
    RecentDir: string;
    Sort: integer;
    DisplayEmptyFolder: boolean;
    DisplayFile: boolean;
    DisplaySize: boolean;
    DisplayDate: boolean;
    DisplayHash: boolean;
    DisplayMaxValue: string;
    MaxDepthValue: string;
    Mask: boolean;
    MaskValue: string;
    SizeRange: boolean;
    MinSizeValue: string;
    MaxSizeValue: string;
    Theme: string;
    Language: string;
  end;

  TFrmConfig = class(TForm)
    PnlBottom: TPanel;
    BtnOk: TButton;
    BtnCancel: TButton;
    PgConfig: TPageControl;
    TshHighlight: TTabSheet;
    TshGeneral: TTabSheet;
    TBarDate: TToolBar;
    TbnDateBold: TToolButton;
    TbnDateItalic: TToolButton;
    TbnDateUnderline: TToolButton;
    LblDate: TLabel;
    ImageList: TImageList;
    TBarSize: TToolBar;
    LblSize: TLabel;
    TbnSizeBold: TToolButton;
    TbnSizeItalic: TToolButton;
    TbnSizeUnderline: TToolButton;
    TBarFile: TToolBar;
    LblFile: TLabel;
    TbnFileBold: TToolButton;
    TbnFileItalic: TToolButton;
    TbnFileUnderline: TToolButton;
    TBarDir: TToolBar;
    LblDir: TLabel;
    TbnDirBold: TToolButton;
    TbnDirItalic: TToolButton;
    TbnDirUnderline: TToolButton;
    TBarTree: TToolBar;
    LblTree: TLabel;
    TbnTreeBold: TToolButton;
    TbnTreeItalic: TToolButton;
    TbnTreeUnderline: TToolButton;
    ChbPageRange: TCheckBox;
    ChbHighlighting: TCheckBox;
    ChbFileNumbering: TCheckBox;
    ChbSaveLastUse: TCheckBox;
    SEdtSpaceLinesDir: TSpinEdit;
    LblSpaceLinesDir: TLabel;
    SEdtSpaceLinesFile: TSpinEdit;
    LblSpaceLinesFile: TLabel;
    TshMargins: TTabSheet;
    TshHeaderFooter: TTabSheet;
    EdtHeaderHeight: TEdit;
    LblHeaderMargin: TLabel;
    EdtTopMargin: TEdit;
    LblMarginTop: TLabel;
    LblRightMargin: TLabel;
    EdtRightMargin: TEdit;
    LblLeftMargin: TLabel;
    EdtLeftMargin: TEdit;
    LblBottomMargin: TLabel;
    EdtBottomMargin: TEdit;
    EdtFooterHeight: TEdit;
    LblFooterMargin: TLabel;
    LblHeaderLeft: TLabel;
    EdtHeaderLeft: TEdit;
    EdtHeaderCenter: TEdit;
    LblHeaderCenter: TLabel;
    LblHeaderRight: TLabel;
    EdtHeaderRight: TEdit;
    LblFooterLeft: TLabel;
    EdtFooterLeft: TEdit;
    LblFooterCenter: TLabel;
    EdtFooterCenter: TEdit;
    LblFooterRight: TLabel;
    EdtFooterRight: TEdit;
    LblHeaderTitle: TLabel;
    LblFooterTitle: TLabel;
    LblSpacer1: TLabel;
    LblSpacer2: TLabel;
    LblSpacer3: TLabel;
    LblSpacer4: TLabel;
    LblSpacer5: TLabel;
    TBarHash: TToolBar;
    LblHash: TLabel;
    TbnHashBold: TToolButton;
    TbnHashItalic: TToolButton;
    TbnHashUnderline: TToolButton;
    LblSpace6: TLabel;
    TshMiscellaneous: TTabSheet;
    RgpHash: TRadioGroup;
    CbxDate: TJvColorComboBox;
    CbxSize: TJvColorComboBox;
    CbxFile: TJvColorComboBox;
    CbxDir: TJvColorComboBox;
    CbxTree: TJvColorComboBox;
    CbxHash: TJvColorComboBox;
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure ChbHighlightingClick(Sender: TObject);
    procedure BtnOkClick(Sender: TObject);
  private
    { Dclarations prives }
    XPMenu: TXPMenu;
    FSelectedTab: byte;
    procedure SetSelectedTab(ATab: byte);
    procedure ApplyLanguage;
  public
    { Dclarations publiques }
    property SelectedTab: byte read FSelectedTab write SetSelectedTab;
  end;

  function LoadConfig(AFilename: TFilename): TConfig;
  procedure SaveConfig(AConfig: TConfig;AFilename: TFilename);

  function LoadLastUse(AFilename: TFilename): TLastUse;
  procedure SaveLastUse(ALastUse: TLastUse;AFilename: TFilename);

var
  FrmConfig: TFrmConfig;

  AppliDir: string;
  Config: TConfig;
  LastUseCfg: TLastUse;

implementation

{$R *.dfm}

uses
  WTLng;

{*****************************************************************************}
{ Configuration management                                                    }
{*****************************************************************************}

procedure ClearConfig(var AConfig: TConfig);
begin
  with AConfig do
  begin
    PageRange:= false;
    HighLighting:= true;
    FileNumbering:= false;
    SpaceLinesDir:= 0;
    SpaceLinesFile:= 0;
    SaveLastUse:= true;

    TreeBold:= false;
    TreeItalic:= false;
    TreeUnderline:= false;
    TreeColor:= clBlack;

    DirBold:= false;
    DirItalic:= false;
    DirUnderline:= false;
    DirColor:= clBlack;

    FileBold:= false;
    FileItalic:= false;
    FileUnderline:= false;
    FileColor:= clBlack;

    SizeBold:= false;
    SizeItalic:= false;
    SizeUnderline:= false;
    SizeColor:= clBlack;

    DateBold:= false;
    DateItalic:= false;
    DateUnderline:= false;
    DateColor:= clBlack;

    HashBold:= false;
    HashItalic:= false;
    HashUnderline:= false;
    HashColor:= clBlack;

    HeaderMargin:= 10.0;
    FooterMargin:= 10.0;
    TopMargin:= 25.0;
    BottomMargin:= 25.0;
    LeftMargin:= 30.0;
    RightMargin:= 30.0;

    HeaderLeft:= '';
    HeaderCenter:= '[TITLE]';
    HeaderRight:= '';
    FooterLeft:= 'Imprim le: [D]/[M]/[Y]';
    FooterCenter:= ' [h]:[n]:[s]';
    FooterRight:= 'Page [PAGE] / [PAGES]';

    HashType:= 0;
  end;
end;

{------------------------------------------------------------------------------}

function LoadConfig(AFilename: TFilename): TConfig;
var
  ConfigFile: TIniFile;       // configuration file
begin
  if FileExists(AFilename) then
  with result do
  begin
    Screen.Cursor := crHourGlass;
    // Open configuration file
    ConfigFile:= TIniFile.Create(AFilename);
    // General
    PageRange:= ConfigFile.ReadBool(General,'PageRange',false);
    Highlighting:= ConfigFile.ReadBool(General,'Highlighting',true);
    FileNumbering:= ConfigFile.ReadBool(General,'FileNumbering',false);
    SpaceLinesDir:= ConfigFile.ReadInteger(General,'SpaceLinesDir',0);
    SpaceLinesFile:= ConfigFile.ReadInteger(General,'SpaceLinesFile',0);
    SaveLastUse:= ConfigFile.ReadBool(General,'SaveLastUse',true);
    // Tree
    TreeBold:= ConfigFile.ReadBool(Highlight,'TreeBold',false);
    TreeItalic:= ConfigFile.ReadBool(Highlight,'TreeItalic',false);
    TreeUnderline:= ConfigFile.ReadBool(Highlight,'TreeUnderline',false);
    TreeColor:= StringToColor(ConfigFile.ReadString(Highlight,'TreeColor','clBlack'));
    // Directory
    DirBold:= ConfigFile.ReadBool(Highlight,'DirBold',false);
    DirItalic:= ConfigFile.ReadBool(Highlight,'DirItalic',false);
    DirUnderline:= ConfigFile.ReadBool(Highlight,'DirUnderline',false);
    DirColor:= StringToColor(ConfigFile.ReadString(Highlight,'DirColor','clBlack'));
    // File
    FileBold:= ConfigFile.ReadBool(Highlight,'FileBold',false);
    FileItalic:= ConfigFile.ReadBool(Highlight,'FileItalic',false);
    FileUnderline:= ConfigFile.ReadBool(Highlight,'FileUnderline',false);
    FileColor:= StringToColor(ConfigFile.ReadString(Highlight,'FileColor','clBlack'));
    // Size
    SizeBold:= ConfigFile.ReadBool(Highlight,'SizeBold',false);
    SizeItalic:= ConfigFile.ReadBool(Highlight,'SizeItalic',false);
    SizeUnderline:= ConfigFile.ReadBool(Highlight,'SizeUnderline',false);
    SizeColor:= StringToColor(ConfigFile.ReadString(Highlight,'SizeColor','clBlack'));
    // Date
    DateBold:= ConfigFile.ReadBool(Highlight,'DateBold',false);
    DateItalic:= ConfigFile.ReadBool(Highlight,'DateItalic',false);
    DateUnderline:= ConfigFile.ReadBool(Highlight,'DateUnderline',false);
    DateColor:= StringToColor(ConfigFile.ReadString(Highlight,'DateColor','clBlack'));
    // Hash
    HashBold:= ConfigFile.ReadBool(Highlight,'HashBold',false);
    HashItalic:= ConfigFile.ReadBool(Highlight,'HashItalic',false);
    HashUnderline:= ConfigFile.ReadBool(Highlight,'HashUnderline',false);
    HashColor:= StringToColor(ConfigFile.ReadString(Highlight,'HashColor','clBlack'));
    // Margins
    HeaderMargin:= ConfigFile.ReadFloat(PrintPreview,'HeaderMargin',10.0);
    FooterMargin:= ConfigFile.ReadFloat(PrintPreview,'FooterMargin',10.0);
    TopMargin:= ConfigFile.ReadFloat(PrintPreview,'TopMargin',25.0);
    BottomMargin:= ConfigFile.ReadFloat(PrintPreview,'BottomMargin',25.0);
    LeftMargin:= ConfigFile.ReadFloat(PrintPreview,'LeftMargin',30.0);
    RightMargin:= ConfigFile.ReadFloat(PrintPreview,'RightMargin',30.0);
    // Header/Footer
    HeaderLeft:= ConfigFile.ReadString(PrintPreview,'HeaderLeft','');
    HeaderCenter:= ConfigFile.ReadString(PrintPreview,'HeaderCenter','[TITLE]');
    HeaderRight:= ConfigFile.ReadString(PrintPreview,'HeaderRight','');
    FooterLeft:=
      ConfigFile.ReadString(PrintPreview,'FooterLeft','Imprim le: [D]/[M]/[Y]');
    FooterCenter:=
      ConfigFile.ReadString(PrintPreview,'FooterCenter',' [h]:[n]:[s]');
    FooterRight:=
      ConfigFile.ReadString(PrintPreview,'FooterRight','Page [PAGE] / [PAGES]');
    // Miscellaneous
    HashType:= ConfigFile.ReadInteger(Miscellaneous,'HashType',0);
    // Close configuration file
    ConfigFile.Free;
    Screen.Cursor := crDefault;
  end
  else ClearConfig(result);
end;

{------------------------------------------------------------------------------}

procedure SaveConfig(AConfig: TConfig;AFilename: TFilename);
var
  ConfigFile: TIniFile;       // configuration file
begin
  with AConfig do
  begin
    Screen.Cursor := crHourGlass;
    // Create, open configuration file
    ConfigFile:= TIniFile.Create(AFilename);
    // General
    ConfigFile.WriteBool(General,'PageRange',PageRange);
    ConfigFile.WriteBool(General,'Highlighting',Highlighting);
    ConfigFile.WriteBool(General,'FileNumbering',FileNumbering);
    ConfigFile.WriteInteger(General,'SpaceLinesDir',SpaceLinesDir);
    ConfigFile.WriteInteger(General,'SpaceLinesFile',SpaceLinesFile);
    ConfigFile.WriteBool(General,'SaveLastUse',SaveLastUse);
    // Tree
    ConfigFile.WriteBool(Highlight,'TreeBold',TreeBold);
    ConfigFile.WriteBool(Highlight,'TreeItalic',TreeItalic);
    ConfigFile.WriteBool(Highlight,'TreeUnderline',TreeUnderline);
    ConfigFile.WriteString(Highlight,'TreeColor',ColorToString(TreeColor));
    // Directory
    ConfigFile.WriteBool(Highlight,'DirBold',DirBold);
    ConfigFile.WriteBool(Highlight,'DirItalic',DirItalic);
    ConfigFile.WriteBool(Highlight,'DirUnderline',DirUnderline);
    ConfigFile.WriteString(Highlight,'DirColor',ColorToString(DirColor));
    //File
    ConfigFile.WriteBool(Highlight,'FileBold',FileBold);
    ConfigFile.WriteBool(Highlight,'FileItalic',FileItalic);
    ConfigFile.WriteBool(Highlight,'FileUnderline',FileUnderline);
    ConfigFile.WriteString(Highlight,'FileColor',ColorToString(FileColor));
    //Size
    ConfigFile.WriteBool(Highlight,'SizeBold',SizeBold);
    ConfigFile.WriteBool(Highlight,'SizeItalic',SizeItalic);
    ConfigFile.WriteBool(Highlight,'SizeUnderline',SizeUnderline);
    ConfigFile.WriteString(Highlight,'SizeColor',ColorToString(SizeColor));
    //Date
    ConfigFile.WriteBool(Highlight,'DateBold',DateBold);
    ConfigFile.WriteBool(Highlight,'DateItalic',DateItalic);
    ConfigFile.WriteBool(Highlight,'DateUnderline',DateUnderline);
    ConfigFile.WriteString(Highlight,'DateColor',ColorToString(DateColor));
    //Hash
    ConfigFile.WriteBool(Highlight,'HashBold',HashBold);
    ConfigFile.WriteBool(Highlight,'HashItalic',HashItalic);
    ConfigFile.WriteBool(Highlight,'HashUnderline',HashUnderline);
    ConfigFile.WriteString(Highlight,'HashColor',ColorToString(HashColor));
    // Margins
    ConfigFile.WriteFloat(PrintPreview,'HeaderMargin',HeaderMargin);
    ConfigFile.WriteFloat(PrintPreview,'FooterMargin',FooterMargin);
    ConfigFile.WriteFloat(PrintPreview,'TopMargin',TopMargin);
    ConfigFile.WriteFloat(PrintPreview,'BottomMargin',BottomMargin);
    ConfigFile.WriteFloat(PrintPreview,'LeftMargin',LeftMargin);
    ConfigFile.WriteFloat(PrintPreview,'RightMargin',RightMargin);
    // Header/Footer
    ConfigFile.WriteString(PrintPreview,'HeaderLeft',HeaderLeft);
    ConfigFile.WriteString(PrintPreview,'HeaderCenter',HeaderCenter);
    ConfigFile.WriteString(PrintPreview,'HeaderRight',HeaderRight);
    ConfigFile.WriteString(PrintPreview,'FooterLeft',FooterLeft);
    ConfigFile.WriteString(PrintPreview,'FooterCenter',FooterCenter);
    ConfigFile.WriteString(PrintPreview,'FooterRight',FooterRight);
    // Miscellaneous
    ConfigFile.WriteInteger(Miscellaneous,'HashType',HashType);
    // end
    Screen.Cursor := crDefault;
  end;
end;

{*****************************************************************************}
{ Configuration management                                                    }
{*****************************************************************************}

procedure ClearLastUse(var ALastUse: TLastUse);
begin
  with ALastUse do
  begin
    Root:= AppliDir;
    Sort:= 1;
    DisplayEmptyFolder:= false;
    DisplayFile:= false;
    DisplaySize:= false;
    DisplayDate:= false;
    DisplayHash:= false;
    MaxDepthValue:= '0';
    Mask:= false;
    MaskValue:= '*.htm;*.html;*.jpg';
    SizeRange:= false;
    MinSizeValue:= '0';
    MaxSizeValue:= '0';
    Theme:= 'Default';
  end;
end;

{------------------------------------------------------------------------------}

function LoadLastUse(AFilename: TFilename): TLastUse;
var
  LastUseFile: TIniFile;
begin
  if FileExists(AFilename) then
  with result do
  begin
    Screen.Cursor := crHourGlass;
    // Open file
    LastUseFile:= TIniFile.Create(AFilename);
    // Last use parameters
    Root:= LastUseFile.ReadString(LastUse,'Root',AppliDir);
    RecentDir:= LastUseFile.ReadString(LastUse,'RecentDir',AppliDir);
    Sort:= LastUseFile.ReadInteger(LastUse,'Sort',1);
    DisplayEmptyFolder:= LastUseFile.ReadBool(LastUse,'DisplayEmptyFolder',false);
    DisplayFile:= LastUseFile.ReadBool(LastUse,'DisplayFile',false);
    DisplaySize:= LastUseFile.ReadBool(LastUse,'DisplaySize',false);
    DisplayDate:= LastUseFile.ReadBool(LastUse,'DisplayDate',false);
    DisplayHash:= LastUseFile.ReadBool(LastUse,'DisplayHash',false);
    DisplayMaxValue:= LastUseFile.ReadString(LastUse,'DisplayMaxValue','0');
    MaxDepthValue:= LastUseFile.ReadString(LastUse,'MaxDepthValue','0');
    Mask:= LastUseFile.ReadBool(LastUse,'Mask',false);
    MaskValue:= LastUseFile.ReadString(LastUse,'MaskValue','*.htm;*.html;*.jpg');
    SizeRange:= LastUseFile.ReadBool(LastUse,'SizeRange',false);
    MinSizeValue:= LastUseFile.ReadString(LastUse,'MinSizeValue','0');
    MaxSizeValue:= LastUseFile.ReadString(LastUse,'MaxSizeValue','0');
    Theme:=LastUseFile.ReadString(LastUse,'Theme','Default');
    Language:=LastUseFile.ReadString(LastUse,'Language',RefLng);
    // Close file
    LastUseFile.Free;
    Screen.Cursor := crDefault;
  end
  else ClearLastUse(result);
end;

{------------------------------------------------------------------------------}

procedure SaveLastUse(ALastUse: TLastUse;AFilename: TFilename);
var
  LastUseFile: TIniFile;
begin
  with ALastUse do
  begin
    Screen.Cursor := crHourGlass;
    // Create, open configuration file
    LastUseFile:= TIniFile.Create(AFilename);
    // Last use parameters
    LastUseFile.WriteString(LastUse,'Root',Root);
    LastUseFile.WriteString(LastUse,'RecentDir',RecentDir);
    LastUseFile.WriteInteger(LastUse,'Sort',Sort);
    LastUseFile.WriteBool(LastUse,'DisplayEmptyFolder',DisplayEmptyFolder);
    LastUseFile.WriteBool(LastUse,'DisplayFile',DisplayFile);
    LastUseFile.WriteBool(LastUse,'DisplaySize',DisplaySize);
    LastUseFile.WriteBool(LastUse,'DisplayDate',DisplayDate);
    LastUseFile.WriteBool(LastUse,'DisplayHash',DisplayHash);
    LastUseFile.WriteString(LastUse,'DisplayMaxValue',DisplayMaxValue);
    LastUseFile.WriteString(LastUse,'MaxDepthValue',MaxDepthValue);
    LastUseFile.WriteBool(LastUse,'Mask',Mask);
    LastUseFile.WriteString(LastUse,'MaskValue',MaskValue);
    LastUseFile.WriteBool(LastUse,'SizeRange',SizeRange);
    LastUseFile.WriteString(LastUse,'MinSizeValue',MinSizeValue);
    LastUseFile.WriteString(LastUse,'MaxSizeValue',MaxSizeValue);
    LastUseFile.WriteString(LastUse,'Theme',Theme);
    LastUseFile.WriteString(LastUse,'Language',Language);
    // end
    Screen.Cursor := crDefault;
  end;
end;

{*****************************************************************************}
{ Form management                                                             }
{*****************************************************************************}

procedure TFrmConfig.FormCreate(Sender: TObject);
begin
  // XP menu style
  XPMenu := TXPMenu.Create(Self);
  with XPMenu do
  begin
    Name := 'XPMenu';
    DimLevel := 30;
    GrayLevel := 10;
    Font.Charset := ANSI_CHARSET;
    Font.Color := clMenuText;
    Font.Height := -11;
    Font.Name := 'Microsoft Sans Serif';
    Font.Style := [];
    Color := clBtnFace;
    DrawMenuBar := False;
    IconBackColor := clBtnFace;
    MenuBarColor := clBtnFace;
    SelectColor := clHighlight;
    SelectBorderColor := clHighlight;
    SelectFontColor := clMenuText;
    DisabledColor := clInactiveCaption;
    SeparatorColor := clBtnFace;
    CheckedColor := clHighlight;
    IconWidth := 24;
    DrawSelect := True;
    UseSystemColors := True;
    UseDimColor := False;
    OverrideOwnerDraw := False;
    Gradient := False;
    FlatMenu := True;
    AutoDetect := True;
    Active := True;
    Left := 56;
    Top := 120;
  end;

  ApplyLanguage;
  FSelectedTab:= 0;
end;

{------------------------------------------------------------------------------}

procedure TFrmConfig.FormShow(Sender: TObject);
begin
  // General
  ChbPageRange.Checked:= Config.PageRange;
  ChbHighlighting.Checked:= Config.Highlighting;
  ChbFileNumbering.Checked:= Config.FileNumbering;
  SEdtSpaceLinesDir.Text:= IntToStr(Config.SpaceLinesDir);
  SEdtSpaceLinesFile.Text:= IntToStr(Config.SpaceLinesFile);
  ChbSaveLastUse.Checked:= Config.SaveLastUse;
  // Tree
  TbnTreeBold.Down:= Config.TreeBold;
  TbnTreeItalic.Down:= Config.TreeItalic;
  TbnTreeUnderline.Down:= Config.TreeUnderline;
  CbxTree.ColorValue:= Config.TreeColor;
  // Directory
  TbnDirBold.Down:= Config.DirBold;
  TbnDirItalic.Down:= Config.DirItalic;
  TbnDirUnderline.Down:= Config.DirUnderline;
  CbxDir.ColorValue:= Config.DirColor;
  // File
  TbnFileBold.Down:= Config.FileBold;
  TbnFileItalic.Down:= Config.FileItalic;
  TbnFileUnderline.Down:= Config.FileUnderline;
  CbxFile.ColorValue:= Config.FileColor;
  // Size
  TbnSizeBold.Down:= Config.SizeBold;
  TbnSizeItalic.Down:= Config.SizeItalic;
  TbnSizeUnderline.Down:= Config.SizeUnderline;
  CbxSize.ColorValue:= Config.SizeColor;
  // Date
  TbnDateBold.Down:= Config.DateBold;
  TbnDateItalic.Down:= Config.DateItalic;
  TbnDateUnderline.Down:= Config.DateUnderline;
  CbxDate.ColorValue:= Config.DateColor;
  // Hash
  TbnHashBold.Down:= Config.HashBold;
  TbnHashItalic.Down:= Config.HashItalic;
  TbnHashUnderline.Down:= Config.HashUnderline;
  CbxHash.ColorValue:= Config.HashColor;
  // Margins
  EdtHeaderHeight.Text:= FloatToStrF(Config.HeaderMargin, ffFixed, 10,3);
  EdtFooterHeight.Text:= FloatToStrF(Config.FooterMargin, ffFixed, 10,3);
  EdtTopMargin.Text:= FloatToStrF(Config.TopMargin, ffFixed, 10,3);
  EdtBottomMargin.Text:= FloatToStrF(Config.BottomMargin, ffFixed, 10,3);
  EdtLeftMargin.Text:= FloatToStrF(Config.LeftMargin, ffFixed, 10,3);
  EdtRightMargin.Text:= FloatToStrF(Config.RightMargin, ffFixed, 10,3);
  // Header/Footer
  EdtHeaderLeft.Text:= Config.HeaderLeft;
  EdtHeaderCenter.Text:= Config.HeaderCenter;
  EdtHeaderRight.Text:= Config.HeaderRight;
  EdtFooterLeft.Text:= Config.FooterLeft;
  EdtFooterCenter.Text:= Config.FooterCenter;
  EdtFooterRight.Text:= Config.FooterRight;
  // Select page
  PgConfig.ActivePageIndex:= FSelectedTab;
  TshHighlight.TabVisible:= ChbHighlighting.Checked;
  // Miscellaneous
  RgpHash.ItemIndex:= Config.HashType;
end;

{------------------------------------------------------------------------------}

procedure TFrmConfig.ChbHighlightingClick(Sender: TObject);
begin
  TshHighlight.TabVisible:= ChbHighlighting.Checked;
end;

{------------------------------------------------------------------------------}

procedure TFrmConfig.BtnOkClick(Sender: TObject);
var
  CanClose: boolean;
begin
  CanClose:= true;
  if ((StrToFloat(EdtHeaderHeight.Text) = 0) or
      (StrToFloat(EdtFooterHeight.Text) = 0)) then
  begin
    CanClose:= MessageDlg(
    'La marge d''entte ou de pied de page est  0.' + #13#10 +
    'Cela empche toute impression dans l''entte ou le pied de page.' +
    #13#10 +  #13#10 + 'tes-vous sr ?',
    mtWarning, [mbYes, mbNo], 0) = mrYes
  end;
  
  if CanClose then
  begin
    // General
    Config.PageRange:= ChbPageRange.Checked;
    Config.Highlighting:= ChbHighlighting.Checked;
    Config.FileNumbering:= ChbFileNumbering.Checked;
    Config.SpaceLinesDir:= StrToInt(SEdtSpaceLinesDir.Text);
    Config.SpaceLinesFile:= StrToInt(SEdtSpaceLinesFile.Text);
    Config.SaveLastUse:= ChbSaveLastUse.Checked;
    // Tree
    Config.TreeBold:= TbnTreeBold.Down;
    Config.TreeItalic:= TbnTreeItalic.Down;
    Config.TreeUnderline:= TbnTreeUnderline.Down;
    Config.TreeColor:= CbxTree.ColorValue;
    // Directory
    Config.DirBold:= TbnDirBold.Down;
    Config.DirItalic:= TbnDirItalic.Down;
    Config.DirUnderline:= TbnDirUnderline.Down;
    Config.DirColor:= CbxDir.ColorValue;
    // File
    Config.FileBold:= TbnFileBold.Down;
    Config.FileItalic:= TbnFileItalic.Down;
    Config.FileUnderline:= TbnFileUnderline.Down;
    Config.FileColor:= CbxFile.ColorValue;
    // Size
    Config.SizeBold:= TbnSizeBold.Down;
    Config.SizeItalic:= TbnSizeItalic.Down;
    Config.SizeUnderline:= TbnSizeUnderline.Down;
    Config.SizeColor:= CbxSize.ColorValue;
    // Date
    Config.DateBold:= TbnDateBold.Down;
    Config.DateItalic:= TbnDateItalic.Down;
    Config.DateUnderline:= TbnDateUnderline.Down;
    Config.DateColor:= CbxDate.ColorValue;
    // Hash
    Config.HashBold:= TbnHashBold.Down;
    Config.HashItalic:= TbnHashItalic.Down;
    Config.HashUnderline:= TbnHashUnderline.Down;
    Config.HashColor:= CbxHash.ColorValue;
    // Margins
    Config.HeaderMargin:= StrToFloat(EdtHeaderHeight.Text);
    Config.FooterMargin:= StrToFloat(EdtFooterHeight.Text);
    Config.TopMargin:= StrToFloat(EdtTopMargin.Text);
    Config.BottomMargin:= StrToFloat(EdtBottomMargin.Text);
    Config.LeftMargin:= StrToFloat(EdtLeftMargin.Text);
    Config.RightMargin:= StrToFloat(EdtRightMargin.Text);
    // Header/Footer
    Config.HeaderLeft:= EdtHeaderLeft.Text;
    Config.HeaderCenter:= EdtHeaderCenter.Text;
    Config.HeaderRight:= EdtHeaderRight.Text;
    Config.FooterLeft:= EdtFooterLeft.Text;
    Config.FooterCenter:= EdtFooterCenter.Text;
    Config.FooterRight:= EdtFooterRight.Text;
    // Miscellaneous
    Config.HashType:= RgpHash.ItemIndex;
    // Save config
    SaveConfig(Config,AppliDir + ConfigFilename);
    Close;
  end
  else
  begin
    PgConfig.ActivePage:= TshMargins;
  end;
end;

{------------------------------------------------------------------------------}

procedure TFrmConfig.SetSelectedTab(ATab: byte);
begin
  if ATab <= PgConfig.PageCount then
     FSelectedTab:= ATab;
end;

{------------------------------------------------------------------------------}

procedure TFrmConfig.ApplyLanguage;
begin
  FrmConfig.Caption:= GetMsg(0101);
  BtnOk.Caption:= GetMsg(0102);
  BtnCancel.Caption:= GetMsg(0103);

  TshGeneral.Caption:= GetMsg(0111);
  ChbPageRange.Caption:= GetMsg(0112);
  ChbHighlighting.Caption:= GetMsg(0113);
  ChbFileNumbering.Caption:= GetMsg(0114);
  LblSpaceLinesDir.Caption:= GetMsg(0115);
  LblSpaceLinesFile.Caption:= GetMsg(0116);
  ChbSaveLastUse.Caption:= GetMsg(0117);

  TshHighlight.Caption:= GetMsg(0121);
  LblTree.Caption:= '  ' + GetMsg(0122);
  LblDir.Caption:= '  ' + GetMsg(0123);
  LblFile.Caption:= '  ' + GetMsg(0124);
  LblSize.Caption:= '  ' + GetMsg(0125);
  LblDate.Caption:= '  ' + GetMsg(0126);
  LblHash.Caption:= '  ' + GetMsg(0127);

  TshMargins.Caption:= GetMsg(0131);
  LblHeaderMargin.Caption:= GetMsg(0132);
  LblFooterMargin.Caption:= GetMsg(0133);
  LblMarginTop.Caption:= GetMsg(0134);
  LblLeftMargin.Caption:= GetMsg(0135);
  LblRightMargin.Caption:= GetMsg(0136);
  LblBottomMargin.Caption:= GetMsg(0137);

  TshHeaderFooter.Caption:= GetMsg(0141);
  LblHeaderTitle.Caption:= GetMsg(0142);
  LblHeaderLeft.Caption:= GetMsg(0143);
  LblHeaderCenter.Caption:= GetMsg(0144);
  LblHeaderRight.Caption:= GetMsg(0145);
  LblFooterTitle.Caption:= GetMsg(0146);
  LblFooterLeft.Caption:= GetMsg(0147);
  LblFooterCenter.Caption:= GetMsg(0148);
  LblFooterRight.Caption:= GetMsg(0149);

  TshMiscellaneous.Caption:= GetMsg(0171);
  RgpHash.Caption:= GetMsg(0172);
end;

end.
