program WindowsTree;

uses
  Forms,
  Windows,
  Messages,
  SysUtils,
  WTMain in 'WTMain.pas' {FrmMain},
  WTConfig in 'WTConfig.pas' {FrmConfig},
  WTScan in 'WTScan.pas',
  XPMenu in 'XPMenu.pas',
  WTPreview in 'WTPreview.pas' {FrmPreview},
  RichEditPrintPreview in 'RichEditPrintPreview.pas',
  WTLng in 'WTLng.pas',
  WTInputDir in 'WTInputDir.pas' {FrmInputDir};

{$R *.RES}

procedure SendParamToPrevInst(H: THandle);
// Pass command line arguments to previous running instance
// Build a data packet into a #0 separated string and then
// broadcast it to all windows
// Send only the first parameter
// Got from: http://www.delphidabbler.com/articles?article=13
var
  CopyData: TCopyDataStruct;
  DataSize: integer;
  Data: PChar;  // parameter
  PData: PChar; // next parameter
begin
  // Compute data size
  DataSize:= 0;
  inc(DataSize, Length(ParamStr(1)) + 1);
  inc(DataSize);
  // Allocate data storage and copy parameters inside
  Data:= StrAlloc(DataSize);
  try
    PData:= Data;
    StrPCopy(PData, ParamStr(1));
    inc(PData, length(ParamStr(1)) + 1);
    PData^ := #0;
    CopyData.lpData:= Data;
    CopyData.cbData:= DataSize;
    CopyData.dwData:= cCopyDataWatermark;
    SendMessage(H,WM_COPYDATA,0, LPARAM(@CopyData));
  finally
    StrDispose(Data);
  end;
end;

var
  Mutex: THandle;
  H: THandle;
begin
  // Run only one instance of program
  SetLastError(NO_ERROR);
  Mutex:= CreateMutex(nil, false, 'WindowsTreeMutex');
  if (Mutex = 0) or (GetLastError = ERROR_ALREADY_EXISTS) then
  begin
    if ParamCount > 0 then
    begin
      H:= FindWindow(cWindowClassName,nil);
      if H <> 0 then
      begin
       SendParamToPrevInst(H);
       SetForegroundWindow(H);
      end;
    end;
  end
  else
  begin
    Application.Initialize;
    Application.Title := 'WindowsTree';
    Application.CreateForm(TFrmMain, FrmMain);
  Application.CreateForm(TFrmInputDir, FrmInputDir);
  Application.Run;
    if (Mutex <> 0) then CloseHandle(Mutex);
  end;
end.
