unit WTMain;

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
//                             WindowsTree                                 //
//                       Listeur d'arborescences                           //
//  2001 - 2011  Alain JAFFRE               http://jack.r.free.fr          //
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
//                            Update history                               //
//                                                                         //
//  V0.0.4  Optimisation de la mise en forme du richedit                   //
//          Affichage du repertoire parcouru pendant le traitement         //
//          Ajout du tri alphabetique des fichiers                         //
//  V0.0.5  Ajout des posibilits d'impression de la slection ou d'une    //
//           plage de pages                                                //
//          Ajout de la possibilit de choix de la police                  //
//          Ajout de la possibilit de sauvegarde dans un fichier au format//
//           Rich Text File (rtf)                                          //
//  V1.0.0  Re-ecriture de la recherche des fichiers avec nouvelle forme   //
//           de stockage                                                   //
//          Ajout :                                                        //
//           Masque de selection des fichiers qui utilise les caracteres   //
//            generiques et autorise plusieurs selections                  //
//           Choix du tri des fichiers dans un repertoire alphabetique,    //
//            par taille, par date                                         //
//           Boite A Propos                                                //
//  V1.0.1  Ajout:                                                         //
//           Bouton permettant d'interrompre le traitement                 //
//  V1.0.2  Ajout:                                                         //
//           Sauvegarde en fichier txt                                     //
//          Correction:                                                    //
//           Si on ne coche pas fichiers, on n'affiche pas la taille et la //
//            date mme s'ils sont cochs                                  //
//  V1.0.3  Correction:                                                    //
//           La taille maxi du fichier rsultant est fixe  2Go. L'ajout  //
//            des lignes est fait par AddLine et plus par                  //
//            DirTreeEdit.Lines.Add qui limite  64Ko sur certaines versions  //
//            de Windows                                                   //
//  V1.0.4  Ajout:                                                         //
//           Selection d'une taille minimum de fichier                     //
//  V1.0.5  Ajout:                                                         //
//           Choix du controle de taille <= ou >=                          //
//  V1.0.6  Ajout:                                                         //
//           Police true type afin d'avoir la mme chose  l'impression et //
//             l'affichage.                                               //
//           Passage du nom de la police en paramtre de la ligne de       //
//            commande. Le nom de la police et le nom du fichier de police //
//            ttf doivent tre identiques et la police dans le mme        //
//            repertoire que l'application                                 //
//          Correction:                                                    //
//           Adaptation de la taille de la fentre en fonction de la       //
//            position de RgpSort pour s'affranchir du problme des grandes//
//            polices                                                      //
//           Mauvaise gestion du changement de police dans le richedit     //
//            (ChangeFont est inutile)                                     //
//  V1.1.0  Ajout:                                                         //
//           Choix de la graisse et de la couleur pour chaque type         //
//            d'lment de l'arborescence                                  //
//           Choix impression plage de page (pb page Serge Miguel avant    //
//            impression)                                                  //
//           Numrotation des fichiers dans le rpertoires                 //
//           Choix abscence de tri (exemple: compil mp3 lors de la         //
//            numrotation des fichiers / plages les fichiers ne sont pas  //
//            forcment enregistrs dans un ordre particulier sur le       //
//            support)                                                     //
//           Possibilit de sauvegarde des rglages lors de la derniere    //
//            utilisation                                                  //
//                                                                         //
//  V1.2.0  Ajout:                                                         //
//           Remaniement de l'interface pour la rendre plus intuitive.     //
//            (suggestion de Gabriel FERRIERAS)                            //
//           '<' et '>' autour des rpertoires pour plus de lisibilite     //
//            (ide de Gabriel FERRIERAS, nostalgique du DOS)              //
//           Separation du scanner de repertoire en un composant afin de   //
//            separer clairement l'interface et le traitement              //                                                //
//           Information sur le disque (Gabriel FERRIERAS)                 //
//           Filtre des fichiers par taille mini et maxi                   //
//           Affichage taille cummul des rpertoires                      //
//           Nouvelle interface avec barre d'outils rorganisables         //
//           Possibilit de commenter le richedit (Gabriel FERRIERAS)      //
//           Choix du nombre de ligne vide aprs rpertoire pour faciliter //
//            les commentaires                                             //
//          Correction:                                                    //
//           Le richedit est repositionn au dbut (curseur et ascenseur)  //
//  V1.2.1  Ajout:                                                         //
//           Touches de raccourcis pour les caractres spciaux de         //
//            l'arborescence et l'ajout de ligne vierge au sien de cette   //
//            arborescence                                                 //
//  V1.2.2  Modification:                                                  //
//           L'affichage de l'arborescence est devenu un composant spar  //
//            (poursuite de la sparation interface / traitement )         //
//  V1.2.3  Modification:                                                  //
//           Amlioartion de l'interface utilisateur (look des palettes)   //
//           Ajout de la fonction stop au menu fichier                     //
//  V1.3.0  Ajout:                                                         //
//           Aperu avant impression                                       //
//           Nouvelle icne au projet                                      //
//           Bulles d'aide                                                 //
//          Correction:                                                    //
//           Style des combobox font et size                               //
//  V1.3.1  Ajout:                                                         //
//           Dans l'aide, description des codes utilisables dans l'aperu  //
//            avant impression                                             //
//           Diffrenciation des nombres de lignes vierges pour les        //
//            rpertoires et fichiers (indirectement Gabriel FERRIERAS)    //
//           Message d'avertissement si les marges d'entte ou de pied de  //
//            page sont  0 (Gabriel FERRIERAS)                            //
//          Correction:                                                    //
//           Initialisation de la configuration en absence du fichier de   //
//            configuration (Gabriel FERRIERAS)                            //
//  V1.3.2  Correction:                                                    //
//           Le filtre par taille ne fonctionnait pas                      //
//  V1.4.0  Ajout:                                                         //
//           Possibilite de definir un niveau maximum de recherche. Le     //
//            repertoire de depart correspond au premier niveau (1). Si on //
//            donne 0, la recherche se fait sur toute la profondeur de     //
//            l'arborescence.                                              //
//  V1.4.1  Correction:                                                    //
//           Si on n'affichait pas les fichiers, les lignes d'espace entre //
//            repertoires n'etaient pas prises en compte                   //
//  V1.5.0  Correction:                                                    //
//           La taille des fichiers et dossiers suprieurs  2Go n'tait   //
//            pas gre correctement. Nouveau calcul de taille et          //
//            utilisation d'int64 au lieu de longint dans WTScan           //
//          Ajout:                                                         //
//           Affichage du separateur pour les milliers afin de faciliter   //
//            la lecture des tailles                                       //
//  V1.6.0  Ajout:                                                         //
//           L'interface devient multi langues                             //
//          Correction:                                                    //
//           L'arborescence est efface ds le debut du scan               //
//           Si le fichier existe lors de l'enregistrement, demande de     //
//            confirmation de l'crasement                                 //
//  V1.6.1 Correction:                                                     //
//           Initialisation manquante de ffnumber dans                     //
//            TDirTreeEdit.Refresh au sein de WTScan provoquant une        //
//            numrotation errone des fichiers du rpertoire racine en    //
//            cas de refresh                                               //
//  V1.7.0 Ajout:                                                          //
//          Drag & drop permettant de dposer un rpertoire ou un          //
//           raccourci vers un rpertoire afin de dmarrer le scan de      //
//           l'arborescence correspondante                                 //
//  V1.8.0 Ajout:                                                          //
//          Lors, du lancement de l'application, cration d'une entre dans//
//           le menu contextuel 'Envoyer vers ...', ce qui permet, via un  //
//           clique droit sur un dossier ou un fichier de lister le        //
//           rpertoire correspondant                                      //
//          Alignement au temps que faire ce peut des dates et tailles au  //
//           sein d'un mme rpertoire                                     //
//          Pour les rpertoires, le scanner compte le nombre de fichiers  //
//           qu'il contient, y compris dans ces sous-rpertoires           //
//          Choix d'afficher ou non les rpertoires vides                  //
//         Correction:                                                     //
//          L'affichage de la tailles de fichiers ou rpertoires ne se     //
//           faisait pas si la taille tait nulle                          //
//          La taille affiche pour les rpertoires tient compte des       //
//           diffrents filtres utiliss.                                  //
//  V1.9.0 Ajout:                                                          //
//           Calcul de la somme de contrle des fichiers (md5, sha1,       //
//             sha256, sha512)                                             //
//           Sauvegarde en texte Utf8 avec des caractres unicode pour     //
//            l'arborescence                                               //
//         Correction:                                                     //
//           Bug sur le calcul de taille du rpertoire lorsqu'il y avait   //
//            une profondeur maxi                                          //
//           Le filtrage par masque ne fonctionnait pas en cas de points   //
//            multiple (ex: windowstre.1.2.3.ini n'tait pas trouv par    //
//            *.ini)                                                       //
//           Le tri par date ne fonctionnait pas sur les rpertoires.      //
//           Nota: le tri par taille ne fonctionne qu'au sein de chaque    //
//            rpertoire car on ne connait pas la taille totale du         //
//            rpertoire lorsque l'on scrute les fichiers. Il faudrait     //
//            r-crire le scanner pour avoir un arbre des rpertoire et   //
//            un arbre des fichiers que l'on trie sparment en fonction   //
//            du critre dfini (alpha, taille, date) puis que l'on        //
//            recompile                                                    //
//  V1.10.0 Ajout:                                                         //
//           Profondeur maximum d'affichage. L'arborescence complte est   //
//            scanne mais seule la profondeur dfinie est affiche        //
//          Correction:                                                    //
//           Il manquait l'enregistrement en UTF8 sur le clic droit        //
//  V1.11.0 Ajout                                                          //
//           Extension par defaut pour toute les boites d'enregistrement   //
//            elle est rajoute automatiquement s'il n'y pas d'extension ou //
//            que ce n'est pas la bonne                                    //
//          Correction:                                                    //
//           Si l'ajout de la police choue, on bascule sur Terminal       //
//  V1.12.0 Ajout                                                          //
//           Gestion des chemins de plus de 260 caracteres.                //
//  V1.13.0 Ajout                                                          //
//           Saisie manuelle du rpertoire racine afin de pouvoir fournir  //
//             un chemin au format UNC \\monserveur\c$\ProgramData\        //
//          Correction:                                                    //
//           Vrifie si le chemin est UNC avant de le convertir            //
//  V1.13.1 Correction                                                     //
//           Modification du chargement de la police pour viter un blocage//
//             dans certaines configuration (WindowsTree a demarre mais    //
//             ne s'affiche pas)                                           //
/////////////////////////////////////////////////////////////////////////////

{***************************************************************************}
{ Ce logiciel est un logiciel libre. Vous pouvez le diffuser et/ou le       }
{ modifier suivant les termes de la GNU General Public License telle que    }
{ publie par la Free Software Foundation, soit la version 2 de cette        }
{ license, soit ( votre convenance) une version ultrieure.                }
{                                                                           }
{ Ce programme est diffus dans l'espoir qu'il sera utile, mais SANS AUCUNE }
{ GARANTIE, sans mme une garantie implicite de COMMERCIALISABILITE ou      }
{ d'ADEQUATION A UN USAGE PARTICULIER. Voyez la GNU General Public License  }
{ pour plus de dtails.                                                     }
{                                                                           }
{ Vous devriez avoir reu une copie de la GNU General Public License avec   }
{ ce programme, veuillez consulter <http://www.gnu.org/licenses/>           }
{***************************************************************************}

{***************************************************************************}
{ This program is free software. You can redistribute it and/or modify it   }
{ under the terms of the GNU Public License as published by the             }
{ Free Software Foundation, either version 2 of the license, or             }
{ (at your option) any later version.                                       }
{                                                                           }
{ This program is distributed in the hope it will be useful, but WITHOUT    }
{ ANY WARRANTY, without even the implied warranty of MERCHANTABILITY or     }
{ FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for  }
{ more details.                                                             }
{                                                                           }
{ You should have received a copy of the GNU General Public License along   }
{ with this program, if not, see <http://www.gnu.org/licenses/>.            }
{***************************************************************************}

interface

uses
  Windows, Menus, Dialogs, Classes, ActnList, ImgList, Controls, ComCtrls,
  StdCtrls, ExtCtrls, ToolWin, Forms, ComObj, ActiveX, ShlObj, Graphics,
  SysUtils, Messages, Printers, Richedit, ShellApi, Registry,
  WTScan,
  XPMenu, JvExStdCtrls, JvCombobox, JvColorCombo;

type
  TFrmMain = class(TForm)
    DlgFont: TFontDialog;
    DlgPrint: TPrintDialog;
    ILAppli: TImageList;
    PnlLeft: TPanel;
    PnlRight: TPanel;
    StatusBar: TStatusBar;
{ Actions }
    ActLAppli: TActionList;
    ActSelectDir: TAction;
    ActSaveRtf: TAction;
    ActSaveTxt: TAction;
    ActPrintPreview: TAction;
    ActPrint: TAction;
    ActRefresh: TAction;
    ActStop: TAction;
    ActQuit: TAction;
    ActPreference: TAction;
    ActHelp: TAction;
    ActAbout: TAction;
    ActSelectFont: TAction;
    ActCommentBold: TAction;
    ActCommentItalic: TAction;
    ActCommentUnderline: TAction;
    ActUpdateStatusBar: TAction;
    ActScan: TAction;
{ Menu }
    TbrMenu: TToolBar;
    MainMenu: TMainMenu;
    MnuFile: TMenuItem;
    MnuOption: TMenuItem;
    MnuHelp: TMenuItem;
    MnuItemSelectDir: TMenuItem;
    MnuSpace1: TMenuItem;
    MnuItemSaveRTF: TMenuItem;
    MnuItemSaveTXT: TMenuItem;
    MnuItemPrintPreview: TMenuItem;
    MnuItemPrint: TMenuItem;
    MnuSpace2: TMenuItem;
    MnuItemRefresh: TMenuItem;
    MnuItemStop: TMenuItem;
    MnuSpace3: TMenuItem;
    MnuItemQuit: TMenuItem;
    MnuItemPreference: TMenuItem;
    MnuItemHelp: TMenuItem;
    MnuSpace21: TMenuItem;
    MnuItemAbout: TMenuItem;
{ PopupMenu }
    TreePopupMenu: TPopupMenu;
    PopMnuSaveRtf: TMenuItem;
    PopMnuSaveTxt: TMenuItem;
    PopMnuAbout: TMenuItem;
{ ToolBar }
    TbrAction: TToolBar;
    TbnSelectDir: TToolButton;
    TbnSpace2: TToolButton;
    TbnPrintPreview: TToolButton;
    TbnPrint: TToolButton;
    TbnSpace3: TToolButton;
    TbnRefresh: TToolButton;
    TbnStop: TToolButton;
    TbnSpace4: TToolButton;
    TbnSelectFont: TToolButton;
    TbnSpace5: TToolButton;
    CbxComment: TCheckBox;
    CbxCommentFont: TComboBox;
    CbxCommentSize: TComboBox;
    TbnCommentBold: TToolButton;
    TbnCommentItalic: TToolButton;
    TbnCommentUnderline: TToolButton;
{ Panel info }
    PnlSelectedDir: TPanel;
    LblSelectedDir: TLabel;
{ Tool box}
    PnlSortTitle: TPanel;
    PnlSort: TPanel;
    RbtnNone: TRadioButton;
    RbtnAlpha: TRadioButton;
    RbtnSize: TRadioButton;
    RbtnDate: TRadioButton;
    PnlDisplayTitle: TPanel;
    PnlDisplay: TPanel;
    CbxFile: TCheckBox;
    CbxSize: TCheckBox;
    CbxDate: TCheckBox;
    PnlFilterTitle: TPanel;
    PnlFilter: TPanel;
    CbxMask: TCheckBox;
    EdtMask: TEdit;
    CbxSizeRange: TCheckBox;
    LblHigherOrEqual: TLabel;
    EdtMinSize: TEdit;
    LblMinSize: TLabel;
    LblLowerOrEqual: TLabel;
    EdtMaxSize: TEdit;
    LblMaxSize: TLabel;
    PnlProgressBar: TPanel;
    ProgressBar: TProgressBar;
    LblMaxDepth: TLabel;
    EdtMaxDepth: TEdit;
    MnuItemLanguage: TMenuItem;
    ActLanguage: TAction;
    CbxEmptyFolder: TCheckBox;
    CbxHash: TCheckBox;
    ColorBoxComment: TColorBox;
    ActSaveUtf8Txt: TAction;
    EnregistrerenTXTUTF81: TMenuItem;
    LblDisplayMax: TLabel;
    EdtDisplayMax: TEdit;
    EnregistrerenTXTUTF82: TMenuItem;
    MnuItemInputDir: TMenuItem;
    ActInputDir: TAction;
    TbtnInputDir: TToolButton;
{ Form }
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure DlgFontApply(Sender: TObject; Wnd: HWND);
{ Action }
    procedure ActSaveRtfExecute(Sender: TObject);
    procedure ActSaveTxtExecute(Sender: TObject);
    procedure ActSaveUtf8TxtExecute(Sender: TObject);
    procedure ActQuitExecute(Sender: TObject);
    procedure ActPreferenceExecute(Sender: TObject);
    procedure ActHelpExecute(Sender: TObject);
    procedure ActAboutExecute(Sender: TObject);
    procedure ActSelectDirExecute(Sender: TObject);
    procedure ActInputDirExecute(Sender: TObject);
    procedure ActPrintPreviewExecute(Sender: TObject);
    procedure ActPrintExecute(Sender: TObject);
    procedure ActScanExecute(Sender: TObject);
    procedure ActRefreshExecute(Sender: TObject);
    procedure ActStopExecute(Sender: TObject);
    procedure ActSelectFontExecute(Sender: TObject);
    procedure ActCommentBoldExecute(Sender: TObject);
    procedure ActCommentItalicExecute(Sender: TObject);
    procedure ActCommentUnderlineExecute(Sender: TObject);

{ DirTreeEdit }
    procedure ActUpdateStatusBarUpdate(Sender: TObject);
    procedure CbxCommentClick(Sender: TObject);
    procedure CbxCommentFontChange(Sender: TObject);
    procedure CbxCommentSizeChange(Sender: TObject);
    procedure ColorBoxCommentChange(Sender: TObject);
    procedure CbxSizeRangeClick(Sender: TObject);
    procedure CbxMaskClick(Sender: TObject);
    procedure CbxFileClick(Sender: TObject);

  private
    { Dclarations prives }
    DirScanner: TDirScanner;
    FontName: string;
    FontFile: string;
    DirTreeEdit: TDirTreeEdit;
    XPMenu: TXPMenu;
    CmdLineDir: string;
    RecentDir: string;
    procedure WMDropFiles(var Mesg: TWMDropFiles); message WM_DROPFILES;
    procedure WMCopyData(var Msg: TWMCopyData); message WM_COPYDATA;
{ Preference }
    procedure UpdateWithLastUse;
    procedure UpdateLastUse;
{ Interface }
    procedure MnuLanguageClick(Sender: TObject);
    procedure BuildLanguageMenu;
    procedure EnableUI(Allowed: boolean);
    procedure EnableComment(Allowed: boolean);
    function StrToSize(ASizeStr: string): integer;
    function SizeToStr(ASize: integer): string;
    procedure UpdateCursorPos;
{ Scanner }
    procedure ScannerDirChange(Sender: TObject; ADir: string);
    procedure UpdateScannerDirSetup;
{ Directory tree editor }
    procedure DirTreeEditProcessing(Sender: TObject; ANumber: integer);
    procedure DirTreeEditSelectionChange(Sender: TObject);
    procedure DirTreeEditKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure DirTreeEditMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
    procedure UpdateDirTreeEditSetup;
{ Contextual menu entry }
    procedure AddRegistryContextMenu;
    procedure RemoveRegistryContextMenu;
    function GetSpecialFolder(Folder: Integer): string;
    procedure AddSendToMenu;
    procedure RemoveSendToMenu;
    procedure ScanFromExplorer(ADir: string);
  protected
    procedure CreateParams(var Params: TCreateParams); override;
  public
    { Dclarations publiques }
    procedure ShowHint(Sender: TObject);
  end;

const
  Version= '1.13.1';
  cWindowClassName= 'WindowsTree' + Version;
  cCopyDataWatermark= $AD257E6C;
var
  FrmMain: TFrmMain;

implementation

{$R *.DFM}

// Remove space before $ to use condition
{ $DEFINE TIMING}

uses
  WTAbout, WTConfig, WTLng, WTPreview, WTInputDir;

{*****************************************************************************}
{ Browse for folder dialog                                                    }
{ Part from http://delphi.about.com/od/windowsshellapi/l/aa122803a.htm        }
{ Part from filectrl (delphi)                                                                            }
{*****************************************************************************}

function BrowseDialogCallBack(Wnd: HWND; uMsg: UINT; lParam,
  lpData: LPARAM): integer stdcall;
// Call back function for SelectADirectory
// Fix dialog position and selected folder
var
  MainRect: TRect;
  BrowseRect: TRect;
  BrowsePoint : TPoint;
begin
  if uMsg = BFFM_INITIALIZED then
  begin
    // Center it in the main form
    GetWindowRect(Application.MainForm.Handle, MainRect);
    GetWindowRect(Wnd, BrowseRect);
    BrowsePoint.X := ((MainRect.Left + MainRect.Right) div 2) -
                  ((BrowseRect.Right - BrowseRect.Left) div 2);
    BrowsePoint.Y := ((MainRect.Top + MainRect.Bottom) div 2) -
                  ((BrowseRect.Bottom-BrowseRect.Top) div 2);
    SetWindowPos(Wnd, 0, BrowsePoint.X, BrowsePoint.Y, 0, 0,
      SWP_NOACTIVATE or SWP_NOSIZE or SWP_NOZORDER);
    // Select the folder
    if lpData <> 0 then
      SendMessage(Wnd, BFFM_SETSELECTION, Integer(True), lpdata);
  end;
  Result := 0;
end;

{------------------------------------------------------------------------------}

function SelectADirectory(Title: string; var Directory: string): boolean;
var
  lpItemID : PItemIDList;
  BrowseInfo : TBrowseInfo;
  DisplayName : array[0..MAX_PATH] of char;
  TempPath : array[0..MAX_PATH] of char;
begin
  FillChar(BrowseInfo, sizeof(TBrowseInfo), #0);
  with BrowseInfo do
  begin
    hwndOwner := Application.Handle;
    pszDisplayName := @DisplayName;
    lpszTitle := PChar(Title);
    ulFlags := BIF_RETURNONLYFSDIRS;
    lpfn := BrowseDialogCallBack;
    lParam := Integer(PChar(Directory));
  end;
  lpItemID := SHBrowseForFolder(BrowseInfo);
  if lpItemId <> nil then
  begin
    SHGetPathFromIDList(lpItemID, TempPath);
    Directory := TempPath;
    GlobalFreePtr(lpItemID);
    result:= true;
  end
  else
    result:= false;
end;

{------------------------------------------------------------------------------}

function GetLinkTarget(Link: string): string;
// From: http://www.delphifr.com/forum/sujet-RECUPERER-CIBLE-RACCOURCI_748438.aspx
var
  Unknown: IUnknown;
  ShellLink: IShellLink;
  PersistFile: IPersistFile;
  WFileName: WideString;
  Target: String;
  X1: Array [0..255] Of Char;
  Data: TWin32FindData;
begin
  Target:= '';
  if UpperCase(ExtractFileExt(Link)) = '.LNK' then
  begin
    // Accder aux deux interfaces de l'objet
    Unknown:= CreateComObject(CLSID_ShellLink);
    ShellLink:= Unknown as IShellLink;
    PersistFile:= Unknown as IPersistFile;
    // Chargement du raccourci
    WFileName:= Link;
    PersistFile.Load(PWChar(WFileName),STGM_READ);
    // Rcupre le path de la cible
    ShellLink.GetPath( @X1,MAX_PATH,Data,SLGP_UNCPRIORITY);
    Target:= StrPas(@X1);
  end;
  result:= Target;
end;

{*****************************************************************************}
{ Main form                                                                   }
{*****************************************************************************}

procedure TFrmMain.FormCreate(Sender: TObject);
// Create the main form of that application

var
  N: integer;
begin
  Width:= 800;
  Height:= 480;

  // XP menu style
  XPMenu := TXPMenu.Create(Self);
  with XPMenu do
  begin
    Name := 'XPMenu';
    DimLevel := 30;
    GrayLevel := 10;
    Font.Charset := ANSI_CHARSET;
    Font.Color := clMenuText;
    Font.Height := -11;
    Font.Name := 'Microsoft Sans Serif';
    Font.Style := [];
    Color := clBtnFace;
    DrawMenuBar := False;
    IconBackColor := clBtnFace;
    MenuBarColor := clBtnFace;
    SelectColor := clHighlight;
    SelectBorderColor := clHighlight;
    SelectFontColor := clMenuText;
    DisabledColor := clInactiveCaption;
    SeparatorColor := clBtnFace;
    CheckedColor := clHighlight;
    IconWidth := 24;
    DrawSelect := True;
    UseSystemColors := True;
    UseDimColor := False;
    OverrideOwnerDraw := False;
    Gradient := False;
    FlatMenu := True;
    AutoDetect := True;
    Active := True;
    Left := 56;
    Top := 120;
  end;

  AppliDir:= ExtractFilePath(Application.ExeName);

  // Initialize fonts
  CmdLineDir:= '';
  if (ParamStr(1) <> '') then
  begin
    FontName:= ParamStr(1);
    if not FileExists(AppliDir + FontName + '.ttf')  then
    begin
      CmdLineDir:= ParamStr(1);
      if FileExists(CmdLineDir) then CmdLineDir:= ExtractFilePath(CmdLineDir);
      if not DirectoryExists(CmdLineDir) then CmdLineDir := '';
      FontName:= 'WindowsTree';
    end;
  end
  else FontName:= 'WindowsTree';
  FontFile:= AppliDir + FontName + '.ttf';
  if FileExists(FontFile) then
  begin
    if AddFontResource(PChar(FontFile)) > 0 then
    begin
      SendMessage(Application.Handle,WM_FONTCHANGE,0,0);
    end
    else
    begin
      FontName:= 'Terminal';
      FontFile:= '';
    end;
  end
  else
  begin
    FontName:= 'Terminal';
    FontFile:= '';
  end;

  // Initialize directory scanner
  DirScanner:= TDirScanner.Create(self);
  DirScanner.OnDirChange:= ScannerDirChange;
  // Initialize directory tree editor
  DirTreeEdit:= TDirTreeEdit.Create(self);
  with DirTreeEdit do
  begin
    Name := 'DirTreeEdit';
    Parent := PnlLeft;
    Left := 8;
    Top := 71;
    Width := 489;
    Height := 300;
    Align := alClient;
    Font.Charset:= ANSI_CHARSET;
    Font.Color := clWindowText;
    Font.Height := -12;
    Font.Name:= FontName;
    Font.Style := [];
    Constraints.MinHeight := 350;
    Constraints.MinWidth := 510;
    ParentFont := False;
    PopupMenu := TreePopupMenu;
    ReadOnly := True;
    ScrollBars := ssBoth;
    TabOrder := 0;
    WordWrap := False;
    WantTabs := true;
    // Fixe la taille maxi du RichEdit a 2Go afin de
    // fonctionner quelque soit la version de windows
    // (RichEdit limite a 64Ko sur certaines versions)
    // Attention aussi a la facon d'ajouter les lignes
    MaxLength:= MaxInt - 2;
    Lines.Clear;
    Scanner:= DirScanner;
    OnDirTreeProcessing:= DirTreeEditProcessing;
    OnSelectionChange:= DirTreeEditSelectionChange;
    OnKeyDown:= DirTreeEditKeyDown;
    OnMouseMove:= DirTreeEditMouseMove;
  end;
  DlgFont.Font.Assign(DirTreeEdit.Font);

  // Initialize list
  CbxCommentFont.Items:= Screen.Fonts;
  CbxCommentFont.ItemIndex:=
    CbxCommentFont.Items.IndexOf(DirTreeEdit.Font.Name);
  CbxCommentFont.Text:= CbxCommentFont.Items[CbxCommentFont.Items.IndexOf(DirTreeEdit.Font.Name)];
  CbxCommentSize.ItemIndex:=
    CbxCommentSize.Items.IndexOf(IntToStr(DirTreeEdit.Font.Size));
  // Load configuration
  Config:= LoadConfig(AppliDir + ConfigFilename);

  // Create default language file if needed
  if not ExistLanguage(RefLng) then CreateLanguageFile;
  LoadLanguage(RefLng);
  // Build language menu
  BuildLanguageMenu;

  // Load last use if needed
  if Config.SaveLastUse then
  begin
    LastUseCfg:= LoadLastUse(AppliDir + ConfigFilename);
    UpdateWithLastUse;
  end;

  // Check current language
  with MnuItemLanguage do
  begin
    for N:= 1 to Count do
      Items[N-1].Checked:= ClearShortcutText(Items[N-1].Caption) = LastUseCfg.Language;
  end;

  // Adaptation to large font
  PnlRight.Width:= LblMaxSize.Left + LblMaxSize.Width + 10;
  FrmMain.Height:= PnlProgressBar.Top + PnlProgressBar.Height + 70;
  FrmMain.Width:= ColorBoxComment.Left + ColorBoxComment.Width +
    PnlRight.Width + 30;

  // Accept dropped items
  DragAcceptFiles(handle, true);

  // Add explorer context menu for folders
  //AddRegistryContextMenu;

  // Add send to menu
  AddSendToMenu;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.FormShow(Sender: TObject);
// Adjust main form size
begin
  if CmdLineDir <> '' then ScanFromExplorer(CmdLineDir);
  Application.OnHint:= ShowHint;
  Position:=poScreenCenter;
  BringToFront;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.FormDestroy(Sender: TObject);
// Destroy the main form
begin
  if Config.SaveLastUse then
  begin
    UpdateLastUse;
    SaveLastUse(LastUseCfg,AppliDir + ConfigFilename);
  end;
  if FontFile <> '' then
  begin
    RemoveFontResource(PChar(FontFile));
    SendMessage(Application.Handle,WM_FONTCHANGE,0,0);
  end;
  DirTreeEdit.Free;
  DirScanner.Free;
  //RemoveContextMenu
  RemoveSendToMenu;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
// Define application short cut
begin
  // About box
  if Key = VK_F1 then ActAboutExecute(Sender);
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.WMDropFiles(var Mesg: TWMDropFiles);
var
  ItemText: array[0..255] of Char;
  SelectedFolder: string;
begin
  // Get only first item
  DragQueryFile(Mesg.drop, 0, ItemText, SizeOf(ItemText));
  // Message process so send 0
  Mesg.result:=0;
  if UpperCase(ExtractFileExt(ItemText)) = '.LNK' then
    SelectedFolder := GetLinkTarget(ItemText)
  else
    SelectedFolder:= ItemText;
  // Get folder if it is a file
  if FileExists(SelectedFolder) then
    SelectedFolder:= ExtractFilePath(SelectedFolder);
  // Process it
  if DirectoryExists(SelectedFolder) then
  begin
    if SelectedFolder[length(SelectedFolder)]<>'\' then
      SelectedFolder:= SelectedFolder + '\';
    DirScanner.RootDir:= SelectedFolder;
    DirScanner.Stop:= false;
    DirTreeEdit.Stop:= false;
    ActRefresh.Enabled:= true;
    ActRefresh.Execute;
  end
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.WMCopyData(var Msg: TWMCopyData);
// Receive command line arguments from another instance
var
  PData: PChar;
  Param: string;
begin
  // Process only if is our message
  if Msg.CopyDataStruct.dwData = cCopyDataWatermark then
  begin
    if IsIconic(Application.Handle) then Application.Restore;
    // Process parameters
    PData:= Msg.CopyDataStruct.lpData;
    while PData^ <> #0 do
    begin
      Param := StrPas(PData);
      ScanFromExplorer(Param);
      inc(PData,length(Param) + 1);
    end;
    // Indicate it has been processed
    Msg.Result:= 1;
  end;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.DlgFontApply(Sender: TObject; Wnd: HWND);
// Manage main font selection
begin
  if Sender is TFontDialog then
  begin
    with Sender as TFontDialog do
    begin
      DirTreeEdit.Font.Assign(TFontDialog(Sender).Font);
    end;
  end;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.ActSaveRtfExecute(Sender: TObject);
// Save contents of richedit in an rtf file
var
  SaveDlg: TSaveDialog;
  Done: boolean;
begin
  SaveDlg:= TSaveDialog.Create(nil);
  SaveDlg.DefaultExt:= 'rtf';
  SaveDlg.Filter:= GetMsg(0031) +' (*.rtf)|*.rtf|' + GetMsg(0032) + ' (*.*)|*.*';
  SaveDlg.FileName:= 'WindowsTree.rtf';
  Done:= false;
  While not Done Do
  begin
    if SaveDlg.Execute then
    begin
      if FileExists(SaveDlg.Filename) then
      begin
        if MessageDlg(SaveDlg.Filename + #13#10 + GetMsg(0034),mtConfirmation, [mbYes, mbNo], 0) = mrYes then
        begin
          DirTreeEdit.Lines.SaveToFile(SaveDlg.Filename);
          Done:= true;
        end;
      end
      else
      begin
        DirTreeEdit.Lines.SaveToFile(SaveDlg.Filename);
        Done:= true;
      end;
    end
    else Done:= true;
  end;
  SaveDlg.Free;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.ActSaveTxtExecute(Sender: TObject);
// Save contents of richedit in an txt file
var
  SaveDlg: TSaveDialog;
  Done: boolean;
begin
  SaveDlg:= TSaveDialog.Create(nil);
  SaveDlg.DefaultExt:= 'txt';
  SaveDlg.Filter:= GetMsg(0033) + ' (*.txt)|*.txt|' + GetMsg(0032) + ' (*.*)|*.*';
  SaveDlg.FileName:= 'WindowsTree.txt';
  Done:= false;
  While not Done Do
  begin
    if SaveDlg.Execute then
    begin
      if FileExists(SaveDlg.Filename) then
      begin
        if MessageDlg(SaveDlg.Filename + #13#10 + GetMsg(0034),mtConfirmation, [mbYes, mbNo], 0) = mrYes then
        begin
          DirTreeEdit.PlainText:= true;
          DirTreeEdit.Lines.SaveToFile(SaveDlg.Filename);
          DirTreeEdit.PlainText:= false;
          Done:= true;
        end;
      end
      else
      begin
        DirTreeEdit.PlainText:= true;
        DirTreeEdit.Lines.SaveToFile(SaveDlg.Filename);
        DirTreeEdit.PlainText:= false;
        Done:= true;
      end;
    end
    else Done:= true;
  end;
  SaveDlg.Free;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.ActSaveUtf8TxtExecute(Sender: TObject);
// Save contents of richedit in an utf8 txt file
var
  SaveDlg: TSaveDialog;
  Utf8Text: TStrings;
  Done: boolean;

  function ConvertToUtf8(AText: string): string;
  var
    SearchTxt: string;
    ReplaceTxt: string;
  begin
    result:= AnsiToUtf8(AText);
    // Horizontal
    SearchTxt:= AnsiToUtf8(DirScanner.HorizontalChar);
    ReplaceTxt:= Utf8Encode(#9472);
    result:= StringReplace(result,SearchTxt,ReplaceTxt,[rfReplaceAll]);
    // Vertical
    SearchTxt:= AnsiToUtf8(DirScanner.VerticalChar);
    ReplaceTxt:= Utf8Encode(#9474);
    result:= StringReplace(result,SearchTxt,ReplaceTxt,[rfReplaceAll]);
    // Middle
    SearchTxt:= AnsiToUtf8(DirScanner.MiddleChar);
    ReplaceTxt:= Utf8Encode(#9500);
    result:= StringReplace(result,SearchTxt,ReplaceTxt,[rfReplaceAll]);
    // Last
    SearchTxt:= AnsiToUtf8(DirScanner.LastChar);
    ReplaceTxt:= Utf8Encode(#9492);
    result:= StringReplace(result,SearchTxt,ReplaceTxt,[rfReplaceAll]);
    // UTF8 header
    result:= #239#187#191 + result;
  end;

begin
  SaveDlg:= TSaveDialog.Create(nil);
  SaveDlg.DefaultExt:= 'txt';
  SaveDlg.Filter:= GetMsg(0033) + ' (*.txt)|*.txt|' + GetMsg(0032) + ' (*.*)|*.*';
  SaveDlg.FileName:= 'WindowsTree.txt';
  Done:= false;
  While not Done Do
  begin
    if SaveDlg.Execute then
    begin
      if FileExists(SaveDlg.Filename) then
      begin
        if MessageDlg(SaveDlg.Filename + #13#10 + GetMsg(0034),mtConfirmation, [mbYes, mbNo], 0) = mrYes then
        begin
          DirTreeEdit.PlainText:= true;
          Utf8Text:= TStringList.Create;
          Utf8Text.Text:= ConvertToUtf8(DirTreeEdit.Text);
          Utf8Text.SaveToFile(SaveDlg.Filename);
          Utf8Text.Free;
          DirTreeEdit.PlainText:= false;
          Done:= true;
        end;
      end
      else
      begin
        DirTreeEdit.PlainText:= true;
        Utf8Text:= TStringList.Create;
        Utf8Text.Text:= ConvertToUtf8(DirTreeEdit.Text);
        Utf8Text.SaveToFile(SaveDlg.Filename);
        Utf8Text.Free;
        DirTreeEdit.PlainText:= false;
        Done:= true;
      end;
    end
    else Done:= true;
  end;
  SaveDlg.Free;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.ActQuitExecute(Sender: TObject);
// Quit application
begin
  Close;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.ActPreferenceExecute(Sender: TObject);
// Display preference setup dialog
begin
  with TFrmConfig.Create(Application) do
  try
    Showmodal;
  finally
    Free;
  end;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.ActHelpExecute(Sender: TObject);
begin
  ShowMessage(
  ' ' + GetMsg(0181) +
  ' ' + GetMsg(0182) + #13#10 + #13#10 +
  '   ALT+V' + #9 + GetMsg(0183) + #13#10 +
  '   ALT+H' + #9 + GetMsg(0184) + #13#10 +
  '   ALT+M' + #9 + GetMsg(0185) + #13#10 +
  '   ALT+L' + #9 + GetMsg(0186) + #13#10 +
  '   ALT+N' + #9 + GetMsg(0187) + #13#10 +
  '' + #13#10 +  #13#10 +
  ' ' + GetMsg(0188) +
  ' ' + GetMsg(0189) +
  #13#10 +  #13#10 +
  '   [TITLE]' + #9 + GetMsg(0190) + #13#10 +
  '   [D]' + #9#9 + GetMsg(0191) + #13#10 +
  '   [M]' + #9#9 + GetMsg(0192) + #13#10 +
  '   [Y]' + #9#9 + GetMsg(0193) + #13#10 +
  '   [h]' + #9#9 + GetMsg(0194) + #13#10 +
  '   [n]' + #9#9 + GetMsg(0195) + #13#10 +
  '   [s]' + #9#9 + GetMsg(0196) + #13#10 +
  '   [PAGE]' + #9 + GetMsg(0197) + #13#10 +
  '   [PAGES]' + #9 + GetMsg(0198)
  );
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.ActAboutExecute(Sender: TObject);
// Display an about box
begin
(*
  ShowMessage('        WindowsTree' + #13#10 +
              '        Version ' + Version + #13#10 + #13#10 +
              'Copyleft 2001-2008 A.Jaffre' + #13#10 + #13#10 +
              '  email: jack.r@free.fr' + #13#10 +
              '  site : http://jack.r.free.fr');
*)
  with TFrmAbout.Create(Application) do
  try
    SoftVersion:= Version;
    Showmodal;
  finally
    Free;
  end;

end;

{------------------------------------------------------------------------------}

procedure TFrmMain.ActSelectDirExecute(Sender: TObject);
// Select directory to scan
var
  SelectedFolder: string;
begin
  SelectedFolder:= DirScanner.RootDir;
  if SelectADirectory(GetMsg(0041),SelectedFolder)then
  begin
    if SelectedFolder<>'' then
    begin
      if SelectedFolder[length(SelectedFolder)]<>'\' then
         SelectedFolder:= SelectedFolder + '\';
      DirScanner.RootDir:= SelectedFolder;
      DirScanner.Stop:= false;
      DirTreeEdit.Stop:= false;
      ActRefresh.Enabled:= true;
      ActRefresh.Execute;
    end
    else
      // Path too long and not managed by Windows folder selection dialog !
      ActRefresh.Enabled:= false;
  end
  else
    ActRefresh.Enabled:= false;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.ActInputDirExecute(Sender: TObject);
// Display root folder input dialog
begin
  with TFrmInputDir.Create(Application) do
  try
    CbxInputDir.Text:=DirScanner.RootDir;
    CbxInputDir.Items.CommaText:=RecentDir;
    if ShowModal=mrOk then
    begin
      DirScanner.RootDir:=CbxInputDir.Text;
      // Limit to 10 in recent dir
      if CbxInputDir.Items.Count>9 then
         CbxInputDir.Items.Delete(0);
      if CbxInputDir.Items.IndexOf(CbxInputDir.Text)=-1 then
        CbxInputDir.Items.Add(CbxInputDir.Text);
      RecentDir:=CbxInputDir.Items.CommaText;
      DirScanner.Stop:= false;
      DirTreeEdit.Stop:= false;
      ActRefresh.Enabled:= true;
      ActRefresh.Execute;
    end
    else
      ActRefresh.Enabled:= false;
  finally
    Free;
  end;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.ActPrintPreviewExecute(Sender: TObject);
// Diplay a print preview of the obtain tree
begin
  with TFrmPreview.Create(Application) do
  try
    RichEditPrintPreview.RichEdit:= DirTreeEdit;
    RichEditPrintPreview.PrintTitle:= DirScanner.RootDir;
    RichEditPrintPreview.HeaderFont.Assign(DirTreeEdit.Font);
    RichEditPrintPreview.FooterFont.Assign(DirTreeEdit.Font);
    Showmodal;
  finally
    Free;
  end;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.ActPrintExecute(Sender: TObject);
// Print the obtain tree
var
  TmpRichEdit : TRichEdit;
begin
    with TFrmPreview.Create(Application) do
    try
      RichEditPrintPreview.RichEdit:= DirTreeEdit;
      RichEditPrintPreview.PrintTitle:= DirScanner.RootDir;
      RichEditPrintPreview.HeaderFont.Assign(DirTreeEdit.Font);
      RichEditPrintPreview.FooterFont.Assign(DirTreeEdit.Font);
      RichEditPrintPreview.Reset;
      // Prepare dialog
      with DlgPrint do
      begin
        Options:= [];
        PrintRange:= prAllPages;
        // If something is selected
        if DirTreeEdit.SelLength > 0 then
        begin
          Options:= Options + [poSelection];
          PrintRange:= prSelection;
        end;
        if Config.PageRange then
        // If not selected, prevent to get a white page before printing
        // due to the below printer query to compute number of page
        begin
          // If more then one page
          if RichEditPrintPreview.NumberOfPages > 1 then
          begin
            Options:= Options + [poPageNums];
            FromPage:= 1;
            MinPage:= 1;
            ToPage:= RichEditPrintPreview.NumberOfPages;
            MaxPage:= ToPage;
          end;
        end;
      end;
      // Execute Dialog
      if DlgPrint.Execute then
      begin
        Screen.Cursor:= crHourGlass;
        case DlgPrint.PrintRange of
          prAllPages  : begin
                          RichEditPrintPreview.Reset;
                          RichEditPrintPreview.Print(1,-1);
                        end;
          prSelection : begin
                          // Copy selected text
                          TmpRichEdit:= TRichEdit.Create(self);
                          TmpRichEdit.Parent:= Self;
                          TmpRichEdit.Visible:= false;
                          TmpRichEdit.Font.Assign(DirTreeEdit.Font);
                          TmpRichEdit.WordWrap:= DirTreeEdit.WordWrap;
                          TmpRichEdit.Lines.Add(DirTreeEdit.SelText);
                          // Print
                          RichEditPrintPreview.RichEdit:= TmpRichEdit;
                          RichEditPrintPreview.PrintTitle:= DirScanner.RootDir;
                          RichEditPrintPreview.Reset;
                          RichEditPrintPreview.Print(1,-1);
                          // Free
                          TmpRichEdit.Free;
                        end;
        else // prPageNums
          RichEditPrintPreview.Reset;
          RichEditPrintPreview.Print(DlgPrint.FromPage,DlgPrint.ToPage);
        end;
        Screen.Cursor:= crDefault;
      end;
    finally
    Free;
  end;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.ActScanExecute(Sender: TObject);
// Run directory scanning
{$IFDEF TIMING}
var
  StartTime: cardinal;
  StopTime: cardinal;
{$ENDIF}
begin
  if DirScanner.RootDir <> '' then
  begin
    // Work in progress cursor
    Screen.Cursor:= crHourGlass;

    // Proccess
    LblSelectedDir.Caption:= GetMsg(0001) + ' ' + DirScanner.RootDir;
    // Clear status bar
    StatusBar.SimplePanel:= true;
    StatusBar.SimpleText:= '';
  {$IFDEF TIMING}
    StartTime:= GetTickCount;
  {$ENDIF}
    DirScanner.Process;
  {$IFDEF TIMING}
    StopTime:= GetTickCount;
    TBXLabelSelectedDir.Caption:= intToStr(StopTime - StartTime);
  {$ELSE}
    LblSelectedDir.Caption:= GetMsg(0001) + ' '  + DirScanner.RootDir;
  {$ENDIF}

    DirScanner.Stop:= false;
    // Back to default cursor
    Screen.Cursor:= crDefault;
  end;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.ActRefreshExecute(Sender: TObject);
// Build and display the tree
var
  ScrollMessage:TWMVScroll;
  Drive: string;
  VolumeName: string;
  FileSystemName: string;
  SerialNumber: string;
  HashName: string;
begin
  // Update user interface
  DragAcceptFiles(handle, false);
  ActRefresh.Enabled:= false;
  ActRefresh.Visible:= false;
  ActStop.Enabled:= true;
  ActStop.Visible:= true;
  EnableUI(false);

  // Clear DirTreeEdit
  DirTreeEdit.Lines.Clear;
  Update;

  // Do scan directory
  UpdateScannerDirSetup;
  ActScan.Execute;

  // Update user interface
  StatusBar.SimplePanel:= false;

  if DirScanner.Count > 0 then
  begin
    // Work in progress cursor
    Screen.Cursor:= crHourGlass;
    ProgressBar.Visible:= true;
    ProgressBar.Max:= DirScanner.Count;

    if not DirTreeEdit.Stop then
    begin
      UpdateDirTreeEditSetup;
      with DirTreeEdit do
      begin
        // Display the result
        Lines.BeginUpdate;
        SelStart:= 0;
        AddLine(GetMsg(0021) + ' ' + DirScanner.RootDir);
        AddLine(GetMsg(0022) + ' ' + DateToStr(Date) + ' ' + GetMsg(0023) + ' ' + TimeToStr(Time));
        Drive:= copy(ExtractFileDrive(DirScanner.RootDir),1,1);
        GetVolumeInfo(Drive, VolumeName, FileSystemName, SerialNumber);
        AddLine(GetDriveTypeStr(Drive) + ' [' + VolumeName +
          '], ' + GetMsg(0024) + ' ' + SerialNumber);
        if DirScanner.Hash <> haNone then
        begin
          HashName := '';
          case DirScanner.Hash of
            haMD5: HashName := 'MD5';
            haSHA1: HashName := 'SHA1';
            haSHA256: HashName := 'SHA256';
            haSHA512: HashName := 'SHA512';
          end;
          if HashName <> '' then AddLine(GetMsg(0172) + ': ' + HashName);
        end;
        AddLine('');
        Refresh;
        Lines.EndUpdate;
        // Move the caret back to first line
        SelStart:= DirTreeEdit.Perform(EM_LINEINDEX,0,0);
        Perform(EM_SCROLLCARET,0,0);
        // Move the scroll bar to the top
        ScrollMessage.Msg:=WM_VScroll;
        ScrollMessage.ScrollCode:=SB_TOP;
        ScrollMessage.Pos:=0;
        Dispatch(ScrollMessage);
        Modified:= false;
      end;
    end;

    DirTreeEdit.Stop:= false;
    DirTreeEdit.SetFocus;

    ProgressBar.Visible:= false;
    // Back to default cursor
    Screen.Cursor:= crDefault;
  end;

  // Update user interface
  ActStop.Enabled:= false;
  ActStop.Visible:= false;
  ActRefresh.Visible:= true;
  DragAcceptFiles(handle, true);
  EnableUI(true);
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.ActStopExecute(Sender: TObject);
// Interrupt processing
begin
  DirScanner.Stop:= true;
  DirTreeEdit.Stop:= true;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.ActSelectFontExecute(Sender: TObject);
// Select tree fonts
begin
  with DlgFont do
  begin
    Device:= fdBoth;
    Font.Assign(DirTreeEdit.Font);
    Options:= [fdForceFontExist,fdApplyButton];
  end;
  if DlgFont.Execute then DirTreeEdit.Font.Assign(DlgFont.Font);
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.ActCommentBoldExecute(Sender: TObject);
begin
  if (not DirTreeEdit.ReadOnly) then
  with (Sender as TAction) do
  begin
    Checked:= not Checked;
    if Checked then
      DirTreeEdit.SelAttributes.Style:= DirTreeEdit.SelAttributes.Style + [fsBold]
    else
      DirTreeEdit.SelAttributes.Style:= DirTreeEdit.SelAttributes.Style - [fsBold];
    TbnCommentBold.down:= Checked;
  end;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.ActCommentItalicExecute(Sender: TObject);
begin
  if (not DirTreeEdit.ReadOnly) then
  with (Sender as TAction) do
  begin
    Checked:= not Checked;
    if Checked then
      DirTreeEdit.SelAttributes.Style:= DirTreeEdit.SelAttributes.Style + [fsItalic]
    else
      DirTreeEdit.SelAttributes.Style:= DirTreeEdit.SelAttributes.Style - [fsItalic];
    TbnCommentItalic.down:= Checked;
  end;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.ActCommentUnderlineExecute(Sender: TObject);
begin
  if (not DirTreeEdit.ReadOnly) then
  with (Sender as TAction) do
  begin
    Checked:= not Checked;
    if Checked then
      DirTreeEdit.SelAttributes.Style:= DirTreeEdit.SelAttributes.Style + [fsUnderline]
    else
      DirTreeEdit.SelAttributes.Style:= DirTreeEdit.SelAttributes.Style - [fsUnderline];
    TbnCommentUnderline.down:= Checked;
  end;
end;

{*****************************************************************************}
{ Private                                                                     }
{*****************************************************************************}

procedure TFrmMain.UpdateWithLastUse;
// Update current configuration with what was save in last use
begin
  DirScanner.RootDir:= LastUseCfg.Root;
  RecentDir:= LastUseCfg.RecentDir;
  case LastUseCfg.Sort of
    1: RbtnAlpha.Checked:= true;
    2: RbtnSize.Checked:= true;
    3: RbtnDate.Checked:= true;
  else
    RbtnNone.Checked:= true
  end;
  CbxEmptyFolder.Checked:= LastUseCfg.DisplayEmptyFolder;
  CbxFile.Checked:= LastUseCfg.DisplayFile;
  CbxSize.Checked:= LastUseCfg.DisplaySize;
  CbxDate.Checked:= LastUseCfg.DisplayDate;
  CbxHash.Checked:= LastUseCfg.DisplayHash;
  EdtDisplayMax.Text:= LastUseCfg.DisplayMaxValue;
  EdtMaxDepth.Text:= LastUseCfg.MaxDepthValue;
  CbxMask.Checked:= LastUseCfg.MasK;
  EdtMask.Text:= LastUseCfg.MaskValue;
  CbxSizeRange.Checked:= LastUseCfg.SizeRange;
  EdtMinSize.Text:= LastUseCfg.MinSizeValue;
  EdtMaxSize.Text:= LastUseCfg.MaxSizeValue;
  LoadLanguage(LastUseCfg.Language);
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.UpdateLastUse;
// Update last use configuration
begin
  LastUseCfg.Root:= DirScanner.RootDir;
  LastUseCfg.RecentDir:= RecentDir;
  LastUseCfg.Sort:= 0;
  if RbtnAlpha.Checked then LastUseCfg.Sort:= 1;
  if RbtnSize.Checked then LastUseCfg.Sort:= 2;
  if RbtnDate.Checked then LastUseCfg.Sort:= 3;
  LastUseCfg.DisplayEmptyFolder:= CbxEmptyFolder.Checked;
  LastUseCfg.DisplayFile:= CbxFile.Checked;
  LastUseCfg.DisplaySize:= CbxSize.Checked;
  LastUseCfg.DisplayDate:= CbxDate.Checked;
  LastUseCfg.DisplayHash:= CbxHash.Checked;
  LastUseCfg.DisplayMaxValue:= EdtDisplayMax.Text;
  LastUseCfg.MaxDepthValue:= EdtMaxDepth.Text;
  LastUseCfg.MasK:= CbxMask.Checked;
  LastUseCfg.MaskValue:= EdtMask.Text;
  LastUseCfg.SizeRange:= CbxSizeRange.Checked;
  LastUseCfg.MinSizeValue:= EdtMinSize.Text;
  LastUseCfg.MaxSizeValue:= EdtMaxSize.Text;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.MnuLanguageClick(Sender: TObject);
// Change language
var
  ALanguage: string;
  APos: integer;
begin
  with Sender as TMenuItem do
  begin
    ALanguage:= ClearShortcutText(Caption);
    with MnuItemLanguage do
    begin
      for APos:= 1 to Count do
        Items[APos-1].Checked:= false;
    end;
    Checked:= true;
    LoadLanguage(ALanguage);
    LastUseCfg.Language:= ALanguage;
  end;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.BuildLanguageMenu;
{ Build the language menu }
var
  N: integer;
  ASearchRec: TSearchRec;
  AText: string;
  Number: integer;
  AMenuItem: TMenuItem;
begin
  // Clear existing language items
  if MnuItemLanguage.Count > 0 then
  begin
    for N:= MnuItemLanguage.Count-1 downto 0 do
      MnuItemLanguage.Items[N].Free;
  end;
  // Get all available language
  Number:= 0;
  if FindFirst(AppliDir + '*' + LngExt, faAnyFile, ASearchRec) = 0 then
  begin
    inc(Number);
    AText:= ExtractFileName(ASearchRec.Name);
    AText:= copy(AText,1,length(AText)- length(LngExt));
    AText:= FirstUpperText(AText);
    // Add sub menu
    AMenuItem:= TMenuItem.Create(PopupMenu);
    AMenuItem.Caption:= AText;
    AMenuItem.OnClick:= MnuLanguageClick;
    MnuItemLanguage.Add(AMenuItem);
    // Find next language
    while FindNext(ASearchRec) = 0 do
    begin
      inc(Number);
      AText:= ExtractFileName(ASearchRec.Name);
      AText:= copy(AText,1,length(AText)-4);
      AText:= FirstUpperText(AText);
      // Add sub menu
      AMenuItem:= TMenuItem.Create(PopupMenu);
      AMenuItem.Caption:= AText;
      AMenuItem.OnClick:= MnuLanguageClick;
      MnuItemLanguage.Add(AMenuItem);
    end;
  end;

  if Number > 0 then
    MnuItemLanguage.Visible:= true
  else
    MnuItemLanguage.Visible:= false;

end;

{------------------------------------------------------------------------------}

procedure TFrmMain.EnableUI(Allowed: boolean);
begin
  ActSelectDir.Enabled:= Allowed;
  ActRefresh.Enabled:= Allowed and (DirScanner.RootDir <> '');
  ActPrintPreview.Enabled:= Allowed and (DirTreeEdit.Lines.Count <> 0);
  ActPrint.Enabled:= ActPrintPreview.Enabled;
  ActSelectFont.Enabled:= Allowed;
  CbxComment.Enabled:= ActPrintPreview.Enabled;
  ActSaveRtf.Enabled:= ActPrintPreview.Enabled;
  ActSaveTxt.Enabled:= ActPrintPreview.Enabled;
  ActSaveUtf8Txt.Enabled:= ActPrintPreview.Enabled;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.EnableComment(Allowed: boolean);
// Change Comment toolbar element status
begin
  CbxCommentFont.Enabled:= Allowed;
  CbxCommentSize.Enabled:= Allowed;
  ActCommentBold.Enabled:= Allowed;
  ActCommentItalic.Enabled:= Allowed;
  ActCommentUnderline.Enabled:= Allowed;
  ColorBoxComment.Enabled:= Allowed;
  DirTreeEdit.ReadOnly:= not Allowed;
end;

{------------------------------------------------------------------------------}

function TFrmMain.StrToSize(ASizeStr: string): integer;
// Convert a string size in kilobyte into size in byte
var
  ASize: integer;
begin
  try
    ASize:= StrToInt(ASizeStr);
    ASize:= ASize * 1024; // convert to byte size
    result:= ASize;
  except
    result:= 0;
  end;
end;

{------------------------------------------------------------------------------}

function TFrmMain.SizeToStr(ASize: integer): string;
// Convert size in byte into a string in kilo byte
begin
  try
    result:= IntToStr(ASize div 1024);
  except
    result:= '0';
  end;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.UpdateCursorPos;
var
  CharPos: TPoint;
begin
  CharPos.Y := SendMessage(DirTreeEdit.Handle, EM_EXLINEFROMCHAR, 0,
    DirTreeEdit.SelStart);
  CharPos.X := (DirTreeEdit.SelStart -
    SendMessage(DirTreeEdit.Handle, EM_LINEINDEX, CharPos.Y, 0));
  Inc(CharPos.Y);
  Inc(CharPos.X);
  StatusBar.Panels[0].Text := Format(GetMsg(0002) + ' %5d     ' + GetMsg(0003) + ' %5d', [CharPos.Y, CharPos.X]);
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.ScannerDirChange(Sender: TObject; ADir: string);
// Display the current directory
begin
  StatusBar.SimpleText:= ADir;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.UpdateScannerDirSetup;
// Update ScanDir setup according to config and user interface
// Only place to do the setup, most simple than to use many on change event
begin
  // Sort
  DirScanner.Sort:= soNone;
  if RbtnAlpha.Checked then DirScanner.Sort:= soAlpha;
  if RbtnSize.Checked then DirScanner.Sort:= soSize;
  if RbtnDate.Checked then DirScanner.Sort:= soDate;
  // Filter
  DirScanner.UseMask:= CbxMask.Checked;
  if EdtMask.Visible then DirScanner.SetMask(EdtMask.Text)
                     else DirScanner.SetMask('');
  // Size
  DirScanner.UseSize:= CbxSizeRange.Checked;
  if EdtMinSize.Visible then
  begin
     DirScanner.SetSize(StrToSize(EdtMinSize.Text),StrToSize(EdtMaxSize.Text));
     EdtMinSize.Text:= SizeToStr(DirScanner.MinSize);
     EdtMaxSize.Text:= SizeToStr(DirScanner.MaxSize);
  end
  else
  begin
    DirScanner.SetSize(0,0);
  end;
  // Max depth
  try
    DirScanner.MaxDepth:= StrToInt(EdtMaxDepth.Text);
  except
    DirScanner.MaxDepth:= 0;
  end;
  EdtMaxDepth.Text:= IntToStr(DirScanner.MaxDepth);
  // Hash
  if CbxHash.Checked then
    case Config.HashType of
      0: DirScanner.Hash:= haNone;
      1: DirScanner.Hash:= haMD5;
      2: DirScanner.Hash:= haSHA1;
      3: DirScanner.Hash:= haSHA256;
      4: DirScanner.Hash:= haSHA512;
    else
      DirScanner.Hash:= haNone;
    end
  else DirScanner.Hash:= haNone;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.DirTreeEditProcessing(Sender: TObject;
  ANumber: integer);
// Update progress bar during processing  
begin
  ProgressBar.Position:= ANumber;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.DirTreeEditSelectionChange(Sender: TObject);
begin
  if (not DirTreeEdit.ReadOnly) then
  begin
    // Update button depending on selection
    ActCommentBold.Checked:= fsBold in DirTreeEdit.SelAttributes.Style;
    TbnCommentBold.down:= ActCommentBold.Checked;
    ActCommentItalic.Checked:= fsItalic in DirTreeEdit.SelAttributes.Style;
    TbnCommentItalic.down:= ActCommentItalic.Checked;
    ActCommentUnderline.Checked:= fsUnderline in DirTreeEdit.SelAttributes.Style;
    TbnCommentUnderline.down:= ActCommentUnderline.Checked;
    ColorBoxComment.Selected:= DirTreeEdit.SelAttributes.Color;
    ColorBoxComment.Enabled:= true;
  end;
  UpdateCursorPos;
end;


{------------------------------------------------------------------------------}

procedure TFrmMain.DirTreeEditKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if (not DirTreeEdit.ReadOnly) then
  begin
    if (ssAlt in Shift) then
    begin
      // Special character
      if Key = ord('V') then DirTreeEdit.SelText:= DirScanner.VerticalChar;
      if Key = ord('H') then DirTreeEdit.SelText:= DirScanner.HorizontalChar;
      if Key = ord('M') then DirTreeEdit.SelText:= DirScanner.MiddleChar;
      if Key = ord('L') then DirTreeEdit.SelText:= DirScanner.LastChar;
      if Key = ord('N') then DirTreeEdit.InsertLines(1);
    end;
  end;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.DirTreeEditMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
begin
  StatusBar.SimplePanel:= false;
  ActUpdateStatusBarUpdate(Sender);
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.UpdateDirTreeEditSetup;
// Update DirTreeEdit setup according to config and user interface
// Only place to do the setup, most simple than to use many on change event
begin
  // User interface
  DirTreeEdit.Displays:= [];
  if CbxEmptyFolder.Checked then
    DirTreeEdit.Displays:= DirTreeEdit.Displays + [dtdEmptyFolder];
  if CbxFile.Checked then
    DirTreeEdit.Displays:= DirTreeEdit.Displays + [dtdFile];
  if CbxDate.Checked then
    DirTreeEdit.Displays:= DirTreeEdit.Displays + [dtdDate];
  if CbxSize.Checked then
    DirTreeEdit.Displays:= DirTreeEdit.Displays + [dtdSize];
  if CbxHash.Checked then
    DirTreeEdit.Displays:= DirTreeEdit.Displays + [dtdHash];
  // Display max depth
  try
    DirTreeEdit.Depth:= StrToInt(EdtDisplayMax.Text);
  except
    DirTreeEdit.Depth:= 0;
  end;
  EdtDisplayMax.Text:= IntToStr(DirTreeEdit.Depth);
  // Config option
  with Config do
  begin
    DirTreeEdit.FileNumbering:= FileNumbering;
    DirTreeEdit.Highlight:= Highlighting;
    // Tree
    with DirTreeEdit.HighlightTree do
    begin
      Styles:= [];
      if TreeBold then Styles:= Styles + [fsBold];
      if TreeItalic then Styles:= Styles + [fsItalic];
      if TreeUnderline then Styles:= Styles + [fsUnderline];
      Color:= TreeColor;
    end;
    // Directory
    with DirTreeEdit.HighlightDir do
    begin
      Styles:= [];
      if DirBold then Styles:= Styles + [fsBold];
      if DirItalic then Styles:= Styles + [fsItalic];
      if DirUnderline then Styles:= Styles + [fsUnderline];
      Color:= DirColor;
    end;
    // File
    with DirTreeEdit.HighlightFile do
    begin
      Styles:= [];
      if FileBold then Styles:= Styles + [fsBold];
      if FileItalic then Styles:= Styles + [fsItalic];
      if FileUnderline then Styles:= Styles + [fsUnderline];
      Color:= FileColor;
    end;
    // Size
    with DirTreeEdit.HighlightSize do
    begin
      Styles:= [];
      if SizeBold then Styles:= Styles + [fsBold];
      if SizeItalic then Styles:= Styles + [fsItalic];
      if SizeUnderline then Styles:= Styles + [fsUnderline];
      Color:= SizeColor;
    end;
    // Date
    with DirTreeEdit.HighlightDate do
    begin
      Styles:= [];
      if DateBold then Styles:= Styles + [fsBold];
      if DateItalic then Styles:= Styles + [fsItalic];
      if DateUnderline then Styles:= Styles + [fsUnderline];
      Color:= DateColor;
    end;
    // Hash
    with DirTreeEdit.HighlightHash do
    begin
      Styles:= [];
      if HashBold then Styles:= Styles + [fsBold];
      if HashItalic then Styles:= Styles + [fsItalic];
      if HashUnderline then Styles:= Styles + [fsUnderline];
      Color:= HashColor;
    end;
    DirTreeEdit.LineSpaceDir:= SpaceLinesDir;
    DirTreeEdit.LineSpaceFile:= SpaceLinesFile;
  end;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.AddRegistryContextMenu;
// Add a contextual menu entry to enable directory listing when application is
// already started
// Work only if user is admin (has right to create key in registry)
var
  Reg: TRegistry;
  // Key could be: '\Folder\shell\' for folders and drives
  //               '\Directory\shell\' for folders
  //               '\Drive\shell\' for drives
begin
  Reg := TRegistry.Create;
  try
    Reg.RootKey := HKEY_CLASSES_ROOT;
    if Reg.OpenKey('\Folder\shell\' + Application.Title + '\command', True) then
    begin
      Reg.WriteExpandString('','"' + Application.ExeName + '" %L');
      Reg.CloseKey;
    end;
  finally
    Reg.Free;
    inherited;
  end;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.RemoveRegistryContextMenu;
// Remove the contextual menu entry which enable directory listing when
// application is already started
var
  Reg: TRegistry;
begin
  Reg := TRegistry.Create;
  try
    Reg.RootKey := HKEY_CLASSES_ROOT;
    if Reg.OpenKey('\Folder\shell\' + Application.Title, True) then
    begin
      Reg.DeleteKey('\Folder\shell\' + Application.Title);
    end;
  finally
    Reg.Free;
    inherited;
  end;
end;

{------------------------------------------------------------------------------}

function TFrmMain.GetSpecialFolder(Folder: Integer): string;
// Return the path of Windows special folders
// From: http://delphi.developpez.com/faq/?page=repertoire#specialdirectory
//
//   CSIDL_APPDATA : Rpertoire contenant les donnes des applications.
//   CSIDL_COMMON_FAVORITES : Rpertoire contenant les Favoris commun  tous les utilisateurs.
//   CSIDL_COMMON_STARTMENU : Rpertoire du menu dmarrer commun  tous les utilisateurs.
//   CSIDL_COMMON_PROGRAMS : Rpertoire Programmes du menu dmarrer commun  tous les utilisateurs.
//   CSIDL_COMMON_STARTUP : Rpertoire du groupe Dmarrage du menu dmarrer commun  tous les utilisateurs.
//   CSIDL_COMMON_DESKTOPDIRECTORY : Rpertoire correspondant au bureau commun  tous les utilisateurs.
//   CSIDL_COOKIES : Rpertoire ou sont stocks les cookies d'Internet Explorer.
//   CSIDL_DESKTOP : Rpertoire correspondant  votre Bureau.
//   CSIDL_DESKTOPDIRECTORY : Rpertoire correspondant  votre Bureau.
//   CSIDL_FAVORITES : Rpertoire Favoris.
//   CSIDL_FONTS : Rpertoire dans lequel sont stockes toutes les polices de caractres.
//   CSIDL_HISTORY : Rpertoire contenant les historiques d'Internet Explorer.
//   CSIDL_INTERNET_CACHE : Rpertoire ou sont stocks les fichiers temporaires d'Internet Explorer.
//   CSIDL_NETHOOD : Rpertoire Voisinage Rseau.
//   CSIDL_PERSONAL : Rpertoire Mes Documents.
//   CSIDL_PRINTHOOD : Rpertoire de voisinage d'impression.
//   CSIDL_PROGRAMS : Rpertoire Programmes du Menu Dmarrer.
//   CSIDL_RECENT : Rpertoire dans lequel se trouvent les raccourcis vers les Fichiers rcemment ouverts.
//   CSIDL_SENDTO : Rpertoire dans lequel se trouvent les raccourcis Envoyer vers
//   CSIDL_STARTMENU : Rpertoire Menu Dmarrer.
//   CSIDL_STARTUP : Rpertoire du groupe Dmarrage du Menu Dmarrer.
//   CSIDL_TEMPLATES : Rpertoire contenant les modles de documents de Windows.

var
  SFolder : pItemIDList;
  SpecialPath : Array[0..MAX_PATH] Of Char;
begin
  SHGetSpecialFolderLocation(self.Handle, Folder, SFolder);
  SHGetPathFromIDList(SFolder, SpecialPath);
  Result := StrPas(SpecialPath);
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.AddSendToMenu;
// Add a send to shortcut
var
  Shortcut: string;
  ShellLink: IShellLink;
begin
  Shortcut:= ChangeFileExt(ExtractFilename(Application.ExeName),'.lnk');
  Shortcut:= GetSpecialFolder(CSIDL_SENDTO) + '\' + Shortcut;
  ShellLink:=CreateComObject(CLSID_ShellLink) as IShellLink;
  ShellLink.SetPath(PAnsiChar(Application.ExeName));
  ShellLink.SetShowCmd(SW_SHOW);
  (ShellLink as IpersistFile).Save(StringToOleStr(Shortcut), true);
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.RemoveSendToMenu;
// Remove the send to shortcut
var
  Shortcut: string;
begin
  Shortcut:= ChangeFileExt(ExtractFilename(Application.ExeName),'.lnk');
  Shortcut:= GetSpecialFolder(CSIDL_SENDTO) + '\' + Shortcut;
  if FileExists(Shortcut) then
  begin
    DeleteFile(Shortcut);
  end;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.ScanFromExplorer(ADir: string);
// Scan ADir received through command line arguments
begin
  if FileExists(Adir) then ADir:= ExtractFilePath(Adir);
  if DirectoryExists(ADir)then
  begin
    if ADir[length(ADir)]<>'\' then ADir:= ADir + '\';
    // Stop running one if needed
    DirScanner.Stop:= true;
    DirTreeEdit.Stop:= true;
    // Process new folder
    DirScanner.RootDir:= ADir;
    DirScanner.Stop:= false;
    DirTreeEdit.Stop:= false;
    ActRefresh.Enabled:= true;
    ActRefresh.Execute;
  end;
end;

{------------------------------------------------------------------------------}

{*****************************************************************************}
{ Protected                                                                   }
{*****************************************************************************}

procedure TFrmMain.CreateParams(var Params: TCreateParams);
begin
  inherited;
  StrCopy(Params.WinClassName, cWindowClassName);
end;

{*****************************************************************************}
{ Public                                                                      }
{*****************************************************************************}

procedure TFrmMain.ActUpdateStatusBarUpdate(Sender: TObject);
var
  Mode: string;
begin
  if not (StatusBar.SimplePanel) then
  begin
    // Insertion / Remplacement
    if DirTreeEdit.ReadOnly then Mode := GetMsg(0004)
    else
      if DirTreeEdit.InsertMode then Mode := GetMsg(0005)
                                else Mode := GetMsg(0006);
    StatusBar.Panels[2].Text:= Mode;
    if DirTreeEdit.Modified then StatusBar.Panels[1].Text:= GetMsg(007)
                            else StatusBar.Panels[1].Text:= '';

  end;
end;

{*****************************************************************************}
{ New interface                                                               }
{*****************************************************************************}

procedure TFrmMain.CbxCommentClick(Sender: TObject);
// Update menu item status of Comment toolbar
begin
  EnableComment(CbxComment.Checked);
  if CbxComment.Checked then DirTreeEdit.SetFocus;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.CbxCommentFontChange(Sender: TObject);
// Change comment font
begin
  if (not DirTreeEdit.ReadOnly) then
      DirTreeEdit.SelAttributes.Name:= CbxCommentFont.Text;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.CbxCommentSizeChange(Sender: TObject);
// Change comment size
begin
  if (not DirTreeEdit.ReadOnly) then
      DirTreeEdit.SelAttributes.Size:= StrToInt(CbxCommentSize.Text);
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.ColorBoxCommentChange(Sender: TObject);
// Change comment color
begin
  if (not DirTreeEdit.ReadOnly) then
      DirTreeEdit.SelAttributes.Color:= ColorBoxComment.Selected;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.CbxSizeRangeClick(Sender: TObject);
// Change availability depending on SizeRange checkbox
begin
  EdtMinSize.Enabled:= CbxSizeRange.Visible and CbxSizeRange.Checked;
  EdtMaxSize.Enabled:= EdtMinSize.Enabled;
  LblHigherOrEqual.Enabled:= EdtMinSize.Enabled;
  LblLowerOrEqual.Enabled:= EdtMinSize.Enabled;
  LblMinSize.Enabled:= EdtMinSize.Enabled;
  LblMaxSize.Enabled:= EdtMaxSize.Enabled;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.CbxMaskClick(Sender: TObject);
// Change availability depending on Mask checkbox
begin
  EdtMask.Enabled:= CbxMask.Visible and CbxMask.Checked;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.CbxFileClick(Sender: TObject);
// Change availability depending on File checkbox
begin
  CbxMask.Enabled:= CbxFile.Checked;
  EdtMask.Enabled:= CbxFile.Checked and CbxMask.Checked;
  CbxSizeRange.Enabled:= CbxFile.Checked;
  EdtMinSize.Enabled:= CbxFile.Checked and CbxSizeRange.Checked;
  EdtMaxSize.Enabled:= CbxFile.Checked and CbxSizeRange.Checked;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.ShowHint(Sender: TObject);
// Show menu hint in the status bar
begin
  StatusBar.SimplePanel:= true;
  StatusBar.SimpleText:= Application.hint;
end;

end.
