unit WTInputDir;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, ExtCtrls,
  XPMenu;

type
  TFrmInputDir = class(TForm)
    PnlBottom: TPanel;
    BtnOk: TButton;
    BtnCancel: TButton;
    PnlTop: TPanel;
    LblInputDir: TLabel;
    CbxInputDir: TComboBox;
    procedure FormCreate(Sender: TObject);
    procedure BtnOkClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { Dclarations prives }
    XPMenu: TXPMenu;
    procedure ApplyLanguage;
  public
    { Dclarations publiques }
  end;

var
  FrmInputDir: TFrmInputDir;

implementation

{$R *.dfm}

uses
  WTLng;

{*****************************************************************************}
{ Form management                                                             }
{*****************************************************************************}

procedure TFrmInputDir.FormCreate(Sender: TObject);
begin
  // XP menu style
  XPMenu := TXPMenu.Create(Self);
  with XPMenu do
  begin
    Name := 'XPMenu';
    DimLevel := 30;
    GrayLevel := 10;
    Font.Charset := ANSI_CHARSET;
    Font.Color := clMenuText;
    Font.Height := -11;
    Font.Name := 'Microsoft Sans Serif';
    Font.Style := [];
    Color := clBtnFace;
    DrawMenuBar := False;
    IconBackColor := clBtnFace;
    MenuBarColor := clBtnFace;
    SelectColor := clHighlight;
    SelectBorderColor := clHighlight;
    SelectFontColor := clMenuText;
    DisabledColor := clInactiveCaption;
    SeparatorColor := clBtnFace;
    CheckedColor := clHighlight;
    IconWidth := 24;
    DrawSelect := True;
    UseSystemColors := True;
    UseDimColor := False;
    OverrideOwnerDraw := False;
    Gradient := False;
    FlatMenu := True;
    AutoDetect := True;
    Active := True;
    Left := 56;
    Top := 120;
  end;

  ApplyLanguage;
end;

{------------------------------------------------------------------------------}

procedure TFrmInputDir.FormShow(Sender: TObject);
begin
  CbxInputDir.SetFocus;
end;

{------------------------------------------------------------------------------}

procedure TFrmInputDir.BtnOkClick(Sender: TObject);
var
  CanClose: boolean;
begin
  CanClose:= DirectoryExists(CbxInputDir.Text);

  if CanClose then
    ModalResult:=mrOk
  else
  begin
    MessageDlg(GetMsg(0173), mtError,[mbOk],0);
    CbxInputDir.SetFocus;
  end;
end;

{------------------------------------------------------------------------------}

{*****************************************************************************}
{ Private                                                                     }
{*****************************************************************************}

procedure TFrmInputDir.ApplyLanguage;
begin
  Caption:= GetMsg(0042);
  LblInputDir.Caption:= GetMsg(0041);
  BtnOk.Caption:= GetMsg(0102);
  BtnCancel.Caption:= GetMsg(0103);
end;

end.
