unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Label1: TLabel;
    Edit1: TEdit;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Memo1: TMemo;
    procedure Button1Click(Sender: TObject);
  private
    { Dclarations prives }
    procedure TimeZoneInfo;
  public
    { Dclarations publiques }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

uses UTCDateTime;

procedure TForm1.TimeZoneInfo;
const
  TIME_ZONE_ID_UNKNOWN= 0;
  TIME_ZONE_ID_STANDARD= 1;
  TIME_ZONE_ID_DAYLIGHT= 2;
var
  TZInfo: TTimeZoneInformation;
  SystemTime: TSystemTime;
begin
  case GetTimeZoneInformation(TZinfo) of
    TIME_ZONE_ID_UNKNOWN : Memo1.Lines.add('Heure inconnue');
    TIME_ZONE_ID_STANDARD: Memo1.Lines.add('Heure d''hiver');
    TIME_ZONE_ID_DAYLIGHT: Memo1.Lines.add('Heure d''t');
  end;
  GetSystemTime(SystemTime);

  with TZinfo do
  begin
    Memo1.Lines.add('Bias : ' + IntToStr(Bias));
    Memo1.Lines.add('Standard Name : ' + StandardName);
    with StandardDate do
    begin
      Memo1.Lines.add('Standard Year : ' + IntToStr(wYear));
      Memo1.Lines.add('Standard Month : ' + IntToStr(wMonth));
      Memo1.Lines.add('Standard DayOfWeek : ' + IntToStr(wDayOfWeek));
      Memo1.Lines.add('Standard Day : ' + IntToStr(wDay));
      Memo1.Lines.add('Standard Hour : ' + IntToStr(wHour));
      Memo1.Lines.add('Standard Minute : ' + IntToStr(wMinute));
      Memo1.Lines.add('Standard Second : ' + IntToStr(wSecond));
      Memo1.Lines.add('Standard Milliseconds : ' + IntToStr(wMilliseconds));
    end;
    Memo1.Lines.add('Standard Bias : ' + IntToStr(StandardBias));
    StandardDate.wYear:= SystemTime.wYear;
    Memo1.Lines.add('Standard Date : ' + DateTimeToStr(AdaptSystemTime(StandardDate)));
    Memo1.Lines.add('');

    Memo1.Lines.add('Standard Name : ' + DayLightName);
    with DayLightDate do
    begin
      Memo1.Lines.add('DayLight Year : ' + IntToStr(wYear));
      Memo1.Lines.add('DayLight Month : ' + IntToStr(wMonth));
      Memo1.Lines.add('DayLight DayOfWeek : ' + IntToStr(wDayOfWeek));
      Memo1.Lines.add('DayLight Day : ' + IntToStr(wDay));
      Memo1.Lines.add('DayLight Hour : ' + IntToStr(wHour));
      Memo1.Lines.add('DayLight Minute : ' + IntToStr(wMinute));
      Memo1.Lines.add('DayLight Second : ' + IntToStr(wSecond));
      Memo1.Lines.add('DayLight Milliseconds : ' + IntToStr(wMilliseconds));
    end;
    Memo1.Lines.add('Daylight Bias : ' + IntToStr(DayLightBias));
    DayLightDate.wYear:= SystemTime.wYear;
    Memo1.Lines.add('DayLight Date : ' + DateTimeToStr(AdaptSystemTime(DayLightDate)));
  end;
end;


procedure TForm1.Button1Click(Sender: TObject);
begin
  if Edit1.Text <> '' then
  begin
    Label3.Caption:= DateTimeToStr(UTCToLocalDateTime(StrToInt(Edit1.Text)));
    Label4.Caption:= IntToStr(LocalDateTimeToUTC(StrToDateTime(Label3.Caption)));
  end;
  TimeZoneInfo;
end;


end.
