unit Utilitaires;

interface

uses Windows, SysUtils, Classes, ShellApi;

const
  LangueRef= 'Franais'; // Langue de reference
  ExtLangue= '.lng';     // Extension des fichiers de langue
  ExtAide= '.hlp';       // Extension des fichiers d'aide

  imgFolder= 8;          // Numero icone repertoire dans IlAppli
//  imgFile  = 9;          // Numero icone fichier dans IlAppli

var
  RepAppli: string; // Repertoire ou se trouve l'application
  TmpFile: string;  // Fichier temporaire stockage liste Client Ftp
  NumImgFolder: longint; // Numero de l'image repertoire ajoutee a IlFichiers

  function EpureTexte(LeTexte: string): string;
  procedure ParseLigne(LaLigne: string;var Numero: longint; var Texte: string);

  function AjouteWindowsBackSlash(Chaine: string): string;
  function AjouteUnixSlash(Chaine: string): string;

  function FormateTailleFichier(Bytes: dword): string;
  function FileTimeToDateTime(FileTime: TFileTime): TDateTime;

  function RepPrecedentWindows(Repertoire: string):string;
  function RepPrecedentUnix(Repertoire: string):string;

  function GetShellInfo(const FileName: string;
  dwFileAttributes: DWORD): TSHFileInfo;

  function GetRepertoireWindows :string;

implementation

function EpureTexte(LeTexte: string): string;
{ Elimine les & de soulignement du raccourci }
var
  Position: integer;
begin
  Position:= pos('&',LeTexte);
  if Position<>0 then System.delete(LeTexte,Position,1);
  Result:= LeTexte;
end;

procedure ParseLigne(LaLigne: string;var Numero: longint; var Texte: string);
{ Decoupe une ligne Numero#Texte en 2 entite Numero et Texte }
var
  N: integer;
begin
  N:= pos('#',LaLigne);
  if N<>0 then
  begin
    Numero:= StrToInt(copy(LaLigne,1,N-1));
    delete(LaLigne,1,N);
    Texte:= LaLigne;
  end
  else
  begin
    Numero:= 0;
    Texte:= '';
  end;
end;

function AjouteWindowsBackSlash(Chaine: string): string;
begin
  if Chaine[length(Chaine)] <> '\' then result:= Chaine + '\'
  else result := Chaine;
end;

function AjouteUnixSlash(Chaine: string): string;
begin
  if Chaine[length(Chaine)] <> '/' then result:= Chaine + '/'
  else result := Chaine;
end;

function FormateTailleFichier(Bytes: dword): string;
begin
  result:= format('%d %s', [Bytes, '']);
end;

function FileTimeToDateTime(FileTime: TFileTime): TDateTime;
{
  Snaffled from UseNet, so don't whine about the hard-coded magic numbers.
  It does what it's supposed to :)
}
begin
  result := (Comp(FileTime) / 8.64E11) - 109205.0
end;

function RepPrecedentWindows(Repertoire: string):string;
var
  Long: integer;
begin
  Long:= length(Repertoire);
  // Suppression des caracteres apres le '\'
  while (copy(Repertoire,long,1)<>'\') and (Long>0) do
  begin
    delete(Repertoire,Long,1);
    dec(Long);
  end;
  // Suppression du '\'
  if Long>0 then
  begin
    delete(Repertoire,Long,1);
    dec(Long);
  end;
  // Recherche du '\' precedent
  while (copy(Repertoire,long,1)<>'\') and (Long>0) do
  begin
    delete(Repertoire,Long,1);
    dec(Long);
  end;
  result:= Repertoire;
end;

function RepPrecedentUnix(Repertoire: string):string;
var
  Long: integer;
begin
  Long:= length(Repertoire);
  // Suppression des caracteres apres le '/'
  while (copy(Repertoire,long,1)<>'/') and (Long>0) do
  begin
    delete(Repertoire,Long,1);
    dec(Long);
  end;
  // Suppression du '/'
  if Long>0 then
  begin
    delete(Repertoire,Long,1);
    dec(Long);
  end;
  // Recherche du '/' precedent
  while (copy(Repertoire,long,1)<>'/') and (Long>0) do
  begin
    delete(Repertoire,Long,1);
    dec(Long);
  end;
  result:= Repertoire;
end;

function GetShellInfo(const FileName: string;
  dwFileAttributes: DWORD): TSHFileInfo;
begin
  SHGetFileInfo(PChar(FileName), dwFileAttributes, result, SizeOf(TSHFileInfo),
    SHGFI_SYSICONINDEX or SHGFI_USEFILEATTRIBUTES);
end;

function GetRepertoireWindows :string;
{Pour obtenir le repertoire de Windows}
var
  Repertoire: array [0..MAX_PATH] of char;
begin
  if GetSystemDirectory (Repertoire,SizeOf(Repertoire))<>0 then
    Result:=String(Repertoire);
end;

end.
