unit Preferences;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, IniFiles, JvEdit, JvSpin;

type
  RecPreferences = record
                     SauveFenetre: boolean;
                     SauveLangue: boolean;
                     SauveRepLocal: boolean;
                     SauveDistant: boolean;
                     TimeOut: integer;
                   end;
  TFPreferences = class(TForm)
    PnlBas: TPanel;
    BtnOk: TButton;
    BtnAnnule: TButton;
    PnlGeneral: TPanel;
    GBSauver: TGroupBox;
    ChBWindow: TCheckBox;
    ChBLangue: TCheckBox;
    ChBRepLocal: TCheckBox;
    ChBHost: TCheckBox;
    JvSpinEditTimeOut: TJvSpinEdit;
    LblTimeout: TLabel;
    procedure FormShow(Sender: TObject);
  private
    { Dclarations prives }
  public
    { Dclarations publiques }
    procedure LitPreferences;
    procedure EcritPreferences(Top,Left,Height,Width: integer;
      Langue,RepLocal,Distant: string);
    procedure GetFenetre(var Top,Left,Height,Width: integer);
    function GetLangue: string;
    function GetRepLocal: string;
    function GetDistant: string;
    function Execute: boolean;
  end;

const
  NomFichierPref= 'sftp.ini';
var
  FPreferences: TFPreferences;
  Pref: RecPreferences;

implementation

{$R *.DFM}

uses Utilitaires, Main;

const
  SectionSauve= 'Save';
  CleFenetre= 'Window';
  CleLangue= 'Language';
  CleRepLocal= 'LocalDir';
  CleDistant= 'Host';
  CleTimeOut= 'TimeOut';
  SectionFenetre= 'Window';
  CleTop= 'Top';
  CleLeft= 'Left';
  CleHeight= 'Height';
  CleWidth= 'Width';
  SectionEtat= 'Status';


{*****************************************************************************}
{ Fonctions de la fiche                                                       }
{*****************************************************************************}

procedure TFPreferences.FormShow(Sender: TObject);
begin
  Caption:= EpureTexte(FPrincipale.MenuPrincipal.Items[1].Items[4].Caption);
  with Pref do
    begin
      ChBWindow.Checked := SauveFenetre;
      ChBLangue.Checked := SauveLangue;
      ChBRepLocal.Checked := SauveRepLocal;
      ChBHost.Checked := SauveDistant;
      JvSpinEditTimeOut.Value:= TimeOut;
    end;
end;

{*****************************************************************************}
{ Fonctions privee                                                            }
{*****************************************************************************}

{*****************************************************************************}
{ Fonctions public                                                            }
{*****************************************************************************}

procedure TFPreferences.LitPreferences;
var
  FichierPref: TIniFile;
begin
  FichierPref:= TIniFile.Create(RepAppli+NomFichierPref);
  with Pref do
  begin
    SauveFenetre:= FichierPref.ReadBool(SectionSauve,CleFenetre,false);
    SauveLangue:= FichierPref.ReadBool(SectionSauve,CleLangue,true);
    SauveRepLocal:= FichierPref.ReadBool(SectionSauve,CleRepLocal,false);
    SauveDistant:= FichierPref.ReadBool(SectionSauve,CleDistant,false);
    TimeOut:= FichierPref.ReadInteger(SectionSauve,CleTimeout,180);
  end;
end;

procedure TFPreferences.EcritPreferences(Top,Left,Height,Width: integer;
  Langue,RepLocal,Distant: string);
var
  FichierPref: TIniFile;
begin
  FichierPref:= TIniFile.Create(RepAppli+NomFichierPref);
  with Pref do
  begin
    FichierPref.WriteBool(SectionSauve,CleFenetre,SauveFenetre);
    FichierPref.WriteBool(SectionSauve,CleLangue,SauveLangue);
    FichierPref.WriteBool(SectionSauve,CleRepLocal,SauveRepLocal);
    FichierPref.WriteBool(SectionSauve,CleDistant,SauveDistant);
    FichierPref.WriteInteger(SectionSauve,CleTimeOut,TimeOut);
  end;
  if Pref.SauveFenetre then
  begin
    FichierPref.WriteInteger(SectionFenetre,CleTop,Top);
    FichierPref.WriteInteger(SectionFenetre,CleLeft,Left);
    FichierPref.WriteInteger(SectionFenetre,CleHeight,Height);
    FichierPref.WriteInteger(SectionFenetre,CleWidth,Width);
  end;
  if Pref.SauveLangue then
     FichierPref.WriteString(SectionEtat,CleLangue,Langue);
  if Pref.SauveRepLocal then
     FichierPref.WriteString(SectionEtat,CleRepLocal,RepLocal);
  if Pref.SauveDistant then
     FichierPref.WriteString(SectionEtat,CleDistant,Distant);
end;

procedure TFPreferences.GetFenetre(var Top,Left,Height,Width: integer);
var
  FichierPref: TIniFile;
begin
  FichierPref:= TIniFile.Create(RepAppli+NomFichierPref);
  Top:= FichierPref.ReadInteger(SectionFenetre,CleTop,Top);
  Left:= FichierPref.ReadInteger(SectionFenetre,CleLeft,Left);
  Height:= FichierPref.ReadInteger(SectionFenetre,CleHeight,Height);
  Width:= FichierPref.ReadInteger(SectionFenetre,CleWidth,Width);
end;

function TFPreferences.GetLangue: string;
var
  FichierPref: TIniFile;
begin
  if Pref.SauveLangue then
  begin
    FichierPref:= TIniFile.Create(RepAppli+NomFichierPref);
    result:= FichierPref.ReadString(SectionEtat,CleLangue,LangueRef);
  end
  else result:= LangueRef;
end;

function TFPreferences.GetRepLocal: string;
var
  FichierPref: TIniFile;
begin
  if Pref.SauveRepLocal then
  begin
    FichierPref:= TIniFile.Create(RepAppli+NomFichierPref);
    result:= FichierPref.ReadString(SectionEtat,CleRepLocal,RepAppli);
  end
  else result:= RepAppli;
end;

function TFPreferences.GetDistant: string;
var
  FichierPref: TIniFile;
begin
  if Pref.SauveDistant then
  begin
    FichierPref:= TIniFile.Create(RepAppli+NomFichierPref);
    result:= FichierPref.ReadString(SectionEtat,CleDistant,'');
  end
  else result:= '';
end;

function TFPreferences.Execute: boolean;
begin
  if ShowModal= mrOk then
  begin
    with Pref do
    begin
      SauveFenetre:= ChBWindow.Checked;
      SauveLangue:= ChBLangue.Checked;
      SauveRepLocal:= ChBRepLocal.Checked;
      SauveDistant:= ChBHost.Checked;
      TimeOut:= round(JvSpinEditTimeOut.Value);
    end;
    result:= true;
  end
  else result:= false;
end;

end.
