unit Parser;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, ImgList, ToolWin, Buttons, ExtCtrls, Menus, IniFiles, ShellApi;

type
  TMode = (Nouv,Edt,Cp,Del);

  Analyseur = record
                LeNom: string;
                LaLongFixe: boolean;
                LeDebut: longint;
                LaFin: longint;
                LePremNom: longint;
                LeDerNom: longint;
                LePremTaille: longint;
                LeDerTaille: longint;
                LePremDate: longint;
                LeDerDate: longint;
                LePremAttribut: longint;
                LeDerAttribut: longint;
              end;

  TFParser = class(TForm)
    PnlBas: TPanel;
    BtnOk: TButton;
    BtnAnnule: TButton;
    PnlInterrogation: TPanel;
    REReponse: TRichEdit;
    LBDetect: TListBox;
    BtnInterroge: TButton;
    PnlParse: TPanel;
    LSauteDebut: TLabel;
    LSauteFin: TLabel;
    LNom: TLabel;
    LTaille: TLabel;
    LDate: TLabel;
    LAttribut: TLabel;
    LvTempo: TListView;
    ESauteDebut: TEdit;
    ESauteFin: TEdit;
    EPremNom: TEdit;
    EDerNom: TEdit;
    EPremTaille: TEdit;
    EDerTaille: TEdit;
    EPremDate: TEdit;
    EDerDate: TEdit;
    EPremAttribut: TEdit;
    EDerAttribut: TEdit;
    PnlHaut: TPanel;
    LAnalyseur: TLabel;
    CBAnalyseur: TComboBox;
    ESite: TEdit;
    LSite: TLabel;
    L1: TLabel;
    L2: TLabel;
    L3: TLabel;
    L4: TLabel;
    PMSauver: TPopupMenu;
    Sauver: TMenuItem;
    SDlgSauver: TSaveDialog;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    SBtnParse: TSpeedButton;
    ChBLongueurFixe: TCheckBox;
    OpenDialog: TOpenDialog;
    procedure ESauteDebutKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure ESauteDebutKeyPress(Sender: TObject; var Key: Char);
    procedure LBDetectClick(Sender: TObject);
    procedure EPremNomDragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure EPremNomDragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure EDerNomDragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure EPremTailleDragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure EDerTailleDragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure EPremDateDragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure EDerDateDragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure EPremAttributDragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure EDerAttributDragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure BtnInterrogeClick(Sender: TObject);
    procedure CBAnalyseurChange(Sender: TObject);
    procedure ChBLongueurFixeClick(Sender: TObject);
    procedure ESauteDebutChange(Sender: TObject);
    procedure ESauteFinChange(Sender: TObject);
    procedure EPremNomChange(Sender: TObject);
    procedure EDerNomChange(Sender: TObject);
    procedure EPremTailleChange(Sender: TObject);
    procedure EDerTailleChange(Sender: TObject);
    procedure EPremDateChange(Sender: TObject);
    procedure EDerDateChange(Sender: TObject);
    procedure EPremAttributChange(Sender: TObject);
    procedure EDerAttributChange(Sender: TObject);
    procedure SBtnParseClick(Sender: TObject);
    procedure BtnOkClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure SauverClick(Sender: TObject);
  private
    { Dclarations prives }
    LeMode: TMode;
    LeParser: Analyseur;

    procedure RechercheBornes(Ligne: string);
    procedure DisplayBornes(Def: string;Ligne: string);
    procedure ChercheDebutFinBornes(Ligne: string);

    procedure NombreDeTokens(Ligne: string);
    procedure DisplayToken(Def: string;Ligne: string);
    procedure ChercheDebutFinDelimiteur(Ligne: string);

    procedure Modifiable(Autorise: boolean);
    procedure EcritParser(Numero: longint);
    procedure SupprimeParser(Numero: longint);
    procedure AfficheParser;
    procedure ParseFixe(Source:TStrings;
      Parser: Analyseur;var Destination:TListView);
    procedure ParseDelimiteur(Source:TStrings;
      Parser: Analyseur;var Destination:TListView);
  public
    { Dclarations publiques }
    function LitNomParser: boolean;
    function NumParser(Nom: string): longint;
    function NombreParser: longint;
    procedure LitParser(Nom: string;var UnParser: Analyseur);
    procedure SetUtilise(Nom: string);
    function GetListeParser: TStrings ;
    procedure Parse(Source:TStrings;Parser: Analyseur;var Destination:TListView);
    function Execute(Mode: TMode): boolean;
  end;

const
  NomParserInconnu= '????????';
  NomFichierParser= 'parser.ini';

var
  FParser: TFParser;

implementation

{$R *.DFM}

uses Utilitaires, ChoixNomParser, Alertes, Main;
// Le numero du parser lors des lectures/ecriture est a base 0

const
  SectionParser= 'Parsers';
  CleLongFixe= 'FixedLength';
  CleSauteDebut= 'LineSkipStart';
  CleSauteFin= 'LineSkipEnd';
  ClePremNom= 'NameFirst';
  CleDerNom= 'NameLast';
  ClePremTaille= 'SizeFirst';
  CleDerTaille= 'SizeLast';
  ClePremDate= 'DateFirst';
  CleDerDate= 'DateLast';
  ClePremAttribut= 'AttributFirst';
  CleDerAttribut= 'AttributLast';
  NbMax= 999;
var
  ParserUtilise: string;

{*****************************************************************************}
{ Fonctions de la fiche                                                       }
{*****************************************************************************}

procedure TFParser.ESauteDebutKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key = VK_RETURN then perform(WM_NEXTDLGCTL,0,0);
end;

procedure TFParser.ESauteDebutKeyPress(Sender: TObject; var Key: Char);
begin
  if not (Key in [#8,'0'..'9']) then Key:= #0;
  if key=#13 then key:= #0;
end;

procedure TFParser.LBDetectClick(Sender: TObject);
var
  Chaine: string;
begin
  if LBDetect.Items.Count>0 then
  begin
    Chaine:=REReponse.lines[StrToInt(ESauteDebut.Text)];
    if LeParser.LaLongFixe then
      DisplayBornes(LBDetect.Items[LBDetect.ItemIndex],Chaine)
    else
      DisplayToken(LBDetect.Items[LBDetect.ItemIndex],Chaine);
  end;
end;
procedure TFParser.EPremNomDragOver(Sender, Source: TObject; X, Y: Integer;
  State: TDragState; var Accept: Boolean);
begin
  Accept:=(Source = LBDetect);
end;

procedure TFParser.EPremNomDragDrop(Sender, Source: TObject; X,
  Y: Integer);
var
  Chaine: string;
  N: longint;
begin
  Chaine:= LBDetect.Items[LBDetect.ItemIndex];
  if LeParser.LaLongFixe then
  begin
    N:= pos(',',Chaine);
    EPremNom.Text:= copy(Chaine,1,N-1);
  end
  else EPremNom.Text:= Chaine;
  EDerNom.Text:= IntToStr(NbMax);
end;

procedure TFParser.EDerNomDragDrop(Sender, Source: TObject; X,
  Y: Integer);
var
  Chaine: string;
  N: longint;
begin
  Chaine:= LBDetect.Items[LBDetect.ItemIndex];
  if LeParser.LaLongFixe then
  begin
    N:= pos(',',Chaine);
    delete(Chaine,1,N);
    EDerNom.Text:= Chaine;
  end
  else EDerNom.Text:= Chaine;
end;

procedure TFParser.EPremTailleDragDrop(Sender, Source: TObject; X,
  Y: Integer);
var
  Chaine: string;
  N: longint;
begin
  Chaine:= LBDetect.Items[LBDetect.ItemIndex];
  if LeParser.LaLongFixe then
  begin
    N:= pos(',',Chaine);
    EPremTaille.Text:= copy(Chaine,1,N-1);
    delete(Chaine,1,N);
    EDerTaille.Text:= Chaine;
  end
  else
  begin
    EPremTaille.Text:= Chaine;
    EDerTaille.Text:= Chaine;
  end;
end;

procedure TFParser.EDerTailleDragDrop(Sender, Source: TObject; X,
  Y: Integer);
var
  Chaine: string;
  N: longint;
begin
  Chaine:= LBDetect.Items[LBDetect.ItemIndex];
  if LeParser.LaLongFixe then
  begin
    N:= pos(',',Chaine);
    delete(Chaine,1,N);
    EDerTaille.Text:= Chaine;
  end
  else EDerTaille.Text:= Chaine;
end;

procedure TFParser.EPremDateDragDrop(Sender, Source: TObject; X,
  Y: Integer);
var
  Chaine: string;
  N: longint;
begin
  Chaine:= LBDetect.Items[LBDetect.ItemIndex];
  if LeParser.LaLongFixe then
  begin
    N:= pos(',',Chaine);
    EPremDate.Text:= copy(Chaine,1,N-1);
    delete(Chaine,1,N);
    EDerDate.Text:= Chaine;
  end
  else
  begin
    EPremDate.Text:= Chaine;
    EDerDate.Text:= Chaine;
  end;
end;

procedure TFParser.EDerDateDragDrop(Sender, Source: TObject; X,
  Y: Integer);
var
  Chaine: string;
  N: longint;
begin
  Chaine:= LBDetect.Items[LBDetect.ItemIndex];
  if LeParser.LaLongFixe then
  begin
    N:= pos(',',Chaine);
    delete(Chaine,1,N);
    EDerDate.Text:= Chaine;
  end
  else EDerDate.Text:= Chaine;
end;

procedure TFParser.EPremAttributDragDrop(Sender, Source: TObject; X,
  Y: Integer);
var
  Chaine: string;
  N: longint;
begin
  Chaine:= LBDetect.Items[LBDetect.ItemIndex];
  if LeParser.LaLongFixe then
  begin
    N:= pos(',',Chaine);
    EPremAttribut.Text:= copy(Chaine,1,N-1);
    delete(Chaine,1,N);
    EDerAttribut.Text:= Chaine;
  end
  else
  begin
    EPremAttribut.Text:= Chaine;
    EDerAttribut.Text:= Chaine;
  end;
end;

procedure TFParser.EDerAttributDragDrop(Sender, Source: TObject; X,
  Y: Integer);
var
  Chaine: string;
  N: longint;
begin
  Chaine:= LBDetect.Items[LBDetect.ItemIndex];
  if LeParser.LaLongFixe then
  begin
    N:= pos(',',Chaine);
    delete(Chaine,1,N);
    EDerAttribut.Text:= Chaine;
  end
  else EDerAttribut.Text:= Chaine;
end;

procedure TFParser.BtnInterrogeClick(Sender: TObject);
var
  N: longint;
  Chaine: string;
begin
  LvTempo.Items.Clear;

  FPrincipale.ExecuteCmd(FPrincipale.FtpClient.Syst);
  Chaine:= FPrincipale.FtpClient.LastResponse;
  N:= StrToInt(trim(copy(Chaine,1,4)));
  delete(Chaine,1,4);
  if N=215 then ESite.Text:= Chaine
           else ESite.Text:= '';

  FPrincipale.ExecuteCmd(FPrincipale.FtpClient.Dir);
  REReponse.Lines.LoadFromFile(TmpFile);

//  if OpenDialog.Execute then REReponse.Lines.LoadFromFile(OpenDialog.Filename);
  N:=REReponse.Lines.Count;
  if N > 0 then
  begin
    if N > 1 then N:= N div 2;
    Chaine:= REReponse.Lines[N];
    if LeParser.LaLongFixe then
    begin
      RechercheBornes(Chaine);
      if LeMode=Nouv then ChercheDebutFinBornes(Chaine);
    end
    else
    begin
      NombreDeTokens(Chaine);
      if LeMode=Nouv then ChercheDebutFinDelimiteur(Chaine);
    end;
  end;
end;

procedure TFParser.CBAnalyseurChange(Sender: TObject);
begin
  LitParser(CBAnalyseur.Items[CBAnalyseur.ItemIndex], LeParser);
  AfficheParser;
end;

procedure TFParser.ChBLongueurFixeClick(Sender: TObject);
begin
  LeParser.LaLongFixe:= (ChBLongueurFixe.State = cbChecked);
end;

procedure TFParser.ESauteDebutChange(Sender: TObject);
begin
  LeParser.LeDebut:= StrToInt(ESauteDebut.Text);
end;

procedure TFParser.ESauteFinChange(Sender: TObject);
begin
  LeParser.LaFin:= StrToInt(ESauteFin.Text);
end;

procedure TFParser.EPremNomChange(Sender: TObject);
begin
  LeParser.LePremNom:= StrToInt(EPremNom.Text);
end;

procedure TFParser.EDerNomChange(Sender: TObject);
begin
  LeParser.LeDerNom:= StrToInt(EDerNom.Text);
end;

procedure TFParser.EPremTailleChange(Sender: TObject);
begin
  LeParser.LePremTaille:= StrToInt(EPremTaille.Text);
end;

procedure TFParser.EDerTailleChange(Sender: TObject);
begin
  LeParser.LeDerTaille:= StrToInt(EDerTaille.Text);
end;

procedure TFParser.EPremDateChange(Sender: TObject);
begin
  LeParser.LePremDate:= StrToInt(EPremDate.Text);
end;

procedure TFParser.EDerDateChange(Sender: TObject);
begin
  LeParser.LeDerDate:= StrToInt(EDerDate.Text);
end;

procedure TFParser.EPremAttributChange(Sender: TObject);
begin
  LeParser.LePremAttribut:= StrToInt(EPremAttribut.Text);
end;

procedure TFParser.EDerAttributChange(Sender: TObject);
begin
  LeParser.LeDerAttribut:= StrToInt(EDerAttribut.Text);
end;

procedure TFParser.SBtnParseClick(Sender: TObject);
begin
  Parse(REReponse.Lines,LeParser,LvTempo);
end;

procedure TFParser.BtnOkClick(Sender: TObject);
begin
  ModalResult:= mrNone;
  if (LeMode= Del) and
     (CBAnalyseur.Items[CBAnalyseur.ItemIndex]= ParserUtilise)   then
  begin
    CBAnalyseur.SetFocus;
    BoiteMessage(57,'','');
  end
  else
  if ESauteDebut.Text= '' then
  begin
    ESauteDebut.SetFocus;
    BoiteMessage(56,'','');
  end
  else
  if ESauteFin.Text= '' then
  begin
    ESauteFin.SetFocus;
    BoiteMessage(56,'','');
  end
  else
  if EPremNom.Text= '' then
  begin
    EPremNom.SetFocus;
    BoiteMessage(56,'','');
  end
  else
  if EDerNom.Text= '' then
  begin
    EDerNom.SetFocus;
    BoiteMessage(56,'','');
  end
  else
  if EPremTaille.Text= '' then
  begin
    EPremTaille.SetFocus;
    BoiteMessage(56,'','');
  end
  else
  if EDerTaille.Text= '' then
  begin
    EDerTaille.SetFocus;
    BoiteMessage(56,'','');
  end
  else
  if EPremDate.Text= '' then
  begin
    EPremDate.SetFocus;
    BoiteMessage(56,'','');
  end
  else
  if EDerDate.Text= '' then
  begin
    EDerDate.SetFocus;
    BoiteMessage(56,'','');
  end
  else ModalResult:= mrOk;
end;

procedure TFParser.FormCreate(Sender: TObject);
begin
  SDlgSauver.InitialDir:= RepAppli;
end;

procedure TFParser.FormShow(Sender: TObject);
begin
  case LeMode of
    Nouv : begin
             CBAnalyseur.Enabled:= false;
             Caption:= L1.Caption;
             Modifiable(true);
             ESauteDebut.SetFocus;
           end;
    Edt  : begin
             CBAnalyseur.Enabled:= true;
             Caption:= L2.Caption;
             Modifiable(true);
             CBAnalyseur.SetFocus;
           end;
    Cp   : begin
             CBAnalyseur.Enabled:= false;
             Caption:= L3.Caption;
             Modifiable(true);
             ESauteDebut.SetFocus;
           end;
    Del  : begin
             CBAnalyseur.Enabled:= true;
             Caption:= L4.Caption;
             Modifiable(false);
           end;
  end;
end;

{*****************************************************************************}
{ Fonctions privee                                                            }
{*****************************************************************************}
// Ligne = chaine de longueur fixe
procedure TFParser.RechercheBornes(Ligne: string);
var
  Premier: longint;
  Dernier: longint;
  Compte: longint;
  Max: longint;
begin
  LBDetect.Items.Clear;
  Premier:= 1;
  Max:= length(Ligne);
  Compte:= 1;
  while Compte<Max do
  begin
    Dernier:= Premier-1;
    while (Ligne[Compte]=' ')and(Compte<=Max) do
    begin
      inc(Dernier);
      inc(Compte);
    end;
    while (Ligne[Compte]<>' ')and(Compte<=Max) do
    begin
      inc(Dernier);
      inc(Compte);
    end;
    if Compte= Max then Dernier:= NbMax
    else if trim(copy(Ligne,Compte,length(Ligne)))='' then Dernier:= NbMax;
    LBDetect.Items.Add(IntToStr(Premier)+','+IntToStr(Dernier));
    Premier:= Compte;
  end;
end;

procedure TFParser.DisplayBornes(Def: string;Ligne: string);
var
  Premier: longint;
  Dernier: longint;
  Longueur: longint;
  M, N: longint;
  Debut: longint;
begin
  N:= pos(',',Def);
  Premier:=StrToInt(copy(Def,1,N-1));
  delete(Def,1,N);
  Dernier:= StrToInt(Def);
  if Dernier = NbMax then Longueur:= length(Ligne)-Premier+1
                     else Longueur:= Dernier-Premier+1;
  Debut:= StrToInt(ESauteDebut.Text);
  M:= SendMessage(REReponse.Handle,EM_LINEINDEX,Debut,0);
  N:= SendMessage(REReponse.Handle,EM_LINEINDEX,Debut+1,0);
  if Premier>(N-M) then Premier:=N-M;
  REReponse.SelStart:= M+Premier-1;
  REReponse.SelLength:= Longueur;
  REReponse.SetFocus;
end;

procedure TFParser.ChercheDebutFinBornes(Ligne: string);
var
  N: longint;
  Nombre: longint;
  Ref: longint;

  function LongueurPremier(Chaine: string): longint;
  var
    N: longint;
    Long: longint;
  begin
    Long:= length(Chaine);
    if Long>0 then
    begin
      N:= 1;
      while (Chaine[N]=' ') and (N<=Long) do inc(N);
      if N <= Long then
        while (Chaine[N]<>' ') and (N<=Long) do inc(N);
      Result:= N;
    end
    else Result:= 0;
  end;

begin
  Ref:= LongueurPremier(Ligne);
  Nombre:= REReponse.Lines.Count-1;
  N:= 0;
  while (N<Nombre) and (LongueurPremier(REReponse.Lines[N])<> Ref) do inc(N);
  ESauteDebut.Text:= IntToStr(N);
  N:= 0;
  while (N<Nombre) and (LongueurPremier(REReponse.Lines[Nombre-N])<> Ref) do inc(N);
  ESauteFin.text:= IntToStr(N);
end;

// Ligne divise grce au sparateur
procedure TFParser.NombreDeTokens(Ligne: string);
var
  Nombre: longint;
  N: longint;
  Long: longint;
begin
  LBDetect.Items.Clear;
  Nombre:= 0;
  Long:= length(Ligne);
  N:= 1;
  while N <= Long do
  begin
    inc(Nombre);
    while (Ligne[N]=' ') and (N<=Long) do inc(N);
    if N <= Long then
    begin
      while (Ligne[N]<>' ') and (N<=Long) do inc(N);
    end;
  end;
  for N:= 1 to Nombre do LBDetect.Items.Add(IntToStr(N));
end;

procedure TFParser.DisplayToken(Def: string;Ligne: string);
var
  Num: longint;
  Nombre: longint;
  M, N: longint;
  Long: longint;
  Debut: longint;
  Premier: longint;
  Longueur: longint;
begin
  Num:= StrToInt(Def);
  Long:= length(Ligne);
  Premier:= 1;
  Longueur:= 0;
  Nombre:= 0;
  N:= 1;
  while (Nombre<Num) and (N<=Long) do
  begin
    inc(Nombre);
    while (Ligne[N]=' ') and (N<=Long) do inc(N);
    if N <= Long then
    begin
      while (Ligne[N]<>' ') and (N<=Long) do inc(N);
    end;
    if Nombre=(Num-1) then Premier:= N+1;
    if Nombre=Num then Longueur:= N-Premier+1;
  end;
  Debut:= StrToInt(ESauteDebut.Text);
  M:= SendMessage(REReponse.Handle,EM_LINEINDEX,Debut,0);
  N:= SendMessage(REReponse.Handle,EM_LINEINDEX,Debut+1,0);
  if Premier>(N-M) then Premier:=N-M;
  REReponse.SelStart:= M+Premier-1;
  REReponse.SelLength:= Longueur;
  REReponse.SetFocus;
end;

procedure TFParser.ChercheDebutFinDelimiteur(Ligne: string);
var
  N: longint;
  Nombre: longint;
  Ref: longint;

  function LongueurPremier(Chaine: string): longint;
  var
    N: longint;
    Long: longint;
  begin
    Long:= length(Chaine);
    if Long>0 then
    begin
      N:= 1;
      while (Chaine[N]=' ') and (N<=Long) do inc(N);
      if N <= Long then
        while (Chaine[N]<>' ') and (N<=Long) do inc(N);
      Result:= N;
    end
    else Result:= 0;
  end;

begin
  Ref:= LongueurPremier(Ligne);
  Nombre:= REReponse.Lines.Count-1;
  N:= 0;
  while (N<Nombre) and (LongueurPremier(REReponse.Lines[N])<> Ref) do inc(N);
  ESauteDebut.Text:= IntToStr(N);
  N:= 0;
  while (N<Nombre) and (LongueurPremier(REReponse.Lines[Nombre-N])<> Ref) do inc(N);
  ESauteFin.text:= IntToStr(N);
end;

// Autorise ou non la modification du parser
procedure TFParser.Modifiable(Autorise: boolean);
begin
  SBtnParse.Enabled:= Autorise;
  ChBLongueurFixe.Enabled:= Autorise;
  ESauteDebut.Enabled:= Autorise;
  ESauteFin.Enabled:= Autorise;
  EPremNom.Enabled:= Autorise;
  EDerNom.Enabled:= Autorise;
  EPremTaille.Enabled:= Autorise;
  EDerTaille.Enabled:= Autorise;
  EPremDate.Enabled:= Autorise;
  EDerDate.Enabled:= Autorise;
  ESite.Enabled:= Autorise;
  LBDetect.Enabled:= Autorise;
  BtnInterroge.Enabled:= Autorise and FPrincipale.FtpClient.Connected;
end;

// Routine de gestion des parsers
procedure TFParser.EcritParser(Numero: longint);
var
  FichierParser: TIniFile;
  N: longint;
begin
  FichierParser:= TIniFile.Create(RepAppli+NomFichierParser);
  // Trie et enregistrement des nom de parser
  CBAnalyseur.Sorted:= true;
  for N:= 1 to CBAnalyseur.Items.Count do
  begin
    FichierParser.WriteString(SectionParser,
      'Name'+IntToStr(N-1),CBAnalyseur.Items[N-1]);
  end;
  CBAnalyseur.Sorted:= false;
  // Sauvegarde du parser
  with LeParser do
  begin
    FichierParser.WriteBool(LeNom,CleLongFixe,LaLongFixe);
    FichierParser.WriteInteger(LeNom,CleSauteDebut,LeDebut);
    FichierParser.WriteInteger(LeNom,CleSauteFin,LaFin);
    FichierParser.WriteInteger(LeNom,ClePremNom,LePremNom);
    FichierParser.WriteInteger(LeNom,CleDerNom,LeDerNom);
    FichierParser.WriteInteger(LeNom,ClePremTaille,LePremTaille);
    FichierParser.WriteInteger(LeNom,CleDerTaille,LeDerTaille);
    FichierParser.WriteInteger(LeNom,ClePremDate,LePremDate);
    FichierParser.WriteInteger(LeNom,CleDerDate,LeDerDate);
    FichierParser.WriteInteger(LeNom,ClePremAttribut,LePremAttribut);
    FichierParser.WriteInteger(LeNom,CleDerAttribut,LeDerAttribut);
  end;
  FichierParser.Free;
end;

procedure TFParser.SupprimeParser(Numero: longint);
var
  FichierParser: TIniFile;
  N: longint;
begin
  FichierParser:= TIniFile.Create(RepAppli+NomFichierParser);
  if FichierParser.SectionExists(LeParser.LeNom) then
     FichierParser.EraseSection(LeParser.LeNom);
  FichierParser.EraseSection(SectionParser);
  for N:= 0 to CBAnalyseur.Items.Count-1 do
    FichierParser.WriteString(SectionParser,'Name'+IntToStr(N),CBAnalyseur.Items[N]);
  FichierParser.Free;
end;

procedure TFParser.AfficheParser;
begin
  with LeParser do
  begin
    CBAnalyseur.Text:= LeNom;
    if LaLongFixe then ChBLongueurFixe.State:=cbChecked
                  else ChBLongueurFixe.State:=cbUnChecked;
    ESauteDebut.Text:= IntToStr(LeDebut);
    ESauteFin.Text:= IntToStr(LaFin);
    EPremNom.Text:= IntToStr(LePremNom);
    EDerNom.Text:= IntToStr(LeDerNom);
    EPremTaille.Text:= IntToStr(LePremtaille);
    EDerTaille.Text:= IntToStr(LeDerTaille);
    EPremDate.Text:= IntToStr(LePremDate);
    EDerDate.Text:= IntToStr(LeDerDate);
    EPremAttribut.Text:= IntToStr(LePremAttribut);
    EDerAttribut.Text:= IntToStr(LeDerAttribut);
  end;
end;

// Parser pour les lignes de longueur fixe
procedure TFParser.ParseFixe(Source:TStrings;
  Parser: Analyseur;var Destination:TListView);
var
  N: longint;
  Ligne: string;
  SauteDebut: longint;
  SauteFin: longint;
  Long: longint;
  UnNom: string;
  UneTaille: string;
  UneDate: string;
  UnAttribut: string;
  SFI: TSHFileInfo;
begin
  Destination.Items.Clear;
  SauteDebut:= Parser.LeDebut;
  SauteFin:= Parser.LaFin;
  for N:= (SauteDebut+1) to (Source.Count-SauteFin) do
  begin
    Ligne:= Source[N-1];
    UnNom:= '';
    UneTaille:= '';
    UneDate:= '';
    UnAttribut:= '';
    // decoupage du nom
    if Parser.LeDerNom=NbMax then Long:= length(Ligne)-Parser.LePremNom+1
      else Long:= Parser.LeDerNom-Parser.LePremNom+1;
    UnNom:= copy(Ligne,Parser.LePremNom,Long);
    // decoupage de la taille
    if Parser.LeDerTaille=NbMax then Long:= length(Ligne)-Parser.LePremTaille+1
      else Long:= Parser.LeDerTaille-Parser.LePremTaille+1;
    UneTaille := copy(Ligne,Parser.LePremTaille,Long);
    // decoupage de la date
    if Parser.LeDerDate=NbMax then Long:= length(Ligne)-Parser.LePremDate+1
      else Long:= Parser.LeDerDate-Parser.LePremDate+1;
    UneDate:= copy(Ligne,Parser.LePremDate,Long);
    // decoupage des attributs
    if Parser.LeDerAttribut=NbMax then Long:= length(Ligne)-Parser.LePremAttribut+1
      else Long:= Parser.LeDerAttribut-Parser.LePremAttribut+1;
    UnAttribut:= copy(Ligne,Parser.LePremAttribut,Long);
    UnAttribut:= lowercase(trim(UnAttribut));
    UnNom:= trim(UnNom);
    if (UnNom<>'.') and (UnNom<>'..') then
    begin
      with Destination.Items.Add do
      begin
        Caption:= UnNom;

        if (UnAttribut<>'') and (UnAttribut[1]= 'd') then
        begin
          ImageIndex := NumImgFolder;
        end
        else
        begin
          SFI := GetShellInfo(Caption,0);
          ImageIndex := SFI.iIcon;
        end;

        SubItems.Add(UneTaille);
        SubItems.Add(UneDate);
      end;
    end;
  end;
end;

// Parser pour les lignes a delimiteurs
procedure TFParser.ParseDelimiteur(Source:TStrings;
  Parser: Analyseur;var Destination:TListView);
var
  N: longint;
  Ligne: string;
  SauteDebut: longint;
  SauteFin: longint;
  Long: longint;
  M: longint;
  Numero: longint;
  Tmp: string;
  UnNom: string;
  UneTaille: string;
  UneDate: string;
  UnAttribut: string;
  SFI: TSHFileInfo;
begin
  Destination.Items.Clear;
  SauteDebut:= Parser.LeDebut;
  SauteFin:= Parser.LaFin;
  for N:= (SauteDebut+1) to (Source.Count-SauteFin) do
  begin
    Ligne:= Source[N-1];
    UnNom:= '';
    UneTaille:= '';
    UneDate:= '';
    UnAttribut:= '';
    // decoupage de la ligne
    Long:= length(Ligne);
    Numero:= 0;
    M:= 1;
    while M <= Long do
    begin
      inc(Numero);
      Tmp:= '';
      while (Ligne[M]=' ') and (M<=Long) do
      begin
        Tmp:= Tmp + Ligne[M];
        inc(M);
      end;
      if M <= Long then
      begin
        while (Ligne[M]<>' ') and (M<=Long) do
        begin
          Tmp:= Tmp + Ligne[M];
          inc(M);
        end;
      end;
      with Parser do
      begin
        if (Numero>=LePremNom) then
        begin
          if (LeDerNom= NbMax) or (Numero<=LeDerNom) then UnNom:= UnNom + Tmp;
        end;
        if (Numero>=LePremTaille) then
        begin
          if (LeDerTaille= NbMax) or (Numero<=LeDerTaille) then
            UneTaille:= UneTaille + Tmp;
        end;
        if (Numero>=LePremDate) then
        begin
          if (LeDerDate= NbMax) or (Numero<=LeDerDate) then UneDate:= UneDate + Tmp;
        end;
        if (Numero>=LePremAttribut) then
        begin
          if (LeDerAttribut= NbMax) or (Numero<=LeDerAttribut) then
            UnAttribut:= UnAttribut + Tmp;
        end;
      end;
    end;
    UnAttribut:= lowercase(trim(UnAttribut));
    UnNom:= trim(UnNom);
    if (UnNom<>'.') and (UnNom<>'..') then
    begin
      with Destination.Items.Add do
      begin
        Caption:= UnNom;

        if (UnAttribut<>'') and (UnAttribut[1]= 'd') then
        begin
          ImageIndex := NumImgFolder;
        end
        else
        begin
          SFI := GetShellInfo(Caption,0);
          ImageIndex := SFI.iIcon;
        end;

        SubItems.Add(UneTaille);
        SubItems.Add(UneDate);
      end;
    end;
  end;
end;

{*****************************************************************************}
{ Fonctions public                                                            }
{*****************************************************************************}

function TFParser.LitNomParser: boolean;
var
  FichierParser: TIniFile;
  Nom: string;
  N: longint;
begin
  result:= false;
  CBAnalyseur.Items.Clear;
  FichierParser:= TIniFile.Create(RepAppli+NomFichierParser);
  Nom:= FichierParser.ReadString(SectionParser,'Name0','');
  N:=1;
  while Nom > '' do
  begin
    CBAnalyseur.Items.Add(Nom);
    Nom:= FichierParser.ReadString(SectionParser,'Name' + IntToStr(N),'');
    inc(N);
  end;
  if CBAnalyseur.Items.Count>0 then result:= true;
end;

function TFParser.NumParser(Nom: string): longint;
begin
  result:= CBAnalyseur.Items.IndexOf(Nom);
end;

function TFParser.NombreParser: longint;
begin
  result:= CBAnalyseur.Items.Count;
end;

procedure TFParser.LitParser(Nom: string; var UnParser: Analyseur);
var
  FichierParser: TIniFile;
begin
  FichierParser:= TIniFile.Create(RepAppli+NomFichierParser);
  with UnParser do
  begin
    LeNom:= Nom;
    LaLongFixe:= FichierParser.ReadBool(LeNom,CleLongFixe,LaLongFixe);
    LeDebut:= FichierParser.ReadInteger(LeNom,CleSauteDebut,LeDebut);
    LaFin:= FichierParser.ReadInteger(LeNom,CleSauteFin,LaFin);
    LePremNom:= FichierParser.ReadInteger(LeNom,ClePremNom,LePremNom);
    LeDerNom:= FichierParser.ReadInteger(LeNom,CleDerNom,LeDerNom);
    LePremTaille:= FichierParser.ReadInteger(LeNom,ClePremTaille,LePremTaille);
    LeDerTaille:= FichierParser.ReadInteger(LeNom,CleDerTaille,LeDerTaille);
    LePremDate:= FichierParser.ReadInteger(LeNom,ClePremDate,LePremDate);
    LeDerDate:= FichierParser.ReadInteger(LeNom,CleDerDate,LeDerDate);
    LePremAttribut:= FichierParser.ReadInteger(LeNom,ClePremAttribut,LePremAttribut);
    LeDerAttribut:= FichierParser.ReadInteger(LeNom,CleDerAttribut,LeDerAttribut);
  end;
  FichierParser.Free;
end;

procedure TFParser.SetUtilise(Nom: string);
begin
  ParserUtilise:= Nom;
end;

function TFParser.GetListeParser: TStrings ;
begin
  result:= CBAnalyseur.Items;
end;

procedure TFParser.Parse(Source:TStrings;Parser: Analyseur;var Destination:TListView);
begin
  if Parser.LaLongFixe then ParseFixe(Source,Parser,Destination)
                       else ParseDelimiteur(Source,Parser,Destination);
end;

function TFParser.Execute(Mode: TMode): boolean;
var
  NomDest: string;
  Numero: longint;
begin
  result:= false;
  LeMode:= Mode;
  ESite.Text:= '';
  LvTempo.Items.Clear;
  REReponse.Lines.Clear;
  LBDetect.Items.Clear;
  CBAnalyseur.ItemIndex:= 0;
  case LeMode of
    Nouv : begin
             Numero:= -1;
             if FChoixNomParser.Execute(CBAnalyseur.Items,NomDest,Numero) then
             begin
               with LeParser do
               begin
                 LeNom:= NomDest;
                 LaLongFixe:= false;
                 LeDebut:= 0;
                 LaFin:= 0;
                 LePremNom:= 0;
                 LeDerNom:= 0;
                 LePremTaille:= 0;
                 LeDerTaille:= 0;
                 LePremDate:= 0;
                 LeDerDate:= 0;
                 LePremAttribut:= 0;
                 LeDerAttribut:= 0;
                 CBAnalyseur.Items.Add(LeNom);
                 CBAnalyseur.ItemIndex:= pred(CBAnalyseur.Items.Count);
               end;
               AfficheParser;
               if ShowModal= mrOk then
               begin
                 EcritParser(CBAnalyseur.ItemIndex);
                 result:= true;
               end
               else
               begin
                 with CBAnalyseur do
                 begin
                   Items.Delete(ItemIndex);
                   if ItemIndex > (Items.Count-1) then ItemIndex:= Items.Count-1;
                 end;
                 result:= false;
               end;
             end;
           end;
    Edt  : begin
             LitParser(CBAnalyseur.Items[CBAnalyseur.ItemIndex], LeParser);
             AfficheParser;
             if ShowModal= mrOk then
             begin
               EcritParser(CBAnalyseur.ItemIndex);
               result:= true;
             end
             else result:= false;
           end;
    Cp   : begin
             Numero:= CBAnalyseur.ItemIndex;
             if FChoixNomParser.Execute(CBAnalyseur.Items,NomDest,Numero) then
             begin
               LitParser(CBAnalyseur.Items[Numero], LeParser);
               with LeParser do
               begin
                 LeNom:= NomDest;
                 CBAnalyseur.Items.Add(LeNom);
                 CBAnalyseur.ItemIndex:= pred(CBAnalyseur.Items.Count);
               end;
               AfficheParser;
               if ShowModal= mrOk then
               begin
                 EcritParser(CBAnalyseur.ItemIndex);
                 result:= true;
               end
               else
               begin
                 with CBAnalyseur do
                 begin
                   Items.Delete(ItemIndex);
                   if ItemIndex > (Items.Count-1) then ItemIndex:= Items.Count-1;
                 end;
                 result:= false;
               end;
             end;
           end;
    Del  : begin
             if ShowModal= mrOk then
             begin
               with CBAnalyseur do
               begin
                 Items.Delete(ItemIndex);
                 SupprimeParser(ItemIndex);
                 if ItemIndex > (Items.Count-1) then ItemIndex:= Items.Count-1;
               end;
               result:= true;
             end
             else result:= false;
           end;
  end;
end;

procedure TFParser.SauverClick(Sender: TObject);
begin
  if SDlgSauver.Execute then
  begin
    REReponse.Lines.SaveToFile(SDlgSauver.FileName);
  end;
end;

end.
