unit Main;

/////////////////////////////////////////////////////////////
//                                                         //
//                     SFtp                                //
//      Transfert de fichiers utilisant FTP                //
//         Copyright (C) 2000 Alain JAFFRE                 //
/////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////
//                Update history                           //
//                                                         //
//  V0.1.0  Premiere version                               //
//  V0.2.0  Modification pour utilisation du composant     //
//            de Francois Piette en remplacement du        //
//            composant Netmaster qui pose probleme        //
//  V0.3.0  Ajout du transfert recursif bi-directionnel    //
//          Ajout de la gestion des preferences            //
//          Correction de la gestion interne des .ini      //
//            lors de la suppression d'un parser ou d'une  //
//            configuration (name n'etait pas recree)      //
//  V0.4.0  Correction bug dans le trie des fichiers par   //
//            taille et par date                           //
//          Ajout du choix de type de transmission binaire //
//            ou ascii                                     //
//          Ajout des boutons Recevoir et Envoyer          //
//          Modification de faon a trier en ordre alpha   //
//            les noms de machine distante et d'analyseur  //
//          Ajout du cryptage du mot de passe dans         //
//            host.ini                                     //
//          Ajout passage dans le rpertoire distant       //
//            configur pour la machine distante a la      //
//            connexion                                    //
//          Ajout de la reconnaissance des icones pour     //
//            les fichiers d'extension connue dans la      //
//            liste distante                               //
//          Ajout de la suppression recursive locale et    //
//            distante                                     //
//  V0.4.1  Correction pour les icones rpertoire distant  //
//            utilisation du numero d'icone du repertoire  //
//            windows                                      //
//  V0.4.2  Suppression du rpertoire RepDistant dans      //
//            l'opration de suppression d'un fichier      //
//            distant                                      //
//  V0.4.3  Correction un appui sur suppr lors de la       //
//            modification d'un nom de fichier declenchait //
//            la demande de suppression du fichier         //
//  V0.4.4  Correction :                                   //
//           Lors de l'echec de connection on envoyait une //
//           commande QUIT meme si l'on n'etait pas        //
//           connecte. Utilisation de ActDistantDeconnecter//
//           Reduction du timeout a 10 seconde apres debut //
//           de communication                              //
//           Lors d'une suppression recursive de repertoire//
//           la commande finale etait dele au lieu de rmd  //
//  V0.4.5  Correction:                                    //
//           Mauvaise detection icone repertoire due a une //
//           abscence d'initialisation de la structure     //
//           Donnees                                       //
//  V0.4.6  Modification:                                  //
//           Timeout des commandes rglable dans les       //
//           prfrences, richedit au lieu d'un mmo pour  //
//           l'historique des commandes.                   //
//                                                         //
/////////////////////////////////////////////////////////////
//              Autre composants utiliss                  //
//              Other components used                      //
//                                                         //
//  FtpClient: F.PIETTE                                    //
//    http://users.swing.be/francois.piette/index.html     //
//                                                         //
/////////////////////////////////////////////////////////////

{***************************************************************************}
{ Ce logiciel est un logiciel libre. Vous pouvez le diffuser et/ou le       }
{ modifier suivant les termes de la GNU General Public License telle que    }
{ publie par la Free Software Foundation, soit la version 2 de cette        }
{ license, soit ( votre convenance) une version ultrieure.                }
{                                                                           }
{ Ce programme est diffus dans l'espoir qu'il sera utile, mais SANS AUCUNE }
{ GARANTIE, sans mme une garantie implicite de COMMERCIALISABILITE ou      }
{ d'ADEQUATION A UN USAGE PARTICULIER. Voyez la GNU General Public License  }
{ pour plus de dtails.                                                     }
{                                                                           }
{ Vous devriez avoir reu une copie de la GNU General Public License avec   }
{ ce programme, sinon, veuillez crire  la Free Software Foundation, Inc., }
{ 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.                  }
{***************************************************************************}

{***************************************************************************}
{ This program is free software. You can redistribute it and/or modify it   }
{ under the terms of the GNU Public License as published by the             }
{ Free Software Foundation, either version 2 of the license, or             }
{ (at your option) any later version.                                       }
{                                                                           }
{ This program is distributed in the hope it will be useful, but WITHOUT    }
{ ANY WARRANTY, without even the implied warranty of MERCHANTABILITY or     }
{ FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for  }
{ more details.                                                             }
{                                                                           }
{ You should have received a copy of the GNU General Public License along   }
{ with this program, if not, write to the Free Software Foundation, Inc.,   }
{ 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.                  }
{***************************************************************************}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, ActnList, ImgList, ComCtrls, ExtCtrls, StdCtrls, ToolWin, FileCtrl,
  ShellApi, Ftpcli;

type
  TListItemType = (itFile, itFolder);
  TSyncCmd = function : boolean of object;

  TFPrincipale = class(TForm)
    IlAppli: TImageList;
    BarreEtat: TStatusBar;
    MenuPrincipal: TMainMenu;
    Fichier: TMenuItem;
    N1: TMenuItem;
    Outils: TMenuItem;
    Langues: TMenuItem;
    Francais: TMenuItem;
    Aide: TMenuItem;
    RubriqueAide: TMenuItem;
    Recherche: TMenuItem;
    N2: TMenuItem;
    ListeAction: TActionList;
    ActQuitter: TAction;
    ActAPropos: TAction;
    ActLocalLitRep: TAction;
    ActLocalRepPrecedent: TAction;
    ActLocalCreeRep: TAction;
    ActLocalChangeLecteur: TAction;
    ActLocalIcone: TAction;
    ActLocalListe: TAction;
    ActLocalDetail: TAction;
    Apropos: TMenuItem;
    Quitter: TMenuItem;
    ActRubriqueAide: TAction;
    ActRechercheAide: TAction;
    TBarPrincipale: TToolBar;
    SplitHorizontal: TSplitter;
    PnlLocal: TPanel;
    SplitVertical: TSplitter;
    PnlDistant: TPanel;
    PnlTitreLocal: TPanel;
    PnlTitreDistant: TPanel;
    TBarLocal: TToolBar;
    TBarDistant: TToolBar;
    PnlLocalRep: TPanel;
    PnlDistantRep: TPanel;
    LvLocal: TListView;
    ToolButton1: TToolButton;
    DCBLocal: TDriveComboBox;
    ToolButton2: TToolButton;
    TBtnLocalRepPrecedent: TToolButton;
    TBtnLocalCreeRep: TToolButton;
    ToolButton5: TToolButton;
    ToolButton6: TToolButton;
    TBtnLocalPetite: TToolButton;
    TBtnLocalListe: TToolButton;
    TBtnLocalDetail: TToolButton;
    ToolButton3: TToolButton;
    TBtnLocalRafraichit: TToolButton;
    ActDistantRepPrecedent: TAction;
    ActDistantCreeRep: TAction;
    ActDistantIcone: TAction;
    ActDistantListe: TAction;
    ActDistantDetail: TAction;
    ActDistantLitRep: TAction;
    ToolButton4: TToolButton;
    ToolButton8: TToolButton;
    TBtnDistantRepPrecedent: TToolButton;
    ToolButton10: TToolButton;
    TBtnDistantCreeRep: TToolButton;
    ToolButton12: TToolButton;
    TBtnDistantIcone: TToolButton;
    TBtnDistantListe: TToolButton;
    TBtnDistantDetail: TToolButton;
    ToolButton16: TToolButton;
    TBtnDistantRafraichit: TToolButton;
    LLocal: TLabel;
    LDistant: TLabel;
    CbMachineDistante: TComboBox;
    Machinelocale: TMenuItem;
    Machinesdistantes: TMenuItem;
    Preference: TMenuItem;
    TBtnConnexion: TToolButton;
    ActDistantConnecter: TAction;
    ActDistantDeconnecter: TAction;
    TBtnDeconnexion: TToolButton;
    Editer: TMenuItem;
    Copier: TMenuItem;
    Nouvelle: TMenuItem;
    N3: TMenuItem;
    Supprimer: TMenuItem;
    IlFichiers: TImageList;
    Analyseur: TMenuItem;
    NouveauAnalyseur: TMenuItem;
    EditerAnalyseur: TMenuItem;
    CopierAnalyseur: TMenuItem;
    N4: TMenuItem;
    SupprimerAnalyseur: TMenuItem;
    FtpClient: TFtpClient;
    PSysteme: TPanel;
    ESysteme: TEdit;
    DlgSauver: TSaveDialog;
    PopupMenu: TPopupMenu;
    Sauver: TMenuItem;
    Efface: TMenuItem;
    ToolButton7: TToolButton;
    TBtnBinaire: TToolButton;
    ToolButton9: TToolButton;
    ActLocalEnvoyer: TAction;
    ActLocalRecevoir: TAction;
    TBtnRecevoir: TToolButton;
    TBtnEnvoyer: TToolButton;
    LvDistant: TListView;
    RichEditCommande: TRichEdit;
  { Fiche }
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure CbMachineDistanteChange(Sender: TObject);{ Menu }
    procedure NouvelleClick(Sender: TObject);
    procedure EditerClick(Sender: TObject);
    procedure CopierClick(Sender: TObject);
    procedure SupprimerClick(Sender: TObject);
    procedure NouveauAnalyseurClick(Sender: TObject);
    procedure EditerAnalyseurClick(Sender: TObject);
    procedure CopierAnalyseurClick(Sender: TObject);
    procedure SupprimerAnalyseurClick(Sender: TObject);
  { LvLocal }
    procedure LvLocalColumnClick(Sender: TObject; Column: TListColumn);
    procedure LvLocalCompare(Sender: TObject; Item1, Item2: TListItem;
      Data: Integer; var Compare: Integer);
    procedure LvLocalDblClick(Sender: TObject);
    procedure LvLocalDragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure LvLocalDragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure LvLocalEdited(Sender: TObject; Item: TListItem;
      var S: String);
    procedure LvLocalEditing(Sender: TObject; Item: TListItem;
      var AllowEdit: Boolean);
    procedure LvLocalKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  { LvDistant}
    procedure LvDistantColumnClick(Sender: TObject; Column: TListColumn);
    procedure LvDistantCompare(Sender: TObject; Item1, Item2: TListItem;
      Data: Integer; var Compare: Integer);
    procedure LvDistantDblClick(Sender: TObject);
    procedure LvDistantDragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure LvDistantDragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure LvDistantEdited(Sender: TObject; Item: TListItem;
      var S: String);
    procedure LvDistantEditing(Sender: TObject; Item: TListItem;
      var AllowEdit: Boolean);
    procedure LvDistantKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  { Gestion du client Ftp }
    function ExecuteCmd(Cmd: TSyncCmd):boolean;
    procedure FtpClientCommand(Sender: TObject; var Cmd: String);
    procedure FtpClientDisplay(Sender: TObject; var Msg: String);
    procedure FtpClientRequestDone(Sender: TObject; RqType: TFtpRequest;
      Error: Word);
    procedure FtpClientSessionClosed(Sender: TObject; Error: Word);      
    procedure FtpClientSessionConnected(Sender: TObject; Error: Word);
    procedure FtpClientProgress(Sender: TObject; Count: Integer;
      var Abort: Boolean);
  { Actions }
    procedure ActQuitterExecute(Sender: TObject);
    procedure ActAProposExecute(Sender: TObject);
    procedure ActRubriqueAideExecute(Sender: TObject);
    procedure ActRechercheAideExecute(Sender: TObject);
    { Locales }
    procedure ActLocalRepPrecedentExecute(Sender: TObject);
    procedure ActLocalCreeRepExecute(Sender: TObject);
    procedure ActLocalIconeExecute(Sender: TObject);
    procedure ActLocalListeExecute(Sender: TObject);
    procedure ActLocalDetailExecute(Sender: TObject);
    procedure ActLocalLitRepExecute(Sender: TObject);
    procedure ActLocalChangeLecteurExecute(Sender: TObject);
    procedure ActLocalEnvoyerExecute(Sender: TObject);
    procedure ActLocalRecevoirExecute(Sender: TObject);
    { Distantes }
    procedure ActDistantRepPrecedentExecute(Sender: TObject);
    procedure ActDistantCreeRepExecute(Sender: TObject);
    procedure ActDistantIconeExecute(Sender: TObject);
    procedure ActDistantListeExecute(Sender: TObject);
    procedure ActDistantDetailExecute(Sender: TObject);
    procedure ActDistantLitRepExecute(Sender: TObject);
    procedure ActDistantConnecterExecute(Sender: TObject);
    procedure ActDistantDeconnecterExecute(Sender: TObject);
    procedure SauverClick(Sender: TObject);
    procedure EffaceClick(Sender: TObject);
    procedure PreferenceClick(Sender: TObject);
    procedure ActDistantDeconnecterUpdate(Sender: TObject);
  private
    { Dclarations prives }
    LastCmd: string;
    Editing: boolean; // Modification d'un nom de fichier
(*    function GetShellInfo(const FileName: string;
      dwFileAttributes: DWORD): TSHFileInfo;*)
    function GetListItemType(Item: TListItem): TListItemType;
    procedure VideLvLocal;
    procedure AjouteNvItemLocal(Item:TListItem;Donnees: TWin32FindData);
    procedure ValideMenuMachineDistante;
    procedure ValideMenuAnalyseur;
    procedure SetPreference(Sender: TObject);
    procedure AjouteMsg(Texte: string);
    procedure AutoriseDistant(Autorise: boolean);
    function LocalCompteRecursif(Origine, Masque: string):longint;
    function LocalScanRecursif(Origine, Masque: string;
      var Nombre: longint;Total: longint):boolean;
    function LocalDeleteRecursif(Origine: string):boolean;
    function DistantCompteRecursif(Origine, Masque: string):longint;
    procedure DistantScanRecursif(Origine, Masque: string;
      var Compte: longint;Total: longint);
    function DistantDeleteRecursif(Origine: string): boolean;
    procedure PasseDeconnecte;
  public
    { Dclarations publiques }
    procedure GereLangue(Sender: TObject);
    procedure AjouteSousMenu(Texte: string);
    procedure VideSousMenu;
  end;

const
  VersionSoft: string = '0.4.6';
  NumItemLangue=0;

var
  FPrincipale: TFPrincipale;

implementation

{$R *.DFM}

uses About, Langues, Configuration, Utilitaires, Alertes, Parser,
  Preferences;

var
  LecteurLocal: char;
  RepLocal: string;
  RepDistant: string;

  LocalColumnToSort: longint;
  DistantColumnToSort: longint;
  AncienNom: string;

  LaLangue: string;
  ConfigActuelle: Config;
  ParserActuel: Analyseur;

{**********************************************}
{ Utilitaires                                  }
{**********************************************}


{*****************************************************************************}
{ Fiche                                                                       }
{*****************************************************************************}

procedure TFPrincipale.FormCreate(Sender: TObject);
var
  WinDir: string;
  SrFichier:   TSearchRec;
  SFI: TSHFileInfo;
  Donnees: TWin32FindData;
begin
  // On recupere la liste d'icones Windows
  IlFichiers.Handle := SHGetFileInfo('', 0, SFI, SizeOf(SFI),
   SHGFI_SYSICONINDEX or SHGFI_SMALLICON);
  // On recupere le numero d'icone du repertoire Windows
  // pour l'utiliser pour les repertoires distants
  // Il faut au prealable remplir Donnees convenablement
  WinDir:= GetRepertoireWindows;
  if findfirst(WinDir, faAnyFile, SrFichier)=0 then
     Donnees:= SrFichier.FindData;
  Sysutils.findclose(SrFichier);
  SFI := GetShellInfo(WinDir,Donnees.dwFileAttributes);
  NumImgFolder := SFI.iIcon;
  // Repertoire de lancement de l'application
  RepAppli := ExtractFilePath(Application.ExeName);
  CreeMenuLangue;
  VideMessage;
  LocalColumnToSort:= 0;
  DistantColumnToSort:= 0;
end;

procedure TFPrincipale.FormShow(Sender: TObject);
begin
  AutoriseDistant(false);
  if FConfiguration.LitNomConfig then
    CbMachineDistante.Items:= FConfiguration.CbMachineDistante.Items;
  ValideMenuMachineDistante;
  FParser.LitNomParser;
  ValideMenuAnalyseur;

  SetPreference(Sender);
  LecteurLocal:= RepLocal[1];
  ActLocalLitRepExecute(Sender);
  PnlDistantRep.Caption:= '';

  PnlLocal.width:= (clientwidth-6) div 2;
end;

procedure TFPrincipale.FormResize(Sender: TObject);
begin
  PnlLocal.width:= (clientwidth-6) div 2;
end;

procedure TFPrincipale.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  ActDistantDeconnecterExecute(Sender);
  with FPrincipale do FPreferences.EcritPreferences(Top,Left,Height,Width,
    LaLangue,RepLocal,ConfigActuelle.LeNom);
end;

procedure TFPrincipale.CbMachineDistanteChange(Sender: TObject);
begin
  with CbMachineDistante do
    FConfiguration.LitConfiguration(Items[ItemIndex], ConfigActuelle);
  FConfiguration.SetUtilisee(ConfigActuelle.LeNom);
  FParser.LitParser(ConfigActuelle.LeType,ParserActuel);
  FParser.SetUtilise(ConfigActuelle.LeType);
  RepLocal:= AjouteWindowsBackSlash(ConfigActuelle.LeRepLocal);
  DCBLocal.Drive:= RepLocal[1];
  ActLocalLitRepExecute(Sender);
end;

{**********************************************}
{ Menu                                         }
{**********************************************}

procedure TFPrincipale.NouvelleClick(Sender: TObject);
var
  Nom: string;
  Index: longint;
begin
  if FConfiguration.Execute(NouvCfg,-1)then
  begin
    Nom:= CbMachineDistante.Items[CbMachineDistante.ItemIndex];
    CbMachineDistante.Items:= FConfiguration.CbMachineDistante.Items;
    // On se repositionne suite au trie;
    Index:= CbMachineDistante.Items.IndexOf(Nom);
    if Index = -1 then Index:= 0;
    CbMachineDistante.ItemIndex:= Index;
    ValideMenuMachineDistante;
  end;
end;

procedure TFPrincipale.EditerClick(Sender: TObject);
begin
  if FConfiguration.Execute(EdtCfg,CbMachineDistante.ItemIndex) then
  begin
    with CbMachineDistante do
      FConfiguration.LitConfiguration(Items[ItemIndex], ConfigActuelle);
    FConfiguration.SetUtilisee(ConfigActuelle.LeNom);
    if ConfigActuelle.LeType<>ParserActuel.LeNom then
    begin
      FParser.LitParser(ConfigActuelle.LeType,ParserActuel);
      FParser.SetUtilise(ConfigActuelle.LeType);
      ActDistantLitRepExecute(Sender);
    end;
    if ConfigActuelle.LeRepLocal<> RepLocal then
    begin
      RepLocal:= AjouteWindowsBackSlash(ConfigActuelle.LeRepLocal);
      DCBLocal.Drive:= RepLocal[1];
      ActLocalLitRepExecute(Sender);
    end;
  end;
end;

procedure TFPrincipale.CopierClick(Sender: TObject);
var
  Nom: string;
  Index: longint;
begin
  if FConfiguration.Execute(CpCfg,CbMachineDistante.ItemIndex)then
  begin
    Nom:= CbMachineDistante.Items[CbMachineDistante.ItemIndex];
    CbMachineDistante.Items:= FConfiguration.CbMachineDistante.Items;
    // On se repositionne suite au trie;
    Index:= CbMachineDistante.Items.IndexOf(Nom);
    if Index = -1 then Index:= 0;
    CbMachineDistante.ItemIndex:= Index;
    ValideMenuMachineDistante;
  end;
end;

procedure TFPrincipale.SupprimerClick(Sender: TObject);
var
  Index: longint;
begin
  if FConfiguration.Execute(DelCfg,CbMachineDistante.ItemIndex)then
  begin
    CbMachineDistante.Items:= FConfiguration.CbMachineDistante.Items;
    Index:= CbMachineDistante.Items.IndexOf(ConfigActuelle.LeNom);
    CbMachineDistante.ItemIndex := Index;
    ValideMenuMachineDistante;
  end;
end;

{**********************************************}
{ LvLocal                                      }
{**********************************************}

procedure TFPrincipale.LvLocalColumnClick(Sender: TObject;
  Column: TListColumn);
begin
  LocalColumnToSort := Column.Index;
  (Sender as TCustomListView).AlphaSort;
end;

procedure TFPrincipale.LvLocalCompare(Sender: TObject; Item1,
  Item2: TListItem; Data: Integer; var Compare: Integer);
var
  S1: string;
  S2: string;
  Date1: TDateTime;
  Date2: TDateTime;
begin
  case LocalColumnToSort of
    0 : begin
          if GetListItemType(Item1) = GetListItemType(Item2) then
          begin
            Compare := CompareText(Item1.Caption, Item2.Caption);
          end
          else
          begin
            if GetListItemType(Item1) = itFolder then Compare := -1
                                                 else Compare := 1;
          end;
        end;
    1 : begin
          S1:= trim(Item1.SubItems[0]);
          S2:= trim(Item2.SubItems[0]);
          if S1 = '' then Compare := -1
          else
          if S2 = '' then Compare := 1
          else
          if GetListItemType(Item1) = GetListItemType(Item2) then
          begin
            if StrToInt(S1) = StrToInt(S2) then
            begin
              Compare := CompareText(Item1.Caption, Item2.Caption);
            end
            else
            begin
              if StrToInt(S1) < StrToInt(S2) then Compare := -1
                                             else Compare := 1;
            end;
          end
          else
          begin
            if GetListItemType(Item1) = itFolder then Compare := -1
                                                 else Compare := 1;
          end;
        end;
    2 : begin
          if GetListItemType(Item1) = GetListItemType(Item2) then
          begin
            Date1:= StrToDateTime(Item1.SubItems[1]);
            Date2:= StrToDateTime(Item2.SubItems[1]);
            if Date1=Date2 then
            begin
              Compare := CompareText(Item1.Caption, Item2.Caption);
            end
            else
            begin
              if Date1 < Date2 then Compare:=-1
                               else Compare:= 1;
            end;
          end
          else
          begin
            if GetListItemType(Item1) = itFolder then Compare := -1
                                                 else Compare := 1;
          end;
        end;
  end;
end;

procedure TFPrincipale.LvLocalDblClick(Sender: TObject);
var
  Nom: string;
  Retour: boolean;
begin
  if assigned(LvLocal.Selected) then
  begin
    Nom:= LvLocal.Selected.Caption;
    case GetListItemType(LvLocal.Selected) of
      itFolder : begin
                  RepLocal:= AjouteWindowsBackSlash(RepLocal + Nom);
                  ActLocalLitRep.Execute;
                end;
      itFile   : if FtpClient.Connected then
                 begin
                   if TBtnBinaire.Down then
                     Retour:= ExecuteCmd(FtpClient.TypeBinary)
                   else
                     Retour:= ExecuteCmd(FtpClient.TypeAscii);
                   if Retour then
                   begin
                     FtpClient.HostDirName:= RepDistant;
                     FtpClient.HostFileName:= Nom;
                     FtpClient.LocalFileName:= RepLocal + Nom;
                     if ExecuteCmd(FtpClient.Put) then
                       ActDistantLitRepExecute(Sender);
                   end;
                 end ;
    end;
  end;
end;

procedure TFPrincipale.LvLocalDragDrop(Sender, Source: TObject; X,
  Y: Integer);
begin
  ActLocalRecevoirExecute(Sender);
end;

procedure TFPrincipale.LvLocalDragOver(Sender, Source: TObject; X,
  Y: Integer; State: TDragState; var Accept: Boolean);
begin
  Accept:=(Source = LvDistant);
end;

procedure TFPrincipale.LvLocalEdited(Sender: TObject; Item: TListItem;
  var S: String);
begin
  Editing:= false;
  if not renamefile(RepLocal+AncienNom,RepLocal+S) then
  begin
    Beep;
    S:= AncienNom;
  end;
end;

procedure TFPrincipale.LvLocalEditing(Sender: TObject; Item: TListItem;
  var AllowEdit: Boolean);
begin
  AncienNom:= LvLocal.Selected.Caption;
  Editing:= true;
end;

procedure TFPrincipale.LvLocalKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
var
  Choix: TListItem;
  ChoixSuivant: TListItem;
  Retour: word;
begin
  Retour:= mrNo;
  if (not Editing) and (Key=VK_Delete) and (LvLocal.SelCount>0) then
  begin
    Screen.Cursor:= crHourGlass;
    lvLocal.Items.BeginUpdate;
    Choix:= LvLocal.Selected;
    while LvLocal.SelCount>0 do
    begin
     if LvLocal.SelCount>0 then
       ChoixSuivant:= lvLocal.GetNextItem(Choix,sdAll,[isSelected])
       else ChoixSuivant:= nil;
     if Retour<> mrAll then Retour:= BoiteMessage(101,Choix.Caption,'');
     if Retour in [mrYes,mrAll] then
     begin
       case GetListItemType(Choix) of
         itFolder : if LocalDeleteRecursif(RepLocal + Choix.Caption)
                      then lvLocal.Items.Delete(lvLocal.Items.IndexOf(Choix))
                    else
                    begin
                      Beep;
                      BoiteMessage(2,Choix.Caption,'');
                      lvLocal.Items.Item[lvLocal.Items.IndexOf(Choix)].Selected:= false;
                    end;

         itFile  : if DeleteFile(RepLocal + Choix.Caption) then
                        lvLocal.Items.Delete(lvLocal.Items.IndexOf(Choix))
                   else
                   begin
                     Beep;
                     BoiteMessage(3,Choix.Caption,'');
                     lvLocal.Items.Item[lvLocal.Items.IndexOf(Choix)].Selected:= false;
                   end;
       end;
     end
     else lvLocal.Items.Item[lvLocal.Items.IndexOf(Choix)].Selected:= false;
     if ChoixSuivant <> nil then Choix:= ChoixSuivant;
    end;
    lvLocal.Items.EndUpdate;
    lvLocal.Update;
    Screen.Cursor:= crDefault;
  end;
end;

{**********************************************}
{ LvDistant                                    }
{**********************************************}

procedure TFPrincipale.LvDistantColumnClick(Sender: TObject;
  Column: TListColumn);
begin
  DistantColumnToSort := Column.Index;
  (Sender as TCustomListView).AlphaSort;
end;

procedure TFPrincipale.LvDistantCompare(Sender: TObject; Item1,
  Item2: TListItem; Data: Integer; var Compare: Integer);
var
  S1: string;
  S2: string;
begin
  case DistantColumnToSort of
    0 : begin
          if Item1.ImageIndex = Item2.ImageIndex then
          begin
            Compare := CompareText(Item1.Caption, Item2.Caption);
          end
          else
          begin
            if Item1.ImageIndex = NumImgFolder then Compare := -1
                                               else Compare := 1;
          end;
        end;
    1 : begin
          S1:= trim(Item1.SubItems[0]);
          S2:= trim(Item2.SubItems[0]);
          if Item1.ImageIndex = Item2.ImageIndex then
          begin
            if ((S1='') and (S2='')) or (StrToInt(S1)=StrToInt(S2)) then
            begin
              Compare := CompareText(Item1.Caption, Item2.Caption);
            end
            else
              if S1='' then Compare:= -1
              else
                if S2='' then Compare:= 1
                else
                begin
                  if StrToInt(S1) < StrToInt(S2) then Compare := -1
                                                 else Compare := 1;
                end;
          end
          else
          begin
            if Item1.ImageIndex = NumImgFolder then Compare := -1
                                               else Compare := 1;
          end;
        end;
    2 : begin
          (*
          if Item1.ImageIndex = Item2.ImageIndex then
          begin
            Compare := CompareText(Item1.SubItems[1], Item2.SubItems[1]);
          end
          else
          begin
            if Item1.ImageIndex = NumImgFolder then Compare := -1
                                               else Compare := 1;
          end;
          *)
        end;
  end;
end;

procedure TFPrincipale.LvDistantDblClick(Sender: TObject);
var
  Nom: string;
  Retour: boolean;
begin
  if assigned(LvDistant.Selected) then
  begin
    Nom:= LvDistant.Selected.Caption;
    if LvDistant.Selected.ImageIndex = NumImgFolder then
    begin
      {if Nom= '..' then ExecuteCmd(FtpClient.CDup)
      else
      if Nom<> '.' then
      begin
        FtpClient.HostDirName:=
          PnlDistantRep.Caption + Nom ;
        ExecuteCmd(FtpClient.Cwd);
      end;}
      FtpClient.HostDirName:= Nom ;
      ExecuteCmd(FtpClient.Cwd);
      // Calcul du repertoire pour le cas ou la commande PWD
      // de la lecture du repertoire se termine mal
      RepDistant:= AjouteUnixSlash(PnlDistantRep.Caption + Nom);
      PnlDistantRep.Caption:= RepDistant;
      // Lecture du repertoire
      ActDistantLitRepExecute(Sender);
    end
    else
    begin
      if TBtnBinaire.Down then
        Retour:= ExecuteCmd(FtpClient.TypeBinary)
      else
        Retour:= ExecuteCmd(FtpClient.TypeAscii);
      if Retour then
      begin
        FtpClient.HostFileName:= Nom;
        FtpClient.LocalFileName:= RepLocal+Nom;
        if ExecuteCmd(FtpClient.Get) then
          ActLocalLitRepExecute(Sender);
      end;
    end ;
  end;

end;

procedure TFPrincipale.LvDistantDragDrop(Sender, Source: TObject; X,
  Y: Integer);
begin
  ActLocalEnvoyerExecute(Sender);
end;

procedure TFPrincipale.LvDistantDragOver(Sender, Source: TObject; X,
  Y: Integer; State: TDragState; var Accept: Boolean);
begin
  Accept:=(Source = LvLocal);
end;

procedure TFPrincipale.LvDistantEdited(Sender: TObject; Item: TListItem;
  var S: String);
begin
  Editing:= false;
  FtpClient.HostFileName:= RepDistant+AncienNom;
  FtpClient.LocalFileName:= RepDistant+S;
  if not ExecuteCmd(FtpClient.Ren) then
  begin
    Beep;
    S:= AncienNom;
  end;
end;

procedure TFPrincipale.LvDistantEditing(Sender: TObject; Item: TListItem;
  var AllowEdit: Boolean);
begin
  AncienNom:= LvDistant.Selected.Caption;
  Editing:= true;
end;

procedure TFPrincipale.LvDistantKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
var
  Choix: TListItem;
  ChoixSuivant: TListItem;
  Retour: word;
begin
  Retour:= mrNo;
  if (not Editing) and (Key=VK_Delete) and (LvDistant.SelCount>0) then
  begin
    Screen.Cursor:= crHourGlass;
    Choix:= LvDistant.Selected;
    lvDistant.Items.BeginUpdate;
    while LvDistant.SelCount>0 do
    begin
      if LvDistant.SelCount>0 then
        ChoixSuivant:= lvDistant.GetNextItem(Choix,sdAll,[isSelected])
        else ChoixSuivant:= nil;
      if Retour<> mrAll then Retour:= BoiteMessage(101,Choix.Caption,'');
      if Retour in [mrYes,mrAll] then
      begin
        if Choix.ImageIndex = NumImgFolder then
        begin
          if DistantDeleteRecursif(RepDistant + Choix.Caption) then
            lvDistant.Items.Delete(lvDistant.Items.IndexOf(Choix))
          else
          begin
            Beep;
            BoiteMessage(2,Choix.Caption,'');
            lvDistant.Items.Item[lvDistant.Items.IndexOf(Choix)].Selected:= false;
          end;
        end
        else
        begin
          FtpClient.HostFileName:= Choix.Caption;
          if ExecuteCmd(FtpClient.Dele) then
             lvDistant.Items.Delete(lvDistant.Items.IndexOf(Choix))
          else
          begin
            Beep;
            BoiteMessage(3,Choix.Caption,'');
            lvDistant.Items.Item[lvDistant.Items.IndexOf(Choix)].Selected:= false;
          end;
        end;
      end
      else lvDistant.Items.Item[lvDistant.Items.IndexOf(Choix)].Selected:= false;
      if ChoixSuivant <> nil then Choix:= ChoixSuivant;
    end;
    lvDistant.Items.EndUpdate;
    lvDistant.Update;
    Screen.Cursor:= crDefault;
  end;
end;

{*****************************************************************************}
{ Gestion du client FTP                                                       }
{*****************************************************************************}

function TFPrincipale.ExecuteCmd(Cmd: TSyncCmd):boolean;
begin
  if Cmd then
  begin
    //AjouteMsg(GetMsg(121) + ' ' + LastCmd + ' ' + GetMsg(122));
    if LastCmd='QUIT' then AjouteMsg(GetMsg(114)+' '+FtpClient.HostName);
    BarreEtat.Panels[2].Text:='';
    Result:= true;
  end
  else
  begin
    if LastCmd<>'' then AjouteMsg(GetMsg(117) + ' ' + LastCmd);
    Result:= false;
  end;
  FtpClient.HostFileName:= '';
end;

procedure TFPrincipale.FtpClientCommand(Sender: TObject; var Cmd: String);
begin
  LastCmd:= Cmd;
  if (Cmd='NLST') or (Cmd='LIST') then FtpClient.LocalFileName:= TmpFile;
  if copy(Cmd,1,4)= 'PASS' then LastCmd:= 'PASS';
end;

procedure TFPrincipale.FtpClientDisplay(Sender: TObject; var Msg: String);
var
  Texte: string;
  Long: longint;
  N: longint;
begin
  Texte:= Msg;
  if copy(Texte,1,6)='> PASS' then // Remplacement mot de passe par *****
  begin
    Long:= length(Texte);
    for N:= 8 to Long do Texte[N]:= '*';
  end;
  AjouteMsg(Texte);
end;

procedure TFPrincipale.FtpClientProgress(Sender: TObject; Count: Integer;
  var Abort: Boolean);
begin
  BarreEtat.Panels[2].Text:= ' ' + IntToStr(Count) + ' ' + GetMsg(127);;
end;

procedure TFPrincipale.FtpClientRequestDone(Sender: TObject;
  RqType: TFtpRequest; Error: Word);
begin
  if Error = 0  then
  begin
    case RqType of
      ftpNone            : ;

      ftpOpenAsync,
      ftpConnectAsync    : if not FtpClient.Connected then
                             AjouteMsg(GetMsg(113)+' '+FtpClient.HostName);
      ftpUserAsync,
      ftpPassAsync,
      ftpPortAsync       : ;

      ftpDirAsync,
      ftpDirectoryAsync  : ;

      ftpLsAsync,
      ftpListAsync       : ;

      ftpCwdAsync,
      ftpCDupAsync       : ;

      ftpPwdAsync        : begin
                             RepDistant:= AjouteUnixSlash(FtpClient.DirResult);
                             PnlDistantRep.Caption:= RepDistant;
                           end;

      ftpGetAsync,
      ftpReceiveAsync    : ;

      ftpRestGetAsync,
      ftpRestartGetAsync : ;

      ftpPutAsync,
      ftpTransmitAsync   : ;

      ftpRestPutAsync,
      ftpRestartPutAsync : ;

      ftpSystAsync,
      ftpSystemAsync     : ;//ESyst.Text:= FtpClient.LastResponse;

      ftpAppendAsync     : ;

      ftpSizeAsync,
      ftpFileSizeAsync   : ;

      ftpRqAbort,
      ftpQuitAsync       : if not FtpClient.Connected then PasseDeconnecte;

      ftpMkdAsync,
      ftpMkdirAsync      : ;

      ftpRmdAsync,
      ftpRmdirAsync      : ;

      ftpRenAsync,
      ftpRenameAsync     : ;

      ftpDeleAsync,
      ftpDeleteAsync     : ;

      ftpRenToAsync,
      ftpRenFromAsync    : ;

      ftpQuoteAsync,
      ftpDoQuoteAsync    : ;

      ftpTypeSetAsync,
      ftpRestAsync       : ;
    end;
  end
  else
  begin
    AjouteMsg(GetMsg(116)+IntToStr(Error)+' '+FtpClient.ErrorMessage +'(RequestDone)');
  end;
end;

procedure TFPrincipale.FtpClientSessionClosed(Sender: TObject;
  Error: Word);
begin
//
end;

procedure TFPrincipale.FtpClientSessionConnected(Sender: TObject;
  Error: Word);
begin
  AjouteMsg(GetMsg(111)+' '+FtpClient.HostName);
  BarreEtat.Panels[0].text:= GetMsg(112);
  AutoriseDistant(True);
end;

{*****************************************************************************}
{ Actions                                                                     }
{*****************************************************************************}

procedure TFPrincipale.ActQuitterExecute(Sender: TObject);
begin
  close;
end;

procedure TFPrincipale.ActAProposExecute(Sender: TObject);
begin
  with TFAbout.Create(Application) do
    try Showmodal;
    finally Free;
    end;
end;

procedure TFPrincipale.ActRubriqueAideExecute(Sender: TObject);
const
  HELP_TAB=15;
  CONTENTS_ACTIVE=-3;
begin
  Application.HelpCommand(HELP_TAB,CONTENTS_ACTIVE);
end;

procedure TFPrincipale.ActRechercheAideExecute(Sender: TObject);
const
  HELP_TAB=15;
  CONTENTS_ACTIVE=-2;
begin
  Application.HelpCommand(HELP_TAB,CONTENTS_ACTIVE);
end;

{**********************************************}
{ Actions locales                              }
{**********************************************}

procedure TFPrincipale.ActLocalRepPrecedentExecute(Sender: TObject);
begin
  RepLocal:= RepPrecedentWindows(RepLocal);
  ActLocalLitRep.execute;
end;

procedure TFPrincipale.ActLocalCreeRepExecute(Sender: TObject);
const
  Nom= 'Nouveau dossier';
var
  Entree: TListItem;
  SrFichier:   TSearchRec;
begin
  if CreateDir(RepLocal+Nom) then
  begin
    Entree:= LvLocal.Items.Add;

    try
      if findfirst(AjouteWindowsBackSlash(RepLocal)+Nom, faAnyFile, SrFichier)=0 then
      begin
        try
          if not ((srFichier.Name='..') or (SrFichier.Name='.')) then
               AjouteNvItemLocal(Entree,SrFichier.FindData);
        finally
          Sysutils.findclose(SrFichier);
        end;
      end;
    except
      on exception do;
    end;

    Entree.EditCaption;
  end
  else
  begin
    Beep;
    BoiteMessage(4,'','');
  end;
end;

procedure TFPrincipale.ActLocalIconeExecute(Sender: TObject);
begin
  LvLocal.ViewStyle:= vsSmallIcon;
end;

procedure TFPrincipale.ActLocalListeExecute(Sender: TObject);
begin
  LvLocal.ViewStyle:= vsList;
end;

procedure TFPrincipale.ActLocalDetailExecute(Sender: TObject);
begin
  LvLocal.ViewStyle:= vsReport;
end;

procedure TFPrincipale.ActLocalLitRepExecute(Sender: TObject);
var
  SrFichier:   TSearchRec;
begin
  Screen.Cursor:= crHourGlass;
  LvLocal.Items.BeginUpdate;
  try
    VideLvLocal;
    try
      if findfirst(AjouteWindowsBackSlash(RepLocal)+'*.*', faAnyFile, SrFichier)=0 then
      begin
        try
          repeat
            if not ((srFichier.Name='..') or (SrFichier.Name='.')) then
               AjouteNvItemLocal(LvLocal.Items.Add,SrFichier.FindData);
          until findnext(SrFichier)<>0;
        finally
          Sysutils.findclose(SrFichier);
        end;
      end;
    except
      on exception do;
    end;

  finally
    LvLocal.AlphaSort;
    PnlLocalRep.Caption:= RepLocal;
    ActLocalRepPrecedent.Enabled:= length(RepLocal)>3;
    LvLocal.Items.EndUpdate;
    Screen.Cursor:= crDefault;
  end;
end;

procedure TFPrincipale.ActLocalChangeLecteurExecute(Sender: TObject);
var
  NumLecteur: integer;
  Lecteur: char;
  LecteurTmp: char;
begin
  LecteurTmp:= DCBLocal.Drive;
  if LecteurTmp<>LecteurLocal then
  begin
    NumLecteur:= ord(LecteurTmp) - ord('a') + 1;
    getdir(NumLecteur,RepLocal);
    Lecteur:= (lowercase(RepLocal))[1];
    if Lecteur=LecteurTmp then
    begin
      AjouteWindowsBackSlash(RepLocal);
      ActLocalLitRep.execute;
      LecteurLocal:= Lecteur;
    end
    else
    begin
      Beep;
      BoiteMessage(1,LecteurTmp,'');
      DCBLocal.Drive:= LecteurLocal;
    end;
  end;
end;

procedure TFPrincipale.ActLocalEnvoyerExecute(Sender: TObject);
var
  Choix: TListItem;
  ChoixSuivant: TListItem;
  Nom: string;
  Nombre: longint;
  Total: longint;
begin
  Screen.Cursor:= crHourGlass;
  if FtpClient.Connected and (LvLocal.SelCount>0) then
  begin
    // Comptage
    Total:= 0;
    BarreEtat.Panels[1].Text:= GetMsg(128);
    Choix:= LvLocal.Selected;
    Nombre:= LvLocal.SelCount;
    while Nombre>0 do
    begin
      if Nombre>0 then
        ChoixSuivant:= lvLocal.GetNextItem(Choix,sdAll,[isSelected])
        else ChoixSuivant:= nil;

      case GetListItemType(Choix) of
        itFolder : begin
                     Nom:= Choix.Caption;
                     Nom:= RepLocal+Nom;
                     Nom:= AjouteWindowsBackSlash(Nom);
                     inc(Total); // compte ce repertoire
                     // comptage des fichiers du repertoire
                     Total:= Total + LocalCompteRecursif(Nom, '*.*');
                   end;
        itFile  : begin
                    inc(Total); // compte les fichiers
                  end;
      end;
      dec(Nombre);
      if ChoixSuivant <> nil then Choix:= ChoixSuivant;
    end;

    // Passage en mode binary ou ascii
    if TBtnBinaire.Down then ExecuteCmd(FtpClient.TypeBinary)
                        else ExecuteCmd(FtpClient.TypeAscii);

    // Execution du transfert
    Choix:= LvLocal.Selected;
    lvLocal.Items.BeginUpdate;
    Nombre:= 0;
    while LvLocal.SelCount>0 do
    begin
      if LvLocal.SelCount>0 then
        ChoixSuivant:= LvLocal.GetNextItem(Choix,sdAll,[isSelected])
        else ChoixSuivant:= nil;

      case GetListItemType(Choix) of
        itFolder : begin
                     inc(Nombre);
                     BarreEtat.Panels[1].Text:= IntToStr(Nombre)+ ' / ' + IntToStr(Total);
                     Nom:= Choix.Caption;
                     // On cree le repertoire
                     FtpClient.HostFileName:= Nom;
                     ExecuteCmd(FtpClient.Mkd);
                     // On passe dans le repertoire
                     FtpClient.HostDirName:= Nom ;
                     ExecuteCmd(FtpClient.Cwd);
                     // On recurse
                     Nom:= RepLocal + Nom;
                     Nom:= AjouteWindowsBackSlash(Nom);
                     LocalScanRecursif(Nom,'*.*',Nombre,Total);
                     // On revient au repertoire d'origine
                     ExecuteCmd(FtpClient.CDup);
                   end;
        itFile  :  begin
                     inc(Nombre);
                     BarreEtat.Panels[1].Text:= IntToStr(Nombre)+ ' / ' + IntToStr(Total);
                     Nom:= Choix.Caption;
                     // On transfert le fichier
                     FtpClient.HostFileName:= Nom;
                     FtpClient.LocalFileName:= RepLocal + Nom;
                     ExecuteCmd(FtpClient.Put);
                   end;
      end;
      LvLocal.Items.Item[LvLocal.Items.IndexOf(Choix)].Selected:= false;
      if ChoixSuivant <> nil then Choix:= ChoixSuivant;
    end;
    lvLocal.Items.EndUpdate;
    lvLocal.Update;

    // On revient au repertoire d'origine
    FtpClient.HostDirName:= RepDistant ;
    ExecuteCmd(FtpClient.Cwd);
    BarreEtat.Panels[1].Text:= '';
    // On affiche le repertoire
    ActDistantLitRepExecute(Sender);
  end;
  Screen.Cursor:= crDefault;
end;

procedure TFPrincipale.ActLocalRecevoirExecute(Sender: TObject);
var
  Choix: TListItem;
  ChoixSuivant: TListItem;
  Nombre: longint;
  Nom: string;
  Total: longint;
begin
  Screen.Cursor:= crHourGlass;
  if FtpClient.Connected and (LvDistant.SelCount>0) then
  begin
    //Comptage
      Total:= 0;
      BarreEtat.Panels[1].Text:= GetMsg(128);
      // Stockage de la selection
      Choix:= LvDistant.Selected;
      Nombre:= LvDistant.SelCount;
      while Nombre>0 do
      begin
        if Nombre>0 then
          ChoixSuivant:= LvDistant.GetNextItem(Choix,sdAll,[isSelected])
          else ChoixSuivant:= nil;
        if Choix.ImageIndex= NumImgFolder then
          Total:= Total + DistantCompteRecursif(Choix.Caption, '');
        inc(Total);
        dec(Nombre);
        if ChoixSuivant <> nil then Choix:= ChoixSuivant;
      end;

    // Passage en mode binary
    if TBtnBinaire.Down then ExecuteCmd(FtpClient.TypeBinary)
                        else ExecuteCmd(FtpClient.TypeAscii);


    // Execution du transfert
       Nombre:= 0;
      // Stockage de la selection
      Choix:= LvDistant.Selected;
      while LvDistant.SelCount>0 do
      begin
        if LvDistant.SelCount>0 then
          ChoixSuivant:= LvDistant.GetNextItem(Choix,sdAll,[isSelected])
          else ChoixSuivant:= nil;
        if Choix.ImageIndex = NumImgFolder then
        begin
          DistantScanRecursif(Choix.Caption,'',Nombre,Total);
        end
        else
        begin
          inc(Nombre);
          BarreEtat.Panels[1].Text:= IntToStr(Nombre)+ ' / ' + IntToStr(Total);
          Nom:= Choix.Caption;
          // On transfert le fichier
          FtpClient.HostFileName:= Nom;
          FtpClient.LocalFileName:= RepLocal + Nom;
          ExecuteCmd(FtpClient.Get);
        end;
        LvDistant.Items.Item[LvDistant.Items.IndexOf(Choix)].Selected:= false;
        if ChoixSuivant <> nil then Choix:= ChoixSuivant;
      end;

    BarreEtat.Panels[1].Text:= '';
    RepLocal:= PnlLocalRep.Caption;
    ActLocalLitRepExecute(Sender);
  end;
  Screen.Cursor:= crDefault;
end;

{**********************************************}
{ Actions distantes                            }
{**********************************************}

procedure TFPrincipale.ActDistantRepPrecedentExecute(Sender: TObject);
begin
  Screen.Cursor:= crHourGlass;
  if ExecuteCmd(FtpClient.CDup) then ActDistantLitRepExecute(Sender);
  Screen.Cursor:= crDefault;
end;

procedure TFPrincipale.ActDistantCreeRepExecute(Sender: TObject);
begin
  Screen.Cursor:= crHourGlass;
  FtpClient.HostFileName:= 'Nouveau dossier';
  // rajouter le if des que l'erreur sur creation sera supprimee
  ExecuteCmd(FtpClient.Mkd);
  ActDistantLitRepExecute(Sender);
  Screen.Cursor:= crDefault;
end;

procedure TFPrincipale.ActDistantIconeExecute(Sender: TObject);
begin
  LvDistant.ViewStyle:= vsSmallIcon;
end;

procedure TFPrincipale.ActDistantListeExecute(Sender: TObject);
begin
  LvDistant.ViewStyle:= vsList;
end;

procedure TFPrincipale.ActDistantDetailExecute(Sender: TObject);
begin
  LvDistant.ViewStyle:= vsReport;
end;

procedure TFPrincipale.ActDistantLitRepExecute(Sender: TObject);
begin
  if FtpClient.Connected then
  begin
    Screen.Cursor:= crHourGlass;
    ExecuteCmd(FtpClient.TypeAscii);
    FtpClient.LocalFileName:= TmpFile;
    FtpClient.HostFileName:= ''; // masque utilise pour le dir
    // *.* ne renverrai que les fichiers, * renverrai toute l'arborescence
    if ExecuteCmd(FtpClient.Dir) then
    begin
      FParser.REReponse.Lines.LoadFromFile(TmpFile);
      LvDistant.Items.BeginUpdate;
      FParser.Parse(FParser.REReponse.Lines,ParserActuel,LvDistant);
      LvDistant.AlphaSort;
      LvDistant.Items.EndUpdate;
      ExecuteCmd(FtpClient.Pwd);
      ActDistantRepPrecedent.Enabled:=
        not((PnlDistantRep.Caption= '/') or (PnlDistantRep.Caption= '\'));
    end;
    Screen.Cursor:= crDefault;
  end;
end;

procedure TFPrincipale.ActDistantConnecterExecute(Sender: TObject);
var
  Chaine: string;
begin
  Screen.Cursor:= crHourGlass;
  ActDistantConnecter.Enabled:= false;
  try
    AjouteMsg(GetMsg(126)+ConfigActuelle.LAdresse);
    FtpClient.HostName:= ConfigActuelle.LAdresse;
    FtpClient.UserName:= ConfigActuelle.LeLogin;
    FtpClient.PassWord:= ConfigActuelle.LeMotDePasse;
    if FtpClient.Connected then ExecuteCmd(FtpClient.Quit);
    TmpFile:= ExtractFilePath(Application.ExeName);
    TmpFile:= TmpFile + 'FtpDir.Txt';
    FtpClient.LocalFileName:= TmpFile;
    FtpClient.HostFileName:= '';
    FtpClient.Timeout:= 180;
    if ExecuteCmd(FtpClient.Open) then
      if ExecuteCmd(FtpClient.User) then
      begin
        FtpClient.Timeout:= 5;
        if ExecuteCmd(FtpClient.Pass) then
        begin
          if ExecuteCmd(FtpClient.Syst) then
          begin
            Chaine:= FtpClient.LastResponse;
            if copy(Chaine,1,3)= '215' then
            begin
              delete(Chaine,1,4);
              ESysteme.Text:= Chaine;
            end
            else ESysteme.Text:= '';
          end
          else ESysteme.Text:= '';
          if ConfigActuelle.LeRepDistant<>'' then
          begin
            FtpClient.HostDirName:= ConfigActuelle.LeRepDistant;
            ExecuteCmd(FtpClient.Cwd);
          end;
          ActDistantLitRepExecute(Sender);
        end
        else ActDistantDeconnecterExecute(Sender);
      end
      else ActDistantDeconnecterExecute(Sender);
  finally
    Screen.Cursor:= crDefault;
  end;
  if FtpClient.Connected then
  begin
    ActDistantConnecter.Enabled:= false;
    ActDistantDeconnecter.Enabled:= true;
    ActLocalEnvoyer.Enabled:= true;
    ActLocalRecevoir.Enabled:= true;
  end
  else ActDistantConnecter.Enabled:= true;
end;

procedure TFPrincipale.ActDistantDeconnecterExecute(Sender: TObject);
begin
  Screen.Cursor:= crHourGlass;
  if FtpClient.Connected then ExecuteCmd(FtpClient.Quit)
                         else PasseDeconnecte;
  Screen.Cursor:= crDefault;
end;

{*****************************************************************************}
{ Fonctions private                                                           }
{*****************************************************************************}

function TFPrincipale.GetListItemType(Item: TListItem): TListItemType;
begin
  if not assigned(Item.Data) then result := itFile
  else
  begin
    if (TWin32FindData(Item.Data^).dwFileAttributes and faDirectory <> 0) then
      result := itFolder
    else
      result := itFile;
  end;
end;

procedure TFPrincipale.VideLvLocal;
var
  N: integer;
begin
  with LvLocal do
  begin
    for N:= 0 to pred(Items.Count) do
      if assigned(Items[N].Data) then dispose(pWin32FindData(Items[N].Data));
    Items.Clear;
  end;
end;

procedure TFPrincipale.AjouteNvItemLocal(Item:TListItem;Donnees: TWin32FindData);
var
  NvDonneeWindows: pWin32FindData;
  SFI: TSHFileInfo;
begin
  with Item do
  begin
    new(NvDonneeWindows);
    move(Donnees, NvDonneeWindows^, sizeof(Donnees));
    Data := NvDonneeWindows;
    // Nom de fichier
    Caption := Donnees.cFileName;
    // Icone
    SFI := GetShellInfo(
      AjouteWindowsBackSlash(RepLocal) + Caption,
      Donnees.dwFileAttributes);
    ImageIndex := SFI.iIcon;

    if (Donnees.dwFileAttributes and File_Attribute_Directory)
       = File_Attribute_Directory
    then
      // Rien car repertoire
      SubItems.Add('')
    else
      // Taille fichier
      SubItems.Add(FormateTailleFichier(Donnees.nFileSizeLow));

    // Date
    SubItems.Add(FormatDateTime('dd/mm/yyyy hh:mm:ss',
        FileTimeToDateTime(Donnees.ftLastWriteTime)));
  end;
end;

procedure TFPrincipale.SetPreference(Sender: TObject);
var
  N: integer;
  Retour: longint;
  Top: longint;
  Left: longint;
  Height: longint;
  Width: longint;
begin
  FPreferences.LitPreferences;
  // Positionne la fenetre
  if Pref.SauveFenetre then
  begin
    FPreferences.GetFenetre(Top,Left,Height,Width);
    FPrincipale.Top:= Top;
    FPrincipale.Left:= Left;
    FPrincipale.Height:= Height;
    FPrincipale.Width:= Width;
  end
  else
  begin
    FPrincipale.Top:= (Screen.Height - FPrincipale.Height)div 2;
    FPrincipale.Left:= (Screen.Width - FPrincipale.Width)div 2;
  end;
  // Selectionne la langue
  LaLangue:= FPreferences.GetLangue;
  if not ExisteLangue(LaLangue) then LaLangue:= LangueRef;
  with MenuPrincipal.Items[1].Items[NumItemLangue]do
  begin
    for N:= 0 to pred(Count) do
      if EpureTexte(Items[N].Caption) = LaLangue then
         Items[N].Checked:= true
      else Items[N].Checked:= false;
  end;
  LitLangue(LaLangue);
  // Selectionne le repertoire local
  RepLocal:= AjouteWindowsBackSlash(FPreferences.GetRepLocal);
  DCBLocal.Drive:= RepLocal[1];
  // Selectionne la machine distante
  Retour:= CbMachineDistante.Items.IndexOf(FPreferences.GetDistant);
  if Retour<>-1 then CbMachineDistante.ItemIndex:= Retour
                else CbMachineDistante.ItemIndex:= 0;
  with CbMachineDistante do
    FConfiguration.LitConfiguration(Items[ItemIndex], ConfigActuelle);
  FConfiguration.SetUtilisee(ConfigActuelle.LeNom);
  FParser.LitParser(ConfigActuelle.LeType,ParserActuel);
  FParser.SetUtilise(ConfigActuelle.LeType);
end;

procedure TFPrincipale.ValideMenuMachineDistante;
begin
  if CbMachineDistante.Items.Count>0 then
  begin
    Editer.Enabled:= true;
    Copier.Enabled:= true;
    ActDistantConnecter.Enabled:= true;
  end
  else
  begin
    Editer.Enabled:= false;
    Copier.Enabled:= false;
    ActDistantConnecter.Enabled:= false;
  end;
  Supprimer.Enabled:= CbMachineDistante.Items.Count>1;
end;

procedure TFPrincipale.ValideMenuAnalyseur;
var
  Nombre: longint;
begin
  Nombre:= FParser.NombreParser;
  if Nombre>0 then
  begin
    EditerAnalyseur.Enabled:= true;
    CopierAnalyseur.Enabled:= true;
  end
  else
  begin
    EditerAnalyseur.Enabled:= false;
    CopierAnalyseur.Enabled:= false;
  end;
  SupprimerAnalyseur.Enabled:= Nombre>1;
end;

procedure TFPrincipale.AjouteMsg(Texte: string);
begin
  if Texte <> '' then
  begin
    while Texte[length(Texte)] in [#13,#10] do delete(Texte,length(Texte),1);
    RichEditCommande.Lines.Add(Texte);
  end;
end;

procedure TFPrincipale.AutoriseDistant(Autorise: boolean);
begin
  TBtnDistantRepPrecedent.Enabled:= Autorise and
     not((PnlDistantRep.Caption= '/') or (PnlDistantRep.Caption= '\'));;
  TBtnDistantCreeRep.Enabled:= Autorise;
  TBtnDistantIcone.Enabled:= Autorise;
  TBtnDistantListe.Enabled:= Autorise;
  TBtnDistantDetail.Enabled:= Autorise;
  TBtnDistantRafraichit.Enabled:= Autorise;
  CbMachineDistante.Enabled:= not Autorise;
end;

function TFPrincipale.LocalCompteRecursif(Origine, Masque: string):longint;
var
  Total: longint;

  function ScanRep(var path: string):boolean;
  var
    SRec: TSearchRec;
    pathlen: integer;
    res: integer;
  begin
    result:= true;
    pathlen:= length(path);
    // Recherche des fichiers
    res:= FindFirst(path+Masque,faAnyfile,SRec);
    if res=0 then
    try
      while res=0 do
      begin
        if ((SRec.Attr and faDirectory)<>faDirectory)
          and (SRec.Name<>'.') and (SRec.Name<>'..') then inc(Total);
        res:= FindNext(SRec);
      end;
    finally
      FindClose(SRec);
    end;
    Application.ProcessMessages;

    // Recherche des repertoires
    res:= FindFirst(path+'*.*',faDirectory,SRec);
    if res=0 then
    try
      while (res=0) and result do
      begin
        if ((SRec.Attr and faDirectory)=faDirectory)
          and (SRec.Name<>'.') and (SRec.Name<>'..') then
        begin
          inc(Total);
          path:= path + SRec.Name + '\';
          result:= ScanRep(path);
          setlength(path,pathlen);
        end;
        res:= FindNext(SRec);
      end;
    finally
      FindClose(SRec);
    end;
  end;

begin
  Total:= 0;
  ScanRep(Origine);
  result:= Total;
end;

function TFPrincipale.LocalScanRecursif(Origine, Masque: string;
  var Nombre: longint;Total: longint):boolean;

  function ScanRep(var path: string):boolean;
  var
    SRec: TSearchRec;
    pathlen: integer;
    res: integer;
    Nom: string;
  begin
    result:= true;
    pathlen:= length(path);
    // Recherche des fichiers
    res:= FindFirst(path+Masque,faAnyfile,SRec);
    if res=0 then
    try
      while res=0 do
      begin
        if ((SRec.Attr and faDirectory)<>faDirectory)
          and (SRec.Name<>'.') and (SRec.Name<>'..') then
        begin
          inc(Nombre);
          BarreEtat.Panels[1].Text:= IntToStr(Nombre)+ ' / ' + IntToStr(Total);
          Nom:= SRec.Name;
          // On transfert le fichier
          FtpClient.HostFileName:= Nom;
          FtpClient.LocalFileName:= Path + Nom;
          ExecuteCmd(FtpClient.Put)
        end;
        res:= FindNext(SRec);
      end;
    finally
      FindClose(SRec);
    end;
    Application.ProcessMessages;

    // Recherche des repertoires
    res:= FindFirst(path+'*.*',faDirectory,SRec);
    if res=0 then
    try
      while (res=0) and result do
      begin
        if ((SRec.Attr and faDirectory)=faDirectory)
          and (SRec.Name<>'.') and (SRec.Name<>'..') then
        begin
          inc(Nombre);
          BarreEtat.Panels[1].Text:= IntToStr(Nombre)+ ' / ' + IntToStr(Total);
          Nom:= SRec.Name;
          // On cree le repertoire
          FtpClient.HostFileName:= Nom;
          ExecuteCmd(FtpClient.Mkd);
          // On passe dans le repertoire
          FtpClient.HostDirName:= Nom ;
          ExecuteCmd(FtpClient.Cwd);
          // On recurse
          path:= path + Nom + '\';
          result:= ScanRep(path);
          // On remonte au precedent
          setlength(path, pathlen);
          ExecuteCmd(FtpClient.CDup);
        end;
        res:= FindNext(SRec);
      end;
    finally
      FindClose(SRec);
    end;
  end;

begin
  result:= ScanRep(Origine);
end;

function TFPrincipale.LocalDeleteRecursif(Origine: string):boolean;

  function ScanRep(var path: string):boolean;
  var
    SRec: TSearchRec;
    pathlen: integer;
    res: integer;
    Nom: string;
  begin
    result:= true;
    path:= AjouteWindowsBackSlash(path);
    pathlen:= length(path);
    // Recherche des fichiers
    res:= FindFirst(path+'*.*',faAnyfile,SRec);
    if res=0 then
    try
      while res=0 do
      begin
        if ((SRec.Attr and faDirectory)<>faDirectory)
          and (SRec.Name<>'.') and (SRec.Name<>'..') then
        begin
          Nom:= SRec.Name;
          // On supprime le fichier
          DeleteFile(Path + Nom);
        end;
        res:= FindNext(SRec);
      end;
    finally
      FindClose(SRec);
    end;
    Application.ProcessMessages;

    // Recherche des repertoires
    res:= FindFirst(path+'*.*',faDirectory,SRec);
    if res=0 then
    try
      while (res=0) and result do
      begin
        if ((SRec.Attr and faDirectory)=faDirectory)
          and (SRec.Name<>'.') and (SRec.Name<>'..') then
        begin
          Nom:= SRec.Name;
          // On recurse
          path:= path + Nom + '\';
          result:= ScanRep(path);
          // On remonte au precedent
          setlength(path, pathlen);
          RemoveDir(path + Nom);
        end;
        res:= FindNext(SRec);
      end;
    finally
      FindClose(SRec);
    end;
  end;

begin
  ScanRep(Origine);
  result:= RemoveDir(Origine);
end;

function TFPrincipale.DistantCompteRecursif(Origine, Masque: string):longint;
// Masque= '' donne tout
// Masque= '*.*' donne tous les fichiers
// Masque= '*' donne toute l'arborescence
var
  Total: longint;

  procedure ScanRep(var path: string);
  var
    ListeRep: TStrings;
    Nombre: longint;
    N: longint;
    Nom: string;
  begin
    // On se place dans le repertoire
    FtpClient.HostDirName:= path ;
    ExecuteCmd(FtpClient.Cwd);

    // On lit le repertoire
    ListeRep:= TStringList.Create;
    FtpClient.LocalFileName:= TmpFile;
    FtpClient.HostFilename:= Masque;
    ExecuteCmd(FtpClient.Dir);
    FParser.REReponse.Lines.LoadFromFile(TmpFile);
    FParser.Parse(FParser.REReponse.Lines,ParserActuel,FParser.LvTempo);

    // On parcourt la liste et stocke les repertoires
    with FParser.LvTempo do
    begin
      Nombre:= Items.Count;
      for N:= 0 to (Nombre-1) do
      begin
        if Items[N].ImageIndex = NumImgFolder then
        begin
          inc(Total);
          ListeRep.Add(Items[N].Caption);
        end
        else inc(Total);
      end;
    end;

    // Parcours recursif des repertoires
    while ListeRep.Count > 0 do
    begin
      Nom:= ListeRep.Strings[0];
      ScanRep(Nom);
      ListeRep.Delete(0);
    end;
    ListeRep.Free;

    // On revient au repertoire precedent;
    ExecuteCmd(FtpClient.CDup);

    Application.ProcessMessages;
  end;

begin
  Total:= 0;
  ScanRep(Origine);
  result:= Total;
end;

procedure TFPrincipale.DistantScanRecursif(Origine, Masque: string;
  var Compte: longint;Total: longint);
// Masque= '' donne tout
// Masque= '*.*' donne tous les fichiers
// Masque= '*' donne toute l'arborescence

  procedure ScanRep(var path: string);
  var
    ListeRep: TStrings;
    Nombre: longint;
    N: longint;
    Nom: string;
  begin
    // On se place dans le repertoire
    inc(Compte);
    BarreEtat.Panels[1].Text:= IntToStr(Compte)+ ' / ' + IntToStr(Total);
    FtpClient.HostDirName:= path ;
    ExecuteCmd(FtpClient.Cwd);
    // On cree le repertoire local si besoin
    RepLocal:= RepLocal + path + '\';
    if not DirectoryExists(RepLocal) then CreateDir(RepLocal);

    // On lit le repertoire
    ListeRep:= TStringList.Create;
    FtpClient.LocalFileName:= TmpFile;
    FtpClient.HostFilename:= Masque;
    ExecuteCmd(FtpClient.Dir);
    FParser.REReponse.Lines.LoadFromFile(TmpFile);
    FParser.Parse(FParser.REReponse.Lines,ParserActuel,FParser.LvTempo);

    // On parcourt la liste et stocke les repertoires
    with FParser.LvTempo do
    begin
      Nombre:= Items.Count;
      for N:= 0 to (Nombre-1) do
      begin
        if Items[N].ImageIndex = NumImgfolder then ListeRep.Add(Items[N].Caption)
        else
        begin
          inc(Compte);
          BarreEtat.Panels[1].Text:= IntToStr(Compte)+ ' / ' + IntToStr(Total);
          Nom:= Items[N].Caption;
          // On transfert le fichier
          FtpClient.HostFileName:= Nom;
          FtpClient.LocalFileName:= RepLocal + Nom;
          ExecuteCmd(FtpClient.Get);
        end;
      end;
    end;

    // Parcours recursif des repertoires
    while ListeRep.Count > 0 do
    begin
      Nom:= ListeRep.Strings[0];
      ScanRep(Nom);
      ListeRep.Delete(0);
    end;
    ListeRep.Free;

    // On revient au repertoire precedent;
    ExecuteCmd(FtpClient.CDup);
    RepLocal:= RepPrecedentWindows(RepLocal);
    ChDir(RepLocal);

    Application.ProcessMessages;
  end;

begin
  ScanRep(Origine);
end;

function TFPrincipale.DistantDeleteRecursif(Origine: string): boolean;

  procedure ScanRep(var path: string);
  var
    ListeRep: TStrings;
    Nombre: longint;
    N: longint;
    Nom: string;
  begin
    // On se place dans le repertoire
    FtpClient.HostDirName:= path ;
    ExecuteCmd(FtpClient.Cwd);

    // On lit le repertoire
    ListeRep:= TStringList.Create;
    FtpClient.LocalFileName:= TmpFile;
    FtpClient.HostFilename:= '';
    ExecuteCmd(FtpClient.Dir);
    FParser.REReponse.Lines.LoadFromFile(TmpFile);
    FParser.Parse(FParser.REReponse.Lines,ParserActuel,FParser.LvTempo);

    // On parcourt la liste et stocke les repertoires
    with FParser.LvTempo do
    begin
      Nombre:= Items.Count;
      for N:= 0 to (Nombre-1) do
      begin
        if Items[N].ImageIndex = NumImgfolder then ListeRep.Add(Items[N].Caption)
        else
        begin
          Nom:= Items[N].Caption;
          // On supprime le fichier
          FtpClient.HostFileName:= Nom;
          ExecuteCmd(FtpClient.Dele);
        end;
      end;
    end;

    // Parcours recursif des repertoires
    while ListeRep.Count > 0 do
    begin
      Nom:= ListeRep.Strings[0];
      ScanRep(Nom);
      // On supprime le repertoire
      FtpClient.HostFileName:= Nom;
      ExecuteCmd(FtpClient.Rmd);
      ListeRep.Delete(0);
    end;
    ListeRep.Free;

    // On revient au repertoire precedent;
    ExecuteCmd(FtpClient.CDup);

    Application.ProcessMessages;
  end;

begin
  ScanRep(Origine);
  FtpClient.HostFileName:= Origine;
  result:= ExecuteCmd(FtpClient.Rmd);
end;

procedure TFPrincipale.PasseDeconnecte;
begin
  BarreEtat.Panels[0].text:= GetMsg(115);
  ActDistantConnecter.Enabled:= true;
  ActDistantDeconnecter.Enabled:= false;
  AutoriseDistant(False);
  ActLocalEnvoyer.Enabled:= false;
  ActLocalRecevoir.Enabled:= false;
  PnlDistantRep.caption:= '';
  ESysteme.Text:= '';
  LvDistant.Items.Clear;
end;
{*****************************************************************************}
{ Fonctions public                                                            }
{*****************************************************************************}

procedure TFPrincipale.GereLangue(Sender: TObject);
var
  Position: integer;
begin
  with Sender as TMenuItem do
  begin
    LaLangue:= EpureTexte(Caption);
    for Position:= 1 to MenuPrincipal.Items[1].Items[NumItemLangue].Count do
      MenuPrincipal.Items[1].Items[NumItemLangue].Items[Position-1].Checked:= false;
    Checked:= true;
    LitLangue(LaLangue);
  end;
end;

procedure TFPrincipale.AjouteSousMenu(Texte: string);
{ Ajoute une langue au sous menu de langue }
var
  NewItem: TMenuItem;
begin
  NewItem := TMenuItem.Create(Self);
  NewItem.Caption := Texte;
  with MenuPrincipal.Items[1].Items[NumItemLangue] do
  begin
    Add(NewItem);
    Items[Count-1].OnClick:= GereLangue;
  end;
end;

procedure TFPrincipale.VideSousMenu;
{ Enleve tous les sous menus de langue }
begin
  while MenuPrincipal.Items[1].Items[NumItemLangue].Count > 0 do
    MenuPrincipal.Items[1].Items[NumItemLangue].Items[0].free;
end;

procedure TFPrincipale.NouveauAnalyseurClick(Sender: TObject);
begin
  if FParser.Execute(Nouv)then
  begin

    ValideMenuAnalyseur;
  end;
end;

procedure TFPrincipale.EditerAnalyseurClick(Sender: TObject);
begin
  if FParser.Execute(Edt)then
  begin
    FParser.LitParser(ConfigActuelle.LeType,ParserActuel);
    ActDistantLitRepExecute(Sender);
  end;
end;

procedure TFPrincipale.CopierAnalyseurClick(Sender: TObject);
begin
  if FParser.Execute(Cp)then ValideMenuAnalyseur;
end;

procedure TFPrincipale.SupprimerAnalyseurClick(Sender: TObject);
begin
  if FParser.Execute(Del)then ValideMenuAnalyseur;
end;

procedure TFPrincipale.SauverClick(Sender: TObject);
begin
  if DlgSauver.Execute then RichEditCommande.Lines.SaveToFile(DlgSauver.FileName);
end;

procedure TFPrincipale.EffaceClick(Sender: TObject);
begin
  RichEditCommande.Lines.Clear;
end;

procedure TFPrincipale.PreferenceClick(Sender: TObject);
begin
  if FPreferences.Execute then
  begin
    FtpClient.Timeout:= Pref.TimeOut;
  end;
end;

procedure TFPrincipale.ActDistantDeconnecterUpdate(Sender: TObject);
begin
  if (not FtpClient.Connected) and ActDistantDeconnecter.Enabled then
  begin
    PasseDeconnecte;
    AjouteMsg(GetMsg(129));
  end;
end;

end.
