unit Langues;

interface

uses  SysUtils, Menus, Forms;

function ExisteLangue(LaLangue: string): boolean;
procedure CreeMenuLangue;
procedure LitLangue(LaLangue: string);

implementation

uses Utilitaires, Main, Configuration, ChoixNom, ChoixNomParser,
  Parser, Alertes, Preferences;

var
  NomFichierLangue: string; { Nom du fichier Langue }
  FichierLangue: textfile;  { Fichier Langue }

{**********************************************}
{ Test de l'existance du fichier de langue     }
{**********************************************}

function ExisteLangue(LaLangue: string): boolean;
begin
  NomFichierLangue:= RepAppli + LaLangue + ExtLangue;
  Result:= FileExists(NomFichierLangue);
end;

{**********************************************}
{ Ecriture du fichier de langue francais       }
{**********************************************}

procedure CreeEntete;
begin
  writeln(FichierLangue,
    '{----------------------------------------------------------------------------}');
    writeln(FichierLangue,
    '{ Fichier de langue de SFTP V1.0                                             }');
    writeln(FichierLangue,
    '{ Franais                                                                   }');
    writeln(FichierLangue,
    '{                                                                            }');
    writeln(FichierLangue,
    '{ Cr le 16 Aout 2000 par A.JAFFRE                                          }');
    writeln(FichierLangue,
    '{                                                                            }');
    writeln(FichierLangue,
    '{ Pour crer d''autres langues, copier ce fichier en le renommant du nom de la}');
    writeln(FichierLangue,
    '{ langue mais en gardant l extension LSF                                     }');
    writeln(FichierLangue,
    '{ Exemple: pour l''anglais le fichier s''appelera English.LSF                  }');
    writeln(FichierLangue,
    '{                                                                            }');
    writeln(FichierLangue,
    '{ Les lignes commencant par { sont des commentaires.                         }');
    writeln(FichierLangue,
    '{ Ne pas modifier les lignes avant le #.                                     }');
    writeln(FichierLangue,
    '{ Traduire tout ce qui se trouve apres #.                                    }');
    writeln(FichierLangue,
    '{ Le & precede la lettre de raccourci clavier que l on obtiendra avec Alt    }');
    writeln(FichierLangue,
    '{----------------------------------------------------------------------------}');
end;

procedure CreeMenu;
begin
  writeln(FichierLangue,
    '{----------------------------------------------------------------------------}');
  writeln(FichierLangue,
    '{ Menu principal                                                             }');
  writeln(FichierLangue,
    '{----------------------------------------------------------------------------}');
  writeln(FichierLangue,'0001#&Fichier');
  writeln(FichierLangue,'0009#&Quitter');
  writeln(FichierLangue,'0010#Quitte le programme');
  writeln(FichierLangue,'0011#O&utils');
  writeln(FichierLangue,'0012#Lan&gues');
  writeln(FichierLangue,'0013#Permet de choisir la langue d''affichage');
  writeln(FichierLangue,'0014#Machine &locale');
  writeln(FichierLangue,'0015#Configuration de la machine locale');
  writeln(FichierLangue,'0021#Machine &distante');
  writeln(FichierLangue,'0022#Configuration des machines distantes');
  writeln(FichierLangue,'0023#&Nouvelle');
  writeln(FichierLangue,'0024#Cre une nouvelle configuration de machine distante');
  writeln(FichierLangue,'0025#&Editer');
  writeln(FichierLangue,'0026#Permet de modifier une configuration de machine distante');
  writeln(FichierLangue,'0027#&Copier');
  writeln(FichierLangue,'0028#Cre une copie d''une configuration de machine distante');
  writeln(FichierLangue,'0029#&Supprimer');
  writeln(FichierLangue,'0030#Efface une configuration machine distante');
  writeln(FichierLangue,'0031#&Analyseur');
  writeln(FichierLangue,'0032#Configuration des analyseurs');
  writeln(FichierLangue,'0033#&Nouveau');
  writeln(FichierLangue,'0034#Cre un nouvel analyseur');
  writeln(FichierLangue,'0035#&Editer');
  writeln(FichierLangue,'0036#Permet de modifier un analyseur');
  writeln(FichierLangue,'0037#&Copier');
  writeln(FichierLangue,'0038#Cre une copie d''un analyseur');
  writeln(FichierLangue,'0039#&Supprimer');
  writeln(FichierLangue,'0040#Efface un analyseur');
  writeln(FichierLangue,'0050#&Prfrences ...');
  writeln(FichierLangue,'0051#Choix des prfrences de l''utilisateur');
  writeln(FichierLangue,'0091#&Aide');
  writeln(FichierLangue,'0092#&Rubrique d''aide');
  writeln(FichierLangue,'0093#Aide du programme');
  writeln(FichierLangue,'0094#Re&cherche');
  writeln(FichierLangue,'0095#Recherche dans les diffrentes rubriques de l''aide');
  writeln(FichierLangue,'0096#&A propos ...');
  writeln(FichierLangue,'0097#Informations concernant le programme');
end;

procedure CreeLocal;
begin
  writeln(FichierLangue,
    '{----------------------------------------------------------------------------}');
  writeln(FichierLangue,
    '{ Local                                                                      }');
  writeln(FichierLangue,
    '{----------------------------------------------------------------------------}');
  writeln(FichierLangue,'0101#Nom');
  writeln(FichierLangue,'0102#Taille');
  writeln(FichierLangue,'0103#Date');
  writeln(FichierLangue,'0104#Choix du lecteur');
  writeln(FichierLangue,'0105#Remonte au rpertoire prcdent');
  writeln(FichierLangue,'0106#Cre un nouveau rpertoire');
  writeln(FichierLangue,'0107#Petites icnes');
  writeln(FichierLangue,'0108#Liste');
  writeln(FichierLangue,'0109#Dtails');
  writeln(FichierLangue,'0110#Rafrachit l''affichage du rpertoire');
  writeln(FichierLangue,'0111#Machine locale');
end;

procedure CreeDistant;
begin
  writeln(FichierLangue,
    '{----------------------------------------------------------------------------}');
  writeln(FichierLangue,
    '{ Distant                                                                    }');
  writeln(FichierLangue,
    '{----------------------------------------------------------------------------}');
  writeln(FichierLangue,'0151#Nom');
  writeln(FichierLangue,'0152#Taille');
  writeln(FichierLangue,'0153#Date');
  writeln(FichierLangue,'0154#Choix du lecteur');
  writeln(FichierLangue,'0155#Remonte au rpertoire prcdent');
  writeln(FichierLangue,'0156#Cre un nouveau rpertoire');
  writeln(FichierLangue,'0157#Petites icnes');
  writeln(FichierLangue,'0158#Liste');
  writeln(FichierLangue,'0159#Dtails');
  writeln(FichierLangue,'0160#Rafrachit');
  writeln(FichierLangue,'0161#Machine distante');
  writeln(FichierLangue,'0162#Choix de la machine distante');
  writeln(FichierLangue,'0171#Connexion  la machine distante');
  writeln(FichierLangue,'0172#Dconnexion de la machine distante');
end;

procedure CreeConfiguration;
begin
  writeln(FichierLangue,
    '{----------------------------------------------------------------------------}');
  writeln(FichierLangue,
    '{ Fiche de configuration                                                     }');
  writeln(FichierLangue,
    '{----------------------------------------------------------------------------}');
  writeln(FichierLangue,'0301#Cration d''une nouvelle configuration');
  writeln(FichierLangue,'0302#Edition d''une configuration');
  writeln(FichierLangue,'0303#Copie d''une configuration');
  writeln(FichierLangue,'0304#Suppression d''une configuration');
  writeln(FichierLangue,'0311#Machine distante :');
  writeln(FichierLangue,'0312#Choix de la configuration');
  writeln(FichierLangue,'0313#&Ok');
  writeln(FichierLangue,'0314#Accepte l''opration en cours');
  writeln(FichierLangue,'0315#&Annule');
  writeln(FichierLangue,'0316#Annule l''opration en cours');
  writeln(FichierLangue,'0320#Caractristiques');
  writeln(FichierLangue,'0321#');
  writeln(FichierLangue,'0322#Type de machine :');
  writeln(FichierLangue,'0323#Type de machine distante');
  writeln(FichierLangue,'0324#Adresse :');
  writeln(FichierLangue,'0325#Adresse de la machine distante');
  writeln(FichierLangue,'0330#Scurit');
  writeln(FichierLangue,'0331#');
  writeln(FichierLangue,'0336#Login :');
  writeln(FichierLangue,'0337#Nom de la machine distante');
  writeln(FichierLangue,'0338#Mot de passe :');
  writeln(FichierLangue,'0339#Mot de passe de la machine distante');
  writeln(FichierLangue,'0350#Rpertoires');
  writeln(FichierLangue,'0351#');
  writeln(FichierLangue,'0352#Rpertoire local :');
  writeln(FichierLangue,'0353#Choix du rpertoire local  la connexion');
  writeln(FichierLangue,'0354#Rpertoire distant :');
  writeln(FichierLangue,'0355#Choix du rpertoire distant  la connexion');
end;

procedure CreeChoixNom;
begin
  writeln(FichierLangue,
    '{----------------------------------------------------------------------------}');
  writeln(FichierLangue,
    '{ Fiche de choix du nom                                                      }');
  writeln(FichierLangue,
    '{----------------------------------------------------------------------------}');
  writeln(FichierLangue,'0401#Choix du nom');
  writeln(FichierLangue,'0402#Choix de la configuration  copier');
  writeln(FichierLangue,'0403#Configuration  copier');
  writeln(FichierLangue,'0404#Choisir la configuration');
  writeln(FichierLangue,'0405#Nom de la configuration');
  writeln(FichierLangue,'0406#Nom pour la nouvelle configuration');
  writeln(FichierLangue,'0407#&Ok');
  writeln(FichierLangue,'0408#Accepte l''opration en cours');
  writeln(FichierLangue,'0409#&Annule');
  writeln(FichierLangue,'0410#Annule l''opration en cours');
end;

procedure CreeChoixNomParser;
begin
  writeln(FichierLangue,
    '{----------------------------------------------------------------------------}');
  writeln(FichierLangue,
    '{ Fiche de choix du nom de l''analyseur                                       }');
  writeln(FichierLangue,
    '{----------------------------------------------------------------------------}');
  writeln(FichierLangue,'0411#Choix du nom');
  writeln(FichierLangue,'0412#Choix de l''analyseur  copier');
  writeln(FichierLangue,'0413#Analyseur  copier');
  writeln(FichierLangue,'0414#Choisir l''analyseur');
  writeln(FichierLangue,'0415#Nom de l''analyseur');
  writeln(FichierLangue,'0416#Nom pour le nouvel analyseur');
  writeln(FichierLangue,'0417#&Ok');
  writeln(FichierLangue,'0418#Accepte l''opration en cours');
  writeln(FichierLangue,'0419#&Annule');
  writeln(FichierLangue,'0420#Annule l''opration en cours');
end;

procedure CreeParser;
begin
  writeln(FichierLangue,
    '{----------------------------------------------------------------------------}');
  writeln(FichierLangue,
    '{ Fiche de l''analyseur                                                       }');
  writeln(FichierLangue,
    '{----------------------------------------------------------------------------}');
  writeln(FichierLangue,'0501#Cration d''un analyseur');
  writeln(FichierLangue,'0502#Edition d''un analyseur');
  writeln(FichierLangue,'0503#Copie d''un analyseur');
  writeln(FichierLangue,'0504#Suppression d''un analyseur');
  writeln(FichierLangue,'0511#Analyseur :');
  writeln(FichierLangue,'0512#Choix de l''analyseur');
  writeln(FichierLangue,'0513#&Ok');
  writeln(FichierLangue,'0514#Accepte l''opration en cours');
  writeln(FichierLangue,'0515#&Annule');
  writeln(FichierLangue,'0516#Annule l''opration en cours');
  writeln(FichierLangue,'0517#Analyse le retour du serveur');
  writeln(FichierLangue,'0520#Elments de longueur fixe');
  writeln(FichierLangue,'0521#Nom');
  writeln(FichierLangue,'0522#Taille');
  writeln(FichierLangue,'0523#Date');
  writeln(FichierLangue,'0524#Rsultat d''analyse');
  writeln(FichierLangue,'0525#Saute dbut :');
  writeln(FichierLangue,'0526#Nombre de lignes  sauter en dbut de reception');
  writeln(FichierLangue,'0527#Saute fin :');
  writeln(FichierLangue,'0528#Nombre de lignes  sauter en fin de rception');
  writeln(FichierLangue,'0529#Nom :');
  writeln(FichierLangue,'0530#Numro du premier bloc pour le nom');
  writeln(FichierLangue,'0531#Numro du dernier bloc pour le nom');
  writeln(FichierLangue,'0532#Taille :');
  writeln(FichierLangue,'0533#Numro du premier bloc pour la taille');
  writeln(FichierLangue,'0534#Numro du dernier bloc pour la taille');
  writeln(FichierLangue,'0535#Date :');
  writeln(FichierLangue,'0536#Numro du premier bloc pour la date');
  writeln(FichierLangue,'0537#Numro du dernier bloc pour la date');
  writeln(FichierLangue,'0538#Attributs :');
  writeln(FichierLangue,'0539#Numro du premier bloc pour les attributs');
  writeln(FichierLangue,'0540#Numro du dernier bloc pour les attributs');
  writeln(FichierLangue,'0551#Type de site');
  writeln(FichierLangue,'0552#Valeur renvoye par le serveur');
  writeln(FichierLangue,'0553#Retour du serveur');
  writeln(FichierLangue,'0554#Possibilits dtectes');
  writeln(FichierLangue,'0555#Interrogation du serveur');
end;

procedure CreePreferences;
begin
  writeln(FichierLangue,
    '{----------------------------------------------------------------------------}');
  writeln(FichierLangue,
    '{ Fiche des preferences                                                      }');
  writeln(FichierLangue,
    '{----------------------------------------------------------------------------}');
  writeln(FichierLangue,'0601#Sauver');
  writeln(FichierLangue,'0602#Dfinition des prfrences  sauvegarder');
  writeln(FichierLangue,'0603#&Position de la fentre');
  writeln(FichierLangue,'0604#Ouvrira SFTP  la mme position');
  writeln(FichierLangue,'0605#&Langue utilise');
  writeln(FichierLangue,'0606#Ouvrira SFTP avec la langue de la dernire utilisation');
  writeln(FichierLangue,'0607#&Rpertoire local');
  writeln(FichierLangue,'0608#SFTP s''ouvrira dans le rpertoire o il tait  la fermeture');
  writeln(FichierLangue,'0609#&Machine distante');
  writeln(FichierLangue,'0610#SFTP s''ouvrira en slectionnant la machine distante de la fermeture');
  writeln(FichierLangue,'0611#Timeout en secondes');
  writeln(FichierLangue,'0612#Dlai au del du quel il y a chec');
  writeln(FichierLangue,'0651#&Ok');
  writeln(FichierLangue,'0652#Accepte l''opration en cours');
  writeln(FichierLangue,'0653#&Annule');
  writeln(FichierLangue,'0654#Annule l''opration en cours');
end;

procedure CreeErreurs;
begin
  writeln(FichierLangue,
    '{----------------------------------------------------------------------------}');
  writeln(FichierLangue,
    '{ Messages d''erreur                                                          }');
  writeln(FichierLangue,
    '{----------------------------------------------------------------------------}');
  writeln(FichierLangue,'1001#Lecteur');
  writeln(FichierLangue,'1002#non disponible');
  writeln(FichierLangue,'1003#Impossible de supprimer ce rpertoire.');
  writeln(FichierLangue,'1004#Rpertoire non vide ou protg.');
  writeln(FichierLangue,'1005#Impossible de supprimer ce fichier.');
  writeln(FichierLangue,'1006#Impossible de crer ce rpertoire.');
  writeln(FichierLangue,'1051#Il manque un nom.');
  writeln(FichierLangue,'1052#Il manque l''adresse.');
  writeln(FichierLangue,'1053#Il manque le rpertoire distant.');
  writeln(FichierLangue,'1054#Ce nom existe dj !');
  writeln(FichierLangue,'1055#Configuration en cours d''utilisation.');
  writeln(FichierLangue,'1056#Suppression interdite.');
  writeln(FichierLangue,'1057#Cette zone ne peut tre vide !');
  writeln(FichierLangue,'1058#Analyseur en cours d''utilisation.');
end;

procedure CreeDivers;
begin
  writeln(FichierLangue,
    '{----------------------------------------------------------------------------}');
  writeln(FichierLangue,
    '{ Messages d''erreur                                                          }');
  writeln(FichierLangue,
    '{----------------------------------------------------------------------------}');
  writeln(FichierLangue,'1101#Supprimer :');
  writeln(FichierLangue,'1111#Connexion tablie avec :');
  writeln(FichierLangue,'1112#Connect');
  writeln(FichierLangue,'1113#Echec de la connexion avec :');
  writeln(FichierLangue,'1114#Dconnect de :');
  writeln(FichierLangue,'1115#Dconnect');
  writeln(FichierLangue,'1116#Erreur :');
  writeln(FichierLangue,'1117#Echec de la commande :');
  writeln(FichierLangue,'1118#Hte rsolu');
  writeln(FichierLangue,'1119#Hte invalide');
  writeln(FichierLangue,'1120#de');
  writeln(FichierLangue,'1121#Commande :');
  writeln(FichierLangue,'1122#russie');
  writeln(FichierLangue,'1123#non supporte');
  writeln(FichierLangue,'1124#Dbut de transfert de donnes');
  writeln(FichierLangue,'1125#Transfert de donnes termin.');
  writeln(FichierLangue,'1126#Tentative de connexion  :');
  writeln(FichierLangue,'1127#octets transmis');
  writeln(FichierLangue,'1128#Prparation');
  writeln(FichierLangue,'1129#La machine distante s''est dconnect.');
end;

procedure CreeFichierLangue(LaLangue: string);
begin
  NomFichierLangue:= RepAppli + LaLangue + ExtLangue;
  AssignFile(FichierLangue,NomFichierLangue);
  rewrite(FichierLangue);
  CreeEntete;
  CreeMenu;
  CreeLocal;
  CreeDistant;
  CreeConfiguration;
  CreeChoixNom;
  CreeChoixNomParser;
  CreeParser;
  CreePreferences;
  CreeErreurs;
  CreeDivers;
  closefile(FichierLangue);
end;

{**********************************************}
{ Creation du menu langue                      }
{**********************************************}

procedure CreeMenuLangue;
var
  Recherche: TSearchRec;
  Texte: string;
  Compte: integer;
begin
  Compte:= 0;
  if FindFirst(RepAppli + '*' + ExtLangue, faAnyFile, Recherche) = 0 then
  begin
    FPrincipale.VideSousMenu;
    inc(Compte);
    Texte:= ExtractFileName(Recherche.Name);
    Texte:= copy(Texte,1,length(Texte)-4);
    FPrincipale.AjouteSousMenu(Texte);
    while FindNext(Recherche) = 0 do
    begin
      inc(Compte);
      Texte:= ExtractFileName(Recherche.Name);
      Texte:= copy(Texte,1,length(Texte)-4);
      FPrincipale.AjouteSousMenu(Texte);
    end;
  end;
  if Compte < 2 then FPrincipale.MenuPrincipal.Items[1].Items[NumItemLangue].Visible:= false
                else FPrincipale.MenuPrincipal.Items[1].Items[NumItemLangue].Visible:= true;
  if Compte=0 then CreeFichierLangue(LangueRef);
end;

{**********************************************}
{ Lecture d'un fichier de langue               }
{**********************************************}

procedure TraiteLigne(LaLigne: string);
var
  Numero: longint;
  Texte: string;
begin
  ParseLigne(LaLigne,Numero,Texte);
  case Numero of
  // FPrincipale
    // 0001  0100 Menu principal
      0001: FPrincipale.MenuPrincipal.Items[0].Caption:= Texte;
      0009: FPrincipale.MenuPrincipal.Items[0].Items[1].Caption:= Texte;
      0010: FPrincipale.MenuPrincipal.Items[0].Items[1].Hint:= Texte;
      0011: FPrincipale.MenuPrincipal.Items[1].Caption:= Texte;
      0012: FPrincipale.MenuPrincipal.Items[1].Items[NumItemLangue].Caption:= Texte;
      0013: FPrincipale.MenuPrincipal.Items[1].Items[NumItemLangue].Hint:= Texte;
      0014: FPrincipale.MenuPrincipal.Items[1].Items[1].Caption:= Texte;
      0015: FPrincipale.MenuPrincipal.Items[1].Items[1].Hint:= Texte;
      0021: FPrincipale.MenuPrincipal.Items[1].Items[2].Caption:= Texte;
      0022: FPrincipale.MenuPrincipal.Items[1].Items[2].Hint:= Texte;
      0023: FPrincipale.MenuPrincipal.Items[1].Items[2].Items[0].Caption:= Texte;
      0024: FPrincipale.MenuPrincipal.Items[1].Items[2].Items[0].Hint:= Texte;
      0025: FPrincipale.MenuPrincipal.Items[1].Items[2].Items[1].Caption:= Texte;
      0026: FPrincipale.MenuPrincipal.Items[1].Items[2].Items[1].Hint:= Texte;
      0027: FPrincipale.MenuPrincipal.Items[1].Items[2].Items[2].Caption:= Texte;
      0028: FPrincipale.MenuPrincipal.Items[1].Items[2].Items[2].Hint:= Texte;
      0029: FPrincipale.MenuPrincipal.Items[1].Items[2].Items[4].Caption:= Texte;
      0030: FPrincipale.MenuPrincipal.Items[1].Items[2].Items[4].Hint:= Texte;
      0031: FPrincipale.MenuPrincipal.Items[1].Items[3].Caption:= Texte;
      0032: FPrincipale.MenuPrincipal.Items[1].Items[3].Hint:= Texte;
      0033: FPrincipale.MenuPrincipal.Items[1].Items[3].Items[0].Caption:= Texte;
      0034: FPrincipale.MenuPrincipal.Items[1].Items[3].Items[0].Hint:= Texte;
      0035: FPrincipale.MenuPrincipal.Items[1].Items[3].Items[1].Caption:= Texte;
      0036: FPrincipale.MenuPrincipal.Items[1].Items[3].Items[1].Hint:= Texte;
      0037: FPrincipale.MenuPrincipal.Items[1].Items[3].Items[2].Caption:= Texte;
      0038: FPrincipale.MenuPrincipal.Items[1].Items[3].Items[2].Hint:= Texte;
      0039: FPrincipale.MenuPrincipal.Items[1].Items[3].Items[4].Caption:= Texte;
      0040: FPrincipale.MenuPrincipal.Items[1].Items[3].Items[4].Hint:= Texte;
      0041: FPrincipale.MenuPrincipal.Items[1].Items[4].Caption:= Texte;
      0042: FPrincipale.MenuPrincipal.Items[1].Items[4].Hint:= Texte;
      0091: FPrincipale.MenuPrincipal.Items[2].Caption:= Texte;
      0092: FPrincipale.MenuPrincipal.Items[2].Items[0].Caption:= Texte;
      0093: FPrincipale.MenuPrincipal.Items[2].Items[0].Hint:= Texte;
      0094: FPrincipale.MenuPrincipal.Items[2].Items[1].Caption:= Texte;
      0095: FPrincipale.MenuPrincipal.Items[2].Items[1].Hint:= Texte;
      0096: FPrincipale.MenuPrincipal.Items[2].Items[3].Caption:= Texte;
      0097: FPrincipale.MenuPrincipal.Items[2].Items[3].Hint:= Texte;
    // 0101  0150 Local
      0101: FPrincipale.LvLocal.Columns[0].Caption:= Texte;
      0102: FPrincipale.LvLocal.Columns[1].Caption:= Texte;
      0103: FPrincipale.LvLocal.Columns[2].Caption:= Texte;
      0104: FPrincipale.DCBLocal.Hint:= Texte;
      0105: FPrincipale.ActLocalRepPrecedent.Hint:= Texte;
      0106: FPrincipale.ActLocalCreeRep.Hint:= Texte;
      0107: FPrincipale.ActLocalIcone.Hint:= Texte;
      0108: FPrincipale.ActLocalListe.Hint:= Texte;
      0109: FPrincipale.ActLocalDetail.Hint:= texte;
      0110: FPrincipale.ActLocalLitRep.Hint:= Texte;
      0111: FPrincipale.LLocal.Caption:= Texte;
    // 0151  0200 Distant
      0151: FPrincipale.LvDistant.Columns[0].Caption:= Texte;
      0152: FPrincipale.LvDistant.Columns[1].Caption:= Texte;
      0153: FPrincipale.LvDistant.Columns[2].Caption:= Texte;
      0155: FPrincipale.ActDistantRepPrecedent.Hint:= Texte;
      0156: FPrincipale.ActDistantCreeRep.Hint:= Texte;
      0157: FPrincipale.ActDistantIcone.Hint:= Texte;
      0158: FPrincipale.ActDistantListe.Hint:= Texte;
      0159: FPrincipale.ActDistantDetail.Hint:= texte;
      0160: FPrincipale.ActDistantLitRep.Hint:= Texte;
      0161: FPrincipale.LDistant.Caption:= Texte;
      0162: FPrincipale.CbMachineDistante.Hint:= Texte;
      0171: FPrincipale.ActDistantConnecter.Hint:= Texte;
      0172: FPrincipale.ActDistantDeconnecter.Hint:= texte;
  //FConfiguration
    // 0301  0400
      0301: FConfiguration.L1.Caption:= Texte;
      0302: FConfiguration.L2.Caption:= Texte;
      0303: FConfiguration.L3.Caption:= Texte;
      0304: FConfiguration.L4.Caption:= Texte;
      0311: FConfiguration.LMachineDistante.Caption:= Texte;
      0312: FConfiguration.CbMachineDistante.Hint:= Texte;
      0313: FConfiguration.BtnOk.Caption:= Texte;
      0314: FConfiguration.BtnOk.Hint:= Texte;
      0315: FConfiguration.BtnAnnule.Caption:= Texte;
      0316: FConfiguration.BtnAnnule.Hint:= Texte;
      0320: FConfiguration.TsCaracteristique.Caption:= Texte;
      0321: FConfiguration.TsCaracteristique.Hint:= Texte;
      0322: FConfiguration.LTypeDistant.Caption:= Texte;
      0323: FConfiguration.CbTypeDistant.Hint:= Texte;
      0324: FConfiguration.LAdresse.Caption:= Texte;
      0325: FConfiguration.EAdresse.Hint:= Texte;
      0330: FConfiguration.TsSecurite.Caption:= Texte;
      0331: FConfiguration.TsSecurite.Hint:= Texte;
      0336: FConfiguration.LLogin.Caption:= Texte;
      0337: FConfiguration.ELogin.Hint:= Texte;
      0338: FConfiguration.LMotDePasse.Caption:= Texte;
      0339: FConfiguration.EMotDePasse.Hint:= Texte;
      0350: FConfiguration.TsRepertoire.Caption:= Texte;
      0351: FConfiguration.TsRepertoire.Hint:= Texte;
      0352: FConfiguration.LRepLocal.Caption:= Texte;
      0353: FConfiguration.ERepLocal.Hint:= Texte;
      0354: FConfiguration.LRepDistant.Caption:= Texte;
      0355: FConfiguration.ERepDistant.Hint:= Texte;
  //FChoixNom
    // 0401  0410
      0401: FChoixNom.L1.Caption:= Texte;
      0402: FChoixNom.L2.Caption:= Texte;
      0403: FChoixNom.LConfigACopier.Caption:= Texte;
      0404: FChoixNom.CbMachineDistante.Hint:= Texte;
      0405: FChoixNom.LNom.Caption:= Texte;
      0406: FChoixNom.ENom.Hint:= Texte;
      0407: FChoixNom.BtnOk.Caption:= Texte;
      0408: FChoixNom.BtnOk.Hint:= Texte;
      0409: FChoixNom.BtnAnnule.Caption:= Texte;
      0410: FChoixNom.BtnAnnule.Hint:= Texte;
  //FChoixNomParser
    // 0411  0420
      0411: FChoixNomParser.L1.Caption:= Texte;
      0412: FChoixNomParser.L2.Caption:= Texte;
      0413: FChoixNomParser.LConfigACopier.Caption:= Texte;
      0414: FChoixNomParser.CbMachineDistante.Hint:= Texte;
      0415: FChoixNomParser.LNom.Caption:= Texte;
      0416: FChoixNomParser.ENom.Hint:= Texte;
      0417: FChoixNomParser.BtnOk.Caption:= Texte;
      0418: FChoixNomParser.BtnOk.Hint:= Texte;
      0419: FChoixNomParser.BtnAnnule.Caption:= Texte;
      0420: FChoixNomParser.BtnAnnule.Hint:= Texte;
  //FParser
    // 0501  0600
      0501: FParser.L1.Caption:= Texte;
      0502: FParser.L2.Caption:= Texte;
      0503: FParser.L3.Caption:= Texte;
      0504: FParser.L4.Caption:= Texte;
      0511: FParser.LAnalyseur.Caption:= Texte;
      0512: FParser.CBAnalyseur.Hint:= Texte;
      0513: FParser.BtnOk.Caption:= Texte;
      0514: FParser.BtnOk.Hint:= Texte;
      0515: FParser.BtnAnnule.Caption:= Texte;
      0516: FParser.BtnAnnule.Hint:= Texte;
      0517: FParser.SBtnParse.Hint:= texte;
      0520: FParser.ChBLongueurFixe.Caption:= Texte;
      0521: FParser.LVTempo.Columns[0].Caption:= Texte;
      0522: FParser.LVTempo.Columns[1].Caption:= Texte;
      0523: FParser.LVTempo.Columns[2].Caption:= Texte;
      0524: FParser.LVTempo.Hint:= Texte;
      0525: FParser.LSauteDebut.Caption:= Texte;
      0526: FParser.ESauteDebut.Hint:= Texte;
      0527: FParser.LSauteFin.Caption:= Texte;
      0528: FParser.ESauteFin.Hint:= Texte;
      0529: FParser.LNom.Caption:= Texte;
      0530: FParser.EPremNom.Hint:= Texte;
      0531: FParser.EDerNom.Hint:= Texte;
      0532: FParser.LTaille.Caption:= Texte;
      0533: FParser.EPremTaille.Hint:= Texte;
      0534: FParser.EDerTaille.Hint:= Texte;
      0535: FParser.LDate.Caption:= Texte;
      0536: FParser.EPremDate.Hint:= Texte;
      0537: FParser.EDerDate.Hint:= Texte;
      0538: FParser.LAttribut.Caption:= Texte;
      0539: FParser.EPremAttribut.Hint:= Texte;
      0540: FParser.EDerAttribut.Hint:= Texte;
      0551: FParser.LSite.Caption:= Texte;
      0552: FParser.ESite.Hint:= Texte;
      0553: FParser.REReponse.Hint:= Texte;
      0554: FParser.LBDetect.Hint:= Texte;
      0555: FParser.BtnInterroge.Hint:= Texte;
  //FPreference
    // 0601  0700
      0601: FPreferences.GBSauver.Caption:= Texte;
      0602: FPreferences.GBSauver.Hint:= Texte;
      0603: FPreferences.ChBWindow.Caption:= Texte;
      0604: FPreferences.ChBWindow.Hint:= Texte;
      0605: FPreferences.ChBLangue.Caption:= Texte;
      0606: FPreferences.ChBLangue.Hint:= Texte;
      0607: FPreferences.ChBRepLocal.Caption:= Texte;
      0608: FPreferences.ChBRepLocal.Hint:= Texte;
      0609: FPreferences.ChBHost.Caption:= Texte;
      0610: FPreferences.ChBHost.Hint:= Texte;
      0611: FPreferences.LblTimeout.Caption:= Texte;
      0612: FPreferences.JvSpinEditTimeOut.Hint:= Texte;
      0651: FPreferences.BtnOk.Caption:= texte;
      0652: FPreferences.BtnOk.Hint:= Texte;
      0653: FPreferences.BtnAnnule.Caption:= Texte;
      0654: FPreferences.BtnAnnule.Hint:= Texte;
    // Erreurs
      else if Numero>1000 then StockeMessage(Numero mod 1000,Texte);
  end;
end;

procedure LitLangue(LaLangue: string);
var
  Ligne: string;
  NomFichierAide: string;
begin
  NomFichierLangue:= RepAppli + LaLangue + ExtLangue;
  AssignFile(FichierLangue,NomFichierLangue);
  reset(FichierLangue);
  while not Eof(FichierLangue) do
  begin
    readln(FichierLangue,Ligne);
    Ligne:= trim(Ligne);
    if (Ligne<>'') and (Ligne[1]<>'{') then TraiteLigne(Ligne);
  end;
  closefile(FichierLangue);
  FPrincipale.Update;

  NomFichierAide:= RepAppli + LaLangue + ExtAide;
  if FileExists(NomFichierAide) then Application.HelpFile:= NomFichierAide
     else Application.HelpFile:= RepAppli + 'Franais' + ExtAide;
end;

end.
