unit Configuration;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, ExtCtrls, StdCtrls, Mask,  FileCtrl, IniFiles, Buttons;

type
  TModeCfg = (NouvCfg,EdtCfg,CpCfg,DelCfg);

  Config = record
             LeNom: string;
             LeLogin: string;
             LeMotDePasse: string;
             LeType: string;
             LAdresse: string;
             LeRepLocal: string;
             LeRepDistant: string;
           end;

  TFConfiguration = class(TForm)
    PnlBas: TPanel;
    PcConfig: TPageControl;
    PnlHaut: TPanel;
    LMachineDistante: TLabel;
    CbMachineDistante: TComboBox;
    BtnOk: TButton;
    BtnAnnule: TButton;
    TsCaracteristique: TTabSheet;
    TsSecurite: TTabSheet;
    TsRepertoire: TTabSheet;
    LLogin: TLabel;
    LMotDePasse: TLabel;
    ELogin: TEdit;
    EMotDePasse: TEdit;
    CbTypeDistant: TComboBox;
    LTypeDistant: TLabel;
    EAdresse: TEdit;
    LAdresse: TLabel;
    LRepLocal: TLabel;
    LRepDistant: TLabel;
    ERepDistant: TEdit;
    L1: TLabel;
    L2: TLabel;
    L3: TLabel;
    L4: TLabel;
    ERepLocal: TEdit;
    SBtnRepLocal: TSpeedButton;
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure CbMachineDistanteChange(Sender: TObject);
    procedure ELoginChange(Sender: TObject);
    procedure EMotDePasseChange(Sender: TObject);
    procedure CbTypeDistantChange(Sender: TObject);
    procedure EAdresseChange(Sender: TObject);
    procedure ERepLocalChange(Sender: TObject);
    procedure ERepDistantChange(Sender: TObject);
    procedure EChaineLoginKeyPress(Sender: TObject; var Key: Char);
    procedure EChaineLoginKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure SBtnRepLocalClick(Sender: TObject);
    procedure BtnOkClick(Sender: TObject);
  private
    { Dclarations prives }
    procedure EcritConfiguration(Numero: longint);
    procedure SupprimeConfiguration(Numero: longint);
    procedure AfficheConfiguration;
    procedure ConfigurationModifiable(Autorise: boolean);
  public
    { Dclarations publiques }
    LaConfig: Config;
    LeMode: TModecfg;

    function LitNomConfig: boolean;
    procedure LitConfiguration(Nom: string;var UneConfig: Config);
    procedure SetUtilisee(Nom: string);
    function Execute(Mode: TModeCfg; Index: longint): boolean;
  end;

const
  NomFichierConfig= 'host.ini';

  SectionHost= 'Hosts';
  CleLogin= 'Login';
  CleMotDePasse= 'Password';
  CleType= 'Parser';
  CleAdresse= 'Address';
  CleRepLocal= 'LocalDir';
  CleRepDistant= 'HostDir';

var
  FConfiguration: TFConfiguration;

implementation

{$R *.DFM}

uses Utilitaires, Alertes, ChoixNom, Parser;
// Le numero de la configuration lors des lectures/ecriture est a base 0

var
  ConfigUtilisee: string;
  Delta: longint;

{*****************************************************************************}
{ Utilitaires                                                                 }
{*****************************************************************************}

function Crypte(Texte: string): string;
var
  N: longint;
  Code: longint;
  Tmp: string;
begin
  Delta:= 5;
  Tmp:= '';
  for N:= 1 to length(Texte) do
  begin
    Code:= ord(Texte[N])+Delta;
    if Code>255 then dec(Code,256);
    Tmp:= Tmp + chr(Code);
    Delta:= ord(Texte[N]) div 4;
  end;
  result:= Tmp;
end;

function DeCrypte(Texte: string): string;
var
  N: longint;
  Code: longint;
  Tmp: string;
begin
  Delta:= 5;
  Tmp:= '';
  for N:= 1 to length(Texte) do
  begin
    Code:= ord(Texte[N])-Delta;
    if Code<0 then inc(Code,256);
    Tmp:= Tmp + chr(Code);
    Delta:= Code div 4;
  end;
  result:= Tmp;
end;

{*****************************************************************************}
{ Fonctions de la fiche                                                       }
{*****************************************************************************}

procedure TFConfiguration.FormCreate(Sender: TObject);
begin
//
end;

procedure TFConfiguration.FormShow(Sender: TObject);
begin
  PcConfig.ActivePageIndex:= 0;
  case LeMode of
    NouvCfg : begin
                CbMachineDistante.Enabled:= false;
                Caption:= L1.Caption;
                ConfigurationModifiable(true);
                ELogin.SetFocus;
              end;
    EdtCfg  : begin
                CbMachineDistante.Enabled:= true;
                Caption:= L2.Caption;
                ConfigurationModifiable(true);
                CbMachineDistante.SetFocus;
              end;
    CpCfg   : begin
                CbMachineDistante.Enabled:= false;
                Caption:= L3.Caption;
                ConfigurationModifiable(true);
                ELogin.SetFocus;
              end;
    DelCfg  : begin
                CbMachineDistante.Enabled:= true;
                Caption:= L4.Caption;
                ConfigurationModifiable(false);
              end;
  end;
  SBtnRepLocal.Hint:= ERepLocal.Hint;
end;

procedure TFConfiguration.CbMachineDistanteChange(Sender: TObject);
begin
  LitConfiguration(CbMachineDistante.Items[CbMachineDistante.ItemIndex], LaConfig);
  AfficheConfiguration;
end;

procedure TFConfiguration.ELoginChange(Sender: TObject);
begin
  LaConfig.LeLogin:= ELogin.Text;
end;

procedure TFConfiguration.EMotDePasseChange(Sender: TObject);
begin
  LaConfig.LeMotDePasse:= EMotDePasse.Text;
end;

procedure TFConfiguration.CbTypeDistantChange(Sender: TObject);
begin
  LaConfig.LeType:= CbTypeDistant.Items[CbTypeDistant.ItemIndex];
end;

procedure TFConfiguration.EAdresseChange(Sender: TObject);
begin
  LaConfig.LAdresse:= EAdresse.Text;
end;

procedure TFConfiguration.ERepLocalChange(Sender: TObject);
begin
  LaConfig.LeRepLocal:= ERepLocal.Text;
end;

procedure TFConfiguration.ERepDistantChange(Sender: TObject);
begin
  LaConfig.LeRepDistant:= ERepDistant.Text;
end;

procedure TFConfiguration.EChaineLoginKeyPress(Sender: TObject;
  var Key: Char);
begin
  if key=#13 then key:= #0;
end;

procedure TFConfiguration.EChaineLoginKeyDown(Sender: TObject;
  var Key: Word; Shift: TShiftState);
begin
  if Key = VK_RETURN then perform(WM_NEXTDLGCTL,0,0);
end;

procedure TFConfiguration.SBtnRepLocalClick(Sender: TObject);
var
  Repertoire: string;
begin
  if SelectDirectory('','',Repertoire) then ERepLocal.Text:= Repertoire;
end;

procedure TFConfiguration.BtnOkClick(Sender: TObject);
begin
  if (LeMode= DelCfg) and
     (CbMachineDistante.Items[CbMachineDistante.ItemIndex]= ConfigUtilisee)   then
  begin
    PcConfig.ActivePageIndex:= 1;
    CbMachineDistante.SetFocus;
    BoiteMessage(55,'','');
    ModalResult:= mrNone;
  end
  else
  if EAdresse.Text= '' then
  begin
    PcConfig.ActivePageIndex:= 1;
    EAdresse.SetFocus;
    BoiteMessage(52,'','');
    ModalResult:= mrNone;
  end
  else
  if ERepDistant.Text= '' then
  begin
    PcConfig.ActivePageIndex:= 2;
    ERepDistant.SetFocus;
    BoiteMessage(53,'','');
    ModalResult:= mrNone;
  end
  else ModalResult:= mrOk;
end;

{*****************************************************************************}
{ Fonctions privee                                                            }
{*****************************************************************************}

procedure TFConfiguration.EcritConfiguration(Numero: longint);
var
  FichierConfig: TIniFile;
  N: longint;
begin
  FichierConfig:= TIniFile.Create(RepAppli+NomFichierConfig);
  // Trie et enregistrement des nom de config
  CbMachineDistante.Sorted:= true;
  for N:= 1 to CbMachineDistante.Items.Count do
  begin
    FichierConfig.WriteString(SectionHost,
      'Name'+IntToStr(N-1),CbMachineDistante.Items[N-1]);
  end;
  CbMachineDistante.Sorted:= false;
  // Sauvegarde de la config
  with LaConfig do
  begin
    FichierConfig.WriteString(LeNom,CleLogin,LeLogin);
    FichierConfig.WriteString(LeNom,CleMotDePasse,Crypte(LeMotDePasse));
    FichierConfig.WriteString(LeNom,CleType,LeType);
    FichierConfig.WriteString(LeNom,CleAdresse,LAdresse);
    FichierConfig.WriteString(LeNom,CleRepLocal,LeRepLocal);
    FichierConfig.WriteString(LeNom,CleRepDistant,LeRepDistant);
  end;
  FichierConfig.Free;
end;

procedure TFConfiguration.SupprimeConfiguration(Numero: longint);
var
  FichierConfig: TIniFile;
  N: longint;
begin
  FichierConfig:= TIniFile.Create(RepAppli+NomFichierConfig);
  if FichierConfig.SectionExists(LaConfig.LeNom) then
     FichierConfig.EraseSection(LaConfig.LeNom);
  FichierConfig.EraseSection(SectionHost);
  for N:= 0 to CbMachineDistante.Items.Count-1 do
    FichierConfig.WriteString(SectionHost,'Name'+IntToStr(N),
      CbMachineDistante.Items[N]);
  FichierConfig.Free;
end;

procedure TFConfiguration.AfficheConfiguration;
var
  N: longint;
begin
  with LaConfig do
  begin
    CbMachineDistante.Text:= LeNom;
    ELogin.Text:= LeLogin;
    EMotDePasse.Text:= LeMotDePasse;
    N:= CbTypeDistant.Items.IndexOf(LeType);
    if N=-1 then CbTypeDistant.ItemIndex:= CbTypeDistant.Items.Count-1
            else CbTypeDistant.ItemIndex:= N;
    EAdresse.Text:= LAdresse;
    ERepLocal.Text:= LeRepLocal;
    ERepDistant.Text:= LeRepDistant;
  end;
end;

procedure TFConfiguration.ConfigurationModifiable(Autorise: boolean);
begin
  ELogin.Enabled:= Autorise;
  EMotDePasse.Enabled:= Autorise;
  CbTypeDistant.Enabled:= Autorise;
  EAdresse.Enabled:= Autorise;
  ERepLocal.Enabled:= Autorise;
  ERepDistant.Enabled:= Autorise;
end;

{*****************************************************************************}
{ Fonctions public                                                            }
{*****************************************************************************}

function TFConfiguration.LitNomConfig: boolean;
var
  FichierConfig: TIniFile;
  Nom: string;
  N: longint;
begin
  result:= false;
  CbMachineDistante.Items.Clear;
  FichierConfig:= TIniFile.Create(RepAppli+NomFichierConfig);
  Nom:= FichierConfig.ReadString(SectionHost,'Name0','');
  N:=1;
  while Nom > '' do
  begin
    CbMachineDistante.Items.Add(Nom);
    Nom:= FichierConfig.ReadString(SectionHost,'Name' + IntToStr(N),'');
    inc(N);
  end;
  if CbMachineDistante.Items.Count>0 then result:= true;
end;

procedure TFConfiguration.LitConfiguration(Nom: string; var UneConfig: Config);
var
  FichierConfig: TIniFile;
begin
  FichierConfig:= TIniFile.Create(RepAppli+NomFichierConfig);
  with UneConfig do
  begin
    LeNom:= Nom;
    LeLogin:= FichierConfig.ReadString(LeNom,CleLogin,LeLogin);
    LeMotDePasse:= Decrypte(FichierConfig.ReadString(LeNom,CleMotDePasse,LeMotDePasse));
    LeType:= FichierConfig.ReadString(LeNom,CleType,LeType);
    LAdresse:= FichierConfig.ReadString(LeNom,CleAdresse,LAdresse);
    LeRepLocal:= FichierConfig.ReadString(LeNom,CleRepLocal,LeRepLocal);
    LeRepDistant:= FichierConfig.ReadString(LeNom,CleRepDistant,LeRepDistant);
  end;
  FichierConfig.Free;
end;

procedure TFConfiguration.SetUtilisee(Nom: string);
begin
  ConfigUtilisee:= Nom;
end;

function TFConfiguration.Execute(Mode: TModeCfg; Index: longint): boolean;
var
  NomDest: string;
  Numero: longint;
begin
  result:= false;
  CBTypeDistant.Items:= FParser.GetListeParser;
  CBTypeDistant.Items.Add(NomParserInconnu);
  LeMode:= Mode;
  CbMachineDistante.ItemIndex:= 0;
  case LeMode of
    NouvCfg : begin
                Numero:= -1;
                if FChoixNom.Execute(CbMachineDistante.Items,NomDest,Numero) then
                begin
                  with LaConfig do
                  begin
                    LeNom:= NomDest;
                    LeLogin:= '';
                    LeMotDePasse:= '';
                    LeType:= NomParserInconnu;
                    LAdresse:= '';
                    LeRepLocal:= RepAppli;
                    LeRepDistant:= '\';
                    CbMachineDistante.Items.Add(LeNom);
                    CbMachineDistante.ItemIndex:= pred(CbMachineDistante.Items.Count);
                  end;
                  AfficheConfiguration;
                  if ShowModal= mrOk then
                  begin
                    EcritConfiguration(CbMachineDistante.ItemIndex);
                    result:= true;
                  end
                  else
                  begin
                    with CbMachineDistante do
                    begin
                      Items.Delete(ItemIndex);
                      if ItemIndex > (Items.Count-1) then ItemIndex:= Items.Count-1;
                    end;
                    result:= false;
                  end;
                end;
              end;
    EdtCfg  : begin
                with CbMachineDistante do
                begin
                  ItemIndex:= Index;
                  LitConfiguration(Items[ItemIndex], LaConfig);
                end;
                AfficheConfiguration;
                if ShowModal= mrOk then
                begin
                  EcritConfiguration(CbMachineDistante.ItemIndex);
                  result:= true;
                end
                else result:= false;
              end;
    CpCfg   : begin
                CbMachineDistante.ItemIndex:= Index;
                Numero:= CbMachineDistante.ItemIndex;
                if FChoixNom.Execute(CbMachineDistante.Items,NomDest,Numero) then
                begin
                  LitConfiguration(CbMachineDistante.Items[Numero], LaConfig);
                  with LaConfig do
                  begin
                    LeNom:= NomDest;
                    CbMachineDistante.Items.Add(LeNom);
                    CbMachineDistante.ItemIndex:= pred(CbMachineDistante.Items.Count);
                  end;
                  AfficheConfiguration;
                  if ShowModal= mrOk then
                  begin
                    EcritConfiguration(CbMachineDistante.ItemIndex);
                    result:= true;
                  end
                  else
                  begin
                    with CbMachineDistante do
                    begin
                      Items.Delete(ItemIndex);
                      if ItemIndex > (Items.Count-1) then ItemIndex:= Items.Count-1;
                    end;
                    result:= false;
                  end;
                end;
              end;
    DelCfg  : begin
                with CbMachineDistante do
                  LitConfiguration(Items[ItemIndex], LaConfig);
                AfficheConfiguration;
                if ShowModal= mrOk then
                begin
                  with CbMachineDistante do
                  begin
                    Items.Delete(ItemIndex);
                    SupprimeConfiguration(ItemIndex);
                    if ItemIndex > (Items.Count-1) then ItemIndex:= Items.Count-1;
                  end;
                  result:= true;
                end
                else result:= false;
              end;
  end;

end;

end.

