unit ChoixNomParser;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TFChoixNomParser = class(TForm)
    BtnOk: TButton;
    BtnAnnule: TButton;
    ENom: TEdit;
    LNom: TLabel;
    L1: TLabel;
    L2: TLabel;
    LConfigACopier: TLabel;
    CbMachineDistante: TComboBox;
    procedure BtnOkClick(Sender: TObject);
    procedure ENomKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure ENomKeyPress(Sender: TObject; var Key: Char);
    procedure FormShow(Sender: TObject);
  private
    { Dclarations prives }
  public
    { Dclarations publiques }
    function Execute(NomSource: TStrings;var NomDest:string;
      var Numero: longint):boolean;
  end;

var
  FChoixNomParser: TFChoixNomParser;

implementation

{$R *.DFM}

uses Alertes;

function TFChoixNomParser.Execute(NomSource: TStrings;var NomDest:string;
  var Numero: longint): boolean;
begin
  if Numero= -1 then
  begin
    Caption:= L1.Caption;
    LConfigACopier.Visible:= false;
    CbMachineDistante.Visible:= false;
    CbMachineDistante.Items:= NomSource;
    LNom.Top:= 42;
    ENom.Top:= 34;
  end
  else
  begin
    Caption:= L2.Caption;
    LConfigACopier.Visible:= true;
    CbMachineDistante.Visible:= true;
    CbMachineDistante.Items:= NomSource;
    CbMachineDistante.ItemIndex:= Numero;
    LNom.Top:= 48;
    ENom.Top:= 40;
  end;
  if ShowModal= mrOk then
  begin
    NomDest:= ENom.Text;
    Numero:= CbMachineDistante.ItemIndex;
    result:= true;
  end
  else result:= false;
end;

procedure TFChoixNomParser.BtnOkClick(Sender: TObject);
begin
  if ENom.Text= '' then
  begin
    BoiteMessage(51,'','');
    ENom.SetFocus;
    ModalResult:= mrNone;
  end;
  if CbMachineDistante.Items.IndexOf(ENom.Text)> -1 then
  begin
    BoiteMessage(54,'','');
    ENom.SetFocus;
    ModalResult:= mrNone;
  end;
end;

procedure TFChoixNomParser.ENomKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key = VK_RETURN then perform(WM_NEXTDLGCTL,0,0);
end;

procedure TFChoixNomParser.ENomKeyPress(Sender: TObject; var Key: Char);
begin
  if key=#13 then key:= #0;
end;

procedure TFChoixNomParser.FormShow(Sender: TObject);
begin
  ENom.SetFocus;
end;

end.
