unit Alertes;

interface

const
  MaxMessage= 200;

procedure VideMessage;
procedure StockeMessage(Num: longint;Texte: string);
function BoiteMessage(Num: longint;Ch1,Ch2: string): word;
function GetMsg(Num: longint): string;

implementation

uses Dialogs;

type
  TMsg= (msgErreur,msgInfo,msgAlerte,msgChoix);
var
  Msg: array[1..MaxMessage] of string;

procedure VideMessage;
var
  N: integer;
begin
  for N:= 1 to MaxMessage do Msg[N]:= '';
end;

procedure StockeMessage(Num: longint;Texte: string);
begin
  Msg[Num]:= Texte;
end;

function AfficheMsg(Texte: string; Genre: TMsg): word;
begin
  case Genre of
    msgErreur: result:= MessageDlg(Texte, mtError, [mbOk], 0);
    msgInfo  : result:= MessageDlg(Texte, mtInformation, [mbOk], 0);
    msgAlerte: result:= MessageDlg(Texte, mtWarning, [mbOk], 0);
    msgChoix : result:= MessageDlg(Texte, mtWarning, [mbYes,mbNo,mbAll], 0);
    else result:= 0;
  end;
end;

function BoiteMessage(Num: longint;Ch1,Ch2: string):word;
var
  Chaine: string;
begin
  case Num of
    // Messages d'erreur
    001 : begin // Lecteur non disponible
            Chaine:= Msg[1]+ ' ''' + Ch1 + ''' ' + Msg[2];
            result:= AfficheMsg(Chaine,msgErreur);
          end;
    002 : begin // Impossible supprimer repertoire
            Chaine:= Ch1 + #13 + Msg[3]+ #13 + Msg[4];
            result:= AfficheMsg(Chaine,msgErreur);
          end;
    003 : begin // Impossible supprimer fichier
            Chaine:= Ch1 + #13 + Msg[5];
            result:= AfficheMsg(Chaine,msgErreur);
          end;
    004 : begin // Impossible crer rpertoire
            Chaine:= Ch1 + #13 + Msg[6];
            result:= AfficheMsg(Chaine,msgErreur);
          end;
    // Message de correction
    051 : begin // Manque nom
            Chaine:= Msg[51];
            result:= AfficheMsg(Chaine,msgAlerte);
          end;
    052 : begin // Manque adresse
            Chaine:= Msg[52];
            result:= AfficheMsg(Chaine,msgAlerte);
          end;
    053 : begin // Manque repertoire destination
            Chaine:= Msg[53];
            result:= AfficheMsg(Chaine,msgAlerte);
          end;
    054 : begin // Nom existe deja
            Chaine:= Msg[54];
            result:= AfficheMsg(Chaine,msgErreur);
          end;
    055 : begin // En cours d'utilisation, suppression interdite
            Chaine:= Msg[55] + #13 + Msg[56];
            result:= AfficheMsg(Chaine,msgErreur);
          end;
    056 : begin // Ne peut etre vide
            Chaine:= Msg[57];
            result:= AfficheMsg(Chaine,msgErreur);
          end;
    057 : begin // En cours d'utilisation, suppression interdite
            Chaine:= Msg[58] + #13 + Msg[56];
            result:= AfficheMsg(Chaine,msgErreur);
          end;
    // Message de dialogue
    101 : begin // Alerte suppression
            Chaine:= Msg[101] + Ch1;
            result:= AfficheMsg(Chaine,msgChoix);
          end;
    else result:= 0;
  end;
end;

function GetMsg(Num: longint): string;
begin
  result:= Msg[Num];
end;

end.
