unit About;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Buttons, ShellApi;

type
  TFAbout = class(TForm)
    BtnOk: TBitBtn;
    Icone: TImage;
    titreCopyright: TLabel;
    TitreProgramme: TLabel;
    TitreVersion: TLabel;
    MemoFr: TMemo;
    MemoGb: TMemo;
    LblWebsite: TLabel;
    LblMailAddress: TLabel;

    procedure FormShow(Sender: TObject);
    procedure LblWebsiteClick(Sender: TObject);
    procedure LblMailAddressClick(Sender: TObject);
  private
    { Dclarations prives }
  public
    { Dclarations publiques }
    Version : string;
  end;

var
  FAbout: TFAbout;

implementation

uses Utilitaires, Main;

{$R *.DFM}

procedure TFAbout.FormShow(Sender: TObject);
begin
  Version := VersionSoft;
  Caption := EpureTexte(FPrincipale.MenuPrincipal.Items[2].Items[3].Caption);
  TitreProgramme.Caption := Application.Title;
  Icone.Picture.Graphic := Application.Icon;
  TitreVersion.Caption := 'Version ' + Version;
end;

procedure TFAbout.LblWebsiteClick(Sender: TObject);
begin
  ShellExecute(0,'open','http://jack.r.free.fr',nil,nil,SW_SHOW);
end;

procedure TFAbout.LblMailAddressClick(Sender: TObject);
begin
  ShellExecute(0,'open','mailto:jack.r@free.fr',nil,nil,SW_SHOW);
end;

end.
