unit Recherche;

{***************************************************************************}
{ Ce logiciel est un logiciel libre. Vous pouvez le diffuser et/ou le       }
{ modifier suivant les termes de la GNU General Public License telle que    }
{ publie par la Free Software Foundation, soit la version 2 de cette        }
{ license, soit ( votre convenance) une version ultrieure.                }
{                                                                           }
{ Ce programme est diffus dans l'espoir qu'il sera utile, mais SANS AUCUNE }
{ GARANTIE, sans mme une garantie implicite de COMMERCIALISABILITE ou      }
{ d'ADEQUATION A UN USAGE PARTICULIER. Voyez la GNU General Public License  }
{ pour plus de dtails.                                                     }
{                                                                           }
{ Vous devriez avoir reu une copie de la GNU General Public License avec   }
{ ce programme, sinon, veuillez crire  la Free Software Foundation, Inc., }
{ 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.                  }
{***************************************************************************}

{***************************************************************************}
{ This program is free software. You can redistribute it and/or modify it   }
{ under the terms of the GNU Public License as published by the             }
{ Free Software Foundation, either version 2 of the license, or             }
{ (at your option) any later version.                                       }
{                                                                           }
{ This program is distributed in the hope it will be useful, but WITHOUT    }
{ ANY WARRANTY, without even the implied warranty of MERCHANTABILITY or     }
{ FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for  }
{ more details.                                                             }
{                                                                           }
{ You should have received a copy of the GNU General Public License along   }
{ with this program, if not, write to the Free Software Foundation, Inc.,   }
{ 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.                  }
{***************************************************************************}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, StdCtrls, ExtCtrls;

type
  TFrmRecherche = class(TForm)
    LChercher: TLabel;
    CbTexteRecherche: TComboBox;
    GbOptions: TGroupBox;
    CboxMajMin: TCheckBox;
    CboxMotsEntiers: TCheckBox;
    RgDirection: TRadioGroup;
    RgOrigine: TRadioGroup;
    RgPortee: TRadioGroup;
    BtnOk: TButton;
    BtnAnnule: TButton;
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
  private
    { Dclarations prives }
    function GetTexte: string;
    function GetHistorique: string;
    function GetMajusculeMinuscule: boolean;
    function GetMotsEntiers: boolean;
    function GetEnArriere: boolean;
    function GetTexteSelectionne: boolean;
    function GetTotalite: boolean;
    procedure SetTexte(Valeur: string);
    procedure SetHistorique(Valeur: string);
    procedure SetMajusculeMinuscule(Valeur: boolean);
    procedure SetMotsEntiers(Valeur: boolean);
    procedure SetEnArriere(Valeur: boolean);
    procedure SetTexteSelectionne(Valeur: boolean);
    procedure SetTotalite(Valeur: boolean);

  public
    { Dclarations publiques }
    property TexteRecherche: string read GetTexte write SetTexte;
    property HistoriqueRecherche: string read GetHistorique
      write SetHistorique;
    property MajusculeMinuscule: boolean read GetMajusculeMinuscule
      write SetMajusculeMinuscule;
    property MotsEntiers: boolean read GetMotsEntiers
      write SetMotsEntiers;
    property EnArriere: boolean read GetEnArriere
      write SetEnArriere;
    property TexteSelectionne: boolean read GetTexteSelectionne
      write SetTexteSelectionne;
    property Totalite: boolean read GetTotalite
      write SetTotalite;

    function Execute(Fichiers: boolean): boolean;
  end;

var
  FrmRecherche: TFrmRecherche;

implementation

{$R *.DFM}

{ TFrmRecherche }

{*****************************************************************************}
{ Fonctions private                                                           }
{*****************************************************************************}

function TFrmRecherche.GetTexte: string;
begin
  result:= CbTexteRecherche.Text;
end;

function TFrmRecherche.GetHistorique: string;
var
  N: longint;
  Chaine: string;
begin
  Chaine:= '';
  for N:= 0 to CbTexteRecherche.Items.Count-1 do
  begin
    Chaine:= Chaine + CbTexteRecherche.Items[N];
    Chaine:= Chaine + #13 + #10;
  end;
  result:= Chaine;
end;

function TFrmRecherche.GetMajusculeMinuscule: boolean;
begin
  result:= CboxMajMin.Checked;
end;

function TFrmRecherche.GetMotsEntiers: boolean;
begin
  result:= CboxMotsEntiers.Checked;
end;

function TFrmRecherche.GetEnArriere: boolean;
begin
  result:= RgDirection.ItemIndex=1;
end;

function TFrmRecherche.GetTexteSelectionne: boolean;
begin
  result:= RgPortee.ItemIndex=1;
end;

function TFrmRecherche.GetTotalite: boolean;
begin
  result:= RgOrigine.ItemIndex=1;
end;

procedure TFrmRecherche.SetTexte(Valeur: string);
begin
  CbTexteRecherche.Text:= Valeur;
end;

procedure TFrmRecherche.SetHistorique(Valeur: string);
begin
  CbTexteRecherche.Text:= Valeur;
end;

procedure TFrmRecherche.SetMajusculeMinuscule(Valeur: boolean);
begin
  CboxMajMin.Checked:= valeur;
end;

procedure TFrmRecherche.SetMotsEntiers(Valeur: boolean);
begin
  CboxMotsEntiers.Checked:= Valeur;
end;

procedure TFrmRecherche.SetEnArriere(Valeur: boolean);
begin
  RgDirection.ItemIndex:= ord(Valeur);
end;

procedure TFrmRecherche.SetTexteSelectionne(Valeur: boolean);
begin
  RgPortee.ItemIndex:= ord(Valeur);
end;

procedure TFrmRecherche.SetTotalite(Valeur: boolean);
begin
  RgOrigine.ItemIndex:= ord(Valeur);
end;

{*****************************************************************************}
{ Fonctions public                                                            }
{*****************************************************************************}

function TFrmRecherche.Execute(Fichiers: boolean): boolean;
begin
  ShowModal;
  result:= ModalResult=mrOK;
end;

{*****************************************************************************}
{ Fiche                                                                       }
{*****************************************************************************}

procedure TFrmRecherche.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
var
  Chaine: string;
  N: longint;
begin
  if ModalResult = mrOK then
  begin
    Chaine := CbTexteRecherche.Text;
    if Chaine <> '' then
    begin
      N := CbTexteRecherche.Items.IndexOf(Chaine);
      if N > -1 then
      begin
        CbTexteRecherche.Items.Delete(N);
        CbTexteRecherche.Items.Insert(0, Chaine);
        CbTexteRecherche.Text := Chaine;
      end
      else CbTexteRecherche.Items.Insert(0, Chaine);
    end;
  end;
end;

end.
