unit Preferences;

{***************************************************************************}
{ Ce logiciel est un logiciel libre. Vous pouvez le diffuser et/ou le       }
{ modifier suivant les termes de la GNU General Public License telle que    }
{ publie par la Free Software Foundation, soit la version 2 de cette        }
{ license, soit ( votre convenance) une version ultrieure.                }
{                                                                           }
{ Ce programme est diffus dans l'espoir qu'il sera utile, mais SANS AUCUNE }
{ GARANTIE, sans mme une garantie implicite de COMMERCIALISABILITE ou      }
{ d'ADEQUATION A UN USAGE PARTICULIER. Voyez la GNU General Public License  }
{ pour plus de dtails.                                                     }
{                                                                           }
{ Vous devriez avoir reu une copie de la GNU General Public License avec   }
{ ce programme, sinon, veuillez crire  la Free Software Foundation, Inc., }
{ 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.                  }
{***************************************************************************}

{***************************************************************************}
{ This program is free software. You can redistribute it and/or modify it   }
{ under the terms of the GNU Public License as published by the             }
{ Free Software Foundation, either version 2 of the license, or             }
{ (at your option) any later version.                                       }
{                                                                           }
{ This program is distributed in the hope it will be useful, but WITHOUT    }
{ ANY WARRANTY, without even the implied warranty of MERCHANTABILITY or     }
{ FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for  }
{ more details.                                                             }
{                                                                           }
{ You should have received a copy of the GNU General Public License along   }
{ with this program, if not, write to the Free Software Foundation, Inc.,   }
{ 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.                  }
{***************************************************************************}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, IniFiles, ComCtrls;

type
  RecPreferences = record
                     SauveFenetre: boolean;
                     SauveLangue: boolean;
                     SauveEditeur: boolean;
                     Maximiser: boolean;

                     MargeVisible: boolean;
                     NumerosDeLigne: boolean;
                     ZerosDeTete: boolean;
                     MaxiEditeur: boolean;
                   end;
  TFrmPreferences = class(TForm)
    PCtrlPreferences: TPageControl;
    TShProgramme: TTabSheet;
    TshEditeur: TTabSheet;
    GBProgramme: TGroupBox;
    ChBWindow: TCheckBox;
    ChBLangue: TCheckBox;
    ChBEditeur: TCheckBox;
    ChBFenetrePrincipale: TCheckBox;
    GBEditeur: TGroupBox;
    ChBMargeVisible: TCheckBox;
    ChBNumerosDeLigne: TCheckBox;
    ChBZerosDeTete: TCheckBox;
    ChBMaximiserEditeur: TCheckBox;
    BtnOk: TButton;
    BtnAnnule: TButton;
    procedure FormShow(Sender: TObject);
    procedure ChBMargeVisibleClick(Sender: TObject);
    procedure ChBNumerosDeLigneClick(Sender: TObject);
  private
    { Dclarations prives }
  public
    { Dclarations publiques }
    procedure LitPreferences;
    procedure EcritPreferences(Top,Left,Height,Width: integer;
      Langue: string);
    procedure GetFenetre(var Top,Left,Height,Width: integer);
    function GetLangue: string;
    procedure GetEditeur(var Visible,NumLigne,Zero,Maxi: boolean);
    function Execute(Titre: string): boolean;
  end;

const
  NomFichierPref= 'sedit.ini';
var
  FrmPreferences: TFrmPreferences;
  Pref: RecPreferences;

implementation

{$R *.DFM}

uses Utilitaires, Data;

const
  SectionSauve= 'Save';
  CleFenetre= 'Window';
  CleLangue= 'Language';
  CleEditeur= 'Editor';

  SectionFenetre= 'Window';
  CleTop= 'Top';
  CleLeft= 'Left';
  CleHeight= 'Height';
  CleWidth= 'Width';
  CleMaxi= 'FullScreen';

  SectionEtat= 'Status';

  SectionEditeur= 'Editor';
  CleMarge= 'Gutter';
  CleNumerosDeLigne= 'LineNumbers';
  CleZerosDeTete= 'LeadingZero';
  CleMaxiEdt= 'Maximum';

  SectionFichiersRecents= 'RecentFile';
  CleFichierRecent= 'File';

{*****************************************************************************}
{ Fonctions de la fiche                                                       }
{*****************************************************************************}

procedure TFrmPreferences.FormShow(Sender: TObject);
begin
  PCtrlPreferences.ActivePage:= TShProgramme;
  with Pref do
  begin
    ChBWindow.Checked:= SauveFenetre;
    ChBLangue.Checked:= SauveLangue;
    ChBEditeur.Checked:= SauveEditeur;
    ChBFenetrePrincipale.Checked:= Maximiser;

    ChBMargeVisible.Checked:= MargeVisible;
    ChBNumerosDeLigne.Checked:= NumerosDeLigne;
    ChBZerosDeTete.Checked:= ZerosDeTete;
    ChBNumerosDeLigne.Enabled:= MargeVisible;
    ChBMaximiserEditeur.Checked:= MaxiEditeur;
    ChBZerosDeTete.Enabled:= MargeVisible and NumerosDeLigne;
  end;
end;

procedure TFrmPreferences.ChBMargeVisibleClick(Sender: TObject);
begin
  ChBNumerosDeLigne.Enabled:= ChBMargeVisible.Checked;
  ChBZerosDeTete.Enabled:= ChBMargeVisible.Checked;
end;

procedure TFrmPreferences.ChBNumerosDeLigneClick(Sender: TObject);
begin
  ChBZerosDeTete.Enabled:= ChBNumerosDeLigne.Checked;
end;

{*****************************************************************************}
{ Fonctions privee                                                            }
{*****************************************************************************}

{*****************************************************************************}
{ Fonctions public                                                            }
{*****************************************************************************}

procedure TFrmPreferences.LitPreferences;
var
  FichierPref: TIniFile;
  N: longint;
  Nom: string;
begin
  FichierPref:= TIniFile.Create(RepAppli+NomFichierPref);
  with Pref do
  begin
    SauveFenetre:= FichierPref.ReadBool(SectionSauve,CleFenetre,false);
    SauveLangue:= FichierPref.ReadBool(SectionSauve,CleLangue,true);
    SauveEditeur:= FichierPref.ReadBool(SectionSauve,CleEditeur,true);
    Maximiser:=FichierPref.ReadBool(SectionSauve,CleMaxi,true);

    // Lecture des preferences de l editeur
    if SauveEditeur then
    begin
      MargeVisible:= FichierPref.ReadBool(SectionEditeur,CleMarge,true);
      NumerosDeLigne:= FichierPref.ReadBool(SectionEditeur,CleNumerosDeLigne,true);
      ZerosDeTete:= FichierPref.ReadBool(SectionEditeur,CleZerosDeTete,true);
      MaxiEditeur:= FichierPref.ReadBool(SectionEditeur,CleMaxiEdt,true);
    end
    else
    begin
      MargeVisible:= false;
      NumerosDeLigne:= true;
      ZerosDeTete:= true;
      MaxiEditeur:= false;
    end;

    // Lecture des fichiers recents
    for N:= MaxFichiersRecents downto 0 do
    begin
      Nom:= FichierPref.ReadString(SectionFichiersRecents,
        CleFichierRecent+IntToStr(N),'');
      if Nom<>'' then DMAppli.AjouteFichierRecent(Nom);
    end;
  end;
end;

procedure TFrmPreferences.EcritPreferences(Top,Left,Height,Width: integer;
  Langue: string);
var
  FichierPref: TIniFile;
  N: longint;
begin
  FichierPref:= TIniFile.Create(RepAppli+NomFichierPref);
  // Que doit-on sauver
  with Pref do
  begin
    FichierPref.WriteBool(SectionSauve,CleFenetre,SauveFenetre);
    FichierPref.WriteBool(SectionSauve,CleLangue,SauveLangue);
    FichierPref.WriteBool(SectionSauve,CleEditeur,SauveEditeur);
    FichierPref.WriteBool(SectionSauve,CleMaxi,Maximiser);
  end;
  // Sauvegarde de la fenetre
  if Pref.SauveFenetre and (not Pref.Maximiser) then
  begin
    FichierPref.WriteInteger(SectionFenetre,CleTop,Top);
    FichierPref.WriteInteger(SectionFenetre,CleLeft,Left);
    FichierPref.WriteInteger(SectionFenetre,CleHeight,Height);
    FichierPref.WriteInteger(SectionFenetre,CleWidth,Width);
  end;
  // Sauvegarde de la langue
  if Pref.SauveLangue then
    FichierPref.WriteString(SectionEtat,CleLangue,Langue);
  // Sauvegarde des preferences editeur
  if Pref.SauveEditeur then
  with Pref do
  begin
    FichierPref.WriteBool(SectionEditeur,CleMarge,MargeVisible);
    FichierPref.WriteBool(SectionEditeur,CleNumerosDeLigne,NumerosDeLigne);
    FichierPref.WriteBool(SectionEditeur,CleZerosDeTete,ZerosDeTete);
    FichierPref.WriteBool(SectionEditeur,CleMaxiEdt,MaxiEditeur);
  end;
  // Sauvegarde des fichiers recents
  for N:= 0 to DMAppli.NombreFichiersRecents-1 do
  with Pref do
  begin
    FichierPref.WriteString(SectionFichiersRecents,
      CleFichierRecent+IntToStr(N),DMAppli.LitFichierRecent(N));
  end;
end;

procedure TFrmPreferences.GetFenetre(var Top,Left,Height,Width: integer);
var
  FichierPref: TIniFile;
begin
  FichierPref:= TIniFile.Create(RepAppli+NomFichierPref);
  Top:= FichierPref.ReadInteger(SectionFenetre,CleTop,Top);
  Left:= FichierPref.ReadInteger(SectionFenetre,CleLeft,Left);
  Height:= FichierPref.ReadInteger(SectionFenetre,CleHeight,Height);
  Width:= FichierPref.ReadInteger(SectionFenetre,CleWidth,Width);
end;

function TFrmPreferences.GetLangue: string;
var
  FichierPref: TIniFile;
begin
  if Pref.SauveLangue then
  begin
    FichierPref:= TIniFile.Create(RepAppli+NomFichierPref);
    result:= FichierPref.ReadString(SectionEtat,CleLangue,LangueRef);
  end
  else result:= LangueRef;
end;

procedure TFrmPreferences.GetEditeur(var Visible,NumLigne,Zero,Maxi: boolean);
begin
  with Pref do
  begin
    Visible:= MargeVisible;
    NumLigne:= NumerosDeLigne;
    Zero:= ZerosDeTete;
    Maxi:= MaxiEditeur;
  end;
end;

function TFrmPreferences.Execute(Titre: string): boolean;
begin
  Caption:= Titre;
  if ShowModal= mrOk then
  begin
    with Pref do
    begin
      SauveFenetre:= ChBWindow.Checked;
      SauveLangue:= ChBLangue.Checked;
      SauveEditeur:= ChBEditeur.Checked;
      Maximiser:= ChBFenetrePrincipale.Checked;
      MargeVisible:= ChBMargeVisible.Checked;
      NumerosDeLigne:= ChBNumerosDeLigne.Checked;
      ZerosDeTete:= ChBZerosDeTete.Checked;
      MaxiEditeur:= ChBMaximiserEditeur.Checked;
    end;
    result:= true;
  end
  else result:= false;
end;

end.
