unit Langues;

{***************************************************************************}
{ Ce logiciel est un logiciel libre. Vous pouvez le diffuser et/ou le       }
{ modifier suivant les termes de la GNU General Public License telle que    }
{ publie par la Free Software Foundation, soit la version 2 de cette        }
{ license, soit ( votre convenance) une version ultrieure.                }
{                                                                           }
{ Ce programme est diffus dans l'espoir qu'il sera utile, mais SANS AUCUNE }
{ GARANTIE, sans mme une garantie implicite de COMMERCIALISABILITE ou      }
{ d'ADEQUATION A UN USAGE PARTICULIER. Voyez la GNU General Public License  }
{ pour plus de dtails.                                                     }
{                                                                           }
{ Vous devriez avoir reu une copie de la GNU General Public License avec   }
{ ce programme, sinon, veuillez crire  la Free Software Foundation, Inc., }
{ 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.                  }
{***************************************************************************}

{***************************************************************************}
{ This program is free software. You can redistribute it and/or modify it   }
{ under the terms of the GNU Public License as published by the             }
{ Free Software Foundation, either version 2 of the license, or             }
{ (at your option) any later version.                                       }
{                                                                           }
{ This program is distributed in the hope it will be useful, but WITHOUT    }
{ ANY WARRANTY, without even the implied warranty of MERCHANTABILITY or     }
{ FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for  }
{ more details.                                                             }
{                                                                           }
{ You should have received a copy of the GNU General Public License along   }
{ with this program, if not, write to the Free Software Foundation, Inc.,   }
{ 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.                  }
{***************************************************************************}

interface

uses  SysUtils, Menus, Forms;

function ExisteLangue(LaLangue: string): boolean;
procedure CreeMenuLangue;
procedure LitLangue(LaLangue: string);

implementation

uses Main, Utilitaires, Alertes, Recherche, Remplace,
  Preferences, Apercu, MiseEnPage;

var
  NomFichierLangue: string; { Nom du fichier Langue }
  FichierLangue: textfile;  { Fichier Langue }

{**********************************************}
{ Test de l'existance du fichier de langue     }
{**********************************************}

function ExisteLangue(LaLangue: string): boolean;
begin
  NomFichierLangue:= RepAppli + LaLangue + ExtLangue;
  Result:= FileExists(NomFichierLangue);
end;

{**********************************************}
{ Ecriture du fichier de langue francais       }
{**********************************************}

procedure CreeEntete;
begin
  writeln(FichierLangue,
    '{----------------------------------------------------------------------------}');
    writeln(FichierLangue,
    '{ Fichier de langue de SEdit V1.0                                            }');
    writeln(FichierLangue,
    '{ Franais                                                                   }');
    writeln(FichierLangue,
    '{                                                                            }');
    writeln(FichierLangue,
    '{ Cr le 12 Decembre 2000 par A.JAFFRE                                      }');
    writeln(FichierLangue,
    '{                                                                            }');
    writeln(FichierLangue,
    '{ Pour crer d''autres langues, copier ce fichier en le renommant du nom de la}');
    writeln(FichierLangue,
    '{ langue mais en gardant l extension LSF                                     }');
    writeln(FichierLangue,
    '{ Exemple: pour l''anglais le fichier s''appelera English.LSF                  }');
    writeln(FichierLangue,
    '{                                                                            }');
    writeln(FichierLangue,
    '{ Les lignes commencant par { sont des commentaires.                         }');
    writeln(FichierLangue,
    '{ Ne pas modifier les lignes avant le #.                                     }');
    writeln(FichierLangue,
    '{ Traduire tout ce qui se trouve apres #.                                    }');
    writeln(FichierLangue,
    '{ Le & precede la lettre de raccourci clavier que l on obtiendra avec Alt    }');
    writeln(FichierLangue,
    '{----------------------------------------------------------------------------}');
end;

procedure CreeMenu;
begin
  writeln(FichierLangue,
    '{----------------------------------------------------------------------------}');
  writeln(FichierLangue,
    '{ Menu principal                                                             }');
  writeln(FichierLangue,
    '{----------------------------------------------------------------------------}');
  writeln(FichierLangue,'0001#&Fichier');
  writeln(FichierLangue,'0002#Commandes relatives aux fichiers');
  writeln(FichierLangue,'0003#&Nouveau');
  writeln(FichierLangue,'0004#Cre un nouveau fichier');
  writeln(FichierLangue,'0005#&Ouvrir');
  writeln(FichierLangue,'0006#Ouvre un fichier existant');
  writeln(FichierLangue,'0007#&Rouvrir');
  writeln(FichierLangue,'0008#Ouvre un fichier de l''historique');
  writeln(FichierLangue,'0009#&Enregistrer');
  writeln(FichierLangue,'0010#Sauve le fichier courant');
  writeln(FichierLangue,'0011#Enregistrer &sous ...');
  writeln(FichierLangue,'0012#Sauve le fichier sous un autre nom');
  writeln(FichierLangue,'0013#To&ut enregistrer');
  writeln(FichierLangue,'0014#Sauve tous les fichiers ouverts');
  writeln(FichierLangue,'0015#Enregistrer au format &Unix');
  writeln(FichierLangue,'0016#Sauve le fichier courant au format unix');
  writeln(FichierLangue,'0017#Enregistrer au format Uni&x sous ...');
  writeln(FichierLangue,'0018#Sauve le fichier au format unix sous un autre nom');
  writeln(FichierLangue,'0019#&Mise en page ...');
  writeln(FichierLangue,'0020#Configure la mise en page pour l''impression');
  writeln(FichierLangue,'0021#&Apercu avant impression ...');
  writeln(FichierLangue,'0022#Affiche un aperu du fichier imprim');
  writeln(FichierLangue,'0023#&Imprimer ...');
  writeln(FichierLangue,'0024#Imprime le fichier courant');
  writeln(FichierLangue,'0025#&Fermer');
  writeln(FichierLangue,'0026#Ferme le fichier courant');
  writeln(FichierLangue,'0027#&Tout fermer');
  writeln(FichierLangue,'0028#Ferme tous les fichiers ouverts');
  writeln(FichierLangue,'0029#&Quitter');
  writeln(FichierLangue,'0030#Quitte le programme');
  writeln(FichierLangue,'0031#&Edition');
  writeln(FichierLangue,'0032#Commandes relatives  l''dition');
  writeln(FichierLangue,'0033#&Dfaire');
  writeln(FichierLangue,'0034#Annule la modification prcdente');
  writeln(FichierLangue,'0035#&Refaire');
  writeln(FichierLangue,'0036#R-excute la modification prcdement annule');
  writeln(FichierLangue,'0037#&Couper');
  writeln(FichierLangue,'0038#Coupe la slection et la met dans le presse-papiers');
  writeln(FichierLangue,'0039#Co&pier');
  writeln(FichierLangue,'0040#Copie la slection et la met dans le presse-papiers');
  writeln(FichierLangue,'0041#Co&ller');
  writeln(FichierLangue,'0042#Insert le contenu du presse-papiers');
  writeln(FichierLangue,'0043#&Supprimer');
  writeln(FichierLangue,'0044#Supprime la slection');
  writeln(FichierLangue,'0045#&Tout slectionner');
  writeln(FichierLangue,'0046#Slectionne la totalit du texte');
  writeln(FichierLangue,'0051#&Chercher');
  writeln(FichierLangue,'0052#Commandes relatives au recherches et remplacements');
  writeln(FichierLangue,'0053#&Chercher ...');
  writeln(FichierLangue,'0054#Recherche un texte dans le fichier courant');
  writeln(FichierLangue,'0055#C&hercher dans les fichiers ...');
  writeln(FichierLangue,'0056#Recherche un texte dans tous les fichiers ouverts');
  writeln(FichierLangue,'0057#&Remplacer ...');
  writeln(FichierLangue,'0058#Remplace un texte dans le fichier courant');
  writeln(FichierLangue,'0059#Occurance &suivante');
  writeln(FichierLangue,'0060#Recherche / remplace en descendant dans le texte');
  writeln(FichierLangue,'0061#Occurance &prcdente');
  writeln(FichierLangue,'0062#Recherche / remplace en remontant dans le texte');
  writeln(FichierLangue,'0063#&Aller  la ligne ...');
  writeln(FichierLangue,'0064#Dplace le curseur  la ligne voulue');
  writeln(FichierLangue,'0071#O&utils');
  writeln(FichierLangue,'0072#Commandes de personnalisation du programme');
  writeln(FichierLangue,'0073#Lan&gues');
  writeln(FichierLangue,'0074#Slection de la langue d''affichage');
  writeln(FichierLangue,'0075#&Prferences ...');
  writeln(FichierLangue,'0076#Dfinition des prfrences de l''utilisateur');
  writeln(FichierLangue,'0081#Fe&ntre');
  writeln(FichierLangue,'0082#Commandes relatives aux fentres');
  writeln(FichierLangue,'0083#&Cascade');
  writeln(FichierLangue,'0084#Place les fentres en cascade');
  writeln(FichierLangue,'0085#Mosaque &horizontale');
  writeln(FichierLangue,'0086#Place les fentres en mosaque horizontale');
  writeln(FichierLangue,'0087#Mosaque &verticale');
  writeln(FichierLangue,'0088#Place les fentres en mosaque verticale');
  writeln(FichierLangue,'0089#&Tout rduire');
  writeln(FichierLangue,'0090#Reduit toutes les fentres');
  writeln(FichierLangue,'0091#&Rorganiser');
  writeln(FichierLangue,'0092#Rorganise les fentres');

  writeln(FichierLangue,'0101#&Aide');
  writeln(FichierLangue,'0102#Commandes relatives  l''aide');
  writeln(FichierLangue,'0103#&Rubriques d''aide');
  writeln(FichierLangue,'0104#Accs  l''onglet sommaire de l''aide');
  writeln(FichierLangue,'0105#&Index de l''aide');
  writeln(FichierLangue,'0106#Accs  l''onglet index de l''aide');
  writeln(FichierLangue,'0107#Re&cherche dans l''aide');
  writeln(FichierLangue,'0108#Accs  l''onglet recherche de l''aide');
  writeln(FichierLangue,'0109#&A propos...');
  writeln(FichierLangue,'0110#Version, Copyright et informations sur le programme');
end;

procedure CreeRecherche;
begin
  writeln(FichierLangue,
    '{----------------------------------------------------------------------------}');
  writeln(FichierLangue,
    '{ Fiche rechercher                                                           }');
  writeln(FichierLangue,
    '{----------------------------------------------------------------------------}');
  writeln(FichierLangue,'0200#Recherche de texte');
  writeln(FichierLangue,'0201#&Chercher');
  writeln(FichierLangue,'0202#Entrer ou choisir le texte  rechercher');
  writeln(FichierLangue,'0203#Options');
  writeln(FichierLangue,'0204#Choix des particularits de recherche');
  writeln(FichierLangue,'0250#&Diffrencier MAJ/min');
  writeln(FichierLangue,'0206#Ne recherche que le texte ecrit de la mme faon');
  writeln(FichierLangue,'0207#Mots &entiers');
  writeln(FichierLangue,'0208#ne recherche que le texte complet');
  writeln(FichierLangue,'0209#Direction');
  writeln(FichierLangue,'0210#Choix de la direction de recherche');
  writeln(FichierLangue,'0211#En a&vant');
  writeln(FichierLangue,'0212#En a&rrire');
  writeln(FichierLangue,'0213#Porte');
  writeln(FichierLangue,'0214#Choix de la zone de recherche');
  writeln(FichierLangue,'0215#&Globale');
  writeln(FichierLangue,'0216#Texte &slectionn');
  writeln(FichierLangue,'0217#Origine');
  writeln(FichierLangue,'0218#Choix du dbut de la recherche');
  writeln(FichierLangue,'0219#Depuis le c&urseur');
  writeln(FichierLangue,'0220#Toute la &porte');
  writeln(FichierLangue,'0221#&Ok');
  writeln(FichierLangue,'0222#Lance la recherche');
  writeln(FichierLangue,'0223#&Annule');
  writeln(FichierLangue,'0224#Annule la recherche');
end;

procedure CreeRemplace;
begin
  writeln(FichierLangue,
    '{----------------------------------------------------------------------------}');
  writeln(FichierLangue,
    '{ Fiche rechercher                                                           }');
  writeln(FichierLangue,
    '{----------------------------------------------------------------------------}');
  writeln(FichierLangue,'0250#Remplacement de texte');
  writeln(FichierLangue,'0251#&Chercher :');
  writeln(FichierLangue,'0252#Entrer ou choisir le texte  rechercher');
  writeln(FichierLangue,'0253#&Remplacer par :');
  writeln(FichierLangue,'0254#Entrer ou choisir le texte de remplacement');
  writeln(FichierLangue,'0255#Options');
  writeln(FichierLangue,'0256#Choix des particularits de recherche/remplacement');
  writeln(FichierLangue,'0257#&Diffrencier MAJ/min');
  writeln(FichierLangue,'0258#Ne recherche que le texte ecrit de la mme faon');
  writeln(FichierLangue,'0259#Mots &entiers');
  writeln(FichierLangue,'0260#ne recherche que le texte complet');
  writeln(FichierLangue,'0261#C&onfirmer les remplacements');
  writeln(FichierLangue,'0262#Demande de confirmation avant remplacement');
  writeln(FichierLangue,'0263#Direction');
  writeln(FichierLangue,'0264#Choix de la direction de recherche/remplacement');
  writeln(FichierLangue,'0265#En a&vant');
  writeln(FichierLangue,'0266#En a&rrire');
  writeln(FichierLangue,'0267#Porte');
  writeln(FichierLangue,'0268#Choix de la zone de recherche/remplacement');
  writeln(FichierLangue,'0269#&Globale');
  writeln(FichierLangue,'0270#Texte &slectionn');
  writeln(FichierLangue,'0271#Origine');
  writeln(FichierLangue,'0272#Choix du dbut de la recherche');
  writeln(FichierLangue,'0273#Depuis le c&urseur');
  writeln(FichierLangue,'0274#Toute la &porte');
  writeln(FichierLangue,'0275#&Ok');
  writeln(FichierLangue,'0276#Lance le remplacement');
  writeln(FichierLangue,'0277#&Tout remplacer');
  writeln(FichierLangue,'0278#Remplace tous les textes trouvs');
  writeln(FichierLangue,'0279#&Annule');
  writeln(FichierLangue,'0280#Annule le remplacement');
end;

procedure CreePreferences;
begin
  writeln(FichierLangue,
    '{----------------------------------------------------------------------------}');
  writeln(FichierLangue,
    '{ Fiche preferences                                                          }');
  writeln(FichierLangue,
    '{----------------------------------------------------------------------------}');
  writeln(FichierLangue,'0300#Preferences');
  writeln(FichierLangue,'0301#Programme');
  writeln(FichierLangue,'0302#Choix relatifs au programme');
  writeln(FichierLangue,'0303#Sauver la position de la fentre');
  writeln(FichierLangue,'0304#Stocke la position et la taille de la fentre en quittant');
  writeln(FichierLangue,'0305#Sauver la langue utilise');
  writeln(FichierLangue,'0306#Stocke la langue utilise par l''interface en quittant');
  writeln(FichierLangue,'0307#Sauver la config. de l''diteur');
  writeln(FichierLangue,'0308#Stocke la configuration de l''diteur en quittant');
  writeln(FichierLangue,'0309#Maximiser la fentre');
  writeln(FichierLangue,'0310#La fentre du programme tiendra tout le bureau');
  writeln(FichierLangue,'0319#Editeur');
  writeln(FichierLangue,'0320#Choix relatifs  l''diteur');
  writeln(FichierLangue,'0321#Marge visible');
  writeln(FichierLangue,'0322#Affiche une marge');
  writeln(FichierLangue,'0323#Numros de ligne');
  writeln(FichierLangue,'0324#Affiche les numros de ligne dans la marge');
  writeln(FichierLangue,'0325#Zros de tte');
  writeln(FichierLangue,'0326#Affiche les zros de tte des numros de ligne');
  writeln(FichierLangue,'0327#Maximiser la fentre de l''diteur');
  writeln(FichierLangue,'0328#La fentre d''dition tient toute la place');
  writeln(FichierLangue,'0395#&Ok');
  writeln(FichierLangue,'0396#Accepte les modifications effectues');
  writeln(FichierLangue,'0397#&Annule');
  writeln(FichierLangue,'0398#Ignore les modifications effectues');
end;

procedure CreeMiseEnPage;
begin
  writeln(FichierLangue,
    '{----------------------------------------------------------------------------}');
  writeln(FichierLangue,
    '{ Fiche mise en page                                                         }');
  writeln(FichierLangue,
    '{----------------------------------------------------------------------------}');
  writeln(FichierLangue,'0401#&Marges');
  writeln(FichierLangue,'0402#Dfinition des marges d''impression');
  writeln(FichierLangue,'0403#&Unit:');
  writeln(FichierLangue,'0404#Unit des marges d''impression');
  writeln(FichierLangue,'0405#&Haut:');
  writeln(FichierLangue,'0406#Valeur de la marge suprieure');
  writeln(FichierLangue,'0407#&Bas:');
  writeln(FichierLangue,'0408#Valeur de la marge infrieure');
  writeln(FichierLangue,'0409#&Gauche:');
  writeln(FichierLangue,'0410#Valeur de la marge de gauche');
  writeln(FichierLangue,'0411#&Droite:');
  writeln(FichierLangue,'0412#Valeur de la marge de droite');
  writeln(FichierLangue,'0413#&Reliure:');
  writeln(FichierLangue,'0414#Largeur de la zone de reliure');
  writeln(FichierLangue,'0415#A partir du bord:');
  writeln(FichierLangue,'0416#Position de l''en-tte et du pied de page');
  writeln(FichierLangue,'0417#&En-tte:');
  writeln(FichierLangue,'0418#Position de l''en-tte');
  writeln(FichierLangue,'0419#&Pied de page:');
  writeln(FichierLangue,'0420#Position du pied de page');
  writeln(FichierLangue,'0421#&Options');
  writeln(FichierLangue,'0422#Dfinition des options d''impression');
  writeln(FichierLangue,'0431#Numrotation des lignes');
  writeln(FichierLangue,'0432#Imprime la numrotation des lignes');
  writeln(FichierLangue,'0433#Numros dans la marge');
  writeln(FichierLangue,'0434#Imprime la numrotation dans la marge');
  writeln(FichierLangue,'0435#Mise en vidence de la syntaxe');
  writeln(FichierLangue,'0436#Imprime la syntaxe');
  writeln(FichierLangue,'0437#Retour  la ligne');
  writeln(FichierLangue,'0438#Effectue un retour  la ligne si elle est trop longue');
  writeln(FichierLangue,'0451#&En-tte et pied de page');
  writeln(FichierLangue,'0452#Dfinition de l''en-tte et du pied de page');
  writeln(FichierLangue,'0453#En-tte');
  writeln(FichierLangue,'0454#Dfinition de l''en-tte de page');
  writeln(FichierLangue,'0455#Gauche');
  writeln(FichierLangue,'0456#Dfinition de la partie gauche de l''en-tte de page');
  writeln(FichierLangue,'0457#Milieu');
  writeln(FichierLangue,'0458#Dfinition de la partie centrale de l''en-tte de page');
  writeln(FichierLangue,'0459#Droite');
  writeln(FichierLangue,'0460#Dfinition de la partie de droite de l''en-tte de page');
  writeln(FichierLangue,'0461#Ligne de sparation');
  writeln(FichierLangue,'0462#Trace une ligne de sparation entre l''en-tte et le texte');
  writeln(FichierLangue,'0463#Encadr');
  writeln(FichierLangue,'0464#Encadre l''en-tte');
  writeln(FichierLangue,'0465#Ombre');
  writeln(FichierLangue,'0466#Place une ombre comme fond d''en-tte');
  writeln(FichierLangue,'0467#Pied de page');
  writeln(FichierLangue,'0468#Dfinition du pied de page');
  writeln(FichierLangue,'0469#Gauche');
  writeln(FichierLangue,'0470#Dfinition de la partie gauche du pied de page');
  writeln(FichierLangue,'0471#Milieu');
  writeln(FichierLangue,'0472#Dfinition de la partie centrale du pied de page');
  writeln(FichierLangue,'0473#Droite');
  writeln(FichierLangue,'0474#Dfinition de la partie droite du pied de page');
  writeln(FichierLangue,'0475#Ligne de sparation');
  writeln(FichierLangue,'0476#Trace une ligne de sparation entre le texte et le pied de page');
  writeln(FichierLangue,'0477#Encadr');
  writeln(FichierLangue,'0478#Encadre le pied de page');
  writeln(FichierLangue,'0479#Ombre');
  writeln(FichierLangue,'0480#Place une ombre comme fond de pied de page');
  writeln(FichierLangue,'0481#Insre le numro de page');
  writeln(FichierLangue,'0482#Insre le nombre de pages');
  writeln(FichierLangue,'0483#Insre la date d''impression');
  writeln(FichierLangue,'0484#Insre l''heure d''impression');
  writeln(FichierLangue,'0485#Insre la date et l''heure d''impression');
  writeln(FichierLangue,'0486#Insre le nom complet du fichier');
  writeln(FichierLangue,'0487#Choix de la police utilise');
  writeln(FichierLangue,'0488#Texte en gras');
  writeln(FichierLangue,'0489#Texte en italique');
  writeln(FichierLangue,'0490#Texte soulign');
  writeln(FichierLangue,'0495#&Ok');
  writeln(FichierLangue,'0496#Accepte les modifications effectues');
  writeln(FichierLangue,'0497#&Annule');
  writeln(FichierLangue,'0498#Ignore les modifications effectues');
end;

procedure CreeApercu;
begin
  writeln(FichierLangue,
    '{----------------------------------------------------------------------------}');
  writeln(FichierLangue,
    '{ Fiche apercu                                                               }');
  writeln(FichierLangue,
    '{----------------------------------------------------------------------------}');
  writeln(FichierLangue,'0500#Va  la premire page');
  writeln(FichierLangue,'0501#Va  la page prcdente');
  writeln(FichierLangue,'0502#Va  la page suivante');
  writeln(FichierLangue,'0503#Va  la dernire page');
  writeln(FichierLangue,'0504#Diminue le grossissement');
  writeln(FichierLangue,'0505#Augmente le grossissemnt');
  writeln(FichierLangue,'0506#Affiche une page entire');
  writeln(FichierLangue,'0507#Rglage de la mise en page');
  writeln(FichierLangue,'0508#Imprime');
end;
procedure CreeErreurs;
begin
  writeln(FichierLangue,
    '{----------------------------------------------------------------------------}');
  writeln(FichierLangue,
    '{ Messages d''erreur                                                          }');
  writeln(FichierLangue,
    '{----------------------------------------------------------------------------}');
  writeln(FichierLangue,'1001#La valeur');
  writeln(FichierLangue,'1002#n''est pas correcte.');
end;

procedure CreeDivers;
begin
  writeln(FichierLangue,
    '{----------------------------------------------------------------------------}');
  writeln(FichierLangue,
    '{ Messages divers                                                            }');
  writeln(FichierLangue,
    '{----------------------------------------------------------------------------}');
  writeln(FichierLangue,'1101#Modifi');
  writeln(FichierLangue,'1102#Lecture seule');
  writeln(FichierLangue,'1103#Insertion');
  writeln(FichierLangue,'1104#Remplacement');
  writeln(FichierLangue,'1111#Le fichier:');
  writeln(FichierLangue,'1112#existe dj. Ecraser ?');
  writeln(FichierLangue,'1113#Enregistrer les modifications dans');
  writeln(FichierLangue,'1114#?');
  writeln(FichierLangue,'1115#Remplacement de');
  writeln(FichierLangue,'1116#par');
  writeln(FichierLangue,'1117#Chaine');
  writeln(FichierLangue,'1118#non trouve.');
  writeln(FichierLangue,'1119#&OK');
  writeln(FichierLangue,'1120#&Annule');
end;

procedure CreeFichierLangue(LaLangue: string);
begin
  NomFichierLangue:= RepAppli + LaLangue + ExtLangue;
  AssignFile(FichierLangue,NomFichierLangue);
  rewrite(FichierLangue);
  CreeEntete;
  CreeMenu;
  CreeRecherche;
  CreeRemplace;
  CreePreferences;
  CreeMiseEnPage;
  CreeApercu;
  CreeErreurs;
  CreeDivers;
  closefile(FichierLangue);
end;

{**********************************************}
{ Creation du menu langue                      }
{**********************************************}

procedure CreeMenuLangue;
var
  Recherche: TSearchRec;
  Texte: string;
  Compte: integer;
begin
  Compte:= 0;
  if FindFirst(RepAppli + '*' + ExtLangue, faAnyFile, Recherche) = 0 then
  begin
    FrmPrincipale.VideSousMenu;
    inc(Compte);
    Texte:= ExtractFileName(Recherche.Name);
    Texte:= copy(Texte,1,length(Texte)-4);
    FrmPrincipale.AjouteSousMenu(Texte);
    while FindNext(Recherche) = 0 do
    begin
      inc(Compte);
      Texte:= ExtractFileName(Recherche.Name);
      Texte:= copy(Texte,1,length(Texte)-4);
      FrmPrincipale.AjouteSousMenu(Texte);
    end;
  end;
  with FrmPrincipale.MenuPrincipal.Items[NumMenuLangue].Items[NumItemLangue] do
    if Compte < 2 then Visible:= false
                  else Visible:= true;
  if Compte=0 then CreeFichierLangue(LangueRef);
end;

{**********************************************}
{ Lecture d'un fichier de langue               }
{**********************************************}

procedure TraiteLigne(LaLigne: string);
var
  Numero: longint;
  Texte: string;
begin
  ParseLigne(LaLigne,Numero,Texte);
  case Numero of
  // FPrincipale
    // 0001  0199 Menu principal
      0001: FrmPrincipale.MenuPrincipal.Items[0].Caption:= Texte;
      0002: FrmPrincipale.MenuPrincipal.Items[0].Hint:= Texte;
      0003: FrmPrincipale.ActFichierNouveau.Caption:= Texte;
      0004: FrmPrincipale.ActFichierNouveau.Hint:= Texte;
      0005: FrmPrincipale.ActFichierOuvrir.Caption:= Texte;
      0006: FrmPrincipale.ActFichierOuvrir.Hint:= Texte;
      0007: FrmPrincipale.ActFichierReouvrir.Caption:= Texte;
      0008: FrmPrincipale.ActFichierReouvrir.Hint:= Texte;
      0009: FrmPrincipale.ActFichierEnregistrer.Caption:= Texte;
      0010: FrmPrincipale.ActFichierEnregistrer.Hint:= Texte;
      0011: FrmPrincipale.ActFichierEnregistrerSous.Caption:= Texte;
      0012: FrmPrincipale.ActFichierEnregistrerSous.Hint:= Texte;
      0013: FrmPrincipale.ActFichierToutEnregistrer.Caption:= Texte;
      0014: FrmPrincipale.ActFichierToutEnregistrer.Hint:= Texte;
      0015: FrmPrincipale.Enregistrerauformat.Caption:= Texte;
      0016: FrmPrincipale.Enregistrerauformat.Hint:= Texte;
      0017: FrmPrincipale.Enregistrersousauformat.Caption:= Texte;
      0018: FrmPrincipale.Enregistrersousauformat.Hint:= Texte;
      0019: FrmPrincipale.ActFichierMiseEnPage.Caption:= Texte;
      0020: FrmPrincipale.ActFichierMiseEnPage.Hint:=Texte;
      0021: FrmPrincipale.ActFichierApercu.Caption:= Texte;
      0022: FrmPrincipale.ActFichierApercu.Hint:= Texte;
      0023: FrmPrincipale.ActFichierImprimer.Caption:= Texte;
      0024: FrmPrincipale.ActFichierImprimer.Hint:= Texte;
      0025: FrmPrincipale.ActFichierFermer.Caption:= Texte;
      0026: FrmPrincipale.ActFichierFermer.Hint:= Texte;
      0027: FrmPrincipale.ActFichierToutFermer.Caption:= Texte;
      0028: FrmPrincipale.ActFichierToutFermer.Hint:= Texte;
      0029: FrmPrincipale.ActFichierQuitter.Caption:= Texte;
      0030: FrmPrincipale.ActFichierQuitter.Hint:= Texte;
      0031: FrmPrincipale.MenuPrincipal.Items[1].Caption:= Texte;
      0032: FrmPrincipale.MenuPrincipal.Items[1].Hint:= Texte;
      0033: FrmPrincipale.ActEditionDefaire.Caption:= Texte;
      0034: FrmPrincipale.ActEditionDefaire.Hint:= Texte;
      0035: FrmPrincipale.ActEditionRefaire.Caption:= Texte;
      0036: FrmPrincipale.ActEditionRefaire.Hint:= Texte;
      0037: FrmPrincipale.ActEditionCouper.Caption:= Texte;
      0038: FrmPrincipale.ActEditionCouper.Hint:= Texte;
      0039: FrmPrincipale.ActEditionCopier.Caption:= Texte;
      0040: FrmPrincipale.ActEditionCopier.Hint:= Texte;
      0041: FrmPrincipale.ActEditionColler.Caption:= Texte;
      0042: FrmPrincipale.ActEditionColler.Hint:= Texte;
      0043: FrmPrincipale.ActEditionSupprimer.Caption:= Texte;
      0044: FrmPrincipale.ActEditionSupprimer.Hint:= Texte;
      0045: FrmPrincipale.ActEditionToutSelectionner.Caption:= Texte;
      0046: FrmPrincipale.ActEditionToutSelectionner.Hint:= Texte;
      0051: FrmPrincipale.MenuPrincipal.Items[2].Caption:= Texte;
      0052: FrmPrincipale.MenuPrincipal.Items[2].Hint:= Texte;
      0053: FrmPrincipale.ActChercherRechercher.Caption:= Texte;
      0054: FrmPrincipale.ActChercherRechercher.Hint:= Texte;
      0055: FrmPrincipale.ActChercherDansFichier.Caption:= Texte;
      0056: FrmPrincipale.ActChercherDansFichier.Hint:= Texte;
      0057: FrmPrincipale.ActChercherRemplacer.Caption:= Texte;
      0058: FrmPrincipale.ActChercherRemplacer.Hint:= Texte;
      0059: FrmPrincipale.ActChercherSuivant.Caption:= Texte;
      0060: FrmPrincipale.ActChercherSuivant.Hint:= Texte;
      0061: FrmPrincipale.ActChercherPrecedent.Caption:= Texte;
      0062: FrmPrincipale.ActChercherPrecedent.Hint:= Texte;
      0063: FrmPrincipale.ActAllerALaLigne.Caption:= Texte;
      0064: FrmPrincipale.ActAllerALaLigne.Hint:= Texte;
      0071: FrmPrincipale.MenuPrincipal.Items[3].Caption:= Texte;
      0072: FrmPrincipale.MenuPrincipal.Items[3].Hint:= Texte;
      0073: FrmPrincipale.MenuPrincipal.Items[3].Items[0].Caption:= Texte;
      0074: FrmPrincipale.MenuPrincipal.Items[3].Items[0].Hint:= Texte;
      0075: FrmPrincipale.ActOutilsPreferences.Caption:= Texte;
      0076: FrmPrincipale.ActOutilsPreferences.Hint:= Texte;
      0081: FrmPrincipale.MenuPrincipal.Items[4].Caption:= Texte;
      0082: FrmPrincipale.MenuPrincipal.Items[4].Hint:= Texte;
      0083: FrmPrincipale.ActFenetreCascade.Caption:= Texte;
      0084: FrmPrincipale.ActFenetreCascade.Hint:= Texte;
      0085: FrmPrincipale.ActFenetreMosaiqueHorizontale.Caption:= Texte;
      0086: FrmPrincipale.ActFenetreMosaiqueHorizontale.Hint:= Texte;
      0087: FrmPrincipale.ActFenetreMosaiqueVerticale.Caption:= Texte;
      0088: FrmPrincipale.ActFenetreMosaiqueVerticale.Hint:= Texte;
      0089: FrmPrincipale.ActFenetreToutReduire.Caption:= Texte;
      0090: FrmPrincipale.ActFenetreToutReduire.Hint:= Texte;
      0091: FrmPrincipale.ActFenetreToutReorganiser.Caption:= Texte;
      0092: FrmPrincipale.ActFenetreToutReorganiser.Hint:= Texte;

      0101: FrmPrincipale.MenuPrincipal.Items[5].Caption:= Texte;
      0102: FrmPrincipale.MenuPrincipal.Items[5].Hint:= Texte;
      0103: FrmPrincipale.ActAideRubrique.Caption:= Texte;
      0104: FrmPrincipale.ActAideRubrique.Hint:= Texte;
      0105: FrmPrincipale.ActAideIndex.Caption:= Texte;
      0106: FrmPrincipale.ActAideIndex.Hint:= Texte;
      0107: FrmPrincipale.ActAideRecherche.Caption:= Texte;
      0108: FrmPrincipale.ActAideRecherche.Hint:= Texte;
      0109: FrmPrincipale.ActAideAPropos.Caption:= Texte;
      0110: FrmPrincipale.ActAideAPropos.Hint:= Texte;
    // Fiche recherche 0200  0249
      0200: FrmRecherche.Caption:= Texte;
      0201: FrmRecherche.LChercher.Caption:= Texte;
      0202: FrmRecherche.CbTexteRecherche.Hint:= Texte;
      0203: FrmRecherche.GbOptions.Caption:= Texte;
      0204: FrmRecherche.GbOptions.Hint:= Texte;
      0205: FrmRecherche.CBoxMajMin.Caption:= Texte;
      0206: FrmRecherche.CBoxMajMin.Hint:= Texte;
      0207: FrmRecherche.CBoxMotsEntiers.Caption:= Texte;
      0208: FrmRecherche.CBoxMotsEntiers.Hint:= Texte;
      0209: FrmRecherche.RgDirection.Caption:= Texte;
      0210: FrmRecherche.RgDirection.Hint:= Texte;
      0211: FrmRecherche.RgDirection.Items.Strings[0]:= Texte;
      0212: FrmRecherche.RgDirection.Items.Strings[1]:= Texte;
      0213: FrmRecherche.RgPortee.Caption:= Texte;
      0214: FrmRecherche.RgPortee.Hint:= Texte;
      0215: FrmRecherche.RgPortee.Items.Strings[0]:= Texte;
      0216: FrmRecherche.RgPortee.Items.Strings[1]:= Texte;
      0217: FrmRecherche.RgOrigine.Caption:= Texte;
      0218: FrmRecherche.RgOrigine.Hint:= Texte;
      0219: FrmRecherche.RgOrigine.Items.Strings[0]:= Texte;
      0220: FrmRecherche.RgOrigine.Items.Strings[1]:= Texte;
      0221: FrmRecherche.BtnOk.Caption:= Texte;
      0222: FrmRecherche.BtnOk.Hint:= Texte;
      0223: FrmRecherche.BtnAnnule.Caption:= Texte;
      0224: FrmRecherche.BtnAnnule.Hint:= Texte;
    // Fiche remplace 0250  0299
      0250: FrmRemplace.Caption:= Texte;
      0251: FrmRemplace.LChercher.Caption:= Texte;
      0252: FrmRemplace.CbTexteRecherche.Hint:= Texte;
      0253: FrmRemplace.LRemplacer.Caption:= Texte;
      0254: FrmRemplace.CbTexteRemplace.Hint:= Texte;
      0255: FrmRemplace.GbOptions.Caption:= Texte;
      0256: FrmRemplace.GbOptions.Hint:= Texte;
      0257: FrmRemplace.CBoxMajMin.Caption:= Texte;
      0258: FrmRemplace.CBoxMajMin.Hint:= Texte;
      0259: FrmRemplace.CBoxMotsEntiers.Caption:= Texte;
      0260: FrmRemplace.CBoxMotsEntiers.Hint:= Texte;
      0261: FrmRemplace.CBoxConfirmer.Caption:= Texte;
      0262: FrmRemplace.CBoxConfirmer.Hint:= Texte;
      0263: FrmRemplace.RgDirection.Caption:= Texte;
      0264: FrmRemplace.RgDirection.Hint:= Texte;
      0265: FrmRemplace.RgDirection.Items.Strings[0]:= Texte;
      0266: FrmRemplace.RgDirection.Items.Strings[1]:= Texte;
      0267: FrmRemplace.RgPortee.Caption:= Texte;
      0268: FrmRemplace.RgPortee.Hint:= Texte;
      0269: FrmRemplace.RgPortee.Items.Strings[0]:= Texte;
      0270: FrmRemplace.RgPortee.Items.Strings[1]:= Texte;
      0271: FrmRemplace.RgOrigine.Caption:= Texte;
      0272: FrmRemplace.RgOrigine.Hint:= Texte;
      0273: FrmRemplace.RgOrigine.Items.Strings[0]:= Texte;
      0274: FrmRemplace.RgOrigine.Items.Strings[1]:= Texte;
      0275: FrmRemplace.BtnOk.Caption:= Texte;
      0276: FrmRemplace.BtnOk.Hint:= Texte;
      0277: FrmRemplace.BtnToutRemplacer.Caption:= Texte;
      0278: FrmRemplace.BtnToutRemplacer.Hint:= Texte;
      0279: FrmRemplace.BtnAnnule.Caption:= Texte;
      0280: FrmRemplace.BtnAnnule.Hint:= Texte;
    // Fiche preferences 0300  0399
      0300: FrmPreferences.Caption:= Texte;
      0301: FrmPreferences.TShProgramme.Caption:= Texte;
      0302: FrmPreferences.TShProgramme.Hint:= Texte;
      0303: FrmPreferences.ChBWindow.Caption:= Texte;
      0304: FrmPreferences.ChBWindow.Hint:= Texte;
      0305: FrmPreferences.ChBLangue.Caption:= Texte;
      0306: FrmPreferences.ChBLangue.Hint:= Texte;
      0307: FrmPreferences.ChBEditeur.Caption:= Texte;
      0308: FrmPreferences.ChBEditeur.Hint:= Texte;
      0309: FrmPreferences.ChBFenetrePrincipale.Caption:= Texte;
      0310: FrmPreferences.ChBFenetrePrincipale.Hint:= Texte;
      0319: FrmPreferences.TShEditeur.Caption:= Texte;
      0320: FrmPreferences.TShEditeur.Hint:= Texte;
      0321: FrmPreferences.ChBMargeVisible.Caption:= Texte;
      0322: FrmPreferences.ChBMargeVisible.Hint:= Texte;
      0323: FrmPreferences.ChBNumerosDeLigne.Caption:= Texte;
      0324: FrmPreferences.ChBNumerosDeLigne.Hint:= Texte;
      0325: FrmPreferences.ChBZerosDeTete.Caption:= Texte;
      0326: FrmPreferences.ChBZerosDeTete.Hint:= Texte;
      0327: FrmPreferences.ChBMaximiserEditeur.Caption:= Texte;
      0328: FrmPreferences.ChBMaximiserEditeur.Hint:= Texte;
      0395: FrmPreferences.BtnOk.Caption:= Texte;
      0396: FrmPreferences.BtnOk.Hint:= Texte;
      0397: FrmPreferences.BtnAnnule.Caption:= Texte;
      0398: FrmPreferences.BtnAnnule.Hint:= Texte;
    // Fiche mise en page 400  499
      0401: FrmMiseEnPage.TShMarges.Caption:= Texte;
      0402: FrmMiseEnPage.TShMarges.Hint:= Texte;
      0403: FrmMiseEnPage.LUnite.Caption:= Texte;
      0404: FrmMiseEnPage.CBUnite.Hint:= Texte;
      0405: FrmMiseEnPage.LHaut.Caption:= Texte;
      0406: FrmMiseEnPage.EdtHaut.Hint:= Texte;
      0407: FrmMiseEnPage.LBas.Caption:= Texte;
      0408: FrmMiseEnPage.EdtBas.Hint:= Texte;
      0409: FrmMiseEnPage.LGauche.Caption:= Texte;
      0410: FrmMiseEnPage.EdtGauche.Hint:= Texte;
      0411: FrmMiseEnPage.LDroite.Caption:= Texte;
      0412: FrmMiseEnPage.EdtDroite.Hint:= Texte;
      0413: FrmMiseEnPage.LReliure.Caption:= Texte;
      0414: FrmMiseEnPage.EdtReliure.Hint:= Texte;
      0415: FrmMiseEnPage.GBEntetePiedDePage.Caption:= Texte;
      0416: FrmMiseEnPage.GBEntetePiedDePage.Hint:= Texte;
      0417: FrmMiseEnPage.LEntete.Caption:= Texte;
      0418: FrmMiseEnPage.EdtEntete.Hint:= Texte;
      0419: FrmMiseEnPage.LPiedDePage.Caption:= Texte;
      0420: FrmMiseEnPage.EdtPiedDePage.Hint:= Texte;
      0421: FrmMiseEnPage.TShOptions.Caption:= Texte;
      0422: FrmMiseEnPage.TShOptions.Hint:= Texte;
      0431: FrmMiseEnPage.ChBNumerosDeLigne.Caption:= Texte;
      0432: FrmMiseEnPage.ChBNumerosDeLigne.Hint:= Texte;
      0433: FrmMiseEnPage.ChBNumeroDansMarge.Caption:= Texte;
      0434: FrmMiseEnPage.ChBNumeroDansMarge.Hint:= Texte;
      0435: FrmMiseEnPage.ChBSyntaxe.Caption:= Texte;
      0436: FrmMiseEnPage.ChBSyntaxe.Hint:= Texte;
      0437: FrmMiseEnPage.ChBRetourALaLigne.Caption:= Texte;
      0438: FrmMiseEnPage.ChBRetourALaLigne.Hint:= Texte;
      0451: FrmMiseEnPage.TShEnTetePiedDePage.Caption:= Texte;
      0452: FrmMiseEnPage.TShEnTetePiedDePage.Hint:= Texte;
      0453: FrmMiseEnPage.GBEntete.Caption:= Texte;
      0454: FrmMiseEnPage.GBEntete.Hint:= Texte;
      0455: FrmMiseEnPage.LGaucheEntete.Caption:= Texte;
      0456: FrmMiseEnPage.REdtGaucheEntete.Hint:= Texte;
      0457: FrmMiseEnPage.LCentreEntete.Caption:= Texte;
      0458: FrmMiseEnPage.REdtCentreEntete.Hint:= Texte;
      0459: FrmMiseEnPage.LDroiteEntete.Caption:= Texte;
      0460: FrmMiseEnPage.REdtDroiteEntete.Hint:= Texte;
      0461: FrmMiseEnPage.ChBLigneEntete.Caption:= Texte;
      0462: FrmMiseEnPage.ChBLigneEntete.Hint:= Texte;
      0463: FrmMiseEnPage.ChBEncadreEntete.Caption:= Texte;
      0464: FrmMiseEnPage.ChBEncadreEntete.Hint:= Texte;
      0465: FrmMiseEnPage.ChBOmbreEntete.Caption:= Texte;
      0466: FrmMiseEnPage.ChBOmbreEntete.Hint:= Texte;
      0467: FrmMiseEnPage.GBPiedDePage.Caption:= Texte;
      0468: FrmMiseEnPage.GBPiedDePage.Hint:= Texte;
      0469: FrmMiseEnPage.LGauchePiedDePage.Caption:= Texte;
      0470: FrmMiseEnPage.REdtGauchePiedDePage.Hint:= Texte;
      0471: FrmMiseEnPage.LCentrePiedDePage.Caption:= Texte;
      0472: FrmMiseEnPage.REdtCentrePiedDePage.Hint:= Texte;
      0473: FrmMiseEnPage.LDroitePiedDePage.Caption:= Texte;
      0474: FrmMiseEnPage.REdtDroitePiedDePage.Hint:= Texte;
      0475: FrmMiseEnPage.ChBLignePiedDePage.Caption:= Texte;
      0476: FrmMiseEnPage.ChBLignePiedDePage.Hint:= Texte;
      0477: FrmMiseEnPage.ChBEncadrePiedDePage.Caption:= Texte;
      0478: FrmMiseEnPage.ChBEncadrePiedDePage.Hint:= Texte;
      0479: FrmMiseEnPage.ChBOmbrePiedDePage.Caption:= Texte;
      0480: FrmMiseEnPage.ChBOmbrePiedDePage.Hint:= Texte;
      0481: FrmMiseEnPage.ActNumPage.Hint:= Texte;
      0482: FrmMiseEnPage.ActNbPages.Hint:= Texte;
      0483: FrmMiseEnPage.ActDate.Hint:= Texte;
      0484: FrmMiseEnPage.ActHeure.Hint:= Texte;
      0485: FrmMiseEnPage.ActDateHeure.Hint:= Texte;
      0486: FrmMiseEnPage.ActTitre.Hint:= Texte;
      0487: FrmMiseEnPage.ActFont.Hint:= Texte;
      0488: FrmMiseEnPage.ActGras.Hint:= Texte;
      0489: FrmMiseEnPage.ActItalique.Hint:= Texte;
      0490: FrmMiseEnPage.ActSouligne.Hint:= Texte;
      0495: FrmMiseEnPage.BtnOk.Caption:= Texte;
      0496: FrmMiseEnPage.BtnOk.Hint:= Texte;
      0497: FrmMiseEnPage.BtnAnnule.Caption:= Texte;
      0498: FrmMiseEnPage.BtnAnnule.Hint:= Texte;
    // Fiche apercu 500  549
      0500: FrmApercu.ActPremiere.Hint:= Texte;
      0501: FrmApercu.ActPrecedente.Hint:= Texte;
      0502: FrmApercu.ActSuivante.Hint:= Texte;
      0503: FrmApercu.ActDerniere.Hint:= Texte;
      0504: FrmApercu.ActZoomMoins.Hint:= Texte;
      0505: FrmApercu.ActZoomPlus.Hint:= Texte;
      0506: FrmApercu.ActPageEntiere.Hint:= Texte;
      0507: FrmApercu.ActMiseEnPage.Hint:= Texte;
      0508: FrmApercu.ActImprimer.Hint:= Texte;
    // Erreurs
      else if Numero>1000 then StockeMessage(Numero mod 1000,Texte);
  end;
end;

procedure LitLangue(LaLangue: string);
var
  Ligne: string;
  NomFichierAide: string;
begin
  NomFichierLangue:= RepAppli + LaLangue + ExtLangue;
  AssignFile(FichierLangue,NomFichierLangue);
  reset(FichierLangue);
  while not Eof(FichierLangue) do
  begin
    readln(FichierLangue,Ligne);
    Ligne:= trim(Ligne);
    if (Ligne<>'') and (Ligne[1]<>'{') then TraiteLigne(Ligne);
  end;
  closefile(FichierLangue);
  FrmPrincipale.Update;

  NomFichierAide:= RepAppli + LaLangue + ExtAide;
  if FileExists(NomFichierAide) then Application.HelpFile:= NomFichierAide
     else Application.HelpFile:= RepAppli + 'Franais' + ExtAide;
end;

end.
