unit Fenetres;

{***************************************************************************}
{ Ce logiciel est un logiciel libre. Vous pouvez le diffuser et/ou le       }
{ modifier suivant les termes de la GNU General Public License telle que    }
{ publie par la Free Software Foundation, soit la version 2 de cette        }
{ license, soit ( votre convenance) une version ultrieure.                }
{                                                                           }
{ Ce programme est diffus dans l'espoir qu'il sera utile, mais SANS AUCUNE }
{ GARANTIE, sans mme une garantie implicite de COMMERCIALISABILITE ou      }
{ d'ADEQUATION A UN USAGE PARTICULIER. Voyez la GNU General Public License  }
{ pour plus de dtails.                                                     }
{                                                                           }
{ Vous devriez avoir reu une copie de la GNU General Public License avec   }
{ ce programme, sinon, veuillez crire  la Free Software Foundation, Inc., }
{ 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.                  }
{***************************************************************************}

{***************************************************************************}
{ This program is free software. You can redistribute it and/or modify it   }
{ under the terms of the GNU Public License as published by the             }
{ Free Software Foundation, either version 2 of the license, or             }
{ (at your option) any later version.                                       }
{                                                                           }
{ This program is distributed in the hope it will be useful, but WITHOUT    }
{ ANY WARRANTY, without even the implied warranty of MERCHANTABILITY or     }
{ FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for  }
{ more details.                                                             }
{                                                                           }
{ You should have received a copy of the GNU General Public License along   }
{ with this program, if not, write to the Free Software Foundation, Inc.,   }
{ 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.                  }
{***************************************************************************}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Grids;

type
  TFrmFenetres = class(TForm)
    PnlBoutons: TPanel;
    BtnOk: TButton;
    BtnAnnule: TButton;
    SGrdFenetres: TStringGrid;
    procedure FormShow(Sender: TObject);
    procedure LBoxFenetresDblClick(Sender: TObject);
  private
    { Dclarations prives }
  public
    { Dclarations publiques }
    procedure SetListe(LaListe: TStrings);
    function Execute(Titre,TxtOk,TxtAnnule: string): longint;
  end;

var
  FrmFenetres: TFrmFenetres;

implementation

{$R *.DFM}

{*****************************************************************************}
{ Fiche                                                                       }
{*****************************************************************************}

procedure TFrmFenetres.FormShow(Sender: TObject);
begin
  SGrdFenetres.Row:= 0;
  SGrdFenetres.SetFocus;
end;

procedure TFrmFenetres.LBoxFenetresDblClick(Sender: TObject);
begin
  ModalResult:= mrOK;
end;

{*****************************************************************************}
{ Fonctions public                                                            }
{*****************************************************************************}

procedure TFrmFenetres.SetListe(LaListe: TStrings);
var
  N: longint;
  Long: longint;
  Max: longint;
begin
  SGrdFenetres.Cols[0].Clear;
  SGrdFenetres.RowCount:= LaListe.Count;
  SGrdFenetres.Cols[0].AddStrings(LaListe);
  Max:= 0;
  for N:= 0 to LaListe.Count-1 do
  begin
    Long:= length(LaListe[N]);
    if Long > Max then Max:= Long;
  end;
  SGrdFenetres.DefaultColWidth:= Max * (abs(SGrdFenetres.Font.Height));
end;

function TFrmFenetres.Execute(Titre,TxtOk,TxtAnnule: string): longint;
begin
  Caption:= Titre;
  BtnOk.Caption:= TxtOk;
  BtnAnnule.Caption:= TxtAnnule;
  ShowModal;
  if ModalResult=mrOK then result:= SGrdFenetres.Row
                      else result:= -1;
end;

end.
