unit Editeur;

{***************************************************************************}
{ Ce logiciel est un logiciel libre. Vous pouvez le diffuser et/ou le       }
{ modifier suivant les termes de la GNU General Public License telle que    }
{ publie par la Free Software Foundation, soit la version 2 de cette        }
{ license, soit ( votre convenance) une version ultrieure.                }
{                                                                           }
{ Ce programme est diffus dans l'espoir qu'il sera utile, mais SANS AUCUNE }
{ GARANTIE, sans mme une garantie implicite de COMMERCIALISABILITE ou      }
{ d'ADEQUATION A UN USAGE PARTICULIER. Voyez la GNU General Public License  }
{ pour plus de dtails.                                                     }
{                                                                           }
{ Vous devriez avoir reu une copie de la GNU General Public License avec   }
{ ce programme, sinon, veuillez crire  la Free Software Foundation, Inc., }
{ 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.                  }
{***************************************************************************}

{***************************************************************************}
{ This program is free software. You can redistribute it and/or modify it   }
{ under the terms of the GNU Public License as published by the             }
{ Free Software Foundation, either version 2 of the license, or             }
{ (at your option) any later version.                                       }
{                                                                           }
{ This program is distributed in the hope it will be useful, but WITHOUT    }
{ ANY WARRANTY, without even the implied warranty of MERCHANTABILITY or     }
{ FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for  }
{ more details.                                                             }
{                                                                           }
{ You should have received a copy of the GNU General Public License along   }
{ with this program, if not, write to the Free Software Foundation, Inc.,   }
{ 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.                  }
{***************************************************************************}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ActnList, Menus, SynEdit, StdActns, ComCtrls;

type
  FormatFichier= (WINDOS, UNIX, MAC);

  TFrmEditeur = class(TForm)
    SynEdit: TSynEdit;
    ALEditeur: TActionList;
    ActFenetreCascade: TAction;
    ActFenetreMosaiqueHorizontale: TAction;
    ActFenetreMosaiqueVerticale: TAction;
    ActFenetreToutReduire: TAction;
    ActFenetreToutReorganiser: TAction;
    ActChercherRechercher: TAction;
    ActChercherDansFichier: TAction;
    ActChercherRemplacer: TAction;
    ActChercherSuivant: TAction;
    ActChercherPrecedent: TAction;
    ActOutilsPreferences: TAction;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure SynEditPlaceBookmark(Sender: TObject;
      var Mark: TSynEditMark);
    procedure SynEditReplaceText(Sender: TObject; const ASearch,
      AReplace: String; Line, Column: Integer;
      var Action: TSynReplaceAction);
  private
    { Dclarations prives }
    procedure SaveUnix(NomFichier: string);
    procedure SaveMac(NomFichier: string);
    procedure SaveDos(NomFichier: string);
    procedure Sauve(NomFichier: string; Format: string);
  public
    { Dclarations publiques }
    procedure Enregistrer(Format: string);
    procedure EnregistrerSous(Format: string);
    procedure RechercheRemplace(Remplacer, EnArriere: boolean);
    function Recherche: boolean;
    function Remplace: boolean;
  end;

var
  FrmEditeur: TFrmEditeur;

implementation

uses Main, Data, Utilitaires, Alertes, Recherche, Remplace;

{$R *.DFM}

{*****************************************************************************}
{ Fonctions private                                                           }
{*****************************************************************************}

procedure TFrmEditeur.SaveUnix(NomFichier: string);
var
  Fichier: system.textfile;
  N: longint;
begin
  AssignFile(Fichier,NomFichier);
  Rewrite(Fichier);
  for N:= 0 to SynEdit.Lines.Count-1 do
  begin
    write(Fichier,SynEdit.Lines[N]);
    write(Fichier,#10);
  end;
  CloseFile(Fichier);
end;

procedure TFrmEditeur.SaveMac(NomFichier: string);
var
  Fichier: system.textfile;
  N: longint;
begin
  AssignFile(Fichier,NomFichier);
  Rewrite(Fichier);
  for N:= 0 to SynEdit.Lines.Count-1 do
  begin
    write(Fichier,SynEdit.Lines[N]);
    write(Fichier,#13);
  end;
  CloseFile(Fichier);
end;

procedure TFrmEditeur.SaveDos(NomFichier: string);
var
  Fichier: system.textfile;
  N: longint;
begin
  AssignFile(Fichier,NomFichier);
  Rewrite(Fichier);
  for N:= 0 to SynEdit.Lines.Count-1 do
  begin
    write(Fichier,SynEdit.Lines[N]);
    write(Fichier,#13#10);
  end;
  CloseFile(Fichier);
end;

procedure TFrmEditeur.Sauve(NomFichier: string; Format: string);
begin
  if Format= '&UNIX (LF)' then SaveUnix(NomFichier)
  else
  if Format= '&DOS (CR LF)' then SaveDos(NomFichier)
  else
  if Format= '&MAC (CR)' then SaveMac(NomFichier)
  else
    if SynEdit.Modified then SynEdit.Lines.SaveToFile(NomFichier);
  SynEdit.Modified:= false;
end;

{*****************************************************************************}
{ Fonctions public                                                            }
{*****************************************************************************}

procedure TFrmEditeur.Enregistrer(Format: string);
var
  Nom: string;
  NomCourt: string;
begin
  Nom:= Caption;
  NomCourt:= copy(Nom,1, length(NomGenerique));
  if NomCourt = NomGenerique then EnregistrerSous(Format)
                             else Sauve(Nom,Format);
end;

procedure TFrmEditeur.EnregistrerSous(Format: string);
var
  Nom: string;
  Retour: word;
  Termine: boolean;
  ExtensionOrigine: string;
  Extension: string;
begin
  ExtensionOrigine:= ExtractFileExt(Caption);
  Termine:= false;
  repeat
    if DmAppli.DlgSauver.Execute then
    begin
      Nom:= DmAppli.DlgSauver.FileName;
      if FileExists(Nom) then
      begin
        Retour:= BoiteMessage(111,Nom,'');
        case Retour of
          mrYes    : begin
                       Sauve(Nom,Format);
                       Caption:= Nom;
                       Termine:= true;
                     end;
          mrCancel : Termine:= false;
        end;
      end
      else
      begin
        Sauve(Nom,Format);
        Caption:= Nom;
        Termine:= true;
      end;
      // Mise  jour de la mise en evidence syntaxique
      Extension:= ExtractFileExt(Nom);
      if Extension<>ExtensionOrigine then
        SynEdit.Highlighter := DmAppli.GetHighlighterForFile(Nom);
    end
    else Termine:= true;
  until Termine;
end;

procedure TFrmEditeur.RechercheRemplace(Remplacer, EnArriere: boolean);
var
  Options: TSynSearchOptions;
begin
  Options:= [];
  with RecRechercheRemplace do
  begin
    if Remplacer then
    begin
      if ConfRemplace then Options:= Options + [ssoPrompt];
      if Tout then Options:= Options + [ssoReplace, ssoReplaceAll]
              else Options:= Options + [ssoReplace];
    end;
    if MajMin then Options:= Options + [ssoMatchCase];
    if Mots then Options:= Options + [ssoWholeWord];
    if EnArriere then Options:= Options + [ssoBackwards];
    if TxtSelectionne then Options:= Options + [ssoSelectedOnly];
    if Total then Options:= Options + [ssoEntireScope];
    // La recherche remplacement
    if SynEdit.SearchReplace(TxtRecherche,TxtRemplace,Options) = 0 then
    begin
      // Chaine non trouve
      if ssoBackwards in Options then SynEdit.BlockEnd:= SynEdit.BlockBegin
                                 else SynEdit.BlockBegin:= SynEdit.BlockEnd;
      SynEdit.CaretXY:= SynEdit.BlockBegin;
      BoiteMessage(117,TxtRecherche,'');
    end;
    // On enleve l option toute la portee
    RecRechercheRemplace.Total:= false;
    // On enleve l option texte selectionne
    RecRechercheRemplace.TxtSelectionne:= false;
  end;
end;

function TFrmEditeur.Recherche: boolean;
begin
  // Initialisation
  with FrmRecherche, RecRechercheRemplace do
  begin
    HistoriqueRecherche:= HistRecherche;
    MajusculeMinuscule:= MajMin;
    MotsEntiers:= Mots;
    EnArriere:= Arriere;
    Totalite:= Total;
    // Si quelque chose est selectionne on le met dans le texte a rechercher
    if SynEdit.SelAvail then
    begin
      if SynEdit.BlockBegin.Y = SynEdit.BlockEnd.Y then
        // Le texte complet si meme ligne
        TexteRecherche := SynEdit.SelText
      else
        // Le premier mot
        TexteRecherche := SynEdit.GetWordAtRowCol(SynEdit.CaretXY);
      TxtSelectionne:= false;
    end
    else TexteRecherche:= TxtRecherche; // La derniere recherche
  end;

  // Execution et traitement
  result:= FrmRecherche.Execute(false);
  if result then
  begin
    with FrmRecherche, RecRechercheRemplace do
    begin
      TxtRecherche:= TexteRecherche;
      HistRecherche:= HistoriqueRecherche;
      MajMin:= MajusculeMinuscule;
      Mots:= MotsEntiers;
      Arriere:= EnArriere;
      Total:= Totalite;
    end;
    RechercheRemplace(false,RecRechercheRemplace.Arriere);
  end;
end;

function TFrmEditeur.Remplace: boolean;
begin
  // Initialisation
  with FrmRemplace, RecRechercheRemplace do
  begin
    HistoriqueRecherche:= HistRecherche;
    HistoriqueRemplace:= HistRemplace;
    MajusculeMinuscule:= MajMin;
    MotsEntiers:= Mots;
    Confirmer:= ConfRemplace;
    EnArriere:= Arriere;
    Totalite:= Total;
    // Si quelque chose est selectionne on le met dans le texte a rechercher
    if SynEdit.SelAvail then
    begin
      if SynEdit.BlockBegin.Y = SynEdit.BlockEnd.Y then
        // Le texte complet si meme ligne
        TexteRecherche := SynEdit.SelText
      else
        // Le premier mot
        TexteRecherche := SynEdit.GetWordAtRowCol(SynEdit.CaretXY);
      TxtSelectionne:= false;
    end
    else TexteRecherche:= TxtRecherche; // La derniere recherche
    TexteRemplace:= TxtRemplace; // Le dernier remplacement
  end;

  // Execution et traitement
  result:= FrmRemplace.Execute(false);
  if result then
  begin
    with FrmRemplace, RecRechercheRemplace do
    begin
      TxtRecherche:= TexteRecherche;
      HistRecherche:= HistoriqueRecherche;
      TxtRemplace:= TexteRemplace;
      HistRemplace:= HistoriqueRemplace;
      MajMin:= MajusculeMinuscule;
      Mots:= MotsEntiers;
      ConfRemplace:= Confirmer;
      Arriere:= EnArriere;
      Total:= Totalite;
      Tout:= RemplaceTout;
    end;
    RechercheRemplace(true,RecRechercheRemplace.Arriere);
  end;
end;

{*****************************************************************************}
{ Fiche                                                                       }
{*****************************************************************************}

procedure TFrmEditeur.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Action := caFree;
end;

procedure TFrmEditeur.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
var
  Retour: word;
  NomCourt: string;
begin
  if SynEdit.Modified then
  begin
    Retour:= BoiteMessage(113,Caption,'');
    case Retour of
      mrYes   : Enregistrer('');
      mrCancel: CanClose:= false;
    end;
  end;
  if CanClose then
  begin
    NomCourt:= copy(Caption,1, length(NomGenerique));
    if NomCourt <> NomGenerique then DMAppli.AjouteFichierRecent(Caption);
    DMAppli.EnleveFenetre(Caption);
  end;
end;

procedure TFrmEditeur.SynEditPlaceBookmark(Sender: TObject;
  var Mark: TSynEditMark);
begin
if Mark.IsBookmark then
    Mark.InternalImage := true;
end;

procedure TFrmEditeur.SynEditReplaceText(Sender: TObject; const ASearch,
  AReplace: String; Line, Column: Integer; var Action: TSynReplaceAction);
var
  APos: TPoint;
  EditRect: TRect;
begin
  if ASearch = AReplace then
    Action := raSkip
  else begin
    APos := Point(Column, Line);
    APos := SynEdit.ClientToScreen(SynEdit.RowColumnToPixels(APos));
    EditRect := ClientRect;
    EditRect.TopLeft := ClientToScreen(EditRect.TopLeft);
    EditRect.BottomRight := ClientToScreen(EditRect.BottomRight);

    with RecRechercheRemplace do
    case BoiteMessagePos(115,TxtRecherche,TxtRemplace,APos.X, APos.Y) of
      mrYes: Action := raReplace;
      mrAll: Action := raReplaceAll;
      mrNo: Action := raSkip;
      else Action := raCancel;
    end;
  end;
end;

end.
