unit Data;

{***************************************************************************}
{ Ce logiciel est un logiciel libre. Vous pouvez le diffuser et/ou le       }
{ modifier suivant les termes de la GNU General Public License telle que    }
{ publie par la Free Software Foundation, soit la version 2 de cette        }
{ license, soit ( votre convenance) une version ultrieure.                }
{                                                                           }
{ Ce programme est diffus dans l'espoir qu'il sera utile, mais SANS AUCUNE }
{ GARANTIE, sans mme une garantie implicite de COMMERCIALISABILITE ou      }
{ d'ADEQUATION A UN USAGE PARTICULIER. Voyez la GNU General Public License  }
{ pour plus de dtails.                                                     }
{                                                                           }
{ Vous devriez avoir reu une copie de la GNU General Public License avec   }
{ ce programme, sinon, veuillez crire  la Free Software Foundation, Inc., }
{ 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.                  }
{***************************************************************************}

{***************************************************************************}
{ This program is free software. You can redistribute it and/or modify it   }
{ under the terms of the GNU Public License as published by the             }
{ Free Software Foundation, either version 2 of the license, or             }
{ (at your option) any later version.                                       }
{                                                                           }
{ This program is distributed in the hope it will be useful, but WITHOUT    }
{ ANY WARRANTY, without even the implied warranty of MERCHANTABILITY or     }
{ FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for  }
{ more details.                                                             }
{                                                                           }
{ You should have received a copy of the GNU General Public License along   }
{ with this program, if not, write to the Free Software Foundation, Inc.,   }
{ 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.                  }
{***************************************************************************}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ImgList, SynHighlighterVB, SynHighlighterTclTk, SynHighlighterSML,
  SynHighlighterSQL, SynHighlighterPython, SynHighlighterProgress,
  SynHighlighterPHP, SynHighlighterPerl, SynHighlighterPas,
  SynHighlighterBat, SynHighlighterASM, SynHighlighterVBScript,
  SynHighlighterFoxpro, SynHighlighterGalaxy, SynHighlighterDml,
  SynHighlighterGeneral, SynHighlighterHP48, SynHighlighterHTML,
  SynHighlighterIni, SynHighlighterInno, SynHighlighterJava,
  SynHighlighterJScript, SynHighlighterKix, SynHighlighterFortran,
  SynHighlighterDfm, SynHighlighterCss, SynHighlighterCAC,
  SynHighlighterCache, SynHighlighterCpp, SynHighlighterBaan,
  SynHighlighterAWK, SynHighlighterADSP21xx, SynEditHighlighter,
  SynHighlighterHC11, SynEditPrint, SynHighlighterXML;

type
  TRecRechercheRemplace = record
                            TxtRecherche: string;
                            HistRecherche: string;
                            TxtRemplace: string;
                            HistRemplace: string;
                            MajMin: boolean;
                            Mots: boolean;
                            ConfRemplace: boolean;
                            Tout: boolean;
                            Arriere: boolean;
                            TxtSelectionne: boolean;
                            Total: boolean;
                          end;
  TDMAppli = class(TDataModule)
    ILAppli: TImageList;
    DlgOuvrir: TOpenDialog;
    DlgSauver: TSaveDialog;
    DlgImprimer: TPrintDialog;
    DlgCfgImprimante: TPrinterSetupDialog;
    DlgChercher: TFindDialog;
    DlgRemplacer: TReplaceDialog;
    SynHC11Syn1: TSynHC11Syn;
    SynADSP21xxSyn1: TSynADSP21xxSyn;
    SynAWKSyn1: TSynAWKSyn;
    SynBaanSyn1: TSynBaanSyn;
    SynCppSyn1: TSynCppSyn;
    SynCacheSyn1: TSynCacheSyn;
    SynCACSyn1: TSynCACSyn;
    SynCssSyn1: TSynCssSyn;
    SynDfmSyn1: TSynDfmSyn;
    SynFortranSyn1: TSynFortranSyn;
    SynKixSyn1: TSynKixSyn;
    SynJScriptSyn1: TSynJScriptSyn;
    SynJavaSyn1: TSynJavaSyn;
    SynInnoSyn1: TSynInnoSyn;
    SynIniSyn1: TSynIniSyn;
    SynHTMLSyn1: TSynHTMLSyn;
    SynHP48Syn1: TSynHP48Syn;
    SynGeneralSyn1: TSynGeneralSyn;
    SynDmlSyn1: TSynDmlSyn;
    SynGalaxySyn1: TSynGalaxySyn;
    SynFoxproSyn1: TSynFoxproSyn;
    SynVBScriptSyn1: TSynVBScriptSyn;
    SynAsmSyn1: TSynAsmSyn;
    SynBatSyn1: TSynBatSyn;
    SynPasSyn1: TSynPasSyn;
    SynPerlSyn1: TSynPerlSyn;
    SynPHPSyn1: TSynPHPSyn;
    SynProgressSyn1: TSynProgressSyn;
    SynPythonSyn1: TSynPythonSyn;
    SynSQLSyn1: TSynSQLSyn;
    SynSMLSyn1: TSynSMLSyn;
    SynTclTkSyn1: TSynTclTkSyn;
    SynVBSyn1: TSynVBSyn;
    SynEditPrint: TSynEditPrint;
    SynXMLSyn1: TSynXMLSyn;
    procedure DataModuleCreate(Sender: TObject);
    procedure DataModuleDestroy(Sender: TObject);
  private
    { Dclarations prives }
    fHighlighters: TStringList;
    FichiersRecents: TStringList;
    FichiersRecentsChanged: boolean;
    ListeFenetres: TStringList;
    FenetresChanged: boolean;
    function FichierRecentExiste(Nom: string): longint;
    function GetFichiersRecentsModifies: boolean;
    procedure SetFichiersRecentsModifies(Valeur: boolean);
    function GetFenetresModifies: boolean;
    procedure SetFenetresModifies(Valeur: boolean);
  public
    { Dclarations publiques }
    procedure GetHighlighterList(LaListe: TStrings);
    function GetHighlighterForFile(NomFichier: string): TSynCustomHighlighter;
    function GetHighlighter(Nom: string): TSynCustomHighlighter;
    property FichiersRecentsModifies: boolean read GetFichiersRecentsModifies
      write SetFichiersRecentsModifies;
    function NombreFichiersRecents: longint;
    procedure AjouteFichierRecent(Nom: string);
    procedure EnleveFichierRecent(Nom: string);
    function LitFichierRecent(Num: longint): string;
    property FenetresModifies: boolean read GetFenetresModifies
      write SetFenetresModifies;
    function NombreFenetres: longint;
    procedure AjouteFenetre(Nom: string);
    procedure EnleveFenetre(Nom: string);
    procedure DeplaceFenetre(Numero: longint);
    function LitFenetre(Num: longint): string;
    function GetListeFenetres: TStrings;
  end;

const
  MaxFichiersRecents= 9; //Nombre maxi - 1 car on compte de 0
  MaxFenetres= 9; //Nombre maxi - 1 car on compte de 0
var
  RecRechercheRemplace: TRecRechercheRemplace;
  DMAppli: TDMAppli;

implementation

{$R *.DFM}

uses uHighlighterProcs;

{*****************************************************************************}
{ Data module                                                                 }
{*****************************************************************************}

procedure TDmAppli.DataModuleCreate(Sender: TObject);
{Repertorie les coloreur syntaxiques et place les extensions}
{de fichier correspondantes dans la liste des filtres des   }
{dialogues d'ouverture et d'enregistrement                  }
begin
  fHighlighters := TStringList.Create;
  GetHighlighters(Self, fHighlighters, FALSE);
  fHighlighters.Sorted:= true;
  DlgOuvrir.Filter := 'All files (*.*)|*.*|'
    + GetHighlightersFilter(fHighlighters);
  DlgSauver.Filter := DlgOuvrir.Filter;
  // Correction du style pour le HTML
  SynHTMLSyn1.AndAttri.Style:= [];
  SynHTMLSyn1.KeyAttri.Style:= [];

  // Fichiers recent
  FichiersRecents:= TStringList.Create;
  FichiersRecentsChanged:= true;

  // Rechercher Remplacer
  with RecRechercheRemplace do
  begin
    TxtRecherche:= '';
    HistRecherche:= '';
    TxtRemplace:= '';
    HistRemplace:= '';
    MajMin:= false;
    Mots:= false;
    ConfRemplace:= true;
    Arriere:= false;
    Total:= false;
  end;

  // Liste des fenetres
  ListeFenetres:= TStringList.Create;
end;

procedure TDMAppli.DataModuleDestroy(Sender: TObject);
begin
  fHighlighters.Free;
  FichiersRecents.Free;
  ListeFenetres.Free;
end;

{*****************************************************************************}
{ Fonctions private                                                           }
{*****************************************************************************}

function TDMAppli.FichierRecentExiste(Nom: string): longint;
var
  N: longint;
begin
  result:= -1;
  N:= -1;
  while ((N< FichiersRecents.Count-1)and (result=-1)) do
  begin
    inc(N);
    if FichiersRecents.Strings[N]=Nom then result:= N;
  end;
end;

function TDMAppli.GetFichiersRecentsModifies: boolean;
begin
  result:= FichiersRecentsChanged;
end;

procedure TDMAppli.SetFichiersRecentsModifies(Valeur: boolean);
begin
  FichiersRecentsChanged:= Valeur;
end;

function TDMAppli.GetFenetresModifies: boolean;
begin
  result:= FenetresChanged;
end;

procedure TDMAppli.SetFenetresModifies(Valeur: boolean);
begin
  FenetresChanged:= Valeur;
end;

{*****************************************************************************}
{ Fonctions public                                                            }
{*****************************************************************************}

procedure TDmAppli.GetHighlighterList(LaListe: TStrings);
begin
  if fHighlighters <> nil then LaListe.Assign(fHighlighters);
  LaListe.Insert(0, '?????');
end;

function TDmAppli.GetHighlighterForFile(NomFichier: string)
  : TSynCustomHighlighter;
begin
  if NomFichier <> '' then
    Result := GetHighlighterFromFileExt(fHighlighters, ExtractFileExt(NomFichier))
  else
    Result := nil;
end;

function TDmAppli.GetHighlighter(Nom: string): TSynCustomHighlighter;
var
  N: integer;
  Find: boolean;
begin
  Find:= false;
  N:= 0;
  while not (Find or (N = fHighlighters.Count)) do
  begin
    Find:= fHighlighters[N] = Nom;
    inc(N);
  end;
  if Find then
    Result:= fHighlighters.Objects[N-1] as TSynCustomHighlighter
  else
    Result:= nil;
end;

function TDMAppli.NombreFichiersRecents: longint;
begin
  result:= FichiersRecents.Count;
end;

procedure TDMAppli.AjouteFichierRecent(Nom: string);
var
  N: longint;
  Nombre: longint;
begin
  // On l'enleve si il existe
  EnleveFichierRecent(Nom);
  // On ajoute en debut de liste
  FichiersRecents.Insert(0,Nom);
  // On supprime ceux en trop
  Nombre:= FichiersRecents.Count-1;
  if Nombre > MaxFichiersRecents then
    for N:= Nombre downto (MaxFichiersRecents+1) do FichiersRecents.Delete(N);
  FichiersRecentsChanged:= true;
end;

procedure TDMAppli.EnleveFichierRecent(Nom: string);
var
  N: longint;
begin
  // On l'enleve si il existe
  N:= FichierRecentExiste(Nom);
  if N>-1 then FichiersRecents.Delete(N);
  FichiersRecentsChanged:= true;
end;

function TDMAppli.LitFichierRecent(Num: Integer): string;
begin
  if Num<NombreFichiersRecents then result:= FichiersRecents.Strings[Num]
                               else result:= '';
end;

{ Fenetres }

function TDMAppli.NombreFenetres: longint;
begin
  result:= ListeFenetres.Count;
end;

procedure TDMAppli.AjouteFenetre(Nom: string);
begin
  ListeFenetres.Insert(0,Nom);
  FenetresChanged:= true;
end;

procedure TDMAppli.EnleveFenetre(Nom: string);
var
  N: longint;
begin
  N:= ListeFenetres.IndexOf(Nom);
  if N > -1 then ListeFenetres.Delete(N);
  FenetresChanged:= true;
end;

procedure TDMAppli.DeplaceFenetre(Numero: Integer);
var
  Nom: string;
begin
  Nom:= ListeFenetres.Strings[Numero];
  ListeFenetres.Delete(Numero);
  ListeFenetres.Insert(MaxFenetres,Nom);
end;

function TDMAppli.LitFenetre(Num: Integer): string;
begin
  if Num<NombreFenetres then result:= ListeFenetres.Strings[Num]
                        else result:= '';
end;

function TDMAppli.GetListeFenetres: TStrings;
begin
  result:= ListeFenetres;
end;

end.
