unit Alertes;

{***************************************************************************}
{ Ce logiciel est un logiciel libre. Vous pouvez le diffuser et/ou le       }
{ modifier suivant les termes de la GNU General Public License telle que    }
{ publie par la Free Software Foundation, soit la version 2 de cette        }
{ license, soit ( votre convenance) une version ultrieure.                }
{                                                                           }
{ Ce programme est diffus dans l'espoir qu'il sera utile, mais SANS AUCUNE }
{ GARANTIE, sans mme une garantie implicite de COMMERCIALISABILITE ou      }
{ d'ADEQUATION A UN USAGE PARTICULIER. Voyez la GNU General Public License  }
{ pour plus de dtails.                                                     }
{                                                                           }
{ Vous devriez avoir reu une copie de la GNU General Public License avec   }
{ ce programme, sinon, veuillez crire  la Free Software Foundation, Inc., }
{ 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.                  }
{***************************************************************************}

{***************************************************************************}
{ This program is free software. You can redistribute it and/or modify it   }
{ under the terms of the GNU Public License as published by the             }
{ Free Software Foundation, either version 2 of the license, or             }
{ (at your option) any later version.                                       }
{                                                                           }
{ This program is distributed in the hope it will be useful, but WITHOUT    }
{ ANY WARRANTY, without even the implied warranty of MERCHANTABILITY or     }
{ FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for  }
{ more details.                                                             }
{                                                                           }
{ You should have received a copy of the GNU General Public License along   }
{ with this program, if not, write to the Free Software Foundation, Inc.,   }
{ 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.                  }
{***************************************************************************}

interface

const
  MaxMessage= 200;

procedure VideMessage;
procedure StockeMessage(Num: longint;Texte: string);
function BoiteMessage(Num: longint;Ch1,Ch2: string): word;
function BoiteMessagePos(Num: longint;Ch1,Ch2: string;X,Y: longint):word;
function GetMsg(Num: longint): string;

implementation

uses Dialogs;

type
  TMsg= (msgErreur,msgInfo,msgAlerte,msgOuiNon,msgOuiNonAnnule,msgOuiNonTout);
var
  Msg: array[1..MaxMessage] of string;

procedure VideMessage;
var
  N: integer;
begin
  for N:= 1 to MaxMessage do Msg[N]:= '';
end;

procedure StockeMessage(Num: longint;Texte: string);
begin
  Msg[Num]:= Texte;
end;

function AfficheMsg(Texte: string; Genre: TMsg): word;
begin
  case Genre of
    msgErreur: result:= MessageDlg(Texte, mtError, [mbOk], 0);
    msgInfo  : result:= MessageDlg(Texte, mtInformation, [mbOk], 0);
    msgAlerte: result:= MessageDlg(Texte, mtWarning, [mbOk], 0);
    msgOuiNon: result:= MessageDlg(Texte, mtConfirmation, [mbYes,mbNo], 0);
    msgOuiNonAnnule: result:= MessageDlg(Texte, mtConfirmation, [mbYes,mbNo,mbCancel], 0);
    msgOuiNonTout: result:= MessageDlg(Texte, mtWarning, [mbYes,mbNo,mbAll], 0);
    else result:= 0;
  end;
end;

function BoiteMessage(Num: longint;Ch1,Ch2: string):word;
var
  Chaine: string;
begin
  case Num of
    // Messages d'erreur
    // Messages de dialogue
    111 : begin // Alerte fichier existe deja. Ecraser
            Chaine:= Msg[111] + #13 + Ch1 + #13 + #13 + Msg[112];
            result:= AfficheMsg(Chaine,msgOuiNonAnnule);
          end;
    113 : begin // Alerte fichier modifi. Enregistrer
            Chaine:= Msg[113] + #13 + Ch1 + ' ' + Msg[114];
            result:= AfficheMsg(Chaine,msgOuiNonAnnule);
          end;
    117 : begin // Alerte recherche non trouvee
            Chaine:= Msg[117] + ': ' + Ch1 + #13 + Msg[118];
            result:= AfficheMsg(Chaine,msgInfo);
          end;
    else result:= 0;
  end;
end;

function BoiteMessagePos(Num: longint;Ch1,Ch2: string;X,Y: longint):word;
var
  Chaine: string;
begin
  case Num of
    115 : begin
            Chaine:= Msg[115] + ' ''' + Ch1 + '''' + #13;
            Chaine:= Chaine + Msg[116] + ' ''' + Ch1 + '''';
            result:= MessageDlgPos(Chaine, mtConfirmation,[mbYes,mbNo,mbAll],0, X, Y);
          end;
    else result:= 0;
  end;
end;

function GetMsg(Num: longint): string;
begin
  result:= Msg[Num];
end;

end.
