unit About;

{***************************************************************************}
{ Ce logiciel est un logiciel libre. Vous pouvez le diffuser et/ou le       }
{ modifier suivant les termes de la GNU General Public License telle que    }
{ publie par la Free Software Foundation, soit la version 2 de cette        }
{ license, soit ( votre convenance) une version ultrieure.                }
{                                                                           }
{ Ce programme est diffus dans l'espoir qu'il sera utile, mais SANS AUCUNE }
{ GARANTIE, sans mme une garantie implicite de COMMERCIALISABILITE ou      }
{ d'ADEQUATION A UN USAGE PARTICULIER. Voyez la GNU General Public License  }
{ pour plus de dtails.                                                     }
{                                                                           }
{ Vous devriez avoir reu une copie de la GNU General Public License avec   }
{ ce programme, sinon, veuillez crire  la Free Software Foundation, Inc., }
{ 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.                  }
{***************************************************************************}

{***************************************************************************}
{ This program is free software. You can redistribute it and/or modify it   }
{ under the terms of the GNU Public License as published by the             }
{ Free Software Foundation, either version 2 of the license, or             }
{ (at your option) any later version.                                       }
{                                                                           }
{ This program is distributed in the hope it will be useful, but WITHOUT    }
{ ANY WARRANTY, without even the implied warranty of MERCHANTABILITY or     }
{ FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for  }
{ more details.                                                             }
{                                                                           }
{ You should have received a copy of the GNU General Public License along   }
{ with this program, if not, write to the Free Software Foundation, Inc.,   }
{ 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.                  }
{***************************************************************************}

interface

uses
  Windows, StdCtrls, Controls, Buttons, Graphics, Classes, ExtCtrls, Forms,
  ShellApi;

type
  TFAbout = class(TForm)
    BtnOk: TBitBtn;
    Icone: TImage;
    titreCopyright: TLabel;
    TitreProgramme: TLabel;
    TitreVersion: TLabel;
    MemoFr: TMemo;
    MemoGb: TMemo;
    LblWebsite: TLabel;
    LblMailAddress: TLabel;

    procedure FormShow(Sender: TObject);
    procedure LblWebsiteClick(Sender: TObject);
    procedure LblMailAddressClick(Sender: TObject);
  private
    { Dclarations prives }
  public
    { Dclarations publiques }
    Version : string;
  end;

var
  FAbout: TFAbout;

implementation

uses Main, Utilitaires;

{$R *.DFM}

procedure TFAbout.FormShow(Sender: TObject);
begin
  Version := VersionSoft;
  Caption := EpureTexte(FrmPrincipale.ActAideAPropos.Caption);
  TitreProgramme.Caption := Application.Title;
  Icone.Picture.Graphic := Application.Icon;
  TitreVersion.Caption := 'Version ' + Version;
end;

procedure TFAbout.LblWebsiteClick(Sender: TObject);
begin
  ShellExecute(0,'open','http://jack.r.free.fr',nil,nil,SW_SHOW);
end;

procedure TFAbout.LblMailAddressClick(Sender: TObject);
begin
  ShellExecute(0,'open','mailto:jack.r@free.fr',nil,nil,SW_SHOW);
end;

end.
