{

                            RS232   Version 3.0

                         Creation Alain JAFFRE 1996

  ͸
                 Programme ecrit pour TURBO PASCAL 7.0                    
                                                                          
                             Alain JAFFRE                                 
  ;

}
Unit RSVisu;

{$I RSComp.Pas}

INTERFACE

Uses Crt,Dos,AJCOUL,AJGLOB,AJSOURIS,AJGENTX,AJFTRTX,AJMENUTX,
     RSGlob;

{}

Procedure Visualise;

{ Affiche le fichier en memoire                                              }
(**)
Procedure InfoPosition;

{ Affiche les caracteristique d'occupation memoire                           }
(**)

IMPLEMENTATION

{}

Const
  LargFnt = 78; { Largeur de la fenetre }
  HautFnt = 21; { Hauteur de la fenetre }

{}

Type
  TextePtr = ^LigneTexte;
  LigneTexte = record
                 LTxt : array [1..HautFnt] of string;
               end;

{}

Var
  Dialog       : DialogRecTx;
  AncienneAide : Str80;

  Texte     : TextePtr; { Tableau (fenetre virtuelle) }
  PremCar   : longint; { Numero du 1er caractere dans le tableau Texte }
  DerCar    : longint; { Numero du 1er caractere dans le tableau Texte }
  ColTexte  : byte; { Colonne du 1er caractere affiche tableau Texte }
  DerLig    : byte; { Numero de ligne du tableau correspondant a fin fichier }
  Debut     : byte; { Numero de la ligne du tableau debutant l'affichage }

  XCurseur  : byte; { Position en X du curseur a l'ecran }
  YCurseur  : byte; { Position en X du curseur a l'ecran }

  XFichier  : longint; { Position en X dans le fichier }
  YFichier  : longint; { Position en Y dans le fichier }

{}

Procedure InitFenetre;

Var
  TexteTmp : Str80;
  N        : byte;

Begin
  AncienneAide := LigneAide.Texte;
  LigneAide.Texte := AideStd + '  ' + Msg[158]^ + '  ' + Msg[159]^;
  TexteTmp := FichierOuvert;
  if length(TexteTmp) > 70 then
    TexteTmp := copy(TexteTmp,length(TexteTmp) - (LargFnt - 9),(LargFnt - 8));
  with Dialog do
  Begin
    Tip := Cadre2;
    Coul := CoulSaisie;
    Titre := ' ' + TexteTmp + ' ';
  End;
  CentreDialogTx(LargFnt,HautFnt,Dialog);
  new(Texte);
  PremCar  := 0;
  DerCar   := 0;
  ColTexte := 1;
  XCurseur := 1;
  YCurseur := 1;
  XFichier := 1;
  YFichier := 1;
End;

{}

Procedure AfficheFenetre;

Begin
  OuvreDialogTx(Dialog);
  with Dialog do
  Begin
    gotoxy(X + 2,Y);
    CoulFondTx(CoulSaisie.Fond);
    CoulEncreTx(CoulSaisie.Encre);
    write('[');
    CoulEncreTx(VertClair);
    write(#254);
    CoulEncreTx(CoulSaisie.Encre);
    write(']');
  End;
  AfficheLigneAideTx(true);
End;

{}

Procedure LibereFenetre;

Var
  N : byte;

Begin
  FermeDialogTx(Dialog);
  dispose(Texte);
  LigneAide.Texte := AncienneAide;
  AfficheLigneAideTx(true);
End;

{}

Procedure StockeTexte(Premier : longint);
 { Premier = car. precedent le premier a afficher }

Var
  NumCar   : longint;
  LeCar    : char;
  NumLigne : byte;
  LigneTmp : string;

Begin
  NumCar := Premier;
  PremCar := Premier + 1;
  DerLig := 0;
  for NumLigne := 1 to HautFnt do
  Begin
    LigneTmp := '';
    if NumCar  < NbDeCar then
    repeat
      inc(NumCar);
      LeCar := LectureCar(NumCar);
      LigneTmp := LigneTmp + LeCar;
      if NumCar = NbDeCar then DerLig := NumLigne;
    until (ord(LeCar) = 10) or (NumCar  = NbDeCar);
    with Texte^ do LTxt[NumLigne] := LigneTmp;
  End;
  DerCar := NumCar;
  Debut := 1;
End;

{}

Procedure AffichePosition;

Var
  PosEnTx : Str20;

Begin
  CacheSouris;
  CacheCurseurTx;
  PosEnTx := ' ' + IntToStr(YFichier);
  while length(PosEnTx) < 8 do PosEnTx := #205 + PosEnTx;
  PosEnTx := PosEnTx + ':' + IntToStr(XFichier) + ' ';
  while length(PosEnTx) < 13 do PosEnTx := PosEnTx + #205;
  CoulFondTx(CoulSaisie.Fond);
  CoulEncreTx(CoulSaisie.Encre);
  with Dialog do gotoxy(X + 2,Y + Haut - 1);
  write(PosEnTx);
  with Dialog do gotoxy(XCurseur + X,YCurseur + Y);
  MontreCurseurTx;
  MontreSouris;
End;

{}

Procedure AfficheUneLigne(Col,Lig : byte;LigneTmp : string);

Var
  M : byte;

Begin
  LigneTmp := copy(LigneTmp,Col,LargFnt);
  LigneTmp := ElargiADte(LigneTmp,LargFnt);
  with Dialog do EcritXYTx(X + 1,Y+Lig,LigneTmp,AffiStandard);
End;

{}

Procedure AfficheTexte(Col : byte);

Var
  N        : byte;
  LigneTmp : string;
  Num      : byte;

Begin
  CacheSouris;
  CacheCurseurTx;
  CoulFondTx(CoulSaisie.Fond);
  CoulEncreTx(CoulMenu.Fond);
  Num := Debut - 1;
  for N := 1 to HautFnt do
  Begin
    inc(Num);
    if Num > HautFnt then dec(Num,HautFnt);
    LigneTmp := Texte^.LTxt[Num];
    AfficheUneLigne(Col,N,LigneTmp);
  End;
  MontreCurseurTx;
  MontreSouris;
  AffichePosition;
End;

{}

Procedure AjouteLigneBas;

Var
  NumCar   : longint;
  LeCar    : char;
  LigneTmp : string;

Begin
  NumCar := DerCar;
  PremCar := PremCar + length(Texte^.LTxt[Debut]);
  LigneTmp := '';
  repeat
    inc(NumCar);
    LeCar := LectureCar(NumCar);
    LigneTmp := LigneTmp + LeCar;
    if NumCar = NbDeCar then DerLig := Debut;
  until (ord(LeCar) = 10) or (NumCar  = NbDeCar);
  with Texte^ do LTxt[Debut] := LigneTmp;
  DerCar := NumCar;

  CacheSouris;
  CacheCurseurTx;
  CoulFondTx(CoulSaisie.Fond);
  CoulEncreTx(CoulMenu.Fond);
  with Dialog do ScrollHautTx(1,X + 1,Y + 1,LargFnt,HautFnt,textattr);
  with Texte^ do AfficheUneLigne(ColTexte,YCurseur,LTxt[Debut]);
  MontreCurseurTx;
  MontreSouris;
  inc(Debut);
  if Debut > HautFnt then Debut := 1;
End;

{}

Procedure VaBas;

Var
  M : byte;

Begin
  M := Debut + YCurseur - 1;
  if M > HautFnt then dec(M,HautFnt);
  if M = DerLig then exit
  else
  Begin
    if YCurseur < HautFnt then
    Begin
      inc(YCurseur);
      inc(YFichier);
    End
    else
    Begin
      AjouteLigneBas;
      inc(YFichier);
    End;
    AffichePosition;
  End;
End;

{}

Procedure AjouteLigneHaut;

Var
  NumCar   : longint;
  LeCar    : char;
  LigneTmp : string;

Begin
  if DerLig = Debut then DerLig := 0;
  if Debut = 1 then Debut := HautFnt
               else dec(Debut);
  DerCar := DerCar - length(Texte^.LTxt[Debut]);

  NumCar := PremCar - 1;
  LigneTmp := LectureCar(NumCar);
  repeat
    dec(NumCar);
    LeCar := LectureCar(NumCar);
    LigneTmp := LeCar + LigneTmp;
  until (ord(LeCar) = 10) or (NumCar  = 1);
  if ord(LeCar) = 10 then delete(LigneTmp,1,1);
  if NumCar = 1 then NumCar := 0;
  PremCar := NumCar + 1;
  with Texte^ do LTxt[Debut] := LigneTmp;
  if DerLig = Debut then DerLig := 0;

  CacheSouris;
  CacheCurseurTx;
  CoulFondTx(CoulSaisie.Fond);
  CoulEncreTx(CoulMenu.Fond);
  with Dialog do ScrollBasTx(1,X + 1,Y + 1,LargFnt,HautFnt,textattr);
  with Texte^ do AfficheUneLigne(ColTexte,YCurseur,LTxt[Debut]);
  MontreCurseurTx;
  MontreSouris;
End;

{}

Procedure VaHaut;

Begin
  if YFichier = 1 then exit
  else
  Begin
    if YCurseur > 1 then
    Begin
      dec(YCurseur);
      dec(YFichier);
    End
    else
    Begin
      AjouteLigneHaut;
      dec(YFichier);
    End;
    AffichePosition;
  End;
End;

{}

Procedure VaDroite;

Var
  N        : byte;
  Num      : byte;
  LigneTmp : string;

Begin
  if XFichier = 255 then exit
  else
  Begin
    inc(XFichier);
    inc(ColTexte);
    if XCurseur < LargFnt then inc(XCurseur)
    else
    Begin
      CacheSouris;
      CacheCurseurTx;
      CoulFondTx(CoulSaisie.Fond);
      CoulEncreTx(CoulMenu.Fond);
      with Dialog do ScrollGaucheTx(1,X + 1,Y + 1,LargFnt,HautFnt,textattr);
      Num := Debut - 1;
      for N := 1 to (HautFnt-1) do
      Begin
        inc(Num);
        if Num > HautFnt then dec(Num,HautFnt);
        LigneTmp := Texte^.LTxt[Num];
        if length(LigneTmp) >= XFichier then
          with Dialog do
            EcritXYTx(X+XCurseur,Y+N,LigneTmp[XFichier],AffiStandard)
      End;
      MontreCurseurTx;
      MontreSouris;
    End;
    AffichePosition;
  End;
End;

{}

Procedure VaGauche;

Var
  N        : byte;
  Num      : byte;
  LigneTmp : string;

Begin
  if XFichier = 1 then exit
  else
  Begin
    dec(XFichier);
    dec(ColTexte);
    if XCurseur > 1 then dec(XCurseur)
    else
    Begin
      CacheSouris;
      CacheCurseurTx;
      CoulFondTx(CoulSaisie.Fond);
      CoulEncreTx(CoulMenu.Fond);
      with Dialog do ScrollDroitTx(1,X + 1,Y + 1,LargFnt,HautFnt,textattr);
      Num := Debut - 1;
      for N := 1 to HautFnt do
      Begin
        inc(Num);
        if Num > HautFnt then dec(Num,HautFnt);
        LigneTmp := Texte^.LTxt[Num];
        if length(LigneTmp) >= XFichier then
          with Dialog do
            EcritXYTx(X+1,Y+N,LigneTmp[XFichier],AffiStandard)
      End;
      MontreCurseurTx;
      MontreSouris;
    End;
    AffichePosition;
  End;
End;

{}

Procedure VaDebutLig;

Begin
  if XFichier = 1 then exit
  else
  Begin
    XFichier := 1;
    XCurseur := 1;
    if ColTexte = 1 then AffichePosition
    else
    Begin
      ColTexte := 1;
      AfficheTexte(ColTexte);
    End;
  End;
End;

{}

Procedure VaPlusLoin(Long : byte);

Var
  M : byte;

Begin
  M := Long - XFichier;
  if M <= (LargFnt - XCurseur) then
  Begin
    inc(XCurseur,M);
    XFichier := Long;
    AffichePosition;
  End
  else
  Begin
    ColTexte := Long - LargFnt + 1;
    XCurseur := LargFnt;
    XFichier := Long;
    AfficheTexte(ColTexte);
  End;
End;

{}

Procedure VaMoinsLoin(Long : byte);

Var
  M : byte;

Begin
  M := XFichier - XCurseur + 1;
  if (Long >= M) and (Long < (M + LargFnt)) then
  Begin
    M := XFichier - Long;
    dec(XCurseur,M);
    XFichier := Long;
    AffichePosition;
  End
  else
  Begin
    if Long > LargFnt then ColTexte := Long - LargFnt + 1
                      else ColTexte := 1;
    XCurseur := LargFnt;
    XFichier := Long;
    AfficheTexte(ColTexte);
  End;
End;

{}

Procedure VaFinLig;

Var
  M,N  : byte;
  Long : byte;

Begin
  M := Debut + YCurseur - 1;
  if M > HautFnt then dec(M,HautFnt);
  Long := length(Texte^.LTxt[M]);
  if Long = XFichier then exit
  else
    if Long > XFichier then VaPlusLoin(Long)
                       else VaMoinsLoin(Long);
End;

{}

Procedure VaPgBas;

Var
  M,N : byte;

Begin
  if DerCar = NbDeCar then exit
  else
  Begin
    StockeTexte(DerCar);
    YFichier := YFichier + HautFnt;
    if DerLig <> 0 then
    Begin
      if DerLig < Debut then M := DerLig + HautFnt - Debut + 1
                        else M := DerLig - Debut + 1;
      if YCurseur > M then
      Begin
        N := YCurseur - M;
        dec(YFichier,N);
        YCurseur := M;
      End;
    End;
    AfficheTexte(ColTexte);
  End;
End;

{}

Procedure RemontePage;

Var
  NbLigne : byte;
  NumCar  : longint;
  LeCar   : char;

Begin
  NbLigne := 0;
  NumCar  := PremCar;
  repeat
    dec(NumCar);
    LeCar := LectureCar(NumCar);
    if ord(LeCar) = 10 then inc(NbLigne);
  until (NbLigne = (HautFnt + 1)) or (NumCar = 1);
  if NumCar = 1 then dec(NumCar)
                else dec(NbLigne);
  StockeTexte(NumCar);
  YFichier := YFichier - NbLigne;
  AfficheTexte(ColTexte);
End;

{}

Procedure VaPgHaut;

Begin
  if YFichier = 1 then exit
  else
  Begin
    if PremCar = 1 then
    Begin
      YFichier := YFichier - YCurseur + 1;
      YCurseur := 1;
      AffichePosition;
    End
    else RemontePage;
  End;
End;

{}

Procedure VaDebutFnt;

Begin
  if YCurseur = 1 then exit
  else
  Begin
    YFichier := YFichier - YCurseur + 1;
    YCurseur := 1;
    AffichePosition;
  End;
End;

{}

Procedure VaFinFnt;

Var
  M :byte;

Begin
  if YCurseur = HautFnt then exit
  else
  Begin
    if DerLig = 0 then
    Begin
      YFichier := YFichier + HautFnt - YCurseur;
      YCurseur := HautFnt;
    End
    else
    Begin
      if DerLig < Debut then M := DerLig + HautFnt - Debut + 1
                        else M := DerLig - Debut + 1;
      YFichier := YFichier + M - YCurseur;
      YCurseur := M;
    End;
    AffichePosition;
  End;
End;

{}

Procedure RechFinFic;

Var
  NumCar   : longint;
  LeCar    : char;
  LigneTmp : string;
  NbLigne  : byte;
  Long     : byte;

Begin
  NbLigne := HautFnt;
  DerCar := NbDeCar;
  DerLig := HautFnt;
  NumCar := NbDeCar;
  repeat
    LigneTmp := LectureCar(NumCar);
    repeat
      dec(NumCar);
      LeCar := LectureCar(NumCar);
      LigneTmp := LeCar + LigneTmp;
    until (ord(LeCar) = 10) or (NumCar  = 1);
    if ord(LeCar) = 10 then delete(LigneTmp,1,1);
    with Texte^ do LTxt[NbLigne] := LigneTmp;
    dec(NbLigne);
  until NbLigne = 0;
  if ord(LeCar) = 10 then inc(NumCar);
  PremCar := NumCar;
  Long := length(Texte^.LTxt[DerLig]);
  if Long < LargFnt then
  Begin
    ColTexte := 1;
    XCurseur := Long;
  End
  else
  Begin
    ColTexte := Long - LargFnt + 1;
    XCurseur := LargFnt;
  End;
  YCurseur := HautFnt;
  XFichier := Long;
  YFichier := NbDeLigne;
  AfficheTexte(ColTexte);
End;

{}

Procedure VaDansFnt;

Var
  EcartX,EcartY  : byte;
  LFin : byte;
  Long : byte;

Begin
    if DerLig < Debut then LFin := DerLig + HautFnt
                      else LFin := DerLig;
    EcartY := LFin - (Debut + YCurseur - 1);
    inc(YCurseur,EcartY);
    inc(YFichier,EcartY);
    Long := length(Texte^.LTxt[DerLig]);

    EcartX := Long - XFichier;
    if EcartX <= (LargFnt - XCurseur) then
    Begin
      inc(XCurseur,EcartX);
      XFichier := Long;
      AffichePosition;
    End
    else
    Begin
      ColTexte := Long - LargFnt + 1;
      XCurseur := LargFnt;
      XFichier := Long;
      AfficheTexte(ColTexte);
    End;
End;

{}

Procedure VaFinFic;

Var
  M,N : byte;
  Delta : byte;

Begin
  M := Debut + YCurseur - 1;
  if M > HautFnt then dec(M,HautFnt);
  N := length(Texte^.LTxt[M]);
  if (M = DerLig) and (N = XFichier) then exit
  else
    if DerLig = 0 then RechFinFic
                  else VaDansFnt;
End;

{}

Procedure VaDebutFic;

Begin
  if (XFichier = 1) and (YFichier = 1) then exit
  else
  Begin
    XCurseur := 1;
    YCurseur := 1;
    XFichier := 1;
    YFichier := 1;
    if (PremCar = 1) and (ColTexte = 1) then AffichePosition
    else
    Begin
      ColTexte := 1;
      StockeTexte(0);
      AfficheTexte(ColTexte);
    End;
  End;
End;

{}

Procedure ChangeAffichage;

Begin
  AffiStandard := not AffiStandard;
  AfficheTexte(ColTexte);
End;

{}

Procedure InfoPosition;

Var
  DlgInfo : DialogRecTx;
  S       : TypeSauveTx;

Begin
  with DlgInfo do
  Begin
    X     := 56;
    Y     := 4;
    Larg  := 23;
    Haut  := 19;
    Tip   := Cadre2;
    Coul  := CoulBtAPropos;
    Titre := ' Information ';
  End;
  SauvegardeTx(S);
  CacheSouris;
  CacheCurseurTx;
  OuvreDialogTx(DlgInfo);
  with DlgInfo do
  Begin
    CoulFondTx(Coul.Fond);
    CoulEncreTx(Coul.Encre);
    gotoxy(X + 2,Y + 2);
    write('PremCar    :',PremCar);
    gotoxy(X + 2,Y + 3);
    write('DerCar     :',DerCar);
    gotoxy(X + 2,Y + 5);
    write('Debut      :',Debut);
    gotoxy(X + 2,Y + 6);
    write('DerLig     :',DerLig);
    gotoxy(X + 2,Y + 8);
    write('XCurseur   :',XCurseur);
    gotoxy(X + 2,Y + 9);
    write('YCurseur   :',YCurseur);
    gotoxy(X + 2,Y + 11);
    write('NbDeCar    :',NbDeCar);
    gotoxy(X + 2,Y + 12);
    write('NbDeLigne  :',NbDeLigne);
    gotoxy(X + 2,Y + 14);
    write('NbMaxDeCar :',NbMaxDeCar);
  End;
  readkey;
  FermeDialogTx(DlgInfo);
  RestaureTx(S);
End;

{}

Procedure GereFenetre;

Var
  LeCar      : char;
  InfoSouris : PosRec;
  XTmp,YTmp  : byte;

Begin
  repeat
    if AttendActionTx(LeCar,InfoSouris) then
      if InfoSouris.Bouton = BoutonGauche then
      Begin
        with InfoSouris do PosSourisPosTx(Colonne,Ligne,XTmp,YTmp);
        with Dialog do
          if (XTmp = X + 3) and (YTmp = Y) then LeCar := CarEsc;
      End;
      if ToucheFct then
        case LeCar of
          ShiftF1 : BoiteAProposTx;
          AltF3   : LeCar := CarEsc;
          F8      : ChangeAffichage;
          AltF10  : InfoPosition;
        end;
      case LeCar of
        FlchBas    : VaBas; { Descend 1 ligne }
        FlchHaut   : VaHaut; { Monte 1 ligne }
        FlchDroite : VaDroite; { Va 1 car a droite }
        FlchGauche : VaGauche; { Va 1 car a gauche }
        FlchDebut  : VaDebutLig; { Va au debut de la ligne }
        FlchFin    : VaFinLig; { Va en fin de ligne }
        FlchPgBas  : VaPgBas; { Descend 1 fenetre }
        FlchPgHaut : VaPgHaut; { Monte 1 fenetre }
        CtrlDebut  : VaDebutFnt; { Va a la 1ere ligne de la fenetre }
        CtrlFin    : VaFinFnt; { Va a la derniere ligne de la fenetre }
        CtrlPgBas  : VaFinFic; { Va au dernier caractere }
        CtrlPgHaut : VaDebutFic; { Va au 1er caractere }
      end;
  until LeCar in [AltX,CarEsc];
  if LeCar = AltX then Sortie := true;
End;

{}

Procedure Visualise;

Var
  UneAlarme : AlarmeRec;

Begin
  if MemAvail > sizeof(Texte) then
  Begin
    InitFenetre;
    AfficheFenetre;
    StockeTexte(PremCar);
    AfficheTexte(ColTexte);
    MontreCurseurTx;
    GereFenetre;
    CacheCurseurTx;
    LibereFenetre;
  End
  else
  Begin
    UneAlarme[1] := ' ' + Msg[88]^ + ' ';
    UneAlarme[2] := '';
    UneAlarme[3] := '';
    UneAlarme[4] := '';
    AlarmeTx(0,UneAlarme);
    DeSelectFilsMenuTx(Menu,MnuFichier,FctVoir);
  End;
End;

{}

Begin

End.