{

                            RS232   Version 3.0

                         Creation Alain JAFFRE 1996

  ͸
                 Programme ecrit pour TURBO PASCAL 7.0                    
                                                                          
                             Alain JAFFRE                                 
  ;

}
Unit RSGlob;

{$I RSComp.Pas}

INTERFACE

Uses Crt,AJCOUL,AJGLOB,AJSOURIS,AJGENTX,AJFTRTX,AJMENUTX;

{}

Const
  MaxCarListe = 65535;  { nombre maximum de caracteres dans une liste }
  NbListe     = 3;      { nombre de liste }
  NbMaxDeCar  = NbListe * MaxCarListe; { nombre maximum de caracteres }

{}

Type
  ListePtr = ^Noeud;
  Noeud = record
            Data : array [1..MaxCarListe] of char;
          end;

  PortSerie = record
                Adresse : word;
                Irq     : byte;
              end;

  ConfigRs = record
               Nom          : Str20;
               Com          : byte; {1:Com1,2:Com2,3:Com3,4:Com4}
               Vitesse      : byte; {1:110,2:150,3:300,4:600,5:1200,6:2400,
                            7:4800,8:9600,9:19200,10:38400,11:57600,12:115200}
               Parite       : byte; {1:paire,2:impaire,3:sans}
               BitDonnee    : byte; {1:7 bits,2:8 bits}
               BitStop      : byte; {1:1 bits,2:2 bits}
               Protocole    : byte; {1:sans,2:Cts/Rts,3:Xon/Xoff}
               NbLigSupp    : byte;
               CarRecherche : Str4;
               CarSupp      : Str40;
               Codage       : byte; {1:ASCII,2:ISO,3:EIA}
               DelaiCar     : word; {delai entre caracteres}
               DelaiLigne   : word; {delai entre lignes}
               AdrFic       : NomRep;
               FicType      : NomFic;
               Serie        : array [1..4] of PortSerie;
             end;

{}

Var
  Msg : MsgRec; { Liste contenant tous les messages }

  Menu     : BarreMenuTxPtr; { Barre du menu }
  AideMenu : Str80;          { Aide du menu }

  MnuAPropos,MnuFichier,MnuEmission,MnuReception,MnuConfiguration : byte;
  FctOuvrir,FctSauver,FctSauverSous,FctVoir,FctImprimer,FctQuitter : byte;
  CfgLiaison,CfgDonnees,CfgFichier,CfgMateriel,OuvreCfg,SauverCfg,
    SauverSousCfg,ParDefautCfg,SupprimerCfg : byte;
  FctAPropos,FctCableStd,FctCableCtsRts : byte;

  LePere,LeFils : byte; { Pere et fils selectionnes du menu }

  FichierOuvert : NomRep;  { Nom du fichier texte ouvert }
  Fichier       : text;    { Fichier  crire ou  lire }
  Buffer        : array [1..5119] of char; { Buffer tampon de 5 Ko }
  UnFichier     : NomRep;   { Nom temporaire de saisie d'un fichier }


  Liste : array [1..NbListe] of ListePtr; { Listes pour le stockage des car.}
  ListeActuelle : byte; { Liste actuellement utilise }
  NbDeCar   : longint; { Nombre de caracteres en memoire }
  NbDeLigne : longint; { Nombre de lignes en memoire }

  AffiStandard   : boolean; { Affichage standard ou etendu (car. speciaux) ? }

  ConfigActuelle : ConfigRs;
  NomFicConfig   : Nomrep;

{}
Procedure InitListes;

{ Initialise les listes de stockage des caracteres                           }
(**)
Procedure VideListes;

{ Vide les listes de stockage des caracteres en les remettant a zero (#255)  }
(**)
Function StockeCar(CeCar : char) : boolean;

{ Stocke le caractere 'CeCar' dans une liste en mmoire                      }
{ Renvoi false si le nombre maxi de caracteres est atteind, true autrement   }
(**)
Function LectureCar(Numero : longint) : char;

{ Lit le caractere 'Numero' dans une liste en mmoire                        }
(**)
Function OuvreFichier : NomRep;

{ Boite de selection du fichier  ouvrir. Retourne le nom complet ou ''      }
(**)
Function SauveFichier : NomRep;

{ Boite de selection du nom de fichier pour l'enregistrement                 }
(**)
Procedure LitFichier(LeFichier : Str80);

{ Lit le fichier 'FichierOuvert' et le stocke dans les listes en mmoire     }
(**)
Procedure EcritFichier(LeFichier : Str80);

{ Ecrit les listes en mmoire dans le fichier 'FichierOuvert'                }
(**)
Procedure ChangeConfigDsMenu;

{ Change le nom de la configuration apparaissant dans la barre de menu       }
(**)
Procedure CablageStandard;

{ Affiche le cablage standard                                                }
(**)
Procedure CablageCtsRts;

{ Affiche le cablage Cts/Rts                                                 }
(**)
Procedure FinProgramme;

{ Termine le programme et remet tout a zro                                  }
(**)

IMPLEMENTATION

{}

Procedure InitLaListe(Var LaListe : ListePtr);

Begin
  if MemAvail > sizeof(LaListe) then
  Begin
    new(LaListe);
  End
  else
  Begin
    PlusDeMemoireTx;
    Halt(1);
  End;
End;

{}

Procedure RazLaListe(Var LaListe : ListePtr);

Var
  Num : word;

Begin
  with LaListe^ do
    for Num := 1 to MaxCarListe do Data[Num] := #255;
End;

{}

Procedure InitListes;

Var
  N : byte;

Begin
  for N := 1 to NbListe do
  Begin
    InitLaListe(Liste[N]);
    RazLaListe(Liste[N]);
  End;
End;

{}

Procedure LibereListes;

Var
  N : byte;

Begin
  for N := 1 to NbListe do dispose(Liste[N]);
End;

{}

Procedure VideListes;

Var
  NumEnCours   : longint;
  NumDeLaListe : word;
  ListeEnCours : byte;

Begin
  NumEnCours := 1;
  NumDeLaListe := 1;
  ListeEnCours := 1;
  while NumEnCours <= NbDeCar do
  Begin
    Liste[ListeEnCours]^.Data[NumDeLaListe] := #255;
    inc(NumEnCours);
    if NumEnCours > MaxCarListe then
    Begin
      NumDeLaListe := 1;
      inc(ListeEnCours);
    End
    else inc(NumDeLaListe);
  End;
  NbDeCar := 0;
  NbDeLigne := 0;
  ListeActuelle := 1;
  FichierOuvert := '';
  DeSelectFilsMenuTx(Menu,MnuFichier,FctSauver);
  DeSelectFilsMenuTx(Menu,MnuFichier,FctSauverSous);
  DeSelectFilsMenuTx(Menu,MnuFichier,FctVoir);
  DeSelectFilsMenuTx(Menu,MnuFichier,FctImprimer);
End;

{}

Function StockeCar(CeCar : char) : boolean;

Var
  N : word;

Begin
  if NbDeCar = NbMaxDeCar then StockeCar := false
  else
  Begin
    StockeCar := true;
    inc(NbDeCar);
    if NbDeCar <> 1 then
    Begin
      N := ((NbDeCar - 1) mod MaxCarListe);
      if N =0 then inc(ListeActuelle);
    End
    else N := 0;
    Liste[ListeActuelle]^.Data[N+1] := CeCar;
    if (ord(CeCar) = 10) then inc(NbDeLigne);
  End;
End;

{}

Function LectureCar(Numero : longint) : char;

Var
  N        : word;
  NumListe : byte;

Begin
  N := Numero mod MaxCarListe;
  NumListe := ((Numero - 1) div MaxCarListe) + 1;
  LectureCar := Liste[NumListe]^.Data[N];
End;

{}

Function OuvreFichier : NomRep;

Var
  Dialogue : DialogRecTx;
  Boite    : BteEsFichierTxPtr;
  Car : char;
  UneAlarme : AlarmeRec;
  tmp : longint;

Begin
  with Dialogue do
  Begin
    X := 0;
    Y := 0;
    Tip := Ombre2;
    Titre := Msg[69]^;
  End;
  InitBteEsFichierTx(Boite,Msg[66]^,Msg[67]^,Msg[68]^,Msg[89]^,
                                                         Msg[64]^,Msg[65]^);
  with ConfigActuelle do RepBteEsFichierTx(Boite,AdrFic,FicType);
  Car := BoiteEsFichierTx(Dialogue,Boite,true);
  if Car = CarReturn then
  Begin
    with Boite^ do OuvreFichier := Repertoire + Masque;
    if TailleFic(Boite^.Repertoire + Boite^.Masque) >= NbMaxDeCar then
    Begin
      UneAlarme[1] := Boite^.Repertoire + Boite^.Masque;
      UneAlarme[2] := ' ';
      UneAlarme[3] := Msg[72]^;
      UneAlarme[4] := ' ';
      AlarmeTx(0,UneAlarme);
      OuvreFichier := '';
    End;
  End
  else OuvreFichier := '';
  LibereBteEsFichierTx(Boite);
End;

{}

Function SauveFichier : NomRep;

Var
  Dialogue : DialogRecTx;
  Boite    : BteEsFichierTxPtr;
  Car : char;
  UneAlarme : AlarmeRec;
  tmp : longint;

Begin
  with Dialogue do
  Begin
    X := 0;
    Y := 0;
    Tip := Ombre2;
    Titre := Msg[90]^;
  End;
  InitBteEsFichierTx(Boite,Msg[66]^,Msg[67]^,Msg[68]^,Msg[89]^,
                                                         Msg[64]^,Msg[65]^);
  with ConfigActuelle do RepBteEsFichierTx(Boite,AdrFic,FicType);
  Car := BoiteEsFichierTx(Dialogue,Boite,false);
  if Car = CarReturn then
  Begin
    with Boite^ do SauveFichier := Repertoire + Masque;
  End
  else SauveFichier := '';
  LibereBteEsFichierTx(Boite);
End;

{}

Procedure LitFichier(LeFichier : Str80);

Var
  S           : TypeSauveTx;
  UnCar       : char;
  Erreur      : boolean;
  Dialogue    : DialogRecTx;
  Barregraphe : BarreGrapheRecTx;
  Compte      : longint;
  NomTmp      : Str80;

Begin
  SauvegardeTx(S);
  CacheCurseurTx;
  CacheSouris;
  if NbDeCar <> 0 then VideListes;
  with Dialogue do
  Begin
    X     := 0;
    Y     := 0;
    Larg  := 40;
    Tip   := Ombre2;
    Titre := ' ' + Msg[70]^ + ' ' + LeFichier + ' ';
    if length(Titre) > 60 then
    Begin
      Compte := length(Titre) - 60;
      NomTmp := LeFichier;
      delete(NomTmp,1,Compte);
      Titre := ' ' + Msg[70]^ + ' ' + NomTmp + ' ';
    End;
    Coul  := CoulBarreGraphe;
  End;
  Barregraphe.Maxi := TailleFic(LeFichier);
  Compte := 0;
  BoiteBarreGrapheTx(Dialogue,Barregraphe,Compte,Ouvrir);
  assign(Fichier,LeFichier);
  settextbuf(Fichier,Buffer);
  reset(Fichier);
  Erreur := false;
  while (not (Compte = Barregraphe.Maxi) or Erreur) do
  Begin
    read(Fichier,UnCar);
    Erreur := not StockeCar(UnCar);
    inc(Compte);
    if (Compte mod 100) = 0 then
      BoiteBarreGrapheTx(Dialogue,Barregraphe,Compte,Utiliser);
  End;
  if ord(UnCar) <> 10 then inc(NbDeLigne);
  BoiteBarreGrapheTx(Dialogue,Barregraphe,Compte,Utiliser);
  close(Fichier);
  BoiteBarreGrapheTx(Dialogue,Barregraphe,Compte,Fermer);
  RestaureTx(S);
  Bip;
  FichierOuvert := LeFichier;
  SelectFilsMenuTx(Menu,MnuFichier,FctSauver);
  SelectFilsMenuTx(Menu,MnuFichier,FctSauverSous);
  SelectFilsMenuTx(Menu,MnuFichier,FctVoir);
  SelectFilsMenuTx(Menu,MnuFichier,FctImprimer);
End;

{}

Procedure EcritFichier(LeFichier : Str80);

Var
  S             : TypeSauveTx;
  Erreur        : boolean;
  Dialogue      : DialogRecTx;
  Barregraphe   : BarreGrapheRecTx;
  Compte        : longint;
  NomTmp        : Str80;
  NomFichierBak : Str80;
  FichierBak    : text;

Begin
  SauvegardeTx(S);
  CacheCurseurTx;
  CacheSouris;
  with Dialogue do
  Begin
    X     := 0;
    Y     := 0;
    Larg  := 40;
    Tip   := Ombre2;
    Titre := ' ' + Msg[71]^ + ' ' + LeFichier + ' ';
    if length(Titre) > 60 then
    Begin
      Compte := length(Titre) - 60;
      NomTmp := LeFichier;
      delete(NomTmp,1,Compte);
      Titre := ' ' + Msg[71]^ + ' ' + NomTmp + ' ';
    End;
    Coul  := CoulBarreGraphe;
  End;
  Barregraphe.Maxi := NbDeCar;
  Compte := 0;
  BoiteBarreGrapheTx(Dialogue,Barregraphe,Compte,Ouvrir);
  NomFichierBak := ChangeExtension(LeFichier,'.BAK');
  if FicExiste(NomFichierBak) then
  Begin
    assign(FichierBak,NomFichierBak);
    erase(FichierBak);
  End;
  if FicExiste(LeFichier) then
  Begin
    assign(Fichier,LeFichier);
    rename(Fichier,NomFichierBak);
  End;
  assign(Fichier,LeFichier);
  settextbuf(Fichier,Buffer);
  rewrite(Fichier);
  for Compte := 1 to NbDeCar do
  Begin
    write(Fichier,LectureCar(Compte));
    if (Compte mod 100) = 0 then
      BoiteBarreGrapheTx(Dialogue,Barregraphe,Compte,Utiliser);
  End;
  BoiteBarreGrapheTx(Dialogue,Barregraphe,Compte,Utiliser);
  close(Fichier);
  BoiteBarreGrapheTx(Dialogue,Barregraphe,Compte,Fermer);
  RestaureTx(S);
  Bip;
End;

{}

Procedure ChangeConfigDsMenu;

Var
  Tmp : Str20;

Begin
  Tmp := ElargiADte(ConfigActuelle.Nom,20);
  CoulFondTx(CoulCarMenu.Fond);
  CoulEncreTx(CoulCarMenu.Encre);
  gotoxy(60,1);
  write(Tmp);
End;

{}

Procedure CablageStandard;

Var
  Dlg       : DialogRecTx;
  S         : TypeSauveTx;
  Texte     : Str80;
  LeBouton  : BoutonTxPtr;
  LeCar     : char;
  InfoSouris: PosRec;
  Ok        : boolean;

Begin
  SauvegardeTx(S);
  CacheSouris;
  with Dlg Do
  Begin
    Tip   := Ombre2;
    Coul  := CoulBtSaisie;
    Titre := '';
  End;
  CentreDialogTx(40,17,Dlg);
  InitBoutonTx(LeBouton,Msg[64]^,37,19,6,true,true);
  OuvreDialogTx(Dlg);
  CoulFondTx(CoulBtAPropos.Fond);
  CoulEncreTx(CoulBtAPropos.Encre);
  Texte := Msg[31]^;
  delete(Texte,pos('&',Texte),1);
  CentreTexteTx( 4,Texte);
  Texte := '                                ';
  delete(Texte,1,(2 * length(Msg[150]^) + 2));
  Texte := ' ' + Msg[150]^ + Texte + Msg[150]^ + ' ';
  CentreTexteTx( 6,Texte);
  CentreTexteTx( 7,'  9  25                25  9  ');
  CentreTexteTx( 8,'  ');
  CentreTexteTx( 9,'      1               1     ');
  CentreTexteTx(10,'  3   2   3  2  ');
  CentreTexteTx(11,'  2   3   2  3  ');
  CentreTexteTx(12,'  7   4 Ŀ            5  8  ');
  CentreTexteTx(13,'  8   5             4  7  ');
  CentreTexteTx(14,'  6   6 Ŀ           20  4  ');
  CentreTexteTx(15,'  1   8 Ĵ            8  1  ');
  CentreTexteTx(16,'  4  20             6  6  ');
  CentreTexteTx(17,'  5   7   7  5  ');
  AfficheBoutonTx(LeBouton);
  MontreSouris;
  repeat
    AttendActionTx(LeCar,InfoSouris);
    Ok := LeCar = CarReturn;
    Ok := Ok or ToucheDuBoutonTx(LeBouton,LeCar);
    Ok := Ok or SourisDsBoutonTx(LeBouton,InfoSouris);
  until Ok;
  CacheSouris;
  FermeDialogTx(Dlg);
  LibereBoutonTx(LeBouton);
  RestaureTx(S);
End;

{}

Procedure CablageCtsRts;

Var
  Dlg       : DialogRecTx;
  S         : TypeSauveTx;
  Texte     : Str80;
  LeBouton  : BoutonTxPtr;
  LeCar     : char;
  InfoSouris: PosRec;
  Ok        : boolean;

Begin
  SauvegardeTx(S);
  CacheSouris;
  with Dlg Do
  Begin
    Tip   := Ombre2;
    Coul  := CoulBtSaisie;
    Titre := '';
  End;
  CentreDialogTx(40,17,Dlg);
  InitBoutonTx(LeBouton,Msg[64]^,37,19,6,true,true);
  OuvreDialogTx(Dlg);
  CoulFondTx(CoulBtAPropos.Fond);
  CoulEncreTx(CoulBtAPropos.Encre);
  Texte := Msg[32]^;
  delete(Texte,pos('&',Texte),1);
  CentreTexteTx( 4,Texte);
  Texte := '                                ';
  delete(Texte,1,(2 * length(Msg[150]^) + 2));
  Texte := ' ' + Msg[150]^ + Texte + Msg[150]^ + ' ';
  CentreTexteTx( 6,Texte);
  CentreTexteTx( 7,'  9  25                25  9  ');
  CentreTexteTx( 8,'  ');
  CentreTexteTx( 9,'      1               1     ');
  CentreTexteTx(10,'  3   2   3  2  ');
  CentreTexteTx(11,'  2   3   2  3  ');
  CentreTexteTx(12,'  7   4   5  8  ');
  CentreTexteTx(13,'  8   5   4  7  ');
  CentreTexteTx(14,'  6   6  20  4  ');
  CentreTexteTx(15,'  1   8               8  1  ');
  CentreTexteTx(16,'  4  20   6  6  ');
  CentreTexteTx(17,'  5   7   7  5  ');
  AfficheBoutonTx(LeBouton);
  MontreSouris;
  repeat
    AttendActionTx(LeCar,InfoSouris);
    Ok := LeCar = CarReturn;
    Ok := Ok or ToucheDuBoutonTx(LeBouton,LeCar);
    Ok := Ok or SourisDsBoutonTx(LeBouton,InfoSouris);
  until Ok;
  CacheSouris;
  FermeDialogTx(Dlg);
  LibereBoutonTx(LeBouton);
  RestaureTx(S);
End;

{}

Procedure FinProgramme;

Begin
  EffaceMsg(Msg);
  LibereListes;
  CoulFondTx(Noir);
  CoulEncreTx(GrisClair);
  CacheSouris;
  MontreCurseurTx;
  Clrscr;
End;

{}

Begin

End.