{

                            RS232   Version 3.0

                         Creation Alain JAFFRE 1996

  ͸
                 Programme ecrit pour TURBO PASCAL 7.0                    
                                                                          
                             Alain JAFFRE                                 
  ;

}
Unit RSEmRe;

{$I RSComp.Pas}

INTERFACE

Uses Crt,AJCOUL,AJGLOB,AJSOURIS,AJGENTX,AJFTRTX,AJMENUTX,AJRS232,RSGlob;

{}

Procedure Emission;

{ Emission des caracteres stockes en memoire                                 }
(**)

Procedure Reception;

{ Reception et stockage des caracteres                                       }
(**)

IMPLEMENTATION

{}

Const

  Vit : array [1..12] of longint
      = (110,150,300,600,1200,2400,4800,9600,19200,38400,57600,115200);
  Par : array [1..3] of char = ('E','O','N');
  Bit : array [1..2] of byte = (7,8);
  Pro : array [1..3] of boolean = (false,true,false);
  Vide : Str80 = '                                       ' +
                 '                                       ';

{}

Function EnvoiXON : boolean;

Begin
  with ConfigActuelle do
    EnvoiXON := WriteCom(Com,17) = 0;
End;

{}

Function EnvoiXOFF : boolean;

Begin
  with ConfigActuelle do
    EnvoiXOFF := WriteCom(Com,19) = 0;
End;

{}

Function XONRecu : boolean;

Var
  Valeur : byte;

Begin
  with ConfigActuelle do
    if ReadCom(Com,Valeur)= 0 then XONRecu := (Valeur = 17)
                              else XONRecu := false;
End;

{}

Function XOFFRecu : boolean;

Var
  Valeur : byte;
  Recu   : boolean;

Begin
  with ConfigActuelle do
  Begin
    Recu := false;
    if ReadCom(Com,Valeur) = 0 then Recu := (Valeur = 19);
  End;
  if Recu then CentreTexteTx(13,Msg[102]^);
  XOFFRecu := Recu;
End;

{}

Function AttendXON : boolean;

Var
  LeCar : char;

Begin
  CentreTexteTx(14,Msg[103]^);
  LeCar := ' ';
  repeat
    if keypressed then LeCar := readkey;
  until XONRecu or (LeCar = CarEsc);
  AttendXON := (LeCar <> CarESC);
  CentreTexteTx(13,copy(Vide,1,length(Msg[102]^)));
  CentreTexteTx(14,copy(Vide,1,length(Msg[103]^)));
End;

{}

Function CodeEIA(CeCar : char) : byte;

Var
  CeCode : byte;

Begin
  case CeCar of
    '0' : CeCode := 32 ;
    '1' : CeCode := 1;
    '2' : CeCode := 2;
    '3' : CeCode := 19;
    '4' : CeCode := 4;
    '5' : CeCode := 21;
    '6' : CeCode := 22;
    '7' : CeCode := 7;
    '8' : CeCode := 8;
    '9' : CeCode := 25;
    'A' : CeCode := 97;
    'B' : CeCode := 98;
    'C' : CeCode := 115;
    'D' : CeCode := 100;
    'E' : CeCode := 117;
    'F' : CeCode := 118;
    'G' : CeCode := 103;
    'H' : CeCode := 104;
    'I' : CeCode := 121;
    'J' : CeCode := 81;
    'K' : CeCode := 82;
    'L' : CeCode := 67;
    'M' : CeCode := 84;
    'N' : CeCode := 69;
    'O' : CeCode := 70;
    'P' : CeCode := 87;
    'Q' : CeCode := 88;
    'R' : CeCode := 73;
    'S' : CeCode := 50;
    'T' : CeCode := 35;
    'U' : CeCode := 52;
    'V' : CeCode := 37;
    'W' : CeCode := 38;
    'X' : CeCode := 55;
    'Y' : CeCode := 56;
    'Z' : CeCode := 41;
    '' : CeCode := 127;
    #0  : CeCode := 0;
    #8  : CeCode := 42;
    #9  : CeCode := 62;
    #13 : CeCode := 128;
    ' ' : CeCode := 16;
    '%' : CeCode := 11;
    '(' : CeCode := 26;
    ')' : CeCode := 74;
    '+' : CeCode := 112;
    '-' : CeCode := 64;
    '/' : CeCode := 49;
    '.' : CeCode := 107;
    '&' : CeCode := 14;
    ',' : CeCode := 59;
  else CeCode := ord(CeCar);
  end;
  CodeEIA := CeCode;
End;

{}

Function DeCodeEIA(CeCode : byte) : char;

Var
  CeCar : char;

Begin
  case CeCode of
    0  : CeCar := #0;
    1  : CeCar := '1';
    2  : CeCar := '2';
    4  : CeCar := '4';
    7  : CeCar := '7';
    8  : CeCar := '8';
    11 : CeCar := '%';
    14 : CeCar := '&';
    16 : CeCar := ' ';
    19 : CeCar := '3';
    21 : CeCar := '5';
    22 : CeCar := '6';
    25 : CeCar := '9';
    26 : CeCar := '(';
    32 : CeCar := '0';
    35 : CeCar := 'T';
    37 : CeCar := 'V';
    38 : CeCar := 'W';
    41 : CeCar := 'Z';
    42 : CeCar := #8;
    49 : CeCar := '/';
    50 : CeCar := 'S';
    52 : CeCar := 'U';
    55 : CeCar := 'X';
    56 : CeCar := 'Y';
    59 : CeCar := ',';
    62 : CeCar := #9;
    64 : CeCar := '-';
    67 : CeCar := 'L';
    69 : CeCar := 'N';
    70 : CeCar := 'O';
    73 : CeCar := 'R';
    74 : CeCar := ')';
    81 : CeCar := 'J';
    82 : CeCar := 'K';
    84 : CeCar := 'M';
    87 : CeCar := 'P';
    88 : CeCar := 'Q';
    97 : CeCar := 'A';
    98 : CeCar := 'B';
    100: CeCar := 'D';
    103: CeCar := 'G';
    104: CeCar := 'H';
    107: CeCar := '.';
    112: CeCar := '+';
    115: CeCar := 'C';
    117: CeCar := 'E';
    118: CeCar := 'F';
    121: CeCar := 'I';
    127: CeCar := '';
    128: CeCar := #13;
  else CeCar := chr(CeCode);
  end;
  DecodeEIA := CeCar;
End;

{}

Procedure Emission_ASCII(PremierCar : longint);

Var
  NumCar    : longint;
  LeCar     : char;
  AideLigne : string;
  Valeur    : byte;
  Dlg       : DialogRecTx;
  S         : TypeSauveTx;
  Execute   : boolean;

Begin
  SauvegardeTx(S);
  CacheSouris;
  with Dlg do
  Begin
    Tip   := Ombre2;
    Coul  := CoulBtSaisie;
    Titre := '';
  End;
  CentreDialogTx(length(Msg[101]^) + 4,4,Dlg);
  OuvreDialogTx(Dlg);
  CoulFondTx(CoulBtSaisie.Fond);
  CoulEncreTx(CoulBtSaisie.Encre);
  CentreTexteTx(11,Msg[101]^);

  with ConfigActuelle do
  Begin
    if OuvreCom(Com,Vit[Vitesse],Par[Parite],Bit[BitDonnee],BitStop,
                                              Pro[Protocole],4096) = 0 then
    Begin
      NumCar := PremierCar;
      LeCar  := ' ';
      AideLigne := LigneAide.Texte;
      LigneAide.Texte := ' ' + Msg[99]^;
      AfficheLigneAideTx(true);
      Execute := true;
      if Protocole = 3 then Execute := AttendXON;

      if Execute then
      repeat
        Valeur := ord(LectureCar(NumCar));
        if WriteCom(Com,Valeur) = 0 then
        Begin
          EcritXYTx(37,12,' ' + IntToStr(NumCar) + ' ',true);
          if DelaiCar <> 0 then delay(DelaiCar);
          if (Valeur = 10) and (DelaiLigne <> 0) then delay(DelaiLigne);
          inc(NumCar);
        End;
        if (Protocole = 3) and XOFFRecu then
           if not AttendXON then LeCar := CarEsc;
        if keypressed then LeCar := readkey;
      until (NumCar > NbDeCar) or (LeCar = CarEsc);
      if (Protocole = 3) and (LeCar = CarEsc) then
        repeat until EnvoiXOFF;

      FermeCom(Com);
      LigneAide.Texte := AideLigne;
      AfficheLigneAideTx(true);
      Beep;
    End;
  End;

  FermeDialogTx(Dlg);
  RestaureTx(S);
End;

{}

Procedure Reception_ASCII;

Var
  NumCar    : longint;
  LeCar     : char;
  AideLigne : string;
  Valeur    : byte;
  Dlg       : DialogRecTx;
  S         : TypeSauveTx;

Begin
  SauvegardeTx(S);
  CacheSouris;
  with Dlg do
  Begin
    Tip   := Ombre2;
    Coul  := CoulBtSaisie;
    Titre := '';
  End;
  CentreDialogTx(length(Msg[101]^) + 4,4,Dlg);
  OuvreDialogTx(Dlg);
  CoulFondTx(CoulBtSaisie.Fond);
  CoulEncreTx(CoulBtSaisie.Encre);
  CentreTexteTx(11,Msg[100]^);

  if NbDeCar <> 0 then VideListes;
  with ConfigActuelle do
  Begin
    if OuvreCom(Com,Vit[Vitesse],Par[Parite],Bit[BitDonnee],BitStop,
                                              Pro[Protocole],4096) = 0 then
    Begin
      NumCar := 0;
      LeCar  := ' ';
      AideLigne := LigneAide.Texte;
      LigneAide.Texte := ' ' + Msg[99]^;
      AfficheLigneAideTx(true);
      if Protocole = 3 then repeat until EnvoiXON;
      repeat
        if ReadCom(Com,Valeur) <> 5 then
          if StockeCar(chr(Valeur)) then
          Begin
            inc(NumCar);
            EcritXYTx(37,12,' ' + IntToStr(NumCar) + ' ',true);
          End;
        if keypressed then LeCar := readkey;
      until LeCar = CarEsc;
      FermeCom(Com);
      LigneAide.Texte := AideLigne;
      AfficheLigneAideTx(true);
      Beep;
    End;
  End;

  FermeDialogTx(Dlg);
  RestaureTx(S);
End;

{}

Procedure Emission_ISO(PremierCar : longint);

Begin
  Emission_ASCII(PremierCar);
End;

{}

Procedure Reception_ISO;

Begin
  Reception_ASCII;
End;

{}

Procedure Emission_EIA(PremierCar : longint);

Var
  NumCar    : longint;
  LeCar     : char;
  AideLigne : string;
  Valeur    : byte;
  Dlg       : DialogRecTx;
  S         : TypeSauveTx;
  Execute   : boolean;

Begin
  SauvegardeTx(S);
  CacheSouris;
  with Dlg do
  Begin
    Tip   := Ombre2;
    Coul  := CoulBtSaisie;
    Titre := '';
  End;
  CentreDialogTx(length(Msg[101]^) + 4,4,Dlg);
  OuvreDialogTx(Dlg);
  CoulFondTx(CoulBtSaisie.Fond);
  CoulEncreTx(CoulBtSaisie.Encre);
  CentreTexteTx(11,Msg[101]^);

  with ConfigActuelle do
  Begin
    if OuvreCom(Com,Vit[Vitesse],Par[Parite],Bit[BitDonnee],BitStop,
                                              Pro[Protocole],4096) = 0 then
    Begin
      NumCar := PremierCar;
      LeCar  := ' ';
      AideLigne := LigneAide.Texte;
      LigneAide.Texte := ' ' + Msg[99]^;
      AfficheLigneAideTx(true);
      Execute := true;
      if Protocole = 3 then Execute := AttendXON;

      if Execute then
      repeat
        Valeur := CodeEIA(LectureCar(NumCar));
        if WriteCom(Com,Valeur) = 0 then
        Begin
          EcritXYTx(37,12,' ' + IntToStr(NumCar) + ' ',true);
          if DelaiCar <> 0 then delay(DelaiCar);
          if (Valeur = 10) and (DelaiLigne <> 0) then delay(DelaiLigne);
          inc(NumCar);
        End;
        if (Protocole = 3) and XOFFRecu then
           if not AttendXON then LeCar := CarEsc;
        if keypressed then LeCar := readkey;
      until (NumCar > NbDeCar) or (LeCar = CarEsc);
      if (Protocole = 3) and (LeCar = CarEsc) then
        repeat until EnvoiXOFF;

      FermeCom(Com);
      LigneAide.Texte := AideLigne;
      AfficheLigneAideTx(true);
      Beep;
    End;
  End;

  FermeDialogTx(Dlg);
  RestaureTx(S);
End;

{}

Procedure Reception_EIA;

Var
  NumCar    : longint;
  LeCar     : char;
  AideLigne : string;
  Valeur    : byte;
  Dlg       : DialogRecTx;
  S         : TypeSauveTx;

Begin
  SauvegardeTx(S);
  CacheSouris;
  with Dlg do
  Begin
    Tip   := Ombre2;
    Coul  := CoulBtSaisie;
    Titre := '';
  End;
  CentreDialogTx(length(Msg[101]^) + 4,4,Dlg);
  OuvreDialogTx(Dlg);
  CoulFondTx(CoulBtSaisie.Fond);
  CoulEncreTx(CoulBtSaisie.Encre);
  CentreTexteTx(11,Msg[100]^);

  if NbDeCar <> 0 then VideListes;
  with ConfigActuelle do
  Begin
    if OuvreCom(Com,Vit[Vitesse],Par[Parite],Bit[BitDonnee],BitStop,
                                              Pro[Protocole],4096) = 0 then
    Begin
      NumCar := 0;
      LeCar  := ' ';
      AideLigne := LigneAide.Texte;
      LigneAide.Texte := ' ' + Msg[99]^;
      AfficheLigneAideTx(true);
      if Protocole = 3 then repeat until EnvoiXON;
      repeat
        if ReadCom(Com,Valeur) <> 5 then
          if StockeCar(DecodeEIA(Valeur)) then
          Begin
            inc(NumCar);
            EcritXYTx(37,12,' ' + IntToStr(NumCar) + ' ',true);
          End;
        if keypressed then LeCar := readkey;
      until LeCar = CarEsc;
      FermeCom(Com);
      LigneAide.Texte := AideLigne;
      AfficheLigneAideTx(true);
      Beep;
    End;
  End;

  FermeDialogTx(Dlg);
  RestaureTx(S);
End;

{}

Procedure SauteLigne(Var NumCar : longint);

Var
  NumLigne : longint;

Begin
  with ConfigActuelle do
  Begin
    if NbLigSupp >= NbDeLigne then NumCar := 0
    else
    Begin
      NumLigne := 0;
      repeat
        if ord(LectureCar(NumCar)) = 10 then inc(NumLigne);
        inc(NumCar);
      until NumLigne = NbLigSupp;
      if NumCar > NbDeCar then NumCar := 0;
    End;
  End;
End;

{}

Procedure RechercheCar(Var NumCar : longint);

Var
  CarTmp : char;
  CarRef : char;
  Trouve : boolean;

Begin
  Trouve := false;
  CarRef := ConfigActuelle.CarRecherche[1];
  repeat
    CarTmp := LectureCar(NumCar);
    Trouve := (CarTmp = CarRef);
    if not Trouve then inc(NumCar);
  until (Trouve or (NumCar > NbDeCar));
  if (Trouve and (NumCar > NbDeCar)) then NumCar := 0;
  if not Trouve then NumCar := 0;
End;

{}

Procedure Emission;

Var
 UneAlarme : AlarmeRec;
 NumCar    : longint;

Begin
  UneAlarme[1] := ' ';
  UneAlarme[2] := Msg[98]^;
  UneAlarme[3] := ' ';
  UneAlarme[4] := '';
  if NbDeCar <> 0 then
  Begin
    NumCar := 1;
    if ConfigActuelle.NbLigSupp > 0 then SauteLigne(NumCar);
    if (NumCar<>0) and (ConfigActuelle.CarRecherche<>Msg[74]^) then
                                                         RechercheCar(NumCar);
    if NumCar <> 0 then
      case ConfigActuelle.Codage of
        1 : Emission_ASCII(NumCar);
        2 : Emission_ISO(NumCar);
        3 : Emission_EIA(NumCar);
      end;
  End
  else AlarmeTx(12,UneAlarme);
End;

{}

Procedure Reception;

Begin
  case ConfigActuelle.Codage of
    1 : Reception_ASCII;
    2 : Reception_ISO;
    3 : Reception_EIA;
  end;
  if NbDeCar <> 0 then
  Begin
    SelectFilsMenuTx(Menu,MnuFichier,FctSauverSous);
    SelectFilsMenuTx(Menu,MnuFichier,FctVoir);
    SelectFilsMenuTx(Menu,MnuFichier,FctImprimer);
  End;
End;

{}

Begin

End.