{

                            RS232   Version 3.0

                         Creation Alain JAFFRE 1996

  ͸
                 Programme ecrit pour TURBO PASCAL 7.0                    
                                                                          
                             Alain JAFFRE                                 
  ;

}
Unit RSConfig;

{$I RSComp.Pas}

INTERFACE

Uses Crt,AJCOUL,AJGLOB,AJSOURIS,AJMATH,AJGENTX,AJFTRTX,AJMENUTX,AJRS232,
     RSGlob;

{}

{}

Procedure InitConfig;

{ Initialise la configuration                                                }
(**)
Procedure ChoixLiaison;

{ Choix de la configuration de la liaison                                    }
(**)
Procedure ChoixDonnee;

{ Choix de la configuration des donnees                                      }
(**)
Procedure ChoixFichier;

{ Choix de la configuration des fichiers                                     }
(**)
Procedure ChoixMateriel;

{ Choix de la configuration materielle                                       }
(**)
Procedure LitConfigDefaut;

{ Lit la configuration par defaut                                            }
(**)
Procedure ChangeFichierConfig(LaConfig : Str20;Change : boolean);

{ Ecrit le fichier de configuration en remplacant une entree                 }
(**)
Procedure SauverConfigSous;

{ Ecrit le fichier de configuration apres avoir demande un nom               }
(**)
Procedure OuvreConfig;

{ Ouvre le fichier de configuration puis charge celle selectionnee           }
(**)
Procedure ChangeConfigDefaut;

{ Change la configuration par defaut et la charge                            }
(**)
Procedure SupprimeConfig;

{ Supprime une configuration du fichier de configuration                     }
(**)

IMPLEMENTATION

{}

Var
  Dialog : DialogRecTx;
  Boite  : array [1..6] of BteABoutonTxPtr;
  Bouton : array [1..3] of BoutonTxPtr;
  NbLigSuppTmp : byte;
  CarRechTmp   : Str4;
  CarSuppTmp   : Str40;
  DelaiCarTmp  : word;
  DelaiLigneTmp: word;
  AdrFicTmp    : NomRep;
  FicTypeTmp   : NomFic;
  SerieTmp     : array [1..4] of PortSerie;
  LigneCfg     : array [1..4] of Str80;
  ListeConfig  : ListeRec;
  NbConfig     : byte;
  PosDsChoix   : byte;
  CfgParDefaut : Str20;

{}

Procedure ChangementImpossible;

Var
  Tmp : Str80;

Begin
  Tmp := Msg[82]^;
  if length(Tmp) > 45 then Tmp := copy(Tmp,1,45)
                      else Tmp := Elargi(Tmp,45);
  with Dialog do
  Begin
    CoulEncreTx(CoulBtSaisie.Encre);
    CoulFondTx(CoulBtSaisie.Fond);
    gotoxy(X + 3,Y + 20);
    write(Tmp);
  End;
End;

{}

Procedure InitConfig;

Var
  N : integer;

Begin
  with ConfigActuelle do
  Begin
    Nom          := 'STANDARD';
    Com          := 1;
    Vitesse      := 1;
    Parite       := 1;
    BitDonnee    := 1;
    BitStop      := 1;
    Protocole    := 1;
    NbLigSupp    := 0;
    CarRecherche := Msg[74]^;
    CarSupp      := '';
    Codage       := 1;
    DelaiCar     := 0;
    DelaiLigne   := 0;
    AdrFic       := RepPrg;
    FicType      := '*.PAS';
    for N := 1 to 4 do
      with Serie[N] do
      Begin
        if LitComAdresse(N,Adresse) <> 0 then Adresse := 0;
        if LitComIrq(N,Irq) <> 0 then Irq := 0;
      End;
  End;
  for N := 1 to MaxChoix do
  Begin
    new(ListeConfig[N]);
    ListeConfig[N]^.Texte := '';
    ListeConfig[N]^.Selectionne := false;
  End;
  ChangeConfigDsMenu;
End;

{}

Procedure InitDialogLiaison;

Var
  N   : byte;
  Tmp : string[10];

Begin
  if ConfigActuelle.Codage = 1 then CentreDialogTx(51,20,Dialog)
                               else CentreDialogTx(51,21,Dialog);
  with Dialog do
  Begin
    Tip   := Ombre2;
    Coul  := CoulBtSaisie;
    Titre := ' ' + Msg[35]^ + ' ';
    InitBteABoutonTx(Boite[1],Msg[36]^,X + 3,Y + 2,45,true);
    InitBteABoutonTx(Boite[2],Msg[37]^,X + 3,Y + 5,45,true);
    InitBteABoutonTx(Boite[3],Msg[38]^,X + 3,Y + 10,16,false);
    InitBteABoutonTx(Boite[4],Msg[39]^,X + 32,Y + 10,16,true);
    InitBteABoutonTx(Boite[5],Msg[40]^,X + 32,Y + 13,16,true);
    InitBteABoutonTx(Boite[6],Msg[41]^,X + 3,Y + 15,45,true);
  End;
  for N := 1 to Machine.NbSeries do
  Begin
    Tmp := 'COM' + IntToStr(N);
    AjouteBoutonDsBteTx(Boite[1],Tmp);
  End;
  Boite[1]^.BtActif := ConfigActuelle.Com;

  AjouteBoutonDsBteTx(Boite[2],'110');
  AjouteBoutonDsBteTx(Boite[2],'150');
  AjouteBoutonDsBteTx(Boite[2],'300');
  AjouteBoutonDsBteTx(Boite[2],'600');
  AjouteBoutonDsBteTx(Boite[2],'1200');
  AjouteBoutonDsBteTx(Boite[2],'2400');
  AjouteBoutonDsBteTx(Boite[2],'4800');
  AjouteBoutonDsBteTx(Boite[2],'9600');
  AjouteBoutonDsBteTx(Boite[2],'19200');
  AjouteBoutonDsBteTx(Boite[2],'38400');
  AjouteBoutonDsBteTx(Boite[2],'57600');
  AjouteBoutonDsBteTx(Boite[2],'115200');
  Boite[2]^.BtActif := ConfigActuelle.Vitesse;

  AjouteBoutonDsBteTx(Boite[3],Msg[42]^);
  AjouteBoutonDsBteTx(Boite[3],Msg[43]^);
  AjouteBoutonDsBteTx(Boite[3],Msg[44]^);
  Boite[3]^.BtActif := ConfigActuelle.Parite;

  AjouteBoutonDsBteTx(Boite[4],'7');
  AjouteBoutonDsBteTx(Boite[4],'8');
  Boite[4]^.BtActif := ConfigActuelle.BitDonnee;

  AjouteBoutonDsBteTx(Boite[5],'1');
  AjouteBoutonDsBteTx(Boite[5],'2');
  Boite[5]^.BtActif := ConfigActuelle.BitStop;

  AjouteBoutonDsBteTx(Boite[6],Msg[45]^);
  AjouteBoutonDsBteTx(Boite[6],Msg[46]^);
  AjouteBoutonDsBteTx(Boite[6],Msg[47]^);
  Boite[6]^.BtActif := ConfigActuelle.Protocole;

  with Dialog do
  Begin
    InitBoutonTx(Bouton[1],Msg[64]^,X + 10,Y + 18,10,true,true);
    InitBoutonTx(Bouton[2],Msg[65]^,X + 30,Y + 18,10,true,false);
  End;

End;

{}

Procedure LibereDialogLiaison;

Begin
  LibereBteABoutonTx(Boite[1]);
  LibereBteABoutonTx(Boite[2]);
  LibereBteABoutonTx(Boite[3]);
  LibereBteABoutonTx(Boite[4]);
  LibereBteABoutonTx(Boite[5]);
  LibereBteABoutonTx(Boite[6]);

  LibereBoutonTx(Bouton[1]);
  LibereBoutonTx(Bouton[2]);
End;

{}

Procedure AfficheChoixLiaison;

Begin
  CacheSouris;
  InitDialogLiaison;
  OuvreDialogTx(Dialog);
  AfficheBoiteABoutonTx(Boite[1]);
  AfficheBoiteABoutonTx(Boite[2]);
  AfficheBoiteABoutonTx(Boite[3]);
  AfficheBoiteABoutonTx(Boite[4]);
  AfficheBoiteABoutonTx(Boite[5]);
  AfficheBoiteABoutonTx(Boite[6]);
  AfficheBoutonTx(Bouton[1]);
  AfficheBoutonTx(Bouton[2]);
  if ConfigActuelle.Codage > 1 then ChangementImpossible;
  MontreSouris;
End;

{}

Procedure ChangeLiaison;

Begin
  with ConfigActuelle do
  Begin
    Com          := Boite[1]^.BtActif;
    Vitesse      := Boite[2]^.BtActif;
    Parite       := Boite[3]^.BtActif;
    BitDonnee    := Boite[4]^.BtActif;
    BitStop      := Boite[5]^.BtActif;
    Protocole    := Boite[6]^.BtActif;
  End;
End;

{}

Procedure ChoixLiaison;

Var
  Position   : byte;
  LeCar      : char;
  InfoSouris : PosRec;

Begin
  AfficheChoixLiaison;
  Position := 1;
  repeat
    case Position of
      1 : Begin { Choix Com }
            AfficheBoiteABoutonTx(Boite[1]);
            GereBteABoutonTx(Boite[1],LeCar,InfoSouris);
          End;
      2 : Begin { Choix Vitesse }
            AfficheBoiteABoutonTx(Boite[2]);
            GereBteABoutonTx(Boite[2],LeCar,InfoSouris);
          End;
      3 : if ConfigActuelle.Codage = 1 then
          Begin { Choix Parite }
            AfficheBoiteABoutonTx(Boite[3]);
            GereBteABoutonTx(Boite[3],LeCar,InfoSouris);
          End;
      4 : if ConfigActuelle.Codage = 1 then
          Begin { Choix BitDonnee }
            AfficheBoiteABoutonTx(Boite[4]);
            GereBteABoutonTx(Boite[4],LeCar,InfoSouris);
          End;
      5 : Begin { Choix BitStop }
            AfficheBoiteABoutonTx(Boite[5]);
            GereBteABoutonTx(Boite[5],LeCar,InfoSouris);
          End;
      6 : Begin { Choix Protocole }
            AfficheBoiteABoutonTx(Boite[6]);
            GereBteABoutonTx(Boite[6],LeCar,InfoSouris);
          End;
      7 : Begin { Choix Ok }
            AttendActionTx(LeCar,InfoSouris);
          End;
      8 : Begin { Choix Annule }
            Bouton[1]^.Actif := false;
            AfficheBoutonTx(Bouton[1]);
            Bouton[2]^.Actif := true;
            AfficheBoutonTx(Bouton[2]);
            AttendActionTx(LeCar,InfoSouris);
            Bouton[2]^.Actif := false;
            AfficheBoutonTx(Bouton[2]);
            Bouton[1]^.Actif := true;
            AfficheBoutonTx(Bouton[1]);
          End;
    end;
    if LeCar = #0 then
    Begin
      if SourisDsBteABoutonTx(Boite[1],InfoSouris) then Position := 1
      else
      if SourisDsBteABoutonTx(Boite[2],InfoSouris) then Position := 2
      else
      if SourisDsBteABoutonTx(Boite[3],InfoSouris) then
        if ConfigActuelle.Codage = 1 then Position := 3
                                     else Beep
      else
      if SourisDsBteABoutonTx(Boite[4],InfoSouris) then
        if ConfigActuelle.Codage = 1 then Position := 4
                                     else Beep
      else
      if SourisDsBteABoutonTx(Boite[5],InfoSouris) then Position := 5
      else
      if SourisDsBteABoutonTx(Boite[6],InfoSouris) then Position := 6
      else
      if SourisDsBoutonTx(Bouton[1],InfoSouris) then
      Begin
        Position := 7;
        LeCar := CarReturn;
      End
      else
      if SourisDsBoutonTx(Bouton[2],InfoSouris) then
      Begin
        Position := 8;
        LeCar := CarEsc;
      End;
    End;
    if LeCar = Tab then
      if Position = 8 then Position := 1
                      else inc(Position);
    if LeCar = ShiftTab then
      if Position = 1 then Position := 8
                      else dec(Position);

    if ToucheDuBoutonTx(Bouton[1],LeCar) then LeCar := CarReturn;
    if ToucheDuBoutonTx(Bouton[2],LeCar) then LeCar := CarEsc;

    if ToucheFct and (LeCar = ShiftF1) then BoiteAProposTx;
  until LeCar in [AltX,CarEsc,CarReturn];
  if LeCar = AltX then Sortie := true;
  FermeDialogTx(Dialog);
  if LeCar = CarReturn then ChangeLiaison;
  LibereDialogLiaison;
End;

{}

Procedure InitDialogDonnee;

Begin
  CentreDialogTx(75,17,Dialog);
  with dialog do
  Begin
    Tip   := Ombre2;
    Coul  := CoulBtSaisie;
    Titre := ' ' + Msg[48]^ + ' ';
    InitBteABoutonTx(Boite[1],Msg[52]^,X + 3,Y + 8,31,true);
  End;

  AjouteBoutonDsBteTx(Boite[1],'ASCII');
  AjouteBoutonDsBteTx(Boite[1],'ISO');
  AjouteBoutonDsBteTx(Boite[1],'EIA');
  Boite[1]^.BtActif := ConfigActuelle.Codage;

  with Dialog do
  Begin
    InitBoutonTx(Bouton[1],Msg[64]^,X + 18,Y + 15,10,true,false);
    InitBoutonTx(Bouton[2],Msg[65]^,X + 47,Y + 15,10,true,false);
  End;

  with ConfigActuelle do
  Begin
    NbLigSuppTmp := NbLigSupp;
    CarRechTmp   := CarRecherche;
    CarSuppTmp   := CarSupp;
    DelaiCarTmp  := DelaiCar;
    DelaiLigneTmp:= DelaiLigne;
  End;
End;

{}

Procedure LibereDialogDonnee;

Begin
  LibereBteABoutonTx(Boite[1]);

  LibereBoutonTx(Bouton[1]);
  LibereBoutonTx(Bouton[2]);
End;

{}

Procedure AfficheChoixDonnee;

Var
  LeCar : char;

Begin
  CacheSouris;
  InitDialogDonnee;
  OuvreDialogTx(Dialog);
  with Dialog do
  Begin
    CoulEncreTx(CoulBteABouton.Encre);
    CoulFondTx(CoulBtSaisie.Fond);
    UnEntier := NbLigSuppTmp;
    LeCar := LireEntierTx(Msg[49]^,X + 3,Y + 2,3,Afficher,true,0,255);
    UneChaine := CarRechTmp;
    LeCar := LireChaineTx(Msg[50]^,X + 3,Y + 4,4,Afficher,true);
    UneChaine := CarSuppTmp;
    LeCar := LireChaineTx(Msg[51]^,X + 3,Y + 6,40,Afficher,true);
    UnEntier := DelaiCarTmp;
    LeCar := LireEntierTx(Msg[53]^,X + 3,Y + 11,5,Afficher,true,0,65535);
    UnEntier := DelaiLigneTmp;
    LeCar := LireEntierTx(Msg[54]^,X + 3,Y + 13,5,Afficher,true,0,65535);
  End;
  AfficheBoiteABoutonTx(Boite[1]);
  AfficheBoutonTx(Bouton[1]);
  AfficheBoutonTx(Bouton[2]);
  MontreSouris;
End;

{}

Procedure ChangeDonnee;

Begin
  with ConfigActuelle do
  Begin
    NbLigSupp    := NbLigSuppTmp;
    CarRecherche := CarRechTmp;
    CarSupp      := Compresse(CarSuppTmp);
    Codage       := Boite[1]^.BtActif;
    if Codage = 2 then
    Begin
      Parite    := 1;
      BitDonnee := 1;
    End;
    if Codage = 3 then
    Begin
      Parite    := 3;
      BitDonnee := 2;
    End;
    DelaiCar   := DelaiCarTmp;
    DelaiLigne := DelaiLigneTmp;
  End;
End;

{}

Procedure ChoixNbLigSupp(Var LeCar : char;Var InfoSouris : PosRec);

Var
  CarTmp : char;  { caractere temporaire non utilise }
  AncienneAide : Str80;

Begin
  AncienneAide := LigneAide.Texte;
  with Dialog do
  Begin
    CoulEncreTx(CoulBteABoutonSelec.Encre);
    CoulFondTx(CoulBtSaisie.Fond);
    UnEntier := NbLigSuppTmp;
    LeCar := LireEntierTx(Msg[49]^,X + 3,Y + 2,3,Utiliser,true,0,255);
    if LeCar = #0 then
    Begin
      PosSouris(InfoSouris);
      InfoSouris.Bouton := BoutonGauche;
    End;
    if LeCar = AltX then Sortie := true;
    if LeCar = CarReturn then
    Begin
      NbLigSuppTmp := UnEntier;
      LeCar := Tab;
    End;
    CoulEncreTx(CoulBteABouton.Encre);
    CoulFondTx(CoulBtSaisie.Fond);
    UnEntier := NbLigSuppTmp;
    CarTmp := LireEntierTx(Msg[49]^,X + 3,Y + 2,3,Afficher,true,0,255);
  End;
  LigneAide.Texte := AncienneAide;
  AfficheLigneAideTx(true);
End;

{}

Procedure ChoixCarRech(Var LeCar : char;Var InfoSouris : PosRec);

Var
  CarTmp : char;  { caractere temporaire non utilise }
  LeDialog : DialogRecTx;
  AncienneAide : Str80;

Begin
  AncienneAide := LigneAide.Texte;
  CoulEncreTx(CoulBteABoutonSelec.Encre);
  CoulFondTx(CoulBtSaisie.Fond);
  UneChaine := CarRechTmp;
  with Dialog do CarTmp := LireChaineTx(Msg[50]^,X + 3,Y + 4,4,Afficher,true);
  with LeDialog do
  Begin
    X := Dialog.X + 40;
    Y := Dialog.Y + 2;
    Tip := Ombre2;
    Titre := Msg[75]^;
  End;
  LeCar := BoiteBoutTx(LeDialog,' '+Msg[74]^+' ',' '+Msg[73]^+' ');
  case LeCar of
    '1' : Begin
            CarRechTmp := Msg[74]^;
            LeCar := Tab;
          End;
    '2' : Begin
            LeDialog.Titre := Msg[50]^;
            UneChaine := '%';
            CarTmp := BoiteChaineTx(LeDialog,1,true);
            case CarTmp of
              CarEsc    : LeCar := #255;
              CarReturn : Begin
                            LeCar := Tab;
                            CarRechTmp := UneChaine;
                          End;
              #0        : Begin
                            LeCar := #0;
                            PosSouris(InfoSouris);
                            InfoSouris.Bouton := BoutonGauche;
                          End;
            else LeCar := CarTmp;
            end;
          End;
    #0  : Begin
            PosSouris(InfoSouris);
            InfoSouris.Bouton := BoutonGauche;
          End;
  end;
  if LeCar = AltX then Sortie := true;
  CoulEncreTx(CoulBteABouton.Encre);
  CoulFondTx(CoulBtSaisie.Fond);
  UneChaine := CarRechTmp;
  with Dialog do CarTmp := LireChaineTx(Msg[50]^,X + 3,Y + 4,4,Afficher,true);
  LigneAide.Texte := AncienneAide;
  AfficheLigneAideTx(true);
End;

{}

Function CarSuppCorrect(CarSuppStr : Str80) : boolean;

Var
  Ok        : boolean;
  UneAlarme : AlarmeRec;
  Valeur    : integer;
  ValeurStr : Str4;

Begin
  Ok := true;
  Valeur := length(CarSuppStr);
  if (Valeur > 0) and (CarSuppStr[Valeur] <> ',') then CarSuppStr := CarSuppStr + ',';
  while length(CarSuppStr) > 0 do
  Begin
    ValeurStr := copy(CarSuppStr,1,pos(',',CarSuppStr) - 1);
    delete(CarSuppStr,1,pos(',',CarSuppStr));
    Valeur := StrToInt(ValeurStr);
    if Valeur > 255 then Ok := false;
  End;
  if not Ok then
  Begin
    UneAlarme[1] := ' ' + Msg[51]^ + ' ';
    UneAlarme[2] := ' ' + Msg[83]^ + ' ';
    UneAlarme[3] := ' ' + Msg[84]^ + ' ';
    uneAlarme[4] := ' ';
    AlarmeTx(Dialog.Y + 7,UneAlarme);
  End;
  CarSuppCorrect := Ok;
End;

{}

Procedure ChoixCarSupp(Var LeCar : char;Var InfoSouris : PosRec);

Var
  CarTmp : char;  { caractere temporaire non utilise }
  AncienneAide : Str80;

Begin
  AncienneAide := LigneAide.Texte;
  with Dialog do
  Begin
    CoulEncreTx(CoulBteABoutonSelec.Encre);
    CoulFondTx(CoulBtSaisie.Fond);
    UneChaine := CarSuppTmp;
    LeCar := LireChaineTx(Msg[51]^,X + 3,Y + 6,40,Utiliser,true);
    if LeCar = #0 then
    Begin
      PosSouris(InfoSouris);
      InfoSouris.Bouton := BoutonGauche;
    End;
    if LeCar = CarReturn then
    Begin
      CarSuppTmp := UneChaine;
      if CarSuppCorrect(UneChaine) then LeCar := Tab
                                   else LeCar := #255;
    End;
    CoulEncreTx(CoulBteABouton.Encre);
    CoulFondTx(CoulBtSaisie.Fond);
    UneChaine := CarSuppTmp;
    CarTmp := LireChaineTx(Msg[51]^,X + 3,Y + 6,40,Afficher,true);
  End;
  if LeCar = AltX then Sortie := true;
  LigneAide.Texte := AncienneAide;
  AfficheLigneAideTx(true);
End;

{}

Procedure ChoixDelaiCar(Var LeCar : char;Var InfoSouris : PosRec);

Var
  CarTmp : char;  { caractere temporaire non utilise }
  AncienneAide : Str80;

Begin
  AncienneAide := LigneAide.Texte;
  with Dialog do
  Begin
    CoulEncreTx(CoulBteABoutonSelec.Encre);
    CoulFondTx(CoulBtSaisie.Fond);
    UnEntier := DelaiCarTmp;
    LeCar := LireEntierTx(Msg[53]^,X + 3,Y + 11,5,Utiliser,true,0,65535);
    if LeCar = #0 then
    Begin
      PosSouris(InfoSouris);
      InfoSouris.Bouton := BoutonGauche;
    End;
    if LeCar = AltX then Sortie := true;
    if LeCar = CarReturn then
    Begin
      DelaiCarTmp := UnEntier;
      LeCar := Tab;
    End;
    CoulEncreTx(CoulBteABouton.Encre);
    CoulFondTx(CoulBtSaisie.Fond);
    UnEntier := DelaiCarTmp;
    CarTmp := LireEntierTx(Msg[53]^,X + 3,Y + 11,5,Afficher,true,0,65535);
  End;
  LigneAide.Texte := AncienneAide;
  AfficheLigneAideTx(true);
End;

{}

Procedure ChoixDelaiLigne(Var LeCar : char;Var InfoSouris : PosRec);

Var
  CarTmp : char;  { caractere temporaire non utilise }
  AncienneAide : Str80;

Begin
  AncienneAide := LigneAide.Texte;
  with Dialog do
  Begin
    CoulEncreTx(CoulBteABoutonSelec.Encre);
    CoulFondTx(CoulBtSaisie.Fond);
    UnEntier := DelaiLigneTmp;
    LeCar := LireEntierTx(Msg[54]^,X + 3,Y + 13,5,Utiliser,true,0,65535);
    if LeCar = #0 then
    Begin
      PosSouris(InfoSouris);
      InfoSouris.Bouton := BoutonGauche;
    End;
    if LeCar = AltX then Sortie := true;
    if LeCar = CarReturn then
    Begin
      DelaiLigneTmp := UnEntier;
      LeCar := Tab;
    End;
    CoulEncreTx(CoulBteABouton.Encre);
    CoulFondTx(CoulBtSaisie.Fond);
    UnEntier := DelaiLigneTmp;
    CarTmp := LireEntierTx(Msg[54]^,X + 3,Y + 13,5,Afficher,true,0,65535);
  End;
  LigneAide.Texte := AncienneAide;
  AfficheLigneAideTx(true);
End;

{}

Procedure ChoixDonnee;

Var
  Position   : byte;
  LeCar      : char;
  InfoSouris : PosRec;
  Long       : byte;
  XTmp       : byte;
  YTmp       : byte;

Begin
  AfficheChoixDonnee;
  CacheSouris;
  Position := 7;
  repeat
    case Position of
      1 : ChoixNbLigSupp(LeCar,InfoSouris);
      2 : ChoixCarRech(LeCar,InfoSouris);
      3 : ChoixCarSupp(LeCar,InfoSouris);
      4 : Begin
            AfficheBoiteABoutonTx(Boite[1]);
            GereBteABoutonTx(Boite[1],LeCar,InfoSouris);
            if LeCar = CarReturn then LeCar := Tab;
          End;
      5 : ChoixDelaiCar(LeCar,InfoSouris);
      6 : ChoixDelaiLigne(LeCar,InfoSouris);
      7 : Begin
            Bouton[1]^.Actif := true;
            AfficheBoutonTx(Bouton[1]);
            MontreSouris;
            AttendActionTx(LeCar,InfoSouris);
            CacheSouris;
            Bouton[1]^.Actif := false;
            AfficheBoutonTx(Bouton[1]);
          End;
      8 : Begin
            Bouton[2]^.Actif := true;
            AfficheBoutonTx(Bouton[2]);
            MontreSouris;
            AttendActionTx(LeCar,InfoSouris);
            CacheSouris;
            Bouton[2]^.Actif := false;
            AfficheBoutonTx(Bouton[2]);
          End;
    end;
    if LeCar = #0 then
    Begin
      with Dialog do
      Begin
        with InfoSouris do PosSourisPosTx(Colonne,Ligne,XTmp,YTmp);
        Long := length(Msg[49]^) + 4;
        if SourisDsZone(XTmp,YTmp,X+3,Y+2,X+3+Long,Y+2) then Position := 1;
        Long := length(Msg[50]^) + 5;
        if SourisDsZone(XTmp,YTmp,X+3,Y+4,X+3+Long,Y+4) then Position := 2;
        Long := length(Msg[51]^) + 41;
        if SourisDsZone(XTmp,YTmp,X+3,Y+6,X+3+Long,Y+6) then Position := 3;
        Long := length(Msg[53]^) + 6;
        if SourisDsZone(XTmp,YTmp,X+3,Y+11,X+3+Long,Y+11) then Position := 5;
        Long := length(Msg[54]^) + 6;
        if SourisDsZone(XTmp,YTmp,X+3,Y+13,X+3+Long,Y+13) then Position := 6;
      End;
      if SourisDsBteABoutonTx(Boite[1],InfoSouris) then Position := 4
      else
      if SourisDsBoutonTx(Bouton[1],InfoSouris) then
      Begin
        Position := 7;
        LeCar := CarReturn;
      End
      else
      if SourisDsBoutonTx(Bouton[2],InfoSouris) then
      Begin
        Position := 8;
        LeCar := CarEsc;
      End;
    End;
    if LeCar = Tab then
      if Position = 8 then Position := 1
                      else inc(Position);
    if LeCar = ShiftTab then
      if Position = 1 then Position := 8
                      else dec(Position);

    if ToucheDuBoutonTx(Bouton[1],LeCar) then LeCar := CarReturn;
    if ToucheDuBoutonTx(Bouton[2],LeCar) then LeCar := CarEsc;

    if ToucheFct and (LeCar = ShiftF1) then BoiteAProposTx;
  until LeCar in [AltX,CarEsc,CarReturn];
  if LeCar = AltX then Sortie := true;
  FermeDialogTx(Dialog);
  if LeCar = CarReturn then ChangeDonnee;
  LibereDialogDonnee;
  MontreSouris;
End;

{}

Procedure InitDialogFichier;

Begin
  with dialog do
  Begin
    Y     := 4;
    Tip   := Ombre2;
    Coul  := CoulBtSaisie;
    Titre := ' ' + Msg[58]^ + ' ';
  End;
  CalculLargDialogTx(75,Dialog);
  CalculHautDialogTx(8,Dialog);
  CalculXDialogTx(Dialog);

  with Dialog do
  Begin
    InitBoutonTx(Bouton[1],Msg[64]^,X + 18,Y + 6,10,true,false);
    InitBoutonTx(Bouton[2],Msg[65]^,X + 47,Y + 6,10,true,false);
  End;

  with ConfigActuelle do
  Begin
    AdrFicTmp    := AdrFic;
    FicTypeTmp   := FicType;
  End;

End;

{}

Procedure LibereDialogFichier;

Begin
  LibereBoutonTx(Bouton[1]);
  LibereBoutonTx(Bouton[2]);
End;

{}

Procedure AfficheChoixFichier;

Var
  LeCar : char;

Begin
  CacheSouris;
  InitDialogFichier;
  OuvreDialogTx(Dialog);
  with Dialog do
  Begin
    CoulEncreTx(CoulBteABouton.Encre);
    CoulFondTx(CoulBtSaisie.Fond);
    UneChaine := AdrFicTmp;
    LeCar := LireChaineTx(Msg[59]^,X + 3,Y + 2,58,Afficher,true);
    UneChaine := FicTypeTmp;
    LeCar := LireChaineTx(Msg[60]^,X + 3,Y + 4,12,Afficher,true);
  End;
  AfficheBoutonTx(Bouton[1]);
  AfficheBoutonTx(Bouton[2]);
  MontreSouris;
End;

{}

Procedure ChangeFichier;

Begin
  with ConfigActuelle do
  Begin
    AdrFic    := Compresse(AdrFicTmp);
    FicType   := Compresse(FicTypeTmp);
  End;
End;

{}

Procedure ChoixAdrFic(Var LeCar : char;Var InfoSouris : PosRec);

Var
  CarTmp   : char;  { caractere temporaire non utilise }
  AncienneAide : Str80;
  UnDialog : DialogRecTx;
  UneBoite : BteChoixRepTxPtr;

Begin
  AncienneAide := LigneAide.Texte;
  With UnDialog do
  Begin
    X := 0;
    Y := 8;
    Tip := Ombre2;
    Titre := Msg[77]^;
  End;
  with Dialog do
  Begin
    CoulEncreTx(CoulBteABoutonSelec.Encre);
    CoulFondTx(CoulBtSaisie.Fond);
    UneChaine := AdrFicTmp;
    CarTmp := LireChaineTx(Msg[59]^,X + 3,Y + 2,58,Afficher,true);

    InitBteChoixRepTx(UneBoite,AdrFicTmp,Msg[76]^,Msg[64]^,Msg[65]^);
    LeCar := BoiteChoixRepTx(UnDialog,UneBoite);
    if LeCar = CarReturn then AdrFicTmp := UneBoite^.Repertoire;
    LibereBteChoixRepTx(UneBoite);
    LeCar := Tab;

    CoulEncreTx(CoulBteABouton.Encre);
    CoulFondTx(CoulBtSaisie.Fond);
    UneChaine := AdrFicTmp;
    CarTmp := LireChaineTx(Msg[59]^,X + 3,Y + 2,58,Afficher,true);
  End;
  if LeCar = AltX then Sortie := true;
  LigneAide.Texte := AncienneAide;
  AfficheLigneAideTx(true);
End;

{}

Procedure AlarmeFicType;

Var
  UneAlarme : AlarmeRec;

Begin
  UneAlarme[1] := ' ' + Msg[68]^ + ' ';
  UneAlarme[2] := '';
  UneAlarme[3] := '';
  UneAlarme[4] := '';
  AlarmeTx(0,UneAlarme);
End;

{}

Procedure ChoixFicType(Var LeCar : char;Var InfoSouris : PosRec);

Var
  CarTmp : char;  { caractere temporaire non utilise }
  AncienneAide : Str80;

Begin
  AncienneAide := LigneAide.Texte;
  with Dialog do
  Begin
    CoulEncreTx(CoulBteABoutonSelec.Encre);
    CoulFondTx(CoulBtSaisie.Fond);
    UneChaine := FicTypeTmp;
    LeCar := LireChaineTx(Msg[60]^,X + 3,Y + 4,12,Utiliser,true);
    if LeCar = #0 then
    Begin
      PosSouris(InfoSouris);
      InfoSouris.Bouton := BoutonGauche;
    End;
    if LeCar = CarReturn then
    Begin
      if NomFichierCorrect(UneChaine,true) then
      Begin
        FicTypeTmp := UneChaine;
        LeCar := Tab;
      End
      else
      Begin
        AlarmeFicType;
        LeCar := #255;
      End;
    End;
    CoulEncreTx(CoulBteABouton.Encre);
    CoulFondTx(CoulBtSaisie.Fond);
    UneChaine := FicTypeTmp;
    CarTmp := LireChaineTx(Msg[60]^,X + 3,Y + 4,12,Afficher,true);
  End;
  if LeCar = AltX then Sortie := true;
  LigneAide.Texte := AncienneAide;
  AfficheLigneAideTx(true);
End;

{}

Procedure ChoixFichier;

Var
  Position   : byte;
  LeCar      : char;
  InfoSouris : PosRec;
  Long       : byte;
  XTmp       : byte;
  YTmp       : byte;

Begin
  AfficheChoixFichier;
  CacheSouris;
  Position := 3;
  repeat
    case Position of
      1 : ChoixAdrFic(LeCar,InfoSouris);
      2 : ChoixFicType(LeCar,InfoSouris);
      3 : Begin
            Bouton[1]^.Actif := true;
            AfficheBoutonTx(Bouton[1]);
            MontreSouris;
            AttendActionTx(LeCar,InfoSouris);
            CacheSouris;
            Bouton[1]^.Actif := false;
            AfficheBoutonTx(Bouton[1]);
          End;
      4 : Begin
            Bouton[2]^.Actif := true;
            AfficheBoutonTx(Bouton[2]);
            MontreSouris;
            AttendActionTx(LeCar,InfoSouris);
            CacheSouris;
            Bouton[2]^.Actif := false;
            AfficheBoutonTx(Bouton[2]);
          End;
    end;
    if LeCar = #0 then
    Begin
      with Dialog do
      Begin
        with InfoSouris do PosSourisPosTx(Colonne,Ligne,XTmp,YTmp);
        Long := length(Msg[59]^) + 59;
        if SourisDsZone(XTmp,YTmp,X+3,Y+2,X+3+Long,Y+2) then Position := 1;
        Long := length(Msg[60]^) + 13;
        if SourisDsZone(XTmp,YTmp,X+3,Y+4,X+3+Long,Y+4) then Position := 2;
      End;
      if SourisDsBoutonTx(Bouton[1],InfoSouris) then
      Begin
        Position := 3;
        LeCar := CarReturn;
      End
      else
      if SourisDsBoutonTx(Bouton[2],InfoSouris) then
      Begin
        Position := 4;
        LeCar := CarEsc;
      End;
    End;
    if LeCar = Tab then
      if Position = 4 then Position := 1
                      else inc(Position);
    if LeCar = ShiftTab then
      if Position = 1 then Position := 4
                      else dec(Position);

    if ToucheDuBoutonTx(Bouton[1],LeCar) then LeCar := CarReturn;
    if ToucheDuBoutonTx(Bouton[2],LeCar) then LeCar := CarEsc;

    if ToucheFct and (LeCar = ShiftF1) then BoiteAProposTx;
  until LeCar in [AltX,CarEsc,CarReturn];
  if LeCar = AltX then Sortie := true;
  FermeDialogTx(Dialog);
  if LeCar = CarReturn then ChangeFichier;
  LibereDialogFichier;
  MontreSouris;
End;

{}

Procedure InitDialogMateriel;

Var
  N   : byte;

Begin
  CentreDialogTx(42,(4 * Machine.NbSeries + 4),Dialog);
  with dialog do
  Begin
    Tip   := Ombre2;
    Coul  := CoulBtSaisie;
    Titre := ' ' + Msg[61]^ + ' ';
  End;

  with Dialog do
  Begin
    InitBoutonTx(Bouton[1],Msg[64]^,X + 3,Y + Haut - 4,10,true,false);
    InitBoutonTx(Bouton[2],Msg[65]^,X + 16,Y + Haut - 4,10,true,false);
    InitBoutonTx(Bouton[3],Msg[78]^,X + 29,Y + Haut - 4,10,true,false);
  End;

  with ConfigActuelle do
    for N := 1 to Machine.NbSeries do SerieTmp[N] := Serie[N];

End;

{}

Procedure LibereDialogMateriel;

Begin
  LibereBoutonTx(Bouton[1]);
  LibereBoutonTx(Bouton[2]);
  LibereBoutonTx(Bouton[3]);
End;

{}

Procedure AfficheUnPort(Num : byte);

Var
  LeCar : char;
  PosY  : byte;
  Tmp   : Str20;

Begin
  with Dialog do
  Begin
    PosY := Y + (Num - 1) * 4 + 2;
    CoulEncreTx(CoulBteABouton.Encre);
    CoulFondTx(CoulBtSaisie.Fond);
    gotoxy(X + 3,PosY);
    write('Com',Num,' :');

    CoulFondTx(CoulBteaBouton.Fond);
    UnEntier := SerieTmp[Num].Adresse;
    LeCar := LireEntierTx(' ' + Msg[62]^,X+5,PosY+1,5,Afficher,true,0,65535);
    CoulFondTx(CoulBtSaisie.Fond);
    gotoxy(X + 15 + length(Msg[62]^),PosY + 1);
    Tmp :='(' + DecToBase(UnEntier,16) + ' Hex)';
    Tmp := ElargiADte(Tmp,10);
    write(Tmp);

    CoulFondTx(CoulBteaBouton.Fond);
    UnEntier := SerieTmp[Num].Irq;
    LeCar := LireEntierTx(' ' + Msg[63]^,X+5,PosY+2,5,Afficher,true,0,15);
    CoulFondTx(CoulBtSaisie.Fond);
    gotoxy(X + 15 + length(Msg[63]^),PosY + 2);
    write('(0 - 15)');
  End;
End;

{}

Procedure AfficheChoixMateriel;

Var
  N : byte;

Begin
  CacheSouris;
  InitDialogMateriel;
  OuvreDialogTx(Dialog);
  with Dialog do
    for N := 1 to Machine.NbSeries do AfficheUnPort(N);
  AfficheBoutonTx(Bouton[1]);
  AfficheBoutonTx(Bouton[2]);
  AfficheBoutonTx(Bouton[3]);
  MontreSouris;
End;

{}

Procedure ChangeMateriel;

Var
  N : byte;

Begin
  with ConfigActuelle do
    for N := 1 to Machine.NbSeries do Serie[N] := SerieTmp[N];
End;

{}

Procedure ChoixAdrMateriel(Num:byte;Var LeCar:char;Var InfoSouris:PosRec);

Var
  PosY : byte;
  CarTmp : char;  { caractere temporaire non utilise }
  Tmp : Str20;
  AncienneAide : Str80;

Begin
  AncienneAide := LigneAide.Texte;
  with Dialog do
  Begin
    PosY := Y + (Num - 1) * 4 + 2;
    CoulEncreTx(CoulBteABoutonSelec.Encre);
    CoulFondTx(CoulBtSaisie.Fond);
    gotoxy(X + 3,PosY);
    write('Com',Num,' :');
    CoulFondTx(CoulBteaBouton.Fond);
    UnEntier := SerieTmp[Num].Adresse;
    LeCar := LireEntierTx(' ' + Msg[62]^,X+5,PosY+1,5,Utiliser,true,0,65535);
    if LeCar = #0 then
    Begin
      PosSouris(InfoSouris);
      InfoSouris.Bouton := BoutonGauche;
    End;
    if LeCar = CarReturn then
    Begin
      SerieTmp[Num].Adresse := UnEntier;
      LeCar := Tab;
    End;
    CoulEncreTx(CoulBteABouton.Encre);
    CoulFondTx(CoulBtSaisie.Fond);
    gotoxy(X + 3,PosY);
    write('Com',Num,' :');
    CoulFondTx(CoulBteaBouton.Fond);
    UnEntier := SerieTmp[Num].Adresse;
    CarTmp := LireEntierTx(' ' + Msg[62]^,X+5,PosY+1,5,Afficher,true,0,65535);
    CoulFondTx(CoulBtSaisie.Fond);
    gotoxy(X + 15 + length(Msg[62]^),PosY + 1);
    Tmp :='(' + DecToBase(UnEntier,16) + ' Hex)';
    Tmp := ElargiADte(Tmp,10);
    write(Tmp);
  End;
  if LeCar = AltX then Sortie := true;
  LigneAide.Texte := AncienneAide;
  AfficheLigneAideTx(true);
End;

{}

Procedure ChoixIrqMateriel(Num:byte;Var LeCar:char;Var InfoSouris:PosRec);

Var
  PosY : byte;
  CarTmp : char;  { caractere temporaire non utilise }
  AncienneAide : Str80;

Begin
  AncienneAide := LigneAide.Texte;
  with Dialog do
  Begin
    PosY := Y + (Num - 1) * 4 + 2;
    CoulEncreTx(CoulBteABoutonSelec.Encre);
    CoulFondTx(CoulBtSaisie.Fond);
    gotoxy(X + 3,PosY);
    write('Com',Num,' :');
    CoulFondTx(CoulBteaBouton.Fond);
    UnEntier := SerieTmp[Num].Irq;
    LeCar := LireEntierTx(' ' + Msg[63]^,X+5,PosY+2,5,Utiliser,true,0,15);
    if LeCar = #0 then
    Begin
      PosSouris(InfoSouris);
      InfoSouris.Bouton := BoutonGauche;
    End;
    if LeCar = CarReturn then
    Begin
      SerieTmp[Num].Irq := UnEntier;
      LeCar := Tab;
    End;
    CoulEncreTx(CoulBteABouton.Encre);
    CoulFondTx(CoulBtSaisie.Fond);
    gotoxy(X + 3,PosY);
    write('Com',Num,' :');
    CoulFondTx(CoulBteaBouton.Fond);
    UnEntier := SerieTmp[Num].Irq;
    CarTmp := LireEntierTx(' ' + Msg[63]^,X+5,PosY+2,5,Afficher,true,0,65535);
  End;
  if LeCar = AltX then Sortie := true;
  LigneAide.Texte := AncienneAide;
  AfficheLigneAideTx(true);
End;

{}

Procedure DetecteCom;

Var
  N : byte;

Begin
  CacheSouris;
  for N := 1 to Machine.NbSeries do
    with SerieTmp[N] do
    Begin
      Adresse := DetecteAdresseCom(N);
      AfficheUnPort(N);
    End;
End;

{}

Procedure ChoixMateriel;

Var
  Position   : byte;
  MaxPos     : byte;
  LeCar      : char;
  InfoSouris : PosRec;
  N ,PosY    : byte;
  XTmp       : byte;
  YTmp       : byte;

Begin
  AfficheChoixMateriel;
  CacheSouris;
  Position := 1;
  MaxPos := Machine.NbSeries * 2 + 3;
  repeat
    case Position of
      1  : Begin
             Bouton[1]^.Actif := true;
             AfficheBoutonTx(Bouton[1]);
             MontreSouris;
              AttendActionTx(LeCar,InfoSouris);
             CacheSouris;
             Bouton[1]^.Actif := false;
             AfficheBoutonTx(Bouton[1]);
           End;
      2  : Begin
             Bouton[2]^.Actif := true;
             AfficheBoutonTx(Bouton[2]);
             MontreSouris;
             AttendActionTx(LeCar,InfoSouris);
             CacheSouris;
             Bouton[2]^.Actif := false;
             AfficheBoutonTx(Bouton[2]);
           End;
      3  : Begin
             Bouton[3]^.Actif := true;
             AfficheBoutonTx(Bouton[3]);
             MontreSouris;
             AttendActionTx(LeCar,InfoSouris);
             CacheSouris;
             Bouton[3]^.Actif := false;
             AfficheBoutonTx(Bouton[3]);
           End;
      4  : ChoixAdrMateriel(1,LeCar,InfoSouris);
      5  : ChoixIrqMateriel(1,LeCar,InfoSouris);
      6  : ChoixAdrMateriel(2,LeCar,InfoSouris);
      7  : ChoixIrqMateriel(2,LeCar,InfoSouris);
      8  : ChoixAdrMateriel(3,LeCar,InfoSouris);
      9  : ChoixIrqMateriel(3,LeCar,InfoSouris);
      10 : ChoixAdrMateriel(4,LeCar,InfoSouris);
      11 : ChoixIrqMateriel(4,LeCar,InfoSouris);
    end;
    if LeCar = #0 then
    Begin
      with Dialog do
      Begin
        with InfoSouris do PosSourisPosTx(Colonne,Ligne,XTmp,YTmp);
        if (XTmp > X+5) and (XTmp < X+12+length(Msg[62]^)) then
          for N := 1 to Machine.NbSeries do
          Begin
            PosY := Y + (N - 1) * 4 + 3;
            if YTmp = PosY then Position := 2 * N + 2;
            inc(PosY);
            if YTmp = PosY then Position := 2 * N + 3;
          End;
      End;
      if SourisDsBoutonTx(Bouton[1],InfoSouris) then
      Begin
        Position := 1;
        LeCar := CarReturn;
      End
      else
      if SourisDsBoutonTx(Bouton[2],InfoSouris) then
      Begin
        Position := 2;
        LeCar := CarEsc;
      End;
      if SourisDsBoutonTx(Bouton[3],InfoSouris) then
      Begin
        Position := 3;
        LeCar := CarReturn;
      End;
    End;
    if LeCar = Tab then
      if Position = MaxPos then Position := 1
                           else inc(Position);
    if LeCar = ShiftTab then
      if Position = 1 then Position := MaxPos
                      else dec(Position);

    if ToucheDuBoutonTx(Bouton[1],LeCar) then LeCar := CarReturn;
    if ToucheDuBoutonTx(Bouton[2],LeCar) then LeCar := CarEsc;

    if ToucheFct and (LeCar = ShiftF1) then BoiteAProposTx;
    if (LeCar = CarReturn) and (Position = 3) then
    Begin
      DetecteCom;
      LeCar := #255;
    End;
  until LeCar in [AltX,CarEsc,CarReturn];
  if LeCar = AltX then Sortie := true;
  FermeDialogTx(Dialog);
  if LeCar = CarReturn then ChangeMateriel;
  LibereDialogMateriel;
  MontreSouris;
End;

{}

Procedure ConstruitLignes;

Var
  Tmp : Str80;
  N   : byte;

Begin
  with ConfigActuelle do
  Begin
    LigneCfg[1] := Nom;
    Tmp := IntToStr(Com)+#255+IntToStr(Vitesse)+#255+IntToStr(Parite)+#255;
    Tmp := Tmp+IntToStr(BitDonnee)+#255+IntToStr(BitStop)+#255;
    Tmp := Tmp+IntToStr(Protocole)+#255+IntToStr(NbLigSupp)+#255+CarRecherche;
    Tmp := Tmp+#255+CarSupp+#255+IntToStr(Codage)+#255;
    Tmp := Tmp+IntToStr(DelaiCar)+#255+IntToStr(DelaiLigne)+#255;
    LigneCfg[2] := Tmp;
    LigneCfg[3] := AdrFic;
    Tmp := FicType+#255;
    for N := 1 to 4 do
      with Serie[N] do Tmp := Tmp+IntToStr(Adresse)+#255+IntToStr(Irq)+#255;
    LigneCfg[4] := Tmp;
  End;
End;

{}

Procedure DecrypteLignes;

Var
  Tmp : Str80;
  N   : byte;

Begin
  with ConfigActuelle do
  Begin
    Nom := LigneCfg[1];

    Tmp := copy(LigneCfg[2],1,pos(#255,LigneCfg[2])-1);
    delete(LigneCfg[2],1,pos(#255,LigneCfg[2]));
    Com := StrToInt(Tmp);

    Tmp := copy(LigneCfg[2],1,pos(#255,LigneCfg[2])-1);
    delete(LigneCfg[2],1,pos(#255,LigneCfg[2]));
    Vitesse := StrToInt(Tmp);

    Tmp := copy(LigneCfg[2],1,pos(#255,LigneCfg[2])-1);
    delete(LigneCfg[2],1,pos(#255,LigneCfg[2]));
    Parite := StrToInt(Tmp);

    Tmp := copy(LigneCfg[2],1,pos(#255,LigneCfg[2])-1);
    delete(LigneCfg[2],1,pos(#255,LigneCfg[2]));
    BitDonnee := StrToInt(Tmp);

    Tmp := copy(LigneCfg[2],1,pos(#255,LigneCfg[2])-1);
    delete(LigneCfg[2],1,pos(#255,LigneCfg[2]));
    BitStop := StrToInt(Tmp);

    Tmp := copy(LigneCfg[2],1,pos(#255,LigneCfg[2])-1);
    delete(LigneCfg[2],1,pos(#255,LigneCfg[2]));
    Protocole := StrToInt(Tmp);

    Tmp := copy(LigneCfg[2],1,pos(#255,LigneCfg[2])-1);
    delete(LigneCfg[2],1,pos(#255,LigneCfg[2]));
    NbLigSupp := StrToInt(Tmp);

    Tmp := copy(LigneCfg[2],1,pos(#255,LigneCfg[2])-1);
    delete(LigneCfg[2],1,pos(#255,LigneCfg[2]));
    CarRecherche := Tmp;

    Tmp := copy(LigneCfg[2],1,pos(#255,LigneCfg[2])-1);
    delete(LigneCfg[2],1,pos(#255,LigneCfg[2]));
    CarSupp := Tmp;

    Tmp := copy(LigneCfg[2],1,pos(#255,LigneCfg[2])-1);
    delete(LigneCfg[2],1,pos(#255,LigneCfg[2]));
    Codage := StrToInt(Tmp);

    Tmp := copy(LigneCfg[2],1,pos(#255,LigneCfg[2])-1);
    delete(LigneCfg[2],1,pos(#255,LigneCfg[2]));
    DelaiCar := StrToInt(Tmp);

    Tmp := copy(LigneCfg[2],1,pos(#255,LigneCfg[2])-1);
    delete(LigneCfg[2],1,pos(#255,LigneCfg[2]));
    DelaiLigne := StrToInt(Tmp);


    AdrFic := LigneCfg[3];
    if not RepExiste(AdrFic) then AdrFic := RepPrg;

    Tmp := copy(LigneCfg[4],1,pos(#255,LigneCfg[4])-1);
    delete(LigneCfg[4],1,pos(#255,LigneCfg[4]));
    FicType := Tmp;

    for N := 1 to 4 do
      with Serie[N] do
      Begin
        Tmp := copy(LigneCfg[4],1,pos(#255,LigneCfg[4])-1);
        delete(LigneCfg[4],1,pos(#255,LigneCfg[4]));
        Adresse := StrToInt(Tmp);
        Tmp := copy(LigneCfg[4],1,pos(#255,LigneCfg[4])-1);
        delete(LigneCfg[4],1,pos(#255,LigneCfg[4]));
        Irq := StrToInt(Tmp);
      End;
  End;
End;

{}

Procedure LitConfig(Nom : Str20);

Var
  N             : byte;
  FichierConfig : text;
  Ligne         : Str80;

Begin
  assign(FichierConfig,NomFicConfig);
  settextbuf(FichierConfig,Buffer);
  reset(FichierConfig);
  readln(FichierConfig,Ligne);
  while not eof(FichierConfig) do
  Begin
    readln(FichierConfig,Ligne);
    if Ligne = Nom then
    Begin
      LigneCfg[1] := Ligne;
      for N := 2 to 4 do readln(FichierConfig,LigneCfg[N]);
      DecrypteLignes;
    End
    else for N := 1 to 3 do readln(FichierConfig,Ligne);
  End;
  close(FichierConfig);
End;

{}

Procedure LitConfigDefaut;

Var
  N             : integer;
  FichierConfig : text;
  Ligne         : Str80;

Begin
  NbConfig := 0;
  assign(FichierConfig,NomFicConfig);
  settextbuf(FichierConfig,Buffer);
  reset(FichierConfig);
  readln(FichierConfig,Ligne);
  CfgParDefaut := Ligne;
  while not eof(FichierConfig) do
  Begin
    readln(FichierConfig,Ligne);
    inc(NbConfig);
    new(ListeConfig[NbConfig]);
    ListeConfig[NbConfig]^.Texte := Ligne;
    ListeConfig[NbConfig]^.Selectionne := false;
    if Ligne = CfgParDefaut then
    Begin
      LigneCfg[1] := Ligne;
      for N := 2 to 4 do readln(FichierConfig,LigneCfg[N]);
      DecrypteLignes;
    End
    else
    for N := 2 to 4 do readln(FichierConfig,Ligne);
  End;
  close(FichierConfig);
  for N := (NbConfig + 1) to MaxChoix do
  Begin
    new(ListeConfig[N]);
    ListeConfig[N]^.Texte := '';
    ListeConfig[N]^.Selectionne := false;
  End;
  ChangeConfigDsMenu;
End;

{}

Procedure ChangeFichierConfig(LaConfig : Str20;Change : boolean);

Var
  N             : byte;
  NomFichierBak : str80;
  FichierBak    : text;
  FichierConfig : text;
  Ligne         : Str80;

Begin
  NomFichierBak := ChangeExtension(NomFicConfig,'.BAK');
  if FicExiste(NomFichierBak) then
  Begin
    assign(FichierBak,NomFichierBak);
    erase(FichierBak);
  End;
  if FicExiste(NomFicConfig) then
  Begin
    assign(FichierConfig,NomFicConfig);
    rename(FichierConfig,NomFichierBak);
  End;
  assign(FichierConfig,NomFicConfig);
  settextbuf(FichierConfig,Buffer);
  rewrite(FichierConfig);
  if FicExiste(NomFichierBak) then
  Begin
    assign(FichierBak,NomFichierBak);
    reset(FichierBak);
    readln(FichierBak,Ligne);   (* Config par defaut *)
    writeln(FichierConfig,Ligne);
    while not eof(FichierBak) do
    Begin
      readln(FichierBak,Ligne);
      if Ligne = LaConfig then
      Begin
        for N := 1 to 3 do readln(FichierBak,Ligne);
        if Change then
        Begin
          ConstruitLignes;
          for N := 1 to 4 do writeln(FichierConfig,LigneCfg[N]);
        End;
      End
      else
      Begin
        writeln(FichierConfig,Ligne);
        for N := 1 to 3 do
        Begin
          readln(FichierBak,Ligne);
          writeln(FichierConfig,Ligne);
        End;
      End;
    End;
    close(FichierBak);
  End;
  close(FichierConfig);
End;

{}

Procedure EcritFichierConfig;

Var
  N             : byte;
  NomFichierBak : str80;
  FichierBak    : text;
  FichierConfig : text;
  Ligne         : Str80;

Begin
  NomFichierBak := ChangeExtension(NomFicConfig,'.BAK');
  if FicExiste(NomFichierBak) then
  Begin
    assign(FichierBak,NomFichierBak);
    erase(FichierBak);
  End;
  if FicExiste(NomFicConfig) then
  Begin
    assign(FichierConfig,NomFicConfig);
    rename(FichierConfig,NomFichierBak);
  End;
  assign(FichierConfig,NomFicConfig);
  settextbuf(FichierConfig,Buffer);
  rewrite(FichierConfig);
  if FicExiste(NomFichierBak) then
  Begin
    assign(FichierBak,NomFichierBak);
    reset(FichierBak);
    while not eof(FichierBak) do
    Begin
      readln(FichierBak,Ligne);
      writeln(FichierConfig,Ligne);
    End;
    close(FichierBak);
  End
  else
  Begin
    writeln(FichierConfig,ConfigActuelle.Nom);
    SelectFilsMenuTx(Menu,MnuConfiguration,OuvreCfg);
    SelectFilsMenuTx(Menu,MnuConfiguration,SauverCfg);
    SelectFilsMenuTx(Menu,MnuConfiguration,ParDefautCfg);
    SelectFilsMenuTx(Menu,MnuConfiguration,SupprimerCfg);
  End;
  ConstruitLignes;
  for N := 1 to 4 do writeln(FichierConfig,LigneCfg[N]);
  close(FichierConfig);
  inc(NbConfig);
  ListeConfig[NbConfig]^.Texte := LigneCfg[1];
End;

{}

Procedure SauverConfigSous;

Var
  LeCar  : char;
  Ok     : boolean;
  NomTmp : Str20;
  N      : byte;

Begin
  UneChaine := 'NONAME';
  repeat
    Ok := true;
    with Dialog do
    Begin
      X := 0;
      Y := 0;
      Tip := Ombre2;
      Titre := ' ' + Msg[79]^ + ' ';
    End;
    LeCar := BoiteChaineTx(Dialog,20,false);
    if LeCar = CarReturn then
    Begin
      NomTmp := Majuscules(Compresse(UneChaine));
      for N := 1 to NbConfig do
        if ListeConfig[N]^.Texte = NomTmp then Ok := false;
      if Ok then
      Begin
        ConfigActuelle.Nom := NomTmp;
        EcritFichierConfig;
        ChangeConfigDsMenu;
      End
      else
      Begin
        Dialog.Titre := ' ' + Msg[81]^ + ' ';
        LeCar := BoiteBoutTx(Dialog,' '+Msg[74]^+' ',' '+Msg[73]^+' ');
        if LeCar = '2' then
        Begin
          ConfigActuelle.Nom := NomTmp;
          ChangeFichierConfig(ConfigActuelle.Nom,true);
          ChangeConfigDsMenu;
          Ok := true;
        End;
      End;
    End;
  until Ok;
End;

{}

Procedure OuvreConfig;

Var
  LeCar     : char;
  ChoixCtrl : ChoixCtrlRecTx;

Begin
  with Dialog do
  Begin
    X := 0;
    Y := 0;
    Tip := Ombre2;
    Titre := ' ' + Msg[80]^ + ' ';
  End;
  with ChoixCtrl do
  Begin
    Pos        := PosDsChoix;
    MaxVisible := 10;
    Multiple   := false;
    EnMaj      := true;
    Trie       := Ascendant;
    Ascenseur  := true;
  End;
  LeCar := BoiteChoixCtrlTx(Dialog,ChoixCtrl,ListeConfig,false);
  PosDsChoix := ChoixCtrl.Pos;
  ListeConfig[PosDsChoix]^.Selectionne := false;
  if LeCar = CarReturn then
  Begin
    LitConfig(ListeConfig[PosDsChoix]^.Texte);
    ChangeConfigDsMenu;
  End;
End;

{}

Procedure EcritFichierConfigDefaut;

Var
  N             : byte;
  NomFichierBak : str80;
  FichierBak    : text;
  FichierConfig : text;
  Ligne         : Str80;

Begin
  NomFichierBak := ChangeExtension(NomFicConfig,'.BAK');
  if FicExiste(NomFichierBak) then
  Begin
    assign(FichierBak,NomFichierBak);
    erase(FichierBak);
  End;
  if FicExiste(NomFicConfig) then
  Begin
    assign(FichierConfig,NomFicConfig);
    rename(FichierConfig,NomFichierBak);
  End;
  assign(FichierConfig,NomFicConfig);
  settextbuf(FichierConfig,Buffer);
  rewrite(FichierConfig);
  assign(FichierBak,NomFichierBak);
  reset(FichierBak);
  readln(FichierBak,Ligne);
  writeln(FichierConfig,ConfigActuelle.Nom);
  while not eof(FichierBak) do
  Begin
    readln(FichierBak,Ligne);
    writeln(FichierConfig,Ligne);
    if Ligne = ConfigActuelle.Nom then
    Begin
      LigneCfg[1] := Ligne;
      for N := 2 to 4 do
      Begin
        readln(FichierBak,LigneCfg[N]);
        writeln(FichierConfig,LigneCfg[N]);
      End;
    End
    else
    for N := 1 to 3 do
    Begin
      readln(FichierBak,Ligne);
      writeln(FichierConfig,Ligne);
    End;
  End;
  close(FichierBak);
  close(FichierConfig);
  DecrypteLignes;
End;

{}

Procedure ChangeConfigDefaut;

Var
  LeCar     : char;
  ChoixCtrl : ChoixCtrlRecTx;

Begin
  with Dialog do
  Begin
    X := 0;
    Y := 0;
    Tip := Ombre2;
    Titre := ' ' + Msg[80]^ + ' ';
  End;
  with ChoixCtrl do
  Begin
    Pos        := PosDsChoix;
    MaxVisible := 10;
    Multiple   := false;
    EnMaj      := false;
    Trie       := Ascendant;
    Ascenseur  := true;
  End;
  LeCar := BoiteChoixCtrlTx(Dialog,ChoixCtrl,ListeConfig,false);
  PosDsChoix := ChoixCtrl.Pos;
  ListeConfig[PosDsChoix]^.Selectionne := false;
  if LeCar = CarReturn then
  Begin
    CfgParDefaut := ListeConfig[PosDsChoix]^.Texte;
    ConfigActuelle.Nom := CfgParDefaut;
    EcritFichierConfigDefaut;
    ChangeConfigDsMenu;
  End;
End;

{}

Procedure AlarmeSuppCfg;

Var
  UneAlarme : AlarmeRec;

Begin
  UneAlarme[1] := ' ' + Msg[86]^ + ' ';
  UneAlarme[2] := ' ' + Msg[87]^ + ' ';
  UneAlarme[3] := '';
  UneAlarme[4] := '';
  AlarmeTx(0,UneAlarme);
End;

{}

Procedure SupprimeConfig;

Var
  LeCar     : char;
  ChoixCtrl : ChoixCtrlRecTx;
  NomConfig : Str20;
  M,N       : byte;

Begin
  with Dialog do
  Begin
    X := 0;
    Y := 0;
    Tip := Ombre2;
    Titre := ' ' + Msg[85]^ + ' ';
  End;
  with ChoixCtrl do
  Begin
    Pos        := PosDsChoix;
    MaxVisible := 10;
    Multiple   := false;
    EnMaj      := true;
    Trie       := Ascendant;
    Ascenseur  := true;
  End;
  repeat
    LeCar := BoiteChoixCtrlTx(Dialog,ChoixCtrl,ListeConfig,false);
    PosDsChoix := ChoixCtrl.Pos;
    ListeConfig[PosDsChoix]^.Selectionne := false;
    if LeCar = CarReturn then
      if (ListeConfig[PosDsChoix]^.Texte = CfgParDefaut) or
         (ListeConfig[PosDsChoix]^.Texte =ConfigActuelle.Nom) then
        Begin
          AlarmeSuppCfg;
          LeCar := #255;
        End;
  until LeCar in [AltX,CarEsc,CarReturn];
  if LeCar = CarReturn then
  Begin
    NomConfig := ListeConfig[PosDsChoix]^.Texte;
    M := 1;
    while ListeConfig[M]^.Texte <> NomConfig do inc(M);
    if M <> NbConfig then
    Begin
      inc(M);
      for N := M to NbConfig do
        ListeConfig[N - 1]^.Texte := ListeConfig[N]^.Texte;
    End
    else N := M;
    ListeConfig[N]^.Texte := '';
    dec(NbConfig);
    ChangeFichierConfig(NomConfig,false);
  End;
End;

{}

Begin
  NbConfig := 0;
  PosDsChoix := 1;
End.