{

                            RS232   Version 3.0

                         Creation Alain JAFFRE 1996

  ͸
                 Programme ecrit pour TURBO PASCAL 7.0                    
                                                                          
                             Alain JAFFRE                                 
  ;

}

Program RS232;

{$I RSComp.Pas}

Uses Crt,AJCOUL,AJGLOB,AJSOURIS,AJGENTX,AJFTRTX,AJMENUTX,
     RSGlob,RsConfig,RsVisu,RsImp,RsEmRe;

{}

Var
  CarMenu    : char;
  SourisMenu : PosRec;

{}

Procedure InitSoft;

Begin
  with Soft do
  Begin
    Nom     := 'Transmission RS232';
    Version := 'Version 3.0';
    Info1   := '22 Mars 1996';
    Info2   := '(c) Alain JAFFRE';
  End;
  with Soft do writeln(Nom,'   ',Version,'   ',Info1,'   ' ,Info2);
  CacheCurseurTx;
  RazSouris;
  SourisUtil := LaSouris.Existe;
  Sortie := false;

  FondEcranTx('',GrisClair,Bleu);
  AfficheLigneAideTx(false);
  MontreSouris;
End;

{}

Procedure InitMenu;

Var
  NomFicMsg : NomRep;
  Nul       : byte;

Begin
  NomFicMsg := paramstr(0);
  NomFicMsg := ChangeExtension(NomFicMsg,'.MSG');
  NomFicConfig := ChangeExtension(NomFicMsg,'.CFG');
  if LitFichierMsg(NomFicMsg,Msg) then
  Begin
    InitMenuTx(Menu);
    AideMenu := AideStd + '  ' + Msg[200]^;

    MnuFichier := AjoutePereTx(Menu,Msg[1]^,Msg[160]^);
    MnuEmission := AjoutePereTx(Menu,Msg[2]^,Msg[161]^);
    MnuReception := AjoutePereTx(Menu,Msg[3]^,Msg[162]^);
    MnuConfiguration := AjoutePereTx(Menu,Msg[4]^,Msg[163]^);
    MnuAPropos := AjoutePereTx(Menu,Msg[5]^,Msg[164]^);

    FctOuvrir := AjouteFilsTx(Menu,MnuFichier,Msg[10]^,Msg[165]^,true);
    FctSauver := AjouteFilsTx(Menu,MnuFichier,Msg[11]^,Msg[166]^,false);
    FctSauverSous := AjouteFilsTx(Menu,MnuFichier,Msg[12]^,Msg[167]^,false);
    Nul := AjouteFilsTx(Menu,MnuFichier,Msg[13]^,'',true);
    FctVoir := AjouteFilsTx(Menu,MnuFichier,Msg[14]^,Msg[168]^,false);
    FctImprimer := AjouteFilsTx(Menu,MnuFichier,Msg[15]^,Msg[169]^,false);
    Nul := AjouteFilsTx(Menu,MnuFichier,Msg[16]^,'',true);
    FctQuitter := AjouteFilsTx(Menu,MnuFichier,Msg[17]^,Msg[170]^,true);

    CfgLiaison := AjouteFilsTx(Menu,MnuConfiguration,Msg[20]^,Msg[171]^,true);
    CfgDonnees := AjouteFilsTx(Menu,MnuConfiguration,Msg[21]^,Msg[172]^,true);
    CfgFichier := AjouteFilsTx(Menu,MnuConfiguration,Msg[22]^,Msg[173]^,true);
    CfgMateriel := AjouteFilsTx(Menu,MnuConfiguration,Msg[23]^,Msg[174]^,true);
    Nul := AjouteFilsTx(Menu,MnuConfiguration,Msg[24]^,'',true);
    OuvreCfg := AjouteFilsTx(Menu,MnuConfiguration,Msg[25]^,Msg[175]^,true);
    SauverCfg := AjouteFilsTx(Menu,MnuConfiguration,Msg[26]^,Msg[176]^,true);
    SauverSousCfg := AjouteFilsTx(Menu,MnuConfiguration,Msg[27]^,Msg[177]^,true);
    ParDefautCfg := AjouteFilsTx(Menu,MnuConfiguration,Msg[28]^,Msg[178]^,true);
    SupprimerCfg := AjouteFilsTx(Menu,MnuConfiguration,Msg[29]^,Msg[179]^,true);

    FctAPropos := AjouteFilsTx(Menu,MnuAPropos,Msg[30]^,Msg[197]^,true);
    FctCableStd := AjouteFilsTx(Menu,MnuAPropos,Msg[31]^,Msg[198]^,true);
    FctCableCtsRts := AjouteFilsTx(Menu,MnuAPropos,Msg[32]^,Msg[199]^,true);

    AfficheBarreMenuTx(Menu);

    LigneAide.Texte := AideMenu;
    AfficheLigneAideTx(True);
  End
  else Sortie := true;
End;

{}

Procedure InitVariables;

Begin
  FichierOuvert := '';
  ListeActuelle := 1;
  NbDeCar       := 0;
  NbDeLigne     := 0;
  AffiStandard  := true;
  if FicExiste(NomFicConfig) then LitConfigDefaut
  else
  Begin
    DeSelectFilsMenuTx(Menu,MnuConfiguration,OuvreCfg);
    DeSelectFilsMenuTx(Menu,MnuConfiguration,SauverCfg);
    DeSelectFilsMenuTx(Menu,MnuConfiguration,ParDefautCfg);
    DeSelectFilsMenuTx(Menu,MnuConfiguration,SupprimerCfg);
    InitConfig;
  End;
End;

{}

Procedure MessageInitialisation(Marche : boolean);

Var
  Long,N : byte;
  Texte : Str80;

Begin
  Long := length(Msg[157]^) + 2;
  Texte := '';
  if Marche then for N := 1 to Long do Texte := Texte + ' '
            else for N := 1 to Long do Texte := Texte + #176;
  CacheSouris;
  CoulFondTx(GrisClair);
  CoulEncreTx(Bleu);
  CentreTexteTx(11,Texte);
  if Marche then CentreTexteTx(12,' ' + Msg[157]^ + ' ')
            else CentreTexteTx(12,Texte);
  CentreTexteTx(13,Texte);
  MontreSouris;
End;

{}

Procedure GereFichier;

Begin
  if LeFils = FctOuvrir then
  Begin
    UnFichier := OuvreFichier;
    if UnFichier <> '' then LitFichier(UnFichier);
  End;
  if LeFils = FctSauver then EcritFichier(FichierOuvert);
  if LeFils = FctSauverSous then
  Begin
    UnFichier := SauveFichier;
    if UnFichier <> '' then EcritFichier(UnFichier);
    FichierOuvert := UnFichier;
  End;
  if LeFils = FctVoir then Visualise;
  if LeFils = FctImprimer then Impression;
  if LeFils = FctQuitter then Sortie := true;

End;

{}

Procedure GereEmission;

Begin
  if NbDeCar = 0 then
  Begin
    UnFichier := OuvreFichier;
    if UnFichier <> '' then
    Begin
      LitFichier(UnFichier);
      Emission;
    End;
  End
  else Emission;
End;

{}

Procedure GereConfiguration;

Begin
  if LeFils = CfgLiaison then ChoixLiaison;
  if LeFils = CfgDonnees then ChoixDonnee;
  if LeFils = CfgFichier then ChoixFichier;
  if LeFils = CfgMateriel then ChoixMateriel;
  if LeFils = OuvreCfg then OuvreConfig;
  if LeFils = SauverCfg then ChangeFichierConfig(ConfigActuelle.Nom,true);
  if LeFils = SauverSousCfg then SauverConfigSous;
  if LeFils = ParDefautCfg then ChangeConfigDefaut;
  if LeFils = SupprimerCfg then SupprimeConfig;
End;

{}

Procedure GereAide;

Begin
  if LeFils = FctAPropos then BoiteAProposTx;
  if LeFils = FctCableStd then CablageStandard;
  if LeFils = FctCableCtsRts then CablageCtsRts;
End;

{}

Procedure GereRS232;

Begin
  if LePere = MnuAPropos then GereAide;
  if LePere = MnuFichier then GereFichier;
  if LePere = MnuEmission then GereEmission;
  if LePere = MnuReception then Reception;
  if LePere = MnuConfiguration then GereConfiguration;
End;

{}

Begin
  InitSoft;
  InitMenu;
  InitVariables;
  MessageInitialisation(true);
  InitListes;
  MessageInitialisation(false);
  while not Sortie do
  Begin
    LePere := 0;
    LeFils := 0;
    if AttendActionTx(CarMenu,SourisMenu) then
    Begin
      DelaiSouris(TempoSouris);
      if SourisDsBarreMenuTx(Menu,SourisMenu) then
      Begin
        GereMenuTx(Menu,LePere,LeFils);
        GereRs232;
      End;
    End
    else
    Begin
      if CarDsBarreMenuTx(Menu,CarMenu) then
      Begin
        GereMenuTx(Menu,LePere,LeFils);
        GereRs232;
      End;
      if ToucheFct then
      Begin
        case CarMenu of
          ShiftF1 : BoiteAProposTx;
          AltX    : Sortie := true;
          AltF10  : InfoPosition;
          F2      : if FichierOuvert <> '' then EcritFichier(FichierOuvert);
          F3      : Begin
                      UnFichier := OuvreFichier;
                      if UnFichier <> '' then LitFichier(UnFichier);
                    End;
          F6      : if NbDeCar <> 0 then Visualise;
          F10     : Begin
                      GereMenuTx(Menu,LePere,LeFils);
                      GereRs232;
                    End;
        end;
      End;
    End;
  End;
  FinProgramme;
End.