unit Main;

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
//             Application for testing print preview componet for richedit //
//  2005         Alain JAFFRE               http://jack.r.free.fr          //
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
//                          Update history                                 //
//                                                                         //
//  21/07/2005: First properly working release                             //
//                                                                         //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

{***************************************************************************}
{ Ce logiciel est un logiciel libre. Vous pouvez le diffuser et/ou le       }
{ modifier suivant les termes de la GNU General Public License telle que    }
{ publie par la Free Software Foundation, soit la version 2 de cette        }
{ license, soit ( votre convenance) une version ultrieure.                }
{                                                                           }
{ Ce programme est diffus dans l'espoir qu'il sera utile, mais SANS AUCUNE }
{ GARANTIE, sans mme une garantie implicite de COMMERCIALISABILITE ou      }
{ d'ADEQUATION A UN USAGE PARTICULIER. Voyez la GNU General Public License  }
{ pour plus de dtails.                                                     }
{                                                                           }
{ Vous devriez avoir reu une copie de la GNU General Public License avec   }
{ ce programme, sinon, veuillez crire  la Free Software Foundation, Inc., }
{ 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.                  }
{***************************************************************************}

{***************************************************************************}
{ This program is free software. You can redistribute it and/or modify it   }
{ under the terms of the GNU Public License as published by the             }
{ Free Software Foundation, either version 2 of the license, or             }
{ (at your option) any later version.                                       }
{                                                                           }
{ This program is distributed in the hope it will be useful, but WITHOUT    }
{ ANY WARRANTY, without even the implied warranty of MERCHANTABILITY or     }
{ FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for  }
{ more details.                                                             }
{                                                                           }
{ You should have received a copy of the GNU General Public License along   }
{ with this program, if not, write to the Free Software Foundation, Inc.,   }
{ 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.                  }
{***************************************************************************}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, ComCtrls,
  RichEditPrintPreview, Spin, ActnList, ImgList, ToolWin, Menus, Buttons;

type
  TFrmMain = class(TForm)
    RichEdit1: TRichEdit;
    IlPreview: TImageList;
    AlPreview: TActionList;
    ActFirstPage: TAction;
    ActPreviousPage: TAction;
    ActNextPage: TAction;
    ActLastPage: TAction;
    ActZoomMinus: TAction;
    ActZoomPlus: TAction;
    ActWholePage: TAction;
    ActShowMargins: TAction;
    ActPrint: TAction;
    ActPageWidth: TAction;
    PrintDlg: TPrintDialog;
    PMnuZoom: TPopupMenu;
    MnuWholePage: TMenuItem;
    MnuPageWidth: TMenuItem;
    N1: TMenuItem;
    Mnu25percent: TMenuItem;
    Mnu50percent: TMenuItem;
    Mnu100percent: TMenuItem;
    Mnu200percent: TMenuItem;
    Mnu400percent: TMenuItem;
    PnlButton: TPanel;
    BtnLoadFile: TButton;
    BtnBuild: TButton;
    OpenDlg: TOpenDialog;
    Splitter: TSplitter;
    ActScalePage: TAction;
    Mnu75percent: TMenuItem;
    Mnu150percent: TMenuItem;
    Mnu125percent: TMenuItem;
    Mnu175percent: TMenuItem;
    Mnu300percent: TMenuItem;
    PgCtrlPreview: TPageControl;
    TShPreview: TTabSheet;
    TShConfig: TTabSheet;
    SbrPreview: TStatusBar;
    TBarNavigation: TToolBar;
    TBtnSpacer1: TToolButton;
    TBtnFirstPage: TToolButton;
    TBtnPreviousPage: TToolButton;
    TBtnNextPage: TToolButton;
    TBtnLastPage: TToolButton;
    TBtnSpacer2: TToolButton;
    TBtnZoomMinus: TToolButton;
    TBtnZoomPlus: TToolButton;
    TBtnWholePage: TToolButton;
    TBtnPageWidth: TToolButton;
    TBtnSpacer3: TToolButton;
    TBtnShowMargins: TToolButton;
    TBtnPrint: TToolButton;
    GbxMargins: TGroupBox;
    LblMarginTop: TLabel;
    LblBottomMargin: TLabel;
    EdtTopMargin: TEdit;
    EdtBottomMargin: TEdit;
    LblLeftMargin: TLabel;
    EdtLeftMargin: TEdit;
    EdtRightMargin: TEdit;
    LblRightMargin: TLabel;
    EdtHeaderHeight: TEdit;
    LblHeaderMargin: TLabel;
    LblFooterMargin: TLabel;
    EdtFooterHeight: TEdit;
    RgpUnit: TRadioGroup;
    FontDlg: TFontDialog;
    GbxHeader: TGroupBox;
    LblHeaderLeft: TLabel;
    EdtHeaderLeft: TEdit;
    LblHeaderCenter: TLabel;
    EdtHeaderCenter: TEdit;
    EdtHeaderRight: TEdit;
    LblHeaderRight: TLabel;
    SbtnHeaderFont: TSpeedButton;
    GbxFooter: TGroupBox;
    LblFooterLeft: TLabel;
    LblFooterCenter: TLabel;
    LblFooterRight: TLabel;
    SBtnFooterFont: TSpeedButton;
    EdtFooterLeft: TEdit;
    EdtFooterCenter: TEdit;
    EdtFooterRight: TEdit;
    TBtnSpacer4: TToolButton;
    TBarZoom: TTrackBar;
    // form
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    // action
    procedure ActFirstPageExecute(Sender: TObject);
    procedure ActPreviousPageExecute(Sender: TObject);
    procedure ActNextPageExecute(Sender: TObject);
    procedure ActLastPageExecute(Sender: TObject);
    procedure ActZoomMinusExecute(Sender: TObject);
    procedure ActZoomPlusExecute(Sender: TObject);
    procedure ActWholePageExecute(Sender: TObject);
    procedure ActPageWidthExecute(Sender: TObject);
    procedure ActScalePageExecute(Sender: TObject);
    procedure ActShowMarginsExecute(Sender: TObject);
    procedure ActPrintExecute(Sender: TObject);
    // event
    procedure BtnLoadFileClick(Sender: TObject);
    procedure BtnBuildClick(Sender: TObject);
    procedure PgCtrlPreviewChange(Sender: TObject);
    procedure RgpUnitClick(Sender: TObject);
    procedure EdtTopMarginExit(Sender: TObject);
    procedure EdtLeftMarginExit(Sender: TObject);
    procedure EdtRightMarginExit(Sender: TObject);
    procedure EdtBottomMarginExit(Sender: TObject);
    procedure EdtHeaderHeightExit(Sender: TObject);
    procedure EdtFooterHeightExit(Sender: TObject);
    procedure SbtnHeaderFontClick(Sender: TObject);
    procedure SBtnFooterFontClick(Sender: TObject);
    procedure TBarZoomChange(Sender: TObject);
    procedure PreviewScaleChange(Sender: TObject; Scale: single);
    procedure Printing(Sender: TObject; Page: integer);

  private
    { Dclarations prives }
    RichEditPrintPreview: TRichEditPrintPreview;
    UpdatingTrackBarZoom: boolean;

    procedure UpdatePreviewUI;
    procedure UpdateEdtMargins;
    procedure UpdateEdtHeaderFooter;

  public
    { Dclarations publiques }
  end;

var
  FrmMain: TFrmMain;

implementation

{$R *.dfm}

uses RichEdit;

{------------------------------------------------------------------------------}
{ Form                                                                         }
{------------------------------------------------------------------------------}

procedure TFrmMain.FormCreate(Sender: TObject);
begin
  RichEditPrintPreview:= TRichEditPrintPreview.Create(self);
  with RichEditPrintPreview do
  begin
    Parent:= TShPreview;
    Align:= alClient;
    RichEdit:= RichEdit1;
    ShowMargin:= true;
    MarginInMM:= true;
    TopMargin:= 10;
    BottomMargin:= 20;
    LeftMargin:= 15;
    RightMargin:= 5;
    HeaderHeight:= 12;
    FooterHeight:= 6;
    SetHeaderText('Haut gauche', '[TITLE]', 'Haut droit');
    SetFooterText('Printed on: [Y]/[M]/[D]', 'at: [h]:[n]:[s]', 'Page [PAGE]/[PAGES]');
  end;
  ActShowMargins.Checked:= RichEditPrintPreview.ShowMargin;
  PgCtrlPreview.ActivePageIndex:= 0;
  UpdatingTrackBarZoom:= false;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.FormShow(Sender: TObject);
begin
  RichEditPrintPreview.OnScaleChange:= PreviewScaleChange;
  RichEditPrintPreview.OnPrint:= Printing;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  RichEditPrintPreview.Free;
end;

{------------------------------------------------------------------------------}
{ Preview actions                                                              }
{------------------------------------------------------------------------------}

procedure TFrmMain.ActFirstPageExecute(Sender: TObject);
// Preview first page
begin
  RichEditPrintPreview.FirstPage;
  UpdatePreviewUI;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.ActPreviousPageExecute(Sender: TObject);
// Preview previous page
begin
  RichEditPrintPreview.PreviousPage;
  UpdatePreviewUI;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.ActNextPageExecute(Sender: TObject);
// Preview next page
begin
  RichEditPrintPreview.NextPage;
  UpdatePreviewUI;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.ActLastPageExecute(Sender: TObject);
// Preview last page
begin
  RichEditPrintPreview.LastPage;
  UpdatePreviewUI;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.ActZoomMinusExecute(Sender: TObject);
// Reduce zoom (zoom out)
begin
  RichEditPrintPreview.Scale:= RichEditPrintPreview.Scale / 2;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.ActZoomPlusExecute(Sender: TObject);
// Increase zoom (zoom in)
begin
  RichEditPrintPreview.Scale:= RichEditPrintPreview.Scale * 2;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.ActWholePageExecute(Sender: TObject);
// Change zoom to display whole page
begin
  RichEditPrintPreview.ScaleMode:= smWholePage;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.ActPageWidthExecute(Sender: TObject);
// Change zoom to display page width
begin
  RichEditPrintPreview.ScaleMode:= smPageWidth;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.ActScalePageExecute(Sender: TObject);
// Change zoom to selected scale
begin
  with Sender as TMenuItem do
  begin
    RichEditPrintPreview.ScaleMode:= smScaled;
    RichEditPrintPreview.Scale:= Tag / 100;
  end;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.ActShowMarginsExecute(Sender: TObject);
// Show margins
begin
  ActShowMargins.Checked:= not ActShowMargins.Checked;
  RichEditPrintPreview.ShowMargin:= ActShowMargins.Checked;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.ActPrintExecute(Sender: TObject);
// Print
var
  NbOfPages: integer;
  TmpRichEdit: TRichEdit;
begin
  with PrintDlg do
  begin
    // General
    Options:= [];
    PrintRange:= prAllPages;
    // If more then one page
    NbOfPages:= RichEditPrintPreview.NumberOfPages;
    if NbOfPages > 1 then
    begin
      Options:= Options + [poPageNums];
      FromPage:= 1;
      MinPage:= 1;
      ToPage:= NbOfPages;
      MaxPage:= ToPage;
    end;
    // If something is selected
    if RichEdit1.SelLength > 0 then
    begin
      Options:= Options + [poSelection];
      PrintRange:= prSelection;
    end;
  end;

  if PrintDlg.Execute then
  begin
    Screen.Cursor:= crHourGlass;
    RichEditPrintPreview.Reset;
    case PrintDlg.PrintRange of
      prAllPages  : RichEditPrintPreview.Print(1,-1);
      prSelection : begin
                      // Copy selected text
                      TmpRichEdit:= TRichEdit.Create(self);
                      TmpRichEdit.Parent:= Self;
                      TmpRichEdit.Visible:= false;
                      TmpRichEdit.Font.Assign(RichEdit1.Font);
                      TmpRichEdit.WordWrap:= RichEdit1.WordWrap;
                      TmpRichEdit.Lines.Add(RichEdit1.SelText);
                      // Print
                      RichEditPrintPreview.RichEdit:= TmpRichEdit;
                      RichEditPrintPreview.Reset;
                      RichEditPrintPreview.Print(1,-1);
                      // Get back
                      RichEditPrintPreview.RichEdit:= RichEdit1;
                      RichEditPrintPreview.Reset;
                      TmpRichEdit.Free;
                    end;
    else // prPageNums
      RichEditPrintPreview.Print(PrintDlg.FromPage,PrintDlg.ToPage);
    end;
    Screen.Cursor:= crDefault;
    SbrPreview.Panels[2].Text:= '';
  end;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.BtnLoadFileClick(Sender: TObject);
begin
  if OpenDlg.Execute then
  begin
    RichEdit1.Lines.Clear;
    RichEdit1.Lines.LoadFromFile(OpenDlg.FileName);
    RichEditPrintPreview.PrintTitle:= ExtractFilename(OpenDlg.FileName);
    RichEditPrintPreview.Reset;
    RichEditPrintPreview.Display;
    UpdatePreviewUI;
  end;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.BtnBuildClick(Sender: TObject);
var
  N: integer;
  ScrollMessage:TWMVScroll;
begin
  with RichEdit1 do
  begin
    Lines.Clear;
    Lines.BeginUpdate;
    SelStart:= 0;
    SelText:= 'Start of the test ';
    for N:= 1 to 20000 do
      SelText:= chr(33 + (N mod 93)) + ' ';
    Lines.EndUpdate;
    // Move the caret back to first line
    SelStart:= Perform(EM_LINEINDEX,0,0);
    Perform(EM_SCROLLCARET,0,0);
    // Move the scroll bar to the top
    ScrollMessage.Msg:=WM_VScroll;
    ScrollMessage.ScrollCode:=SB_TOP;
    ScrollMessage.Pos:=0;
    Dispatch(ScrollMessage);
  end;
  RichEditPrintPreview.Reset;
  RichEditPrintPreview.Display;
  UpdatePreviewUI;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.PgCtrlPreviewChange(Sender: TObject);
begin
  if PgCtrlPreview.ActivePage = TShPreview then
  begin
    // Done before display preview
    with RichEditPrintPreview do
    begin
      SetHeaderText(EdtHeaderLeft.Text,EdtHeaderCenter.Text,EdtHeaderRight.Text);
      SetFooterText(EdtFooterLeft.Text,EdtFooterCenter.Text,EdtFooterRight.Text);
      Display;
    end;
  end
  else
  begin
    // Done before display config
    UpdateEdtMargins;
    UpdateEdtHeaderFooter;
  end;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.RgpUnitClick(Sender: TObject);
begin
  RichEditPrintPreview.MarginInMM:= RgpUnit.ItemIndex = 0;
  UpdateEdtMargins;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.EdtHeaderHeightExit(Sender: TObject);
begin
  try
    RichEditPrintPreview.HeaderHeight:= StrToFloat(EdtHeaderHeight.Text);
  finally
    EdtHeaderHeight.Text:= FloatToStrF(RichEditPrintPreview.HeaderHeight, ffFixed, 10,3);
  end;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.EdtTopMarginExit(Sender: TObject);
begin
  try
    RichEditPrintPreview.TopMargin:= StrToFloat(EdtTopMargin.Text);
  finally
    EdtTopMargin.Text:= FloatToStrF(RichEditPrintPreview.TopMargin, ffFixed, 10,3);
  end;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.EdtLeftMarginExit(Sender: TObject);
begin
  try
    RichEditPrintPreview.LeftMargin:= StrToFloat(EdtLeftMargin.Text);
  finally
    EdtLeftMargin.Text:= FloatToStrF(RichEditPrintPreview.LeftMargin, ffFixed, 10,3);
  end;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.EdtRightMarginExit(Sender: TObject);
begin
  try
    RichEditPrintPreview.RightMargin:= StrToFloat(EdtRightMargin.Text);
  finally
    EdtRightMargin.Text:= FloatToStrF(RichEditPrintPreview.RightMargin, ffFixed, 10,3);
  end;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.EdtBottomMarginExit(Sender: TObject);
begin
  try
    RichEditPrintPreview.BottomMargin:= StrToFloat(EdtBottomMargin.Text);
  finally
    EdtBottomMargin.Text:= FloatToStrF(RichEditPrintPreview.BottomMargin, ffFixed, 10,3);
  end;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.EdtFooterHeightExit(Sender: TObject);
begin
  try
    RichEditPrintPreview.FooterHeight:= StrToFloat(EdtFooterHeight.Text);
  finally
    EdtFooterHeight.Text:= FloatToStrF(RichEditPrintPreview.FooterHeight, ffFixed, 10,3);
  end;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.SbtnHeaderFontClick(Sender: TObject);
begin
  FontDlg.Font.Assign(RichEditPrintPreview.HeaderFont);
  if FontDlg.Execute then
  begin
    RichEditPrintPreview.HeaderFont.Assign(FontDlg.Font);
    EdtHeaderLeft.Font.Assign(FontDlg.Font);
    EdtHeaderCenter.Font.Assign(FontDlg.Font);
    EdtHeaderRight.Font.Assign(FontDlg.Font);
  end;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.SBtnFooterFontClick(Sender: TObject);
begin
  FontDlg.Font.Assign(RichEditPrintPreview.FooterFont);
  if FontDlg.Execute then
  begin
    RichEditPrintPreview.FooterFont.Assign(FontDlg.Font);
    EdtFooterLeft.Font.Assign(FontDlg.Font);
    EdtFooterCenter.Font.Assign(FontDlg.Font);
    EdtFooterRight.Font.Assign(FontDlg.Font);
  end;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.TBarZoomChange(Sender: TObject);
var
  AValue: single;
begin
  if not UpdatingTrackBarZoom then
  begin
    AValue:= TBarZoom.Position / 100;
    RichEditPrintPreview.ScaleMode:= smScaled;
    RichEditPrintPreview.Scale:= AValue;
  end;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.PreviewScaleChange(Sender: TObject; Scale: single);
begin
  SbrPreview.Panels[1].Text:= 'Scale ' + FloatToStrF(Scale,ffFixed, 10, 3);
  ActZoomMinus.Enabled:= Scale > RichEditPrintPreview.MinScale;
  ActZoomPlus.Enabled:= Scale < RichEditPrintPreview.MaxScale;
  UpdatingTrackBarZoom:= true;
  TBarZoom.Position:= round(Scale * 100);
  UpdatingTrackBarZoom:= false;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.Printing(Sender: TObject; Page: integer);
begin
  SbrPreview.Panels[2].Text:= 'Printing page ' + IntToStr(Page);
end;

{------------------------------------------------------------------------------}
{ Private                                                                      }
{------------------------------------------------------------------------------}

procedure TFrmMain.UpdatePreviewUI;
begin
  TBarNavigation.Visible:= true;
  // Page
  ActFirstPage.Enabled:= RichEditPrintPreview.CurrentPage > 1;
  ActPreviousPage.Enabled:= ActFirstPage.Enabled;
  ActNextPage.Enabled:=
    RichEditPrintPreview.CurrentPage < RichEditPrintPreview.NumberOfPages;
  ActLastPage.Enabled:= ActNextPage.Enabled;
  SbrPreview.SimplePanel:= false;
  SbrPreview.Panels[0].Text:= 'Page ' + IntToStr(RichEditPrintPreview.CurrentPage)
    + ' of ' + IntToStr(RichEditPrintPreview.NumberOfPages);
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.UpdateEdtMargins;
begin
  EdtHeaderHeight.Text:= FloatToStrF(RichEditPrintPreview.HeaderHeight, ffFixed, 10,3);
  EdtTopMargin.Text:= FloatToStrF(RichEditPrintPreview.TopMargin, ffFixed, 10,3);
  EdtLeftMargin.Text:= FloatToStrF(RichEditPrintPreview.LeftMargin, ffFixed, 10,3);
  EdtRightMargin.Text:= FloatToStrF(RichEditPrintPreview.RightMargin, ffFixed, 10,3);
  EdtBottomMargin.Text:= FloatToStrF(RichEditPrintPreview.BottomMargin, ffFixed, 10,3);
  EdtFooterHeight.Text:= FloatToStrF(RichEditPrintPreview.FooterHeight, ffFixed, 10,3);
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.UpdateEdtHeaderFooter;
var
  ALeftText: string;
  ACenterText: string;
  ARightText: string;
begin
  // Header
  RichEditPrintPreview.GetHeaderText(ALeftText, ACenterText, ARightText);
  EdtHeaderLeft.Text:= ALeftText;
  EdtHeaderCenter.Text:= ACenterText;
  EdtHeaderRight.Text:= ARightText;
  EdtHeaderLeft.Font.Assign(RichEditPrintPreview.HeaderFont);
  EdtHeaderCenter.Font.Assign(RichEditPrintPreview.HeaderFont);
  EdtHeaderRight.Font.Assign(RichEditPrintPreview.HeaderFont);
  // Footer
  RichEditPrintPreview.GetFooterText(ALeftText, ACenterText, ARightText);
  EdtFooterLeft.Text:= ALeftText;
  EdtFooterCenter.Text:= ACenterText;
  EdtFooterRight.Text:= ARightText;
  EdtFooterLeft.Font.Assign(RichEditPrintPreview.FooterFont);
  EdtFooterCenter.Font.Assign(RichEditPrintPreview.FooterFont);
  EdtFooterRight.Font.Assign(RichEditPrintPreview.FooterFont);
end;


end.
