<?php
{}
/* vim: set filetype=php encoding=utf-8 expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

// Time-stamp: <2009-01-16 16:41:41 alain>
// $Id:$ %

/****************************************************************************
 * That file is part of regexp_view project                                 *
 * Copyright (c) 2008 Alain JAFFRE (jack.r@free.fr) and contributors        *
 ****************************************************************************
 * This program is free software. You can redistribute it and/or modify it  *
 * under the terms of the GNU Public License as published by the            *
 * Free Software Foundation, either version 2 of the license, or            *
 * (at your option) any later version.                                      *
 *                                                                          *
 * This program is distributed in the hope it will be useful, but WITHOUT   *
 * ANY WARRANTY, without even the implied warranty of MERCHANTABILITY or    *
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for *
 * more details.                                                            *
 *                                                                          *
 * You should have received a copy of the GNU General Public License along  *
 * with this program, if not, write to the Free Software Foundation, Inc.,  *
 * 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.                 *
 ****************************************************************************/

/****************************************************************************
 * 20080816 version 0.1
 * 20090111 version 0.2
 *            Addition of more comment in code
 *            HTML explain that only captured parts are highlight
 *            Addition of PHP matches result
 *            Highlight all results the same way
 * 20090116   Addition of proper handling of UTF-8 by htmlentities
 ****************************************************************************/

$version = 0.2;

// error_reporting(E_ERROR | E_WARNING | E_PARSE | E_NOTICE);

/**
 * Highlight capturing part of a regexp
 *
 * @param	  string  regexp      Regexp to highlight
 * @param	  integer max_colors  Maximum number of color for highlighting
 */

function highlight_regexp($regexp, $max_colors) {
    $result = '';
    $max = mb_strlen($regexp);
    $catching = false;
    $i = 0;
    $color = 1;
    while ($i < $max) {
        // Look for opening parenthesis
        $tmp = '';
        while (($i < $max) && ($regexp[$i] !== '(')) {
            $tmp .= $regexp[$i];
            $i++;
        }
        $result .= htmlentities($tmp, ENT_QUOTES, 'UTF-8');

        // Find opening parenthesis
        $tmp = '';
        if (($i < $max) && ($regexp[$i] === '(')) {
            $code = mb_substr($regexp, $i, 3);
            if (!in_array($code, array('(?!', '(?:', '(?='))) {
                $result .= '<span class="b'.$color.'">';
                $color++;
                if ($color > $max_colors) {
                    $color = 1;
                }
                $catching = true;
            }
            $tmp .= $regexp[$i];
            $i++;
        }
        // Look for closing parenthesis
        while (($i < $max) && ($regexp[$i] !== ')')) {
            $tmp .= $regexp[$i];
            $i++;
        }
        $result .= htmlentities($tmp, ENT_QUOTES, 'UTF-8');

        // Find closing parenthesis
        if (($i < $max) && ($regexp[$i] === ')')) {
            $result .= htmlentities($regexp[$i], ENT_QUOTES, 'UTF-8');
            if ($catching) {
                $result .= '</span>';
                $catching = false;
            }
            $i++;
        }
    }
    return $result;
}

/**
 * Replace some special character like space, tab, newline
 * to produce clear html
 */

function replace_chars($source) {
    $result = htmlentities($source, ENT_QUOTES, 'UTF-8');
    $result = str_replace(' ', '&nbsp;', $result);
    $result = str_replace("\t", str_repeat('&nbsp;',4), $result);
    $result = str_replace("\n", '<br />', $result);
    return $result;
}

/**
 * Process regexp on source to get captured parts
 *
 * @param	  string  regexp      Regexp to use
 * @param	  string  source      Source to which apply the regexp
 * @param     boolean match_all   Did we use preg_match_all or only preg_match
 */

function process_source($regexp, $source, $match_all=true) {
    if ($match_all) {
        preg_match_all($regexp, $source, $matches, PREG_SET_ORDER);
    } else {
        preg_match($regexp, $source, $match);
        $matches[0] = $match;
    }
    return $matches;
}

/**
 * Highlight regexp captured part in source
 *
 * @param	  string  source      Source to which apply the regexp
 * @param     string  matches     Matches found by regexp
 * @param	  integer max_colors  Maximum number of color for highlighting
 */

function highlight_source($source, $matches, $max_colors) {
    if ($matches == '') {
        $result = replace_chars($source);
    } else {
        $result = '';

        foreach ($matches as $match) {
            $color = 1;
            $full_match = $match[0];
            $pos = mb_strpos($source, $full_match);
            // Take what we have before
            if ($pos > 0) {
                $result .= replace_chars(mb_substr($source,0,$pos));
                $source = mb_substr($source, $pos);
            }

            // Process matche parts
            $max = count($match);
            $i = 1;
            for ($i=1; $i < $max; $i++) {
                if (!empty($match[$i])) {
                    $pos = mb_strpos($full_match, $match[$i]);
                    // Take what we have before and is not catch
                    if ($pos > 0) {
                        $result .= replace_chars(mb_substr($full_match,0,$pos));
                        $full_match = mb_substr($full_match, $pos);
                    }
                }
                // Catch
                $result .= '<span class="b'.$color.'">';
                $color++;
                if ($color > $max_colors) {
                    $color = 1;
                }
                $result .= replace_chars($match[$i]).'</span>';;
                $full_match = mb_substr($full_match, mb_strlen($match[$i]));
            }
            // Put remaining not catch
            if ($full_match != '') {
                $result .= replace_chars($full_match);
                $full_match = '';
            }
            // Adjust source
            $source = mb_substr($source, mb_strlen($match[0]));

        }
        // Put remaining source
        if ($source != '') {
            $result .= replace_chars($source);
            $source = '';
        }
    }

    return $result;
}

/**
 * Format captured part
 *
 * @param     string  matches     Matches found by regexp
 * @param	  integer max_colors  Maximum number of color for highlighting
 */

function format_capture($matches, $max_colors) {
    $result = '';
    $i = 0;
    foreach ($matches as $match) {
        $color = 0;
        $result .= 'Array { <br \>'."\n";
        $result .= '&nbsp;&nbsp;['.$i.'] => Array {<br />'."\n";
        $j = 0;
        foreach ($match as $item) {
            $result .= '&nbsp;&nbsp;&nbsp;&nbsp;['.$j.'] => ';
            $result .= '<span class="b'.$color.'">';
            $color++;
            if ($color > $max_colors) {
                $color = 1;
            }
            $result .= replace_chars($item).'</span> <br />';
            $j++;
        }
        $i++;
    }
    return $result;
}


// Initialize variables
$test_source1 = <<<EOD
<h3>Pour les programmeurs</h3>


	<h4>Version 0.6</h4>

	<ul>
	  <li> Sources version 0.6:
		<a href="test_06.zip"
           title="test_06.zip">
           test_06.zip
        </a> (59 Kb)
	  </li>
      <li> Sources version 0.7:<a href="test_07.zip">test_07.zip</a> (59 Kb)</li>
	  <li> Sources version 0.8:
		<a href="test_08.zip" title="test_08.zip">test_08.zip</a> (259 Kb)
	  </li>
	</ul>
EOD;

$test_source2 = <<<EOD
Jean Dupont
Alex Ursulin
Olivier Durant
Arsène Lupin
EOD;

$test_source3 = <<<EOD
the red king and the red queen
the white king and the white queen
the red king and the white queen
the white king and the red queen
EOD;

$demos = array();
$demos[] = array( 'title' => 'Link',
                  'pattern' => '|(<a href=")(?!/)(?!http://)(?!#)(.*?)(".*?>)(.*?)(</a>)|s',
                  'source' => $test_source1
                 );
$demos[] = array( 'title' => 'Opening tag',
                  'pattern' => '|<\w+>|',
                  'source' => $test_source1
                 );
$demos[] = array( 'title' => 'Opening tag with attribut',
                  'pattern' => '|<\w+ [=:#."\s\w -]+>|',
                  'source' => $test_source1
                 );
$demos[] = array( 'title' => 'Closing tag',
                  'pattern' => '|</\w+>|',
                  'source' => $test_source1
                 );
$demos[] = array( 'title' => 'Tag contents',
                  'pattern' => '|(?!\s)[^<>]*[^<>\s](?=\s*<)|',
                  'source' => $test_source1
                 );
$demos[] = array( 'title' => 'First name, last name',
                  'pattern' => '|([\wéèàùôûê]+)\s([\wéèàùôûê]+)|',
                  'source' => $test_source2
                 );
$demos[] = array( 'title' => 'Dominant same color',
                  'pattern' => '/the (red|white) king and the \1 queen/',
                  'source' => $test_source3
                 );
$demos[] = array( 'title' => 'Dominant different color',
                  'pattern' => '/the (red|white) king and the (?!\1)(red|white) queen/',
                  'source' => $test_source3
                 );

$pattern = '';
$all = false;
$source = '';
$matches = '';
$result = '';
$capture = '';

$colors = array('#e6e6ff',
                '#e6ffe6',
                '#ffe6e6',
                '#efd5e1',
                '#b1dcfa',
                '#b8b1fa',
                '#fab1fa',
                '#fad6b1',
                '#fab1ca',
                '#fafab1',
                '#defab1',
                '#b1fae5',
                '#fef3e5');
$max_colors = count($colors);

// Analyse what we get
if (!isset($_POST['btnReset'])) {
    if (isset($_POST['pattern'])) {
        if (get_magic_quotes_gpc()) {
            $pattern = stripslashes($_POST['pattern']);
        } else {
            $pattern = $_POST['pattern'];
        }
    }
    if (isset($_POST['source'])) {
        if (get_magic_quotes_gpc()) {
            $source = stripslashes($_POST['source']);
        } else {
            $source = $_POST['source'];
        }
    }
 }

if (isset($_POST['rbtnMatch']) && ($_POST['rbtnMatch'] === 'all')) {
    $all = true;
}

if ((isset($_POST['btnDemo'])) && (isset($_POST['cbxDemo']))) {
    $pattern = $demos[0]['pattern'];
    $source = $demos[0]['source'];
    $all = true;

    foreach ($demos as $demo) {
        if ($_POST['cbxDemo'] == $demo['title']) {
            $pattern = $demo['pattern'];
            $source = $demo['source'];
        }
    }
 }

// Process

if ($pattern !== '') {
    $matches = process_source($pattern, $source, $all);
    $result = highlight_source($source, $matches, $max_colors);
    $capture = format_capture($matches, $max_colors);
 } else {
    $matches = '';
    $result = replace_chars($source);
    $capture = '';
 }

// Display resulting page
$xhtml = '';
$xhtml .= '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"'."\n";
$xhtml .= '                  "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">'."\n";
$xhtml .= '<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en" dir="ltr">'."\n";
$xhtml .= '  <head>'."\n";
$xhtml .= '    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />'."\n";
$xhtml .= '    <meta http-equiv="Content-Language" content="en" />'."\n";
$xhtml .= '    <title>RegExp viewer</title>'."\n";
$xhtml .= '    <meta content="noindex,nofollow" name="robots"/>'."\n";
$xhtml .= '    <style type="text/css">'."\n";
$xhtml .= '      input {margin-top: 0.3em; margin-bottom: 0.3em; }'."\n";
$xhtml .= '      .code {font-family: monospace; }'."\n";
foreach ($colors as $key => $value) {
    $id = $key + 1;
    $xhtml .= '      .b'.$id.' {background: '.$value.'; padding: 0.1em; }'."\n";
}
$xhtml .= '      h1 {margin-top: 0.5em; margin-bottom: 0.5em; font-size: 120%; }'."\n";
$xhtml .= '      h2 {margin-top: 0; font-size: 80%; }'."\n";
$xhtml .= '    </style>'."\n";
$xhtml .= '  </head>'."\n";
$xhtml .= '  <body>'."\n";
$xhtml .= '    <h1>PHP regexp (PCRE) viewer '.$version.'</h1>'."\n";
$xhtml .= '	   <form action="'.basename($_SERVER['PHP_SELF']).'" accept-charset="utf-8" method="post" id="frm">'."\n";
$xhtml .= '		 <fieldset>'."\n";
$xhtml .= '		   <legend> Source </legend>'."\n";
$xhtml .= '		   <textarea rows="10" cols="90"'."\n";
$xhtml .= '		     name="source" id="source" class="code">';
$xhtml .= htmlentities($source, ENT_QUOTES, 'UTF-8').'</textarea>'."\n";
$xhtml .= '		 </fieldset>'."\n";
$xhtml .= '		 <fieldset>'."\n";
$xhtml .= '		   <legend> Regexp pattern (do not forget delimiters) </legend>'."\n";
$xhtml .= '		   <input type="text"'."\n";
$xhtml .= '				 name="pattern" id="pattern"'."\n";
$xhtml .= '				 size="80" maxlength="200"'."\n";
$xhtml .= '				 value="'.htmlentities($pattern, ENT_QUOTES, 'UTF-8').'" /><br />'."\n";
$xhtml .= '		   <input type="radio" name="rbtnMatch" id="preg_match" value="1"';
if ($all) {
    $xhtml .= ' />'."\n";
 } else {
    $xhtml .= ' checked="checked" />'."\n";
 }
$xhtml .= '		   <label for="preg_match">preg_match</label>'."\n";
$xhtml .= '		   <input type="radio" name="rbtnMatch" id="preg_match_all" value="all"';
if ($all) {
    $xhtml .= ' checked="checked" />'."\n";
 } else {
    $xhtml .= ' />'."\n";
 }
$xhtml .= '		   <label for="preg_match_all">preg_match_all</label>'."\n";
$xhtml .= '		   <br />'."\n";
$xhtml .= '		   <input type="submit" name="btnReset" id="reset" value="Clear form" />'."\n";
$xhtml .= '		   <input type="submit" name="btnGo" id="go" value="Run regexp" />'."\n";
$xhtml .= '		   <hr />'."\n";
// Demos
$xhtml .= '		   <label for="choice">If you need some sample, select a demo</label>'."\n";
$xhtml .= '		   <select name="cbxDemo" id="choice">'."\n";
foreach ($demos as $demo) {
    $xhtml .= '		     <option value="'.$demo['title'].'"';
    if ($_POST['cbxDemo'] == $demo['title']) {
        $xhtml .= ' selected';
    }
    $xhtml .= '>'.$demo['title'].'</option>'."\n";
}
$xhtml .= '		   </select>'."\n";
$xhtml .= '		   <input type="submit" name="btnDemo" id="demo" value="Run demo" />'."\n";
// End demos
$xhtml .= '		 </fieldset>'."\n";
$xhtml .= '		 <fieldset>'."\n";
$xhtml .= '		   <legend> Result </legend>'."\n";
$xhtml .= '		   <div>'."\n";
$xhtml .= '		     <h2>Capturing parts of regexp are highlighted</h2>';
$xhtml .= '		     <p class="code">';
$xhtml .= highlight_regexp($pattern, $max_colors);
$xhtml .= '          </p>'."\n";
$xhtml .= '		     <hr />'."\n";
$xhtml .= '		     <h2>Captured part of regexp are highlighted in matching source</h2>';
$xhtml .= '		     <p class="code">'."\n";
$xhtml .= $result;
$xhtml .= '		     </p>'."\n";
$xhtml .= '		     <hr />'."\n";
$xhtml .= '		     <h2>Regexp matches returned by PHP, with captured parts highlighted</h2>';
$xhtml .= '		     <p class="code">'."\n";
$xhtml .= $capture;
$xhtml .= '		     </p>'."\n";
$xhtml .= '		   </div>'."\n";
$xhtml .= '		 </fieldset>'."\n";
$xhtml .= '	   </form>'."\n";
$xhtml .= '  </body>'."\n";
$xhtml .= '</html>'."\n";

echo $xhtml;

/*
 * Local variables:
 * mode: php
 * coding: utf-8-unix
 * tab-width: 4
 * c-basic-offset: 4
 * indent-tabs-mode: nil
 * End:
 */

