#!/usr/bin/tclsh
# -*- mode: tcl; coding: latin-9-unix; -*-
# Time-stamp: <2007-02-28 21:44:56 alain>%
# $Id: lngcode.tcl,v 1.1.1.1 2007-03-08 18:16:28 cvsalain Exp $
#-------------------------------------------------------------------------------
# 
#-------------------------------------------------------------------------------

package provide lngcode 0.1

namespace eval ::lngcode:: {
	namespace export getLngCode
	namespace export getLngName

	variable LngList
	variable CodeList
	variable DefaultCode
	variable DefaultName
}

#-------------------------------------------------------------------------------
# List of all language code and name in corresponding language
# First one is the default language and we should always have a language file
# for this one
#-------------------------------------------------------------------------------
set ::lngcode::LngList \
	[ list \
		  "en" "English" \
		  "fr" "Franais" \
		  "de" "Deutch" \
		  "it" "Italiano" \
	 ]

#-------------------------------------------------------------------------------
# Set default values
#-------------------------------------------------------------------------------
set ::lngcode::DefaultCode [ lindex $::lngcode::LngList 0 ]
set ::lngcode::DefaultName [ lindex $::lngcode::LngList 1 ]

#-------------------------------------------------------------------------------
# Get list of code for which a language file is found in folder
# Return true if found almost one
#-------------------------------------------------------------------------------
proc ::lngcode::getCodeList {folder} {
	set MsgFilesList [ glob -directory $folder -nocomplain "*.msg" ]
	set Length [ string length $folder ]
	set ::lngcode::CodeList [ list ]
	foreach Filename $MsgFilesList {
		set Code [ string map {".msg" ""} [ string replace $Filename 0 $Length ] ]
		lappend ::lngcode::CodeList $Code
	}
	if { [ llength $::lngcode::CodeList ] > 0 } {
		return true
	} else {
		return false
	}
}

#-------------------------------------------------------------------------------
# Return true if code is one for which we have a language file
#-------------------------------------------------------------------------------
proc ::lngcode::isValidCode {code} {
	set Pos [ lsearch $::lngcode::LngList $code ]
	if { $Pos > 0 } {
		return true
	} else {
		return false
	}
}

#-------------------------------------------------------------------------------
# Return first code for which we have a language file, 
# default language code otherwise
#-------------------------------------------------------------------------------
proc ::lngcode::getValidCode {args} {
	set result $::lngcode::DefaultCode
	foreach code $args {
		if { $result == $::lngcode::DefaultCode } {
			if { [ ::lngcode::isValidCode $code ] } {
				set result $code
			}
		}
	}
	return $result
}

#-------------------------------------------------------------------------------
# Return language code corresponding to name
# If usedefault is set to 1 and fail to find name, return default one
#-------------------------------------------------------------------------------
proc ::lngcode::getLngCode {name usedefault} {
	set Pos [ lsearch $::lngcode::LngList $name ]
	if { $Pos > 0 } {
		return [ lindex $::lngcode::LngList [ incr Pos -1 ] ]
	} else {
		if { $usedefault == 1 } {
			return $::lngcode::DefaultCode
		} else {
			return ""
		}
	}
}

#-------------------------------------------------------------------------------
# Return language name corresponding to code
# If usedefault is set to 1 and fail to find code, return default one
#-------------------------------------------------------------------------------
proc ::lngcode::getLngName {code usedefault} {
	set Pos [ lsearch $::lngcode::LngList $code ]
	if { $Pos >= 0 } {
		return [ lindex $::lngcode::LngList [ incr Pos ] ]
	} else {
		if { $usedefault == 1 } {
			return $::lngcode::DefaultName
		} else {
			return $code
		}
	}
}

################################################################################
# Test
# puts [ ::lngcode::getLngCode "Franais" 0 ]
# puts [ ::lngcode::getLngName "en" 0 ]
# puts [ ::lngcode::getLngCode "Zurlub" 1 ]
# puts [ ::lngcode::getLngName "zu" 1 ]
# ::lngcode::getCodeList ./msg
