#!/usr/bin/tclsh
# -*- mode: tcl; coding: latin-9-unix; -*-
# Time-stamp: <2007-03-12 19:53:45 alain>%
# $Id: debug.tcl,v 1.2 2007-03-12 18:54:04 cvsalain Exp $
#-------------------------------------------------------------------------------
# Debugging procedures
#-------------------------------------------------------------------------------

package provide debug 0.1
namespace eval ::debug {}

set ::debug::state false ; # Debugging status, true or false
set ::debug::level 1;     # Debugging level, higher it is, more verbose it is

#-------------------------------------------------------------------------------
# Return current debugging status
#-------------------------------------------------------------------------------
proc ::debug::status {} {
	return ::debug::state
}

#-------------------------------------------------------------------------------
# Display debugging message on console, text is "message"
#-------------------------------------------------------------------------------
proc ::debug::msg {level message} {
	if $::debug::state {
		if {$::debug::level >= $level} {
			puts $message
		}
	}
}
