#!/usr/bin/env tclsh
# -*- mode: tcl; coding: utf-8-unix; -*-
# Time-stamp: <2016-05-14 22:32:45 alain>%
# $Id: netinfo_generic.tcl,v 1.10 2009-01-25 16:52:47 cvsalain Exp $
#-------------------------------------------------------------------------------
# 20090122 version 1.1
#   Addition of differenciation between Microsoft workgroup and domain
# 20090124 version 1.2
#   Addition of operating system support level
# 20090125 version 1.3
#   Collect all infomations in one call
#-------------------------------------------------------------------------------

package provide netinfo_generic 1.3

if {![info exists ::netinfo]} {
	# Adjust auto_path to contain script home and current directory
	set script_home [string trimright [file dirname [info script]] ./]
	set script_home [file join [pwd] $script_home]
	lappend auto_path $script_home
}

package require netinfo_common

#-------------------------------------------------------------------------------
# Return level of support for that operationg system
# It can be full, partial or none
#-------------------------------------------------------------------------------
proc ::net_info::getSupportLevel {} {
	return "none"
}

#-------------------------------------------------------------------------------
# Return computer operating system name
#-------------------------------------------------------------------------------
proc ::net_info::getOS {} {
	return $::tcl_platform(os)
}

#-------------------------------------------------------------------------------
# Return computer operating system version
#-------------------------------------------------------------------------------
proc ::net_info::getOSVersion {} {
	return $::tcl_platform(osVersion)
}

#-------------------------------------------------------------------------------
# Return computer current logged user
#-------------------------------------------------------------------------------
proc ::net_info::getCurrentUser {} {
	return $::tcl_platform(user)
}

#-------------------------------------------------------------------------------
# Return computer name
#-------------------------------------------------------------------------------
proc ::net_info::getComputerName {} {
	return [info hostname]
}

#-------------------------------------------------------------------------------
# Return all informations regarding computer and interfaces
#-------------------------------------------------------------------------------
proc ::net_info::getInfos {} {
	array set Computer [::net_info::initComputer]

	set Computer(Os)             [::net_info::getOS]
	set Computer(OsVersion)      [::net_info::getOSVersion]
	set Computer(OsSupportLevel) [::net_info::getSupportLevel]
	set Computer(Username)       [::net_info::getCurrentUser]
	set Computer(Hostname)       [::net_info::getComputerName]

	set Interfaces {}

	return [list Computer [array get Computer] Interfaces $Interfaces]
}

#-------------------------------------------------------------------------------
# If that file is called directly, display test suite on command line
#-------------------------------------------------------------------------------

if {![info exist ::netinfo]} {
	::net_info::testSuite
}
