UNIT CaoMnu;

{}
{                                                                           }
{                                CaoMnu                                     }
{                                                                           }
{   - Menus droulants verticaux en mode graphique pour Turbo Pascal -      }
{                                                                           }
{}

INTERFACE

USES
    Dos,
    Crt,
    Graph,
    TurboLib,
    GrafLib;

{}
CONST
  MaxMenus = 20; { Nombre maximum de menus }
  MaxCases = 27; { Nombre maximum de case d'un menu <= 28 }
  ClFdTitre : couleur = BleuCiel; { Couleur de fond du titre du menu }
  ClTxTitre : couleur = Noir; { Couleur de texte du titre du menu }
  ClFdMenu  : couleur = GrisClair; { Couleur de fond du menu }
  ClTxMenu  : couleur = Blanc; { Couleur de texte du menu }
  ClNSelect : couleur = Gris; {Couleur de texte des cases non selectionnables }

{}
TYPE
  MenuPtr = ^Menu;
  Menu = RECORD
           NumMenu : byte ; {numro du menu}
           Titre   : Str80;
           Cases : array [1..MaxCases] of
             RECORD
               Titre : Str80; {titre de la case}
               Select : boolean; {Vrai si case selectionnable}
               Inverse : boolean; {Etat inverse de la case}
             END;
         END;
  ListeMenuPtr = ^Noeud;
  Noeud = RECORD
            NumMenu   : byte;
            Precedent : ListeMenuPtr;
            Suivant   : ListeMenuPtr;
          END;
  Action = (SansAction, Clavier , ChoixMenu , Souris1 , Souris2);
  typAction = RECORD
                actType   : action; {type d'action enregistre}
                actPos    : Point; {position d'une action souris}
                actTouche : char; {touche pour une action clavier}
                actCase   : byte; {case pour une action menu}
              END;

{}
VAR
  Separateur : Str80;
  CaseVide : Str80;
  i : byte;
  MaxCarCase :byte; { Nombre de caractres par case }

  LMenu : array [1..MaxMenus] of MenuPtr; { liste des menus }
  Premier , Nouveau , Dernier : ListeMenuPtr; { pointeur liste de suivi des menus }
  Ouvert  : Byte;            { numro du menu courament ouvert }
  CasePrecedente : byte;        { numro de la case prcdement inverse }
  CaseActuelle : byte; { numro de la case actuelle }
  EtatClv : byte; { tat des touches spciales du clavier }
  lAction : typAction; {variable de stockage des actions }

  TesterSouris : boolean;

PROCEDURE InverseCaseMenu(PosY : byte);
PROCEDURE AjouteMenu(Num : byte; TMenu : Str80);
PROCEDURE AjouteCase(Num,PosY : byte;TCase : Str80;Etat : boolean);
PROCEDURE SelectCase(Num,PosY : byte);
PROCEDURE DeSelectCase(Num,PosY : byte);
FUNCTION LitEtatCase(Num,PosY : byte):boolean;
PROCEDURE DessineMenu(Num : byte);
PROCEDURE DessineCaseMenu(NumMenu,PosY : byte);
FUNCTION dsMenu : boolean;
FUNCTION actionMenu (VAR action : typAction) : boolean;

IMPLEMENTATION

{}
{                   Ajoute un menu dans la liste de suivi                   }
{}
PROCEDURE AjouteListeMenu(Num : byte);
BEGIN
  if Premier^.NumMenu = 0 then
  BEGIN
    Premier^.NumMenu := Num;
    Dernier := Premier;
  END
  else
  BEGIN
    New(Nouveau);
    Nouveau^.NumMenu := Num;
    Nouveau^.Suivant := nil;
    Nouveau^.Precedent := Dernier;
    Dernier^.Suivant := Nouveau;
    Dernier := Nouveau;
  END;
END;

{}
{                   Supprime un menu dans la liste de suivi                 }
{}
PROCEDURE SupprimeListeMenu;
BEGIN
  Nouveau := Dernier^.Precedent;
  Nouveau^.Suivant := nil;
  Dispose(Dernier);
  Dernier := Nouveau;
END;

{}
{                   Dessine case vide                                       }
{}
PROCEDURE DessineCase_Vide(NumMenu , PosY : byte);
BEGIN
  with LMenu[NumMenu]^ do
  with Cases[PosY] do
  BEGIN
    coulFond(ClFdMenu);
    coulTexte(ClTxTitre);
    gotoxy(1,(PosY * 2 + 2));
    Ecrit('');
    Ecrit(CaseVide);
    Ecrit('');
    gotoxy(1,(PosY * 2 + 3));
    if Cases[PosY + 1].Titre = '' then
    BEGIN
      Ecrit('');
      Ecrit(CaseVide);
      Ecrit('');
    END
    else
    BEGIN
      Ecrit('');
      Ecrit(Separateur);
      Ecrit('');
    END;
  END;
END;

{}
{                   Dessine case pleine                                     }
{}
PROCEDURE DessineCase_Pleine(NumMenu , PosY : byte);
BEGIN
  with LMenu[NumMenu]^ do
  with Cases[PosY] do
  BEGIN
    coulFond(ClFdMenu);
    coulTexte(ClTxTitre);
    gotoxy(1,(PosY * 2 + 2));
    Ecrit('');
    if Select then coulTexte(ClTxMenu)
              else coulTexte(ClNSelect);
    Ecrit(Titre);
    coulTexte(ClTxTitre);
    Ecrit('');
    gotoxy(1,(PosY * 2 + 3));
    Ecrit('');
    Ecrit(Separateur);
    Ecrit('');
  END;
END;

{}
{                   Dessine derniere case                                   }
{}
PROCEDURE DessineDerniere_Case(NumMenu , PosY : byte);
BEGIN
  with LMenu[NumMenu]^ do
  with Cases[PosY] do
  BEGIN
    coulFond(ClFdMenu);
    coulTexte(ClTxTitre);
    gotoxy(1,(PosY * 2 + 2));
    Ecrit('');
    if Titre = '' then Ecrit(CaseVide)
    else
    BEGIN
      if Select then coulTexte(ClTxMenu)
                else coulTexte(ClNSelect);
      Ecrit(Titre);
    END;
    coulTexte(ClTxTitre);
    Ecrit('');
    gotoxy(1,(PosY * 2 + 3));
    Ecrit('');
    Ecrit(Separateur);
    Ecrit('');
  END;
END;


{}
{                  Dessine une case du menu                                 }
{}
PROCEDURE DessineCaseMenu(NumMenu,PosY : byte);
BEGIN
  with LMenu[NumMenu]^ do
  with Cases[PosY] do
  BEGIN
    if PosY = MaxCases then DessineDerniere_Case(NumMenu,PosY)
    else if Titre = '' then DessineCase_Vide(NumMenu,PosY)
                       else DessineCase_Pleine(NumMenu,PosY);
  END;
END;

{}
{                   Inverse une case du menu                                }
{}

PROCEDURE InverseCaseMenu(PosY : byte);
BEGIN
  with LMenu[Ouvert]^ do
  if PosY <= MaxCases then
    with Cases[posY] do
    BEGIN
      if not inverse then
      BEGIN
        CoulFond(ClTxMenu);
        if Select then CoulTexte(ClFdMenu)
                  else CoulTexte(ClNSelect);
      END
      else
      BEGIN
        CoulFond(ClFdMenu);
        if Select then CoulTexte(ClTxMenu)
                  else CoulTexte(ClNSelect);
      END;
      if Titre <> '' then
      BEGIN
        gotoxy(2,(PosY * 2 + 2));
        Ecrit(Titre);
        Inverse := not Inverse;
      END;
    END;
END;

{}
{                   Dessine le menu                                         }
{}

PROCEDURE DessineMenu(Num : byte);
VAR
  s : typSauvGrf;

BEGIN
  sauvegarde(s);
  CacheSouris;
  if Premier^.NumMenu = Num then
    while Dernier <> Premier do SupprimeListeMenu
  else
  if Dernier^.Precedent^.NumMenu = Num then SupprimeListeMenu
     else if Dernier^.NumMenu <> Num then AjouteListeMenu(Num);
  with LMenu[Num]^ do
  BEGIN
    coulFond(ClFdMenu);
    coulTexte(ClTxTitre);
    gotoxy(1,1);
    Ecrit('');
    Ecrit(Separateur);
    Ecrit('');
    gotoxy(1,2);
    Ecrit('');
    coulFond(ClFdTitre);
    Ecrit(Titre);
    coulFond(ClFdMenu);
    Ecrit('');
    gotoxy(1,3);
    Ecrit('');
    Ecrit(Separateur);
    Ecrit('');

    for i := 1 to MaxCases do
    BEGIN
    Cases[i].Inverse := false;
    DessineCaseMenu(Num,i);
    END;
  END;
  Ouvert := Num;
  CasePrecedente := 0;
  CaseActuelle := 0;
  restaure(s);
END;

{}
{                  Ajoute un nouveau menu                                   }
{}

PROCEDURE AjouteMenu(Num : byte; TMenu : Str80);
BEGIN
  New(LMenu[Num]);
  with LMenu[Num]^ do
  BEGIN
    NumMenu := Num;
    Titre := elargi(TMenu,MaxCarCase);
    for i := 1 to MaxCases do
    with Cases[i] do
    BEGIN
      Titre := '';
      Select := false;
    END;
  END;
END;

{}
{                  Ajoute une case a un menu                                }
{}

PROCEDURE AjouteCase(Num,PosY : byte;TCase : Str80;Etat : boolean);
BEGIN
  with LMenu[Num]^ do
  BEGIN
    with Cases[PosY] do
    BEGIN
      Titre := elargiADte(TCase,MaxCarCase);
      Select := Etat;
    END;
  END;
END;

{}
{                 Rend une case selectionnable                              }
{}

PROCEDURE SelectCase(Num,PosY : byte);
BEGIN
  with LMenu[Num]^ do
  with Cases[PosY] do Select := true;
END;

{}
{                  Rend une case non selectionnable                         }
{}

PROCEDURE DeSelectCase(Num,PosY : byte);
BEGIN
  with LMenu[Num]^ do
  with Cases[PosY] do Select := false;
END;

{}
{           Renvoie l'tat courant (slectionnable ou non) d'une case       }
{}

FUNCTION LitEtatCase(Num,PosY : byte):boolean;
BEGIN
  with LMenu[Num]^ do
  with Cases[PosY] do LitEtatCase := Select;
END;

{}
{                   Teste si la souris se trouve dans le menu               }
{}

FUNCTION dsMenu : boolean;
BEGIN
  with PosSouris do
   dsMenu := (X > grLFont) and (X < ((MaxCarCase+1) * grLFont))
         and (Y > (3 * grHFont))
         and (Y < (((MaxCases - 2) * 2 + 3) * grHFont));
END;

{}
{                   Inversion case si souris prsente                       }
{}

PROCEDURE Inversion;
VAR
  s : typSauvGrf;

BEGIN
  if LMenu[Ouvert]^.Cases[CaseActuelle].Titre <> '' then
  BEGIN
    sauvegarde(s);
    CacheSouris;
    if CasePrecedente = 0 then
    BEGIN
      InverseCaseMenu(CaseActuelle);
      CasePrecedente := CaseActuelle;
    END
    else
    if CasePrecedente <> CaseActuelle then
    BEGIN
      InverseCaseMenu(CasePrecedente);
      InverseCaseMenu(CaseActuelle);
      CasePrecedente := CaseActuelle;
    END;
    restaure(s);
  END
  else
  BEGIN
    if CasePrecedente <> 0 then
    BEGIN
      sauvegarde(s);
      CacheSouris;
      InverseCaseMenu(CasePrecedente);
      CasePrecedente := 0;
      restaure(s);
    END;
  END;
END;

{}
{  Attente d'un vnement utilisateur . Vrai si c'est un vnement du menu  }
{}

FUNCTION actionMenu (VAR action : typAction): boolean;

VAR
  Reste : real;

BEGIN
  with lAction do
  BEGIN
    actType := SansAction;
    ActionMenu := false;
    if TesterSouris then execSouris;
    if dsMenu then
    BEGIN
      CaseActuelle := (PosSouris.Y - 1) div grHFont + 1;
      if (CaseActuelle mod 2) <> 0 then
        BEGIN
          Reste := (PosSouris.Y - 1) mod grHFont;
          if Reste < (grHFont div 2) then
             CaseActuelle := CaseActuelle - 1;
          if Reste >= (grHFont div 2) then
             CaseActuelle := CaseActuelle + 1;
        END;
      if (CaseActuelle mod 2) = 0 then
      BEGIN
        CaseActuelle := CaseActuelle div 2 - 1;
        if not  LMenu[Ouvert]^.Cases[CaseActuelle].Inverse then
          Inversion;
      END;
    END
    else
    BEGIN
      if CasePrecedente <> 0 then
      BEGIN
        CaseActuelle := CasePrecedente;
        CasePrecedente := 0;
        Inversion;
        CasePrecedente := 0;
      END;
    END;
    if BoutSouris = 1 then
    BEGIN
      actType := Souris1;
      actPos := posSouris;
      if dsMenu then
      BEGIN
        CaseActuelle := (PosSouris.Y - 1) div grHFont + 1;
        if (CaseActuelle mod 2) <> 0 then
        BEGIN
          Reste := (PosSouris.Y - 1) mod grHFont;
          if Reste < (grHFont div 2) then
             CaseActuelle := CaseActuelle - 1;
          if Reste >= (grHFont div 2) then
             CaseActuelle := CaseActuelle + 1;
        END;
        if (CaseActuelle mod 2) = 0 then
        BEGIN
          CaseActuelle := CaseActuelle div 2 - 1;
          if LMenu[Ouvert]^.Cases[CaseActuelle].Select then
          BEGIN
            ActionMenu := true;
            actCase := CaseActuelle;
            actType := ChoixMenu;
            unBip;
          END;
        END;
      END;
    END
    else
    if BoutSouris = 2 then
    BEGIN
      actType := Souris2;
      actPos := posSouris;
    END
    else
    if keypressed then
    BEGIN
      EtatClv := etatClavier;
      actTouche := readkey;
      if (actTouche = carNul) and keypressed then actTouche := readkey;
      actType := Clavier;
    END;
  END;
  TesterSouris := true;
END;

{}
{ Pr-initialisation de CaoMnu }
BEGIN
  Ouvert := 0;
  CasePrecedente := 0;
  MaxCarCase := 13;
  for i := 1 to MaxCarCase do Separateur := Separateur + '';
  for i := 1 to MaxCarCase do CaseVide := CaseVide + ' ';
  new(Premier);
  Premier^.NumMenu := 0;
  Premier^.Precedent := nil;
  Premier^.Suivant := nil;
  Dernier := Premier;
  TesterSouris := true;
END.