UNIT CaoImp;

{}
{                                                                           }
{                                CaoImp                                     }
{                                                                           }
{                 - Routines d'impression et traceur -                      }
{                                                                           }
{}

INTERFACE

USES
    Printer,
    Turbolib,
    Graflib,
    Math,
    CaoGlob,
    CaoGra,
    CaoBdd;

PROCEDURE ImprimeFc;
PROCEDURE ImprimeTouteFc;

{}

IMPLEMENTATION

VAR
  NbLigne : word;

PROCEDURE Impression(Texte : str80);

BEGIN
  car := ' ';
  while not ImprimantePrete do
  BEGIN
    Alarme('Vrifiez l''imprimante');
    if car = CarEsc then exit;
  END;
  Writeln(Lst,Texte);
  NbLigne := NbLigne + 1;
  if NbLigne = NbLignesParPage then
  BEGIN
    writeln(Lst,#12);
    Alarme('Changez la page');
    NbLigne := 0;
  END;
END;

{}
{           Test si le nombre de ligne disponible est suffisant              }
{}

PROCEDURE TestNbLignes(NbTest : word);

BEGIN
  if (NbLignesParPage - NbLigne) <= NbTest then
  BEGIN
    NbLigne := NbLignesParPage - 1;
    Impression('');
    if car = CarEsc then exit;
  END;
END;

{}
{           Impression d'un ligne de sparation                              }
{}

PROCEDURE Separateur;

VAR
  N : word;
  Ligne : str80;

BEGIN
  Ligne := '';
  for n := 1 to 80 do Ligne := Ligne + '*';
  Impression(Ligne);
  if car = CarEsc then exit;
END;

{}
{           Impression d'un point                                            }
{}

PROCEDURE ImprimePoint;

VAR
  Ligne : str80;
  Valeur : str80;

BEGIN
  TestNbLignes(2);
  Ligne := 'Point  X :';
  str(PointEnCours^.X:10:5,Valeur);
  Ligne := Ligne + Valeur + '  Y :';
  str(PointEnCours^.Y:10:5,Valeur);
  Ligne := Ligne + Valeur;
  Impression(Ligne);
  if car = CarEsc then exit;
  Separateur;
END;

{}
{           Impression d'une droite ou d'un segment                          }
{}

PROCEDURE ImprimeDroite;

VAR
  Ligne : str80;
  Valeur : str80;

BEGIN
  if DroiteEnCours^.Nom = 'SEGMENT' then TestNbLignes(4)
                                    else TestNbLignes(2);
  Ligne := DroiteEnCours^.Nom + '  X :';
  str(DroiteEnCours^.X:10:5,Valeur);
  Ligne := Ligne + Valeur + '  Y :';
  str(DroiteEnCours^.Y:10:5,Valeur);
  Ligne := Ligne + Valeur + '  Angle :';
  str(RadToDeg(DroiteEnCours^.Angle):10:5,Valeur);
  Ligne := Ligne + Valeur;
  Impression(Ligne);
  if car = CarEsc then exit;
  if DroiteEnCours^.Nom = 'SEGMENT' then
  BEGIN
    Ligne := 'X Dbut :';
    str(DroiteEnCours^.XDebut:10:5,Valeur);
    Ligne := Ligne + Valeur + '  Y Dbut :';
    str(DroiteEnCours^.YDebut:10:5,Valeur);
    Ligne := Ligne + Valeur;
    Impression(Ligne);
    if car = CarEsc then exit;
    Ligne := 'X Fin   :';
    str(DroiteEnCours^.XFin:10:5,Valeur);
    Ligne := Ligne + Valeur + '  Y Fin   :';
    str(DroiteEnCours^.YFin:10:5,Valeur);
    Ligne := Ligne + Valeur;
    Impression(Ligne);
    if car = CarEsc then exit;
  END;
  Separateur;
END;

{}
{           Impression d'un cercle ou d'un arc                               }
{}

PROCEDURE ImprimeCercle;

VAR
  Ligne : str80;
  Valeur : str80;

BEGIN
  if CercleEnCours^.Nom = 'ARC' then TestNbLignes(4)
                                else TestNbLignes(2);
  Ligne := CercleEnCours^.Nom + '  X centre :';
  str(CercleEnCours^.Xc:10:5,Valeur);
  Ligne := Ligne + Valeur + '  Y centre :';
  str(CercleEnCours^.Yc:10:5,Valeur);
  Ligne := Ligne + Valeur + '  Rayon :';
  str(CercleEnCours^.R:10:5,Valeur);
  Ligne := Ligne + Valeur;
  Impression(Ligne);
  if car = CarEsc then exit;
  if CercleEnCours^.Nom = 'ARC' then
  BEGIN
    Ligne := 'X Dbut :';
    str(CercleEnCours^.XDebut:10:5,Valeur);
    Ligne := Ligne + Valeur + '  Y Dbut :';
    str(CercleEnCours^.YDebut:10:5,Valeur);
    Ligne := Ligne + Valeur + '  Angle Dbut :';
    str(RadToDeg(CercleEnCours^.ADebut):10:5,Valeur);
    Ligne := Ligne + Valeur;
    Impression(Ligne);
    if car = CarEsc then exit;
    Ligne := 'X Fin   :';
    str(CercleEnCours^.XFin:10:5,Valeur);
    Ligne := Ligne + Valeur + '  Y Fin   :';
    str(CercleEnCours^.YFin:10:5,Valeur);
    Ligne := Ligne + Valeur + '  Angle Fin   :';
    str(RadToDeg(CercleEnCours^.AFin):10:5,Valeur);
    Ligne := Ligne + Valeur;
    Impression(Ligne);
    if car = CarEsc then exit;
  END;
  Separateur;
END;

{}
{           Impression de formes canoniques                                  }
{}

PROCEDURE ImprimeFc;

VAR
  XS,YS : integer;

BEGIN
  repeat
    AfficheBas(grClFond,grClTexte,'Cliquez l''lment de rfrence ');
    (*  delay(TempoSouris);*)
    Detection(XS,YS);
    EffaceBas;
    Test_Abandon;
    if Abandonner then exit;
    if PremierPoint <> nil then
       if DetectPoint then ImprimePoint
    else
      if PremierDroite <> nil then
         if DetectDroite then ImprimeDroite
      else
        if PremierCercle <> nil then
           if DetectCercle then ImprimeCercle;
  until false
END;

{}
{           Impression de toutes les formes canoniques                       }
{}

PROCEDURE ImprimeTouteFc;

BEGIN
  NbLigne := 0;
  Impression(' Impression des formes canoniques des lments ');
  if car = CarEsc then exit;
  Impression('');
  if car = CarEsc then exit;
  PointEnCours := PremierPoint;
  if PointEnCours <> nil then
  BEGIN
    ImprimePoint;
    while ListePoint do ImprimePoint;
  END;
  Impression('');
  if car = CarEsc then exit;
  Separateur;
  DroiteEnCours := PremierDroite;
  if DroiteEnCours <> nil then
  BEGIN
    ImprimeDroite;
    while ListeDroite do ImprimeDroite;
  END;
  Impression('');
  if car = CarEsc then exit;
  Separateur;
  CercleEnCours := PremierCercle;
  if CercleEnCours <> nil then
  BEGIN
    ImprimeCercle;
    while ListeCercle do ImprimeCercle;
  END;
  NbLigne := NbLignesParPage - 1;
  Impression('');
  if car = CarEsc then exit;
END;

BEGIN

END.