UNIT CaoGra;

{}
{                                                                           }
{                                CaoGra                                     }
{                                                                           }
{             - Gestion complte de la zone graphique -                     }
{                                                                           }
{}

INTERFACE

USES
    Dos,
    Crt,
    Graph,
    TurboLib,
    Math,
    GrafLib,
    CaoGlob,
    CaoMnu,
    CaoBdd,
    CaoDef;

{}

PROCEDURE FctGenerales;
PROCEDURE Attente;
PROCEDURE AttenteClic;
PROCEDURE NouvellePalette;
PROCEDURE TraceCadre;
PROCEDURE GraphPort;
PROCEDURE DessinePoint(X,Y : real);
PROCEDURE DessineOrigine;
PROCEDURE DessineDroite(X,Y,A : real);
PROCEDURE DessineSegment(X,Y,A,XD,YD,XF,YF : real);
PROCEDURE DessineCercle(X,Y,R : real);
PROCEDURE DessineArc(X,Y,R,AD,AF : real);
FUNCTION DsGraph(X,Y : integer):boolean;
PROCEDURE EffaceBas;
PROCEDURE AfficheBas(Fd,Tx : Couleur;Texte : str80);
PROCEDURE Redessine;
PROCEDURE EchelleAuto;
PROCEDURE GereZoom;

PROCEDURE EnregistreSouris(VAR XSouris,YSouris : integer);
PROCEDURE Detection(VAR XSouris,YSouris:integer);
PROCEDURE CreePoint(X,Y : real);
PROCEDURE CreeDroite(X,Y,Angle,XD,YD,XF,YF : real);
PROCEDURE CreeCercle(X,Y,R,XD,YD,AD,XF,YF,AF : real);
FUNCTION DetectPoint:boolean;
FUNCTION DetectDroite:boolean;
FUNCTION DetectSegment:boolean;
FUNCTION DetectCercle:boolean;
FUNCTION DetectArc:boolean;

PROCEDURE Test_Abandon;
PROCEDURE Alarme(Texte : str80);
PROCEDURE CreationImpossible;

{}

IMPLEMENTATION

USES CaoDiv;

type
  PolyPoint = record
              x,y:longint;
            end;
  P1P2 = record
           P1,P2:polypoint;
         end;



VAR
  FaitDessin : boolean;

{}
{                 Liste des diffrentes actions lors des attentes           }
{}

PROCEDURE FctGenerales;

BEGIN
  if (boutSouris = 1) and DsAccessoires then
  BEGIN
    gereAccessoires;
    if Abandonner then exit;
    BoutSouris := 0;
  END;
  if (boutSouris = 2) and DsGraph(PosSouris.X,PosSouris.Y) then
  BEGIN
    GereZoom;
    BoutSouris := 0;
  END;
  if AffCoord then
  BEGIN
    AfficheCoordonnees;
  END;
  if (FormeSouris <> 'CROIX') and (PosSouris.X > XMinEcran) then
  BEGIN
    ChangeCurseur(ptrCroix);
    FormeSouris := 'CROIX';
  END;
  if (FormeSouris <> 'MAIN') and (PosSouris.X < XMinEcran) then
  BEGIN
    ChangeCurseur(ptrMain);
    FormeSouris := 'MAIN';
  END;
END;

{}
{                 Attente d'un vnement utilisateur souris ou clavier      }
{}

PROCEDURE Attente;

BEGIN
  Delay(TempoSouris);
  repeat
    execSouris;
    FctGenerales;
  until keypressed or (BoutSouris <> 0);
END;

{}
{                 Attente d'un vnement utilisateur souris                 }
{}

PROCEDURE AttenteClic;
BEGIN
  Delay(TempoSouris);
  repeat
    execSouris;
    FctGenerales;
    while keypressed do
    BEGIN
      car := readkey;
      if car = CarEsc then
      BEGIN
        Abandonner := true;
        exit;
      END;
    END;
  until (BoutSouris <> 0);
END;

{}
{                 Dfinition d'une nouvelle palette de couleurs             }
{}

PROCEDURE NouvellePalette;
BEGIN
  SetPalette(Brun,6);
  SetPalette(Jaune,118);
  SetPalette(VertClair,50);
  SetPalette(Orange,36);
  SetPalette(Rose,45);
  SetPalette(BleuClair,9);
END;

{}

PROCEDURE TraceCadre;
VAR
  ViewPort : ViewPortType;
  N        : integer;
BEGIN
  CacheSouris;
  GetViewSettings(ViewPort);
  SetColor(GrisClair);
  with ViewPort do
  BEGIN
    Y2 := Y2 - 24;
    Rectangle(X1,Y1,X2,Y2);
  END;
  MontreSouris;
END;

{}

PROCEDURE GraphPort;

BEGIN
  SetViewPort(XMinEcran,YMinEcran,XMaxEcran,YMaxEcran,ClipOn);
END;

{}

PROCEDURE DrawCircle(Xc,Yc,Rayon : longint);

  PROCEDURE PointCourant(VAR X : longint; VAR Y : longint; M : byte);
  BEGIN
    case M of
      1 : Inc(X);
      2 : BEGIN
            Inc(X);
            Dec(Y);
          END;
      3 : Dec(Y);
      4 : BEGIN
            Dec(X);
            Dec(Y);
          END;
      5 : Dec(X);
      6 : BEGIN
            Dec(X);
            Inc(Y);
          END;
      7 : Inc(Y);
      8 : BEGIN
            Inc(X);
            Inc(Y);
          END;
    end;
    if (X >= 0) and (X < (XMaxEcran - XMinEcran)) and
       (Y >= 0) and (Y < YMaxEcran) then PutPixel(X,Y,CoulActive);
  END;

VAR
  M1, M2, M3 : byte;
  X1, Y1, X, Y : longint;
  Delta , Arobase : longint;

BEGIN
  xc := xc - XMinEcran;
  yc := yc - YMinEcran;
  GraphPort;
  M3 := 3;
  X1 := Xc + Rayon;
  Y1 := Yc;
  REPEAT
    X := -1;
    Y := Rayon + Rayon - 1;
    Delta := Y -1;
    M1 := M3;
    M2 := M1 + 1;
    M3 := M2 + 1;
    if M3 = 9 then M3 := 1;
    while Y >= 0 do
    BEGIN
      Arobase := Delta + Delta;
      if Arobase < 0 then
      BEGIN
        Arobase := Arobase - X;
        Y := Y - 2;
        if Arobase < 0 then
        BEGIN
          Delta := Delta + Y;
          PointCourant(X1, Y1, M3);
        END
        else
        BEGIN
          X := X - 2;
          Delta := Delta + Y + X;
          PointCourant(X1, Y1, M2);
        END;
      END
      else
      BEGIN
        Arobase := Arobase - Y;
        X := X - 2;
        if Arobase >= 0 then
        BEGIN
          Delta := Delta + X;
          PointCourant(X1, Y1, M1);
        END
        else
        BEGIN
          Y := Y - 2;
          Delta := Delta + Y + X;
          PointCourant(X1, Y1, M2);
        END;
      END;
    END;
  UNTIL M3 = 3;
  FullPort;
END;

{}

PROCEDURE DrawArc(Xc,Yc : longint;AngleFin,AngleDeb : real;Rayon : longint);
{ On interverti les angles de dbut et de fin car le dessin se fait en
  sens horaire }

VAR CoordP1P2 : P1P2;


  PROCEDURE CalculCoordonneesEntieres(VAR Angle:real;VAR x,y:longint;
    Xc,Yc,Rayon:longint;VAR Rx,Ry:real);
    VAR
      erreur:longint;
      Mini : longint;
      i : longint;
      Tab : array [1..4] of polypoint;
  BEGIN
    if(Angle<0.001) and (Angle> -0.001) then Angle := 2 * Pi;
    Rx := Cos(Angle) * Rayon + Xc;
    Ry := -Sin(Angle) * Rayon + Yc;
    Tab[1].x := trunc(Rx);
    Tab[1].y := trunc(Ry);
    Tab[2].x := trunc(Rx) + 1;
    Tab[2].y := trunc(Ry);
    Tab[3].x := trunc(Rx);
    Tab[3].y := trunc(Ry) + 1;
    Tab[4].x := trunc(Rx) + 1;
    Tab[4].y := trunc(Ry) + 1;
    Mini := 32735;
    for i := 1 to 4 do
    BEGIN
      Erreur := Abs((Tab[i].x - Xc)*(Tab[i].x - Xc)+(Tab[i].y - Yc)*(Tab[i].y - Yc)-Rayon*Rayon);
      if Erreur < Mini then
      BEGIN
        Mini := Erreur;
        X := Tab[i].x;
        Y := Tab[i].y;
      END;
    END;
  END;

  PROCEDURE NormalisationXY(VAR x,y,q : longint);
  VAR temp : longint;
  BEGIN
    if(x<0) and (y<=0) then
    BEGIN
      q := 2;
      temp := x;
      x := abs(y);
      y := abs(temp);
    END
    else
    BEGIN
      if (x>0) and (y>=0) then
      BEGIN
        q := 0;
        temp := x;
        x := abs(y);
        y := abs(temp);
      END
      else
      BEGIN
        if y<0 then q := 3
               else q := 1;
        x := abs(x);
        y := abs(y);
      END;
    END;
  END;

CONST
  k_M1:array[0..3] of Polypoint =
    ((x:0;y:1),(x:-1;y:0),(x:0;y:-1),(x:1;y:0));
  k_M2:array[0..3] of Polypoint =
    ((x:-1;y:1),(x:-1;y:-1),(x:1;y:-1),(x:1;y:1));
  k_M3:array[0..3] of Polypoint =
    ((x:-1;y:0),(x:0;y:-1),(x:1;y:0),(x:0;y:1));
VAR
  m1,m2,m3 :Polypoint;
  Q1,Q2,Q : longint;
  Mouvement : longint;
  x,y:longint;
  xi,yi:longint;
  x1,y1,x2,y2:longint;
  delta : real;
  arobase1,arobase2:real;
  temp:longint;
  fin:boolean;
  IX1,IY1,IX2,IY2:longint;
  RX1,RY1,RX2,RY2:real;

  BEGIN
    GraphPort;
    xc := xc - XMinEcran;
    yc := yc - YMinEcran;
    CalculCoordonneesEntieres(AngleDeb,IX1,IY1,Xc,Yc,Rayon,RX1,RY1);
    CalculCoordonneesEntieres(AngleFin,IX2,IY2,Xc,Yc,Rayon,RX2,RY2);
    with CoordP1P2 do
    BEGIN
      P1.x := IX1;
      P1.y := IY1;
      P2.x := IX2;
      P2.y := IY2;
    END;
    x1 := IX1 - Xc;
    y1 := IY1 - Yc;
    x2 := IX2 - Xc;
    y2 := IY2 - Yc;
    NormalisationXY(x1,y1,Q1);
    m1 := k_M1[Q1];
    m2 := k_M2[Q1];
    m3 := k_M3[Q1];
    NormalisationXY(x2,y2,Q2);
    Q := abs(Q2 - Q1) mod 4;
    if (Q=0) and (x2<=x1) and (y2>=y1) then Q := 3
       else if (Q1=3) and (AngleFin > AngleDeb) then Q := 3 - Q
               else Dec(Q);
    delta := x1*x1+y1*y1-(RX1-Xc)*(RX1-Xc)-(RY1-Yc)*(RY1-Yc)+2.0*x1-y1+1.0;
    x := IX1;
    y := IY1;
    if (x >= 0) and (x < (XMaxEcran - XMinEcran)) and
       (y >= 0) and (y < YMaxEcran) then PutPixel(x,y,CoulActive);
    xi := x1;
    yi := y1;
    fin := false;
    while not fin do
    BEGIN
      if yi>0 then
      BEGIN
        if delta <= 0 then
        BEGIN
          arobase1 := 2.0*delta+2.0*yi-1.0;
          if arobase1 <= 0 then Mouvement := 1
                           else Mouvement := 2;
        END
        else
        BEGIN
          arobase2 := 2.0*delta-2.0*xi-1.0;
          if arobase2 <= 0 then Mouvement := 2
                           else Mouvement := 3;
        END;
        case Mouvement of
          1:BEGIN
              inc(xi);
              delta := delta + 2.0*xi+1.0;
              x := x + m1.x;
              y := y + m1.y;
            END;
          2:BEGIN
              inc(xi);
              dec(yi);
              delta := delta + 2.0*xi-2.0*yi+2.0;
              x := x + m2.x;
              y := y + m2.y;
            END;
          3:BEGIN
              dec(yi);
              delta := delta - 2.0*yi+1.0;
              x := x + m3.x;
              y := y + m3.y;
            END;
        END;
        if (x >= 0) and (x < (XMaxEcran - XMinEcran)) and
          (y >= 0) and (y < YMaxEcran) then PutPixel(x,y,CoulActive);
      END
      else
      BEGIN
        delta := delta-4.0*xi;
        temp := xi;
        xi := -yi;
        yi := temp;
        m1 := m3;
        temp := m2.x;
        m2.x := -m2.y;
        m2.y := temp;
        temp := m3.x;
        m3.x := -m3.y;
        m3.y := temp;
        dec(Q);
      END;
      if (Q<0) and (x2<=xi) and (y2>=yi) then Fin := true;
    END;
    FullPort;
END;

{}

PROCEDURE DessinePoint(X,Y : real);
VAR
  XPoint  : longint;
  YPoint  : longint;
  Xp,Yp   : array[1..4] of longint;
  EcartXM : longint;
  EcartXP : longint;
  EcartYM : longint;
  EcartYP : longint;

BEGIN
  CacheSouris;
  SetColor(CoulActive);
  HorsEcran := true;
  XPoint := trunc(XOrigine + INT(X * Echelle));
  YPoint := trunc(YOrigine - INT(Y * Echelle));
  if (XPoint > XMinEcran) and (YPoint > YMinEcran) then
     if (XPoint < XMaxEcran) and (YPoint < YMaxEcran) then
      BEGIN
        if (XPoint - 4) < XMinEcran then EcartXM := XPoint - XMinEcran
                                    else EcartXM := 4;
        if (XPoint + 4) > XMaxEcran then EcartXP := XMaxEcran - XPoint
                                    else EcartXP := 4;
        if (YPoint - 4) < YMinEcran then EcartYM := YPoint - YMinEcran
                                    else EcartYM := 4;
        if (YPoint + 4) > YMaxEcran then EcartYP := YMaxEcran - YPoint
                                    else EcartYP := 4;
        if EcartXM <= EcartYM then
          BEGIN
            Xp[1] := XPoint - EcartXM;
            Yp[1] := YPoint - EcartXM;
          END;
        if EcartXM > EcartYM then
          BEGIN
            Xp[1] := XPoint - EcartYM;
            Yp[1] := YPoint - EcartYM;
          END;
        if EcartXP <= EcartYP then
          BEGIN
            Xp[2] := XPoint + EcartXP;
            Yp[2] := YPoint + EcartXP;
          END;
        if EcartXP > EcartYP then
          BEGIN
            Xp[2] := XPoint + EcartYP;
            Yp[2] := YPoint + EcartYP;
          END;
        if EcartXP <= EcartYM then
          BEGIN
            Xp[3] := XPoint + EcartXP;
            Yp[3] := YPoint - EcartXP;
          END;
        if EcartXP > EcartYM then
          BEGIN
            Xp[3] := XPoint + EcartYM;
            Yp[3] := YPoint - EcartYM;
          END;
        if EcartXM <= EcartYP then
          BEGIN
            Xp[4] := XPoint - EcartXM;
            Yp[4] := YPoint + EcartXM;
          END;
        if EcartXM > EcartYP then
          BEGIN
            Xp[4] := XPoint - EcartYP;
            Yp[4] := YPoint + EcartYP;
          END;
        Line(XP[1],YP[1],XP[2],YP[2]);
        Line(XP[3],YP[3],XP[4],YP[4]);
        HorsEcran := false;
      END;
  MontreSouris;
END;

{}

PROCEDURE DessineOrigine;

BEGIN
  CacheSouris;
  SetColor(GrisClair);
  GraphPort;
  Circle((XOrigine - XMinEcran),(YOrigine - YMinEcran),6);
  FullPort;
  MontreSouris;
END;

{}

FUNCTION TestDansGraph(X,Y : integer):boolean;

BEGIN
  TestDansGraph := false ;
  if (X >= XMinEcran) and (X <= XMaxEcran) then
    if (Y >= YMinEcran) and (Y <= YMaxEcran) then
      TestDansGraph := true;
END;

{}

PROCEDURE DessineDroite(X,Y,A : real);
VAR
  XPoint    : longint;
  YPoint    : longint;
  Xp,Yp     : array [1..2] of longint;
  XTmp,YTmp : array [1..4] of longint;

PROCEDURE Droite0_90;
BEGIN
    XTmp[1] := XMinEcran;
    YTmp[1] := YPoint - round((XTmp[1] - XPoint) * Tan(A));
    if TestDansGraph(XTmp[1],YTmp[1]) then
    BEGIN
      FaitDessin := true;
      Xp[1] := XTmp[1];
      Yp[1] := YTmp[1];
    END
    else
    BEGIN
      YTmp[2] := YMaxEcran;
      XTmp[2] := XPoint + round((YPoint - YTmp[2]) / Tan(A));
      if TestDansGraph(XTmp[2],YTmp[2]) then
      BEGIN
        FaitDessin := true;
        Xp[1] := XTmp[2];
        Yp[1] := YTmp[2];
      END;
    END;
    if FaitDessin then
    BEGIN
      XTmp[1] := XMaxEcran;
      YTmp[1] := YPoint - round((XTmp[1] - XPoint) * Tan(A));
      if TestDansGraph(XTmp[1],YTmp[1]) then
      BEGIN
        Xp[2] := XTmp[1];
        Yp[2] := YTmp[1];
      END
      else
      BEGIN
        YTmp[2] := YMinEcran;
        XTmp[2] := XPoint + round((YPoint - YTmp[2]) / Tan(A));
        if TestDansGraph(XTmp[2],YTmp[2]) then
        BEGIN
          Xp[2] := XTmp[2];
          Yp[2] := YTmp[2];
        END;
      END;
    END;
END;

PROCEDURE Droite90_180;
BEGIN
  XTmp[1] := XMaxEcran;
  YTmp[1] := YPoint - round((XTmp[1] - XPoint) * Tan(A));
  if TestDansGraph(XTmp[1],YTmp[1]) then
  BEGIN
    FaitDessin := true;
    Xp[1] := XTmp[1];
    Yp[1] := YTmp[1];
  END
  else
  BEGIN
    YTmp[2] := YMaxEcran;
    XTmp[2] := XPoint + round((YPoint - YTmp[2]) / Tan(A));
    if TestDansGraph(XTmp[2],YTmp[2]) then
    BEGIN
      FaitDessin := true;
      Xp[1] := XTmp[2];
      Yp[1] := YTmp[2];
    END;
  END;
  if FaitDessin then
  BEGIN
    XTmp[1] := XMinEcran;
    YTmp[1] := YPoint - round((XTmp[1] - XPoint) * Tan(A));
    if TestDansGraph(XTmp[1],YTmp[1]) then
    BEGIN
      Xp[2] := XTmp[1];
      Yp[2] := YTmp[1];
    END
    else
    BEGIN
      YTmp[2] := YMinEcran;
      XTmp[2] := XPoint + round((YPoint - YTmp[2]) / Tan(A));
      if TestDansGraph(XTmp[2],YTmp[2]) then
      BEGIN
        Xp[2] := XTmp[2];
        Yp[2] := YTmp[2];
      END;
    END;
  END;
END;

PROCEDURE Droite180_270;
BEGIN
  XTmp[1] := XMaxEcran;
  YTmp[1] := YPoint - round((XTmp[1] - XPoint) * Tan(A));
  if TestDansGraph(XTmp[1],YTmp[1]) then
  BEGIN
    FaitDessin := true;
    Xp[1] := XTmp[1];
    Yp[1] := YTmp[1];
  END
  else
  BEGIN
    YTmp[2] := YMinEcran;
    XTmp[2] := XPoint + round((YPoint - YTmp[2]) / Tan(A));
    if TestDansGraph(XTmp[2],YTmp[2]) then
    BEGIN
      FaitDessin := true;
      Xp[1] := XTmp[2];
      Yp[1] := YTmp[2];
    END;
  END;
  if FaitDessin then
  BEGIN
    XTmp[1] := XMinEcran;
    YTmp[1] := YPoint - round((XTmp[1] - XPoint) * Tan(A));
    if TestDansGraph(XTmp[1],YTmp[1]) then
    BEGIN
      Xp[2] := XTmp[1];
      Yp[2] := YTmp[1];
    END
    else
    BEGIN
      YTmp[2] := YMaxEcran;
      XTmp[2] := XPoint + round((YPoint - YTmp[2]) / Tan(A));
      if TestDansGraph(XTmp[2],YTmp[2]) then
      BEGIN
        Xp[2] := XTmp[2];
        Yp[2] := YTmp[2];
      END;
    END;
  END;
END;

PROCEDURE Droite270_360;
BEGIN
  XTmp[1] := XMinEcran;
  YTmp[1] := YPoint - round((XTmp[1] - XPoint) * Tan(A));
  if TestDansGraph(XTmp[1],YTmp[1]) then
  BEGIN
    FaitDessin := true;
    Xp[1] := XTmp[1];
    Yp[1] := YTmp[1];
  END
  else
  BEGIN
    YTmp[2] := YMinEcran;
    XTmp[2] := XPoint + round((YPoint - YTmp[2]) / Tan(A));
    if TestDansGraph(XTmp[2],YTmp[2]) then
    BEGIN
      FaitDessin := true;
      Xp[1] := XTmp[2];
      Yp[1] := YTmp[2];
    END;
  END;
  if FaitDessin then
  BEGIN
    XTmp[1] := XMaxEcran;
    YTmp[1] := YPoint - round((XTmp[1] - XPoint) * Tan(A));
    if TestDansGraph(XTmp[1],YTmp[1]) then
    BEGIN
      Xp[2] := XTmp[1];
      Yp[2] := YTmp[1];
    END
    else
    BEGIN
      YTmp[2] := YMaxEcran;
      XTmp[2] := XPoint + round((YPoint - YTmp[2]) / Tan(A));
      if TestDansGraph(XTmp[2],YTmp[2]) then
      BEGIN
        Xp[2] := XTmp[2];
        Yp[2] := YTmp[2];
      END;
    END;
  END;
END;

BEGIN
  CacheSouris;
  SetColor(CoulActive);
  HorsEcran := true;
  FaitDessin := false;
  XPoint := XOrigine + round(X * Echelle);
  YPoint := YOrigine - round(Y * Echelle);

  if A = 0 then
    if (YPoint > YMinEcran) and (YPoint < YMaxEcran) then
    BEGIN
      Xp[1] := XMinEcran;
      Yp[1] := YPoint;
      Xp[2] := XMaxEcran;
      Yp[2] := YPoint;
      FaitDessin := true;
    END;
  if A = PiSur2 then
    if (XPoint > XMinEcran) and (XPoint < XMaxEcran) then
    BEGIN
      Xp[1] := XPoint;
      Yp[1] := YMaxEcran;
      Xp[2] := XPoint;
      Yp[2] := YMinEcran;
      FaitDessin := true;
    END;
  if A = Pi then
    if (YPoint > YMinEcran) and (YPoint < YMaxEcran) then
    BEGIN
      Xp[1] := XMaxEcran;
      Yp[1] := YPoint;
      Xp[2] := XMinEcran;
      Yp[2] := YPoint;
      FaitDessin := true;
    END;
  if A = (3 * PiSur2) then
    if (XPoint > XMinEcran) and (XPoint < XMaxEcran) then
    BEGIN
      Xp[1] := XPoint;
      Yp[1] := YMinEcran;
      Xp[2] := XPoint;
      Yp[2] := YMaxEcran;
      FaitDessin := true;
    END;
  if (A > 0) and (A < (PiSur2)) then Droite0_90;
  if (A > (PiSur2)) and (A < Pi) then Droite90_180;
  if (A > Pi) and (A < (3*PiSur2)) then Droite180_270;
  if (A > (3*PiSur2)) and (A < (2*Pi)) then Droite270_360;
  if FaitDessin then
  BEGIN
    Line(Xp[1],Yp[1],Xp[2],Yp[2]);
    HorsEcran := false;
  END;
  MontreSouris;
END;

{}

PROCEDURE DessineSegment(X,Y,A,XD,YD,XF,YF : real);
VAR
  XPoint    : longint;
  YPoint    : longint;
  XDebut    : longint;
  YDebut    : longint;
  XFin      : longint;
  YFin      : longint;
  Xp,Yp     : array [1..2] of longint;
  XTmp,YTmp : array [1..4] of longint;
  Debut,Fin : boolean; { Le point se trouve dans l'cran }

PROCEDURE Segment0_90;
BEGIN
    XTmp[1] := XMinEcran;
    YTmp[1] := YPoint - round((XTmp[1] - XPoint) * Tan(A));
    if TestDansGraph(XTmp[1],YTmp[1]) then
    BEGIN
      FaitDessin := true;
      Xp[1] := XTmp[1];
      Yp[1] := YTmp[1];
    END
    else
    BEGIN
      YTmp[2] := YMaxEcran;
      XTmp[2] := XPoint + round((YPoint - YTmp[2]) / Tan(A));
      if TestDansGraph(XTmp[2],YTmp[2]) then
      BEGIN
        FaitDessin := true;
        Xp[1] := XTmp[2];
        Yp[1] := YTmp[2];
      END;
    END;
    if FaitDessin then
    BEGIN
      XTmp[1] := XMaxEcran;
      YTmp[1] := YPoint - round((XTmp[1] - XPoint) * Tan(A));
      if TestDansGraph(XTmp[1],YTmp[1]) then
      BEGIN
        Xp[2] := XTmp[1];
        Yp[2] := YTmp[1];
      END
      else
      BEGIN
        YTmp[2] := YMinEcran;
        XTmp[2] := XPoint + round((YPoint - YTmp[2]) / Tan(A));
        if TestDansGraph(XTmp[2],YTmp[2]) then
        BEGIN
          Xp[2] := XTmp[2];
          Yp[2] := YTmp[2];
        END;
      END;
    END;
END;

PROCEDURE Segment90_180;
BEGIN
  XTmp[1] := XMaxEcran;
  YTmp[1] := YPoint - round((XTmp[1] - XPoint) * Tan(A));
  if TestDansGraph(XTmp[1],YTmp[1]) then
  BEGIN
    FaitDessin := true;
    Xp[1] := XTmp[1];
    Yp[1] := YTmp[1];
  END
  else
  BEGIN
    YTmp[2] := YMaxEcran;
    XTmp[2] := XPoint + round((YPoint - YTmp[2]) / Tan(A));
    if TestDansGraph(XTmp[2],YTmp[2]) then
    BEGIN
      FaitDessin := true;
      Xp[1] := XTmp[2];
      Yp[1] := YTmp[2];
    END;
  END;
  if FaitDessin then
  BEGIN
    XTmp[1] := XMinEcran;
    YTmp[1] := YPoint - round((XTmp[1] - XPoint) * Tan(A));
    if TestDansGraph(XTmp[1],YTmp[1]) then
    BEGIN
      Xp[2] := XTmp[1];
      Yp[2] := YTmp[1];
    END
    else
    BEGIN
      YTmp[2] := YMinEcran;
      XTmp[2] := XPoint + round((YPoint - YTmp[2]) / Tan(A));
      if TestDansGraph(XTmp[2],YTmp[2]) then
      BEGIN
        Xp[2] := XTmp[2];
        Yp[2] := YTmp[2];
      END;
    END;
  END;
END;

PROCEDURE Segment180_270;
BEGIN
  XTmp[1] := XMaxEcran;
  YTmp[1] := YPoint - round((XTmp[1] - XPoint) * Tan(A));
  if TestDansGraph(XTmp[1],YTmp[1]) then
  BEGIN
    FaitDessin := true;
    Xp[1] := XTmp[1];
    Yp[1] := YTmp[1];
  END
  else
  BEGIN
    YTmp[2] := YMinEcran;
    XTmp[2] := XPoint + round((YPoint - YTmp[2]) / Tan(A));
    if TestDansGraph(XTmp[2],YTmp[2]) then
    BEGIN
      FaitDessin := true;
      Xp[1] := XTmp[2];
      Yp[1] := YTmp[2];
    END;
  END;
  if FaitDessin then
  BEGIN
    XTmp[1] := XMinEcran;
    YTmp[1] := YPoint - round((XTmp[1] - XPoint) * Tan(A));
    if TestDansGraph(XTmp[1],YTmp[1]) then
    BEGIN
      Xp[2] := XTmp[1];
      Yp[2] := YTmp[1];
    END
    else
    BEGIN
      YTmp[2] := YMaxEcran;
      XTmp[2] := XPoint + round((YPoint - YTmp[2]) / Tan(A));
      if TestDansGraph(XTmp[2],YTmp[2]) then
      BEGIN
        Xp[2] := XTmp[2];
        Yp[2] := YTmp[2];
      END;
    END;
  END;
END;

PROCEDURE Segment270_360;
BEGIN
  XTmp[1] := XMinEcran;
  YTmp[1] := YPoint - round((XTmp[1] - XPoint) * Tan(A));
  if TestDansGraph(XTmp[1],YTmp[1]) then
  BEGIN
    FaitDessin := true;
    Xp[1] := XTmp[1];
    Yp[1] := YTmp[1];
  END
  else
  BEGIN
    YTmp[2] := YMinEcran;
    XTmp[2] := XPoint + round((YPoint - YTmp[2]) / Tan(A));
    if TestDansGraph(XTmp[2],YTmp[2]) then
    BEGIN
      FaitDessin := true;
      Xp[1] := XTmp[2];
      Yp[1] := YTmp[2];
    END;
  END;
  if FaitDessin then
  BEGIN
    XTmp[1] := XMaxEcran;
    YTmp[1] := YPoint - round((XTmp[1] - XPoint) * Tan(A));
    if TestDansGraph(XTmp[1],YTmp[1]) then
    BEGIN
      Xp[2] := XTmp[1];
      Yp[2] := YTmp[1];
    END
    else
    BEGIN
      YTmp[2] := YMaxEcran;
      XTmp[2] := XPoint + round((YPoint - YTmp[2]) / Tan(A));
      if TestDansGraph(XTmp[2],YTmp[2]) then
      BEGIN
        Xp[2] := XTmp[2];
        Yp[2] := YTmp[2];
      END;
    END;
  END;
END;

BEGIN
  CacheSouris;
  SetColor(CoulActive);
  HorsEcran := true;
  FaitDessin := false;
  XPoint := trunc(XOrigine + INT(X * Echelle));
  YPoint := trunc(YOrigine - INT(Y * Echelle));
  XDebut := trunc(XOrigine + INT(XD * Echelle));
  YDebut := trunc(YOrigine - INT(YD * Echelle));
  XFin := trunc(XOrigine + INT(XF * Echelle));
  YFin := trunc(YOrigine - INT(YF * Echelle));
  Debut := TestDansGraph(XDebut,YDebut);
  Fin := TestDansGraph(XFin,YFin);

  if (A = 0) and not FaitDessin then
    if (YPoint > YMinEcran) and (YPoint < YMaxEcran) then
    BEGIN
      Xp[1] := XMinEcran;
      Yp[1] := YPoint;
      Xp[2] := XMaxEcran;
      Yp[2] := YPoint;
      FaitDessin := true;
    END;

  if (A = (PiSur2)) and not FaitDessin then
    if (XPoint > XMinEcran) and (XPoint < XMaxEcran) then
    BEGIN
      Xp[1] := XPoint;
      Yp[1] := YMaxEcran;
      Xp[2] := XPoint;
      Yp[2] := YMinEcran;
      FaitDessin := true;
    END;

  if (A = Pi) and not FaitDessin then
    if (YPoint > YMinEcran) and (YPoint < YMaxEcran) then
    BEGIN
      Xp[1] := XMaxEcran;
      Yp[1] := YPoint;
      Xp[2] := XMinEcran;
      Yp[2] := YPoint;
      FaitDessin := true;
    END;

  if (A = (3*PiSur2)) and not FaitDessin then
    if (XPoint > XMinEcran) and (XPoint < XMaxEcran) then
    BEGIN
      Xp[1] := XPoint;
      Yp[1] := YMinEcran;
      Xp[2] := XPoint;
      Yp[2] := YMaxEcran;
      FaitDessin := true;
    END;

  if ((A > 0) and (A < (PiSur2))) and not FaitDessin then Segment0_90;
  if ((A > (PiSur2)) and (A < Pi)) and not FaitDessin then Segment90_180;
  if ((A > Pi) and (A < (3*PiSur2))) and not FaitDessin then Segment180_270;
  if ((A > (3*PiSur2)) and (A < (2*Pi))) and not FaitDessin then Segment270_360;

  if Debut then
  BEGIN
    Xp[1] := XDebut;
    Yp[1] := YDebut;
    FaitDessin := true;
  END;

  if Fin then
  BEGIN
    Xp[2] := XFin;
    Yp[2] := YFin;
    FaitDessin := true;
  END;

  if FaitDessin then
  BEGIN
    Line(Xp[1],Yp[1],Xp[2],Yp[2]);
    HorsEcran := false;
  END;
  MontreSouris;
END;

{}

PROCEDURE CercleDansGraph(XCentre,YCentre,Rayon : longint);
VAR
  CosTmp  : real;
  Angle  : real;
  Alpha   : array [1..8] of real;

BEGIN
  if (XCentre + Rayon) > XMaxEcran then
      BEGIN
        CosTmp := (XMaxEcran + 1 - XCentre) / Rayon;
        Angle := ArcCos(CosTmp);
        Alpha[1] := Angle;
        Alpha[8] := 2* Pi - Angle;
      END
      else
      BEGIN
        Alpha[1] := 0;
        Alpha[8] := 2 * Pi;
      END;
  if (YCentre - Rayon) < YMinEcran then
      BEGIN
        CosTmp := (YCentre - YMinEcran) / Rayon;
        Angle := ArcCos(CosTmp);
        Alpha[2] := Pi / 2 - Angle;
        Alpha[3] := Pi / 2 + Angle;
      END
      else
      BEGIN
        Alpha[2] := Pi / 2;
        Alpha[3] := Pi / 2;
      END;
  if (XCentre - Rayon) < XMinEcran then
      BEGIN
        CosTmp := (XCentre - XMinEcran ) / Rayon;
        Angle := ArcCos(CosTmp);
        Alpha[4] := Pi - Angle;
        Alpha[5] := Pi + Angle;
      END
      else
      BEGIN
        Alpha[4] := Pi;
        Alpha[5] := Pi;
      END;
  if (YCentre + Rayon) > YMaxEcran then
      BEGIN
        CosTmp := (YMaxEcran - YCentre) / Rayon;
        Angle := ArcCos(CosTmp);
        Alpha[6] := 3 * Pi / 2 - Angle;
        Alpha[7] := 3 * Pi / 2 + Angle;
      END
      else
      BEGIN
        Alpha[6] := 3 * Pi / 2;
        Alpha[7] := 3 * Pi / 2;
      END;
  if Alpha[2] > Alpha[1] then
      BEGIN
        DrawArc(XCentre,YCentre,Alpha[1],Alpha[2],Rayon);
        HorsEcran := false;
      END;
  if Alpha[4] > Alpha[3] then
      BEGIN
        DrawArc(XCentre,YCentre,Alpha[3],Alpha[4],Rayon);
        HorsEcran := false;
      END;
  if Alpha[6] > Alpha[5] then
      BEGIN
        DrawArc(XCentre,YCentre,Alpha[5],Alpha[6],Rayon);
        HorsEcran := false;
      END;
  if Alpha[8] > Alpha[7] then
      BEGIN
        DrawArc(XCentre,YCentre,Alpha[7],Alpha[8],Rayon);
        HorsEcran := false;
      END;
      FaitDessin := true;
END;

{}

PROCEDURE CercleXYM(XCentre,YCentre,Rayon : longint);
VAR
  CosTmp  : real;
  Angle  : real;
  Alpha   : array [1..2] of real;

BEGIN
  if (XCentre - Rayon) > XMinEcran then
  BEGIN
    CosTmp := (YMinEcran - YCentre) / Rayon;
    Angle := ArcCos(CosTmp);
    Alpha[1] := 3 * Pi / 2 - Angle;
  END
  else
  BEGIN
    CosTmp := (XCentre - XMinEcran) / Rayon;
    Angle := ArcCos(CosTmp);
    Alpha[1] := Pi + Angle;
  END;

  if (XCentre + Rayon) < XMaxEcran then
  BEGIN
    CosTmp := (YMinEcran - YCentre) / Rayon;
    Angle := ArcCos(CosTmp);
    Alpha[2] := 3 * Pi / 2 + Angle;
  END
  else
  BEGIN
    CosTmp := (XMaxEcran - XCentre) / Rayon;
    Angle := ArcCos(CosTmp);
    Alpha[2] := 2 * Pi - Angle;
  END;
  if Alpha[2] > Alpha[1] then
  BEGIN
    DrawArc(XCentre,YCentre,Alpha[1],Alpha[2],Rayon);
    HorsEcran := false;
  END;
  FaitDessin := true;
END;

{}

PROCEDURE CercleXYP(XCentre,YCentre,Rayon : longint);
VAR
  CosTmp  : real;
  Angle  : real;
  Alpha   : array [1..2] of real;

BEGIN
  if (XCentre - Rayon) > XMinEcran then
  BEGIN
    CosTmp := (YCentre - YMaxEcran) / Rayon;
    Angle := ArcCos(CosTmp);
    Alpha[2] := Pi / 2 + Angle;
  END
  else
  BEGIN
    CosTmp := (XCentre - XMinEcran) / Rayon;
    Angle := ArcCos(CosTmp);
    Alpha[2] := Pi - Angle;
  END;

  if (XCentre + Rayon) < XMaxEcran then
  BEGIN
    CosTmp := (YCentre - YMaxEcran) / Rayon;
    Angle := ArcCos(CosTmp);
    Alpha[1] := Pi / 2 - Angle;
  END
  else
  BEGIN
    CosTmp := (XMaxEcran - XCentre) / Rayon;
    Angle := ArcCos(CosTmp);
    Alpha[1] := Angle;
  END;
  if Alpha[2] > Alpha[1] then
  BEGIN
    DrawArc(XCentre,YCentre,Alpha[1],Alpha[2],Rayon);
    HorsEcran := false;
  END;
  FaitDessin := true;
END;

{}

PROCEDURE CercleYXM(XCentre,YCentre,Rayon : longint);
VAR
  CosTmp  : real;
  Angle  : real;
  Alpha   : array [1..2] of real;

BEGIN
  if (YCentre - Rayon) > YMinEcran then
  BEGIN
    CosTmp := (XMinEcran - XCentre) / Rayon;
    Angle := ArcCos(CosTmp);
    Alpha[2] := Angle;
  END
  else
  BEGIN
    CosTmp := (YCentre - YMinEcran) / Rayon;
    Angle := ArcCos(CosTmp);
    Alpha[2] := Pi / 2 - Angle;
  END;
  if (YCentre + Rayon) < YMaxEcran then
  BEGIN
    CosTmp := (XMinEcran - XCentre) / Rayon;
    Angle := ArcCos(CosTmp);
    Alpha[1] := - Angle;
  END
  else
  BEGIN
    CosTmp := (YMaxEcran - YCentre) / Rayon;
    Angle := ArcCos(CosTmp);
    Alpha[1] := -Pi / 2 + Angle;
  END;
  if Alpha[2] > Alpha[1] then
  BEGIN
    DrawArc(XCentre,YCentre,Alpha[1],Alpha[2],Rayon);
    HorsEcran := false;
  END;
  FaitDessin := true;
END;

{}

PROCEDURE CercleYXP(XCentre,YCentre,Rayon : longint);
VAR
  CosTmp  : real;
  Angle  : real;
  Alpha   : array [1..2] of real;

BEGIN
  if (YCentre - Rayon) > YMinEcran then
  BEGIN
    CosTmp := (XCentre - XMaxEcran) / Rayon;
    Angle := ArcCos(CosTmp);
    Alpha[1] := Pi - Angle;
  END
  else
  BEGIN
    CosTmp := (YCentre - YMinEcran) / Rayon;
    Angle := ArcCos(CosTmp);
    Alpha[1] := Pi / 2 + Angle;
  END;
  if (YCentre + Rayon) < YMaxEcran then
  BEGIN
    CosTmp := (XCentre - XMaxEcran) / Rayon;
    Angle := ArcCos(CosTmp);
    Alpha[2] := Pi + Angle;
  END
  else
  BEGIN
    CosTmp := (YMaxEcran - YCentre) / Rayon;
    Angle := ArcCos(CosTmp);
    Alpha[2] := 3 * Pi / 2 - Angle;
  END;
  if Alpha[2] > Alpha[1] then
  BEGIN
    DrawArc(XCentre,YCentre,Alpha[1],Alpha[2],Rayon);
    HorsEcran := false;
  END;
  FaitDessin := true;
END;

{}

PROCEDURE CercleXMYP(XCentre,YCentre,Rayon : longint);
VAR
  CosTmp  : real;
  Angle  : real;
  Alpha   : array [1..2] of real;

BEGIN
  if (YCentre - Rayon) > YMinEcran then
  BEGIN
    CosTmp := (XMinEcran - XCentre) / Rayon;
    Angle := ArcCos(CosTmp);
    Alpha[2] := Angle;
  END
  else
  BEGIN
    CosTmp := (YCentre - YMinEcran) / Rayon;
    Angle := ArcCos(CosTmp);
    Alpha[2] := Pi / 2  - Angle;
  END;
  CosTmp := (YCentre - YMaxEcran) / Rayon;
  Angle := ArcCos(CosTmp);
  Alpha[1] := Pi / 2 - Angle;
  if Alpha[2] > Alpha[1] then
  BEGIN
    DrawArc(XCentre,YCentre,Alpha[1],Alpha[2],Rayon);
    HorsEcran := false;
  END;
  FaitDessin := true;
END;

{}

PROCEDURE CercleXMYM(XCentre,YCentre,Rayon : longint);
VAR
  CosTmp  : real;
  Angle  : real;
  Alpha   : array [1..2] of real;

BEGIN
  if (YCentre + Rayon) < YMaxEcran then
  BEGIN
    CosTmp := (XMinEcran - XCentre) / Rayon;
    Angle := ArcCos(CosTmp);
    Alpha[1] :=  - Angle;
  END
  else
  BEGIN
    CosTmp := (YMaxEcran - YCentre) / Rayon;
    Angle := ArcCos(CosTmp);
    Alpha[1] := -Pi / 2 + Angle;
  END;
  CosTmp := (YMinEcran - YCentre) / Rayon;
  Angle := ArcCos(CosTmp);
  Alpha[2] := - Pi / 2 + Angle;
  if Alpha[2] > Alpha[1] then
  BEGIN
    DrawArc(XCentre,YCentre,Alpha[1],Alpha[2],Rayon);
    HorsEcran := false;
  END;
  FaitDessin := true;
END;

{}

PROCEDURE CercleXPYP(XCentre,YCentre,Rayon : longint);
VAR
  CosTmp  : real;
  Angle  : real;
  Alpha   : array [1..2] of real;

BEGIN
  if (YCentre - Rayon) > YMinEcran then
  BEGIN
    CosTmp := (XCentre - XMaxEcran) / Rayon;
    Angle := ArcCos(CosTmp);
    Alpha[1] := Pi - Angle;
  END
  else
  BEGIN
    CosTmp := (YCentre - YMinEcran) / Rayon;
    Angle := ArcCos(CosTmp);
    Alpha[1] := Pi / 2 + Angle;
  END;
  CosTmp := (YCentre - YMaxEcran) / Rayon;
  Angle := ArcCos(CosTmp);
  Alpha[2] := Pi / 2 + Angle;
  if Alpha[2] > Alpha[1] then
  BEGIN
    DrawArc(XCentre,YCentre,Alpha[1],Alpha[2],Rayon);
    HorsEcran := false;
  END;
  FaitDessin := true;
END;

{}

PROCEDURE CercleXPYM(XCentre,YCentre,Rayon : longint);
VAR
  CosTmp  : real;
  Angle  : real;
  Alpha   : array [1..2] of real;

BEGIN
  if (YCentre + Rayon) < YMaxEcran then
  BEGIN
    CosTmp := (XCentre - XMaxEcran) / Rayon;
    Angle := ArcCos(CosTmp);
    Alpha[2] := Pi + Angle;
  END
  else
  BEGIN
    CosTmp := (YMaxEcran - YCentre) / Rayon;
    Angle := ArcCos(CosTmp);
    Alpha[2] := 3 * Pi / 2 - Angle;
  END;
  CosTmp := (YMinEcran - YCentre) / Rayon;
  Angle := ArcCos(CosTmp);
  Alpha[1] := 3 * Pi / 2 - Angle;
  if Alpha[2] > Alpha[1] then
  BEGIN
    DrawArc(XCentre,YCentre,Alpha[1],Alpha[2],Rayon);
    HorsEcran := false;
  END;
  FaitDessin := true;
END;

{}

PROCEDURE DessineCercle(X,Y,R : real);
VAR
  XCentre : longint;
  YCentre : longint;
  Rayon   : longint;

BEGIN
  CacheSouris;
  SetColor(CoulActive);
  HorsEcran := true;
  FaitDessin := false;
  XCentre := round(XOrigine + round(X * Echelle));
  YCentre := round(YOrigine - round(Y * Echelle));
  Rayon   := round(R * Echelle);
  if ((XCentre + Rayon) < XMinEcran) then
  BEGIN
    MontreSouris;
    exit;
  END;
  if ((XCentre - Rayon) > XMaxEcran) then
  BEGIN
    MontreSouris;
    exit;
  END;
  if ((YCentre + Rayon) < YMinEcran) then
  BEGIN
    MontreSouris;
    exit;
  END;
  if ((YCentre - Rayon) > YMaxEcran) then
  BEGIN
    MontreSouris;
    exit;
  END;
  if Rayon > 3000 then
  BEGIN
    if (XCentre >= XMinEcran) and (XCentre <= XMaxEcran) then
    BEGIN
      if (YCentre >= YMinEcran) and (YCentre <= YMaxEcran) then
         CercleDansGraph(XCentre,YCentre,Rayon);
      if YCentre > YMaxEcran then CercleXYP(XCentre,YCentre,Rayon);
      if YCentre < YMinEcran then CercleXYM(XCentre,YCentre,Rayon);
    END;

    if (XCentre < XMinEcran) and not FaitDessin then
    BEGIN
      if (YCentre >= YMinEcran) and (YCentre <= YMaxEcran) then
         CercleYXM(XCentre,YCentre,Rayon);
      if (YCentre > YMaxEcran) then CercleXMYP(XCentre,YCentre,Rayon);
      if (YCentre < YMinEcran) then CercleXMYM(XCentre,YCentre,Rayon);
    END;

    if (XCentre > XMinEcran) and not FaitDessin then
    BEGIN
      if (YCentre >= YMinEcran) and (YCentre <= YMaxEcran) then
         CercleYXP(XCentre,YCentre,Rayon);
      if (YCentre > YMaxEcran) then CercleXPYP(XCentre,YCentre,Rayon);
      if (YCentre < YMinEcran) then CercleXPYM(XCentre,YCentre,Rayon);
    END;
   END
   else
   BEGIN
     DrawCircle(XCentre,YCentre,Rayon);
     HorsEcran := false;
   END;

  MontreSouris;
END;

{}

PROCEDURE ArcDansGraph(XCentre,YCentre,Rayon: longint;ADebut,AFin : real);
VAR
  CosTmp  : real;
  Angle  : real;
  Alpha   : array [1..8] of real;

BEGIN
  if (XCentre + Rayon) > XMaxEcran then
      BEGIN
        CosTmp := (XMaxEcran + 1 - XCentre) / Rayon;
        Angle := ArcCos(CosTmp);
        Alpha[1] := Angle;
        Alpha[8] := 2 * Pi - Angle;
      END
      else
      BEGIN
        Alpha[1] := 0;
        Alpha[8] := 2 * Pi;
      END;
      if (YCentre - Rayon) < YMinEcran then
      BEGIN
        CosTmp := (YCentre - YMinEcran) / Rayon;
        Angle := ArcCos(CosTmp);
        Alpha[2] := Pi / 2 - Angle;
        Alpha[3] := Pi / 2 + Angle;
      END
      else
      BEGIN
        Alpha[2] := Pi / 2;
        Alpha[3] := Pi / 2;
      END;
      if (XCentre - Rayon) < XMinEcran then
      BEGIN
        CosTmp := (XCentre - XMinEcran ) / Rayon;
        Angle := ArcCos(CosTmp);
        Alpha[4] := Pi - Angle;
        Alpha[5] := Pi + Angle;
      END
      else
      BEGIN
        Alpha[4] := Pi;
        Alpha[5] := Pi;
      END;
      if (YCentre + Rayon) > YMaxEcran then
      BEGIN
        CosTmp := (YMaxEcran - YCentre) / Rayon;
        Angle := ArcCos(CosTmp);
        Alpha[6] := 3 * Pi / 2 - Angle;
        Alpha[7] := 3 * Pi / 2 + Angle;
      END
      else
      BEGIN
        Alpha[6] := 3 * Pi / 2;
        Alpha[7] := 3 * Pi / 2;
      END;

      if Alpha[2] > Alpha[1] then
      BEGIN
        if (ADebut < Alpha[2]) and (ADebut > Alpha[1]) then Alpha[1] := ADebut;
        if (AFin < Alpha[2]) and (AFin > Alpha[1]) then Alpha[2] := AFin;
        if (Alpha[1] < AFin) and (Alpha[1] >= ADebut) then
        BEGIN
          DrawArc(XCentre,YCentre,Alpha[1],Alpha[2],Rayon);
          HorsEcran := false;
        END;
      END;

      if Alpha[4] > Alpha[3] then
      BEGIN
        if (ADebut < Alpha[4]) and (ADebut > Alpha[3]) then Alpha[3] := ADebut;
        if (AFin < Alpha[4]) and (AFin > Alpha[3]) then Alpha[4] := AFin;
        if (Alpha[3] < AFin) and (Alpha[3] >= ADebut) then
        BEGIN
          DrawArc(XCentre,YCentre,Alpha[3],Alpha[4],Rayon);
          HorsEcran := false;
        END;
      END;

      if Alpha[6] > Alpha[5] then
      BEGIN
        if (ADebut < Alpha[6]) and (ADebut > Alpha[5]) then Alpha[5] := ADebut;
        if (AFin < Alpha[6]) and (AFin > Alpha[5]) then Alpha[6] := AFin;
        if (Alpha[5] < AFin) and (Alpha[5] >= ADebut) then
        BEGIN
          DrawArc(XCentre,YCentre,Alpha[5],Alpha[6],Rayon);
          HorsEcran := false;
        END;
      END;

      if Alpha[8] > Alpha[7] then
      BEGIN
        if (ADebut < Alpha[8]) and (ADebut > Alpha[7]) then Alpha[7] := ADebut;
        if (AFin < Alpha[8]) and (AFin > Alpha[7]) then Alpha[8] := AFin;
        if (Alpha[7] < AFin) and (Alpha[7] >= ADebut) then
        BEGIN
          DrawArc(XCentre,YCentre,Alpha[7],Alpha[8],Rayon);
          HorsEcran := false;
        END;
      END;
      FaitDessin := true;
END;

{}

PROCEDURE ArcXYM(XCentre,YCentre,Rayon : longint;ADebut,AFin : real);
VAR
  CosTmp  : real;
  Angle  : real;
  Alpha   : array [1..2] of real;

BEGIN
  if (XCentre - Rayon) > XMinEcran then
  BEGIN
    CosTmp := (YMinEcran - YCentre) / Rayon;
    Angle := ArcCos(CosTmp);
    Alpha[1] := 3 * Pi / 2 - Angle;
  END
  else
  BEGIN
    CosTmp := (XCentre - XMinEcran) / Rayon;
    Angle := ArcCos(CosTmp);
    Alpha[1] := Pi + Angle;
  END;

  if (XCentre + Rayon) < XMaxEcran then
  BEGIN
    CosTmp := (YMinEcran - YCentre) / Rayon;
    Angle := ArcCos(CosTmp);
    Alpha[2] := 3 * Pi / 2 + Angle;
  END
  else
  BEGIN
    CosTmp := (XMaxEcran - XCentre) / Rayon;
    Angle := ArcCos(CosTmp);
    Alpha[2] := 2 * Pi - Angle;
  END;
  if Alpha[2] > Alpha[1] then
  BEGIN
    if (ADebut < Alpha[2]) and (ADebut > Alpha[1]) then Alpha[1] := ADebut;
    if (AFin < Alpha[2]) and (AFin > Alpha[1]) then Alpha[2] := AFin;
    if (Alpha[1] < AFin) and (Alpha[1] >= ADebut) then
        BEGIN
          DrawArc(XCentre,YCentre,Alpha[1],Alpha[2],Rayon);
          HorsEcran := false;
        END;
  END;
  FaitDessin := true;
END;

{}

PROCEDURE ArcXYP(XCentre,YCentre,Rayon : longint;ADebut,AFin : real);
VAR
  CosTmp  : real;
  Angle  : real;
  Alpha   : array [1..2] of real;

BEGIN
  if (XCentre - Rayon) > XMinEcran then
  BEGIN
    CosTmp := (YCentre - YMaxEcran) / Rayon;
    Angle := ArcCos(CosTmp);
    Alpha[2] := Pi / 2 + Angle;
  END
  else
  BEGIN
    CosTmp := (XCentre - XMinEcran) / Rayon;
    Angle := ArcCos(CosTmp);
    Alpha[2] := Pi - Angle;
  END;

  if (XCentre + Rayon) < XMaxEcran then
  BEGIN
    CosTmp := (YCentre - YMaxEcran) / Rayon;
    Angle := ArcCos(CosTmp);
    Alpha[1] := Pi / 2 - Angle;
  END
  else
  BEGIN
    CosTmp := (XMaxEcran - XCentre) / Rayon;
    Angle := ArcCos(CosTmp);
    Alpha[1] := Angle;
  END;
  if Alpha[2] > Alpha[1] then
  BEGIN
    if (ADebut < Alpha[2]) and (ADebut > Alpha[1]) then Alpha[1] := ADebut;
    if (AFin < Alpha[2]) and (AFin > Alpha[1]) then Alpha[2] := AFin;
    if (Alpha[1] < AFin) and (Alpha[1] >= ADebut) then
        BEGIN
          DrawArc(XCentre,YCentre,Alpha[1],Alpha[2],Rayon);
          HorsEcran := false;
        END;
  END;
  FaitDessin := true;
END;

{}

PROCEDURE ArcYXM(XCentre,YCentre,Rayon : longint;ADebut,AFin : real);
VAR
  CosTmp  : real;
  Angle  : real;
  Alpha   : array [1..4] of real;

BEGIN
  Alpha[1] := 0;
  Alpha[4] := 2 * Pi;
  if (YCentre - Rayon) > YMinEcran then
  BEGIN
    CosTmp := (XMinEcran - XCentre) / Rayon;
    Angle := ArcCos(CosTmp);
    Alpha[2] := Angle;
  END
  else
  BEGIN
    CosTmp := (YCentre - YMinEcran) / Rayon;
    Angle := ArcCos(CosTmp);
    Alpha[2] := Pi / 2 - Angle;
  END;
  if (YCentre + Rayon) < YMaxEcran then
  BEGIN
    CosTmp := (XMinEcran - XCentre) / Rayon;
    Angle := ArcCos(CosTmp);
    Alpha[3] := 2 * Pi - Angle;
  END
  else
  BEGIN
    CosTmp := (YMaxEcran - YCentre) / Rayon;
    Angle := ArcCos(CosTmp);
    Alpha[3] := 3 * Pi / 2 + Angle;
  END;

  if Alpha[2] > Alpha[1] then
  BEGIN
    if (ADebut < Alpha[2]) and (ADebut > Alpha[1]) then Alpha[1] := ADebut;
    if (AFin < Alpha[2]) and (AFin > Alpha[1]) then Alpha[2] := AFin;
    if (Alpha[1] < AFin) and (Alpha[1] >= ADebut) then
        BEGIN
          DrawArc(XCentre,YCentre,Alpha[1],Alpha[2],Rayon);
          HorsEcran := false;
        END;
  END;
  if Alpha[4] > Alpha[3] then
  BEGIN
    if (ADebut < Alpha[4]) and (ADebut > Alpha[3]) then Alpha[3] := ADebut;
    if (AFin < Alpha[4]) and (AFin > Alpha[3]) then Alpha[4] := AFin;
    if (Alpha[3] < AFin) and (Alpha[3] >= ADebut) then
        BEGIN
          DrawArc(XCentre,YCentre,Alpha[3],Alpha[4],Rayon);
          HorsEcran := false;
        END;
  END;
  FaitDessin := true;
END;

{}

PROCEDURE ArcYXP(XCentre,YCentre,Rayon : longint;ADebut,AFin : real);
VAR
  CosTmp  : real;
  Angle  : real;
  Alpha   : array [1..2] of real;

BEGIN
  if (YCentre - Rayon) > YMinEcran then
  BEGIN
    CosTmp := (XCentre - XMaxEcran) / Rayon;
    Angle := ArcCos(CosTmp);
    Alpha[1] := Pi - Angle;
  END
  else
  BEGIN
    CosTmp := (YCentre - YMinEcran) / Rayon;
    Angle := ArcCos(CosTmp);
    Alpha[1] := Pi / 2 + Angle;
  END;
  if (YCentre + Rayon) < YMaxEcran then
  BEGIN
    CosTmp := (XCentre - XMaxEcran) / Rayon;
    Angle := ArcCos(CosTmp);
    Alpha[2] := Pi + Angle;
  END
  else
  BEGIN
    CosTmp := (YMaxEcran - YCentre) / Rayon;
    Angle := ArcCos(CosTmp);
    Alpha[2] := 3 * Pi / 2 - Angle;
  END;
  if Alpha[2] > Alpha[1] then
  BEGIN
    if (ADebut < Alpha[2]) and (ADebut > Alpha[1]) then Alpha[1] := ADebut;
    if (AFin < Alpha[2]) and (AFin > Alpha[1]) then Alpha[2] := AFin;
    if (Alpha[1] < AFin) and (Alpha[1] >= ADebut) then
        BEGIN
          DrawArc(XCentre,YCentre,Alpha[1],Alpha[2],Rayon);
          HorsEcran := false;
        END;
  END;
  FaitDessin := true;
END;

{}

PROCEDURE ArcXMYP(XCentre,YCentre,Rayon : longint;ADebut,AFin : real);
VAR
  CosTmp  : real;
  Angle  : real;
  Alpha   : array [1..2] of real;

BEGIN
  if (YCentre - Rayon) > YMinEcran then
  BEGIN
    CosTmp := (XMinEcran - XCentre) / Rayon;
    Angle := ArcCos(CosTmp);
    Alpha[2] := Angle;
  END
  else
  BEGIN
    CosTmp := (YCentre - YMinEcran) / Rayon;
    Angle := ArcCos(CosTmp);
    Alpha[2] := Pi / 2 - Angle;
  END;
  CosTmp := (YCentre - YMaxEcran) / Rayon;
  Angle := ArcCos(CosTmp);
  Alpha[1] := Pi / 2 - Angle;
  if Alpha[2] > Alpha[1] then
  BEGIN
    if (ADebut < Alpha[2]) and (ADebut > Alpha[1]) then Alpha[1] := ADebut;
    if (AFin < Alpha[2]) and (AFin > Alpha[1]) then Alpha[2] := AFin;
    if (Alpha[1] < AFin) and (Alpha[1] >= ADebut) then
        BEGIN
          DrawArc(XCentre,YCentre,Alpha[1],Alpha[2],Rayon);
          HorsEcran := false;
        END;
  END;
  FaitDessin := true;
END;

{}

PROCEDURE ArcXMYM(XCentre,YCentre,Rayon : longint;ADebut,AFin : real);
VAR
  CosTmp  : real;
  Angle  : real;
  Alpha   : array [1..2] of real;

BEGIN
  if (YCentre + Rayon) < YMaxEcran then
  BEGIN
    CosTmp := (XMinEcran - XCentre) / Rayon;
    Angle := ArcCos(CosTmp);
    Alpha[1] := 2 * Pi - Angle;
  END
  else
  BEGIN
    CosTmp := (YMaxEcran - YCentre) / Rayon;
    Angle := ArcCos(CosTmp);
    Alpha[1] := 3 * Pi / 2 + Angle;
  END;
  CosTmp := (YMinEcran - YCentre) / Rayon;
  Angle := ArcCos(CosTmp);
  Alpha[2] := 3 * Pi / 2 + Angle;
  if Alpha[2] > Alpha[1] then
  BEGIN
    if (ADebut < Alpha[2]) and (ADebut > Alpha[1]) then Alpha[1] := ADebut;
    if (AFin < Alpha[2]) and (AFin > Alpha[1]) then Alpha[2] := AFin;
    if (Alpha[1] < AFin) and (Alpha[1] >= ADebut) then
        BEGIN
          DrawArc(XCentre,YCentre,Alpha[1],Alpha[2],Rayon);
          HorsEcran := false;
        END;
  END;
  FaitDessin := true;
END;

{}

PROCEDURE ArcXPYP(XCentre,YCentre,Rayon : longint;ADebut,AFin : real);
VAR
  CosTmp  : real;
  Angle  : real;
  Alpha   : array [1..2] of real;

BEGIN
  if (YCentre - Rayon) > YMinEcran then
  BEGIN
    CosTmp := (XCentre - XMaxEcran) / Rayon;
    Angle := ArcCos(CosTmp);
    Alpha[1] := Pi - Angle;
  END
  else
  BEGIN
    CosTmp := (YCentre - YMinEcran) / Rayon;
    Angle := ArcCos(CosTmp);
    Alpha[1] := Pi / 2 + Angle;
  END;
  CosTmp := (YCentre - YMaxEcran) / Rayon;
  Angle := ArcCos(CosTmp);
  Alpha[2] := Pi / 2 + Angle;
  if Alpha[2] > Alpha[1] then
  BEGIN
    if (ADebut < Alpha[2]) and (ADebut > Alpha[1]) then Alpha[1] := ADebut;
    if (AFin < Alpha[2]) and (AFin > Alpha[1]) then Alpha[2] := AFin;
    if (Alpha[1] < AFin) and (Alpha[1] >= ADebut) then
        BEGIN
          DrawArc(XCentre,YCentre,Alpha[1],Alpha[2],Rayon);
          HorsEcran := false;
        END;
  END;
  FaitDessin := true;
END;

{}

PROCEDURE ArcXPYM(XCentre,YCentre,Rayon : longint;ADebut,AFin : real);
VAR
  CosTmp  : real;
  Angle  : real;
  Alpha   : array [1..2] of real;

BEGIN
  if (YCentre + Rayon) < YMaxEcran then
  BEGIN
    CosTmp := (XCentre - XMaxEcran) / Rayon;
    Angle := ArcCos(CosTmp);
    Alpha[2] := Pi + Angle;
  END
  else
  BEGIN
    CosTmp := (YMaxEcran - YCentre) / Rayon;
    Angle := ArcCos(CosTmp);
    Alpha[2] := 3 * Pi / 2 - Angle;
  END;
  CosTmp := (YMinEcran - YCentre) / Rayon;
  Angle := ArcCos(CosTmp);
  Alpha[1] := 3 * Pi / 2 - Angle;
  if Alpha[2] > Alpha[1] then
  BEGIN
    if (ADebut < Alpha[2]) and (ADebut > Alpha[1]) then Alpha[1] := ADebut;
    if (AFin < Alpha[2]) and (AFin > Alpha[1]) then Alpha[2] := AFin;
    if (Alpha[1] < AFin) and (Alpha[1] >= ADebut) then
        BEGIN
          DrawArc(XCentre,YCentre,Alpha[1],Alpha[2],Rayon);
          HorsEcran := false;
        END;
  END;
  FaitDessin := true;
END;

{}

PROCEDURE DessineUnArc(X,Y,R,AD,AF : real);
VAR
  XCentre : longint;
  YCentre : longint;
  Rayon   : longint;

BEGIN
  CacheSouris;
  SetColor(CoulActive);
  HorsEcran := true;
  FaitDessin := false;
  XCentre := trunc(XOrigine + INT(X * Echelle));
  YCentre := trunc(YOrigine - INT(Y * Echelle));
  Rayon   := trunc(R * Echelle);
  if ((XCentre + Rayon) < XMinEcran) then
  BEGIN
    MontreSouris;
    exit;
  END;
  if ((XCentre - Rayon) > XMaxEcran) then
  BEGIN
    MontreSouris;
    exit;
  END;
  if ((YCentre + Rayon) < YMinEcran) then
  BEGIN
    MontreSouris;
    exit;
  END;
  if ((YCentre - Rayon) > YMaxEcran) then
  BEGIN
    MontreSouris;
    exit;
  END;

  if Rayon > 3000 then
  BEGIN
    if (XCentre >= XMinEcran) and (XCentre <= XMaxEcran) then
    BEGIN
      if (YCentre >= YMinEcran) and (YCentre <= YMaxEcran) then
         ArcDansGraph(XCentre,YCentre,Rayon,Ad,Af);
      if YCentre > YMaxEcran then ArcXYP(XCentre,YCentre,Rayon,Ad,Af);
      if YCentre < YMinEcran then ArcXYM(XCentre,YCentre,Rayon,Ad,Af);
    END;

    if (XCentre < XMinEcran) and not FaitDessin then
    BEGIN
      if (YCentre >= YMinEcran) and (YCentre <= YMaxEcran) then
         ArcYXM(XCentre,YCentre,Rayon,Ad,Af);
      if (YCentre > YMaxEcran) then ArcXMYP(XCentre,YCentre,Rayon,Ad,Af);
      if (YCentre < YMinEcran) then ArcXMYM(XCentre,YCentre,Rayon,Ad,Af);
    END;

    if (XCentre > XMinEcran) and not FaitDessin then
    BEGIN
      if (YCentre >= YMinEcran) and (YCentre <= YMaxEcran) then
         ArcYXP(XCentre,YCentre,Rayon,Ad,Af);
      if (YCentre > YMaxEcran) then ArcXPYP(XCentre,YCentre,Rayon,Ad,Af);
      if (YCentre < YMinEcran) then ArcXPYM(XCentre,YCentre,Rayon,Ad,Af);
    END;
    END
    else
    BEGIN
      DrawArc(XCentre,YCentre,Ad,Af,Rayon);
      HorsEcran := false;
    END;
  MontreSouris;
END;

{}

PROCEDURE DessineArc(X,Y,R,AD,AF : real);

BEGIN
  if AD = AF then DessineCercle(X,Y,R);
  if AD < AF then DessineUnArc(X,Y,R,AD,AF);
  if AD > AF then
  BEGIN
    DessineUnArc(X,Y,R,AD,AF);
  END;
END;

{}

FUNCTION DsGraph(X,Y : integer):boolean;

BEGIN
  DsGraph := false;
  if (X > XMinEcran) and (X < XMaxEcran) then
    if (Y > YMinEcran) and (Y < YMaxEcran) then DsGraph := true;
END;

{}

PROCEDURE EffaceBas;

VAR
  Ligne : string;
  il    : byte;
  s     : typSauvGrf;

BEGIN
  sauvegarde(s);
  CacheSouris;
  coulTexte(grClFond);
  FillChar(Ligne,MaxXTxt,#219);
  Ligne[0] := chr(MaxXTxt);
  for il := 1 to 3 do ecritXY(1,MaxYTxt - 3 + il,Ligne);
  restaure(s);
END;

{}

PROCEDURE AfficheBas(Fd,Tx : Couleur;Texte : str80);

VAR
  s : typSauvGrf;

BEGIN
  sauvegarde(s);
  CacheSouris;
  EffaceBas;
  CoulFond(Fd);
  CoulTexte(Tx);
  EcritXY(2,MaxYTxt - 1,Texte);
  restaure(s);
END;

{}

PROCEDURE Redessine;

VAR
  Pt      : PointPtr;
  Dr      : DroitePtr;
  Ce      : CerclePtr;
  Couleur : byte;

BEGIN
  CacheSouris;
  Couleur := CoulActive;
  GraphPort;
  ClearViewPort;
  FullPort;
  Dr := PremierDroite;
  While Dr <> nil do
  BEGIN
    CoulActive := Dr^.Couleur;
    if Dr^.Nom = 'DROITE' then
      with Dr^ do DessineDroite(X,Y,Angle);
    if Dr^.Nom = 'SEGMENT' then
      with Dr^ do DessineSegment(X,Y,Angle,XDebut,YDebut,XFin,YFin);
    Dr := Dr^.Suivant;
  END;
  Ce := PremierCercle;
  While Ce <> nil do
  BEGIN
    CoulActive := Ce^.Couleur;
    if Ce^.Nom = 'CERCLE' then
      with Ce^ do DessineCercle(XC,YC,R);
    if Ce^.Nom = 'ARC' then
      with Ce^ do DessineArc(XC,YC,R,ADebut,AFin);
    Ce := Ce^.Suivant;
  END;
  Pt := PremierPoint;
  While Pt <> nil do
  BEGIN
    CoulActive := Pt^.Couleur;
    DessinePoint(Pt^.X,Pt^.Y);
    if Pt^.Numero = 1 then DessineOrigine;
    Pt := Pt^.Suivant;
  END;
  MontreSouris;
  CoulActive := Couleur;
END;

{}

PROCEDURE RechercheMiniMaxi;

BEGIN
  MinX := -1;
  MinY := -1;
  MaxX := 1;
  MaxY := 1;
  PointEnCours := PremierPoint;
  while PointEnCours <> nil do
  BEGIN
    with PointEnCours^ do
    BEGIN
      if X < MinX then MinX := X;
      if X > MaxX then MaxX := X;
      if Y < MinY then MinY := Y;
      if Y > MaxY then MaxY := Y;
    END;
    PointEnCours := PointEnCours^.Suivant;
  END;
  DroiteEnCours := PremierDroite;
  while DroiteEnCours <> nil do
  BEGIN
    with DroiteEnCours^ do
    if Nom = 'SEGMENT' then
    BEGIN
      if XDebut < MinX then MinX := XDebut;
      if XDebut > MaxX then MaxX := XDebut;
      if YDebut < MinY then MinY := YDebut;
      if YDebut > MaxY then MaxY := YDebut;

      if XFin < MinX then MinX := XFin;
      if XFin > MaxX then MaxX := XFin;
      if YFin < MinY then MinY := YFin;
      if YFin > MaxY then MaxY := YFin;
    END
    else
    BEGIN
      if X < MinX then MinX := X;
      if X > MaxX then MaxX := X;
      if Y < MinY then MinY := Y;
      if Y > MaxY then MaxY := Y;
    END;
    DroiteEnCours := DroiteEnCours^.Suivant;
  END;
  CercleEnCours := PremierCercle;
  while CercleEnCours <> nil do
  BEGIN
    with CercleEnCours^ do
    BEGIN
      if (XC - R) < MinX then MinX := (XC - R);
      if (XC + R) > MaxX then MaxX := (XC + R);
      if (YC - R) < MinY then MinY := (YC - R);
      if (YC + R) > MaxY then MaxY := (YC + R);
    END;
    CercleEnCours := CercleEnCours^.Suivant;
  END;
END;

{}

PROCEDURE EchelleAuto;

VAR
  Tmp           : real;
  Ech1Tmp       : real;
  Ech2Tmp       : real;

BEGIN
  RechercheMiniMaxi;
  Ech1Tmp := (XMaxEcran - XMinEcran - 20) / (MaxX - MinX);
  Ech2Tmp := (YMaxEcran - YMinEcran - 20) / (MaxY - MinY);
  IF Ech2Tmp < Ech1Tmp then
  BEGIN
    Tmp := Ech1Tmp;
    Ech1Tmp := Ech2Tmp;
    Ech2Tmp := Tmp;
  END;
  Echelle := Ech1Tmp;
  if Echelle > MaxEchelle then Echelle := MaxEchelle;
  if Echelle < MinEchelle then Echelle := MinEchelle;
  Tmp := ((MinX + MaxX) / 2) * Echelle;
  XOrigine := XMilEcran - round(Tmp);
  Tmp := ((MinY + MaxY) / 2) * Echelle;
  YOrigine := YMilEcran + round(Tmp);
  Redessine;
  if Echelle = MaxEchelle then Alarme('Echelle maximale atteinte !');
  if Echelle = MinEchelle then Alarme('Echelle minimale atteinte !');
END;

{}

PROCEDURE CalculEchelle(X1,Y1,X2,Y2 : integer);

VAR
  Tmp           : real;
  Ech1Tmp       : real;
  Ech2Tmp       : real;
  AncienEchelle : real;

BEGIN
  AncienEchelle := Echelle;
  if X1 <> X2 then Ech1Tmp := (XMaxEcran - XMinEcran) / (X2 - X1)
              else Ech1Tmp := MaxEchelle;
  if Y1 <> Y2 then Ech2Tmp := (YMaxEcran - YMinEcran) / (Y2 - Y1)
              else Ech2Tmp := MaxEchelle;
  IF Ech2Tmp < Ech1Tmp then
  BEGIN
    Tmp := Ech1Tmp;
    Ech1Tmp := Ech2Tmp;
    Ech2Tmp := Tmp;
  END;
  Echelle := Echelle * Ech1Tmp;
  if Echelle > MaxEchelle then
  BEGIN
    Echelle := MaxEchelle;
    Ech1Tmp := Echelle / AncienEchelle;
  END;
  Tmp := ((X1 + X2) / 2) - XOrigine;
  XOrigine := XMilEcran - round(Tmp * Ech1Tmp);
  Tmp := ((Y1 + Y2) / 2) - YOrigine;
  YOrigine := YMilEcran - round(Tmp * Ech1Tmp);
END;

{}

PROCEDURE Fenetre(X1,Y1,X2,Y2 : integer);

VAR
  Tmp : integer;

BEGIN
  EffaceBas;
  if (X1 = X2) and (Y1 = Y2) then exit;
  if X2 < X1 then
  BEGIN
    Tmp := X1;
    X1 := X2;
    X2 := Tmp;
  END;
  if Y2 < Y1 then
  BEGIN
    Tmp := Y1;
    Y1 := Y2;
    Y2 := Tmp;
  END;
  CalculEchelle(X1,Y1,X2,Y2);
  SetWriteMode(CopyPut);
  Redessine;
  if Echelle = MaxEchelle then Alarme('Echelle maximale atteinte !');
  if Echelle = MinEchelle then Alarme('Echelle minimale atteinte !');
END;

{}

PROCEDURE Zoom(X1,Y1 : integer);

VAR
  AncienEchelle : real;
  Tmp           : real;
  Coeff         : real;
  Code          : integer;

BEGIN
  CacheSouris;
  AncienEchelle := Echelle;
  EffaceBas;
  reel := Echelle;
  REPEAT
    Saisie(1,MaxYTxt -1,4,3,grClFond,blanc,' Echelle (0 - 9999) : ');
    if reel = 0 then reel := 1;
    if (reel < 0) or (reel > 9999) then reel := -1;
  UNTIL (reel <> -1) or Abandon;
  if Abandon then
  BEGIN
    MontreSouris;
    exit;
  END;
  Coeff := reel;
  EffaceBas;
  MontreSouris;
  Echelle := Echelle * Coeff;
  if Echelle > MaxEchelle then
  BEGIN
    Echelle := MaxEchelle;
    Coeff := Echelle / AncienEchelle;
  END;
  if Echelle < MinEchelle then
  BEGIN
    Echelle := MinEchelle;
    Coeff := Echelle / AncienEchelle;
  END;
  Tmp := X1 - XOrigine;
  XOrigine := XMilEcran - round(Tmp * Coeff);
  Tmp := Y1 - YOrigine;
  YOrigine := YMilEcran - round(Tmp * Coeff);
  SetWriteMode(CopyPut);
  Redessine;
  if Echelle = MaxEchelle then Alarme('Echelle maximale atteinte !');
  if Echelle = MinEchelle then Alarme('Echelle minimale atteinte !');
END;

{}

PROCEDURE GereZoom;

TYPE
  Choix = (FaitZoom , FaitFenetre , Aucun);

VAR
  X1,Y1,X2,Y2 : integer;
  AncienX2    : integer;
  AncienY2    : integer;
  Fini        : boolean;
  LeChoix     : Choix;
  R : pointer;

BEGIN
  SauveRectTexte(1,MaxYTxt - 1,MaxXTxt - 1,MaxYTxt - 1,R);
  SetWriteMode(XorPut);
  X1 := PosSouris.X;
  Y1 := PosSouris.Y;
  X2 := X1;
  Y2 := Y1;
  Fini := false;
  LeChoix := Aucun;
  EffaceBas;
  AfficheBas(grClFond,grClTexte,'2 me point ou chelle');
  Delay(TempoSouris);
  BoutSouris := 0;
  while not (LeChoix in [FaitZoom , FaitFenetre]) do
    BEGIN
      if (PosSouris.X <> X2) and (PosSouris.Y <> Y2)
        and DsGraph(PosSouris.X,PosSouris.Y) then
      BEGIN
        AncienX2 := X2;
        AncienY2 := Y2;
        X2 := PosSouris.X;
        Y2 := PosSouris.Y;
        CacheSouris;
        Rectangle(X1,Y1,AncienX2,AncienY2);
        SetColor(GrisClair);
        Rectangle(X1,Y1,X2,Y2);
        MontreSouris;
      END;
        execSouris;
        if (BoutSouris = 2) and DsGraph(PosSouris.X,PosSouris.Y) then
            LeChoix := FaitFenetre;
        if keypressed then
        BEGIN
          CacheSouris;
          Rectangle(X1,Y1,X2,Y2);
          MontreSouris;
          LeChoix := FaitZoom;
        END;
    END;
  X2 := PosSouris.X;
  Y2 := PosSouris.Y;
  if LeChoix = FaitFenetre then Fenetre(X1,Y1,X2,Y2);
  if LeChoix = FaitZoom then Zoom(X1,Y1);
  (*Delay(TempoSouris);*)
  BoutSouris := 0;
  LitRectTexte(1,MaxYTxt - 1,MaxXTxt - 1,MaxYTxt - 1,R);
END;

{---------------------------------------------------------------------------}
{---------------------------------------------------------------------------}

{}
{                     Enregistre les diffrents pixels allums              }
{}

PROCEDURE EnregistreSouris(VAR XSouris,YSouris : integer);

VAR
  Coul    : byte;
  M,N     : integer;

BEGIN
  XSouris := PosSouris.X;
  YSouris := PosSouris.Y;
  CacheSouris;
  Coul := 0;
  N := 1;
  for M := (XSouris - 7) to (XSouris + 7) do
  BEGIN
    Coul := getpixel(M,YSouris) mod 8;
    if (Coul > 0) and (Coul < 8) then
       with TabPtsSouris[N] do
       BEGIN
         XPts := M;
         YPts := YSouris;
         CPts := Coul;
         N := N + 1;
       END;
  END;
  for M := (YSouris - 7) to (YSouris - 1) do
  BEGIN
    Coul := getpixel(XSouris,M) mod 8;
    if (Coul > 0) and (Coul < 7) then
       with TabPtsSouris[N] do
       BEGIN
         XPts := XSouris;
         YPts := M;
         CPts := Coul;
         N := N + 1;
       END;
  END;
  for M := (YSouris + 1) to (YSouris + 7) do
  BEGIN
    Coul := getpixel(XSouris,M) mod 8;
    if (Coul > 0) and (Coul < 7) then
       with TabPtsSouris[N] do
       BEGIN
         XPts := XSouris;
         YPts := M;
         CPts := Coul;
         N := N + 1;
       END;
  END;
  for M := N to 29 do
      with TabPtsSouris[M] do
        BEGIN
          XPts := -1;
          YPts := -1;
          CPts := 0;
        END;
  MontreSouris;
END;

{}
{                     Dtection d'un lment graphique                      }
{}


PROCEDURE Detection(VAR XSouris,YSouris : integer);
VAR
  Coul    : byte;
  M,N     : integer;
BEGIN
  XSouris := PosSouris.X;
  YSouris := PosSouris.Y;
  repeat
    Attente;
  until BoutSouris = 1;
  EnregistreSouris(XSouris,YSouris);
END;

{}
{                                 Point                                     }
{}
PROCEDURE CreePoint(X,Y : real);
BEGIN
  Fait := true;
  AjoutePoint(X,Y);
  DessinePoint(X,Y);
  if NbPoint = 1 then DessineOrigine;
  if HorsEcran then Alarme('Elment(s) dessin hors cran !');
END;

{}
{                                Droite                                     }
{}
PROCEDURE CreeDroite(X,Y,Angle,XD,YD,XF,YF : real);

BEGIN
  Fait := true;
  if Angle < 0 then Angle := Angle + Pi;
  if Angle > Pi then Angle := Angle - Pi;
  AjouteDroite(X,Y,Angle,XD,YD,XF,YF);
  if (XD = XF) and (YD = YF) then DessineDroite(X,Y,Angle)
                             else DessineSegment(X,Y,Angle,XD,YD,XF,YF);
  if HorsEcran then Alarme('Elment(s) dessin hors cran !');
END;

{}
{                                Cercle                                     }
{}
PROCEDURE CreeCercle(X,Y,R,XD,YD,AD,XF,YF,AF : real);
BEGIN
  Fait := true;
  if AD < 0 then AD := AD + (2 * Pi);
  if AD > (2 * Pi) then AD := AD - (2 * Pi);
  if AF < 0 then AF := AF + ( 2 * Pi);
  if AF > (2 * Pi) then AF := AF - (2 * Pi);
  AjouteCercle(X,Y,R,XD,YD,AD,XF,YF,AF);
  if (AD = AF) then DessineCercle(X,Y,R)
  else DessineArc(X,Y,R,AD,AF);
  if HorsEcran then Alarme('Elment(s) dessin hors cran !');
END;

{}
{                    Dtection d'un point                                   }
{}

FUNCTION DetectPoint:boolean;
VAR
  Trouve : boolean;
  M,N    : integer;
  XPoint : integer;
  YPoint : integer;
  CPoint : byte;

BEGIN
  Trouve := false;
  PointEnCours := PremierPoint;
  while (PointEnCours <> nil) and not Trouve do
    BEGIN
      XPoint := trunc(XOrigine + INT(PointEnCours^.X * Echelle));
      YPoint := trunc(YOrigine - INT(PointEnCours^.Y * Echelle));
      CPoint := PointEnCours^.Couleur;
      M := 1;
      while (TabPtsSouris[M].XPts <> -1) and (M <= 29) and not Trouve do
      BEGIN
        for N := -4 to 4 do
        BEGIN
          with TabPtsSouris[M] do
            if (XPoint + N) = XPts then
              if ((YPoint + N) = YPts) or ((YPoint - N) = YPts) then
                 Trouve := true;
        END;
        M := M + 1;
      END;
    if Trouve then break;
    if not ListePoint then break;
  END;
  if Trouve then unBip;
  DetectPoint := Trouve;
END;

{}
{              Vrification que le point cliqu se trouve sur le segment    }
{}

FUNCTION PointSurSegment(XTest,YTest : real):boolean;
VAR
  MinTest , MaxTest : real;

BEGIN
  PointSurSegment := false;
  with DroiteEnCours^ do
  BEGIN
    if XDebut < XFin then
    BEGIN
      MinTest := XDebut;
      MaxTest := XFin;
      if (XTest >= MinTest) and (XTest <= MaxTest) then
         PointSurSegment := true;
    END;
    if XDebut > XFin then
    BEGIN
      MinTest := XFin;
      MaxTest := XDebut;
      if (XTest >= MinTest) and (XTest <= MaxTest) then
         PointSurSegment := true;
    END;
    if YDebut < YFin then
    BEGIN
      MinTest := YDebut;
      MaxTest := YFin;
      if (YTest >= MinTest) and (YTest <= MaxTest) then
         PointSurSegment := true;
    END;
    if YDebut > YFin then
    BEGIN
      MinTest := YFin;
      MaxTest := YDebut;
      if (YTest >= MinTest) and (YTest <= MaxTest) then
         PointSurSegment := true;
    END;
  END;
END;

{}
{                    Dtection d'une droite                                 }
{}

FUNCTION DetectDroite:boolean;

VAR
  Trouve : boolean;
  XPoint : real;
  YPoint : real;
  CPoint : byte;
  M      : integer;
  Tmp    : real;
  Erreur : real;

BEGIN
  Trouve := false;
  DroiteEnCours := PremierDroite;
  while (DroiteEnCours <> nil) and not Trouve do
    BEGIN
      M := 1;
      while (TabPtsSouris[M].XPts <> -1) and (M <= 29) and not Trouve do
      BEGIN
        with DroiteEnCours^ do
          with TabPtsSouris[M] do
          BEGIN
            XPoint := (XPts - XOrigine) / Echelle;
            YPoint := -(YPts - YOrigine) / Echelle;
            CPoint := Couleur;
            Tmp := A * XPoint + B * YPoint + C;
            Erreur := (abs(A) + abs(B)) / Echelle;
            if (abs(Tmp) < Erreur) and (CPoint = CPts) then
              if Nom = 'SEGMENT' then
              BEGIN
                 if PointSurSegment(XPoint,YPoint) then Trouve := true;
              END
              else Trouve := true;
          END;
        M := M + 1;
      END;
      if Trouve then break;
      if not ListeDroite then break;
    END;
  if Trouve then unBip;
  DetectDroite := Trouve;
END;

{}
{                    Dtection d'un segment                                 }
{}

FUNCTION DetectSegment:boolean;

VAR
  Trouve : boolean;
  XPoint : real;
  YPoint : real;
  CPoint : byte;
  M      : integer;
  Tmp    : real;
  Erreur : real;

BEGIN
  Trouve := false;
  DroiteEnCours := PremierDroite;
  while (DroiteEnCours <> nil) and not Trouve do
    BEGIN
      M := 1;
      while (TabPtsSouris[M].XPts <> -1) and (M <= 29) and not Trouve do
      BEGIN
        with DroiteEnCours^ do
        if Nom = 'SEGMENT' then
          with TabPtsSouris[M] do
          BEGIN
            XPoint := (XPts - XOrigine) / Echelle;
            YPoint := -(YPts - YOrigine) / Echelle;
            CPoint := Couleur;
            Tmp := A * XPoint + B * YPoint + C;
            Erreur := (abs(A) + abs(B)) / Echelle;
            if (abs(Tmp) < Erreur) and (CPoint = CPts) then
              if PointSurSegment(XPoint,YPoint) then Trouve := true;
          END;
        M := M + 1;
      END;
      if Trouve then break;
      if not ListeDroite then break;
    END;
  if Trouve then unBip;
  DetectSegment := Trouve;
END;

{}
{              Vrification que le point cliqu se trouve sur l'arc         }
{}

FUNCTION PointSurArc(ATest : real):boolean;
VAR
  MinTest , MaxTest : real;

BEGIN
  PointSurArc := false;
  with CercleEnCours^ do
  BEGIN
    if ADebut < AFin then
    BEGIN
      MinTest := ADebut;
      MaxTest := AFin;
      if (ATest >= MinTest) and (ATest <= MaxTest) then
         PointSurArc := true;
    END;
    if ADebut > AFin then
    BEGIN
      MinTest := 0;
      MaxTest := AFin;
      if (ATest >= MinTest) and (ATest <= MaxTest) then
         PointSurArc := true;
      MinTest := ADebut;
      MaxTest := 2 * Pi;
      if (ATest >= MinTest) and (ATest <= MaxTest) then
         PointSurArc := true;
    END;
  END;
END;

{}
{                    Dtection d'un cercle                                  }
{}

FUNCTION DetectCercle:boolean;
VAR
  Trouve : boolean;
  XPoint : real;
  YPoint : real;
  CPoint : byte;
  APoint : real;
  M      : integer;
  Tmp    : real;
  Erreur : real;

BEGIN
  Trouve := false;
  CercleEnCours := PremierCercle;
  while (CercleEnCours <> nil) and not Trouve do
    BEGIN
      M := 1;
      while (TabPtsSouris[M].XPts <> -1) and (M <= 29) and not Trouve do
      BEGIN
        with CercleEnCours^ do
          with TabPtsSouris[M] do
          BEGIN
            XPoint := (XPts - XOrigine) / Echelle;
            YPoint := -(YPts - YOrigine) / Echelle;
            CPoint := Couleur;
            Tmp := sqr((XPoint - XC)) + sqr((YPoint - YC)) - sqr(R);
            Erreur := 2 * (1 + abs(XPoint - XC) + abs(YPoint - YC)) / Echelle;
            if (abs(Tmp) < Erreur) and (CPoint = CPts) then
              if Nom = 'ARC' then
              BEGIN
                APoint := CalculAngleSegment(XC,YC,XPoint,YPoint);
                if PointSurArc(APoint) then Trouve := true;
              END
              else Trouve := true;
          END;
        M := M + 1;
      END;
      if Trouve then break;
      if not ListeCercle then break;
    END;
  if Trouve then unBip;
  DetectCercle := Trouve;
END;

{}
{                    Dtection d'un arc                                     }
{}

FUNCTION DetectArc:boolean;
VAR
  Trouve : boolean;
  XPoint : real;
  YPoint : real;
  CPoint : byte;
  APoint : real;
  M      : integer;
  Tmp    : real;
  Erreur : real;

BEGIN
  Trouve := false;
  CercleEnCours := PremierCercle;
  while (CercleEnCours <> nil) and not Trouve do
    BEGIN
      M := 1;
      while (TabPtsSouris[M].XPts <> -1) and (M <= 29) and not Trouve do
      BEGIN
        with CercleEnCours^ do
        if Nom = 'ARC' then
          with TabPtsSouris[M] do
          BEGIN
            XPoint := (XPts - XOrigine) / Echelle;
            YPoint := -(YPts - YOrigine) / Echelle;
            CPoint := Couleur;
            Tmp := sqr((XPoint - XC)) + sqr((YPoint - YC)) - sqr(R);
            Erreur := 2 * (1 + abs(XPoint - XC) + abs(YPoint - YC)) / Echelle;
            if (abs(Tmp) < Erreur) and (CPoint = CPts) then
            BEGIN
             APoint := CalculAngleSegment(XC,YC,XPoint,YPoint);
             if PointSurArc(APoint) then Trouve := true;
            END;
          END;
        M := M + 1;
      END;
      if Trouve then break;
      if not ListeCercle then break;
    END;
  if Trouve then unBip;
  DetectArc := Trouve;
END;

{}

PROCEDURE Test_Abandon;

BEGIN
  if not DsGraph(PosSouris.X,PosSouris.Y) and (BoutSouris = 1) then
  BEGIN
    Abandonner := true;
    MemoX := PosSouris.X;
    MemoY := PosSouris.Y;
    while keypressed do car := readkey;
  END;
END;

{}

PROCEDURE Alarme(Texte : str80);

BEGIN
  Beep;
  CacheSouris;
  AfficheBas(blanc,orange,' ' + Texte +
     ' , appuyez sur une touche ou cliquez .');
  MontreSouris;
  Attente;
  if keypressed then car := readkey;
  if BoutSouris <> 0 then BoutSouris := 0;
  EffaceBas;
END;

{}

PROCEDURE CreationImpossible;

BEGIN
  Alarme('Cration impossible');
END;
{}

BEGIN

END.