UNIT CaoGlob;

{}
{                                                                           }
{                                CaoGlob                                    }
{                                                                           }
{             - Liste complte des variables utilises -                    }
{                                                                           }
{}

INTERFACE

USES
    Turbolib,
    Protect;

{}

CONST
  MaxPoint   = 2000;
  MaxDroite  = 2000;
  MaxCercle  = 2000;
  MaxEchelle : real = 10000;
  MinEchelle : real = 0.002;

  

  NomCh = '';
  VersionCh = 'ߑ';
  Createur_DateCh = 'ܓƻ';

  Extension : ficExt = 'MAO';

  TempoSouris = 250;

  CasePrecedent = 18;
  CaseGeneral   = 19;

  MenuGeneral = 1;
    CaseFichier = 1;
    CaseCreer   = 2;
    CaseCreer2  = 3;
    CaseGroupe  = 4;
    CasePapier  = 5;
    CaseConfig  = 6;
    CaseQuitter = 7;

  MenuFichier = 2;
    CaseNouveau     = 1;
    CaseOuvrir      = 2;
    CaseSauver      = 3;
    CaseSauver_sous = 4;

  MenuCreer  = 3;
    CasePoints   = 1;
    CaseMilieu   = 2;
    CaseExtreme  = 3;
    CaseIntersec = 4;
    CaseDroites  = 6;
    CaseMediane  = 7;
    CaseBissect  = 8;
    CasePerpend  = 9;
    CaseCentre   = 11;
    CaseRayon    = 12;
    CaseRien     = 13;
    CaseTourne   = 15;
    CaseSymetrie = 16;
    CasePolaire  = 17;


  MenuCreer2 = 4;
    CasePoint   = 1;
    CaseDroite  = 2;
    CaseCercle  = 3;
    CaseCercle2 = 4;
    CaseCercle3 = 5;

  MenuGroupe = 5;

  MenuPapier = 6;
    CaseCopieEcran = 1;
    CaseTraceEcran = 2;
    CaseTrace      = 3;
    CaseFormeCan   = 4;
    CaseTtFormeCan = 5;

  MenuConfig = 7;
    CaseImprime = 1;
    CaseTraceur = 2;

  MenuPoint  = 8;
    CasePtXY      = 1;
    CasePtRA      = 2;
    CasePtDeplXY  = 3;
    CasePtDeplRA  = 4;
    CaseptCentre  = 5;
    CasePtExtreme = 6;
    CasePtMilieu  = 7;
    CasePtInter   = 8;
    CasePtSym     = 9;
    CasePtTourne  = 10;
    CasePtMil2Pts = 11;

  MenuDroite = 9;
    CaseDrPtA      = 1;
    CaseDrPtParal  = 2;
    CaseDrCercleA  = 3;
    CaseDrParalD   = 4;
    CaseDrSym      = 5;
    CaseDrTourne   = 6;
    CaseDrPtCercle = 7;
    CaseDr2Pts     = 8;
    CaseDrPerpen   = 9;
    CaseDrParalC   = 10;
    CaseDr2Cercles = 11;
    CaseDrMedia    = 12;
    CaseDrBissec   = 13;

  MenuCercle = 10;
    CaseCeXYR      = 1;
    CaseCeCentreR  = 2;
    CaseCeDeplXY   = 3;
    CaseCeDeplRA   = 4;
    CaseCeConcenR  = 5;
    CaseCeConcenD  = 6;
    CaseCeSym      = 7;
    CaseCeTourne   = 8;

  MenuCercle2 = 11;
    CaseCeCentrePt = 1;
    CaseCeCentreDr = 2;
    CaseCeCentreCe = 3;
    CaseCePtDrR    = 4;
    CaseCePtCeR    = 5;
    CaseCe2PtsR    = 6;
    CaseCe2DrR     = 7;
    CaseCeDrCeR    = 8;
    CaseCe2CeR     = 9;

  MenuCercle3 = 12;
    CaseCe3Pts     = 1;
    CaseCe2PtsDr   = 2;
    CaseCe2PtsCe   = 3;
    CaseCePt2Dr    = 4;
    CaseCePtDrCe   = 5;
    CaseCePt2Ce    = 6;
    CaseCe3Dr      = 7;
    CaseCe2DrCe    = 8;
    CaseCe2CeDr    = 9;
    CaseCe3Ce      = 10;

{}

TYPE
  PointPtr = ^Point;
  Point = RECORD
           Nom     : string[7]; { type d'lment = point }
           Numero  : integer; { numro du point }
           X       : real; { coordonne en X du point }
           Y       : real; { coordonne en Y du point }
           Couleur : byte; { couleur du point }
           Couche  : byte; { couche ou se trouve le point }
           Select  : boolean; { tat slectionn ou non du point }
           Visible : boolean; { tat visible ou non du point }
           Suivant : PointPtr;
         END;

  DroitePtr = ^Droite;
  Droite = RECORD
           Nom     : string[7]; { type d'lment: droite ou segment }
           Numero  : integer; { numro de l'lment }
           X       : real; { coordonne en X d'un point }
           Y       : real; { coordonne en Y d'un point }
           Angle   : real; { angle par rapport  l'horizontale }
           XDebut  : real; { coordonne en X du point de dpart }
           YDebut  : real; { coordonne en Y du point de dpart }
           XFin    : real; { coordonne en X du point de fin }
           YFin    : real; { coordonne en Y du point de fin }
           A       : real; { coef. quation droite Ax + By + C = 0}
           B       : real; { coef. quation droite Ax + By + C = 0}
           C       : real; { coef. quation droite Ax + By + C = 0}
           Couleur : byte; { couleur du point }
           Couche  : byte; { couche ou se trouve le point }
           Select  : boolean; { tat slectionn ou non du point }
           Visible : boolean; { tat visible ou non du point }
           Suivant : DroitePtr;
         END;

  CerclePtr = ^Cercle;
  Cercle = RECORD
           Nom     : string[7]; { type d'lment: arc ou cercle }
           Numero  : integer; { numro de l'lment }
           XC      : real; { coordonne en X du point de centre }
           YC      : real; { coordonne en Y du point de centre }
           R       : real; { rayon }
           XDebut  : real; { coordonne en X du point de dpart }
           YDebut  : real; { coordonne en Y du point de dpart }
           ADebut  : real; { angle par rapport  l'horizontale du depart }
           XFin    : real; { coordonne en X du point de fin }
           YFin    : real; { coordonne en Y du point de fin }
           AFin    : real; { angle par rapport  l'horizontale de la fin }
           Couleur : byte; { couleur du point }
           Couche  : byte; { couche ou se trouve le point }
           Select  : boolean; { tat slectionn ou non du point }
           Visible : boolean; { tat visible ou non du point }
           Suivant : CerclePtr;
         END;

  PtsSouris = RECORD
                XPts : integer;
                YPts : integer;
                CPts : byte;
              END;

{}

VAR
  Nom : str80;
  Version : str80;
  Createur_Date : str80;


  SommetTas  : ^integer;
  Fait       : boolean;

  Nom_Fichier : nomFichier; { Nom du fichier }
  Fichier     : text;
  Modifie     : boolean; { Le fichier  t modifi }
  NbModif     : integer; { Comptage des modifications effectues }

  Abandonner : boolean; { On abandonne la fonction en court }
  MemoX      : integer; { Memorisation de l'X souris lors abandon }
  MemoY      : integer; { Memorisation de l'Y souris lors abandon }

  XMinEcran  : integer; { Cote mini de l'affichage en X }
  XMaxEcran  : integer; { Cote maxi de l'affichage en X }
  YMinEcran  : integer; { Cote mini de l'affichage en Y }
  YMaxEcran  : integer; { Cote maxi de l'affichage en Y }
  XMilEcran  : integer; { Cote du milieu de l'affichage en X }
  YMilEcran  : integer; { Cote du milieu de l'affichage en Y }

  Echelle    : real;    { Echelle relative de l'affichage }
  XOrigine   : longint; { Cote en X de l'origine }
  YOrigine   : longint; { Cote en Y de l'origine }

  CoulActive : integer; { Couleur active d'affichage }
  HorsEcran  : boolean; { L'lment  t dessin hors cran }

  NbPoint    : integer; { Nombre de points }
  NbDroite   : integer; { Nombre de droites }
  NbCercle   : integer; { Nombre de cercles }
  PremierPoint    : PointPtr; { Pointeur sur le premier point cr }
  PremierDroite   : DroitePtr; { Pointeur sur la premire droite cre }
  PremierCercle   : CerclePtr; { Pointeur sur le premier cercle cr }

  PointEnCours    : PointPtr; { Pointeur sur le point en cours }
  DroiteEnCours   : DroitePtr; { Pointeur sur la droite en cours }
  CercleEnCours   : CerclePtr; { Pointeur sur le cercle en cours }

  MaxX       : real; { Taille maximum en X }
  MinX       : real; { Taille minimum en X }
  MaxY       : real; { Taille maximum en Y }
  MinY       : real; { Taille minimum en Y }

  AffCoord   : boolean; { Affichage des coordonnes }
  OldCoordX  : real;
  OldCoordY  : real;

  FormeSouris : str80;

  TabPtsSouris : array [1..29] of PtsSouris;
  PiSur2       : real;
  car          : char;

  NbLignesParPage : word;

{}

PROCEDURE InitEchelle;

IMPLEMENTATION

{}

PROCEDURE InitEchelle;

BEGIN
  Echelle := 10;
  MinX := -1;
  MaxX := 1;
  MinY := -1;
  MaxY := 1;
  XOrigine  := XMilEcran;
  YOrigine  := YMilEcran;
END;

{}

BEGIN
  Nom := Decode1(NomCh,3);
  Version := Decode1(VersionCh,6);
  Createur_Date := Decode1(Createur_DateCh,4);
  NbPoint := 0;
  NbDroite := 0;
  NbCercle := 0;
  PiSur2 := Pi/2;
  CoulActive := vert;
  HorsEcran := false;
  NbLignesParPage := 64;
  Modifie := false;
  NbModif := 0;
  Nom_Fichier := '';
END.