UNIT CaoFic;

{}
{                                                                           }
{                                CaoFic                                     }
{                                                                           }
{                 - Routines de gestion de fichiers -                       }
{                                                                           }
{}

INTERFACE

USES
    Turbolib,
    GrafLib,
    GrafFtr,
    CaoGlob,
    CaoMnu,
    CaoBdd,
    CaoDiv,
    CaoGra;

PROCEDURE NouveauFichier;
PROCEDURE OuvrirFichier;
PROCEDURE SauverFichier;
PROCEDURE SauverFichierSous;

{}

IMPLEMENTATION

PROCEDURE EcriturePoint;

VAR
  Ligne : string;
  Tmp   : string;

BEGIN
  with PointEnCours^ do
  BEGIN
    Ligne := Nom + ',';
    str(Numero,Tmp);
    Ligne := Ligne + Tmp + ',';
    str(X,Tmp);
    Ligne := Ligne + Tmp + ',';
    str(Y,Tmp);
    Ligne := Ligne + Tmp + ',';
    str(Couleur,Tmp);
    Ligne := Ligne + Tmp + ',';
    str(Couche,Tmp);
    Ligne := Ligne + Tmp + ',';
    if Select then Ligne := Ligne + '1,'
              else Ligne := Ligne + '0,';
    if Visible then Ligne := Ligne + '1'
               else Ligne := Ligne + '0';
  END;
  writeln(Fichier,Ligne);
END;

{}

PROCEDURE EcritureDroite;

VAR
  Ligne : string;
  Tmp   : string;

BEGIN
  with DroiteEnCours^ do
  BEGIN
    Ligne := Nom + ',';
    str(Numero,Tmp);
    Ligne := Ligne + Tmp + ',';
    str(X,Tmp);
    Ligne := Ligne + Tmp + ',';
    str(Y,Tmp);
    Ligne := Ligne + Tmp + ',';
    str(Angle,Tmp);
    Ligne := Ligne + Tmp + ',';
    str(XDebut,Tmp);
    Ligne := Ligne + Tmp + ',';
    str(YDebut,Tmp);
    Ligne := Ligne + Tmp + ',';
    str(XFin,Tmp);
    Ligne := Ligne + Tmp + ',';
    str(YFin,Tmp);
    Ligne := Ligne + Tmp + ',';
    writeln(Fichier,Ligne);

    str(A,Tmp);
    Ligne := Tmp + ',';
    str(B,Tmp);
    Ligne := Ligne + Tmp + ',';
    str(C,Tmp);
    Ligne := Ligne + Tmp + ',';
    str(Couleur,Tmp);
    Ligne := Ligne + Tmp + ',';
    str(Couche,Tmp);
    Ligne := Ligne + Tmp + ',';
    if Select then Ligne := Ligne + '1,'
              else Ligne := Ligne + '0,';
    if Visible then Ligne := Ligne + '1'
               else Ligne := Ligne + '0';
    writeln(Fichier,Ligne);
  END;
END;

{}

PROCEDURE EcritureCercle;

VAR
  Ligne : string;
  Tmp   : string;

BEGIN
  with CercleEnCours^ do
  BEGIN
    Ligne := Nom + ',';
    str(Numero,Tmp);
    Ligne := Ligne + Tmp + ',';
    str(Xc,Tmp);
    Ligne := Ligne + Tmp + ',';
    str(Yc,Tmp);
    Ligne := Ligne + Tmp + ',';
    str(R,Tmp);
    Ligne := Ligne + Tmp + ',';
    writeln(Fichier,Ligne);

    str(XDebut,Tmp);
    Ligne := Tmp + ',';
    str(YDebut,Tmp);
    Ligne := Ligne + Tmp + ',';
    str(ADebut,Tmp);
    Ligne := Ligne + Tmp + ',';
    str(XFin,Tmp);
    Ligne := Ligne + Tmp + ',';
    str(YFin,Tmp);
    str(AFin,Tmp);
    Ligne := Ligne + Tmp + ',';
    Ligne := Ligne + Tmp + ',';
    str(Couleur,Tmp);
    Ligne := Ligne + Tmp + ',';
    str(Couche,Tmp);
    Ligne := Ligne + Tmp + ',';
    if Select then Ligne := Ligne + '1,'
              else Ligne := Ligne + '0,';
    if Visible then Ligne := Ligne + '1'
               else Ligne := Ligne + '0';
    writeln(Fichier,Ligne);
  END;
END;

{}

PROCEDURE EcritureFichier(NomDuFichier : nomFichier);

VAR
  Ligne : string;
  Tmp   : string;

BEGIN
  assign(Fichier,NomDuFichier);
  rewrite(Fichier);
  Ligne := NomDuFichier;
  writeln(Fichier,Ligne);
  Ligne := Nom + ',' + Version;
  writeln(Fichier,Ligne);
  str(NbPoint,Tmp);
  Ligne := Tmp + ',';
  str(NbDroite,Tmp);
  Ligne := Ligne + Tmp + ',';
  str(NbCercle,Tmp);
  Ligne := Ligne + Tmp;
  writeln(Fichier,Ligne);
  PointEnCours := PremierPoint;
  if PointEnCours <> nil then
  BEGIN
    EcriturePoint;
    while ListePoint do EcriturePoint;
  END;
  DroiteEnCours := PremierDroite;
  if DroiteEnCours <> nil then
  BEGIN
    EcritureDroite;
    while ListeDroite do EcritureDroite;
  END;
  CercleEnCours := PremierCercle;
  if CercleEnCours <> nil then
  BEGIN
    EcritureCercle;
    while ListeCercle do EcritureCercle;
  END;
  Modifie := false;
  NbModif := 0;
  close(Fichier);
END;

{}

PROCEDURE LecturePoint;

VAR
  Ligne  : string;
  Tmp    : string;
  Erreur : integer;
  XPoint : real;
  YPoint : real;

BEGIN
  readln(Fichier,Ligne);
  Tmp := copy(Ligne,1,pos(',',Ligne)-1);
  delete(Ligne,1,pos(',',Ligne));
  Tmp := copy(Ligne,1,pos(',',Ligne)-1);
  delete(Ligne,1,pos(',',Ligne));
  val(Tmp,NbPoint,Erreur);
  NbPoint := NbPoint - 1;
  Tmp := copy(Ligne,1,pos(',',Ligne)-1);
  delete(Ligne,1,pos(',',Ligne));
  val(Tmp,XPoint,Erreur);
  Tmp := copy(Ligne,1,pos(',',Ligne)-1);
  delete(Ligne,1,pos(',',Ligne));
  val(Tmp,YPoint,Erreur);
  Tmp := copy(Ligne,1,pos(',',Ligne)-1);
  delete(Ligne,1,pos(',',Ligne));
  val(Tmp,CoulActive,Erreur);
  AjoutePoint(XPoint,YPoint);
END;

{}

PROCEDURE LectureDroite;

VAR
  Ligne  : string;
  Tmp    : string;
  Erreur : integer;
  X,Y,Angle : real;
  XD,YD : real;
  XF,YF : real;

BEGIN
  readln(Fichier,Ligne);
  Tmp := copy(Ligne,1,pos(',',Ligne)-1);
  delete(Ligne,1,pos(',',Ligne));
  Tmp := copy(Ligne,1,pos(',',Ligne)-1);
  delete(Ligne,1,pos(',',Ligne));
  val(Tmp,NbDroite,Erreur);
  NbDroite := NbDroite - 1;
  Tmp := copy(Ligne,1,pos(',',Ligne)-1);
  delete(Ligne,1,pos(',',Ligne));
  val(Tmp,X,Erreur);
  Tmp := copy(Ligne,1,pos(',',Ligne)-1);
  delete(Ligne,1,pos(',',Ligne));
  val(Tmp,Y,Erreur);
  Tmp := copy(Ligne,1,pos(',',Ligne)-1);
  delete(Ligne,1,pos(',',Ligne));
  val(Tmp,Angle,Erreur);
  Tmp := copy(Ligne,1,pos(',',Ligne)-1);
  delete(Ligne,1,pos(',',Ligne));
  val(Tmp,XD,Erreur);
  Tmp := copy(Ligne,1,pos(',',Ligne)-1);
  delete(Ligne,1,pos(',',Ligne));
  val(Tmp,YD,Erreur);
  Tmp := copy(Ligne,1,pos(',',Ligne)-1);
  delete(Ligne,1,pos(',',Ligne));
  val(Tmp,XF,Erreur);
  Tmp := copy(Ligne,1,pos(',',Ligne)-1);
  delete(Ligne,1,pos(',',Ligne));
  val(Tmp,YF,Erreur);

  readln(Fichier,Ligne);
  Tmp := copy(Ligne,1,pos(',',Ligne)-1); {A}
  delete(Ligne,1,pos(',',Ligne));
  Tmp := copy(Ligne,1,pos(',',Ligne)-1); {B}
  delete(Ligne,1,pos(',',Ligne));
  Tmp := copy(Ligne,1,pos(',',Ligne)-1); {C}
  delete(Ligne,1,pos(',',Ligne));
  Tmp := copy(Ligne,1,pos(',',Ligne)-1);
  delete(Ligne,1,pos(',',Ligne));
  val(Tmp,CoulActive,Erreur);
  AjouteDroite(X,Y,Angle,XD,YD,XF,YF);
END;

{}

PROCEDURE LectureCercle;

VAR
  Ligne  : string;
  Tmp    : string;
  Erreur : integer;
  X,Y,R  : real;
  XD,YD,AD : real;
  XF,YF,AF : real;

BEGIN
  readln(Fichier,Ligne);
  Tmp := copy(Ligne,1,pos(',',Ligne)-1);
  delete(Ligne,1,pos(',',Ligne));
  Tmp := copy(Ligne,1,pos(',',Ligne)-1);
  delete(Ligne,1,pos(',',Ligne));
  val(Tmp,NbCercle,Erreur);
  NbCercle := NbCercle - 1;
  Tmp := copy(Ligne,1,pos(',',Ligne)-1);
  delete(Ligne,1,pos(',',Ligne));
  val(Tmp,X,Erreur);
  Tmp := copy(Ligne,1,pos(',',Ligne)-1);
  delete(Ligne,1,pos(',',Ligne));
  val(Tmp,Y,Erreur);
  Tmp := copy(Ligne,1,pos(',',Ligne)-1);
  delete(Ligne,1,pos(',',Ligne));
  val(Tmp,R,Erreur);

  readln(Fichier,Ligne);
  Tmp := copy(Ligne,1,pos(',',Ligne)-1);
  delete(Ligne,1,pos(',',Ligne));
  val(Tmp,XD,Erreur);
  Tmp := copy(Ligne,1,pos(',',Ligne)-1);
  delete(Ligne,1,pos(',',Ligne));
  val(Tmp,YD,Erreur);
  Tmp := copy(Ligne,1,pos(',',Ligne)-1);
  delete(Ligne,1,pos(',',Ligne));
  val(Tmp,AD,Erreur);
  Tmp := copy(Ligne,1,pos(',',Ligne)-1);
  delete(Ligne,1,pos(',',Ligne));
  val(Tmp,XF,Erreur);
  Tmp := copy(Ligne,1,pos(',',Ligne)-1);
  delete(Ligne,1,pos(',',Ligne));
  val(Tmp,YF,Erreur);
  Tmp := copy(Ligne,1,pos(',',Ligne)-1);
  delete(Ligne,1,pos(',',Ligne));
  val(Tmp,AF,Erreur);
  Tmp := copy(Ligne,1,pos(',',Ligne)-1);
  delete(Ligne,1,pos(',',Ligne));
  val(Tmp,CoulActive,Erreur);
  AjouteCercle(X,Y,R,XD,YD,AD,XF,YF,AF);
END;

{}

FUNCTION LectureFichier(NomDuFichier : nomFichier):boolean;

VAR
  Ligne  : string;
  Tmp    : string;
  Erreur : integer;
  TPoint : integer;
  TDroite: integer;
  TCercle: integer;
  N      : integer;

BEGIN
  LectureFichier := false;
  assign(Fichier,NomDuFichier);
  reset(Fichier);
  readln(Fichier,Ligne); { Nom de fichier }
  readln(Fichier,Ligne); { Nom et Version }
  Tmp := copy(Ligne,1,pos(',',Ligne)-1);
  if Tmp <> Nom then
  BEGIN
    close(Fichier);
    Ligne := 'Ceci n''est pas un fichier ' + Nom;
    Alerte(Ligne);
  END
  else
  BEGIN
    readln(Fichier,Ligne); { Nombres de Points , Droites , Cercles }
    Tmp := copy(Ligne,1,pos(',',Ligne)-1);
    delete(Ligne,1,pos(',',Ligne));
    val(Tmp,TPoint,Erreur);
    Tmp := copy(Ligne,1,pos(',',Ligne)-1);
    delete(Ligne,1,pos(',',Ligne));
    val(Tmp,TDroite,Erreur);
    val(Ligne,TCercle,Erreur);
    for N := 1 to TPoint do LecturePoint;
    if TDroite <> 0 then
       for N := 1 to TDroite do LectureDroite;
    if TCercle <> 0 then
       for N := 1 to TCercle do LectureCercle;
    close(Fichier);
    NbPoint := TPoint;
    NbDroite := TDroite;
    NbCercle := TCercle;
    CoulActive := vert;
    Modifie := false;
    NbModif := 0;
    LectureFichier := true;
  END;
END;

{}
{  Nouveau Fichier }
{}

PROCEDURE NouveauFichier;

VAR
  s : typSauvGrf;

BEGIN
  Sauvegarde(s);
  if Modifie then
  BEGIN
    ChangeCurseur(ptrFleche);
    FormeSouris := 'FLECHE';
    IF dialogueBout('Le fichier  t modifi . Enregistrer ?',' OUI ',
       ' NON ')  THEN SauverFichierSous;
    ChangeCurseur(ptrCroix);
    FormeSouris := 'CROIX';
  END;
  SuppToutPoint;
  SuppToutDroite;
  SuppToutCercle;
  InitEchelle;
  CoulActive := vert;
  CreePoint(0,0);
  Redessine;
  Modifie := false;
  NbModif := 0;
  Nom_Fichier := '';
  DeselectCase(MenuFichier,CaseSauver);
  CacheSouris;
  DessinerMenu(MenuFichier);
  Restaure(s);
END;

{}
{ Ouvrir Fichier }
{}

PROCEDURE OuvrirFichier;

VAR
  s : typSauvGrf;
  Tmp : string[8];
  NouveauNom : NomFichier;

BEGIN
  NouveauNom := '*.MAO';
  if not ChoixFichier(35,20,repPrg,NouveauNom,'Choisissez le fichier') then exit;
  SuppToutPoint;
  SuppToutDroite;
  SuppToutCercle;
  InitEchelle;
  if LectureFichier(NouveauNom) then
  BEGIN
    Sauvegarde(s);
    SelectCase(MenuFichier,CaseSauver);
    CacheSouris;
    DessinerMenu(MenuFichier);
    Restaure(s);
    EchelleAuto;
    Nom_Fichier := NouveauNom;
  END;
END;

{}
{  Sauver Fichier }
{}

PROCEDURE SauverFichier;

BEGIN
  EcritureFichier(Nom_Fichier);
END;

{}
{  Sauver Fichier Sous }
{}

PROCEDURE SauverFichierSous;

VAR
  s : typSauvGrf;
  Tmp : string[8];
  NouveauNom : NomFichier;
  Fait : boolean;

BEGIN
  Fait := false;
  repeat
    Tmp := copy(Nom_Fichier,1,pos('.',Nom_Fichier) - 1);
    repeat
      NouveauNom := DialogueTexte('Nom du fichier',Tmp,8);
      if (NouveauNom = '') and not Abandon then beep;
    until (NouveauNom <> '') or Abandon;
    if Abandon then exit;
    NouveauNom := Majuscules(NouveauNom) + '.' + Extension;
    if FicExiste(NouveauNom) then
    BEGIN
      ChangeCurseur(ptrFleche);
      FormeSouris := 'FLECHE';
      IF dialogueBout('Fichier xistant . Ecraser ?',' OUI ',' NON ')  THEN
      BEGIN
        EcritureFichier(NouveauNom);
        Nom_Fichier := NouveauNom;
        Fait := true;
      END;
      ChangeCurseur(ptrCroix);
      FormeSouris := 'CROIX';
    END
    else
    BEGIN
      EcritureFichier(NouveauNom);
      Nom_Fichier := NouveauNom;
      Fait := true;
    END;
  until Fait;
  Sauvegarde(s);
  SelectCase(MenuFichier,CaseSauver);
  CacheSouris;
  DessinerMenu(MenuFichier);
  Restaure(s);
END;

BEGIN

END.