UNIT CaoDiv;

{}
{                                                                           }
{                                CaoDiv                                     }
{                                                                           }
{                         - Routines diverses -                             }
{                                                                           }
{}

INTERFACE

USES
    crt,
    graph,
    Math,
    TurboLib,
    GrafLib,
    GrafFtr,
    CaoGlob,
    CaoBdd,
    CaoMnu,
    CaoGra,
    CaoDef;

VAR
  PosAcces : integer;

PROCEDURE DessinerMenu(Num : byte);
PROCEDURE DessineAccessoires;
FUNCTION DsAccessoires : boolean;
PROCEDURE ChangeCouleur(X : byte);
PROCEDURE Info;
PROCEDURE AfficheCoordonnees;
PROCEDURE EffaceCoordonnees;
PROCEDURE gereAccessoires;
PROCEDURE Cliquer;

{}

IMPLEMENTATION

CONST
  CoulTxtFc = grisclair;

{}
{               Dessine menus et accessoires                                }
{}

PROCEDURE DessinerMenu(Num : byte);
BEGIN
  DessineMenu(Num);
  DessineAccessoires;
END;


{}
{                   Annule la case de menu selectionne                     }
{}

PROCEDURE AnnuleCase;

VAR
  s : typSauvGrf;

BEGIN
  Sauvegarde(s);
  InverseCaseMenu(CaseActuelle);
  CasePrecedente := 0;
  CaseActuelle := 0;
  Restaure(s);
END;

{}
{                   Dessine la couleur slectionne                         }
{}

PROCEDURE DessineCouleur;

VAR
  Carre : array[1..4] of PointType;
  X1,Y1 : integer;

BEGIN
  X1 := 2 * CoulActive * grLFont;
  Y1 := ((PosAcces + 1) * 2 + 1) * grLFont;
  Carre[1].X := X1 - trunc(1.3 * grLFont);
  Carre[1].Y := Y1 - trunc(0.3 * grHFont);
  Carre[2].X := X1 + trunc(0.2 * grLFont);
  Carre[2].Y := Y1 - trunc(0.3 * grHFont);
  Carre[3].X := X1 + trunc(0.2 * grLFont);
  Carre[3].Y := Y1 + trunc(1.4 * grHFont);
  Carre[4].X := X1 - trunc(1.3 * grLFont);
  Carre[4].Y := Y1 + trunc(1.4 * grHFont);
  SetFillStyle(SolidFill,(CoulActive + 8));
  FillPoly(SizeOf(Carre) div SizeOf(PointType),Carre);
END;

{}
{                   Dessine les accessoires                                 }
{}

PROCEDURE DessineAccessoires;
VAR
  N : byte;
  s : typSauvGrf;

BEGIN
  Sauvegarde(s);
  CacheSouris;
  coulFond(ClFdMenu);
  coulTexte(ClTxTitre);
  gotoxy(1,((PosAcces + 1) * 2 + 1));
  Ecrit('Ĵ');
  gotoxy(1,((PosAcces + 1) * 2 + 2));
  for N := 1 to 6 do
  BEGIN
    coulTexte(ClTxTitre);
    Ecrit('');
    if N <> CoulActive then
    BEGIN
      coulTexte(N);
      Ecrit('');
    END
    else
    BEGIN
      CoulTexte(N + 8);
      Ecrit('');
    END;
  END;
  coulTexte(ClTxTitre);
  Ecrit('');
  coulTexte(ClTxMenu);
  Ecrit('?');
  coulTexte(ClTxTitre);
  Ecrit('');
  coulTexte(ClTxTitre);
  gotoxy(1,((PosAcces + 1) * 2 + 3));
  Ecrit('Ĵ');
  DessineCouleur;
  coulTexte(ClTxTitre);
  gotoxy(1,((PosAcces + 2) * 2 + 2));
  Ecrit('');
  coulTexte(ClTxMenu);
  Ecrit('Cadre ');
  coulTexte(ClTxTitre);
  Ecrit('');
  coulTexte(ClTxMenu);
  Ecrit('Redes.');
  coulTexte(ClTxTitre);
  Ecrit('');
  coulTexte(ClTxTitre);
  gotoxy(1,((PosAcces + 2) * 2 + 3));
  Ecrit('Ĵ');
  coulTexte(ClTxTitre);
  gotoxy(1,((PosAcces + 3) * 2 + 2));
  Ecrit('');
  coulTexte(ClTxMenu);
  Ecrit('Info  ');
  coulTexte(ClTxTitre);
  Ecrit('');
  coulTexte(ClTxMenu);
  Ecrit('Coord.');
  coulTexte(ClTxTitre);
  gotoxy(1,((PosAcces + 3) * 2 + 3));
  Ecrit('Ĵ');
  gotoxy(1,((PosAcces + 4) * 2 + 2));
  Ecrit('');
  coulTexte(ClTxMenu);
  Ecrit('Suppr.');
  coulTexte(ClTxTitre);
  Ecrit('');
  coulTexte(ClTxMenu);
  Ecrit('      ');
  coulTexte(ClTxTitre);
  gotoxy(1,((PosAcces + 4) * 2 + 3));
  Ecrit('Ĵ');
  coulTexte(ClTxTitre);
  gotoxy(1,((PosAcces + 5) * 2 + 2));
  Ecrit('');
  coulTexte(ClTxMenu);
  Ecrit('Garde ');
  coulTexte(ClTxTitre);
  Ecrit('');
  coulTexte(ClTxMenu);
  Ecrit('Ajoute');
  coulTexte(ClTxTitre);
  gotoxy(1,((PosAcces + 5) * 2 + 3));
  Ecrit('');
  Restaure(s);
END;

{}
{             Teste si la souris se trouve dans les accessoires             }
{}

FUNCTION DsAccessoires : boolean;
BEGIN
  with PosSouris do
   dsAccessoires := (X > grLFont) and (X < ((MaxCarCase+1) * grLFont))
         and (Y > round((PosAcces * 2 + 2.5)* grHFont))
         and (Y < round((MaxCases * 2 + 3.5) * grHFont));
END;

{}
{                          Change la couleur active                         }
{}

PROCEDURE ChangeCouleur(X : byte);
VAR
  N : byte;
  s     : typSauvGrf;

BEGIN
  Sauvegarde(s);
  CacheSouris;
  coulFond(ClFdMenu);
  coulTexte(ClTxTitre);
  if CoulActive = bleu then
  BEGIN
    gotoxy(1,((PosAcces + 1) * 2 + 1));
    coulTexte(ClTxTitre);
    Ecrit('');
    gotoxy(1,((PosAcces + 1) * 2 + 2));
    coulTexte(ClTxTitre);
    Ecrit('');
    coulTexte(CoulActive);
    Ecrit('');
    coulTexte(ClTxTitre);
    Ecrit('');
    gotoxy(1,((PosAcces + 1) * 2 + 3));
    Ecrit('');
  END
  else
  BEGIN
    gotoxy((2 * CoulActive - 1),((PosAcces + 1) * 2 + 1));
    coulTexte(ClTxTitre);
    Ecrit('');
    gotoxy((2 * CoulActive - 1),((PosAcces + 1) * 2 + 2));
    coulTexte(ClTxTitre);
    Ecrit('');
    coulTexte(CoulActive);
    Ecrit('');
    coulTexte(ClTxTitre);
    Ecrit('');
    gotoxy((2 * CoulActive - 1),((PosAcces + 1) * 2 + 3));
    if CoulActive <> Rouge then Ecrit('')
                           else Ecrit('');
  END;
  if (X > round(0.5 * grLFont)) and (X < round(2.5 * grLFont)) then
     CoulActive := bleu;
  if (X > round(2.5 * grLFont)) and (X < round(4.5 * grLFont)) then
     CoulActive := vert;
  if (X > round(4.5 * grLFont)) and (X < round(6.5 * grLFont)) then
     CoulActive := bleuciel;
  if (X > round(6.5 * grLFont)) and (X < round(8.5 * grLFont)) then
     CoulActive := rouge;
  if (X > round(8.5 * grLFont)) and (X < round(10.5 * grLFont)) then
     CoulActive := violet;
  if (X > round(10.5 * grLFont)) and (X < round(12.5 * grLFont)) then
     CoulActive := brun;
  DessineCouleur;
  Restaure(s);
END;

{}
{              Affiche les informations d'occupation de la mmoire          }
{}

PROCEDURE Info;
VAR
   dlg : typDlog;
   s : typSauvGrf;
   ligne : str80;
   tempLigne : str80;

BEGIN
  sauvegarde(s);
  CacheSouris;
  centreRect(dlg.DRect,40+2,20);
  WITH dlg DO
  BEGIN
    titre := '';
    DTyp := ombre2;
    clFond := coulDialogues;
    clTexte := coulTextes;
  END;
  ouvreDialogue(dlg);
  coulFond(coulDialogues);
  coulTexte(jaune);
  centreTexte(YMilTxt - 9,Nom + ' ' + Version);
  centreTexte(YMilTxt - 7,Createur_Date);

  coulTexte(coulTextes);
  Ligne := 'Points  : ';
  str(NbPoint,tempLigne);
  tempLigne := ElargiAGch(tempLigne,4);
  Ligne := Ligne + tempLigne + ' / ';
  str(MaxPoint,tempLigne);
  Ligne := Ligne + tempLigne;
  centreTexte(YMilTxt - 3,Ligne);

  Ligne := 'Droites : ';
  str(NbDroite,tempLigne);
  tempLigne := ElargiAGch(tempLigne,4);
  Ligne := Ligne + tempLigne + ' / ';
  str(MaxDroite,tempLigne);
  Ligne := Ligne + tempLigne;
  centreTexte(YMilTxt - 1,Ligne);

  Ligne := 'Cercles : ';
  str(NbCercle,tempLigne);
  tempLigne := ElargiAGch(tempLigne,4);
  Ligne := Ligne + tempLigne + ' / ';
  str(MaxCercle,tempLigne);
  Ligne := Ligne + tempLigne;
  centreTexte(YMilTxt + 1,Ligne);

  Ligne := 'Mmoire disponible : ';
  str(MemAvail,tempLigne);
  Ligne := Ligne + tempLigne + ' octets ';
  centreTexte(YMilTxt + 5,Ligne);

  coulTexte(jaune);
  centreTexte(YMilTxt + 8,'Appuyez sur une touche , ou cliquez .');
  Delay(TempoSouris);
  repeat
    ExecSouris;
  until keypressed or (BoutSouris <>0);
  if keypressed then car := readkey;
  if BoutSouris <> 0 then BoutSouris := 0;
  Delay(TempoSouris);
  fermeDialogue(dlg);
  restaure(s);
END;

{}
{              Affiche les coordonnes de la souris dans l'cran            }
{}

PROCEDURE AfficheCoordonnees;
VAR
  s     : typSauvGrf;
  ligne : str80;
  tmpX  : real;
  tmpY  : real;
  D , A : real;

BEGIN
  if not DsGraph(PosSouris.X,Possouris.Y) then exit;
  tmpX := (PosSouris.X - XOrigine) / Echelle;
  tmpY := -(PosSouris.Y - YOrigine) / Echelle;
  if (tmpX = OldCoordX) and (tmpY = OldCoordY) then exit;
  D := CalculDistDeuxPts(0,0,tmpX,tmpY);
  A := CalculAngleSegment(0,0,tmpX,tmpY);
  OldCoordX := tmpX;
  OldCoordY := tmpY;
  Sauvegarde(s);
  CacheSouris;
  coulFond(ClFdMenu);
  coulTexte(ClTxTitre);
  gotoxy(2,((PosAcces - 2) * 2 + 2));
  str(tmpX:10:3,Ligne);
  while length(Ligne) < 11 do Ligne := ' ' + Ligne;
  Ligne := 'X ' + Ligne;
  Ecrit(Ligne);
  gotoxy(2,((PosAcces - 1) * 2 + 2));
  str(tmpY:10:3,Ligne);
  while length(Ligne) < 11 do Ligne := ' ' + Ligne;
  Ligne := 'Y ' + Ligne;
  Ecrit(Ligne);
  Restaure(s);
END;

{}
{               Efface les coordonnes de la souris dans l'cran            }
{}

PROCEDURE EffaceCoordonnees;
VAR
  s     : typSauvGrf;
  ligne : str80;

BEGIN
  Sauvegarde(s);
  CacheSouris;
  coulFond(ClFdMenu);
  coulTexte(ClTxTitre);
  gotoxy(2,((PosAcces - 2) * 2 + 2));
  fillchar(Ligne,MaxCarCase + 1,' ');
  Ligne[0] := chr(MaxCarCase);
  Ecrit(Ligne);
  gotoxy(2,((PosAcces - 1) * 2 + 2));
  Ecrit(Ligne);
  Restaure(s);
END;

{}
{Attent la frappe d'une touche ou un clic souris pour les formes canoniques }
{}

PROCEDURE Attente_Fc;

BEGIN
  delay(TempoSouris);
  repeat
    execSouris;
  until keypressed or (BoutSouris <> 0);
END;

{}
{              Affichage d'une ligne de forme canonique                     }
{}

PROCEDURE AfficheFc(Ligne : byte;Titre : str80;Valeur : real);
VAR
  Texte : str80;
BEGIN
    coulTexte(CoulTxtFc);
    EcritXY(3,Ligne,Titre);
    str(Valeur:10:3,Texte);
    coulTexte(coulTextes);
    EcritXY(5,Ligne + 1,Texte);
END;

{}
{              Formes canoniques d'un point                                 }
{}

PROCEDURE FormesCanonPoint;
VAR
   dlg : typDlog;
   s : typSauvGrf;

BEGIN
  sauvegarde(s);
  CacheSouris;
  WITH dlg DO
  BEGIN
    DRect.x1 := 1;
    DRect.y1 := 1;
    DRect.x2 := 15;
    DRect.y2 := 13;
    titre := '';
    DTyp := ombre1;
    clFond := coulDialogues;
    clTexte := coulTextes;
  END;
  ouvreDialogue(dlg);
  coulFond(coulDialogues);
  coulTexte(jaune);
  EcritXY(5,3,'Point');
  coulTexte(coulTextes);
  with PointEnCours^ do
  BEGIN
    AfficheFc(6,'X :',X);
    AfficheFc(10,'Y :',Y);
  END;
  Attente_Fc;
  if keypressed then car := readkey;
  if BoutSouris <> 0 then BoutSouris := 0;
  fermeDialogue(dlg);
  restaure(s);
  delay(tempoSouris);
END;

{}
{              Formes canoniques d'une droite                               }
{}

PROCEDURE FormesCanonDroite;
VAR
   dlg : typDlog;
   s : typSauvGrf;

BEGIN
  sauvegarde(s);
  CacheSouris;
  WITH dlg DO
  BEGIN
    DRect.x1 := 1;
    DRect.y1 := 1;
    DRect.x2 := 15;
    DRect.y2 := 17;
    titre := '';
    DTyp := ombre1;
    clFond := coulDialogues;
    clTexte := coulTextes;
  END;
  ouvreDialogue(dlg);
  coulFond(coulDialogues);
  coulTexte(jaune);
  EcritXY(5,3,'Droite');
  coulTexte(coulTextes);
  with DroiteEnCours^ do
  BEGIN
    AfficheFc(6,'X :',X);
    AfficheFc(10,'Y :',Y);
    AfficheFc(14,'Angle :',RadToDeg(Angle));
  END;
  Attente_Fc;
  if keypressed then car := readkey;
  if BoutSouris <> 0 then BoutSouris := 0;
  fermeDialogue(dlg);
  restaure(s);
  delay(tempoSouris);
END;

{}
{              Formes canoniques d'un segment                               }
{}

PROCEDURE FormesCanonSegment;

VAR
   dlg : typDlog;
   s : typSauvGrf;
   ligne : str80;
   tmp : real;

BEGIN
  sauvegarde(s);
  CacheSouris;
  WITH dlg DO
  BEGIN
    DRect.x1 := 1;
    DRect.y1 := 1;
    DRect.x2 := 15;
    DRect.y2 := 35;
    titre := '';
    DTyp := ombre1;
    clFond := coulDialogues;
    clTexte := coulTextes;
  END;
  ouvreDialogue(dlg);
  coulFond(coulDialogues);
  coulTexte(jaune);
  EcritXY(4,3,'Segment');
  coulTexte(coulTextes);
  with DroiteEnCours^ do
  BEGIN
    AfficheFc(6,'X :',X);
    AfficheFc(10,'Y :',Y);
    AfficheFc(14,'Angle :',RadToDeg(Angle));
    coulTexte(jaune);
    EcritXY(2,17,'');
    AfficheFc(19,'X dbut :',XDebut);
    AfficheFc(23,'Y dbut :',YDebut);
    coulTexte(jaune);
    EcritXY(2,26,'');
    AfficheFc(28,'X fin :',XFin);
    AfficheFc(32,'Y fin :',YFin);
  END;
  Attente_Fc;
  if keypressed then car := readkey;
  if BoutSouris <> 0 then BoutSouris := 0;
  fermeDialogue(dlg);
  restaure(s);
  delay(tempoSouris);
END;

{}
{              Formes canoniques d'un cercle                                }
{}

PROCEDURE FormesCanonCercle;
VAR
   dlg : typDlog;
   s : typSauvGrf;
   ligne : str80;

BEGIN
  sauvegarde(s);
  CacheSouris;
  WITH dlg DO
  BEGIN
    DRect.x1 := 1;
    DRect.y1 := 1;
    DRect.x2 := 15;
    DRect.y2 := 17;
    titre := '';
    DTyp := ombre1;
    clFond := coulDialogues;
    clTexte := coulTextes;
  END;
  ouvreDialogue(dlg);
  coulFond(coulDialogues);
  coulTexte(jaune);
  EcritXY(5,3,'Cercle');
  coulTexte(coulTextes);
  with CercleEnCours^ do
  BEGIN
    AfficheFc(6,'X centre :',XC);
    AfficheFc(10,'Y centre :',YC);
    AfficheFc(14,'Rayon :',R);
  END;
  Attente_Fc;
  if keypressed then car := readkey;
  if BoutSouris <> 0 then BoutSouris := 0;
  fermeDialogue(dlg);
  restaure(s);
  delay(tempoSouris);
END;

{}
{              Formes canoniques d'un arc                                   }
{}

PROCEDURE FormesCanonArc;
VAR
   dlg : typDlog;
   s : typSauvGrf;
   ligne : str80;
   tmp : real;

BEGIN
  sauvegarde(s);
  CacheSouris;
  WITH dlg DO
  BEGIN
    DRect.x1 := 1;
    DRect.y1 := 1;
    DRect.x2 := 15;
    DRect.y2 := 43;
    titre := '';
    DTyp := ombre1;
    clFond := coulDialogues;
    clTexte := coulTextes;
  END;
  ouvreDialogue(dlg);
  coulFond(coulDialogues);
  coulTexte(jaune);
  EcritXY(6,3,'Arc');
  coulTexte(coulTextes);
  with CercleEnCours^ do
  BEGIN
    AfficheFc(6,'X centre :',XC);
    AfficheFc(10,'Y centre :',YC);
    AfficheFc(14,'Rayon :',R);
    coulTexte(jaune);
    EcritXY(2,17,'');
    AfficheFc(19,'X dbut :',XDebut);
    AfficheFc(23,'Y dbut :',YDebut);
    AfficheFc(27,'Angle dbut:',RadToDeg(ADebut));
    coulTexte(jaune);
    EcritXY(2,30,'');
    AfficheFc(32,'X fin :',XFin);
    AfficheFc(36,'Y fin :',YFin);
    AfficheFc(40,'Angle fin :',RadToDeg(AFin));
  END;
  Attente_Fc;
  if keypressed then car := readkey;
  if BoutSouris <> 0 then BoutSouris := 0;
  fermeDialogue(dlg);
  restaure(s);
  delay(tempoSouris);
END;

{}
{              Formes canoniques d'un lment                               }
{}

PROCEDURE FormesCanon;
VAR
  XS,YS : integer;

BEGIN
  AfficheBas(grClFond,grClTexte,'Cliquez l''lment de rfrence ');
(*  delay(TempoSouris);*)
  Detection(XS,YS);
  EffaceBas;
  Test_Abandon;
  if Abandonner then exit;
  if PremierPoint <> nil then
     if DetectPoint then
     BEGIN
       FormesCanonPoint;
       exit;
     END;
  if PremierDroite <> nil then
     BEGIN
       if DetectSegment then
       BEGIN
         FormesCanonSegment;
         exit;
       END;
       if DetectDroite then
       BEGIN
         FormesCanonDroite;
         exit;
       END;
     END;
  if PremierCercle <> nil then
     BEGIN
       if DetectArc then
       BEGIN
         FormesCanonArc;
         exit;
       END;
       if DetectCercle then
       BEGIN
         FormesCanonCercle;
         exit;
       END;
     END;
END;

{}
{              Suppression d'lments                                       }
{}

PROCEDURE Suppression;

VAR
  XS,YS : integer;
  Couleur : word;

BEGIN
  AnnuleCase;
  repeat
    AfficheBas(grClFond,grClTexte,
      'Cliquez l''lment  supprimer');
    Cliquer;
    EffaceBas;
    Test_Abandon;
    if Abandonner then exit;
    if BoutSouris = 1 then
    BEGIN
      EnregistreSouris(XS,YS);
      if DetectPoint then
        BEGIN
          if PointEnCours^.Numero <> 1 then
          BEGIN
            Couleur := CoulActive;
            CoulActive := Noir;
            with PointEnCours^ do DessinePoint(X,Y);
            SuppPoint(PointEnCours);
            CoulActive := Couleur;
          END;
        END
      else
      if DetectDroite then
        BEGIN
          Couleur := CoulActive;
          CoulActive := Noir;
          if DroiteEnCours^.Nom = 'DROITE' then
             with DroiteEnCours^ do DessineDroite(X,Y,Angle);
          if DroiteEnCours^.Nom = 'SEGMENT' then
             with DroiteEnCours^ do
                  DessineSegment(X,Y,Angle,XDebut,YDebut,XFin,YFin);
          SuppDroite(DroiteEnCours);
          CoulActive := Couleur;
        END
      else
      if DetectCercle then
        BEGIN
          Couleur := CoulActive;
          CoulActive := Noir;
          if CercleEnCours^.Nom = 'CERCLE' then
             with CercleEnCours^ do DessineCercle(XC,YC,R);
          if CercleEnCours^.Nom = 'ARC' then
             with CercleEnCours^ do DessineArc(XC,YC,R,ADebut,AFin);
          SuppCercle(CercleEnCours);
          CoulActive := Couleur;
        END;
    END;
    if Abandonner then exit;
  until false;
END;

{}
{              Limite un lment existant                                   }
{}

FUNCTION GardeDroite : boolean;

VAR
  XS,YS : integer;
  X,Y : real;
  Adr,Bdr,Cdr : real;
  A2,B2,C2 : real;
  Xdr,Ydr,Aodr : real;
  Numr : integer;
  XCercle,YCercle,Rayon : real;
  XDebut,YDebut : real;
  XFin,YFin : real;
  DroiteTmp : DroitePtr;
  Couleur : word;

BEGIN
  GardeDroite := false;
  Fait := false;
  Adr := DroiteEnCours^.A;
  Bdr := DroiteEnCours^.B;
  Cdr := DroiteEnCours^.C;
  Xdr := DroiteEnCours^.X;
  Ydr := DroiteEnCours^.Y;
  Aodr := DroiteEnCours^.Angle;
  Numr := DroiteEnCours^.Numero;
  DroiteTmp := DroiteEnCours;
  repeat
    AfficheBas(grClFond,grClTexte,'Cliquez la premire borne ');
    Cliquer;
    EffaceBas;
    Test_Abandon;
    if Abandonner then exit;
    if BoutSouris = 1 then
    BEGIN
      EnregistreSouris(XS,YS);
      if DetectDroite then
      BEGIN
        A2 := DroiteEnCours^.A;
        B2 := DroiteEnCours^.B;
        C2 := DroiteEnCours^.C;
        if CPtIntDrDr(Adr,Bdr,Cdr,A2,B2,C2,X,Y) then Fait := true;
      END
      else
      if DetectCercle then
      BEGIN
        XCercle := CercleEnCours^.Xc;
        YCercle := CercleEnCours^.Yc;
        Rayon := CercleEnCours^.R;
        if CPtIntDrCe(Xdr,Ydr,Aodr,XCercle,YCercle,Rayon,XS,YS,X,Y)
           then Fait := true;
      END;
    END;
  until Fait;

  XDebut := X;
  YDebut := Y;
  Fait := false;
  repeat
    AfficheBas(grClFond,grClTexte,'Cliquez la deuxime borne ');
    Cliquer;
    EffaceBas;
    Test_Abandon;
    if Abandonner then exit;
    if BoutSouris = 1 then
    BEGIN
      EnregistreSouris(XS,YS);
      if DetectDroite then
      BEGIN
        A2 := DroiteEnCours^.A;
        B2 := DroiteEnCours^.B;
        C2 := DroiteEnCours^.C;
        if CPtIntDrDr(Adr,Bdr,Cdr,A2,B2,C2,X,Y) then Fait := true;
      END
      else
      if DetectCercle then
      BEGIN
        XCercle := CercleEnCours^.Xc;
        YCercle := CercleEnCours^.Yc;
        Rayon := CercleEnCours^.R;
        if CPtIntDrCe(Xdr,Ydr,Aodr,XCercle,YCercle,Rayon,XS,YS,X,Y)
           then Fait := true;
      END;
    END;
  until Fait;
  XFin := X;
  YFin := Y;

  with DroiteTmp^ do
  BEGIN
    Couleur := CoulActive;
    CoulActive := Noir;
    if Nom = 'DROITE' then DessineDroite(X,Y,Angle);
    if Nom = 'SEGMENT' then
       DessineSegment(X,Y,Angle,XDebut,YDebut,XFin,YFin);
    CoulActive := Couleur;
  END;
  ModifDroite(XDebut,YDebut,XFin,YFin,Numr);
  with DroiteTmp^ do
  BEGIN
    if Nom = 'DROITE' then DessineDroite(X,Y,Angle);
    if Nom = 'SEGMENT' then
       DessineSegment(X,Y,Angle,XDebut,YDebut,XFin,YFin);
  END;

  GardeDroite := true;
END;

{}

FUNCTION GardeCercle : boolean;

VAR
  XS,YS : integer;
  X,Y,A : real;
  Xd,Yd,Aod : real;
  XCr,YCr,Rr : real;
  Numr : integer;
  XC2,YC2,R2 : real;
  XDebut,YDebut,ADebut : real;
  XFin,YFin,AFin : real;
  Couleur : word;
  CercleTmp : CerclePtr;

BEGIN
  GardeCercle := false;
  XCr := CercleEnCours^.Xc;
  YCr := CercleEnCours^.Yc;
  Rr := CercleEnCours^.R;
  numr := CercleEnCours^.Numero;
  CercleTmp := CercleEnCours;
  Fait := false;
  repeat
    AfficheBas(grClFond,grClTexte,'Cliquez la premire borne ');
    Cliquer;
    EffaceBas;
    Test_Abandon;
    if Abandonner then exit;
    if BoutSouris = 1 then
    BEGIN
      EnregistreSouris(XS,YS);
      if DetectDroite then
      BEGIN
        Xd := DroiteEnCours^.X;
        Yd := DroiteEnCours^.Y;
        Aod := DroiteEnCours^.Angle;
        if CPtIntDrCe(Xd,Yd,Aod,XCr,YCr,Rr,XS,YS,X,Y) then Fait := true;
      END
      else
      if DetectCercle then
      BEGIN
        XC2 := CercleEnCours^.Xc;
        YC2 := CercleEnCours^.Yc;
        R2 := CercleEnCours^.R;
        if CPtIntCeCe(XCr,YCr,Rr,XC2,YC2,R2,XS,YS,X,Y) then Fait := true;
      END;
    END;
  until Fait;
    XDebut := X;
    YDebut := Y;
    ADebut := CalculAngleSegment(Xcr,Ycr,X,Y);

  Fait := false;
  repeat
    AfficheBas(grClFond,grClTexte,'Cliquez la deuxime borne ');
    Cliquer;
    EffaceBas;
    Test_Abandon;
    if Abandonner then exit;
    if BoutSouris = 1 then
    BEGIN
      EnregistreSouris(XS,YS);
      if DetectDroite then
      BEGIN
        Xd := DroiteEnCours^.X;
        Yd := DroiteEnCours^.Y;
        Aod := DroiteEnCours^.Angle;
        if CPtIntDrCe(Xd,Yd,Aod,XCr,YCr,Rr,XS,YS,X,Y) then Fait := true;
      END
      else
      if DetectCercle then
      BEGIN
        XC2 := CercleEnCours^.Xc;
        YC2 := CercleEnCours^.Yc;
        R2 := CercleEnCours^.R;
        if CPtIntCeCe(XCr,YCr,Rr,XC2,YC2,R2,XS,YS,X,Y) then Fait := true;
      END;
    END;
  until Fait;
  XFin := X;
  YFin := Y;
  AFin := CalculAngleSegment(Xcr,Ycr,X,Y);
  if AFin = 0 then AFin := ( 2 * Pi);

  with CercleTmp^ do
  BEGIN
    Couleur := CoulActive;
    CoulActive := Noir;
    if Nom = 'CERCLE' then DessineCercle(XC,YC,R);
    if Nom = 'ARC' then
       DessineArc(XC,YC,R,ADebut,AFin);
    CoulActive := Couleur;
  END;
  ModifCercle(XDebut,YDebut,ADebut,XFin,YFin,AFin,Numr);
  with CercleTmp^ do
  BEGIN
    if Nom = 'CERCLE' then DessineCercle(XC,YC,R);
    if Nom = 'ARC' then
       DessineArc(XC,YC,R,ADebut,AFin);
  END;

  GardeCercle := true;
END;

{}

PROCEDURE Garde;

VAR
  XS,YS : integer;

BEGIN
  AnnuleCase;
  repeat
    AfficheBas(grClFond,grClTexte,
      'Cliquez l''lment  garder ');
    Cliquer;
    EffaceBas;
    Test_Abandon;
    if Abandonner then exit;
    if BoutSouris = 1 then
    BEGIN
      EnregistreSouris(XS,YS);
      if DetectDroite then
      BEGIN
        if not GardeDroite then
           if not Abandonner then CreationImpossible;
      END
      else
      if DetectCercle then
         if not GardeCercle then
            if not Abandonner then CreationImpossible;
    END;
    if Abandonner then exit;
  until false;
END;

{}
{              Un lment dja existant est recr et limit                }
{}

FUNCTION AjouteDroite : boolean;

VAR
  XS,YS : integer;
  X,Y : real;
  Adr,Bdr,Cdr : real;
  A2,B2,C2 : real;
  Xdr,Ydr,Aodr : real;
  XCercle,YCercle,Rayon : real;
  Xd,Yd,Angle,XDebut,YDebut,XFin,YFin : real;

BEGIN
  AjouteDroite := false;
  Adr := DroiteEnCours^.A;
  Bdr := DroiteEnCours^.B;
  Cdr := DroiteEnCours^.C;
  Xdr := DroiteEnCours^.X;
  Ydr := DroiteEnCours^.Y;
  Aodr := DroiteEnCours^.Angle;
  Xd := Xdr;
  Yd := Ydr;
  Angle := Aodr;
  Fait := false;
  repeat
    AfficheBas(grClFond,grClTexte,'Cliquez la premire borne ');
    Cliquer;
    EffaceBas;
    Test_Abandon;
    if Abandonner then exit;
    if BoutSouris = 1 then
    BEGIN
      EnregistreSouris(XS,YS);
      if DetectDroite then
      BEGIN
        A2 := DroiteEnCours^.A;
        B2 := DroiteEnCours^.B;
        C2 := DroiteEnCours^.C;
        if CPtIntDrDr(Adr,Bdr,Cdr,A2,B2,C2,X,Y) then Fait := true;
      END
      else
      if DetectCercle then
      BEGIN
        XCercle := CercleEnCours^.Xc;
        YCercle := CercleEnCours^.Yc;
        Rayon := CercleEnCours^.R;
        if CPtIntDrCe(Xdr,Ydr,Aodr,XCercle,YCercle,Rayon,XS,YS,X,Y)
           then Fait := true;
      END;
    END;
  until Fait;
  XDebut := X;
  YDebut := Y;

  Fait := false;
  repeat
    AfficheBas(grClFond,grClTexte,'Cliquez la deuxime borne ');
    Cliquer;
    EffaceBas;
    Test_Abandon;
    if Abandonner then exit;
    if BoutSouris = 1 then
    BEGIN
      EnregistreSouris(XS,YS);
      if DetectDroite then
      BEGIN
        A2 := DroiteEnCours^.A;
        B2 := DroiteEnCours^.B;
        C2 := DroiteEnCours^.C;
        if CPtIntDrDr(Adr,Bdr,Cdr,A2,B2,C2,X,Y) then Fait := true;
      END
      else
      if DetectCercle then
      BEGIN
        XCercle := CercleEnCours^.Xc;
        YCercle := CercleEnCours^.Yc;
        Rayon := CercleEnCours^.R;
        if CPtIntDrCe(Xdr,Ydr,Aodr,XCercle,YCercle,Rayon,XS,YS,X,Y)
           then Fait := true;
      END;
    END;
  until Fait;

  XFin := X;
  YFin := Y;

  CreeDroite(Xd,Yd,Angle,XDebut,YDebut,XFin,YFin);
  AjouteDroite := true;
END;

{}

FUNCTION AjouteCercle : boolean;

VAR
  XS,YS : integer;
  X,Y,A : real;
  Xd,Yd,Aod : real;
  XCr,YCr,Rr : real;
  XC2,YC2,R2 : real;
  Xc,Yc,R,XDebut,YDebut,ADebut,XFin,YFin,AFin : real;

BEGIN
  AjouteCercle := false;
  XCr := CercleEnCours^.Xc;
  YCr := CercleEnCours^.Yc;
  Rr := CercleEnCours^.R;
  Xc := XCr;
  Yc := YCr;
  R := Rr;
  Fait := false;
  repeat
    AfficheBas(grClFond,grClTexte,'Cliquez la premire borne ');
    Cliquer;
    EffaceBas;
    Test_Abandon;
    if Abandonner then exit;
    if BoutSouris = 1 then
    BEGIN
      EnregistreSouris(XS,YS);
      if DetectDroite then
      BEGIN
        Xd := DroiteEnCours^.X;
        Yd := DroiteEnCours^.Y;
        Aod := DroiteEnCours^.Angle;
        if CPtIntDrCe(Xd,Yd,Aod,XCr,YCr,Rr,XS,YS,X,Y) then Fait := true
           else exit;
      END
      else
      if DetectCercle then
      BEGIN
        XC2 := CercleEnCours^.Xc;
        YC2 := CercleEnCours^.Yc;
        R2 := CercleEnCours^.R;
        if CPtIntCeCe(XCr,YCr,Rr,XC2,YC2,R2,XS,YS,X,Y) then Fait := true
           else exit;
      END;
    END;
  until Fait;
  XDebut := X;
  YDebut := Y;
  ADebut := CalculAngleSegment(Xcr,Ycr,X,Y);

  Fait := false;
  repeat
    AfficheBas(grClFond,grClTexte,'Cliquez la deuxime borne ');
    Cliquer;
    EffaceBas;
    Test_Abandon;
    if Abandonner then exit;
    if BoutSouris = 1 then
    BEGIN
      EnregistreSouris(XS,YS);
      if DetectDroite then
      BEGIN
        Xd := DroiteEnCours^.X;
        Yd := DroiteEnCours^.Y;
        Aod := DroiteEnCours^.Angle;
        if CPtIntDrCe(Xd,Yd,Aod,XCr,YCr,Rr,XS,YS,X,Y) then Fait := true
           else exit;
      END
      else
      if DetectCercle then
      BEGIN
        XC2 := CercleEnCours^.Xc;
        YC2 := CercleEnCours^.Yc;
        R2 := CercleEnCours^.R;
        if CPtIntCeCe(XCr,YCr,Rr,XC2,YC2,R2,XS,YS,X,Y) then Fait := true
           else exit;
      END;
    END;
  until Fait;
  XFin := X;
  YFin := Y;
  AFin := CalculAngleSegment(Xcr,Ycr,X,Y);

  CreeCercle(Xc,Yc,R,XDebut,YDebut,ADebut,XFin,YFin,AFin);
  AjouteCercle := true;
END;

{}

PROCEDURE Ajoute;

VAR
  XS,YS : integer;

BEGIN
  AnnuleCase;
  repeat
    AfficheBas(grClFond,grClTexte,
      'Cliquez l''lment  ajouter');
    Cliquer;
    EffaceBas;
    Test_Abandon;
    if Abandonner then exit;
    if BoutSouris = 1 then
    BEGIN
      EnregistreSouris(XS,YS);
      if DetectDroite then
      BEGIN
        if not AjouteDroite then CreationImpossible;
      END
      else
      if DetectCercle then
         if not AjouteCercle then CreationImpossible;
    END;
    if Abandonner then exit;
  until false;
END;

{}
{               Gre tous les vnements dans les accessoires               }
{}

PROCEDURE gereAccessoires;
VAR
 X,Y : integer;

BEGIN
  X := PosSouris.X;
  Y := PosSouris.Y;
  if (Y > round((PosAcces * 2 + 2.5)* grHFont)) and
     (Y < round(((PosAcces + 1) * 2 + 2.5)* grHFont)) then
     BEGIN
       if X < round(12.5 * grLFont) then ChangeCouleur(X)
                                    else
                                    BEGIN
                                      unBip;
                                      FormesCanon;
                                    END;
     END;
  if (Y > (((PosAcces + 1) * 2 + 2.5)* grHFont)) and
     (Y < (((PosAcces + 2) * 2 + 2.5)* grHFont)) then
     BEGIN
       if (X > round(0.5 * grLFont)) and (X < round(7.5 * grLFont)) then
          EchelleAuto;
       if (X > round(7.5 * grLFont)) and (X < round(15.5 * grLFont)) then
          Redessine;
     END;
  if (Y > (((PosAcces + 2) * 2 + 2.5)* grHFont)) and
     (Y < (((PosAcces + 3) * 2 + 2.5)* grHFont)) then
     BEGIN
       if (X > round(0.5 * grLFont)) and (X < round(7.5 * grLFont)) then
          Info;
       if (X > round(7.5 * grLFont)) and (X < round(15.5 * grLFont)) then
       BEGIN
         unbip;
         AffCoord := not AffCoord;
         if not AffCoord then EffaceCoordonnees;
         delay(TempoSouris);
       END;
     END;
  if (Y > (((PosAcces + 3) * 2 + 2.5)* grHFont)) and
     (Y < (((PosAcces + 4) * 2 + 2.5)* grHFont)) then
     BEGIN
       if (X > round(0.5 * grLFont)) and (X < round(7.5 * grLFont)) then
       BEGIN
         UnBip;
         Suppression;
         if Abandonner then exit;
       END;
       if (X > round(7.5 * grLFont)) and (X < round(15.5 * grLFont)) then
        beep;
     END;
  if (Y > (((PosAcces + 4) * 2 + 2.5)* grHFont)) and
     (Y < (((PosAcces + 5) * 2 + 2.5)* grHFont)) then
     BEGIN
       if (X > round(0.5 * grLFont)) and (X < round(7.5 * grLFont)) then
       BEGIN
         UnBip;
         Garde;
         if Abandonner then exit;
       END;
       if (X > round(7.5 * grLFont)) and (X < round(15.5 * grLFont)) then
       BEGIN
         UnBip;
         Ajoute;
         if Abandonner then exit;
       END;
     END;
END;

{}
{ Gre tous les vnements spcifique aux accessoires                       }
{}

PROCEDURE gereSpeciales;
VAR
 X,Y : integer;

BEGIN
  X := PosSouris.X;
  Y := PosSouris.Y;
  if (Y > round((PosAcces * 2 + 2.5)* grHFont)) and
     (Y < round(((PosAcces + 1) * 2 + 2.5)* grHFont)) then
     BEGIN
       if X < round(12.5 * grLFont) then ChangeCouleur(X)
                                    else
                                    BEGIN
                                      unBip;
                                      FormesCanon;
                                    END;
     END;
  if (Y > (((PosAcces + 1) * 2 + 2.5)* grHFont)) and
     (Y < (((PosAcces + 2) * 2 + 2.5)* grHFont)) then
     BEGIN
       if (X > round(0.5 * grLFont)) and (X < round(7.5 * grLFont)) then
          EchelleAuto;
       if (X > round(7.5 * grLFont)) and (X < round(15.5 * grLFont)) then
          Redessine;
     END;
  if (Y > (((PosAcces + 2) * 2 + 2.5)* grHFont)) and
     (Y < (((PosAcces + 3) * 2 + 2.5)* grHFont)) then
     BEGIN
       if (X > round(0.5 * grLFont)) and (X < round(7.5 * grLFont)) then
          Info;
       if (X > round(7.5 * grLFont)) and (X < round(15.5 * grLFont)) then
       BEGIN
         unbip;
         AffCoord := not AffCoord;
         if not AffCoord then EffaceCoordonnees;
         delay(TempoSouris);
       END;
     END;
  if (Y > (((PosAcces + 3) * 2 + 2.5)* grHFont)) and
     (Y < (((PosAcces + 4) * 2 + 2.5)* grHFont)) then
     BEGIN
       if (X > round(0.5 * grLFont)) and (X < round(7.5 * grLFont)) then
       BEGIN
         Abandonner := true;
       END;
       if (X > round(7.5 * grLFont)) and (X < round(15.5 * grLFont)) then
        beep;
     END;
  if (Y > (((PosAcces + 4) * 2 + 2.5)* grHFont)) and
     (Y < (((PosAcces + 5) * 2 + 2.5)* grHFont)) then
     BEGIN
       if (X > round(0.5 * grLFont)) and (X < round(7.5 * grLFont)) then
       BEGIN
         Abandonner := true;
       END;
       if (X > round(7.5 * grLFont)) and (X < round(15.5 * grLFont)) then
       BEGIN
         Abandonner := true;
       END;
     END;
END;

{}
{Liste des diffrentes actions lors des attentes specifiques aux accessoires}
{}

PROCEDURE FctSpeciales;

BEGIN
  if (boutSouris = 1) and DsAccessoires then
  BEGIN
    gereSpeciales;
    if Abandonner then exit;
    BoutSouris := 0;
  END;
  if (boutSouris = 2) and DsGraph(PosSouris.X,PosSouris.Y) then
  BEGIN
    GereZoom;
    BoutSouris := 0;
  END;
  if AffCoord then
  BEGIN
    AfficheCoordonnees;
    BoutSouris := 0;
  END;
  if (FormeSouris <> 'CROIX') and (PosSouris.X > XMinEcran) then
  BEGIN
    ChangeCurseur(ptrCroix);
    FormeSouris := 'CROIX';
  END;
  if (FormeSouris <> 'MAIN') and (PosSouris.X < XMinEcran) then
  BEGIN
    ChangeCurseur(ptrMain);
    FormeSouris := 'MAIN';
  END;
END;

{}
{   Attente d'un vnement utilisateur souris  spcifique aux accessoires   }
{}

PROCEDURE Cliquer;

BEGIN
  Delay(TempoSouris);
  repeat
    execSouris;
    FctSpeciales;
    if Abandonner then exit;
    while keypressed do
    BEGIN
      car := readkey;
      if car = CarEsc then
      BEGIN
        Abandonner := true;
        exit;
      END;
    END;
  until (BoutSouris <> 0);
END;



BEGIN
  PosAcces := MaxCases - 5;
END.