UNIT CaoDef;

{}
{                                                                           }
{                                CaoDef                                     }
{                                                                           }
{                 - Routines de calcul des definitions -                    }
{                                                                           }
{}

INTERFACE

USES
    CaoGlob,
    Graflib,
    Math;

PROCEDURE ConvSourisPoint(XSouris,YSouris : integer;
                          VAR XPoint,YPoint : real);
PROCEDURE ConvPointSouris(XPoint,YPoint : real;
                          VAR XS,YS : integer);
FUNCTION MiseEnFormeAngleDr(Angle : real):real;
FUNCTION CalculAngleSegment(Xr,Yr,Xp,Yp : real): real;
PROCEDURE CalculEqDroite(Xp,Yp,Angle : real;VAR A,B,C : real);
PROCEDURE CalculPtInterDrt(Xp,Yp,Xpd,Ypd,Aod : real;VAR X,Y : real);
PROCEDURE PtLePlusProche(Xref,Yref : integer;X1,Y1,X2,Y2 : real;
                       VAR X,Y : real);
FUNCTION ALePlusProche(Aref,A1,A2 : real):real;
FUNCTION CalculDistDeuxPts(X1,Y1,X2,Y2 : real):real;

{########################}

PROCEDURE CPtTourne(Xc,Yc,Xp,Yp,Angle : real;VAR X,Y : real);
PROCEDURE CPtMilSeg(Xd,Yd,Xf,Yf : real;VAR X,Y : real);
PROCEDURE CPtMilArc(Xc,Yc,R,Ad,Af : real;VAR X,Y : real);
PROCEDURE CPtSymPt(Xp,Yp,Xps,Yps : real;VAR X,Y : real);
PROCEDURE CPtSymDr(Xp,Yp,Xpd,Ypd,Aod : real;VAR X,Y : real);
FUNCTION CPtIntDrDr(A1,B1,C1,A2,B2,C2 : real;VAR X,Y : real) : boolean;
FUNCTION CPtIntDrCe(Xpd,Ypd,Aod,Xc,Yc,Rc : real;XS,YS : integer;
                   VAR X,Y: real) : boolean;
FUNCTION CPtIntCeCe(Xc1,Yc1,Rc1,Xc2,Yc2,Rc2 : real;XS,YS : integer;
                   VAR X,Y : real) : boolean;

{########################}

PROCEDURE CDrDeuxPts(Xp1,Yp1,Xp2,Yp2 : real; VAR X,Y,A : real);
PROCEDURE CDrPtsPerpDr(Xp,Yp,Aod : real; VAR X,Y,A : real);
PROCEDURE CDrCePerpDr(Xc,Yc,Rc,Aod : real; VAR X1,Y1,X2,Y2,A : real);
PROCEDURE CDrCeAngle(Xc,Yc,Rc,Angle : real;XS,YS : integer;
                     VAR X,Y,A : real);
PROCEDURE CDrParalDist(Xpd,Ypd,Aod,Etmp : real;XS,YS : integer;
                     VAR X,Y,A : real);

FUNCTION CDrSymDr(A1,B1,C1,Angle1,A2,B2,C2,Angle2 : real;
                   VAR X,Y,Angle : real) : boolean;
PROCEDURE CDrSymPt(Xpd,Ypd,Aod,Xps,Yps : real;VAR X,Y,Angle : real);
PROCEDURE CDrTourne(Xc,Yc,Xpd,Ypd,Aod,Alpha : real;VAR X,Y,Angle : real);
FUNCTION CMediatrice(A1,B1,C1,Aod1,A2,B2,C2,Aod2 : real;
                   VAR X,Y,Angle : real) : boolean;
FUNCTION CBissectrice(A1,B1,C1,Aod1,A2,B2,C2,Aod2 : real;
                   VAR X,Y,Angle : real) : boolean;
FUNCTION CDrPtCe(Xp,Yp,Xc,Yc,Rc : real;VAR X,Y,A1,A2 : real):boolean;
FUNCTION CDrCeCe(Xc1,Yc1,Rc1,Xc2,Yc2,Rc2 : real;XS1,YS1,XS2,YS2 : integer;
              VAR X,Y,A,XD,YD,XF,YF : real): boolean;

{########################}

FUNCTION CCePcPts(Xpc,Ypc,Xp,Yp : real;VAR X,Y,R : real):boolean;
FUNCTION CCePcDr(Xpc,Ypc,Xpd,Ypd,Aod,A,B,C : real;VAR X,Y,R : real):boolean;
FUNCTION CCePcCe(Xpc,Ypc,Xc,Yc,Rc : real;XS,YS : integer;
                  VAR X,Y,R : real):boolean;
FUNCTION CCePtsDr(Xp,Yp,Xpd,Ypd,Aod,A,B,C,Rayon:real;XS1,YS1,XS2,YS2:integer;
                  VAR X,Y,R:real) : boolean;
FUNCTION CCePtsCe(Xp,Yp,Xc,Yc,Rc,Rayon:real;XS1,YS1,XS2,YS2:integer;
                  VAR X,Y,R:real) : boolean;
FUNCTION CCe2Pts(Xp1,Yp1,Xp2,Yp2,Rayon:real;XS,YS:integer;
                  VAR X,Y,R:real) : boolean;
FUNCTION CCe2Dr(Xd1,Yd1,Aod1,Xd2,Yd2,Aod2,Rayon:real;XS1,YS1,XS2,YS2:integer;
                  VAR X,Y,R:real):boolean;
FUNCTION CCeDrCe(Xd,Yd,Aod,Xc,Yc,Rc,Rayon:real;XS1,YS1,XS2,YS2:integer;
                 VAR X,Y,R:real):boolean;
FUNCTION CCe2Ce(Xc1,Yc1,Rc1,Xc2,Yc2,Rc2,Rayon:real;XS1,YS1,XS2,YS2:integer;
                  VAR X,Y,R:real):boolean;

{########################}

FUNCTION CCe3Pts(Xp1,Yp1,Xp2,Yp2,Xp3,Yp3:real;
                 VAR X,Y,R:real):boolean;
{}

IMPLEMENTATION

{}
{  Converti une position Souris dans l'cran en coordonne d'un point       }
{}

PROCEDURE ConvSourisPoint(XSouris,YSouris : integer;
                          VAR XPoint,YPoint : real);

BEGIN
  XPoint := (XSouris - XOrigine) / Echelle;
  YPoint := -(YSouris - YOrigine) / Echelle;
END;

{}
{  Converti coordonne point en position souris                             }
{}

PROCEDURE ConvPointSouris(XPoint,YPoint : real;
                          VAR XS,YS : integer);

BEGIN
  XS := round(XPoint * Echelle) + XOrigine;
  YS := YOrigine - round(YPoint * Echelle);
END;


{}
{  Met en forme l'angle pour une droite                                     }
{}

FUNCTION MiseEnFormeAngleDr(Angle : real):real;

BEGIN
  if Angle < 0 then Angle := Angle + (2 * Pi);
  if Angle > (2 * Pi) then Angle := Angle - (2 * Pi);
  if Angle > Pi then Angle := Angle - Pi;
  MiseEnFormeAngleDr := Angle;
END;

{}
{  Calcul de l'angle d'un segment par rapport  l'horizontale               }
{}

FUNCTION CalculAngleSegment(Xr,Yr,Xp,Yp : real): real;
VAR
  Tmp : real;
  Angle : real;

BEGIN
  if Xp > Xr then
  BEGIN
    Tmp := (Yp - Yr) / (Xp - Xr);
    Angle := ArcTan(Tmp);
  END;
  if Xp < Xr then
  BEGIN
    Tmp := (Yp - Yr) / (Xp - Xr);
    Angle := ArcTan(Tmp) + Pi;
  END;
  if Xp = Xr then
  BEGIN
    if Yp > Yr then Angle := Pi / 2;
    if Yp < Yr then Angle := 3 * Pi / 2;
  END;
  if Angle < 0 then Angle := Angle + (2 * Pi);
  if Angle > (2 * Pi) then Angle := Angle - (2 * Pi);
  CalculAngleSegment := Angle;
END;

{}
{  Calcul des coefficients de l'quation d'une droite                       }
{}

PROCEDURE CalculEqDroite(Xp,Yp,Angle : real;VAR A,B,C : real);

BEGIN
  A := MSin(Angle);
  B := - MCos(Angle);
  C := (Yp * MCos(Angle)) - (Xp * MSin(Angle));
END;

{}
{  Calcul point d'intersection d'une droite avec sa perpendiculaire passant }
{  par un point                                                             }
{}

PROCEDURE CalculPtInterDrt(Xp,Yp,Xpd,Ypd,Aod : real;VAR X,Y : real);
VAR
  Tmp : real;

BEGIN
  if Aod = 0 then
  BEGIN
    X := Xp;
    Y := Ypd;
  END;
  if Aod = (Pi / 2) then
  BEGIN
    X := Xpd;
    Y := Yp;
  END;
  if (Aod <> 0) and (Aod <> (Pi / 2)) then
  BEGIN
    X := Xpd * MSin(Aod) * MSin(Aod);
    Tmp := Xp * MCos(Aod) * MCos(Aod);
    X := X + Tmp;
    Tmp := (Yp - Ypd) * MCos(Aod) * MSin(Aod);
    X := X + Tmp;
    Y := Yp * MSin(Aod) * MSin(Aod);
    Tmp := Ypd * MCos(Aod) * MCos(Aod);
    Y := Y + Tmp;
    Tmp := (Xp - Xpd) * MCos(Aod) * MSin(Aod);
    Y := Y + Tmp;
  END;
END;

{}
{  Calcul point le plus proche du point cliqu                              }
{}

PROCEDURE PtLePlusProche(Xref,Yref : integer;X1,Y1,X2,Y2 : real;
                       VAR X,Y : real);
VAR
  XPoint,YPoint : real;
  Ecart1,Ecart2 : real;

BEGIN
  ConvSourisPoint(Xref,Yref,XPoint,YPoint);
  Ecart1 := ((X1 - XPoint) * (X1 - XPoint)) + ((Y1 - YPoint) * (Y1 - YPoint));
  Ecart2 := ((X2 - XPoint) * (X2 - XPoint)) + ((Y2 - YPoint) * (Y2 - YPoint));
  if Ecart1 < Ecart2 then
  BEGIN
    X := X1;
    Y := Y1;
  END
  else
  BEGIN
    X := X2;
    Y := Y2;
  END;
END;

{}
{  Calcul l'angle le plus proche                                            }
{}

FUNCTION ALePlusProche(Aref,A1,A2 : real): real;
VAR
  Ecart1,Ecart2 : real;

BEGIN
  Ecart1 := abs(Aref - A1);
  Ecart2 := abs(Aref - A2);
  if Ecart1 < Ecart2 then ALePlusProche := A1
                     else ALePlusProche := A2;
END;

{}
{  Calcul la distance entre deux points                                     }
{}

FUNCTION CalculDistDeuxPts(X1,Y1,X2,Y2 : real):real;
VAR
  Xa,Xb,Ya,Yb : real;
  tmp : real;

BEGIN
  if X1 > X2 then
  BEGIN
    Xa := X1;
    Xb := X2;
  END
  else
  BEGIN
    Xa := X2;
    Xb := X1;
  END;
  if Y1 > Y2 then
  BEGIN
    Ya := Y1;
    Yb := Y2;
  END
  else
  BEGIN
    Ya := Y2;
    Yb := Y1;
  END;
  tmp := sqr((Xa - Xb)) + sqr((Ya - Yb));
  tmp := sqrt(tmp);
  tmp := round(tmp * 10000);
  tmp := tmp / 10000;
  CalculDistDeuxPts := tmp;
END;


{---------------------------------------------------------------------------}
{---------------------------------------------------------------------------}

{}
{                 Calcul le point tourn autour d'un autre                  }
{  On fournit les coordonnes du point de centre de la rotation , du point  }
{   tourner et l'angle de rotation par rapport  l'horizontale             }
{}

PROCEDURE CPtTourne(Xc,Yc,Xp,Yp,Angle : real;VAR X,Y : real);
VAR
  R,Tmp,B : real;
  EcartX : real;
  EcartY : real;

BEGIN
  if Xp = Xc then
  BEGIN
    R := Yp - Yc;
    X := Xc - R * MSin(Angle);
    Y := Yc + R * MCos(Angle);
  END
  else
  BEGIN
    EcartX := Xp - Xc;
    R := EcartX * EcartX;
    EcartY := Yp - Yc;
    Tmp := EcartY * EcartY;
    Tmp := R + Tmp;
    R := sqrt(Tmp);
    Tmp := EcartX / R;
    B := ArcCos(Tmp);
    if EcartX >= 0 then
       BEGIN
         if EcartY >= 0 then B := B
                        else B := 2 * Pi - B;
       END
       else
       BEGIN
         if EcartY >= 0 then B := Pi + B
                        else B := Pi - B;
       END;
    X := Xc + R * MCos((Angle + B));
    Y := Yc + R * MSin((Angle + B));
  END;
END;

{}
{                 Calcul le point milieu d'un segment                       }
{  On fournit les coordonnes des 2 extrmit du segment                    }
{}

PROCEDURE CPtMilSeg(Xd,Yd,Xf,Yf : real;VAR X,Y : real);
BEGIN
  X := 0.5 * (Xd + Xf);
  Y := 0.5 * (Yd + Yf);
END;

{}
{                 Calcul le point milieu d'un arc                           }
{  On fournit le point de centre , le rayon et les angles des 2 extrmites }
{  de l'arc                                                                 }
{}

PROCEDURE CPtMilArc(Xc,Yc,R,Ad,Af : real;VAR X,Y : real);
VAR
  Angle : real;

BEGIN
  Angle := 0.5 * (Ad + Af);
  X := Xc + R * MCos(Angle);
  Y := Yc + R * MSin(Angle);
END;

{}
{                 Calcul le point symtrique par rapport  un autre         }
{  On fournit le point  symtriser et le point de symtrie                 }
{}

PROCEDURE CPtSymPt(Xp,Yp,Xps,Yps : real;VAR X,Y : real);
BEGIN
  X := 2 * Xps - Xp;
  Y := 2 * Yps - Yp;
END;

{}
{                 Calcul le point symtrique par rapport  une droite       }
{  On fournit le point  symtriser et le point de rfrence , l'angle      }
{  de la droite                                                             }
{}

PROCEDURE CPtSymDr(Xp,Yp,Xpd,Ypd,Aod : real;VAR X,Y : real);
VAR
  X2 , Y2 : real;
BEGIN
  CalculPtInterDrt(Xp,Yp,Xpd,Ypd,Aod,X2,Y2);
  X := 2 * X2 - Xp;
  Y := 2 * Y2 - Yp;
END;

{}
{                 Calcul le point d'intersection entre 2 droites            }
{}
FUNCTION CPtIntDrDr(A1,B1,C1,A2,B2,C2 : real;VAR X,Y : real) : boolean;
VAR
  tmp : real;

BEGIN
  CPtIntDrDr := false;
  if (A1 = A2) and (B1 = B2) and (C1 = C2) then exit;
  tmp := (A1 * B2) - (A2 * B1);
  if tmp <> 0 then
  BEGIN
    tmp := (A1 * B2) - (A2 * B1);
    X := ((C2 * B1) - (C1 * B2)) / tmp ;
    Y := ((A2 * C1) - (A1 * C2)) / tmp ;
    CPtIntDrDr := true;
  END;
END;

{}
{                 Calcul le point d'intersection entre 1 droite et 1 cercle }
{}
FUNCTION CPtIntDrCe(Xpd,Ypd,Aod,Xc,Yc,Rc : real;XS,YS : integer;
                   VAR X,Y: real) : boolean;
VAR
  Xtmp,Ytmp : real;
  Atmp :real;
  Aref : real;
  tmp : real;
  X1,Y1,X2,Y2 : real;

  PROCEDURE Angle_0;

  BEGIN
    if Ypd > (Yc + Rc) then exit;
    if Ypd < (Yc - Rc) then exit;
    tmp := ArcSin((Ypd - Yc) / Rc);
    X1 := Xc + Rc * MCos(tmp);
    X2 := Xc - Rc * MCos(tmp);
    Y1 := Ypd;
    Y2 := Ypd;
    CPtIntDrCe := true;
  END;

  PROCEDURE Angle_90;

  BEGIN
    if Xpd > (Xc + Rc) then exit;
    if Xpd < (Xc - Rc) then exit;
    tmp := Xpd - Xc;
    tmp := sqr(tmp);
    tmp := sqr(Rc) - tmp;
    tmp := sqrt(tmp);
    X1 := Xpd;
    X2 := Xpd;
    Y1 := Yc + tmp;
    Y2 := Yc - tmp;
    CPtIntDrCe := true;
  END;

  PROCEDURE Autre_Angle;

  BEGIN
    CalculPtInterDrt(Xc,Yc,Xpd,Ypd,Aod,Xtmp,Ytmp);
    tmp := CalculDistDeuxPts(Xc,Yc,Xtmp,Ytmp);
    if tmp > Rc then exit;
    tmp := ArcCos((tmp / Rc));
    Aref := CalculAngleSegment(Xpd,Ypd,Xc,Yc);

    if Aref > Pi then
    BEGIN
      if Aref > Pi then Aref := Aref - Pi;
      if Aref < Aod then Atmp := Aod + (3 * Pi / 2) - tmp
                    else Atmp := Aod + (Pi / 2) - tmp;
      X1 := Xc + Rc * MCos(Atmp);
      Y1 := Yc + Rc * MSin(Atmp);
      if Aref < Aod then Atmp := Aod + (3 * Pi / 2) + tmp
                    else Atmp := Aod + (Pi / 2) + tmp;
      X2 := Xc + Rc * MCos(Atmp);
      Y2 := Yc + Rc * MSin(Atmp);
    END
    else
    BEGIN
      if Aref < Aod then Atmp := Aod + (Pi / 2) - tmp
                    else Atmp := Aod + (3 * Pi / 2) - tmp;
      X1 := Xc + Rc * MCos(Atmp);
      Y1 := Yc + Rc * MSin(Atmp);
      if Aref < Aod then Atmp := Aod + (Pi / 2) + tmp
                    else Atmp := Aod + (3 * Pi / 2) + tmp;
      X2 := Xc + Rc * MCos(Atmp);
      Y2 := Yc + Rc * MSin(Atmp);
    END;
    CPtIntDrCe := true;
  END;

BEGIN
  CPtIntDrCe := false;

  if Aod = 0 then Angle_0
  else if Aod = PiSur2 then Angle_90
       else if Aod = Pi then Angle_0
            else if Aod = (3*PiSur2) then Angle_90
                 else Autre_Angle;

  PtLePlusProche(XS,YS,X1,Y1,X2,Y2,X,Y);
END;

{}
{                 Calcul le point d'intersection entre 2 cercles            }
{}
FUNCTION CPtIntCeCe(Xc1,Yc1,Rc1,Xc2,Yc2,Rc2 : real;XS,YS : integer;
                   VAR X,Y : real) : boolean;
VAR
  D , tmp : real;
  Angle1 , Angle2 : real;
  Atmp : real;
  Xr1,Yr1,Rr1 : real;
  Xr2,Yr2,Rr2 : real;
  X1,Y1,X2,Y2 : real;

BEGIN
  CPtIntCeCe := false;
  if (Xc1 = Xc2) and (Yc1 = Yc2) and (Rc1 = Rc2) then exit;
  if Rc1 > Rc2 then
  BEGIN
    Xr1 := Xc1;
    Yr1 := Yc1;
    Rr1 := Rc1;
    Xr2 := Xc2;
    Yr2 := Yc2;
    Rr2 := Rc2;
  END
  else
  BEGIN
    Xr1 := Xc2;
    Yr1 := Yc2;
    Rr1 := Rc2;
    Xr2 := Xc1;
    Yr2 := Yc1;
    Rr2 := Rc1;
  END;
  Angle1 := CalculAngleSegment(Xr1,Yr1,Xr2,Yr2);
  D := CalculDistDeuxPts(Xr1,Yr1,Xr2,Yr2);
  tmp := sqr(D) + sqr(Rr1) - sqr(Rr2);
  tmp := tmp / (2 * D * Rr1);
  Angle2 := ArcCos(tmp);
  Atmp := Angle1 + Angle2;
  X1 := Xr1 + Rr1 * MCos(Atmp);
  Y1 := Yr1 + Rr1 * MSin(Atmp);
  Atmp := Angle1 - Angle2;
  X2 := Xr1 + Rr1 * MCos(Atmp);
  Y2 := Yr1 + Rr1 * MSin(Atmp);
  if (X1 = X2) and (Y1 = Y2) then
  BEGIN
    X := X1;
    Y := Y1;
  END
  else PtLePlusProche(XS,YS,X1,Y1,X2,Y2,X,Y);
  CPtIntCeCe := true;
END;

{---------------------------------------------------------------------------}
{---------------------------------------------------------------------------}

{}
{                 Calcul le droite passant par 2 points                     }
{}

PROCEDURE CDrDeuxPts(Xp1,Yp1,Xp2,Yp2 : real; VAR X,Y,A : real);

VAR
  D : real;

BEGIN
  D := CalculDistDeuxPts(Xp1,Yp1,Xp2,Yp2);
  X := Xp1;
  Y := Yp1;
  A := ArcCos((Xp2 -Xp1) / D);
  if Yp2 < Yp1 then A := (2 * Pi) - A;
  A := MiseEnFormeAngleDr(A);
END;

{}
{ Calcul la droite passant par 1 points et perpendiculaire  une droite     }
{}

PROCEDURE CDrPtsPerpDr(Xp,Yp,Aod : real; VAR X,Y,A : real);
BEGIN
  X := Xp;
  Y := Yp;
  A := Aod + PiSur2;
  A := MiseEnFormeAngleDr(A);
END;

{}
{ Calcul la droite tangente  1 cercle  et perpendiculaire  une droite     }
{}

PROCEDURE CDrCePerpDr(Xc,Yc,Rc,Aod : real; VAR X1,Y1,X2,Y2,A : real);
BEGIN
  X1 := Xc - Rc * MCos(Aod);
  Y1 := Yc - Rc * MSin(Aod);
  X2 := Xc + Rc * MCos(Aod);
  Y2 := Yc + Rc * MSin(Aod);
  A := Aod + PiSur2;
  A := MiseEnFormeAngleDr(A);
END;

{}
{ Calcul la droite tangente  1 cercle  avec un angle                       }
{}

PROCEDURE CDrCeAngle(Xc,Yc,Rc,Angle : real;XS,YS : integer;
                     VAR X,Y,A : real);
VAR
  X1,Y1,X2,Y2 : real;

BEGIN
  A := MiseEnFormeAngleDr(Angle);
  Angle := A + PiSur2;
  X1 := Xc - Rc * MCos(Angle);
  Y1 := Yc - Rc * MSin(Angle);
  X2 := Xc + Rc * MCos(Angle);
  Y2 := Yc + Rc * MSin(Angle);
  PtLePlusProche(XS,YS,X1,Y1,X2,Y2,X,Y);
END;

{}
{ Calcul la droite parallle  une autre avec distance                      }
{}

PROCEDURE CDrParalDist(Xpd,Ypd,Aod,Etmp : real;XS,YS : integer;
                     VAR X,Y,A : real);

VAR
  Atmp : real;
  XPoint,YPoint : real;

BEGIN
  ConvSourisPoint(XS,YS,XPoint,YPoint);
  Atmp := CalculAngleSegment(Xpd,Ypd,XPoint,YPoint);
  if Atmp > Pi then
  BEGIN
    Atmp := Atmp - Pi;
    if Atmp > Aod then Etmp := -Etmp;
  END
  else
    if Atmp < Aod then Etmp := -Etmp;
  Atmp := Aod;
  if Atmp >= Pi then Atmp := Atmp - Pi;
  X := Xpd - Etmp * MSin(Atmp);
  Y := Ypd + Etmp * MCos(Atmp);
  A := Aod;
END;

{}
{ Calcul la droite symtrique par rapport  une autre                       }
{         (2 = droite de symtrie)                                          }
{}

FUNCTION CDrSymDr(A1,B1,C1,Angle1,A2,B2,C2,Angle2 : real;
                   VAR X,Y,Angle : real) : boolean;
VAR
  Tmp : real;

BEGIN
  CDrSymDr := false;
  Tmp := (A1 * B2) - (A2 * B1);
  if Tmp = 0 then exit;
  X := (C2 * B1) - (C1 * B2);
  X := X / Tmp;
  Y := (A2 * C1) - (A1 * C2);
  Y := Y / Tmp;
  Angle := 2 * Angle2 - Angle1;
  Angle := MiseEnFormeAngleDr(Angle);
  CDrSymDr := true;
END;

{}
{ Calcul la droite symtrique par rapport  un point                        }
{}

PROCEDURE CDrSymPt(Xpd,Ypd,Aod,Xps,Yps : real;VAR X,Y,Angle : real);

VAR
  X2 , Y2 : real;

BEGIN
  CalculPtInterDrt(Xps,Yps,Xpd,Ypd,Aod,X2,Y2);
  X := 2 * Xps - X2;
  Y := 2 * Yps - Y2;
  Angle := Aod;
END;

{}
{ Calcul la droite tourne autour d'un point                                }
{}

PROCEDURE CDrTourne(Xc,Yc,Xpd,Ypd,Aod,Alpha : real;VAR X,Y,Angle : real);
VAR
  X2 , Y2 : real;
  R , Beta : real;
  Tmp : real;

BEGIN
  if (Xc = Xpd) and (Yc = Ypd) then
  BEGIN
    X := Xc;
    Y := Yc;
  END
  else
  BEGIN
    CalculPtInterDrt(Xc,Yc,Xpd,Ypd,Aod,X2,Y2);
    Tmp := sqr((X2 - Xc)) + sqr((Y2 - Yc));
    R := sqrt(Tmp);
    Tmp := (X2 - Xc) / R;
    Beta := ArcCos(Tmp);
    if Y2 < Yc then Beta := 2 * Pi - Beta;
    X := Xc + R * MCos((Alpha + Beta));
    Y := Yc + R * MSin((Alpha + Beta));
  END;
  Angle := Aod + Alpha;
  Angle := MiseEnFormeAngleDr(Angle);
END;

{}
{ Calcul la mdiatrice                                                      }
{}

FUNCTION CMediatrice(A1,B1,C1,Aod1,A2,B2,C2,Aod2 : real;
                   VAR X,Y,Angle : real) : boolean;
VAR
  Tmp : real;

BEGIN
  CMediatrice := false;
  Tmp := (A1 * B2) - (A2 * B1);
  if Tmp = 0 then exit;
  X := (C2 * B1) - (C1 * B2);
  X := X / Tmp;
  Y := (A2 * C1) - (A1 * C2);
  Y := Y / Tmp;
  if Aod2 > Aod1 then Angle := 0.5 * (Aod1 + Aod2)
                 else Angle := 0.5 * (Aod1 + Aod2) + PiSur2;
  Angle := MiseEnFormeAngleDr(Angle);
  CMediatrice := true;
END;

{}
{ Calcul la bissectrice                                                     }
{}

FUNCTION CBissectrice(A1,B1,C1,Aod1,A2,B2,C2,Aod2 : real;
                   VAR X,Y,Angle : real) : boolean;
VAR
  Tmp : real;

BEGIN
  CBissectrice := false;
  Tmp := (A1 * B2) - (A2 * B1);
  if Tmp = 0 then exit;
  X := (C2 * B1) - (C1 * B2);
  X := X / Tmp;
  Y := (A2 * C1) - (A1 * C2);
  Y := Y / Tmp;
  Angle := 2 * Aod1 - Aod2;
  Angle := MiseEnFormeAngleDr(Angle);
  CBissectrice := true;
END;

{}
{ Calcul la droite passant par un point et tangente a un cercle             }
{}

FUNCTION CDrPtCe(Xp,Yp,Xc,Yc,Rc : real;VAR X,Y,A1,A2 : real): boolean;

VAR
  Tmp : real;
  Beta : real;

BEGIN
  CDrPtCe := false;
  if (Xp = Xc) and (Yp = Yc) then exit;
  Tmp := CalculDistDeuxPts(Xc,Yc,Xp,Yp);
  if Tmp <= Rc then exit;
  Beta := CalculAngleSegment(Xp,Yp,Xc,Yc);
  X := Xp;
  Y := Yp;
  Tmp := Rc / Tmp;
  Tmp := ArcSin(Tmp);
  A1 := Beta + Tmp;
  A2 := Beta - Tmp;
  A1 := MiseEnFormeAngleDr(A1);
  A2 := MiseEnFormeAngleDr(A2);
  CDrPtCe := true;
END;

{}
{ Calcul la droite tangente  deux cercles                                  }
{}

FUNCTION CDrCeCe(Xc1,Yc1,Rc1,Xc2,Yc2,Rc2 : real;XS1,YS1,XS2,YS2 : integer;
              VAR X,Y,A,XD,YD,XF,YF : real): boolean;

VAR
  AngleRef : real;
  Dist  : real;
  AngleTmp,Tmp : real;
  Xr1,Xr2 : real;
  Yr1,Yr2 : real;
  R1,R2 : real;
  XP1,XP2,YP1,YP2 : real;

  Angle,XDebut,YDebut,XFin,YFin : array [1..4] of real;
  Ecart,EcartTmp : real;
  Selectionne : integer;

  ch : string;

  PROCEDURE R1SupR2;

  BEGIN
    Tmp := (R1 - R2) / Dist;
    if (Tmp >= -1)  and (Tmp <= 1) then
    BEGIN
      AngleTmp:= ArcSin(Tmp);
      Angle[1] := (AngleRef - AngleTmp);
      XDebut[1] := Xr1 - R1 * MSin(Angle[1]);
      YDebut[1] := Yr1 + R1 * MCos(Angle[1]);
      XFin[1] := Xr2 - R2 * MSin(Angle[1]);
      YFin[1] := Yr2 + R2 * MCos(Angle[1]);
      Angle[1] := MiseEnFormeAngleDr(Angle[1]);
      EcartTmp := CalculDistDeuxPts(XP1,YP1,XDebut[1],YDebut[1]) +
                  CalculDistDeuxPts(XP2,YP2,XFin[1],YFin[1]);
      if EcartTmp < Ecart then
      BEGIN
        Ecart := EcartTmp;
        Selectionne := 1;
      END;

      Angle[3] := (AngleRef + AngleTmp);
      XDebut[3] := Xr1 + R1 * MSin(Angle[3]);
      YDebut[3] := Yr1 - R1 * MCos(Angle[3]);
      XFin[3] := Xr2 + R2 * MSin(Angle[3]);
      YFin[3] := Yr2 - R2 * MCos(Angle[3]);
      Angle[3] := MiseEnFormeAngleDr(Angle[3]);
      EcartTmp := CalculDistDeuxPts(XP1,YP1,XDebut[3],YDebut[3]) +
                  CalculDistDeuxPts(XP2,YP2,XFin[3],YFin[3]);
      if EcartTmp < Ecart then
      BEGIN
        Ecart := EcartTmp;
        Selectionne := 3;
      END;
    END;

    Tmp := (R1 + R2) / Dist;
    if (Tmp >= -1)  and (Tmp <= 1) then
    BEGIN
      AngleTmp:= ArcSin(Tmp);
      Angle[2] := (AngleRef - AngleTmp);
      XDebut[2] := Xr1 - R1 * MSin(Angle[2]);
      YDebut[2] := Yr1 + R1 * MCos(Angle[2]);
      XFin[2] := Xr2 + R2 * MSin(Angle[2]);
      YFin[2] := Yr2 - R2 * MCos(Angle[2]);
      Angle[2] := MiseEnFormeAngleDr(Angle[2]);
      EcartTmp := CalculDistDeuxPts(XP1,YP1,XDebut[2],YDebut[2]) +
                  CalculDistDeuxPts(XP2,YP2,XFin[2],YFin[2]);
      if EcartTmp < Ecart then
      BEGIN
        Ecart := EcartTmp;
        Selectionne := 2;
      END;

      Angle[4] := (AngleRef + AngleTmp);
      XDebut[4] := Xr1 + R1 * MSin(Angle[4]);
      YDebut[4] := Yr1 - R1 * MCos(Angle[4]);
      XFin[4] := Xr2 - R2 * MSin(Angle[4]);
      YFin[4] := Yr2 + R2 * MCos(Angle[4]);
      Angle[4] := MiseEnFormeAngleDr(Angle[4]);
      EcartTmp := CalculDistDeuxPts(XP1,YP1,XDebut[4],YDebut[4]) +
                  CalculDistDeuxPts(XP2,YP2,XFin[4],YFin[4]);
      if EcartTmp < Ecart then
      BEGIN
        Ecart := EcartTmp;
        Selectionne := 4;
      END;
    END;
  END;

  PROCEDURE R2SupR1;

  BEGIN
    Tmp := (R2 - R1) / Dist;
    if (Tmp >= -1)  and (Tmp <= 1) then
    BEGIN
      AngleTmp:= ArcSin(Tmp);
      Angle[1] := (AngleRef + AngleTmp);
      XDebut[1] := Xr1 - R1 * MSin(Angle[1]);
      YDebut[1] := Yr1 + R1 * MCos(Angle[1]);
      XFin[1] := Xr2 - R2 * MSin(Angle[1]);
      YFin[1] := Yr2 + R2 * MCos(Angle[1]);
      Angle[1] := MiseEnFormeAngleDr(Angle[1]);
      EcartTmp := CalculDistDeuxPts(XP1,YP1,XDebut[1],YDebut[1]) +
                  CalculDistDeuxPts(XP2,YP2,XFin[1],YFin[1]);
      if EcartTmp < Ecart then
      BEGIN
        Ecart := EcartTmp;
        Selectionne := 1;
      END;

      Angle[3] := (AngleRef - AngleTmp);
      XDebut[3] := Xr1 + R1 * MSin(Angle[3]);
      YDebut[3] := Yr1 - R1 * MCos(Angle[3]);
      XFin[3] := Xr2 + R2 * MSin(Angle[3]);
      YFin[3] := Yr2 - R2 * MCos(Angle[3]);
      Angle[3] := MiseEnFormeAngleDr(Angle[3]);
      EcartTmp := CalculDistDeuxPts(XP1,YP1,XDebut[3],YDebut[3]) +
                  CalculDistDeuxPts(XP2,YP2,XFin[3],YFin[3]);
      if EcartTmp < Ecart then
      BEGIN
        Ecart := EcartTmp;
        Selectionne := 3;
      END;
    END;

    Tmp := (R1 + R2) / Dist;
    if (Tmp >= -1)  and (Tmp <= 1) then
    BEGIN
      AngleTmp:= ArcSin(Tmp);
      Angle[2] := (AngleRef - AngleTmp);
      XDebut[2] := Xr1 - R1 * MSin(Angle[2]);
      YDebut[2] := Yr1 + R1 * MCos(Angle[2]);
      XFin[2] := Xr2 + R2 * MSin(Angle[2]);
      YFin[2] := Yr2 - R2 * MCos(Angle[2]);
      Angle[2] := MiseEnFormeAngleDr(Angle[2]);
      EcartTmp := CalculDistDeuxPts(XP1,YP1,XDebut[2],YDebut[2]) +
                  CalculDistDeuxPts(XP2,YP2,XFin[2],YFin[2]);
      if EcartTmp < Ecart then
      BEGIN
        Ecart := EcartTmp;
        Selectionne := 2;
      END;

      Angle[4] := (AngleRef + AngleTmp);
      XDebut[4] := Xr1 + R1 * MSin(Angle[4]);
      YDebut[4] := Yr1 - R1 * MCos(Angle[4]);
      XFin[4] := Xr2 - R2 * MSin(Angle[4]);
      YFin[4] := Yr2 + R2 * MCos(Angle[4]);
      Angle[4] := MiseEnFormeAngleDr(Angle[4]);
      EcartTmp := CalculDistDeuxPts(XP1,YP1,XDebut[4],YDebut[4]) +
                  CalculDistDeuxPts(XP2,YP2,XFin[4],YFin[4]);
      if EcartTmp < Ecart then
      BEGIN
        Ecart := EcartTmp;
        Selectionne := 4;
      END;
    END;
  END;

BEGIN
  CDrCeCe := false;
  Ecart := 9999.999;
  Dist := CalculDistDeuxPts(Xc1,Yc1,Xc2,Yc2);
  if (Xc1 = Xc2) and (Yc1 = Yc2) then exit;
  if Xc1 < Xc2 then
  BEGIN
    Xr1 := Xc1;
    Yr1 := Yc1;
    Xr2 := Xc2;
    Yr2 := Yc2;
    R1 := Rc1;
    R2 := Rc2;
    ConvSourisPoint(XS1,YS1,XP1,YP1);
    ConvSourisPoint(XS2,YS2,XP2,YP2);
  END
  else
  BEGIN
    Xr1 := Xc2;
    Yr1 := Yc2;
    Xr2 := Xc1;
    Yr2 := Yc1;
    R1 := Rc2;
    R2 := Rc1;
    ConvSourisPoint(XS2,YS2,XP1,YP1);
    ConvSourisPoint(XS1,YS1,XP2,YP2);
  END;
  if R1 > R2 then
  BEGIN
    if (Dist < R1) and ((Dist + R2) <  R1) then exit;
  END
  else if (Dist < R2) and ((Dist + R1) <  R2) then exit;

  AngleRef := CalculAngleSegment(Xr1,Yr1,Xr2,Yr2);
  if R1 > R2 then R1SupR2
             else R2SupR1;

  X := XDebut[Selectionne];
  Y := YDebut[Selectionne];
  A := Angle[Selectionne];
  XD := XDebut[Selectionne];
  YD := YDebut[Selectionne];
  XF := XFin[Selectionne];
  YF := YFin[Selectionne];
  CDrCeCe := true;
END;

{---------------------------------------------------------------------------}
{---------------------------------------------------------------------------}

{}
{ Calcul le cercle dont on connait le point de centre et un point sur la    }
{ circonfrence                                                             }
{}

FUNCTION CCePcPts(Xpc,Ypc,Xp,Yp : real;VAR X,Y,R : real):boolean;

BEGIN
  CCePcPts := false;
  if (Xpc = Xp) and (Ypc = Yp) then exit;
  X := Xpc;
  Y := Ypc;
  R := CalculDistDeuxPts(Xpc,Ypc,Xp,Yp);
  CCePcPts := true;
END;

{}
{ Calcul le cercle dont on connait le point de centre et une droite tangente}
{}

FUNCTION CCePcDr(Xpc,Ypc,Xpd,Ypd,Aod,A,B,C : real;VAR X,Y,R : real):boolean;

VAR
  Tmp : real;
  X2,Y2 : real;

BEGIN
  CCePcDr := false;
  Tmp := A * Xpc + B * Ypc + C;
  if Tmp = 0 then exit;
  CalculPtInterDrt(Xpc,Ypc,Xpd,Ypd,Aod,X2,Y2);
  X := Xpc;
  Y := Ypc;
  R := CalculDistDeuxPts(Xpc,Ypc,X2,Y2);
  CCePcDr := true;
END;

{}
{ Calcul le cercle dont on connait le point de centre et un cercle tangent  }
{}

FUNCTION CCePcCe(Xpc,Ypc,Xc,Yc,Rc : real;XS,YS : integer;
            VAR X,Y,R : real):boolean;

VAR
  Tmp : real;
  R1,R2 : real;
  XPoint,YPoint : real;

BEGIN
  CCePcCe := false;
  Tmp := sqr((Xpc - Xc)) + sqr((Ypc - Yc)) - sqr(Rc);
  if Tmp = 0 then exit;
  X := Xpc;
  Y := Ypc;
  Tmp := CalculDistDeuxPts(Xpc,Ypc,Xc,Yc);
  if Tmp > Rc then
  BEGIN
    R1 := Tmp - Rc;
    R2 := Tmp + Rc;
    ConvSourisPoint(XS,YS,XPoint,YPoint);
    Tmp := CalculDistDeuxPts(Xpc,Ypc,XPoint,YPoint);
    if abs(R2 - Tmp) > abs(R1 - Tmp) then
       R := R1
       else R := R2;
    CCePcCe := true;
  END
  else
  BEGIN
    R := Rc - Tmp;
    CCePcCe := true;
  END;
END;

{}
{ Calcul le cercle dont on connait un point sur la circonfrence ,          }
{ une droite tangente , le rayon                                            }
{}

FUNCTION CCePtsDr(Xp,Yp,Xpd,Ypd,Aod,A,B,C,Rayon:real;XS1,YS1,XS2,YS2:integer;
                  VAR X,Y,R:real) : boolean;
VAR
  Tmp : real;
  XTmp,YTmp,ATmp : real;
  XPoint,YPoint : real;
  Etmp : real;

BEGIN
  CCePtsDr := false;
  Tmp := A * Xp + B * Yp + C ;
  if Tmp = 0 then
  BEGIN
    ConvSourisPoint(XS2,YS2,XPoint,YPoint);
    Etmp := Rayon;
    Atmp := CalculAngleSegment(Xp,Yp,XPoint,YPoint);
    if Atmp > Pi then
    BEGIN
      Atmp := Atmp - Pi;
      if Atmp > Aod then Etmp := -Etmp;
    END
    else
      if Atmp < Aod then Etmp := -Etmp;
    Atmp := Aod;
    if Atmp >= Pi then Atmp := Atmp - Pi;
    X := Xp - Etmp * MSin(Atmp);
    Y := Yp + Etmp * MCos(Atmp);
    R := Rayon;
    CCePtsDr := true;
  END
  else
  BEGIN
  CDrParalDist(Xpd,Ypd,Aod,Rayon,XS1,YS1,XTmp,YTmp,ATmp);
  if not CPtIntDrCe(XTmp,YTmp,ATmp,Xp,Yp,Rayon,XS2,YS2,X,Y) then exit;
  R := Rayon;
  CCePtsDr := true;
  END;
END;

{}
{ Calcul le cercle dont on connait un point sur la circonfrence ,          }
{ un cercle tangent , le rayon                                              }
{}

FUNCTION CCePtsCe(Xp,Yp,Xc,Yc,Rc,Rayon:real;XS1,YS1,XS2,YS2:integer;
                  VAR X,Y,R:real) : boolean;
VAR
  D,Tmp1,Tmp2 : real;
  XPoint,YPoint : real;
  Xtmp,YTmp : real;
  Xpd,Ypd,Aod : real;

BEGIN
  CCePtsCe := false;
  D := CalculDistDeuxPts(Xc,Yc,Xp,Yp);
  if D = Rc then
  BEGIN
    CDrDeuxPts(Xc,Yc,Xp,Yp,Xpd,Ypd,Aod);
    if CPtIntDrCe(Xpd,Ypd,Aod,Xp,Yp,Rayon,XS1,YS1,XTmp,YTmp)then
    BEGIN
      X := XTmp;
      Y := YTmp;
      R := Rayon;
      CCePtsCe := true;
    END;
  END;
  if D > Rc then
  BEGIN
    if (D-Rc) > Rayon then exit;
    Tmp1 := CalculDistDeuxPts(Xp,Yp,Xc,Yc);
    ConvSourisPoint(XS2,YS2,XPoint,YPoint);
    Tmp2 := CalculDistDeuxPts(Xp,Yp,XPoint,YPoint);
    if Tmp2 > Tmp1 then
    BEGIN
      if Rayon > Rc then
      if CPtIntCeCe(Xp,Yp,Rayon,Xc,Yc,(Rayon-Rc),XS1,YS1,XTmp,YTmp) then
      BEGIN
        X := XTmp;
        Y := YTmp;
        R := Rayon;
        CCePtsCe := true;
      END;
    END
    else
      if CPtIntCeCe(Xp,Yp,Rayon,Xc,Yc,(Rc+Rayon),XS1,YS1,XTmp,YTmp) then
      BEGIN
        X := XTmp;
        Y := YTmp;
        R := Rayon;
        CCePtsCe := true;
      END;
  END;
  if D < Rc then
  BEGIN
    if Rayon > ((Rc + D) / 2) then exit;
    if (Rc-D) > Rayon then exit;
    if CPtIntCeCe(Xp,Yp,Rayon,Xc,Yc,(Rc-Rayon),XS1,YS1,XTmp,YTmp) then
    BEGIN
      X := XTmp;
      Y := YTmp;
      R := Rayon;
      CCePtsCe := true;
    END;
  END;
END;

{}
{ Calcul le cercle dont on connait deux points sur la circonfrence         }
{ et le rayon                                                               }
{}

FUNCTION CCe2Pts(Xp1,Yp1,Xp2,Yp2,Rayon:real;XS,YS:integer;
                 VAR X,Y,R:real) : boolean;

BEGIN
  CCe2Pts := false;
  if (Xp1 = Xp2) and (Yp1 = Yp2) then exit;
  if not CPtIntCeCe(Xp1,Yp1,Rayon,Xp2,Yp2,Rayon,XS,YS,X,Y) then exit;
  R := Rayon;
  CCe2Pts := true;
END;

{}
{ Calcul le cercle dont on connait deux droites tangentes et le rayon       }
{}

FUNCTION CCe2Dr(Xd1,Yd1,Aod1,Xd2,Yd2,Aod2,Rayon:real;XS1,YS1,XS2,YS2:integer;
                VAR X,Y,R:real):boolean;

VAR
  Xtmp,YTmp,Atmp : real;
  AD,BD,CD : array [1..2] of real;

BEGIN
  CCe2Dr := false;
  if Aod1 = Aod2 then exit;

  CDrParalDist(Xd1,Yd1,Aod1,Rayon,XS2,YS2,XTmp,YTmp,ATmp);
  CalculEqDroite(XTmp,YTmp,ATmp,AD[1],BD[1],CD[1]);
  CDrParalDist(Xd2,Yd2,Aod2,Rayon,XS1,YS1,XTmp,YTmp,ATmp);
  CalculEqDroite(XTmp,YTmp,ATmp,AD[2],BD[2],CD[2]);
  CPtIntDrDr(AD[1],BD[1],CD[1],AD[2],BD[2],CD[2],X,Y);

  R := Rayon;
  CCe2Dr := true;
END;

{}
{ Calcul le cercle dont on connait une droite tangente , un cercle tangent  }
{ et le rayon                                                               }
{}

FUNCTION CCeDrCe(Xd,Yd,Aod,Xc,Yc,Rc,Rayon:real;XS1,YS1,XS2,YS2:integer;
                 VAR X,Y,R:real):boolean;

VAR
  D,Tmp,Tmp2 : real;
  X2,Y2 : real;
  XPoint,YPoint : real;
  XPoint2,YPoint2 : real;
  XdTmp,YdTmp,AdTmp : real;

BEGIN
  CCeDrCe := false;
  CalculPtInterDrt(Xc,Yc,Xd,Yd,Aod,X2,Y2);
  D := CalculDistDeuxPts(Xc,Yc,X2,Y2);
  if D >= Rc then
  BEGIN
    CDrParalDist(Xd,Yd,Aod,Rayon,XS2,YS2,XdTmp,YdTmp,AdTmp);
    ConvSourisPoint(XS1,YS1,XPoint,YPoint);
    Tmp := CalculDistDeuxPts(XPoint,YPoint,Xc,Yc);
    ConvSourisPoint(XS2,YS2,XPoint2,YPoint2);
    Tmp2 := CalculDistDeuxPts(XPoint,YPoint,XPoint2,YPoint2);
    if Tmp2 > Tmp then
    BEGIN
      if Rayon > Rc then
        if CPtIntDrCe(XdTmp,YdTmp,AdTmp,Xc,Yc,(Rayon-Rc),XS1,YS1,X,Y) then
        BEGIN
          R := Rayon;
          CCeDrCe := true;
        END;
    END
    else
    if CPtIntDrCe(XdTmp,YdTmp,AdTmp,Xc,Yc,(Rc+Rayon),XS1,YS1,X,Y) then
    BEGIN
      R := Rayon;
      CCeDrCe := true;
    END;
  END
  else
  BEGIN
    CDrParalDist(Xd,Yd,Aod,Rayon,XS2,YS2,XdTmp,YdTmp,AdTmp);
    ConvSourisPoint(XS1,YS1,XPoint,YPoint);
    Tmp := CalculDistDeuxPts(Xc,Yc,XPoint,YPoint);
    if Tmp > Rc then
    BEGIN
      if CPtIntDrCe(XdTmp,YdTmp,AdTmp,Xc,Yc,(Rc+Rayon),XS1,YS1,X,Y) then
        BEGIN
          R := Rayon;
          CCeDrCe := true;
        END;
    END
    else
    BEGIN
      if CPtIntDrCe(XdTmp,YdTmp,AdTmp,Xc,Yc,(Rc-Rayon),XS1,YS1,X,Y) then
        BEGIN
          R := Rayon;
          CCeDrCe := true;
        END
    END;
  END;
END;

{}
{ Calcul le cercle dont on connait deux cercles tangents et le rayon        }
{}

FUNCTION CCe2Ce(Xc1,Yc1,Rc1,Xc2,Yc2,Rc2,Rayon:real;XS1,YS1,XS2,YS2:integer;
                VAR X,Y,R:real):boolean;

VAR
  D,Tmp : real;
  XS,YS : integer;
  XPoint,YPoint : real;
  Xr1,Yr1,Rr1 : real;
  Xr2,Yr2,Rr2 : real;
  InterneC1,InterneC2 : boolean;

BEGIN
  CCe2Ce := false;
  if (Xc1 = Xc2) and (Yc1 = Yc2) and (Rc1 = Rc2) then exit;
  D := CalculDistDeuxPts(Xc1,Yc1,Xc2,Yc2);
  if D < (Rc1 + Rc2) then
  BEGIN
    ConvSourisPoint(XS2,YS2,XPoint,YPoint);
    Tmp := CalculDistDeuxPts(Xc1,Yc1,XPoint,YPoint);
    if Tmp < Rc1 then InterneC1 := true
                 else InterneC1 := false;
    ConvSourisPoint(XS1,YS1,XPoint,YPoint);
    Tmp := CalculDistDeuxPts(Xc2,Yc2,XPoint,YPoint);
    if Tmp < Rc2 then InterneC2 := true
                 else InterneC2 := false;
    if InterneC1 then
    BEGIN
      if Rayon > Rc1 then exit;
      if InterneC2 then
      BEGIN
        if Rayon > Rc2 then exit;
        Xr1 := Xc1;
        Yr1 := Yc1;
        Rr1 := Rc1 - Rayon;
        Xr2 := Xc2;
        Yr2 := Yc2;
        Rr2 := Rc2 - Rayon;
        Tmp := Rc1 + Rc2 - D;
        if (2 * Rayon) > Tmp then exit;
        if not CPtIntCeCe(Xr1,Yr1,Rr1,Xr2,Yr2,Rr2,XS1,YS1,X,Y) then exit;
        R := Rayon;
        CCe2Ce := true;
      END
      else
      BEGIN
        Xr1 := Xc1;
        Yr1 := Yc1;
        Rr1 := Rc1 - Rayon;
        Xr2 := Xc2;
        Yr2 := Yc2;
        Rr2 := Rc2 + Rayon;
        Tmp := D + Rc1 - Rc2;
        if (2 * Rayon) > Tmp then exit;
        if not CPtIntCeCe(Xr1,Yr1,Rr1,Xr2,Yr2,Rr2,XS1,YS1,X,Y) then exit;
        R := Rayon;
        CCe2Ce := true;
      END;
    END
    else
    BEGIN
      if InterneC2 then
      BEGIN
        if Rayon > Rc2 then exit;
        Xr1 := Xc1;
        Yr1 := Yc1;
        Rr1 := Rc1 + Rayon;
        Xr2 := Xc2;
        Yr2 := Yc2;
        Rr2 := Rc2 - Rayon;
        Tmp := D - Rc1 + Rc2;
        if (2 * Rayon) > Tmp then exit;
        if not CPtIntCeCe(Xr1,Yr1,Rr1,Xr2,Yr2,Rr2,XS1,YS1,X,Y) then exit;
        R := Rayon;
        CCe2Ce := true;
      END
      else
      BEGIN
        Xr1 := Xc1;
        Yr1 := Yc1;
        Rr1 := Rc1 + Rayon;
        Xr2 := Xc2;
        Yr2 := Yc2;
        Rr2 := Rc2 + Rayon;
        if not CPtIntCeCe(Xr1,Yr1,Rr1,Xr2,Yr2,Rr2,XS1,YS1,X,Y) then exit;
        R := Rayon;
        CCe2Ce := true;
      END;
    END;
  END
  else
  BEGIN
    ConvSourisPoint(XS2,YS2,XPoint,YPoint);
    Tmp := CalculDistDeuxPts(Xc1,Yc1,XPoint,YPoint);
    if Tmp > D then InterneC2 := true
                 else InterneC2 := false;
    ConvSourisPoint(XS1,YS1,XPoint,YPoint);
    Tmp := CalculDistDeuxPts(Xc2,Yc2,XPoint,YPoint);
    if Tmp > D then InterneC1 := true
                 else InterneC1 := false;
    if InterneC1 then
    BEGIN
      if InterneC2 then
      BEGIN
        Tmp := D + Rc1 + Rc2;
        if Rayon < Tmp then exit;
        Xr1 := Xc1;
        Yr1 := Yc1;
        Rr1 := Rayon - Rc1;
        Xr2 := Xc2;
        Yr2 := Yc2;
        Rr2 := Rayon - Rc2;
        ConvSourisPoint(XS1,YS1,XPoint,YPoint);
        CPtSymPt(XPoint,YPoint,Xc1,Yc1,XPoint,YPoint);
        XS := round(XPoint * Echelle) + XOrigine;
        YS := YOrigine - round(YPoint * Echelle);
        if not CPtIntCeCe(Xr1,Yr1,Rr1,Xr2,Yr2,Rr2,XS,YS,X,Y) then exit;
        R := Rayon;
        CCe2Ce := true;
      END
      else
      BEGIN
        Tmp := D + Rc1 - Rc2;
        if Rayon < Tmp then exit;
        Xr1 := Xc1;
        Yr1 := Yc1;
        Rr1 := Rayon - Rc1;
        Xr2 := Xc2;
        Yr2 := Yc2;
        Rr2 := Rayon + Rc2;
        ConvSourisPoint(XS1,YS1,XPoint,YPoint);
        CPtSymPt(XPoint,YPoint,Xc1,Yc1,XPoint,YPoint);
        ConvPointSouris(XPoint,YPoint,XS,YS);
        if not CPtIntCeCe(Xr1,Yr1,Rr1,Xr2,Yr2,Rr2,XS,YS,X,Y) then exit;
        R := Rayon;
        CCe2Ce := true;
      END;
    END
    else
    BEGIN
      if InterneC2 then
      BEGIN
        Tmp := D - Rc1 + Rc2;
        if Rayon < Tmp then exit;
        Xr1 := Xc1;
        Yr1 := Yc1;
        Rr1 := Rayon + Rc1;
        Xr2 := Xc2;
        Yr2 := Yc2;
        Rr2 := Rayon - Rc2;
        ConvSourisPoint(XS2,YS2,XPoint,YPoint);
        CPtSymPt(XPoint,YPoint,Xc1,Yc1,XPoint,YPoint);
        ConvPointSouris(XPoint,YPoint,XS,YS);
        if not CPtIntCeCe(Xr1,Yr1,Rr1,Xr2,Yr2,Rr2,XS,YS,X,Y) then exit;
        R := Rayon;
        CCe2Ce := true;
      END
      else
      BEGIN
        Tmp := D - Rc1 - Rc2;
        if Rayon < Tmp then exit;
        Xr1 := Xc1;
        Yr1 := Yc1;
        Rr1 := Rc1 + Rayon;
        Xr2 := Xc2;
        Yr2 := Yc2;
        Rr2 := Rc2 + Rayon;
        if not CPtIntCeCe(Xr1,Yr1,Rr1,Xr2,Yr2,Rr2,XS1,YS1,X,Y) then exit;
        R := Rayon;
        CCe2Ce := true;
      END;
    END;
  END;
END;

{}
{ Calcul le cercle dont on connait trois points sur la circonfrence        }
{}

FUNCTION CCe3Pts(Xp1,Yp1,Xp2,Yp2,Xp3,Yp3:real;
                 VAR X,Y,R:real):boolean;
VAR
  Tmp : real;
  D,DA,DB,DC : real;
  A,B,C : real;

BEGIN
  CCe3Pts := false;

  if (Xp1 = Xp2) and (Yp1 = Yp2) then exit;
  if (Xp1 = Xp3) and (Yp1 = Yp3) then exit;
  if (Xp2 = Xp3) and (Yp2 = Yp3) then exit;

  D := Xp1 * Yp2 + Yp1 * Xp3;
  Tmp := Xp2 * Yp3 - Xp3 * Yp2;
  D := D + Tmp;
  Tmp := -(Yp3 * Xp1) - Yp1 * Xp2;
  D := D + Tmp;

  DA := (sqr(Xp3) + sqr(Yp3)) * Yp2;
  Tmp := (sqr(Xp1) + sqr(Yp1)) * Yp3;
  DA := DA + Tmp;
  Tmp := (sqr(Xp2) + sqr(Yp2)) * Yp1;
  DA := DA + Tmp;
  Tmp := (sqr(Xp1) + sqr(Yp1)) * Yp2;
  DA := DA - Tmp;
  Tmp := (sqr(Xp3) + sqr(Yp3)) * Yp1;
  DA := DA - Tmp;
  Tmp := (sqr(Xp2) + sqr(Yp2)) * Yp3;
  DA := DA - Tmp;

  DB := (sqr(Xp2) + sqr(Yp2)) * Xp3;
  Tmp := (sqr(Xp3) + sqr(Yp3)) * Xp1;
  DB := DB + Tmp;
  Tmp := (sqr(Xp1) + sqr(Yp1)) * Xp2;
  DB := DB + Tmp;
  Tmp := (sqr(Xp2) + sqr(Yp2)) * Xp1;
  DB := DB - Tmp;
  Tmp := (sqr(Xp1) + sqr(Yp1)) * Xp3;
  DB := DB - Tmp;
  Tmp := (sqr(Xp3) + sqr(Yp3)) * Xp2;
  DB := DB - Tmp;

  DC := (sqr(Xp1) + sqr(Yp1)) * Xp3 * Yp2;
  Tmp := (sqr(Xp2) + sqr(Yp2)) * Yp3 * Xp1;
  DC := DC + Tmp;
  Tmp := (sqr(Xp3) + sqr(Yp3)) * Xp2 * Yp1;
  DC := DC + Tmp;
  Tmp := (sqr(Xp3) + sqr(Yp3)) * Xp1 * Yp2;
  DC := DC - Tmp;
  Tmp := (sqr(Xp2) + sqr(Yp2)) * Yp1 * Xp3;
  DC := DC - Tmp;
  Tmp := (sqr(Xp1) + sqr(Yp1)) * Xp2 * Yp3;
  DC := DC - Tmp;

  A := DA / D;
  B := DB / D;
  C := DC / D;

  X := - A / 2;
  Y := - B / 2;
  Tmp := sqr(X) + sqr(Y) - C;
  R := sqrt(Tmp);
  CCe3Pts := true;
END;

{}

BEGIN

END.