UNIT CaoCree2;

{}
{                                                                           }
{                                CaoCree2                                   }
{                                                                           }
{                 - Routines de cration de gomtrie -                     }
{                                                                           }
{}

INTERFACE

USES
    TurboLib,
    GrafLib,
    Math,
    CaoGlob,
    CaoDef,
    CaoGra;

(* Point *)
PROCEDURE PointXY;
PROCEDURE PointRA;
PROCEDURE PtDeplXY;
PROCEDURE PtDeplRA;
PROCEDURE Centre;
PROCEDURE Extreme;
PROCEDURE Milieu;
PROCEDURE Intersec;
PROCEDURE PtSym;
PROCEDURE PtTourne;
PROCEDURE MilDeuxPts;

(* Droite *)
PROCEDURE PtA;
PROCEDURE PtParal;
PROCEDURE CercleA;
PROCEDURE ParalD;
PROCEDURE DrSym;
PROCEDURE DrTourne;

(* Droite 2 *)
PROCEDURE PtCercle;
PROCEDURE DeuxPts;
PROCEDURE Perpen;
PROCEDURE ParalC;
PROCEDURE DeuxCercles;
PROCEDURE Media;
PROCEDURE Bissec;

(* Cercle *)
PROCEDURE CercleXYR;
PROCEDURE CentreR;
PROCEDURE CeDeplXY;
PROCEDURE CeDeplRA;
PROCEDURE ConcenR;
PROCEDURE ConcenD;
PROCEDURE CeSym;
PROCEDURE CeTourne;

(* Cercle 2 *)
PROCEDURE CentrePt;
PROCEDURE CentreDr;
PROCEDURE CentreCe;
PROCEDURE PtDrR;
PROCEDURE PtCeR;
PROCEDURE DeuxPtsR;
PROCEDURE DeuxDrR;
PROCEDURE DrCeR;
PROCEDURE DeuxCeR;

(* Cercle 3 *)
PROCEDURE TroisPts;
PROCEDURE DeuxPtsDr;
PROCEDURE DeuxPtsCe;
PROCEDURE PtDeuxDr;
PROCEDURE PtDrCe;
PROCEDURE PtDeuxCe;
PROCEDURE TroisDr;
PROCEDURE DeuxDrCe;
PROCEDURE DeuxCeDr;
PROCEDURE TroisCe;

{}

IMPLEMENTATION

{}
{                               Point  XY                                   }
{}

PROCEDURE PointXY;
VAR
  XRech,YRech: real;

BEGIN
  CacheSouris;
  REPEAT
    Saisie(1,MaxYTxt -1,10,3,grClFond,blanc,
           ' Cote en X (+/- 99 999.999 ) : ');
  UNTIL (abs(reel) > -100000) and (abs(reel) < 100000);
  if Abandon then
  BEGIN
    MontreSouris;
    EffaceBas;
    exit;
  END;
  XRech:= reel;
  EffaceBas;
  REPEAT
    Saisie(1,MaxYTxt -1,10,3,grClFond,blanc,
           ' Cote en Y (+/- 99 999.999 ) : ');
  UNTIL (abs(reel) > -100000) and (abs(reel) < 100000);
  if Abandon then
  BEGIN
    MontreSouris;
    EffaceBas;
    exit;
  END;
  YRech:= reel;
  EffaceBas;
  MontreSouris;
  CreePoint(XRech,YRech);
END;

{}
{                        Point  rayon et angle                              }
{}

PROCEDURE PointRA;
VAR
  XRech,YRech: real;
  R : real;
  Angle : real;

BEGIN
  CacheSouris;
  REPEAT
    Saisie(1,MaxYTxt -1,9,3,grClFond,blanc,' Rayon (0.001 - 99 999.999 ) : ');
  UNTIL (reel > 0) and (reel < 100000);
  if Abandon then
  BEGIN
    MontreSouris;
    EffaceBas;
    exit;
  END;
  R := reel;
  EffaceBas;
  REPEAT
    Saisie(1,MaxYTxt -1,8,3,grClFond,blanc,' Angle (+/- 359.999 degrs) : ');
  UNTIL (abs(reel) > -360) and (abs(reel) < 360);
  if Abandon then
  BEGIN
    MontreSouris;
    EffaceBas;
    exit;
  END;
  Angle := DegToRad(reel);
  EffaceBas;
  MontreSouris;
  XRech:= R * MCos(Angle);
  YRech:= R * MSin(Angle);
  CreePoint(XRech,YRech);
END;

{}
{                         Point  dplac en XY                              }
{}

PROCEDURE PtDeplXY;
VAR
  XS,YS : integer;
  Xtmp,Ytmp : real;
  XRech,YRech: real;

BEGIN
  AfficheBas(grClFond,grClTexte,'Cliquez le point de rfrence ');
  Detection(XS,YS);
  EffaceBas;
  if DetectPoint then
  BEGIN
    Xtmp := PointEnCours^.X;
    Ytmp := PointEnCours^.Y;
    CacheSouris;
    REPEAT
      Saisie(1,MaxYTxt -1,10,3,grClFond,blanc,
             ' Dcalage en X (+/- 99 999.999 ) : ');
    UNTIL (abs(reel) > -100000) and (abs(reel) < 100000);
    if Abandon then
    BEGIN
      MontreSouris;
      EffaceBas;
      exit;
    END;
    XRech:= reel;
    EffaceBas;
    REPEAT
      Saisie(1,MaxYTxt -1,10,3,grClFond,blanc,
             ' Dcalage en Y (+/- 99 999.999 ) : ');
    UNTIL (abs(reel) > -100000) and (abs(reel) < 100000);
    if Abandon then
    BEGIN
      MontreSouris;
      EffaceBas;
      exit;
    END;
    YRech:= reel;
    EffaceBas;
    MontreSouris;
    XRech:= Xtmp + XRech;
    YRech:= Ytmp + YRech;
    CreePoint(XRech,YRech);
  END;
END;

{}
{                  Point dplac rayon et angle                             }
{}

PROCEDURE PtDeplRA;
VAR
  XS,YS:integer;
  R,Angle    : real;
  Xtmp,Ytmp  : real;
  XRech,YRech: real;

BEGIN
  AfficheBas(grClFond,grClTexte,'Cliquez le point de rfrence ');
  Detection(XS,YS);
  EffaceBas;
  if DetectPoint then
  BEGIN
    Xtmp := PointEnCours^.X;
    Ytmp := PointEnCours^.Y;
    CacheSouris;
    REPEAT
      Saisie(1,MaxYTxt -1,9,3,grClFond,blanc,
             ' Rayon de dplacement (0.001 - 99 999.999 ) : ');
    UNTIL (reel > 0) and (reel < 100000);
    if Abandon then
    BEGIN
      MontreSouris;
      EffaceBas;
      exit;
    END;
    R := reel;
    EffaceBas;
    REPEAT
      Saisie(1,MaxYTxt -1,8,3,grClFond,blanc,' Angle (+/- 359.999 degrs) : ');
    UNTIL (abs(reel) > -360) and (abs(reel) < 360);
    if Abandon then
    BEGIN
      MontreSouris;
      EffaceBas;
      exit;
    END;
    Angle := DegToRad(reel);
    EffaceBas;
    MontreSouris;
    XRech:= Xtmp + R * Cos(Angle);
    YRech:= Ytmp + R * Sin(Angle);
    CreePoint(XRech,YRech);
  END;
END;

{}
{                  Point de centre d'un cercle                              }
{}

PROCEDURE Centre;
VAR
  XS,YS:integer;
  XRech,YRech : real;

BEGIN
  AfficheBas(grClFond,grClTexte,'Cliquez l''lment de rfrence ');
  Detection(XS,YS);
  EffaceBas;
  if DetectCercle then
  BEGIN
    with CercleEnCours^ do
    BEGIN
      XRech := XC;
      YRech := YC;
    END;
  CreePoint(XRech,YRech);
  END;
END;

{}
{                       Point extrmit                                     }
{}

PROCEDURE Extreme;
VAR
  XS,YS:integer;
  XRech,YRech : real;

BEGIN
  AfficheBas(grClFond,grClTexte,'Cliquez l''lment de rfrence ');
  Detection(XS,YS);
  EffaceBas;

  if DetectSegment then
  BEGIN
    with DroiteEnCours^ do
    BEGIN
      PtLePlusProche(XS,YS,XDebut,YDebut,XFin,YFin,XRech,YRech);
            CreePoint(XRech,YRech);
    END;
  END
  else
  if DetectArc then
    with CercleEnCours^ do
    BEGIN
      PtLePlusProche(XS,YS,XDebut,YDebut,XFin,YFin,XRech,YRech);
            CreePoint(XRech,YRech);
    END;
END;

{}
{                       Point milieu                                        }
{}

PROCEDURE Milieu;
VAR
  XS,YS:integer;
  XRech,YRech : real;

BEGIN
  AfficheBas(grClFond,grClTexte,'Cliquez l''lment de rfrence ');
  Detection(XS,YS);
  EffaceBas;

  if DetectSegment then
  BEGIN
    with DroiteEnCours^ do
         CPtMilSeg(XDebut,YDebut,XFin,YFin,XRech,YRech);
    CreePoint(XRech,YRech);
  END
  else
  if DetectArc then
  BEGIN
    with CercleEnCours^ do
         CPtMilArc(XC,YC,R,ADebut,AFin,XRech,YRech);
  CreePoint(XRech,YRech);
  END;
END;

{}
{                       Point d'intersection                                }
{}

PROCEDURE Intersec;
VAR
  XS,YS:integer;
  X1Rech,Y1Rech: real;
  X2Rech,Y2Rech: real;
  XRech,Yrech : real;
  Xpd,Ypd,Aod,A1,B1,C1 : real;
  Xc1,Yc1,Rc1 : real;

BEGIN
  AfficheBas(grClFond,grClTexte,'Cliquez le 1er lment');
  Detection(XS,YS);
  EffaceBas;

  if DetectDroite then
  BEGIN
    AfficheBas(grClFond,grClTexte,'Cliquez le 2me lment');
    Detection(XS,YS);
    EffaceBas;
    with DroiteEnCours^ do
    BEGIN
      Xpd := X;
      Ypd := Y;
      Aod := Angle;
      A1 := A;
      B1 := B;
      C1 := C;
    END;
    if DetectDroite then
    BEGIN
       with DroiteEnCours^ do
            if CPtIntDrDr(A1,B1,C1,A,B,C,X1Rech,Y1Rech) then
               CreePoint(X1Rech,Y1Rech);
    END
    else
    if DetectCercle then
       with CercleEnCours^ do
          if CPtIntDrCe(Xpd,Ypd,Aod,Xc,Yc,R,XS,YS,XRech,YRech) then
             CreePoint(XRech,YRech);
  END
  else if DetectCercle then
  BEGIN
    AfficheBas(grClFond,grClTexte,'Cliquez le 2me lment');
    Detection(XS,YS);
    EffaceBas;
    with CercleEnCours^ do
    BEGIN
      Xc1 := Xc;
      Yc1 := Yc;
      Rc1 := R;
    END;
    if DetectDroite then
    BEGIN
       with DroiteEnCours^ do
         if CPtIntDrCe(X,Y,Angle,Xc1,Yc1,Rc1,XS,YS,XRech,YRech) then
            CreePoint(XRech,YRech);
    END
    else
    if DetectCercle then
       with CercleEnCours^ do
       BEGIN
         if CPtIntCeCe(Xc1,Yc1,Rc1,Xc,Yc,R,XS,YS,XRech,YRech) then
            CreePoint(XRech,YRech);
       END;
  END;
END;

{}
{                          Point symtrique                                 }
{}

PROCEDURE PtSym;
VAR
  XS,YS:integer;
  Xps,Yps : real;
  Xp,Yp : real;
  XRech,YRech: real;

BEGIN
  AfficheBas(grClFond,grClTexte,'Cliquez le point  symtriser');
  Detection(XS,YS);
  EffaceBas;
  if DetectPoint then
  BEGIN
    Xp := PointEnCours^.X;
    Yp := PointEnCours^.Y;
    AfficheBas(grClFond,grClTexte,
               'Cliquez l''axe de symtrie (point ou droite)');
    Detection(XS,YS);
    EffaceBas;

    if DetectPoint then
    BEGIN
      Xps := PointEnCours^.X;
      Yps := PointEnCours^.Y;
      CPtSymPt(Xp,Yp,Xps,Yps,XRech,YRech);
      CreePoint(XRech,YRech);
    END
    else
    if DetectDroite then
    BEGIN
      with DroiteEnCours^ do
        CPtSymDr(Xp,Yp,X,Y,Angle,XRech,YRech);
      CreePoint(XRech,YRech);
    END;
  END;
END;

{}
{                             Point tourn                                  }
{}

PROCEDURE PtTourne;
VAR
  XS,YS:integer;
  Xc,Yc : real;
  Xp,Yp : real;
  Angle : real;
  XRech,YRech: real;

BEGIN
  AfficheBas(grClFond,grClTexte,'Cliquez le point de rotation');
  Detection(XS,YS);
  EffaceBas;
  if DetectPoint then
  BEGIN
    Xc := PointEnCours^.X;
    Yc := PointEnCours^.Y;
    AfficheBas(grClFond,grClTexte,'Cliquez le point  tourner');
    Detection(XS,YS);
    EffaceBas;
    if DetectPoint then
    BEGIN
      Xp := PointEnCours^.X;
      Yp := PointEnCours^.Y;
      CacheSouris;
      REPEAT
        Saisie(1,MaxYTxt -1,8,3,grClFond,blanc,' Angle (+/- 359.999 degrs) : ');
      UNTIL (abs(reel) > -360) and (abs(reel) < 360);
      if Abandon then
      BEGIN
        MontreSouris;
        EffaceBas;
        exit;
      END;
      Angle := DegToRad(reel);
      EffaceBas;
      MontreSouris;
      CPtTourne(Xc,Yc,Xp,Yp,Angle,XRech,YRech);
      CreePoint(XRech,YRech);
    END;
  END;
END;

{}
{                         Point milieu de Deux points                          }
{}

PROCEDURE MilDeuxPts;
VAR
  XS,YS : integer;
  X1tmp,Y1tmp : real;
  X2tmp,Y2tmp : real;
  XRech,YRech: real;

BEGIN
  AfficheBas(grClFond,grClTexte,'Cliquez le premier point ');
  Detection(XS,YS);
  EffaceBas;
  if DetectPoint then
  BEGIN
    X1tmp := PointEnCours^.X;
    Y1tmp := PointEnCours^.Y;
    AfficheBas(grClFond,grClTexte,'Cliquez le deuxime point ');
    Detection(XS,YS);
    EffaceBas;
    if DetectPoint then
    BEGIN
      X2tmp := PointEnCours^.X;
      Y2tmp := PointEnCours^.Y;
      XRech:= 0.5 * (X1tmp + X2tmp);
      YRech:= 0.5 * (Y1tmp + Y2tmp);
      CreePoint(XRech,YRech);
    END;
  END;
END;

{}
{                      Droite par point et angle                            }
{}

PROCEDURE PtA;
VAR
  XS,YS:integer;
  XRech,YRech,ARech: real;

BEGIN
  AfficheBas(grClFond,grClTexte,'Cliquez le point de rfrence ');
  Detection(XS,YS);
  EffaceBas;
  if DetectPoint then
  BEGIN
    XRech := PointEnCours^.X;
    YRech := PointEnCours^.Y;
    CacheSouris;
    REPEAT
      Saisie(1,MaxYTxt -1,8,3,grClFond,blanc,' Angle (+/- 359.999 degrs) : ');
    UNTIL (abs(reel) > -360) and (abs(reel) < 360);
    if Abandon then
    BEGIN
      MontreSouris;
      EffaceBas;
      exit;
    END;
    ARech := DegToRad(reel);
    if ARech < 0 then ARech := 2 * pi + ARech;
    if ARech >= Pi then ARech := ARech - Pi;
    EffaceBas;
    MontreSouris;
    CreeDroite(XRech,YRech,ARech,0,0,0,0);
  END;
END;

{}
{                      Droite par point et parallle                        }
{}

PROCEDURE PtParal;
VAR
  XS,YS:integer;
  XRech,YRech,ARech: real;

BEGIN
  AfficheBas(grClFond,grClTexte,'Cliquez le point de rfrence ');
  Detection(XS,YS);
  EffaceBas;
  if DetectPoint then
  BEGIN
    XRech := PointEnCours^.X;
    YRech := PointEnCours^.Y;
    AfficheBas(grClFond,grClTexte,'Cliquez la parallle ');
    Detection(XS,YS);
    EffaceBas;
    if DetectDroite then
    with DroiteEnCours^ do
    BEGIN
      ARech := Angle;
      CreeDroite(XRech,YRech,ARech,0,0,0,0);
    END;
  END;
END;

{}
{                      Droite tangente cercle et angle                      }
{}

PROCEDURE CercleA;

VAR
  XS,YS : integer;
  XRef,YRef : integer;
  X1Rech,Y1Rech : real;
  X2Rech,Y2Rech : real;
  XRech,YRech : real;
  ARech : real;
  Angle : real;

BEGIN
  AfficheBas(grClFond,grClTexte,'Cliquez le cercle de rfrence ');
  Detection(XS,YS);
  EffaceBas;
  if DetectCercle then
  with CercleEnCours^ do
  BEGIN
    XRef := XS;
    YRef := YS;
    CacheSouris;
    REPEAT
      Saisie(1,MaxYTxt -1,8,3,grClFond,blanc,' Angle (+/- 359.999 degrs) : ');
    UNTIL (abs(reel) > -360) and (abs(reel) < 360);
    if Abandon then
    BEGIN
      MontreSouris;
      EffaceBas;
      exit;
    END;
    Angle := DegToRad(reel);
    CDrCeAngle(Xc,Yc,R,Angle,XRef,YRef,XRech,YRech,ARech);
    CreeDroite(XRech,YRech,ARech,0,0,0,0);
  END;
END;

{}
{                      Droite paralle et distance                          }
{}

PROCEDURE ParalD;
VAR
  XS,YS:integer;
  Etmp,Atmp : real;
  XPoint,YPoint : real;
  XRech,YRech,ARech : real;

BEGIN
  AfficheBas(grClFond,grClTexte,'Cliquez la droite de rfrence ');
  Detection(XS,YS);
  EffaceBas;
  if DetectDroite then
  BEGIN
    CacheSouris;
    REPEAT
      Saisie(1,MaxYTxt -1,10,3,grClFond,blanc,
             ' Ecart (0.001 - 99 999.999 ) : ');
    UNTIL (reel > 0) and (reel < 100000);
    if Abandon then
    BEGIN
      MontreSouris;
      EffaceBas;
      exit;
    END;
    Etmp := reel;
    EffaceBas;
    MontreSouris;
    AfficheBas(grClFond,grClTexte,'Position ? ');
    Detection(XS,YS);
    EffaceBas;
    with DroiteEnCours^ do
    BEGIN
      CDrParalDist(X,Y,Angle,Etmp,XS,YS,XRech,YRech,ARech);
      CreeDroite(XRech,YRech,ARech,0,0,0,0);
    END;
  END;
END;

{}
{                      Droite symtrique                                    }
{}

PROCEDURE DrSym;
VAR
  XS,YS:integer;
  Xpd,Ypd,Aod : real;
  Xps,Yps : real;
  Ad,Bd,Cd : real;
  XRech,YRech,ARech: real;

BEGIN
  AfficheBas(grClFond,grClTexte,'Cliquez la droite  symtriser');
  Detection(XS,YS);
  EffaceBas;
  if DetectDroite then
  BEGIN
    with DroiteEnCours^ do
    BEGIN
      Ad := A;
      Bd := B;
      Cd := C;
      Aod := Angle;
      Xpd := X;
      Ypd := Y;
    END;
    AfficheBas(grClFond,grClTexte,
               'Cliquez l''axe de symtrie (point ou droite)');
    Detection(XS,YS);
    EffaceBas;

    if DetectPoint then
    BEGIN
      Xps := PointEnCours^.X;
      Yps := PointEnCours^.Y;
      CDrSymPt(Xpd,Ypd,Aod,Xps,Yps,XRech,YRech,ARech);
      CreeDroite(XRech,YRech,ARech,0,0,0,0);
    END
    else
    if DetectDroite then
    BEGIN
      with DroiteEnCours^ do
        if CDrSymDr(Ad,Bd,Cd,Aod,A,B,C,Angle,XRech,YRech,ARech) then
           CreeDroite(XRech,YRech,ARech,0,0,0,0);
    END;
  END;
END;

{}
{                      Droite tourne                                       }
{}

PROCEDURE DrTourne;
VAR
  XS,YS:integer;
  Xc,Yc : real;
  Xpd,Ypd,Aod : real;
  AngleRot : real;
  XRech,YRech,ARech: real;

BEGIN
  AfficheBas(grClFond,grClTexte,'Cliquez le point de rotation');
  Detection(XS,YS);
  EffaceBas;
  if DetectPoint then
  BEGIN
    Xc := PointEnCours^.X;
    Yc := PointEnCours^.Y;
    AfficheBas(grClFond,grClTexte,'Cliquez la droite  tourner');
    Detection(XS,YS);
    EffaceBas;
    if DetectDroite then
    BEGIN
      with DroiteEnCours^do
      BEGIN
        Xpd := X;
        Ypd := Y;
        Aod := Angle;
      END;
      CacheSouris;
      REPEAT
        Saisie(1,MaxYTxt -1,8,3,grClFond,blanc,' Angle (+/- 359.999 degrs) : ');
      UNTIL (abs(reel) > -360) and (abs(reel) < 360);
      if Abandon then
      BEGIN
        MontreSouris;
        EffaceBas;
        exit;
      END;
      AngleRot := DegToRad(reel);
      EffaceBas;
      MontreSouris;
      CDrTourne(Xc,Yc,Xpd,Ypd,Aod,AngleRot,XRech,YRech,ARech);
      CreeDroite(XRech,YRech,ARech,0,0,0,0);
    END;
  END;
END;

{}
{                      Droite par point et tangente cercle                  }
{}

PROCEDURE PtCercle;
VAR
  XS,YS:integer;
  Xp,Yp : real;
  XPoint,YPoint : real;
  XRech,YRech,ARech : real;
  ARef,A1Rech,A2Rech: real;

BEGIN
  AfficheBas(grClFond,grClTexte,'Cliquez le point de rfrence ');
  Detection(XS,YS);
  EffaceBas;
  if DetectPoint then
  BEGIN
    Xp := PointEnCours^.X;
    Yp := PointEnCours^.Y;
    AfficheBas(grClFond,grClTexte,'Cliquez le cercle ');
    Detection(XS,YS);
    EffaceBas;
    if DetectCercle then
    with CercleEnCours^ do
    BEGIN
      if CDrPtCe(Xp,Yp,Xc,Yc,R,XRech,YRech,A1Rech,A2Rech) then
      BEGIN
        XPoint := (XS - XOrigine) / Echelle;
        YPoint := -(YS - YOrigine) / Echelle;
        Aref := CalculAngleSegment(Xp,Yp,XPoint,YPoint);
        Aref := MiseEnFormeAngleDr(Aref);
        ARech := ALePlusProche(Aref,A1Rech,A2Rech);
        CreeDroite(XRech,YRech,ARech,0,0,0,0);
      END;
    END;
  END;
END;

{}
{                      Droite par Deux points                                  }
{}

PROCEDURE DeuxPts;
VAR
  XS,YS:integer;
  Xp1,Yp1 : real;
  Xp2,Yp2 : real;
  XRech,YRech : real;
  ARech : real;

BEGIN
  AfficheBas(grClFond,grClTexte,'Cliquez le premier point');
  Detection(XS,YS);
  EffaceBas;
  if DetectPoint then
  BEGIN
    Xp1 := PointEnCours^.X;
    Yp1 := PointEnCours^.Y;
    AfficheBas(grClFond,grClTexte,'Cliquez le deuxime point');
    Detection(XS,YS);
    EffaceBas;
    if DetectPoint then
    BEGIN
      Xp2 := PointEnCours^.X;
      Yp2 := PointEnCours^.Y;
      if (Xp1 = Xp2) and (Yp1 = Yp2) then exit;
      CDrDeuxPts(Xp1,Yp1,Xp2,Yp2,XRech,YRech,ARech);
      CreeDroite(XRech,YRech,ARech,Xp1,Yp1,Xp2,Yp2);
    END;
  END;
END;

{}
{                      Droite perpendiculaire                               }
{}

PROCEDURE Perpen;
VAR
  XS,YS:integer;
  XRef,YRef : integer;
  Xp,Yp : real;
  Adroite : real;
  XCercle,YCercle,RCercle : real;
  X1Rech,Y1Rech : real;
  X2Rech,Y2Rech : real;
  XRech,YRech : real;
  ARech : real;

BEGIN
  AfficheBas(grClFond,grClTexte,'Cliquez le premier lment');
  Detection(XS,YS);
  EffaceBas;
  if DetectPoint then
  BEGIN
    Xp := PointEnCours^.X;
    Yp := PointEnCours^.Y;
    AfficheBas(grClFond,grClTexte,'Cliquez le deuxime lment');
    Detection(XS,YS);
    EffaceBas;
    if DetectDroite then
    with DroiteEnCours^ do
    BEGIN
      CDrPtsPerpDr(Xp,Yp,Angle,XRech,YRech,ARech);
      CreeDroite(XRech,YRech,ARech,0,0,0,0);
    END;
  END
  else
  if DetectDroite then
  BEGIN
    with DroiteEnCours^ do ADroite := Angle;
    AfficheBas(grClFond,grClTexte,'Cliquez le deuxime lment');
    Detection(XS,YS);
    EffaceBas;
    if DetectPoint then
    BEGIN
      Xp := PointEnCours^.X;
      Yp := PointEnCours^.Y;
      CDrPtsPerpDr(Xp,Yp,ADroite,XRech,YRech,ARech);
      CreeDroite(XRech,YRech,ARech,0,0,0,0);
    END
    else
    if DetectCercle then
    with CercleEnCours^ do
    BEGIN
      XRef := XS;
      YRef := YS;
      CDrCePerpDr(Xc,Yc,R,ADroite,X1Rech,Y1Rech,X2Rech,Y2Rech,ARech);
      PtLePlusProche(XRef,YRef,X1Rech,Y1Rech,X2Rech,Y2Rech,XRech,YRech);
      CreeDroite(XRech,YRech,ARech,0,0,0,0);
    END;
  END
  else
  if DetectCercle then
  BEGIN
    XRef := XS;
    YRef := YS;
    with CercleEnCours^ do
    BEGIN
      XCercle := Xc;
      YCercle := Yc;
      RCercle := R;
    END;
    AfficheBas(grClFond,grClTexte,'Cliquez le deuxime lment');
    Detection(XS,YS);
    EffaceBas;
    if DetectDroite then
    with DroiteEnCours^ do
    BEGIN
      CDrCePerpDr(XCercle,YCercle,RCercle,Angle,X1Rech,Y1Rech,X2Rech,Y2Rech,ARech);
      PtLePlusProche(XRef,YRef,X1Rech,Y1Rech,X2Rech,Y2Rech,XRech,YRech);
      CreeDroite(XRech,YRech,ARech,0,0,0,0);
    END;
  END
END;

{}
{                      Droite paralle et tangente cercle                   }
{}

PROCEDURE ParalC;
VAR
  XS,YS : integer;
  XRef,YRef : integer;
  X1Rech,Y1Rech : real;
  X2Rech,Y2Rech : real;
  XRech,YRech : real;
  ARech : real;
  XCercle,YCercle,RCercle : real;
  Angle : real;

BEGIN
  AfficheBas(grClFond,grClTexte,'Cliquez le premier lment');
  Detection(XS,YS);
  EffaceBas;
  if DetectCercle then
  BEGIN
    XRef := XS;
    YRef := YS;
    with CercleEnCours^ do
    BEGIN
      XCercle := Xc;
      YCercle := Yc;
      RCercle := R;
    END;
    AfficheBas(grClFond,grClTexte,'Cliquez le deuxime lment');
    Detection(XS,YS);
    EffaceBas;
    if DetectDroite then
    with DroiteEnCours^ do
    BEGIN
      CDrCeAngle(XCercle,YCercle,RCercle,Angle,XRef,YRef,XRech,YRech,ARech);
      CreeDroite(XRech,YRech,ARech,0,0,0,0);
    END;
  END
  else
  if DetectDroite then
  BEGIN
    Angle := DroiteEnCours^.Angle;

    AfficheBas(grClFond,grClTexte,'Cliquez le deuxime lment');
    Detection(XS,YS);
    EffaceBas;
    if DetectCercle then
    XRef := XS;
    YRef := YS;
    with CercleEnCours^ do
    BEGIN
      XCercle := Xc;
      YCercle := Yc;
      RCercle := R;
    END;
    CDrCeAngle(XCercle,YCercle,RCercle,Angle,XRef,YRef,XRech,YRech,ARech);
    CreeDroite(XRech,YRech,ARech,0,0,0,0);
  END;
END;

{}
{                      Droite tangente Deux cercles                            }
{}

PROCEDURE DeuxCercles;

VAR
  XS1,YS1 : integer;
  XS2,YS2 : integer;
  Xc1,Yc1,Rc1 : real;
  XRech,YRech,ARech : real;
  XDRech,YDRech,XFRech,YFRech : real;

BEGIN
  AfficheBas(grClFond,grClTexte,'Cliquez le premier cercle');
  Detection(XS1,YS1);
  EffaceBas;
  if DetectCercle then
  BEGIN
    with CercleEnCours^ do
    BEGIN
      Xc1 := Xc;
      Yc1 := Yc;
      Rc1 := R;
    END;
    AfficheBas(grClFond,grClTexte,'Cliquez le deuxime cercle');
    Detection(XS2,YS2);
    EffaceBas;
    if DetectCercle then
    BEGIN
      with CercleEnCours^ do
      if CDrCeCe(Xc1,Yc1,Rc1,Xc,Yc,R,XS1,YS1,XS2,YS2,
                XRech,YRech,ARech,XDRech,YDRech,XFRech,YFRech) then
        CreeDroite(XRech,YRech,ARech,XDRech,YDRech,XFRech,YFRech);
    END;
  END;
END;

{}
{                      Mdiatrice                                           }
{}

PROCEDURE Media;
VAR
  XS,YS:integer;
  Xpd,Ypd,Aod : real;
  Ad,Bd,Cd : real;
  XRech,YRech,ARech: real;

BEGIN
  AfficheBas(grClFond,grClTexte,'Cliquez la premire droite');
  Detection(XS,YS);
  EffaceBas;
  if DetectDroite then
  BEGIN
    with DroiteEnCours^ do
    BEGIN
      Ad := A;
      Bd := B;
      Cd := C;
      Aod := Angle;
    END;
    AfficheBas(grClFond,grClTexte,'Cliquez la deuxime droite');
    Detection(XS,YS);
    EffaceBas;
    if DetectDroite then
    BEGIN
      with DroiteEnCours^ do
        if CMediatrice(Ad,Bd,Cd,Aod,A,B,C,Angle,XRech,YRech,ARech) then
           CreeDroite(XRech,YRech,ARech,0,0,0,0);
    END;
  END;
END;

{}
{                      Bissectrice                                          }
{}

PROCEDURE Bissec;
VAR
  XS,YS:integer;
  Xpd,Ypd,Aod : real;
  Ad,Bd,Cd : real;
  XRech,YRech,ARech: real;

BEGIN
  AfficheBas(grClFond,grClTexte,'Cliquez la premire droite');
  Detection(XS,YS);
  EffaceBas;
  if DetectDroite then
  BEGIN
    with DroiteEnCours^ do
    BEGIN
      Ad := A;
      Bd := B;
      Cd := C;
      Aod := Angle;
    END;
    AfficheBas(grClFond,grClTexte,'Cliquez la deuxime droite');
    Detection(XS,YS);
    EffaceBas;
    if DetectDroite then
    BEGIN
      with DroiteEnCours^ do
        if CBissectrice(Ad,Bd,Cd,Aod,A,B,C,Angle,XRech,YRech,ARech) then
           CreeDroite(XRech,YRech,ARech,0,0,0,0);
    END;
  END;
END;

{}
{                      Cercle X , Y et rayon                                }
{}

PROCEDURE CercleXYR;
VAR
  XRech,YRech: real;
  RRech : real;

BEGIN
  CacheSouris;
  REPEAT
    Saisie(1,MaxYTxt -1,10,3,grClFond,blanc,
           ' Cote en X (+/- 99 999.999 ) : ');
  UNTIL (abs(reel) > -100000) and (abs(reel) < 100000);
  if Abandon then
  BEGIN
    MontreSouris;
    EffaceBas;
    exit;
  END;
  XRech:= reel;
  EffaceBas;
  REPEAT
    Saisie(1,MaxYTxt -1,10,3,grClFond,blanc,
           ' Cote en Y (+/- 99 999.999 ) : ');
  UNTIL (abs(reel) > -100000) and (abs(reel) < 100000);
  if Abandon then
  BEGIN
    MontreSouris;
    EffaceBas;
    exit;
  END;
  YRech:= reel;
  EffaceBas;
  REPEAT
    Saisie(1,MaxYTxt -1,10,3,grClFond,blanc,' Rayon (0 - 99 999.999 ) : ');
  UNTIL (reel > 0) and (reel < 100000);
  if Abandon then
  BEGIN
    MontreSouris;
    EffaceBas;
    exit;
  END;
  RRech := reel;
  EffaceBas;
  MontreSouris;
  CreeCercle(XRech,YRech,RRech,0,0,0,0,0,0);
END;

{}
{                      Cercle centre et rayon                               }
{}

PROCEDURE CentreR;
VAR
  XS,YS : integer;
  XRech,YRech : real;
  RRech: real;

BEGIN
  AfficheBas(grClFond,grClTexte,'Cliquez le point de rfrence ');
  Detection(XS,YS);
  EffaceBas;
  if DetectPoint then
  BEGIN
    XRech := PointEnCours^.X;
    YRech := PointEnCours^.Y;
    CacheSouris;
    REPEAT
      Saisie(1,MaxYTxt -1,10,3,grClFond,blanc,' Rayon (0 - 99 999.999 ) : ');
    UNTIL (reel > 0) and (reel < 100000);
    if Abandon then
    BEGIN
      MontreSouris;
      EffaceBas;
      exit;
    END;
    RRech := reel;
    EffaceBas;
    MontreSouris;
    CreeCercle(XRech,YRech,RRech,0,0,0,0,0,0);
  END;
END;

{}
{                      Cercle dplac en X et Y                             }
{}

PROCEDURE CeDeplXY;
VAR
  XS,YS : integer;
  Xtmp,Ytmp : real;
  XRech,YRech: real;

BEGIN
  AfficheBas(grClFond,grClTexte,'Cliquez le cercle de rfrence ');
  Detection(XS,YS);
  EffaceBas;
  if DetectCercle then
  BEGIN
    Xtmp := CercleEnCours^.XC;
    Ytmp := CercleEnCours^.YC;
    CacheSouris;
    REPEAT
      Saisie(1,MaxYTxt -1,10,3,grClFond,blanc,
             ' Dcalage en X (+/- 99 999.999 ) : ');
    UNTIL (abs(reel) > -100000) and (abs(reel) < 100000);
    if Abandon then
    BEGIN
      MontreSouris;
      EffaceBas;
      exit;
    END;
    XRech:= reel;
    EffaceBas;
    REPEAT
      Saisie(1,MaxYTxt -1,10,3,grClFond,blanc,
             ' Dcalage en Y (+/- 99 999.999 ) : ');
    UNTIL (abs(reel) > -100000) and (abs(reel) < 100000);
    if Abandon then
    BEGIN
      MontreSouris;
      EffaceBas;
      exit;
    END;
    YRech:= reel;
    EffaceBas;
    MontreSouris;
    XRech:= Xtmp + XRech;
    YRech:= Ytmp + YRech;
    with CercleEnCours^ do
      CreeCercle(XRech,YRech,R,XDebut,YDebut,ADebut,XFin,YFin,AFin);
  END;
END;

{}
{                      Cercle dplac par rayon et angle                    }
{}

PROCEDURE CeDeplRA;
VAR
  XS,YS:integer;
  Rtmp,Angle    : real;
  Xtmp,Ytmp  : real;
  XRech,YRech: real;

BEGIN
  AfficheBas(grClFond,grClTexte,'Cliquez le cercle de rfrence ');
  Detection(XS,YS);
  EffaceBas;
  if DetectCercle then
  BEGIN
    Xtmp := CercleEnCours^.XC;
    Ytmp := CercleEnCours^.YC;
    CacheSouris;
    REPEAT
      Saisie(1,MaxYTxt -1,9,3,grClFond,blanc,
             ' Rayon du dplacement (0.001 - 99 999.999 ) : ');
    UNTIL (reel > 0) and (reel < 100000);
    if Abandon then
    BEGIN
      MontreSouris;
      EffaceBas;
      exit;
    END;
    Rtmp := reel;
    EffaceBas;
    REPEAT
      Saisie(1,MaxYTxt -1,8,3,grClFond,blanc,' Angle (+/- 359.999 degrs) : ');
    UNTIL (abs(reel) > -360) and (abs(reel) < 360);
    if Abandon then
    BEGIN
      MontreSouris;
      EffaceBas;
      exit;
    END;
    Angle := DegToRad(reel);
    EffaceBas;
    MontreSouris;
    XRech:= Xtmp + Rtmp * Cos(Angle);
    YRech:= Ytmp + Rtmp * Sin(Angle);
    with CercleEnCours^ do
      CreeCercle(XRech,YRech,R,XDebut,YDebut,ADebut,XFin,YFin,AFin);
  END;
END;

{}
{                      Cercle concentrique et rayon                         }
{}

PROCEDURE ConcenR;
VAR
  XS,YS:integer;
  Rtmp : real;

BEGIN
  AfficheBas(grClFond,grClTexte,'Cliquez le cercle de rfrence ');
  Detection(XS,YS);
  EffaceBas;
  if DetectCercle then
  BEGIN
    CacheSouris;
    REPEAT
      Saisie(1,MaxYTxt -1,9,3,grClFond,blanc,
             ' Rayon (0.001 - 99 999.999 ) : ');
    UNTIL (reel > 0) and (reel < 100000);
    if Abandon then
    BEGIN
      MontreSouris;
      EffaceBas;
      exit;
    END;
    Rtmp := reel;
    EffaceBas;
    MontreSouris;
    with CercleEnCours^ do
      CreeCercle(XC,YC,Rtmp,0,0,0,0,0,0);
  END;
END;

{}
{                      Cercle concentrique et cart                         }
{}

PROCEDURE ConcenD;
VAR
  XS,YS:integer;
  Rtmp : real;

BEGIN
  AfficheBas(grClFond,grClTexte,'Cliquez le cercle de rfrence ');
  Detection(XS,YS);
  EffaceBas;
  if DetectCercle then
  BEGIN
    CacheSouris;
    REPEAT
      Saisie(1,MaxYTxt -1,10,3,grClFond,blanc,
             ' Diffrence de rayon (+/- 99 999.999 ) : ');
    UNTIL (reel > -100000) and (reel < 100000);
    if Abandon then
    BEGIN
      MontreSouris;
      EffaceBas;
      exit;
    END;
    Rtmp := reel;
    EffaceBas;
    MontreSouris;
    with CercleEnCours^ do
      CreeCercle(XC,YC,abs(R + Rtmp),0,0,0,0,0,0);
  END;
END;

{}
{                      Cercle symtrique                                    }
{}

PROCEDURE CeSym;
VAR
  XS,YS:integer;
  Xps,Yps : real;
  Xp,Yp : real;
  XRech,YRech: real;
  RRech : real;

BEGIN
  AfficheBas(grClFond,grClTexte,'Cliquez le cercle  symtriser');
  Detection(XS,YS);
  EffaceBas;
  if DetectCercle then
  BEGIN
    Xp := CercleEnCours^.XC;
    Yp := CercleEnCours^.YC;
    RRech := CercleEnCours^.R;
    AfficheBas(grClFond,grClTexte,
               'Cliquez l''axe de symtrie (point ou droite)');
    Detection(XS,YS);
    EffaceBas;

    if DetectPoint then
    BEGIN
      Xps := PointEnCours^.X;
      Yps := PointEnCours^.Y;
      CPtSymPt(Xp,Yp,Xps,Yps,XRech,YRech);
      CreeCercle(XRech,YRech,RRech,0,0,0,0,0,0);
    END
    else
    if DetectDroite then
    BEGIN
      with DroiteEnCours^ do
        CPtSymDr(Xp,Yp,X,Y,Angle,XRech,YRech);
      CreeCercle(XRech,YRech,RRech,0,0,0,0,0,0);
    END;
  END;
END;

{}
{                      Cercle tourn                                        }
{}

PROCEDURE CeTourne;
VAR
  XS,YS:integer;
  Xc,Yc : real;
  Xp,Yp : real;
  Angle : real;
  XRech,YRech: real;

BEGIN
  AfficheBas(grClFond,grClTexte,'Cliquez le point de rotation');
  Detection(XS,YS);
  EffaceBas;
  if DetectPoint then
  BEGIN
    Xc := PointEnCours^.X;
    Yc := PointEnCours^.Y;
    AfficheBas(grClFond,grClTexte,'Cliquez le cercle  tourner');
    Detection(XS,YS);
    EffaceBas;
    if DetectCercle then
    BEGIN
      Xp := CercleEnCours^.XC;
      Yp := CercleEnCours^.YC;
      CacheSouris;
      REPEAT
        Saisie(1,MaxYTxt -1,8,3,grClFond,blanc,' Angle (+/- 359.999 degrs) : ');
      UNTIL (abs(reel) > -360) and (abs(reel) < 360);
      if Abandon then
      BEGIN
        MontreSouris;
        EffaceBas;
        exit;
      END;
      Angle := DegToRad(reel);
      EffaceBas;
      MontreSouris;
      CPtTourne(Xc,Yc,Xp,Yp,Angle,XRech,YRech);
      with CercleEnCours^ do
           CreeCercle(XRech,YRech,R,0,0,0,0,0,0);
    END;
  END;
END;

{}
{                      Cercle par centre et point sur circonfrence         }
{}

PROCEDURE CentrePt;

VAR
  XS,YS : integer;
  Xpc,Ypc : real;
  XRech,YRech,R : real;

BEGIN
  AfficheBas(grClFond,grClTexte,'Cliquez le point de centre');
  Detection(XS,YS);
  EffaceBas;
  if DetectPoint then
  BEGIN
    Xpc := PointEnCours^.X;
    Ypc := PointEnCours^.Y;
    AfficheBas(grClFond,grClTexte,'Cliquez le point sur la circonfrence');
    Detection(XS,YS);
    EffaceBas;
    if DetectPoint then
    with PointEnCours^ do
      if CCePcPts(Xpc,Ypc,X,Y,XRech,YRech,R) then
         CreeCercle(XRech,YRech,R,0,0,0,0,0,0);
    END;
END;

{}
{                      Cercle par centre et droite tangente                 }
{}

PROCEDURE CentreDr;

VAR
  XS,YS : integer;
  Xpc,Ypc : real;
  XRech,YRech,R : real;

BEGIN
  AfficheBas(grClFond,grClTexte,'Cliquez le point de centre');
  Detection(XS,YS);
  EffaceBas;
  if DetectPoint then
  BEGIN
    Xpc := PointEnCours^.X;
    Ypc := PointEnCours^.Y;
    AfficheBas(grClFond,grClTexte,'Cliquez la droite tangente');
    Detection(XS,YS);
    EffaceBas;
    if DetectDroite then
    with DroiteEnCours^ do
      if CCePcDr(Xpc,Ypc,X,Y,Angle,A,B,C,XRech,YRech,R) then
         CreeCercle(XRech,YRech,R,0,0,0,0,0,0);
    END;
END;

{}
{                      Cercle par centre et cercle tangent                  }
{}

PROCEDURE CentreCe;

VAR
  XS,YS : integer;
  Xpc,Ypc : real;
  XRech,YRech,RRech : real;

BEGIN
  AfficheBas(grClFond,grClTexte,'Cliquez le point de centre');
  Detection(XS,YS);
  EffaceBas;
  if DetectPoint then
  BEGIN
    Xpc := PointEnCours^.X;
    Ypc := PointEnCours^.Y;
    AfficheBas(grClFond,grClTexte,'Cliquez le cercle tangent');
    Detection(XS,YS);
    EffaceBas;
    if DetectCercle then
    with CercleEnCours^ do
      if CCePcCe(Xpc,Ypc,Xc,Yc,R,XS,YS,XRech,YRech,RRech) then
         CreeCercle(XRech,YRech,RRech,0,0,0,0,0,0);
    END;
END;

{}
{                      Cercle par point , droite tangente et rayon          }
{}

PROCEDURE PtDrR;

VAR
  XS,YS : integer;
  XS1,YS1 : integer;
  XS2,YS2 : integer;
  Xp,Yp : real;
  XRech,YRech,RRech : real;

BEGIN
  AfficheBas(grClFond,grClTexte,'Cliquez le point sur la circonfrence');
  Detection(XS1,YS1);
  EffaceBas;
  if DetectPoint then
  BEGIN
    Xp := PointEnCours^.X;
    Yp := PointEnCours^.Y;
    AfficheBas(grClFond,grClTexte,'Cliquez la droite tangente');
    Detection(XS,YS);
    EffaceBas;
    if DetectDroite then
    BEGIN
      CacheSouris;
      REPEAT
        Saisie(1,MaxYTxt -1,9,3,grClFond,blanc,
               ' Rayon (0.001 - 99 999.999 ) : ');
      UNTIL (reel > 0) and (reel < 100000);
      if Abandon then
      BEGIN
        MontreSouris;
        EffaceBas;
        exit;
      END;
      RRech := reel;
      EffaceBas;
      MontreSouris;
      AfficheBas(grClFond,grClTexte,'Position ?');
      Detection(XS2,YS2);
      EffaceBas;
      with DroiteEnCours^ do
      if CCePtsDr(Xp,Yp,X,Y,Angle,A,B,C,RRech,XS1,YS1,XS2,YS2,XRech,YRech,RRech)
         then CreeCercle(XRech,YRech,RRech,0,0,0,0,0,0);
    END;
  END;
END;

{}
{                      Cercle par point , cercle tangent et rayon           }
{}

PROCEDURE PtCeR;
VAR
  XS1,YS1 : integer;
  XS,YS : integer;
  Xp,Yp : real;
  XRech,YRech,RRech : real;

BEGIN
  AfficheBas(grClFond,grClTexte,'Cliquez le point sur la circonfrence');
  Detection(XS,YS);
  EffaceBas;
  if DetectPoint then
  BEGIN
    Xp := PointEnCours^.X;
    Yp := PointEnCours^.Y;
    AfficheBas(grClFond,grClTexte,'Cliquez le cercle tangent');
    Detection(XS1,YS1);
    EffaceBas;
    if DetectCercle then
    BEGIN
      CacheSouris;
      REPEAT
        Saisie(1,MaxYTxt -1,9,3,grClFond,blanc,
               ' Rayon (0.001 - 99 999.999 ) : ');
      UNTIL (reel > 0) and (reel < 100000);
      if Abandon then
      BEGIN
        MontreSouris;
        EffaceBas;
        exit;
      END;
      RRech := reel;
      EffaceBas;
      MontreSouris;
      AfficheBas(grClFond,grClTexte,'Position ?');
      Detection(XS,YS);
      EffaceBas;
      with CercleEnCours^ do
      if CCePtsCe(Xp,Yp,Xc,Yc,R,RRech,XS,YS,XS1,YS1,XRech,YRech,RRech)
         then CreeCercle(XRech,YRech,RRech,0,0,0,0,0,0);
    END;
  END;
END;

{}
{                      Cercle par 2 points et rayon                         }
{}

PROCEDURE DeuxPtsR;

VAR
  XS,YS : integer;
  Xp1,Yp1 : real;
  Xp2,Yp2 : real;
  XRech,YRech,RRech : real;

BEGIN
  AfficheBas(grClFond,grClTexte,
             'Cliquez le premier point sur la circonfrence');
  Detection(XS,YS);
  EffaceBas;
  if DetectPoint then
  BEGIN
    Xp1 := PointEnCours^.X;
    Yp1 := PointEnCours^.Y;
    AfficheBas(grClFond,grClTexte,
               'Cliquez le deuxime point sur la circonfrence');
    Detection(XS,YS);
    EffaceBas;
    if DetectPoint then
    BEGIN
      Xp2 := PointEnCours^.X;
      Yp2 := PointEnCours^.Y;
      CacheSouris;
      REPEAT
        Saisie(1,MaxYTxt -1,9,3,grClFond,blanc,
               ' Rayon (0.001 - 99 999.999 ) : ');
      UNTIL (reel > 0) and (reel < 100000);
      if Abandon then
      BEGIN
        MontreSouris;
        EffaceBas;
        exit;
      END;
      RRech := reel;
      EffaceBas;
      MontreSouris;
      AfficheBas(grClFond,grClTexte,'Position ?');
      Detection(XS,YS);
      EffaceBas;
      if CCe2Pts(Xp1,Yp1,Xp2,Yp2,RRech,XS,YS,XRech,YRech,RRech)
         then CreeCercle(XRech,YRech,RRech,0,0,0,0,0,0);
    END;
  END;
END;

{}
{                      Cercle par 2 droites tangentes et rayon              }
{}

PROCEDURE DeuxDrR;

VAR
  XS1,YS1,XS2,YS2 : integer;
  Xd1,Yd1,Aod1 : real;
  Xd2,Yd2,Aod2 : real;
  XRech,YRech,RRech : real;

BEGIN
  AfficheBas(grClFond,grClTexte,
             'Cliquez la premire droite tangente');
  Detection(XS1,YS1);
  EffaceBas;
  if DetectDroite then
  BEGIN
    with DroiteEnCours^ do
    BEGIN
      Xd1 := X;
      Yd1 := Y;
      Aod1 := Angle;
    END;
    AfficheBas(grClFond,grClTexte,
               'Cliquez la deuxime droite tangente');
    Detection(XS2,YS2);
    EffaceBas;
    if DetectDroite then
    BEGIN
      with DroiteEnCours^ do
      BEGIN
        Xd2 := X;
        Yd2 := Y;
        Aod2 := Angle;
      END;
      CacheSouris;
      REPEAT
        Saisie(1,MaxYTxt -1,9,3,grClFond,blanc,
               ' Rayon (0.001 - 99 999.999 ) : ');
      UNTIL (reel > 0) and (reel < 100000);
      if Abandon then
      BEGIN
        MontreSouris;
        EffaceBas;
        exit;
      END;
      RRech := reel;
      EffaceBas;
      MontreSouris;
      if CCe2Dr(Xd1,Yd1,Aod1,Xd2,Yd2,Aod2,RRech,XS1,YS1,XS2,YS2,XRech,YRech,RRech)
         then CreeCercle(XRech,YRech,RRech,0,0,0,0,0,0);
    END;
  END;
END;

{}
{                      Cercle par droite , cercle tangent et rayon          }
{}

PROCEDURE DrCeR;

VAR
  XS1,YS1,XS2,YS2 : integer;
  Xd,Yd,Aod : real;
  XCentre,YCentre,Rc : real;
  XRech,YRech,RRech : real;

BEGIN
  AfficheBas(grClFond,grClTexte,
             'Cliquez la droite tangente');
  Detection(XS1,YS1);
  EffaceBas;
  if DetectDroite then
  BEGIN
    with DroiteEnCours^ do
    BEGIN
      Xd := X;
      Yd := Y;
      Aod := Angle;
    END;
    AfficheBas(grClFond,grClTexte,
               'Cliquez le cercle tangent');
    Detection(XS2,YS2);
    EffaceBas;
    if DetectCercle then
    BEGIN
      with CercleEnCours^ do
      BEGIN
        XCentre := Xc;
        YCentre := Yc;
        Rc := R;
      END;
      CacheSouris;
      REPEAT
        Saisie(1,MaxYTxt -1,9,3,grClFond,blanc,
               ' Rayon (0.001 - 99 999.999 ) : ');
      UNTIL (reel > 0) and (reel < 100000);
      if Abandon then
      BEGIN
        MontreSouris;
        EffaceBas;
        exit;
      END;
      RRech := reel;
      EffaceBas;
      MontreSouris;
      if CCeDrCe(Xd,Yd,Aod,XCentre,YCentre,Rc,RRech,XS1,YS1,XS2,YS2,XRech,YRech,RRech)
         then CreeCercle(XRech,YRech,RRech,0,0,0,0,0,0);
    END;
  END;
END;

{}
{                      Cercle par 2 cercles tangents et rayon               }
{}

PROCEDURE DeuxCeR;

VAR
  XS1,YS1,XS2,YS2 : integer;
  Xc1,Yc1,Rc1 : real;
  Xc2,Yc2,Rc2 : real;
  XRech,YRech,RRech : real;

BEGIN
  AfficheBas(grClFond,grClTexte,
             'Cliquez le premier cercle tangent');
  Detection(XS1,YS1);
  EffaceBas;
  if DetectCercle then
  BEGIN
    with CercleEnCours^ do
    BEGIN
      Xc1 := Xc;
      Yc1 := Yc;
      Rc1 := R;
    END;
    AfficheBas(grClFond,grClTexte,
               'Cliquez le deuxime cercle tangent');
    Detection(XS2,YS2);
    EffaceBas;
    if DetectCercle then
    BEGIN
      with CercleEnCours^ do
      BEGIN
        Xc2 := Xc;
        Yc2 := Yc;
        Rc2 := R;
      END;
      CacheSouris;
      REPEAT
        Saisie(1,MaxYTxt -1,9,3,grClFond,blanc,
               ' Rayon (0.001 - 99 999.999 ) : ');
      UNTIL (reel > 0) and (reel < 100000);
      if Abandon then
      BEGIN
        MontreSouris;
        EffaceBas;
        exit;
      END;
      RRech := reel;
      EffaceBas;
      MontreSouris;
      if CCe2Ce(Xc1,Yc1,Rc1,Xc2,Yc2,Rc2,RRech,XS1,YS1,XS2,YS2,XRech,YRech,RRech)
         then CreeCercle(XRech,YRech,RRech,0,0,0,0,0,0);
    END;
  END;
END;

{}
{                      Cercle par 3 cercles tangents                        }
{}

PROCEDURE TroisPts;
VAR
  XS,YS : integer;
  Xp1,Yp1 : real;
  Xp2,Yp2 : real;
  Xp3,Yp3 : real;
  XRech,YRech,RRech : real;

BEGIN
  AfficheBas(grClFond,grClTexte,
             'Cliquez le premier point sur la circonfrence');
  Detection(XS,YS);
  EffaceBas;
  if DetectPoint then
  BEGIN
    Xp1 := PointEnCours^.X;
    Yp1 := PointEnCours^.Y;
    AfficheBas(grClFond,grClTexte,
               'Cliquez le deuxime point sur la circonfrence');
    Detection(XS,YS);
    EffaceBas;
    if DetectPoint then
    BEGIN
      Xp2 := PointEnCours^.X;
      Yp2 := PointEnCours^.Y;
      AfficheBas(grClFond,grClTexte,
               'Cliquez le troisime point sur la circonfrence');
      Detection(XS,YS);
      EffaceBas;
      if DetectPoint then
      BEGIN
        Xp3 := PointEnCours^.X;
        Yp3 := PointEnCours^.Y;
        if CCe3Pts(Xp1,Yp1,Xp2,Yp2,Xp3,Yp3,XRech,YRech,RRech)
           then CreeCercle(XRech,YRech,RRech,0,0,0,0,0,0);
      END;
    END;
  END;
END;

{}
{                      Cercle par 2 points et droite tangente               }
{}

PROCEDURE DeuxPtsDr;
BEGIN

END;

{}
{                      Cercle par 2 points et cercle tangent                }
{}

PROCEDURE DeuxPtsCe;
BEGIN

END;

{}
{                      Cercle par point et 2 droites tangentes              }
{}

PROCEDURE PtDeuxDr;
BEGIN

END;

{}
{                      Cercle par point , droite et cercle tangents         }
{}

PROCEDURE PtDrCe;
BEGIN

END;

{}
{                      Cercle par point et 2 cercles tangents               }
{}

PROCEDURE PtDeuxCe;
BEGIN

END;

{}
{                      Cercle par 3 droites tangentes                       }
{}

PROCEDURE TroisDr;
BEGIN

END;

{}
{                      Cercle par 2 droites et cercle tangents              }
{}

PROCEDURE DeuxDrCe;
BEGIN

END;

{}
{                      Cercle par 2 cercles et droite tangents              }
{}

PROCEDURE DeuxCeDr;
BEGIN

END;

{}
{                      Cercle par 3 cercles tangents                        }
{}

PROCEDURE TroisCe;
BEGIN

END;

{}

BEGIN

END.