UNIT CaoCree;

{}
{                                                                           }
{                                CaoCree                                    }
{                                                                           }
{                 - Routines de cration de gomtrie -                     }
{                                                                           }
{}

INTERFACE

USES
    Crt,
    TurboLib,
    GrafLib,
    GrafFtr,
    Math,
    CaoGlob,
    CaoDef,
    CaoGra;

PROCEDURE Points;
PROCEDURE Points_Milieu;
PROCEDURE Points_Extreme;
PROCEDURE Points_Intersection;
PROCEDURE Droites;
PROCEDURE Mediane;
PROCEDURE Bissectrice;
PROCEDURE Perpendiculaire;
PROCEDURE CercleCentre;
PROCEDURE CercleRayon;
PROCEDURE CercleRien;
PROCEDURE Tourne;
PROCEDURE Symetrie;
PROCEDURE Polaire;

{}

IMPLEMENTATION

{}
{ Gestion des points coordonnees , points + coordonnees , centre cercle .   }
{}

PROCEDURE PtsXY;

VAR
  XRech,YRech : real;

BEGIN
  CacheSouris;
  REPEAT
    Saisie(1,MaxYTxt -1,10,3,grClFond,blanc,
           ' Cote en X (+/- 99 999.999 ) : ');
  UNTIL ((abs(reel) > -100000) and (abs(reel) < 100000)) or Abandon;
  if Abandon then
  BEGIN
    MontreSouris;
    EffaceBas;
    exit;
  END;
  XRech:= reel;
  EffaceBas;
  REPEAT
    Saisie(1,MaxYTxt -1,10,3,grClFond,blanc,
           ' Cote en Y (+/- 99 999.999 ) : ');
  UNTIL ((abs(reel) > -100000) and (abs(reel) < 100000)) or Abandon;
  if Abandon then
  BEGIN
    MontreSouris;
    EffaceBas;
    exit;
  END;
  YRech:= reel;
  EffaceBas;
  MontreSouris;
  CreePoint(XRech,YRech);
END;

{}

PROCEDURE PtsDepl;

VAR
  XRech,YRech : real;
  Xtmp,YTmp : real;

BEGIN
  Xtmp := PointEnCours^.X;
  Ytmp := PointEnCours^.Y;
  CacheSouris;
  REPEAT
    Saisie(1,MaxYTxt -1,10,3,grClFond,blanc,
           ' Dcalage en X (+/- 99 999.999 ) : ');
  UNTIL ((abs(reel) > -100000) and (abs(reel) < 100000)) or Abandon;
  if Abandon then
  BEGIN
    MontreSouris;
    EffaceBas;
    exit;
  END;
  XRech:= reel;
  EffaceBas;
  REPEAT
    Saisie(1,MaxYTxt -1,10,3,grClFond,blanc,
           ' Dcalage en Y (+/- 99 999.999 ) : ');
  UNTIL ((abs(reel) > -100000) and (abs(reel) < 100000)) or Abandon;
  if Abandon then
  BEGIN
    MontreSouris;
    EffaceBas;
    exit;
  END;
  YRech:= reel;
  EffaceBas;
  MontreSouris;
  XRech:= Xtmp + XRech;
  YRech:= Ytmp + YRech;
  CreePoint(XRech,YRech);
END;

{}

PROCEDURE PtsCentre;

VAR
  XRech,YRech : real;

BEGIN
  with CercleEnCours^ do
    BEGIN
      XRech := XC;
      YRech := YC;
    END;
  CreePoint(XRech,YRech);
END;
{}

PROCEDURE Points;

VAR
  XS,YS : integer;

BEGIN
  repeat
    AfficheBas(grClFond,grClTexte,
      'Tapez des coordonnes ou cliquez un lment de rfrence ');
    Attente;
    EffaceBas;
    Test_Abandon;
    if Abandonner then exit;
    if keypressed then PtsXY
    else if BoutSouris =1 then
    BEGIN
      EnregistreSouris(XS,YS);
      if DetectPoint then PtsDepl;
      if DetectCercle then PtsCentre;
    END;
    if Abandonner then exit;
  until false;
END;

{}
{ Gestion des points milieu des segments , arcs et de 2 points .            }
{}

PROCEDURE Points_Milieu;
VAR
  XS,YS:integer;
  X1,Y1 : real;
  X2,Y2 : real;
  XRech,YRech : real;

BEGIN
  repeat
    AfficheBas(grClFond,grClTexte,'Cliquez l''lment de rfrence ');
    AttenteClic;
    EffaceBas;
    Test_Abandon;
    if Abandonner then exit;
    if BoutSouris = 1 then
    BEGIN
      EnregistreSouris(XS,YS);
      if DetectPoint then
      BEGIN
        with PointEnCours^ do
        BEGIN
          X1 := X;
          Y1 := Y;
        END;
        Fait := false;
        repeat
          AfficheBas(grClFond,grClTexte,'Cliquez le deuxime point ');
          AttenteClic;
          EffaceBas;
          Test_Abandon;
          if Abandonner then exit;
          if BoutSouris = 1 then
          BEGIN
            EnregistreSouris(XS,YS);
            EffaceBas;
            if DetectPoint then
            BEGIN
              X2 := PointEnCours^.X;
              Y2 := PointEnCours^.Y;
              if (X1 = X2) and (Y1 = Y2) then exit;
              CPtMilSeg(X1,Y1,X2,Y2,XRech,YRech);
              CreePoint(XRech,YRech);
              Fait := true;
            END;
          END;
        until Fait;
      END
      else
      if DetectSegment then
      BEGIN
        with DroiteEnCours^ do
             CPtMilSeg(XDebut,YDebut,XFin,YFin,XRech,YRech);
        CreePoint(XRech,YRech);
      END
      else
      if DetectArc then
      BEGIN
        with CercleEnCours^ do
             CPtMilArc(XC,YC,R,ADebut,AFin,XRech,YRech);
      CreePoint(XRech,YRech);
      END;
    END;
  until false;
END;

{}
{ Gestion des points extrmes des segments et des arcs .                    }
{}

PROCEDURE Points_Extreme;
VAR
  XS,YS:integer;
  XRech,YRech : real;

BEGIN
  repeat
    AfficheBas(grClFond,grClTexte,'Cliquez l''lment de rfrence ');
    AttenteClic;
    EffaceBas;
    Test_Abandon;
    if Abandonner then exit;
    if BoutSouris = 1 then
    BEGIN
      EnregistreSouris(XS,YS);
      if DetectSegment then
      BEGIN
        with DroiteEnCours^ do
        BEGIN
          PtLePlusProche(XS,YS,XDebut,YDebut,XFin,YFin,XRech,YRech);
                CreePoint(XRech,YRech);
        END;
      END
      else
      if DetectArc then
        with CercleEnCours^ do
        BEGIN
          PtLePlusProche(XS,YS,XDebut,YDebut,XFin,YFin,XRech,YRech);
                CreePoint(XRech,YRech);
        END;
    END;
  until false;
END;

{}
{ Gestion des d'intersections .                                             }
{}

PROCEDURE Points_Inter_Droite;

VAR
  XS,YS : integer;
  Xpd,Ypd,Aod : real;
  A1,B1,C1 : real;
  XRech,YRech : real;

BEGIN
  with DroiteEnCours^ do
  BEGIN
    Xpd := X;
    Ypd := Y;
    Aod := Angle;
    A1 := A;
    B1 := B;
    C1 := C;
  END;
  Fait := false;
  repeat
    AfficheBas(grClFond,grClTexte,'Cliquez le deuxime lment');
    AttenteClic;
    EffaceBas;
    Test_Abandon;
    if Abandonner then exit;
    if BoutSouris = 1 then
    BEGIN
      EnregistreSouris(XS,YS);
      if DetectDroite then
      BEGIN
        with DroiteEnCours^ do
          if CPtIntDrDr(A1,B1,C1,A,B,C,XRech,YRech)
             then CreePoint(XRech,YRech)
             else CreationImpossible;
      END
      else
      if DetectCercle then
      BEGIN
        with CercleEnCours^ do
            if CPtIntDrCe(Xpd,Ypd,Aod,Xc,Yc,R,XS,YS,XRech,YRech) then
               CreePoint(XRech,YRech)
               else CreationImpossible;
      END;
    END;
  until Fait;
END;

{}

PROCEDURE Points_Inter_Cercle;

VAR
  XS,YS : integer;
  Xc1,Yc1,Rc1 : real;
  XRech,YRech : real;

BEGIN
  with CercleEnCours^ do
  BEGIN
    Xc1 := Xc;
    Yc1 := Yc;
    Rc1 := R;
  END;
  Fait := false;
  repeat
    AfficheBas(grClFond,grClTexte,'Cliquez le deuxime lment');
    AttenteClic;
    EffaceBas;
    Test_Abandon;
    if Abandonner then exit;
    if BoutSouris = 1 then
    BEGIN
      EnregistreSouris(XS,YS);
      if DetectDroite then
      BEGIN
       with DroiteEnCours^ do
           if CPtIntDrCe(X,Y,Angle,Xc1,Yc1,Rc1,XS,YS,XRech,YRech) then
              CreePoint(XRech,YRech)
              else CreationImpossible;
      END
      else
      if DetectCercle then
      BEGIN
        with CercleEnCours^ do
           if CPtIntCeCe(Xc1,Yc1,Rc1,Xc,Yc,R,XS,YS,XRech,YRech) then
              CreePoint(XRech,YRech)
              else CreationImpossible;
      END;
    END;
  until Fait;
END;

{}

PROCEDURE Points_Intersection;

VAR
  XS,YS:integer;
  XRech,YRech : real;

BEGIN
  repeat
    AfficheBas(grClFond,grClTexte,'Cliquez le premier lment');
    AttenteClic;
    EffaceBas;
    Test_Abandon;
    if Abandonner then exit;
    if BoutSouris = 1 then
    BEGIN
      EnregistreSouris(XS,YS);
      if DetectDroite then Points_Inter_Droite
      else
      if DetectCercle then Points_Inter_Cercle;
    END;
    if Abandonner then exit;
  until false;
END;

{}
{ Gestion des droites coordonnes et angle , coordonnes et parallle ,     }
{ point et angle , point et parallle , point et cercle tangent , 2 points ,}
{ droite et cart , droite et cercle tangent , droite et point , cercle et  }
{ angle , cercle et droite parallle , cercle et cercle .                   }
{}

PROCEDURE Droites_XY;

VAR
  XS,YS : integer;
  XRech,YRech,ARech : real;

BEGIN
  CacheSouris;
  REPEAT
    Saisie(1,MaxYTxt -1,10,3,grClFond,blanc,
           ' Cote en X (+/- 99 999.999 ) : ');
  UNTIL ((abs(reel) > -100000) and (abs(reel) < 100000)) or Abandon;
  if Abandon then
  BEGIN
    MontreSouris;
    EffaceBas;
    exit;
  END;
  XRech := reel;
  EffaceBas;
  REPEAT
    Saisie(1,MaxYTxt -1,10,3,grClFond,blanc,
           ' Cote en Y (+/- 99 999.999 ) : ');
  UNTIL ((abs(reel) > -100000) and (abs(reel) < 100000)) or Abandon;
  if Abandon then
  BEGIN
    MontreSouris;
    EffaceBas;
    exit;
  END;
  YRech := reel;
  EffaceBas;
  MontreSouris;
  Fait := false;
  repeat
    AfficheBas(grClFond,grClTexte,'Tapez l''angle ou cliquez une parallle ');
    Attente;
    EffaceBas;
    Test_Abandon;
    if Abandonner then exit;
    if keypressed then
    BEGIN
      CacheSouris;
      REPEAT
        Saisie(1,MaxYTxt -1,8,3,grClFond,blanc,' Angle (+/- 359.999 degrs) : ');
      UNTIL ((abs(reel) > -360) and (abs(reel) < 360)) or Abandon;
      if Abandon then
      BEGIN
        MontreSouris;
        EffaceBas;
        exit;
      END;
      ARech := DegToRad(reel);
      ARech := MiseEnFormeAngleDr(ARech);
      EffaceBas;
      MontreSouris;
      CreeDroite(XRech,YRech,ARech,0,0,0,0);
    END
    else if BoutSouris = 1 then
    BEGIN
      EnregistreSouris(XS,YS);
      if DetectDroite then
         with DroiteEnCours^ do
              CreeDroite(XRech,YRech,Angle,0,0,0,0);
    END;
  until Fait;
END;

{}

PROCEDURE Droites_Point_Angle(Xp,Yp : real);

VAR
  XRech,YRech,ARech : real;
BEGIN
  CacheSouris;
  REPEAT
    Saisie(1,MaxYTxt -1,8,3,grClFond,blanc,' Angle (+/- 359.999 degrs) : ');
  UNTIL ((abs(reel) > -360) and (abs(reel) < 360)) or Abandon;
  if Abandon then
  BEGIN
    MontreSouris;
    EffaceBas;
    exit;
  END;
  ARech := DegToRad(reel);
  ARech := MiseEnFormeAngleDr(ARech);
  EffaceBas;
  MontreSouris;
  XRech := Xp;
  YRech := Yp;
  CreeDroite(XRech,YRech,ARech,0,0,0,0);
END;

{}

PROCEDURE Droites_Point_Point(Xp,Yp : real);

VAR
  XpTmp,YpTmp : real;
  XRech,YRech,ARech : real;

BEGIN
  XpTmp := PointEnCours^.X;
  YpTmp := PointEnCours^.Y;
  if (Xp = XpTmp) and (Yp = YpTmp) then exit;
  CDrDeuxPts(Xp,Yp,XpTmp,YpTmp,XRech,YRech,ARech);
  CreeDroite(XRech,YRech,ARech,0,0,0,0);
END;

{}

PROCEDURE Droites_Point_Droite(Xp,Yp : real);

VAR
  XRech,YRech,ARech : real;

BEGIN
  XRech := Xp;
  YRech := Yp;
  ARech := DroiteEnCours^.Angle;
  CreeDroite(XRech,YRech,ARech,0,0,0,0);
END;

{}

PROCEDURE Droites_Point_Cercle(Xp,Yp : real;XS,YS : integer);

VAR
  XPoint,YPoint : real;
  XCentre,YCentre,Rayon : real;
  ARef,A1Rech,A2Rech : real;
  XRech,YRech,ARech : real;

BEGIN
  XCentre := CercleEnCours^.Xc;
  YCentre := CercleEnCours^.Yc;
  Rayon := CercleEnCours^.R;
  if CDrPtCe(Xp,Yp,XCentre,YCentre,Rayon,XRech,YRech,A1Rech,A2Rech) then
  BEGIN
    XPoint := (XS - XOrigine) / Echelle;
    YPoint := -(YS - YOrigine) / Echelle;
    Aref := CalculAngleSegment(Xp,Yp,XPoint,YPoint);
    Aref := MiseEnFormeAngleDr(Aref);
    ARech := ALePlusProche(Aref,A1Rech,A2Rech);
    CreeDroite(XRech,YRech,ARech,0,0,0,0);
  END
  else CreationImpossible;
END;

{}

PROCEDURE Droites_Point;

VAR
  XS,YS : integer;
  Xp1,Yp1 : real;
  XRech,YRech,ARech : real;

BEGIN
  Xp1 := PointEnCours^.X;
  Yp1 := PointEnCours^.Y;
  EffaceBas;
  Fait := false;
  repeat
    AfficheBas(grClFond,grClTexte,
               'Entrez l''angle ou cliquez un lment de rfrence ');
    Attente;
    EffaceBas;
    Test_Abandon;
    if Abandonner then exit;
    if keypressed then Droites_Point_Angle(Xp1,Yp1)
    else  if BoutSouris = 1 then
    BEGIN
      EnregistreSouris(XS,YS);
      if DetectPoint then Droites_Point_Point(Xp1,Yp1)
        else
        if DetectDroite then Droites_Point_Droite(Xp1,Yp1)
        else
        if DetectCercle then Droites_Point_Cercle(Xp1,Yp1,XS,YS);
    END;
    if Abandonner then exit;
  until Fait;
END;

{}

PROCEDURE Droites_Droite_Ecart(X,Y,Angle : real);

VAR
  Etmp : real;
  XS,YS : integer;
  XRech,YRech,ARech : real;

BEGIN
  CacheSouris;
  REPEAT
    Saisie(1,MaxYTxt -1,10,3,grClFond,blanc,
           ' Ecart (0.001 - 99 999.999 ) : ');
  UNTIL ((reel > 0) and (reel < 100000)) or Abandon;
  if Abandon then
  BEGIN
    MontreSouris;
    EffaceBas;
    exit;
  END;
  Etmp := reel;
  EffaceBas;
  MontreSouris;
  AfficheBas(grClFond,grClTexte,'Position ? ');
  AttenteClic;
  EffaceBas;
  Test_Abandon;
  if Abandonner then exit;
  if BoutSouris = 1 then
  BEGIN
    EnregistreSouris(XS,YS);
    CDrParalDist(X,Y,Angle,Etmp,XS,YS,XRech,YRech,ARech);
    CreeDroite(XRech,YRech,ARech,0,0,0,0);
  END;
END;

{}

PROCEDURE Droites_Droite_Point(Angle : real);

VAR
  XRech,YRech,ARech : real;

BEGIN
  XRech := PointEnCours^.X;
  YRech := PointEnCours^.Y;
  ARech := Angle;
  CreeDroite(XRech,YRech,ARech,0,0,0,0);
END;

{}

PROCEDURE Droites_Droite_Cercle(Angle : real;XS,YS : integer);

VAR
  XCercle,YCercle,RCercle : real;
  XRech,YRech,ARech : real;

BEGIN
  XCercle := CercleEnCours^.Xc;
  YCercle := CercleEnCours^.Yc;
  RCercle := CercleEnCours^.R;
  CDrCeAngle(XCercle,YCercle,RCercle,Angle,XS,YS,XRech,YRech,ARech);
  CreeDroite(XRech,YRech,ARech,0,0,0,0);
END;

{}

PROCEDURE Droites_Droite;

VAR
  XS,YS : integer;
  XDroite,YDroite,ADroite : real;

BEGIN
  XDroite := DroiteEnCours^.X;
  YDroite := DroiteEnCours^.Y;
  ADroite := DroiteEnCours^.Angle;
  EffaceBas;
  Fait := false;
  repeat
    AfficheBas(grClFond,grClTexte,
               'Entrez l''cart ou cliquez un lment de rfrence ');
    Attente;
    EffaceBas;
    Test_Abandon;
    if Abandonner then exit;
    if keypressed then Droites_Droite_Ecart(XDroite,YDroite,ADroite)
    else if BoutSouris = 1 then
    BEGIN
      EnregistreSouris(XS,YS);
      if DetectPoint then Droites_Droite_Point(ADroite)
      else
      if DetectCercle then Droites_Droite_Cercle(ADroite,XS,YS);
    END;
    if Abandonner then exit;
  until Fait;
END;

{}

PROCEDURE Droites_Cercle_Angle(Xc,Yc,Rc : real;XS,YS : integer);

VAR
  Angle : real;
  XRech,YRech,ARech : real;

BEGIN
  CacheSouris;
  REPEAT
    Saisie(1,MaxYTxt -1,8,3,grClFond,blanc,' Angle (+/- 359.999 degrs) : ');
  UNTIL ((abs(reel) > -360) and (abs(reel) < 360)) or Abandon;
  if Abandon then
  BEGIN
    MontreSouris;
    EffaceBas;
    exit;
  END;
  EffaceBas;
  MontreSouris;
  Angle := DegToRad(reel);
  ARech := MiseEnFormeAngleDr(ARech);
  CDrCeAngle(Xc,Yc,Rc,Angle,XS,YS,XRech,YRech,ARech);
  CreeDroite(XRech,YRech,ARech,0,0,0,0);
END;

{}

PROCEDURE Droites_Cercle_Point(Xc,Yc,Rc : real;XS,YS : integer);

VAR
  Xp,Yp : real;
  XPoint,YPoint : real;
  Aref,A1Rech,A2Rech : real;
  XRech,YRech,ARech : real;

BEGIN
  Xp := PointEnCours^.X;
  Yp := PointEnCours^.Y;
  if CDrPtCe(Xp,Yp,Xc,Yc,Rc,XRech,YRech,A1Rech,A2Rech) then
  BEGIN
    XPoint := (XS - XOrigine) / Echelle;
    YPoint := -(YS - YOrigine) / Echelle;
    Aref := CalculAngleSegment(Xp,Yp,XPoint,YPoint);
    Aref := MiseEnFormeAngleDr(Aref);
    ARech := ALePlusProche(Aref,A1Rech,A2Rech);
    CreeDroite(XRech,YRech,ARech,0,0,0,0);
  END
  else CreationImpossible;
END;

{}

PROCEDURE Droites_Cercle_Droite(Xc,Yc,Rc : real;XS,YS : integer);

VAR
  Aref : real;
  XRech,YRech,ARech : real;

BEGIN
  Aref := DroiteEnCours^.Angle;
  CDrCeAngle(Xc,Yc,Rc,Aref,XS,YS,XRech,YRech,ARech);
  CreeDroite(XRech,YRech,ARech,0,0,0,0);
END;

{}

PROCEDURE Droites_Cercle_Cercle(Xc1,Yc1,Rc1 : real;XS1,YS1,XS2,YS2 : integer);

VAR
  Xc2,Yc2,Rc2 : real;
  XRech,YRech,ARech : real;
  XDRech,YDRech,XFRech,YFRech : real;

BEGIN
   Xc2 := CercleEnCours^.Xc;
   Yc2 := CercleEnCours^.Yc;
   Rc2 := CercleEnCours^.R;
   if CDrCeCe(Xc1,Yc1,Rc1,Xc2,Yc2,Rc2,XS1,YS1,XS2,YS2,
              XRech,YRech,ARech,XDRech,YDRech,XFRech,YFRech) then
        CreeDroite(XRech,YRech,ARech,0,0,0,0)
      else CreationImpossible;
END;

{}

PROCEDURE Droites_Cercle(XS1,YS1 : integer);

VAR
  XCercle,YCercle,RCercle : real;
  XS2,YS2 : integer;

BEGIN
  XCercle := CercleEnCours^.Xc;
  YCercle := CercleEnCours^.Yc;
  RCercle := CercleEnCours^.R;
  EffaceBas;
  Fait := false;
  repeat
    AfficheBas(grClFond,grClTexte,
               'Entrez l''angle ou cliquez un lment de rfrence ');
    Attente;
    EffaceBas;
    Test_Abandon;
    if Abandonner then exit;
    if keypressed then Droites_Cercle_Angle(XCercle,YCercle,RCercle,XS1,YS1)
    else if BoutSouris = 1 then
    BEGIN
      EnregistreSouris(XS2,YS2);
      if DetectPoint then
         Droites_Cercle_Point(XCercle,YCercle,RCercle,XS1,YS1)
      else
      if DetectDroite then
         Droites_Cercle_Droite(XCercle,YCercle,RCercle,XS1,YS1)
      else
      if DetectCercle then
         Droites_Cercle_Cercle(XCercle,YCercle,RCercle,XS1,YS1,XS2,YS2);
    END;
    if Abandonner then exit;
  until Fait;
END;

{}

PROCEDURE Droites;

VAR
  XS,YS : integer;

BEGIN
  repeat
    AfficheBas(grClFond,grClTexte,
      'Tapez des coordonnes ou cliquez un lment de rfrence ');
    Attente;
    EffaceBas;
    Test_Abandon;
    if Abandonner then exit;
    if keypressed then Droites_XY
    else if BoutSouris = 1 then
    BEGIN
      EnregistreSouris(XS,YS);
      if DetectPoint then Droites_Point
      else
      if DetectDroite then Droites_Droite
      else
      if DetectCercle then Droites_Cercle(XS,YS);
    END;
    if Abandonner then exit;
  until false;
END;

{}
{ Gestion des mdiatrices                                                   }
{}

PROCEDURE Mediane;

VAR
  XS,YS : integer;
  A1,B1,C1,Aod1 : real;
  A2,B2,C2,Aod2 : real;
  XRech,YRech,ARech : real;

BEGIN
  repeat
    AfficheBas(grClFond,grClTexte,'Cliquez la premire droite');
    AttenteClic;
    EffaceBas;
    Test_Abandon;
    if Abandonner then exit;
    if BoutSouris = 1 then
    BEGIN
      EnregistreSouris(XS,YS);
      if DetectDroite then
      BEGIN
        A1 := DroiteEnCours^.A;
        B1 := DroiteEnCours^.B;
        C1 := DroiteEnCours^.C;
        Aod1 := DroiteEnCours^.Angle;
        Fait := false;
        repeat
          AfficheBas(grClFond,grClTexte,'Cliquez la deuxime droite');
          AttenteClic;
          EffaceBas;
          Test_Abandon;
          if Abandonner then exit;
          if BoutSouris = 1 then
          BEGIN
            EnregistreSouris(XS,YS);
            if DetectDroite then
            BEGIN
              A2 := DroiteEnCours^.A;
              B2 := DroiteEnCours^.B;
              C2 := DroiteEnCours^.C;
              Aod2 := DroiteEnCours^.Angle;
              if CMediatrice(A1,B1,C1,Aod1,A2,B2,C2,Aod2,XRech,YRech,ARech)
                 then CreeDroite(XRech,YRech,ARech,0,0,0,0)
                 else CreationImpossible;
            END;
          END;
        until Fait;
      END;
    END;
    if Abandonner then exit;
  until false;
END;

{}
{ Gestion des bissectrices                                                  }
{}

PROCEDURE Bissectrice;

VAR
  XS,YS : integer;
  A1,B1,C1,Aod1 : real;
  A2,B2,C2,Aod2 : real;
  XRech,YRech,ARech : real;

BEGIN
  repeat
    AfficheBas(grClFond,grClTexte,'Cliquez la premire droite');
    AttenteClic;
    EffaceBas;
    Test_Abandon;
    if Abandonner then exit;
    if BoutSouris = 1 then
    BEGIN
      EnregistreSouris(XS,YS);
      if DetectDroite then
      BEGIN
        A1 := DroiteEnCours^.A;
        B1 := DroiteEnCours^.B;
        C1 := DroiteEnCours^.C;
        Aod1 := DroiteEnCours^.Angle;
        Fait := false;
        repeat
          AfficheBas(grClFond,grClTexte,'Cliquez la deuxime droite');
          AttenteClic;
          EffaceBas;
          Test_Abandon;
          if Abandonner then exit;
          if BoutSouris = 1 then
          BEGIN
            EnregistreSouris(XS,YS);
            if DetectDroite then
            BEGIN
              A2 := DroiteEnCours^.A;
              B2 := DroiteEnCours^.B;
              C2 := DroiteEnCours^.C;
              Aod2 := DroiteEnCours^.Angle;
              if CBissectrice(A1,B1,C1,Aod1,A2,B2,C2,Aod2,XRech,YRech,ARech)
                 then CreeDroite(XRech,YRech,ARech,0,0,0,0)
                 else CreationImpossible;
            END;
          END;
        until Fait;
      END;
    END;
    if Abandonner then exit;
  until false;
END;

{}
{ Gestion des droites perpendiculaires                                      }
{}

PROCEDURE Perpendiculaire_Point;

VAR
  Xp,Yp,Ad : real;
  XS,YS : integer;
  XRech,YRech,ARech : real;


BEGIN
  Xp := PointEnCours^.X;
  Yp := PointEnCours^.Y;
  Fait := false;
  repeat
    AfficheBas(grClFond,grClTexte,'Cliquez la droite de rfrence ');
    AttenteClic;
    EffaceBas;
    Test_Abandon;
    if Abandonner then exit;
    if BoutSouris = 1 then
    BEGIN
      EnregistreSouris(XS,YS);
      if DetectDroite then
      BEGIN
        Ad := DroiteEnCours^.Angle;
        CDrPtsPerpDr(Xp,Yp,Ad,XRech,YRech,ARech);
        CreeDroite(XRech,YRech,ARech,0,0,0,0);
      END;
    END;
  until Fait;
END;

{}

PROCEDURE Perpendiculaire_Droite;

VAR
  Xp,Yp,Ad : real;
  Xc1,Yc1,Rc1 : real;
  XS,YS : integer;
  X1Rech,Y1Rech,X2Rech,Y2Rech : real;
  XRech,YRech,ARech : real;


BEGIN
  Ad := DroiteEnCours^.Angle;
  Fait := false;
  repeat
    AfficheBas(grClFond,grClTexte,'Cliquez le deuxime lment');
    AttenteClic;
    EffaceBas;
    Test_Abandon;
    if Abandonner then exit;
    if BoutSouris = 1 then
    BEGIN
      EnregistreSouris(XS,YS);
      if DetectPoint then
      BEGIN
        Xp := PointEnCours^.X;
        Yp := PointEnCours^.Y;
        CDrPtsPerpDr(Xp,Yp,Ad,XRech,YRech,ARech);
        CreeDroite(XRech,YRech,ARech,0,0,0,0);
      END
      else
      if DetectCercle then
      BEGIN
        Xc1 := CercleEnCours^.Xc;
        Yc1 := CercleEnCours^.Yc;
        Rc1 := CercleEnCours^.R;
        CDrCePerpDr(Xc1,Yc1,Rc1,Ad,X1Rech,Y1Rech,X2Rech,Y2Rech,ARech);
        PtLePlusProche(XS,YS,X1Rech,Y1Rech,X2Rech,Y2Rech,XRech,YRech);
        CreeDroite(XRech,YRech,ARech,0,0,0,0);
      END;
    END;
  until Fait
END;

{}

PROCEDURE Perpendiculaire_Cercle;

VAR
  Ad : real;
  Xc1,Yc1,Rc1 : real;
  XS,YS : integer;
  X1Rech,Y1Rech,X2Rech,Y2Rech : real;
  XRech,YRech,ARech : real;

BEGIN
  Xc1 := CercleEnCours^.Xc;
  Yc1 := CercleEnCours^.Yc;
  Rc1 := CercleEnCours^.R;
  Fait := false;
  repeat
    AfficheBas(grClFond,grClTexte,'Cliquez la droite de rfrence ');
    AttenteClic;
    EffaceBas;
    Test_Abandon;
    if Abandonner then exit;
    if BoutSouris = 1 then
    BEGIN
      EnregistreSouris(XS,YS);
      if DetectDroite then
      BEGIN
        Ad := DroiteEnCours^.Angle;
        CDrCePerpDr(Xc1,Yc1,Rc1,Ad,X1Rech,Y1Rech,X2Rech,Y2Rech,ARech);
        PtLePlusProche(XS,YS,X1Rech,Y1Rech,X2Rech,Y2Rech,XRech,YRech);
        CreeDroite(XRech,YRech,ARech,0,0,0,0);
      END;
    END;
  until Fait;
END;

{}

PROCEDURE Perpendiculaire;

VAR
  XS,YS : integer;

BEGIN
  repeat
    AfficheBas(grClFond,grClTexte,
      'Cliquez un lment de rfrence ');
    AttenteClic;
    EffaceBas;
    Test_Abandon;
    if Abandonner then exit;
    if BoutSouris = 1 then
    BEGIN
      EnregistreSouris(XS,YS);
      if DetectPoint then Perpendiculaire_Point
      else
      if DetectDroite then Perpendiculaire_Droite
      else
      if DetectCercle then Perpendiculaire_Cercle;
    END;
    if Abandonner then exit;
  until false;
END;

{}
{ Gestion des cercles de centre connu . Coordonnes cartsiennes et rayon , }
{ centre et rayon , centre et point sur la circonfrence , centre et droite }
{ tangente , centre et cercle tangent , cercle et rayon , cercle et diff   }
{ rence de rayon .                                                          }
{}

PROCEDURE CercleCentre_XY;

VAR
  XRech,YRech,RRech : real;

BEGIN
  CacheSouris;
  REPEAT
    Saisie(1,MaxYTxt -1,10,3,grClFond,blanc,
           ' Cote en X (+/- 99 999.999 ) : ');
  UNTIL ((abs(reel) > -100000) and (abs(reel) < 100000)) or Abandon;
  if Abandon then
  BEGIN
    MontreSouris;
    EffaceBas;
    exit;
  END;
  XRech := reel;
  EffaceBas;
  REPEAT
    Saisie(1,MaxYTxt -1,10,3,grClFond,blanc,
           ' Cote en Y (+/- 99 999.999 ) : ');
  UNTIL ((abs(reel) > -100000) and (abs(reel) < 100000)) or Abandon;
  if Abandon then
  BEGIN
    MontreSouris;
    EffaceBas;
    exit;
  END;
  YRech := reel;
  EffaceBas;
  REPEAT
    Saisie(1,MaxYTxt -1,10,3,grClFond,blanc,
           ' Rayon du cercle (0.001 - 99 999.999) : ');
  UNTIL ((abs(reel) > 0) and (abs(reel) < 100000)) or Abandon;
  if Abandon then
  BEGIN
    MontreSouris;
    EffaceBas;
    exit;
  END;
  RRech := reel;
  EffaceBas;
  MontreSouris;
  CreeCercle(XRech,YRech,RRech,0,0,0,0,0,0);
END;

{}

PROCEDURE CercleCentre_Point_Rayon(Xc,Yc : real);

VAR
  XRech,YRech,RRech : real;

BEGIN
  CacheSouris;
  REPEAT
    Saisie(1,MaxYTxt -1,8,3,grClFond,blanc,' Rayon (0.001 - 99 999.999) : ');
  UNTIL ((abs(reel) > 0) and (abs(reel) < 100000)) or Abandon;
  if Abandon then
  BEGIN
    MontreSouris;
    EffaceBas;
    exit;
  END;
  RRech := reel;
  EffaceBas;
  MontreSouris;
  XRech := Xc;
  YRech := Yc;
  CreeCercle(XRech,YRech,RRech,0,0,0,0,0,0);
END;

{}

PROCEDURE CercleCentre_Point_Point(Xc,Yc : real);

VAR
  Xp,Yp : real;
  XRech,YRech,RRech : real;

BEGIN
  Xp := PointEnCours^.X;
  Yp := PointEnCours^.Y;
  if CCePcPts(Xc,Yc,Xp,Yp,XRech,YRech,RRech) then
     CreeCercle(XRech,YRech,RRech,0,0,0,0,0,0)
     else CreationImpossible;
END;

{}

PROCEDURE CercleCentre_Point_Droite(Xc,Yc : real);

VAR
  Xd,Yd,Aod,Ad,Bd,Cd : real;
  XRech,YRech,RRech : real;

BEGIN
  Xd := DroiteEnCours^.X;
  Yd := DroiteEnCours^.Y;
  Aod := DroiteEnCours^.Angle;
  Ad := DroiteEnCours^.A;
  Bd := DroiteEnCours^.B;
  Cd := DroiteEnCours^.C;
  if CCePcDr(Xc,Yc,Xd,Yd,Aod,Ad,Bd,Cd,XRech,YRech,RRech) then
     CreeCercle(XRech,YRech,RRech,0,0,0,0,0,0)
     else CreationImpossible;

END;

{}

PROCEDURE CercleCentre_Point_Cercle(Xc,Yc : real;XS,YS : integer);

VAR
  XCentre,YCentre,Rayon : real;
  XRech,YRech,RRech : real;

BEGIN
  XCentre := CercleEnCours^.Xc;
  YCentre := CercleEnCours^.Yc;
  Rayon := CercleEnCours^.R;
  if CCePcCe(Xc,Yc,XCentre,YCentre,Rayon,XS,YS,XRech,YRech,RRech) then
     CreeCercle(XRech,YRech,RRech,0,0,0,0,0,0)
     else CreationImpossible;
END;

{}

PROCEDURE CercleCentre_Point;

VAR
  Xp,Yp : real;
  XS,YS : integer;

BEGIN
  Xp := PointEnCours^.X;
  Yp := PointEnCours^.Y;
  EffaceBas;
  Fait := false;
  repeat
    AfficheBas(grClFond,grClTexte,
             'Entrez le rayon ou cliquez un lment de rfrence');
    Attente;
    EffaceBas;
    Test_Abandon;
    if Abandonner then exit;
    if keypressed then CercleCentre_Point_Rayon(Xp,Yp)
    else if BoutSouris = 1 then
    BEGIN
      EnregistreSouris(XS,YS);
      if DetectPoint then
         CercleCentre_Point_Point(Xp,Yp)
      else
      if DetectDroite then
         CercleCentre_Point_Droite(Xp,Yp)
      else
      if DetectCercle then
         CercleCentre_Point_Cercle(Xp,Yp,XS,YS);
    END;
    if Abandonner then exit;
  until Fait;
END;

{}

PROCEDURE CercleCentre_Cercle_Rayon(XCentre,YCentre : real);

VAR
  XRech,YRech,RRech : real;

BEGIN
  CacheSouris;
  REPEAT
    Saisie(1,MaxYTxt -1,9,3,grClFond,blanc,
           ' Rayon (0.001 - 99 999.999 ) : ');
  UNTIL ((reel > 0) and (reel < 100000)) or Abandon;
  if Abandon then
  BEGIN
    MontreSouris;
    EffaceBas;
    exit;
  END;
  RRech := reel;
  EffaceBas;
  MontreSouris;
  CreeCercle(XCentre,YCentre,RRech,0,0,0,0,0,0);
END;

{}

PROCEDURE CercleCentre_Cercle_Ecart(XCentre,YCentre,Rayon : real);

VAR
  XRech,YRech,RRech : real;

BEGIN
  CacheSouris;
  REPEAT
    Saisie(1,MaxYTxt -1,10,3,grClFond,blanc,
           ' Diffrence de rayon (+/- 99 999.999 ) : ');
  UNTIL ((reel > -100000) and (reel < 100000)) or Abandon;
  if Abandon then
  BEGIN
    MontreSouris;
    EffaceBas;
    exit;
  END;
  RRech := abs(Rayon + reel);
  EffaceBas;
  MontreSouris;
  CreeCercle(XCentre,YCentre,RRech,0,0,0,0,0,0);
END;

{}

PROCEDURE CercleCentre_Cercle;

VAR
  XCentre,YCentre,Rayon : real;

BEGIN
  XCentre := CercleEnCours^.Xc;
  YCentre := CercleEnCours^.Yc;
  Rayon := CercleEnCours^.R;
  ChangeCurseur(ptrFleche);
  FormeSouris := 'FLECHE';
  if dialogueBout('Choisissez :',' Rayon ',' Ecart ')
     then CercleCentre_Cercle_Rayon(XCentre,YCentre)
     else CercleCentre_Cercle_Ecart(XCentre,YCentre,Rayon);
  ChangeCurseur(ptrCroix);
  FormeSouris := 'CROIX';
END;

{}

PROCEDURE CercleCentre;

VAR
  XS,YS : integer;

BEGIN
  repeat
    AfficheBas(grClFond,grClTexte,
      'Tapez des coordonnes ou cliquez un lment de rfrence ');
    Attente;
    EffaceBas;
    Test_Abandon;
    if Abandonner then exit;
    if keypressed then CercleCentre_XY
    else if BoutSouris = 1 then
    BEGIN
      EnregistreSouris(XS,YS);
      if DetectPoint then CercleCentre_Point
      else
      if DetectCercle then CercleCentre_Cercle;
    END;
    if Abandonner then exit;
  until false;
END;

{}
{ Gestion des cercles de rayon connu . 2 points sur la circonfrence , point}
{ sur la circonfrence et droite tangente , point sur la circonfrence et   }
{ cercle tangent , 2 droites tangentes , droite tangente et cercle tangent ,}
{ 2 cercles tangents .                                                      }
{}

PROCEDURE CercleRayon_Point_Point(Xp1,Yp1 : real);

VAR
  XS,YS : integer;
  Xp2,Yp2 : real;
  XRech,YRech,RRech : real;
  D : real;

BEGIN
  Xp2 := PointEnCours^.X;
  Yp2 := PointEnCours^.Y;
  CacheSouris;
  REPEAT
    Saisie(1,MaxYTxt -1,9,3,grClFond,blanc,
           ' Rayon (0.001 - 99 999.999 ) : ');
  UNTIL ((reel > 0) and (reel < 100000)) or Abandon;
  if Abandon then
  BEGIN
    Abandonner := true;
    MontreSouris;
    EffaceBas;
    exit;
  END;
  RRech := reel;
  EffaceBas;
  MontreSouris;
  D := CalculDistDeuxPts(Xp1,Yp1,Xp2,Yp2);
  if D > (2*RRech) then
  BEGIN
    CreationImpossible;
    exit;
  END;
  AfficheBas(grClFond,grClTexte,'Position ?');
  AttenteClic;
  EffaceBas;
  Test_Abandon;
  if Abandonner then exit;
  if BoutSouris = 1 then
  BEGIN
    EnregistreSouris(XS,YS);
    if CCe2Pts(Xp1,Yp1,Xp2,Yp2,RRech,XS,YS,XRech,YRech,RRech)
       then CreeCercle(XRech,YRech,RRech,0,0,0,0,0,0)
       else CreationImpossible;
  END;
END;

{}

PROCEDURE CercleRayon_Point_Droite(Xp,Yp : real;XS1,YS1,XS2,YS2 : integer);

VAR
  XS,YS : integer;
  Xd,Yd,Aod,Ad,Bd,Cd : real;
  XRech,YRech,RRech : real;

BEGIN
  Xd := DroiteEnCours^.X;
  Yd := DroiteEnCours^.Y;
  Aod := DroiteEnCours^.Angle;
  Ad := DroiteEnCours^.A;
  Bd := DroiteEnCours^.B;
  Cd := DroiteEnCours^.C;
  CacheSouris;
  REPEAT
    Saisie(1,MaxYTxt -1,9,3,grClFond,blanc,
           ' Rayon (0.001 - 99 999.999 ) : ');
  UNTIL ((reel > 0) and (reel < 100000)) or Abandon;
  if Abandon then
  BEGIN
    Abandonner := true;
    MontreSouris;
    EffaceBas;
    exit;
  END;
  RRech := reel;
  EffaceBas;
  MontreSouris;
  AfficheBas(grClFond,grClTexte,'Position ?');
  AttenteClic;
  EffaceBas;
  Test_Abandon;
  if Abandonner then exit;
  if BoutSouris = 1 then
  BEGIN
    EnregistreSouris(XS,YS);
    if CCePtsDr(Xp,Yp,Xd,Yd,Aod,Ad,Bd,Cd,RRech,XS1,YS1,XS,YS,XRech,YRech,RRech)
       then CreeCercle(XRech,YRech,RRech,0,0,0,0,0,0)
       else CreationImpossible;
  END;
END;

{}

PROCEDURE CercleRayon_Point_Cercle(Xp,Yp : real;XS1,YS1 : integer);

VAR
  XS,YS : integer;
  XCentre,YCentre,Rayon : real;
  XRech,YRech,RRech : real;

BEGIN
  XCentre := CercleEnCours^.Xc;
  YCentre := CercleEnCours^.Yc;
  Rayon := CercleEnCours^.R;
  CacheSouris;
  REPEAT
    Saisie(1,MaxYTxt -1,9,3,grClFond,blanc,
           ' Rayon (0.001 - 99 999.999 ) : ');
  UNTIL ((reel > 0) and (reel < 100000)) or Abandon;
  if Abandon then
  BEGIN
    Abandonner := true;
    MontreSouris;
    EffaceBas;
    exit;
  END;
  RRech := reel;
  EffaceBas;
  MontreSouris;
  AfficheBas(grClFond,grClTexte,'Position ?');
  AttenteClic;
  EffaceBas;
  Test_Abandon;
  if Abandonner then exit;
  if BoutSouris = 1 then
  BEGIN
    EnregistreSouris(XS,YS);
    if CCePtsCe(Xp,Yp,XCentre,YCentre,Rayon,RRech,XS,YS,XS1,YS1,XRech,YRech,RRech)
       then CreeCercle(XRech,YRech,RRech,0,0,0,0,0,0)
       else CreationImpossible;
  END;
END;

{}

PROCEDURE CercleRayon_Point(XS1,YS1 : integer);

VAR
  Xp,Yp : real;
  XS2,YS2 : integer;

BEGIN
  Xp := PointEnCours^.X;
  Yp := PointEnCours^.Y;
  Fait := false;
  repeat
    AfficheBas(grClFond,grClTexte,
      'Cliquez le deuxime lment de rfrence ');
    AttenteClic;
    EffaceBas;
    Test_Abandon;
    if Abandonner then exit;
    if BoutSouris = 1 then
    BEGIN
      EnregistreSouris(XS2,YS2);
      if DetectPoint then CercleRayon_Point_Point(Xp,Yp)
      else
      if DetectDroite then CercleRayon_Point_Droite(Xp,Yp,XS1,YS1,XS2,YS2)
      else
      if DetectCercle then CercleRayon_Point_Cercle(Xp,Yp,XS2,YS2);
    END;
    if Abandonner then exit;
  until Fait;
END;

{}

PROCEDURE CercleRayon_Droite_Point(Xd,Yd,Aod,Ad,Bd,Cd : real;
                                   XS1,YS1 : integer);

VAR
  XS,YS : integer;
  Xp,Yp : real;
  XRech,YRech,RRech : real;

BEGIN
  Xp := PointEnCours^.X;
  Yp := PointEnCours^.Y;
  CacheSouris;
  REPEAT
    Saisie(1,MaxYTxt -1,9,3,grClFond,blanc,
           ' Rayon (0.001 - 99 999.999 ) : ');
  UNTIL ((reel > 0) and (reel < 100000)) or Abandon;
  if Abandon then
  BEGIN
    Abandonner := true;
    MontreSouris;
    EffaceBas;
    exit;
  END;
  RRech := reel;
  EffaceBas;
  MontreSouris;
  AfficheBas(grClFond,grClTexte,'Position ?');
  AttenteClic;
  EffaceBas;
  Test_Abandon;
  if Abandonner then exit;
  if BoutSouris = 1 then
  BEGIN
    EnregistreSouris(XS,YS);
    if CCePtsDr(Xp,Yp,Xd,Yd,Aod,Ad,Bd,Cd,RRech,XS1,YS1,XS,YS,XRech,YRech,RRech)
       then CreeCercle(XRech,YRech,RRech,0,0,0,0,0,0)
       else CreationImpossible;
  END;
END;

{}

PROCEDURE CercleRayon_Droite_Droite(Xd1,Yd1,Aod1 : real;
                                    XS1,YS1,XS2,YS2 : integer);

VAR
  Xd2,Yd2,Aod2 : real;
  XRech,YRech,RRech : real;

BEGIN
  Xd2 := DroiteEnCours^.X;
  Yd2 := DroiteEnCours^.Y;
  Aod2 := DroiteEnCours^.Angle;
  CacheSouris;
  REPEAT
    Saisie(1,MaxYTxt -1,9,3,grClFond,blanc,
           ' Rayon (0.001 - 99 999.999 ) : ');
  UNTIL ((reel > 0) and (reel < 100000)) or Abandon;
  if Abandon then
  BEGIN
    Abandonner := true;
    MontreSouris;
    EffaceBas;
    exit;
  END;
  RRech := reel;
  EffaceBas;
  MontreSouris;
  if CCe2Dr(Xd1,Yd1,Aod1,Xd2,Yd2,Aod2,RRech,XS1,YS1,XS2,YS2,XRech,YRech,RRech)
     then CreeCercle(XRech,YRech,RRech,0,0,0,0,0,0)
     else CreationImpossible;
END;

{}

PROCEDURE CercleRayon_Droite_Cercle(Xd,Yd,Aod : real;
                                    XS1,YS1,XS2,YS2 : integer);

VAR
  XCentre,YCentre,Rayon : real;
  XRech,YRech,RRech : real;

BEGIN
  XCentre := CercleEnCours^.Xc;
  YCentre := CercleEnCours^.Yc;
  Rayon := CercleEnCours^.R;
  CacheSouris;
  REPEAT
    Saisie(1,MaxYTxt -1,9,3,grClFond,blanc,
           ' Rayon (0.001 - 99 999.999 ) : ');
  UNTIL ((reel > 0) and (reel < 100000)) or Abandon;
  if Abandon then
  BEGIN
    Abandonner := true;
    MontreSouris;
    EffaceBas;
    exit;
  END;
  RRech := reel;
  EffaceBas;
  MontreSouris;
  if CCeDrCe(Xd,Yd,Aod,XCentre,YCentre,Rayon,RRech,XS1,YS1,XS2,YS2,
             XRech,YRech,RRech)
     then CreeCercle(XRech,YRech,RRech,0,0,0,0,0,0)
     else CreationImpossible;
END;

{}

PROCEDURE CercleRayon_Droite(XS1,YS1 : integer);

VAR
  Xd,Yd,Aod,Ad,Bd,Cd : real;
  XS2,YS2 : integer;

BEGIN
  Xd := DroiteEnCours^.X;
  Yd := DroiteEnCours^.Y;
  Aod := DroiteEnCours^.Angle;
  Ad := DroiteEnCours^.A;
  Bd := DroiteEnCours^.B;
  Cd := DroiteEnCours^.C;
  Fait := false;
  repeat
    AfficheBas(grClFond,grClTexte,
      'Cliquez le deuxime lment de rfrence ');
    AttenteClic;
    EffaceBas;
    Test_Abandon;
    if Abandonner then exit;
    if BoutSouris = 1 then
    BEGIN
      EnregistreSouris(XS2,YS2);
      if DetectPoint then CercleRayon_Droite_Point(Xd,Yd,Aod,Ad,Bd,Cd,XS2,YS2)
      else
      if DetectDroite then CercleRayon_Droite_Droite(Xd,Yd,Aod,XS1,YS1,XS2,YS2)
      else
      if DetectCercle then CercleRayon_Droite_Cercle(Xd,Yd,Aod,XS1,YS1,XS2,YS2);
    END;
    if Abandonner then exit;
  until Fait;
END;

{}

PROCEDURE CercleRayon_Cercle_Point(XCentre,YCentre,Rayon : real;
                                   XS1,YS1 : integer);

VAR
  XS,YS : integer;
  Xp,Yp : real;
  XRech,YRech,RRech : real;

BEGIN
  Xp := PointEnCours^.X;
  Yp := PointEnCours^.Y;
  CacheSouris;
  REPEAT
    Saisie(1,MaxYTxt -1,9,3,grClFond,blanc,
           ' Rayon (0.001 - 99 999.999 ) : ');
  UNTIL ((reel > 0) and (reel < 100000)) or Abandon;
  if Abandon then
  BEGIN
    Abandonner := true;
    MontreSouris;
    EffaceBas;
    exit;
  END;
  RRech := reel;
  EffaceBas;
  MontreSouris;
  AfficheBas(grClFond,grClTexte,'Position ?');
  AttenteClic;
  EffaceBas;
  Test_Abandon;
  if Abandonner then exit;
  if BoutSouris = 1 then
  BEGIN
    EnregistreSouris(XS,YS);
    if CCePtsCe(Xp,Yp,XCentre,YCentre,Rayon,RRech,XS,YS,XS1,YS1,XRech,YRech,RRech)
       then CreeCercle(XRech,YRech,RRech,0,0,0,0,0,0)
       else CreationImpossible;
  END;
END;

{}

PROCEDURE CercleRayon_Cercle_Droite(XCentre,YCentre,Rayon : real;
                                    XS1,YS1,XS2,YS2 : integer);

VAR
  Xd,Yd,Aod : real;
  XRech,YRech,RRech : real;

BEGIN
  Xd := DroiteEnCours^.X;
  Yd := DroiteEnCours^.Y;
  Aod := DroiteEnCours^.Angle;
  CacheSouris;
  REPEAT
    Saisie(1,MaxYTxt -1,9,3,grClFond,blanc,
           ' Rayon (0.001 - 99 999.999 ) : ');
  UNTIL ((reel > 0) and (reel < 100000)) or Abandon;
  if Abandon then
  BEGIN
    Abandonner := true;
    MontreSouris;
    EffaceBas;
    exit;
  END;
  RRech := reel;
  EffaceBas;
  MontreSouris;
  if CCeDrCe(Xd,Yd,Aod,XCentre,YCentre,Rayon,RRech,XS2,YS2,XS1,YS1,
             XRech,YRech,RRech)
     then CreeCercle(XRech,YRech,RRech,0,0,0,0,0,0)
     else CreationImpossible;
END;

{}

PROCEDURE CercleRayon_Cercle_Cercle(Xc1,Yc1,Rc1 : real;
                                    XS1,YS1,XS2,YS2 : integer);

VAR
  Xc2,Yc2,Rc2 : real;
  XRech,YRech,RRech : real;

BEGIN
  Xc2 := CercleEnCours^.Xc;
  Yc2 := CercleEnCours^.Yc;
  Rc2 := CercleEnCours^.R;
  CacheSouris;
  REPEAT
    Saisie(1,MaxYTxt -1,9,3,grClFond,blanc,
           ' Rayon (0.001 - 99 999.999 ) : ');
  UNTIL ((reel > 0) and (reel < 100000)) or Abandon;
 if Abandon then
 BEGIN
   Abandonner := true;
   MontreSouris;
   EffaceBas;
   exit;
 END;
 RRech := reel;
 EffaceBas;
 MontreSouris;
 if CCe2Ce(Xc1,Yc1,Rc1,Xc2,Yc2,Rc2,RRech,XS1,YS1,XS2,YS2,XRech,YRech,RRech)
    then CreeCercle(XRech,YRech,RRech,0,0,0,0,0,0)
    else CreationImpossible;
END;

{}

PROCEDURE CercleRayon_Cercle(XS1,YS1 : integer);

VAR
  XCentre,YCentre,Rayon : real;
  XS2,YS2 : integer;

BEGIN
  XCentre := CercleEnCours^.Xc;
  YCentre := CercleEnCours^.Yc;
  Rayon := CercleEnCours^.R;
  Fait := false;
  repeat
    AfficheBas(grClFond,grClTexte,
      'Cliquez le deuxime lment de rfrence ');
    AttenteClic;
    EffaceBas;
    Test_Abandon;
    if Abandonner then exit;
    if BoutSouris = 1 then
    BEGIN
      EnregistreSouris(XS2,YS2);
      if DetectPoint then
         CercleRayon_Cercle_Point(XCentre,YCentre,Rayon,XS1,YS1)
      else
      if DetectDroite then
         CercleRayon_Cercle_Droite(XCentre,YCentre,Rayon,XS1,YS1,XS2,YS2)
      else
      if DetectCercle then
         CercleRayon_Cercle_Cercle(XCentre,YCentre,Rayon,XS1,YS1,XS2,YS2);
    END;
    if Abandonner then exit;
  until Fait;
END;

{}

PROCEDURE CercleRayon;

VAR
  XS,YS : integer;

BEGIN
  repeat
    AfficheBas(grClFond,grClTexte,
      'Cliquez le premier lment de rfrence ');
    AttenteClic;
    EffaceBas;
    Test_Abandon;
    if Abandonner then exit;
    if BoutSouris = 1 then
    BEGIN
      EnregistreSouris(XS,YS);
      if DetectPoint then CercleRayon_Point(XS,YS)
      else
      if DetectDroite then CercleRayon_Droite(XS,YS)
      else
      if DetectCercle then CercleRayon_Cercle(XS,YS);
    END;
    if Abandonner then exit;
  until false;
END;

{}
{ Gestion des cercles dont on connait 3 lments de tangence .              }
{ (point(s) , droite(s) , cercle(s)                                         }
{}

PROCEDURE CercleRien_Point_Point_Point(Xp1,Yp1,Xp2,Yp2 : real);

VAR
  Xp3,Yp3 : real;
  XRech,YRech,RRech : real;

BEGIN
  Xp3 := PointEnCours^.X;
  Yp3 := PointEnCours^.Y;
  if CCe3Pts(Xp1,Yp1,Xp2,Yp2,Xp3,Yp3,XRech,YRech,RRech)
     then CreeCercle(XRech,YRech,RRech,0,0,0,0,0,0)
     else CreationImpossible;
END;

{}


PROCEDURE CercleRien_Point_Point(Xp1,Yp1 : real;XS1,YS1,XS2,YS2 : integer);

VAR
  XS3,YS3 : integer;
  Xp2,Yp2 : real;

BEGIN
  Xp2 := PointEnCours^.X;
  Yp2 := PointEnCours^.Y;
  Fait := false;
  repeat
    AfficheBas(grClFond,grClTexte,
        'Cliquez le troisime lment de rfrence ');
    AttenteClic;
    EffaceBas;
    Test_Abandon;
    if Abandonner then exit;
    if BoutSouris = 1 then
    BEGIN
      EnregistreSouris(XS3,YS3);
      if DetectPoint then CercleRien_Point_Point_Point(Xp1,Yp1,Xp2,Yp2)
      else
      if DetectDroite then exit
      else
      if DetectCercle then exit;
    END;
    if Abandonner then exit;
  until Fait;
END;

{}

PROCEDURE CercleRien_Point_Droite(XS1,YS1 : integer);

BEGIN

END;

{}

PROCEDURE CercleRien_Point_Cercle(XS1,YS1 : integer);

BEGIN

END;

{}

PROCEDURE CercleRien_Point(XS1,YS1 : integer);

VAR
  XS2,YS2 : integer;
  Xp,Yp : real;

BEGIN
  Xp := PointEnCours^.X;
  Yp := PointEnCours^.Y;
  Fait := false;
  repeat
    AfficheBas(grClFond,grClTexte,
        'Cliquez le deuxime lment de rfrence ');
    AttenteClic;
    EffaceBas;
    Test_Abandon;
    if Abandonner then exit;
    if BoutSouris = 1 then
    BEGIN
      EnregistreSouris(XS2,YS2);
      if DetectPoint then CercleRien_Point_Point(Xp,Yp,XS1,YS1,XS2,YS2)
      else
      if DetectDroite then CercleRien_Point_Droite(XS1,YS1)
      else
      if DetectCercle then CercleRien_Point_Cercle(XS1,YS1);
    END;
    if Abandonner then exit;
  until Fait;
END;

{}

PROCEDURE CercleRien_Droite(XS1,YS1 : integer);

BEGIN

END;

{}

PROCEDURE CercleRien_Cercle(XS1,YS1 : integer);

BEGIN

END;

{}

PROCEDURE CercleRien;

VAR
  XS,YS : integer;

BEGIN
  repeat
    AfficheBas(grClFond,grClTexte,
      'Cliquez le premier lment de rfrence ');
    AttenteClic;
    EffaceBas;
    Test_Abandon;
    if Abandonner then exit;
    if BoutSouris = 1 then
    BEGIN
      EnregistreSouris(XS,YS);
      if DetectPoint then CercleRien_Point(XS,YS)
      else
      if DetectDroite then CercleRien_Droite(XS,YS)
      else
      if DetectCercle then CercleRien_Cercle(XS,YS);
    END;
    if Abandonner then exit;
  until false;
END;

{}
{ Gestion points , droites et cercles tourns .                             }
{}

PROCEDURE Tourne_Point(Xc,Yc,Angle : real);

VAR
  Xp,Yp : real;
  XRech,YRech : real;

BEGIN
  Xp := PointEnCours^.X;
  Yp := PointEncours^.Y;
  CPtTourne(Xc,Yc,Xp,Yp,Angle,XRech,YRech);
  CreePoint(XRech,YRech);
END;

{}

PROCEDURE Tourne_Droite(Xc,Yc,Angle : real);

VAR
  Xd,Yd,Aod : real;
  XRech,YRech,ARech : real;

BEGIN
  Xd := DroiteEnCours^.X;
  Yd := DroiteEnCours^.Y;
  Aod := DroiteEnCours^.Angle;
  CDrTourne(Xc,Yc,Xd,Yd,Aod,Angle,XRech,YRech,ARech);
  CreeDroite(XRech,YRech,ARech,0,0,0,0);
END;

{}

PROCEDURE Tourne_Cercle(Xc,Yc,Angle : real);

VAR
  XCercle,YCercle,Rayon : real;
  XRech,YRech,RRech : real;

BEGIN
  XCercle := CercleEnCours^.Xc;
  YCercle := CercleEnCours^.Yc;
  Rayon := CercleEnCours^.R;
  RRech := Rayon;
  CPtTourne(Xc,Yc,XCercle,YCercle,Angle,XRech,YRech);
  CreeCercle(XRech,YRech,RRech,0,0,0,0,0,0);
END;

{}

PROCEDURE Tourne_Choix;

VAR
  XS,YS : integer;
  Angle : real;
  XCentre,YCentre : real;

BEGIN
  XCentre := PointEnCours^.X;
  YCEntre := PointEnCours^.Y;
  CacheSouris;
  REPEAT
    Saisie(1,MaxYTxt -1,8,3,grClFond,blanc,' Angle (+/- 359.999 degrs) : ');
  UNTIL ((abs(reel) > -360) and (abs(reel) < 360)) or Abandon;
  if Abandon then
  BEGIN
    MontreSouris;
    EffaceBas;
    exit;
  END;
  Angle := DegToRad(reel);
  EffaceBas;
  MontreSouris;
  repeat
    AfficheBas(grClFond,grClTexte,
               'Cliquez l''lment  tourner ');
    AttenteClic;
    EffaceBas;
    Test_Abandon;
    if Abandonner then exit;
    if BoutSouris = 1 then
    BEGIN
      EnregistreSouris(XS,YS);
      if DetectPoint then Tourne_Point(XCentre,YCentre,Angle)
      else
      if DetectDroite then Tourne_Droite(XCentre,YCentre,Angle)
      else
      if DetectCercle then Tourne_Cercle(XCentre,YCentre,Angle);
    END;
    if Abandonner then exit;
  until false;
END;

{}

PROCEDURE Tourne;

VAR
  XS,YS : integer;

BEGIN
  AfficheBas(grClFond,grClTexte,'Cliquez le centre de rotation ');
  AttenteClic;
  EffaceBas;
  Test_Abandon;
  if Abandonner then exit;
  if BoutSouris = 1 then
  BEGIN
    EnregistreSouris(XS,YS);
    if DetectPoint then Tourne_Choix;
  END;
  if Abandonner then exit;
END;

{}
{ Gestion points , droites et cercles symtriques par rapport  un point ou }
{ une droite .                                                              }
{}

PROCEDURE Symetrie_Point_Point(Xps,Yps : real);

VAR
  Xp,Yp : real;
  XRech,YRech : real;

BEGIN
  Xp := PointEnCours^.X;
  Yp := PointEnCours^.Y;
  CPtSymPt(Xp,Yp,Xps,Yps,XRech,YRech);
  CreePoint(XRech,YRech);
END;

{}

PROCEDURE Symetrie_Point_Droite(Xps,Yps : real);

VAR
 Xd,Yd,Aod : real;
 XRech,YRech,ARech : real;

BEGIN
  Xd := DroiteEnCours^.X;
  Yd := DroiteEnCours^.Y;
  Aod := DroiteEnCours^.Angle;
  CDrSymPt(Xd,Yd,Aod,Xps,Yps,XRech,YRech,ARech);
  CreeDroite(XRech,YRech,ARech,0,0,0,0);
END;

{}

PROCEDURE Symetrie_Point_Cercle(Xps,Yps : real);

VAR
  XCercle,YCercle,Rayon : real;
  XRech,YRech,RRech : real;

BEGIN
  XCercle := CercleEnCours^.Xc;
  YCercle := CercleEnCours^.Yc;
  Rayon := CercleEnCours^.R;
  RRech := Rayon;
  CPtSymPt(XCercle,YCercle,Xps,Yps,XRech,YRech);
  CreeCercle(XRech,YRech,RRech,0,0,0,0,0,0);
END;

{}

PROCEDURE Symetrie_Point;

VAR
  XS,YS : integer;
  Xp,Yp : real;

BEGIN
  Xp := PointEnCours^.X;
  Yp := PointEnCours^.Y;
  repeat
    AfficheBas(grClFond,grClTexte,
               'Cliquez l''lment  symtriser ');
    AttenteClic;
    EffaceBas;
    Test_Abandon;
    if Abandonner then exit;
    if BoutSouris = 1 then
    BEGIN
      EnregistreSouris(XS,YS);
      if DetectPoint then Symetrie_Point_Point(Xp,Yp)
      else
      if DetectDroite then Symetrie_Point_Droite(Xp,Yp)
      else
      if DetectCercle then Symetrie_Point_Cercle(Xp,Yp);
    END;
    if Abandonner then exit;
  until false;
END;

{}

PROCEDURE Symetrie_Droite_Point(XdS,YdS,AodS : real);

VAR
  Xp,Yp : real;
  XRech,YRech : real;

BEGIN
  Xp := PointEnCours^.X;
  Yp := PointEnCours^.Y;
  CPtSymDr(Xp,Yp,XdS,YdS,AodS,XRech,YRech);
  CreePoint(XRech,YRech);
END;

{}

PROCEDURE Symetrie_Droite_Droite(AS,BS,CS,AodS : real);

VAR
 Ad,Bd,Cd,Aod : real;
 XRech,YRech,ARech : real;

BEGIN
  Ad := DroiteEnCours^.A;
  Bd := DroiteEnCours^.B;
  Cd := DroiteEnCours^.C;
  Aod := DroiteEnCours^.Angle;
  if CDrSymDr(Ad,Bd,Cd,Aod,AS,BS,CS,AodS,XRech,YRech,ARech) then
           CreeDroite(XRech,YRech,ARech,0,0,0,0)
     else CreationImpossible;
END;

{}

PROCEDURE Symetrie_Droite_Cercle(XdS,YdS,AodS : real);

VAR
  XCercle,YCercle,Rayon : real;
  XRech,YRech,RRech : real;

BEGIN
  XCercle := CercleEnCours^.Xc;
  YCercle := CercleEnCours^.Yc;
  Rayon := CercleEnCours^.R;
  RRech := Rayon;
  CPtSymDr(XCercle,YCercle,XdS,YdS,AodS,XRech,YRech);
  CreeCercle(XRech,YRech,RRech,0,0,0,0,0,0);
END;

{}

PROCEDURE Symetrie_Droite;

VAR
  XS,YS : integer;
  XdS,YdS,AodS,AS,BS,CS : real;

BEGIN
  XdS := DroiteEnCours^.X;
  YdS := DroiteEnCours^.Y;
  AodS := DroiteEnCours^.Angle;
  AS := DroiteEnCours^.A;
  BS := DroiteEnCours^.B;
  CS := DroiteEnCours^.C;
  repeat
    AfficheBas(grClFond,grClTexte,
               'Cliquez l''lment  symtriser ');
    AttenteClic;
    EffaceBas;
    Test_Abandon;
    if Abandonner then exit;
    if BoutSouris = 1 then
    BEGIN
      EnregistreSouris(XS,YS);
      if DetectPoint then Symetrie_Droite_Point(XdS,YdS,AodS)
      else
      if DetectDroite then Symetrie_Droite_Droite(AS,BS,CS,AodS)
      else
      if DetectCercle then Symetrie_Droite_Cercle(XdS,YdS,AodS);
    END;
    if Abandonner then exit;
  until false;
END;

{}

PROCEDURE Symetrie;

VAR
  XS,YS : integer;

BEGIN
  AfficheBas(grClFond,grClTexte,'Cliquez l''lment de symtrie');
  AttenteClic;
  EffaceBas;
  Test_Abandon;
  if Abandonner then exit;
  if BoutSouris = 1 then
  BEGIN
    EnregistreSouris(XS,YS);
    if DetectPoint then Symetrie_Point
    else
    if DetectDroite then Symetrie_Droite;
  END;
  if Abandonner then exit;
END;

{}
{ Gestion points en coordonnes polaires , des dplacements de points et    }
{ cercles en coordonnes polaires .                                         }
{}

PROCEDURE Polaire_Rayon;

VAR
  R,Angle : real;
  XRech,YRech : real;

BEGIN
  CacheSouris;
  REPEAT
    Saisie(1,MaxYTxt -1,9,3,grClFond,blanc,' Rayon (0.001 - 99 999.999 ) : ');
  UNTIL ((reel > 0) and (reel < 100000)) or Abandon;
  if Abandon then
  BEGIN
    MontreSouris;
    EffaceBas;
    exit;
  END;
  R := reel;
  EffaceBas;
  REPEAT
    Saisie(1,MaxYTxt -1,8,3,grClFond,blanc,' Angle (+/- 359.999 degrs) : ');
  UNTIL ((abs(reel) > -360) and (abs(reel) < 360)) or Abandon;
  if Abandon then
  BEGIN
    MontreSouris;
    EffaceBas;
    exit;
  END;
  Angle := DegToRad(reel);
  EffaceBas;
  MontreSouris;
  XRech:= R * MCos(Angle);
  YRech:= R * MSin(Angle);
  CreePoint(XRech,YRech);
END;

{}

PROCEDURE Polaire_Point;

VAR
  Xp,Yp : real;
  R,Angle : real;
  XRech,YRech : real;

BEGIN
  Xp := PointEnCours^.X;
  Yp := PointEnCours^.Y;
  CacheSouris;
  REPEAT
    Saisie(1,MaxYTxt -1,9,3,grClFond,blanc,' Rayon (0.001 - 99 999.999 ) : ');
  UNTIL ((reel > 0) and (reel < 100000)) or Abandon;
  if Abandon then
  BEGIN
    MontreSouris;
    EffaceBas;
    exit;
  END;
  R := reel;
  EffaceBas;
  REPEAT
    Saisie(1,MaxYTxt -1,8,3,grClFond,blanc,' Angle (+/- 359.999 degrs) : ');
  UNTIL ((abs(reel) > -360) and (abs(reel) < 360)) or Abandon;
  if Abandon then
  BEGIN
    MontreSouris;
    EffaceBas;
    exit;
  END;
  Angle := DegToRad(reel);
  EffaceBas;
  MontreSouris;
  XRech:= Xp + R * Cos(Angle);
  YRech:= Yp + R * Sin(Angle);
  CreePoint(XRech,YRech);
END;

{}

PROCEDURE Polaire_Cercle;

VAR
  XCercle,YCercle,RCercle : real;
  R,Angle : real;
  XRech,YRech,RRech : real;

BEGIN
  XCercle := CercleEnCours^.Xc;
  YCercle := CercleEnCours^.Yc;
  RCercle := CercleEnCours^.R;
  CacheSouris;
  REPEAT
    Saisie(1,MaxYTxt -1,9,3,grClFond,blanc,' Rayon (0.001 - 99 999.999 ) : ');
  UNTIL ((reel > 0) and (reel < 100000)) or Abandon;
  if Abandon then
  BEGIN
    MontreSouris;
    EffaceBas;
    exit;
  END;
  R := reel;
  EffaceBas;
  REPEAT
    Saisie(1,MaxYTxt -1,8,3,grClFond,blanc,' Angle (+/- 359.999 degrs) : ');
  UNTIL ((abs(reel) > -360) and (abs(reel) < 360)) or Abandon;
  if Abandon then
  BEGIN
    MontreSouris;
    EffaceBas;
    exit;
  END;
  Angle := DegToRad(reel);
  EffaceBas;
  MontreSouris;
  XRech:= XCercle + R * Cos(Angle);
  YRech:= YCercle + R * Sin(Angle);
  RRech := RCercle;
  CreeCercle(XRech,YRech,RRech,0,0,0,0,0,0);
END;

{}

PROCEDURE Polaire;

VAR
  XS,YS : integer;

BEGIN
  repeat
    AfficheBas(grClFond,grClTexte,
      'Entrez un rayon ou cliquez un lment de rfrence ');
    Attente;
    EffaceBas;
    Test_Abandon;
    if Abandonner then exit;
    if keypressed then Polaire_Rayon
    else if BoutSouris = 1 then
    BEGIN
      EnregistreSouris(XS,YS);
      if DetectPoint then Polaire_Point
      else
      if DetectCercle then Polaire_Cercle;
    END;
    if Abandonner then exit;
  until false;
END;

{}

BEGIN

END.