UNIT CaoBdd;

{}
{                                                                           }
{                                CaoBdd                                     }
{                                                                           }
{             - Routines de gestion des bases de donnes -                  }
{                                                                           }
{}

INTERFACE

USES
    GrafFtr,
    CaoGlob,
    CaoDef;

{}

PROCEDURE AjoutePoint(XPoint,YPoint : real);
PROCEDURE SuppPoint(PointRef : PointPtr);
PROCEDURE ModifPoint(Num : integer);
PROCEDURE TrouvePoint(XPoint,YPoint : real;Var X,Y : real);
FUNCTION ListePoint : boolean;
PROCEDURE SuppToutPoint;
PROCEDURE AjouteDroite(X,Y,Angle,XD,YD,XF,YF : real);
PROCEDURE SuppDroite(DroiteRef : DroitePtr);
PROCEDURE ModifDroite(XD,YD,XF,YF : real;Num : integer);
PROCEDURE TrouveDroite(XDroite,YDroite : real;Var X,Y,Angle : real);
FUNCTION ListeDroite : boolean;
PROCEDURE SuppToutDroite;
PROCEDURE AjouteCercle(X,Y,R,XD,YD,AD,XF,YF,AF : real);
PROCEDURE SuppCercle(CercleRef : CerclePtr);
PROCEDURE ModifCercle(XD,YD,AD,XF,YF,AF : real;Num : integer);
PROCEDURE TrouveCercle(XCentre,YCentre : real;Var X,Y : real);
FUNCTION ListeCercle : boolean;
PROCEDURE SuppToutCercle;

IMPLEMENTATION

{}

PROCEDURE AjoutePoint(XPoint,YPoint : real);
VAR
  RecherchePoint : PointPtr;
  NouveauPoint   : PointPtr;
  DernierPoint   : PointPtr;
  Trouve         : boolean;

BEGIN
  if MemAvail < Sizeof(NouveauPoint) then
  BEGIN
     Alerte('Cration impossible , plus assez de mmoire !');
     exit;
  END;
  if NbPoint = MaxPoint then
  BEGIN
     Alerte('Cration impossible , nombre maxi de points atteint ! ');
     exit;
  END;
  NbPoint := NbPoint + 1;
  New(NouveauPoint);
  NouveauPoint^.Nom := 'POINT';
  NouveauPoint^.Numero := NbPoint;
  NouveauPoint^.X := XPoint;
  NouveauPoint^.Y := YPoint;
  NouveauPoint^.Couleur := CoulActive;
  NouveauPoint^.Couche := 0;
  NouveauPoint^.Select := false;
  NouveauPoint^.Visible := true;
  NouveauPoint^.Suivant := nil;

  RecherchePoint := PremierPoint;
  if RecherchePoint = nil then PremierPoint := NouveauPoint
  else
  BEGIN
    Trouve := false;

    while (RecherchePoint <> nil) and not Trouve do
      if RecherchePoint^.X < NouveauPoint^.X then
      BEGIN
        DernierPoint := RecherchePoint;
        RecherchePoint := RecherchePoint^.Suivant;
      END
      else Trouve := true;

    NouveauPoint^.Suivant := RecherchePoint;

    if RecherchePoint = PremierPoint then PremierPoint := NouveauPoint
       else DernierPoint^.Suivant := NouveauPoint;
  END;

  Modifie := true;
  NbModif := NbModif + 1;
END;

{}

PROCEDURE SuppPoint(PointRef : PointPtr);
VAR
  RecherchePoint : PointPtr;
  NouveauPoint   : PointPtr;
  Trouve         : boolean;

BEGIN
  if PointRef = PremierPoint then
  BEGIN
    NouveauPoint := PremierPoint;
    PremierPoint := PremierPoint^.Suivant;
    dispose(NouveauPoint);
    NbPoint := NbPoint - 1;
  END
  else
  BEGIN
    Trouve := false;
    RecherchePoint := PremierPoint;
    while (RecherchePoint^.Suivant <> nil) and not trouve do
      if (RecherchePoint^.Suivant = PointRef) then Trouve := true
      else RecherchePoint := RecherchePoint^.Suivant;

    if Trouve then
    BEGIN
    NouveauPoint := RecherchePoint^.Suivant;
    RecherchePoint^.Suivant := RecherchePoint^.Suivant^.Suivant;
    Dispose(NouveauPoint);
    NbPoint := NbPoint - 1;
    END;
  END;
  Modifie := true;
  NbModif := NbModif + 1;
END;

{}

PROCEDURE ModifPoint(Num : integer);

VAR
  RecherchePoint : PointPtr;

BEGIN
  RecherchePoint := PremierPoint;
  while RecherchePoint^.Numero <> Num do
        RecherchePoint := RecherchePoint^.Suivant;
  RecherchePoint^.Couleur := CoulActive;
  Modifie := true;
  NbModif := NbModif + 1;
END;

{}

PROCEDURE TrouvePoint(XPoint,YPoint : real;Var X,Y : real);
VAR
  RecherchePoint : PointPtr;
  Trouve         : boolean;

BEGIN
  RecherchePoint := PremierPoint;
  Trouve := false;
  while (RecherchePoint^.Suivant <> nil) and not trouve do
      if (RecherchePoint^.Suivant^.X = XPoint) and
         (RecherchePoint^.Suivant^.Y = YPoint) then Trouve := true
      else RecherchePoint := RecherchePoint^.Suivant;
  if Trouve then
  BEGIN
    X := RecherchePoint^.X;
    Y := RecherchePoint^.Y;
  END;
END;

{}

FUNCTION ListePoint : boolean;

BEGIN
  ListePoint := true;
  if PointEnCours^.Suivant <> nil then
     PointEnCours := PointEnCours^.Suivant
     else ListePoint := false;
END;

{}

PROCEDURE SuppToutPoint;

VAR
  PointActuel    : PointPtr;
  RecherchePoint : PointPtr;

BEGIN
  if PremierPoint = nil then exit;
  PointActuel := PremierPoint;
  while (PointActuel^.Suivant <> nil) do
  BEGIN
    RecherchePoint := PointActuel^.Suivant;
    Dispose(PointActuel);
    PointActuel := RecherchePoint;
  END;
  Dispose(PointActuel);
  PremierPoint := nil;
  NbPoint := 0;
END;

{}

PROCEDURE AjouteDroite(X,Y,Angle,XD,YD,XF,YF : real);
VAR
  RechercheDroite : DroitePtr;
  NouveauDroite   : DroitePtr;
  DernierDroite   : DroitePtr;
  Trouve          : boolean;
  A,B,C,Tmp       : real;

BEGIN
  if MemAvail < Sizeof(NouveauDroite) then
  BEGIN
     Alerte('Cration impossible , plus assez de mmoire !');
     exit;
  END;
  if NbDroite = MaxDroite then
  BEGIN
     Alerte('Cration impossible , nombre maxi de droites atteint ! ');
     exit;
  END;
  NbDroite := NbDroite + 1;
  New(NouveauDroite);
  if (XD = XF) and (YD = YF) then NouveauDroite^.Nom := 'DROITE'
                             else NouveauDroite^.Nom := 'SEGMENT';
  CalculEqDroite(X,Y,Angle,A,B,C);
  NouveauDroite^.Numero := NbDroite;
  NouveauDroite^.X := X;
  NouveauDroite^.Y := Y;
  NouveauDroite^.Angle := Angle;
  NouveauDroite^.XDebut := XD;
  NouveauDroite^.YDebut := YD;
  NouveauDroite^.XFin := XF;
  NouveauDroite^.YFin := YF;
  NouveauDroite^.A := A;
  NouveauDroite^.B := B;
  NouveauDroite^.C := C;
  NouveauDroite^.Couleur := CoulActive;
  NouveauDroite^.Couche := 0;
  NouveauDroite^.Select := false;
  NouveauDroite^.Visible := true;
  NouveauDroite^.Suivant := nil;

  RechercheDroite := PremierDroite;
  if RechercheDroite = nil then PremierDroite := NouveauDroite
  else
  BEGIN
    Trouve := false;

    while (RechercheDroite <> nil) and not Trouve do
      if RechercheDroite^.Couleur < NouveauDroite^.Couleur then
      BEGIN
        DernierDroite := RechercheDroite;
        RechercheDroite := RechercheDroite^.Suivant;
      END
      else Trouve := true;

    NouveauDroite^.Suivant := RechercheDroite;

    if RechercheDroite = PremierDroite then PremierDroite := NouveauDroite
       else DernierDroite^.Suivant := NouveauDroite;
  END;
(*  if (XD = XF) and (YD = YF) then
  BEGIN
    if (Angle = 0) or (Angle = Pi) then
    BEGIN
      if Y < MinY then MinY := Y;
      if Y > MaxY then MaxY := Y;
    END
    else
    if (Angle = PiSur2) or (Angle = 3 * PiSur2) then
    BEGIN
      if X < MinX then MinX := X;
      if X > MaxX then MaxX := X;
    END
    else
    if (A <> 0) and (B <> 0) then
    BEGIN
      Tmp := -(A / B) * MinX - (C / B);
      if Tmp < MinY then MinY := Tmp;
      if Tmp > MaxY then MaxY := Tmp;
      Tmp := -(A / B) * MaxX - (C / B);
      if Tmp < MinY then MinY := Tmp;
      if Tmp > MaxY then MaxY := Tmp;
      Tmp := -(B / A) * MinY - (C / A);
      if Tmp < MinX then MinX := Tmp;
      if Tmp > MaxX then MaxX := Tmp;
      Tmp := -(B / A) * MaxY - (C / A);
      if Tmp < MinX then MinX := Tmp;
      if Tmp > MaxX then MaxX := Tmp;
    END;
  END
  else
  BEGIN
    if XD < MinX then MinX := XD;
    if XD > MaxX then MaxX := XD;
    if YD < MinY then MinY := YD;
    if YD > MaxY then MaxY := YD;
    if XF < MinX then MinX := XF;
    if XF > MaxX then MaxX := XF;
    if YF < MinY then MinY := YF;
    if YF > MaxY then MaxY := YF;
  END;*)
  Modifie := true;
  NbModif := NbModif + 1;
END;

{}

PROCEDURE SuppDroite(DroiteRef : DroitePtr);
VAR
  RechercheDroite : DroitePtr;
  NouveauDroite   : DroitePtr;
  Trouve          : boolean;

BEGIN
  if (DroiteRef = PremierDroite) then
  BEGIN
    NouveauDroite := PremierDroite;
    PremierDroite := PremierDroite^.Suivant;
    dispose(NouveauDroite);
    NbDroite := NbDroite - 1;
  END
  else
  BEGIN
    Trouve := false;
    RechercheDroite := PremierDroite;
    while (RechercheDroite^.Suivant <> nil) and not trouve do
      if (RechercheDroite^.Suivant = DroiteRef) then Trouve := true
      else RechercheDroite := RechercheDroite^.Suivant;

    if Trouve then
    BEGIN
    NouveauDroite := RechercheDroite^.Suivant;
    RechercheDroite^.Suivant := RechercheDroite^.Suivant^.Suivant;
    Dispose(NouveauDroite);
    NbDroite := NbDroite - 1;
    END;
  END;
  Modifie := true;
  NbModif := NbModif + 1;
END;

{}

PROCEDURE ModifDroite(XD,YD,XF,YF : real;Num : integer);

VAR
  RechercheDroite : DroitePtr;

BEGIN
  RechercheDroite := PremierDroite;
  while RechercheDroite^.Numero <> Num do
        RechercheDroite := RechercheDroite^.Suivant;
  if (XD = XF) and (YD = YF) then RechercheDroite^.Nom := 'DROITE'
                             else RechercheDroite^.Nom := 'SEGMENT';
  RechercheDroite^.XDebut := XD;
  RechercheDroite^.YDebut := YD;
  RechercheDroite^.XFin := XF;
  RechercheDroite^.YFin := YF;
  RechercheDroite^.Couleur := CoulActive;
  Modifie := true;
  NbModif := NbModif + 1;
END;

{}

PROCEDURE TrouveDroite(XDroite,YDroite : real;Var X,Y,Angle : real);
VAR
  RechercheDroite : DroitePtr;
  Trouve          : boolean;

BEGIN
  RechercheDroite := PremierDroite;
  Trouve := false;
  while (RechercheDroite^.Suivant <> nil) and not trouve do
      if (RechercheDroite^.Suivant^.X = XDroite) and
         (RechercheDroite^.Suivant^.Y = YDroite) then Trouve := true
      else RechercheDroite := RechercheDroite^.Suivant;
  if Trouve then
  BEGIN
    X := RechercheDroite^.X;
    Y := RechercheDroite^.Y;
    Angle := RechercheDroite^.Angle;
  END;
END;

{}

FUNCTION ListeDroite : boolean;

BEGIN
  ListeDroite := true;
  if DroiteEnCours^.Suivant <> nil then
     DroiteEnCours := DroiteEnCours^.Suivant
     else ListeDroite := false;
END;

{}

PROCEDURE SuppToutDroite;

VAR
  DroiteActuel    : DroitePtr;
  RechercheDroite : DroitePtr;

BEGIN
  if PremierDroite = nil then exit;
  DroiteActuel := PremierDroite;
  while (DroiteActuel^.Suivant <> nil) do
  BEGIN
    RechercheDroite := DroiteActuel^.Suivant;
    Dispose(DroiteActuel);
    DroiteActuel := RechercheDroite;
  END;
  Dispose(DroiteActuel);
  PremierDroite := nil;
  NbDroite := 0;
END;

{}

PROCEDURE AjouteCercle(X,Y,R,XD,YD,AD,XF,YF,AF : real);
VAR
  RechercheCercle : CerclePtr;
  NouveauCercle   : CerclePtr;
  DernierCercle   : CerclePtr;
  Trouve          : boolean;

BEGIN
  if MemAvail < Sizeof(NouveauCercle) then
  BEGIN
     Alerte('Cration impossible , plus assez de mmoire !');
     exit;
  END;
  if NbCercle = MaxCercle then
  BEGIN
     Alerte('Cration impossible , nombre maxi de cercles atteint ! ');
     exit;
  END;
  NbCercle := NbCercle + 1;
  New(NouveauCercle);
  if (AD = AF) then NouveauCercle^.Nom := 'CERCLE'
               else NouveauCercle^.Nom := 'ARC';
  NouveauCercle^.Numero := NbCercle;
  NouveauCercle^.XC := X;
  NouveauCercle^.YC := Y;
  NouveauCercle^.R := R;
  NouveauCercle^.XDebut := XD;
  NouveauCercle^.YDebut := YD;
  NouveauCercle^.ADebut := AD;
  NouveauCercle^.XFin := XF;
  NouveauCercle^.YFin := YF;
  NouveauCercle^.AFin := AF;
  NouveauCercle^.Couleur := CoulActive;
  NouveauCercle^.Couche := 0;
  NouveauCercle^.Select := false;
  NouveauCercle^.Visible := true;
  NouveauCercle^.Suivant := nil;

  RechercheCercle := PremierCercle;
  if RechercheCercle = nil then PremierCercle := NouveauCercle
  else
  BEGIN
    Trouve := false;

    while (RechercheCercle <> nil) and not Trouve do
      if RechercheCercle^.Couleur < NouveauCercle^.Couleur then
      BEGIN
        DernierCercle := RechercheCercle;
        RechercheCercle := RechercheCercle^.Suivant;
      END
      else Trouve := true;

    NouveauCercle^.Suivant := RechercheCercle;

    if RechercheCercle = PremierCercle then PremierCercle := NouveauCercle
       else DernierCercle^.Suivant := NouveauCercle;
  END;

  Modifie := true;
  NbModif := NbModif + 1;
END;

{}

PROCEDURE SuppCercle(CercleRef : CerclePtr);
VAR
  RechercheCercle : CerclePtr;
  NouveauCercle   : CerclePtr;
  Trouve          : boolean;

BEGIN
  if (CercleRef = PremierCercle) then
  BEGIN
    NouveauCercle := PremierCercle;
    PremierCercle := PremierCercle^.Suivant;
    dispose(NouveauCercle);
    NbCercle := NbCercle - 1;
  END
  else
  BEGIN
    Trouve := false;
    RechercheCercle := PremierCercle;
    while (RechercheCercle^.Suivant <> nil) and not trouve do
      if (RechercheCercle^.Suivant = CercleRef) then Trouve := true
      else RechercheCercle := RechercheCercle^.Suivant;

    if Trouve then
    BEGIN
    NouveauCercle := RechercheCercle^.Suivant;
    RechercheCercle^.Suivant := RechercheCercle^.Suivant^.Suivant;
    Dispose(NouveauCercle);
    NbCercle := NbCercle - 1;
    END;
  END;
  Modifie := true;
  NbModif := NbModif + 1;
END;

{}

PROCEDURE ModifCercle(XD,YD,AD,XF,YF,AF : real;Num : integer);
VAR
  RechercheCercle : CerclePtr;

BEGIN
  RechercheCercle := PremierCercle;
  while RechercheCercle^.Numero <> Num do
        RechercheCercle := RechercheCercle^.Suivant;
  if (AD = AF) then RechercheCercle^.Nom := 'CERCLE'
               else RechercheCercle^.Nom := 'ARC';
  RechercheCercle^.XDebut := XD;
  RechercheCercle^.YDebut := YD;
  RechercheCercle^.ADebut := AD;
  RechercheCercle^.XFin := XF;
  RechercheCercle^.YFin := YF;
  RechercheCercle^.AFin := AF;
  RechercheCercle^.Couleur := CoulActive;
  Modifie := true;
  NbModif := NbModif + 1;
END;

{}

PROCEDURE TrouveCercle(XCentre,YCentre : real;Var X,Y : real);
VAR
  RechercheCercle : CerclePtr;
  Trouve          : boolean;

BEGIN
  RechercheCercle := PremierCercle;
  Trouve := false;
  while (RechercheCercle^.Suivant <> nil) and not trouve do
      if (RechercheCercle^.Suivant^.XC = XCentre) and
         (RechercheCercle^.Suivant^.YC = YCentre) then Trouve := true
      else RechercheCercle := RechercheCercle^.Suivant;
  if Trouve then
  BEGIN
    X := RechercheCercle^.XC;
    Y := RechercheCercle^.YC;
  END;
END;

{}

FUNCTION ListeCercle : boolean;

BEGIN
  ListeCercle := true;
  if CercleEnCours^.Suivant <> nil then
     CercleEnCours := CercleEnCours^.Suivant
     else ListeCercle := false;
END;

{}

PROCEDURE SuppToutCercle;

VAR
  CercleActuel    : CerclePtr;
  RechercheCercle : CerclePtr;

BEGIN
  if PremierCercle = nil then exit;
  CercleActuel := PremierCercle;
  while (CercleActuel^.Suivant <> nil) do
  BEGIN
    RechercheCercle := CercleActuel^.Suivant;
    Dispose(CercleActuel);
    CercleActuel := RechercheCercle;
  END;
  Dispose(CercleActuel);
  PremierCercle := nil;
  NbCercle := 0;
END;

{}

BEGIN
  New(PremierPoint);
  PremierPoint := nil;
  New(PremierDroite);
  PremierDroite := nil;
  New(PremierCercle);
  PremierCercle := nil;
END.