unit JVDutil;

/////////////////////////////////////////////////////////////////////////////
//                     Part of JVDesk project                              //
//                     Multiple desktop management                         //
//  2003  Main developper Alain JAFFRE         http://jack.r.free.fr       //
//                                                                         //
// Utilities for that project                                              //
/////////////////////////////////////////////////////////////////////////////

{***************************************************************************}
{ Ce logiciel est un logiciel libre. Vous pouvez le diffuser et/ou le       }
{ modifier suivant les termes de la GNU General Public License telle que    }
{ publie par la Free Software Foundation, soit la version 2 de cette        }
{ license, soit ( votre convenance) une version ultrieure.                }
{                                                                           }
{ Ce programme est diffus dans l'espoir qu'il sera utile, mais SANS AUCUNE }
{ GARANTIE, sans mme une garantie implicite de COMMERCIALISABILITE ou      }
{ d'ADEQUATION A UN USAGE PARTICULIER. Voyez la GNU General Public License  }
{ pour plus de dtails.                                                     }
{                                                                           }
{ Vous devriez avoir reu une copie de la GNU General Public License avec   }
{ ce programme, sinon, veuillez crire  la Free Software Foundation, Inc., }
{ 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.                  }
{***************************************************************************}

{***************************************************************************}
{ This program is free software. You can redistribute it and/or modify it   }
{ under the terms of the GNU Public License as published by the             }
{ Free Software Foundation, either version 2 of the license, or             }
{ (at your option) any later version.                                       }
{                                                                           }
{ This program is distributed in the hope it will be useful, but WITHOUT    }
{ ANY WARRANTY, without even the implied warranty of MERCHANTABILITY or     }
{ FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for  }
{ more details.                                                             }
{                                                                           }
{ You should have received a copy of the GNU General Public License along   }
{ with this program, if not, write to the Free Software Foundation, Inc.,   }
{ 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.                  }
{***************************************************************************}

interface

uses
  Windows, Classes, Forms, TlHelp32, SysUtils, ShellApi, ShlObj, WinSock;

  function GetIpAddress:TStrings;
  function GetUserApplicationDataDir: string;

  function ExecuteFile(AHandle: THandle; AFileName, AParams, ADefaultDir: string;
    AShowCmd: Integer): THandle;

  function BuildPrgString(AnExeName,ADeskNumber,AStickyStatus: string): string;
  procedure ExtractPrgString(AString: string;
    var AnExeName,ADeskNumber,AStickyStatus: string);

  function LowerCaseText(AText: string): string;
  function FirstUpperText(AText: string): string;
  function ClearShortcutText(AText: string): string;

implementation

{*****************************************************************************}
{ IP address routine                                                          }
{*****************************************************************************}

function GetIpAddress:TStrings;
type
  TaPInAddr = array[0..10] of PInAddr;
  PaPInAddr = ^TaPInAddr;
var
  phe: PHostEnt;
  pptr: PaPInAddr;
  Buffer: array[0..63] of Char;
  I: Integer;
  GInitData: TWSAData;
begin
  WSAStartup($101, GInitData);
  Result := TstringList.Create;
  Result.Clear;
  GetHostName(Buffer, SizeOf(Buffer));
  phe := GetHostByName(buffer);
  if phe = nil then Exit;
  pPtr := PaPInAddr(phe^.h_addr_list);
  I := 0;
  while pPtr^[I] <> nil do
  begin
    Result.Add(inet_ntoa(pptr^[I]^));
    Inc(I);
  end;
  WSACleanup;
end;

{*****************************************************************************}
{ Directories routine                                                         }
{*****************************************************************************}

function GetUserApplicationDataDir: string;
var
  IdList: PItemIdList;
  Directory: array[0..MAX_PATH] of char;
begin
  if SHGetSpecialFolderLocation(0,CSIDL_APPDATA,IdList)=NOERROR then
  begin
    SHGetPathFromIDList(IdList, Directory);
    Result:= Directory;
    if Result[length(Result)] <> '\' then Result:= Result + '\';
  end
  else Result:= '';
end;

{*****************************************************************************}
{ Execute program routine                                                     }
{*****************************************************************************}

function ExecuteFile(AHandle: THandle; AFileName, AParams, ADefaultDir: string;
  AShowCmd: Integer): THandle;
// Execute a file with its default application, command line parameter,
// default directory and return the window handle (0 if failed)
// ShowCmd can be SW_HIDE, SW_SHOWNORMAL, SW_SHOWMINIMIZED, SW_SHOWMAXIMIZED
// SW_SHOWNOACTIVATE, SW_SHOW, SW_MINIMIZE, SW_SHOWMINNOACTIVE, SW_SHOWNA
// SW_RESTORE, SW_SHOWDEFAULT
var
  CurrHandle: THandle;
  TmpHandle: THandle;
  Counter: byte;
begin
  CurrHandle:= GetForegroundWindow();
  TmpHandle := ShellExecute(AHandle, 'open', pchar(AFilename), pchar(AParams),
    pchar(ADefaultDir), AShowCmd);
  if TmpHandle > 32 then // succeed
  begin
    Counter:= 0;
    repeat
      sleep(300); //0.3 secondes
      inc(Counter);
      Application.ProcessMessages;
      TmpHandle:= GetForegroundWindow();
      if Counter = 10 then TmpHandle:= 0; // 3 secondes timeout
    until (TmpHandle <> CurrHandle);
    sleep(1000); // 1 secondes to be sure to have good display
    result:= TmpHandle;
  end
  else
    result:= 0;
end;

{*****************************************************************************}
{ Launched program routine                                                    }
{*****************************************************************************}

function BuildPrgString(AnExeName,ADeskNumber,AStickyStatus: string): string;
// Make a single string from all the elements
begin
  result:= AnExeName + ',' + ADeskNumber + ',' + AStickyStatus;
end;

{------------------------------------------------------------------------------}

procedure ExtractPrgString(AString: string;
  var AnExeName,ADeskNumber,AStickyStatus: string);
// Extract the different elements from a single string
var
  Position: integer;
begin
  // Filename
  Position:= pos(',',AString);
  if Position > 0 then
  begin
    AnExeName:= copy(AString,1,Position - 1);
    System.Delete(AString,1,Position);
    // DeskNumber
    Position:= pos(',',AString);
    if Position > 0 then
    begin
      ADeskNumber:= copy(AString,1,Position - 1);
      System.Delete(AString,1,Position);
      // StickyStatus
      AStickyStatus:= AString;
    end
    else
    begin
      ADeskNumber:= '1';
      AStickyStatus:= '0'
    end;
  end
  else
  begin
    AnExeName:= AString;
    ADeskNumber:= '1';
    AStickyStatus:= '0'
  end;
end;

{*****************************************************************************}
{ Language file utilities                                                     }
{*****************************************************************************}

function LowerCaseText(AText: string): string;
// Change all to lower case
begin
  result:= AnsiLowerCase(AText);
end;

{------------------------------------------------------------------------------}

function FirstUpperText(AText: string): string;
// Put first character in upper case, other lower case
var
  FirstChar: string;
begin
  AText:= LowerCaseText(AText);
  FirstChar:= AText[1];
  FirstChar:= AnsiUpperCase(FirstChar);
  system.Delete(AText,1,1);
  result:= FirstChar + AText;
end;

{------------------------------------------------------------------------------}

function ClearShortcutText(AText: string): string;
// Remove '&' corresponding to shortcut identification and change to lower case
var
  APos: integer;
begin
  AText:= AnsiLowerCase(AText);
  APos:= pos('&',AText);
  if APos<>0 then System.delete(AText,APos,1);
  result:= AText;
end;

end.
