unit JVDname;

/////////////////////////////////////////////////////////////////////////////
//                     Part of JVDesk project                              //
//                     Multiple desktop management                         //
//  2003  Main developper Alain JAFFRE         http://jack.r.free.fr       //
//                                                                         //
// Diplay desktop name in the middle of the screen                         //
/////////////////////////////////////////////////////////////////////////////

{***************************************************************************}
{ Ce logiciel est un logiciel libre. Vous pouvez le diffuser et/ou le       }
{ modifier suivant les termes de la GNU General Public License telle que    }
{ publie par la Free Software Foundation, soit la version 2 de cette        }
{ license, soit ( votre convenance) une version ultrieure.                }
{                                                                           }
{ Ce programme est diffus dans l'espoir qu'il sera utile, mais SANS AUCUNE }
{ GARANTIE, sans mme une garantie implicite de COMMERCIALISABILITE ou      }
{ d'ADEQUATION A UN USAGE PARTICULIER. Voyez la GNU General Public License  }
{ pour plus de dtails.                                                     }
{                                                                           }
{ Vous devriez avoir reu une copie de la GNU General Public License avec   }
{ ce programme, sinon, veuillez crire  la Free Software Foundation, Inc., }
{ 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.                  }
{***************************************************************************}

{***************************************************************************}
{ This program is free software. You can redistribute it and/or modify it   }
{ under the terms of the GNU Public License as published by the             }
{ Free Software Foundation, either version 2 of the license, or             }
{ (at your option) any later version.                                       }
{                                                                           }
{ This program is distributed in the hope it will be useful, but WITHOUT    }
{ ANY WARRANTY, without even the implied warranty of MERCHANTABILITY or     }
{ FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for  }
{ more details.                                                             }
{                                                                           }
{ You should have received a copy of the GNU General Public License along   }
{ with this program, if not, write to the Free Software Foundation, Inc.,   }
{ 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.                  }
{***************************************************************************}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls;

type
  TFrmDeskName = class(TForm)
    TmrHide: TTimer;
    procedure TmrHideTimer(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormPaint(Sender: TObject);
  private
    { Dclarations prives }
  public
    { Dclarations publiques }
  end;

var
  FrmDeskName: TFrmDeskName;

implementation

{$R *.dfm}

procedure TFrmDeskName.TmrHideTimer(Sender: TObject);
begin
  Hide;
  TmrHide.Enabled:= false;
end;

{------------------------------------------------------------------------------}

procedure TFrmDeskName.FormCreate(Sender: TObject);
begin
  Brush.Style:= bsClear;
end;

{------------------------------------------------------------------------------}

procedure TFrmDeskName.FormShow(Sender: TObject);
begin
  TmrHide.Enabled:= false; // be sure to reset the timer
  Sleep(30);               // prevent to have garbadge in the back
  ClientWidth:= Canvas.TextWidth(Caption) + 20;
  ClientHeight:= Canvas.TextHeight(Caption) + 20;
  TmrHide.Enabled:= true;
  BringToFront;
end;

{------------------------------------------------------------------------------}

procedure TFrmDeskName.FormPaint(Sender: TObject);
begin
  Canvas.Brush.Style:= bsClear;
  Canvas.Font.Assign(Font);
  Canvas.Font.Color:= clBlack;
  Canvas.TextOut(12,12,Caption);
  Canvas.TextOut(15,15,Caption);
  Canvas.Font.Color:= clWhite;
  Canvas.TextOut(10,10,Caption);
end;

{------------------------------------------------------------------------------}

end.
