unit JVDmain;

/////////////////////////////////////////////////////////////////////////////
//                                JVDesk                                   //
//                     Multiple desktop management                         //
//  2003  Main developper Alain JAFFRE         http://jack.r.free.fr       //
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
//                              Update history                             //
//                                                                         //
//  26/01/2003                                                             //
//    Start of that new software                                           //
//  02/02/2003 version 0.0.1                                               //
//    Basic function are working (configuration, hide from status bar,     //
//    pager, hotkey ... )                                                  //
//  15/02/2003 version 0.1.0                                               //
//    Sticky window, configure pager desk size, when reducing desk number  //
//    bring all windows of removed desk to the last one, bring window to   //
//    the current desk, goto application (switch to the desk where it is)  //
//  24/02/2003 version 0.2.0                                               //
//    Change window desk number when loosing sticky status , restore       //
//    windows saved status at startup. Didn't work properly. Removed.      //
//  02/03/2003 version 0.3.0                                               //
//    Clean up code regarding TConfig object, user can define with program //
//    he wants to launch at start up, desk number on pager desk, color     //
//    selection for active and inactive desk on pager                      //
//  13/03/2003 version 0.4.0                                               //
//    Change window detection to get only visible windows instead of       //
//    dealing with windows size and position. Use Pid to move all windows  //
//    from the same application to the same desk. Add desk number before   //
//    window title in 'Goto application' and 'Bring application' menus.    //
//    Addition of application unknow window list in order to be able to    //
//    unhide lost applications.                                            //
//  06/04/2003 version 0.5.0                                               //
//    Correct initialisation problem (some part of config was not          //
//    initialised which give black desk). If not configuration file, use   //
//    default setting and create a configuration file with these setting.  //
//    Program internationalization, help file                              //
//  27/04/2003 version 0.6.0                                               //
//    Tray icon hint give the current desktop number. Pager can be hide.   //
//    Left click on tray icon show desktop selection popup menu.           //
//    DisplayException function to add all window which need to be set to  //
//    normal state before showing or hidding them. (Excel, ...)            //
//    PidException for windows which don't need to be on the same desk as  //
//    others with same PID (Explorer, IE, MyComputer ...)                  //
//    Drag windows from desk to desk. Drag file on pager. Drag window on   //
//    pager. Send active application to a specific desk.                   //
//  00/00/2003 version 0.7.0                                               //
//    Tray icon left click menu was not update after number of desk change //
//    in configuration.                                                    //
//    Desk border switching can be disable.                                //
//    Configuration is stored in 'windows application data' directory if   //
//    it exist to allow multi-user configuration                           //
//    Desk name can be defined by user.                                    //
//  28/12/2005 version 0.7.1                                               //
//    Tray icon hint display IP address. Double click on it redo IP address//
//    detection to update tray icon hint in case IP address has changed.   //
//  01/01/2006 version 0.7.2                                               //
//    Correct bug if pager is hidden we should no do any switch from pager //
//    Pager switching can be disable                                       //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////
//              Autre composants utiliss / Other components used          //
//  JCL, JVCL from project JEDI http://www.delphi-jedi.org                 //
//                                                                         //
//                                                                         //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

{***************************************************************************}
{ Ce logiciel est un logiciel libre. Vous pouvez le diffuser et/ou le       }
{ modifier suivant les termes de la GNU General Public License telle que    }
{ publie par la Free Software Foundation, soit la version 2 de cette        }
{ license, soit ( votre convenance) une version ultrieure.                }
{                                                                           }
{ Ce programme est diffus dans l'espoir qu'il sera utile, mais SANS AUCUNE }
{ GARANTIE, sans mme une garantie implicite de COMMERCIALISABILITE ou      }
{ d'ADEQUATION A UN USAGE PARTICULIER. Voyez la GNU General Public License  }
{ pour plus de dtails.                                                     }
{                                                                           }
{ Vous devriez avoir reu une copie de la GNU General Public License avec   }
{ ce programme, sinon, veuillez crire  la Free Software Foundation, Inc., }
{ 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.                  }
{***************************************************************************}

{***************************************************************************}
{ This program is free software. You can redistribute it and/or modify it   }
{ under the terms of the GNU Public License as published by the             }
{ Free Software Foundation, either version 2 of the license, or             }
{ (at your option) any later version.                                       }
{                                                                           }
{ This program is distributed in the hope it will be useful, but WITHOUT    }
{ ANY WARRANTY, without even the implied warranty of MERCHANTABILITY or     }
{ FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for  }
{ more details.                                                             }
{                                                                           }
{ You should have received a copy of the GNU General Public License along   }
{ with this program, if not, write to the Free Software Foundation, Inc.,   }
{ 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.                  }
{***************************************************************************}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Menus, ExtCtrls, ShellApi,
  JvComponent, JvTrayIcon, JvComponentBase;

const
  // Used for GotoDesk changing mode
  Gtd_HotKey     = 0;
  Gtd_MouseClick = 1;
  Gtd_Timer      = 2;
  Gtd_Switch     = 3;
  Gtd_Menu       = 4;

type
  TFrmMain = class(TForm)
    JvTrayIcon: TJvTrayIcon;
    PopupMenu: TPopupMenu;
    MnuAbout: TMenuItem;
    MnuDiv1: TMenuItem;
    MnuExit: TMenuItem;
    MnuWindowList: TMenuItem;
    MnuConfiguration: TMenuItem;
    MnuDiv3: TMenuItem;
    MnuBringAppliHere: TMenuItem;
    MnuGotoAppli: TMenuItem;
    MnuUnknownWindowList: TMenuItem;
    MnuDiv2: TMenuItem;
    MnuSendAppliThere: TMenuItem;
    MnuHelp: TMenuItem;
    MnuLanguage: TMenuItem;
    PmnuDesktop: TPopupMenu;
    TmrSwitchDesk: TTimer;
    Image1: TImage;
    TmrUpdate: TTimer;
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormPaint(Sender: TObject);
    procedure FormMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure FormMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure JvTrayIconClick(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure JvTrayIconDblClick(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure PopupMenuPopup(Sender: TObject);
    procedure PmnuDesktopPopup(Sender: TObject);
    procedure MnuGotoAppliClick(Sender: TObject);
    procedure MnuBringAppliHereClick(Sender: TObject);
    procedure MnuSendToClick(Sender: TObject);
    procedure MnuWindowListClick(Sender: TObject);
    procedure MnuUnknownWindowListClick(Sender: TObject);
    procedure MnuLanguageClick(Sender: TObject);
    procedure MnuConfigurationClick(Sender: TObject);
    procedure MnuHelpClick(Sender: TObject);
    procedure MnuAboutClick(Sender: TObject);
    procedure MnuExitClick(Sender: TObject);
    procedure TmrSwitchDeskTimer(Sender: TObject);
    procedure TmrUpdateTimer(Sender: TObject);
    
  private
    { Dclarations prives }
    BitDesktop: TBitmap;       // to draw pager desk on a buffer
    StartDown: comp;           // time in milliseconds when mouse start to be
                               // down in our form
    StartX: integer;           // mouse X position
    StartY: integer;           // mouse Y position
    MoveMainForm: boolean;     // did we move the form
    LeftClick: boolean;        // was the left mouse button clicked
    MouseDownDelay: cardinal;  // for how long the mouse is down in the screen
    StartTimeDelay: cardinal;  // time at which we start to count for a delay
    ExpectedSwitching: integer;// -2 for desk border or -1 for none or desk number
    AutoSwitching: boolean;    // we are switching desktop automatically
//    MousePos: TPoint;          // mouse position
    procedure ShowDeskName;
    procedure ChangeTrayIconHint;
    procedure GotoDesk(ADeskNumber: integer; Mode: byte);
    procedure WMHotKey(var Msg: TWMHotKey); message WM_HOTKEY;
    procedure ApplyConfig(FirstTime: boolean);
    procedure ClearSubMenu(AnIndex: integer);
    procedure BuildSubMenus;
    procedure BuildSendToSubMenus;
    procedure BuildLanguageMenu;
    procedure BuildPmnuDesktop;
    function WindowsDeskBorder(AMousePos: TPoint; ADeskArea: TRect): byte;
    function PagerDeskNumber(X,Y: integer; PagerCoord: boolean): smallint;
    function SwitchFromDeskBorder(AMousePos: TPoint; ADeskArea: TRect;
      ADirection: byte): boolean;
    procedure SwitchFileFromPager(ADeskNumber: smallint; ADeskArea: TRect);
    procedure SwitchWindowFromPager(AHandle: THandle; AMousePos: TPoint;
      ADeskNumber: smallint; ADeskArea: TRect);
    function SwitchFromPager(AMousePos: TPoint; ADeskNumber: smallint;
      ADeskArea: TRect): boolean;
    function ConvertScreenToPager(AHandle: THandle; ADesk: byte): TPoint;
//    procedure DrawAnIcon(ACanvas: TCanvas; AHandle: THandle; ADesk: byte);
//    procedure DrawIcons(ACanvas: TCanvas);
  public
    { Dclarations publiques }
  end;

var
  FrmMain: TFrmMain;

implementation

{$R *.dfm}

uses
  JVDutil, JVDdata, JVDwutil, JVDwmng, JVDlng,
{$IFDEF TESTING}
  JVDwin,
{$ENDIF}
  JVDabout, JVDcfg, JVDname;

{*****************************************************************************}
{ Public function                                                             }
{*****************************************************************************}

{*****************************************************************************}
{ Form management                                                             }
{*****************************************************************************}

procedure TFrmMain.FormCreate(Sender: TObject);
var
  X, Y: integer;
begin
  // Store the main form handle
  MainFormHandle:= Handle;
  // Recover windows which could have been lost by application crash
  RecoverLostWindows;
  // Accept dropped items
  DragAcceptFiles(handle, true);
  // Get directories
  GetDirectories;
  // Create pager drawing desk buffer
  BitDesktop:= TBitmap.Create;
  // Create a window manager
  WindowsManager:= TWindowsManager.Create;
  WindowsManager.MaxDesktop:= MaxDesk;
  // Create configuration storage
  Config:= TConfig.create;
  // Load configuration
  Config.LoadFromFile(ConfigFilename);
  // Set pager position if remember position is set
  if Config.RememberPos then
  begin
    Config.LoadPagerPos(ConfigFilename,X,Y);
    Left:= X;
    Top:= Y;
  end;
  // Create default language file if needed
  if not ExistLanguage(RefLng) then CreateLanguageFile;
  if Config.Language = '' then Config.Language:= RefLng;
  // Build language menu
  BuildLanguageMenu;
  // Set default value
  AutoSwitching:= false;
  StartTimeDelay:= 0;
  ExpectedSwitching:= -1;
  // Apply configuration
  ApplyConfig(true);
{$IFDEF TESTING}
  MnuWindowList.Visible:= true;
  MnuUnknownWindowList.Visible:= true;
  MnuDiv2.Visible:= true;
{$ENDIF}
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.FormShow(Sender: TObject);
begin
  // Hide from the task bar
  ShowWindow(Application.Handle,SW_HIDE);
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  // Save pager position if remember position is set
  if Config.RememberPos then
    Config.SavePagerPos(ConfigFilename,Left,Top);
  Config.SaveLanguage(ConfigFilename);
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  // Free configuration
  Config.Free;
  TmrUpdate.Enabled:= false;
  // Free windows manager
  WindowsManager.Free;
  // Free pager drawing buffer
  BitDesktop.Free;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.FormPaint(Sender: TObject);
var
  ARect: TRect;
  HPos: integer;
  VPos: integer;
  M, N: byte;
begin
  // Draw desk on buffer
  with BitDesktop do
  begin
    // Clear
    ARect:= Rect(0,0,Width, Height);
    Canvas.Brush.Style:= bsSolid;
    Canvas.Brush.Color:= Config.InactiveDeskColor;
    Canvas.FillRect(ARect);
    // Draw active desk
    Canvas.Brush.Color:= Config.ActiveDeskColor;
    HPos:= (WindowsManager.CurrDesktop + 1) mod Config.NbHDesk;
    if HPos = 0 then HPos:= Config.NbHDesk;
    HPos:= (HPos - 1) * Config.PagerDeskWidth;
    VPos:= (WindowsManager.CurrDesktop div Config.NbHDesk) + 1;
    if VPos = 0 then VPos:= Config.NbVDesk;
    VPos:= (VPos - 1) * Config.PagerDeskHeight;
    Canvas.FillRect(Rect(HPos,VPos,HPos + Config.PagerDeskWidth,VPos +
      Config.PagerDeskHeight));
    // Draw grid
    Canvas.Pen.Color:= clBtnText;
    for N:= 0 to Config.NbHDesk do
    begin
      Canvas.MoveTo(N * Config.PagerDeskWidth,0);
      Canvas.LineTo(N * Config.PagerDeskWidth,Height);
    end;
    for N:= 0 to Config.NbVDesk do
    begin
      Canvas.MoveTo(0, N * Config.PagerDeskHeight);
      Canvas.LineTo(Width, N * Config.PagerDeskHeight);
    end;
    // Draw desk number
    Canvas.Font.Name:= 'Courrier New';
    Canvas.Font.Size:= Config.PagerDeskHeight div 2;
    Canvas.Brush.Style:= bsDiagCross;
    for M:= 0 to Config.NbVDesk do
    begin
      for N:= 0 to Config.NbHDesk do
      begin
        Canvas.TextOut((N*Config.PagerDeskWidth)+ 2,
          (M*Config.PagerDeskHeight),
          IntToStr(M*Config.NbHDesk + N + 1));
      end;
    end;

  end;
  // Display buffer
  Canvas.CopyRect(Rect(0,0,ClientWidth,ClientHeight),BitDesktop.Canvas,ARect);
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.FormMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  StartDown:= TimeStampToMsecs(DateTimeToTimeStamp(Time));
  StartX:= X;
  StartY:= Y;
  MoveMainForm:= false;
  LeftClick:= (ssLeft in Shift);
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.FormMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
const
  SC_DragMove = $F012;
var
  TmpTime: comp;
begin
  if ssLeft in Shift then
  begin
    TmpTime:= TimeStampToMsecs(DateTimeToTimeStamp(Time));
    if (TmpTime - StartDown) > 100 then
    // too long to be just a click
    begin
      if ((X <> StartX) or (Y <> StartY)) then
      begin
        MoveMainForm:= true;
        ReleaseCapture;
        Perform(WM_SysCommand, SC_DragMove, 0);
      end;
    end;
  end;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.FormMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var
  ADeskNumber: smallint;
begin
  if LeftClick and (not MoveMainForm) and (not AutoSwitching) then
  // Click on another desk
  begin
    ADeskNumber:= PagerDeskNumber(X,Y,true);
    if ADeskNumber <> -1 then GotoDesk(ADeskNumber, Gtd_MouseClick);
  end;
  StartTimeDelay:=0;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.JvTrayIconClick(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  // Only on left click
  if (Button = mbLeft) then
  begin
    // Bring back the pager if it has been hiden (by the taskbar for example)
    BringToFront;
    // Show desktop selection pop up menu
    PmnuDesktop.Popup(X,Y);
  end;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.JvTrayIconDblClick(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  ChangeTrayIconHint;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.PopupMenuPopup(Sender: TObject);
var
  SendToTitle: string;
  MainWindowHandle: THandle;
begin
  // Clear menus
  ClearSubMenu(GotoAppliMnuIndex);
  ClearSubMenu(BringHereMnuIndex);
  ClearSubMenu(SendToMnuIndex);
  // Update windows list
  WindowsManager.RefreshWindowList;
  // Build menus
  BuildSubMenus;
  BuildSendToSubMenus;
  // Show or hide Send Application To item
  MainWindowHandle:= GetWindowMainParent(WindowsManager.ActiveHandle);
  SendToTitle:= GetWindowTitle(MainWindowHandle);
  if IsValideWindow(MainWindowHandle) then
  begin
    PopupMenu.Items[SendToMnuIndex].Caption:=
      Format(GetMsg(112),[SendToTitle]);
    PopupMenu.Items[SendToMnuIndex].Visible:= true;
  end
  else PopupMenu.Items[SendToMnuIndex].Visible:= false;
{$IFDEF TESTING}
  PopupMenu.Items[UnmanagedMnuIndex].Caption:= IntToStr(WindowsManager.ActiveHandle);
{$ENDIF}  
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.PmnuDesktopPopup(Sender: TObject);
var
  N: integer;
begin
  // Check current desktop
  if PmnuDesktop.Items.Count > 0 then
  begin
    for N:= PmnuDesktop.Items.Count-1 downto 0 do
      PmnuDesktop.Items[N].Checked:= N = WindowsManager.CurrDesktop;
  end;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.MnuGotoAppliClick(Sender: TObject);
// Goto the desk corresponding to the selected application
var
  AMenuItem: TMenuItem;
begin
  AMenuItem:= (Sender as TMenuItem);
  if AMenuItem.Tag <> -1 then
    GotoDesk(AMenuItem.Tag,Gtd_Menu);
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.MnuBringAppliHereClick(Sender: TObject);
// Bring the corresponding application to the current desktop
var
  AMenuItem: TMenuItem;
begin
  TmrUpdate.Enabled:= false;
  AMenuItem:= (Sender as TMenuItem);
  if AMenuItem.Tag <> -1 then
    WindowsManager.BringToDesk(AMenuItem.Tag, WindowsManager.CurrDesktop);
  TmrUpdate.Enabled:= true;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.MnuSendToClick(Sender: TObject);
// Send the corresponding application to a new desktop
var
  AMenuItem: TMenuItem;
begin
  TmrUpdate.Enabled:= false;
  AMenuItem:= (Sender as TMenuItem);
  if AMenuItem.Tag <> -1 then
    WindowsManager.BringToDesk(WindowsManager.ActiveHandle, AMenuItem.Tag);
  TmrUpdate.Enabled:= true;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.MnuWindowListClick(Sender: TObject);
// Display list of visible windows
begin
{$IFDEF TESTING}
  WindowsManager.UpdateActiveHandle;
  with TFrmWindowList.Create(Application) do
    try
      Showmodal;
    finally
      Free;

    end;
  WindowsManager.ShowActiveWindow;
{$ENDIF}
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.MnuUnknownWindowListClick(Sender: TObject);
// Spare for debugging
begin
  RecoverLostWindows;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.MnuLanguageClick(Sender: TObject);
// Change language
var
  ALanguage: string;
  APos: integer;
begin
  with Sender as TMenuItem do
  begin
    ALanguage:= ClearShortcutText(Caption);
    with PopUpMenu.Items[LanguageMnuIndex] do
    begin
      for APos:= 1 to Count do
        Items[APos-1].Checked:= false;
    end;
    Checked:= true;
    LoadLanguage(ALanguage);
    Config.Language:= ALanguage;
    // Change things affected by language
    Hint:= GetMsg(111);
    ChangeTrayIconHint;
    BuildPmnuDesktop;
  end;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.MnuConfigurationClick(Sender: TObject);
// Display configuration window
var
  OldLastDesk: byte;
  NewLastDesk: byte;
begin
  // Last desk before configuration change
  OldLastDesk:= Config.LastDesk;
  // configuration change
  with TFrmConfig.Create(Application) do
    try
      Showmodal;
    finally
      Free;
    end;
  // Apply change
  ApplyConfig(false);
  // Last desk after configuration change
  NewLastDesk:= Config.LastDesk;
  // Bring all windows from removed desk to the current one
  if NewLastDesk < OldLastDesk then
  begin
    TmrUpdate.Enabled:= false;
    WindowsManager.BringHigherDeskTo(NewLastDesk);
    TmrUpdate.Enabled:= true;
  end;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.MnuHelpClick(Sender: TObject);
const
  HELP_TAB=15;
  CONTENTS_ACTIVE=-3;
begin
  Application.HelpCommand(HELP_TAB,CONTENTS_ACTIVE);
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.MnuAboutClick(Sender: TObject);
// Display about box
begin
  with TFrmAbout.Create(Application) do
    try
      Showmodal;
    finally
      Free;
    end;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.MnuExitClick(Sender: TObject);
begin
  Close;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.TmrSwitchDeskTimer(Sender: TObject);
// Manage desktop switching by dragging file to pager, window to pager,
// window to desktop border
var
  State: smallint;
  DeskArea: TRect;
  Direction: byte;
  DeskNumber: smallint;
  MousePos: TPoint;
  Switched: boolean;
begin
  Switched:= false;
  if not MoveMainForm then
  begin
    // Check if mouse is down
    if GetSystemMetrics(SM_SWAPBUTTON) = 1 then // right and left mouse button have been swapped
      State:= GetAsyncKeyState(VK_RBUTTON)
    else
      State:= GetAsyncKeyState(VK_LBUTTON);
    if (State and $8000) = $8000 then inc(MouseDownDelay,TmrSwitchDesk.Interval)
                                 else MouseDownDelay:= 0;

    if MouseDownDelay >= 1000 then
    // more than 1 seconde down so we are dragging something
    begin
      TmrSwitchDesk.Enabled:= false;
      GetCursorPos(MousePos);
      DeskArea:= GetDeskArea;
      Direction:= WindowsDeskBorder(MousePos,DeskArea);
      // On windows desk border ?
      if Direction > 0 then
      begin
        if ExpectedSwitching <> -2 then
        begin
          // Change switching mode
          ExpectedSwitching:= -2;
          StartTimeDelay:= GetTickCount;
        end
        else
        begin
          if Config.BorderSwitching then
            Switched:= SwitchFromDeskBorder(MousePos,DeskArea,Direction)
          else
            StartTimeDelay:= 0;
        end;
      end
      else
      begin
        DeskNumber:= PagerDeskNumber(MousePos.X,MousePos.Y,false);
        // On the same pager ?
        if (DeskNumber > -1) then
        begin
          if ExpectedSwitching <> DeskNumber then
          begin
            // Change switching mode
            ExpectedSwitching:= DeskNumber;
            StartTimeDelay:= GetTickCount;
          end
          else
            if Config.PagerSwitching then
              Switched := SwitchFromPager(MousePos,DeskNumber,DeskArea)
            else
              StartTimeDelay:= 0;
        end
        else ExpectedSwitching:= -1;
      end;
      if Switched then
      begin
        // Reset
        MouseDownDelay:= 0;
        StartTimeDelay:= 0;
        ExpectedSwitching:= -1;
      end;
      TmrSwitchDesk.Enabled:= true;
    end;
  end;
end;

{*****************************************************************************}
{ Private function                                                            }
{*****************************************************************************}

procedure TFrmMain.ShowDeskName;
// Display a form with desktop name
begin
  FrmDeskName.Hide;
  if Config.HotKeys.DeskName[WindowsManager.CurrDesktop] <> '' then
    FrmDeskName.Caption:= Config.HotKeys.DeskName[WindowsManager.CurrDesktop]
  else
    FrmDeskName.Caption:= GetMsg(026) + ' ' + IntToStr(WindowsManager.CurrDesktop+1);
  FrmDeskName.Show;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.ChangeTrayIconHint;
// Change the tray icon hint to display desktop name
var
  IPs: TStrings;
  HintText: string;
  N: byte;
begin
  IPs:= GetIpAddress;
  HintText:= '';
  for N:= 0 to (IPs.Count - 1) do
    HintText:= HintText + 'IP - ' +Ips[N] + #13 + #10;

  if Config.HotKeys.DeskName[WindowsManager.CurrDesktop] <> '' then
    JvTrayIcon.Hint:= HintText + Config.HotKeys.DeskName[WindowsManager.CurrDesktop] +
      ' (' + IntToStr(WindowsManager.CurrDesktop+1) + ')' + #13#10 + GetMsg(111)
  else
    JvTrayIcon.Hint:= HintText + GetMsg(026) +' ' + IntToStr(WindowsManager.CurrDesktop+1)
      + #13#10 + GetMsg(111);
end;

{------------------------------------------------------------------------------}
procedure TFrmMain.GotoDesk(ADeskNumber: integer; Mode: byte);
// Change desk (DeskNumber is 0 based)
var
  NewDesk: byte;
  UpdateActivate: boolean;
begin
  UpdateActivate:= TmrUpdate.Enabled = true;
  if UpdateActivate then TmrUpdate.Enabled:= false;
  // Hot key direct access to desk number xx
  if Mode in [Gtd_HotKey, Gtd_MouseClick, Gtd_Timer, Gtd_Menu] then
  begin
    NewDesk:= ADeskNumber;
    if ADeskNumber < 0 then NewDesk:= WindowsManager.CurrDesktop;
    if ADeskNumber > Config.LastDesk then NewDesk:= WindowsManager.CurrDesktop;
  end
  else
    // Move from desk to desk
    NewDesk:= Config.AdaptDeskNumber(ADeskNumber,WindowsManager.CurrDesktop);
  if NewDesk <> WindowsManager.CurrDesktop then
  begin
    WindowsManager.MoveToDesktop(NewDesk);
    // Repaint pager
    if not Config.HidePager then
    begin
      Sleep(25);
      FormPaint(self);
//      if Config.IconOnPager then DrawIcons(Image1.Canvas);
    end;
    // Show the desk name
    ShowDeskName;
    // Change tray icon hint
    ChangeTrayIconHint;
    // Bring back the active form on that desk
    if Mode in [Gtd_HotKey, Gtd_MouseClick, Gtd_Switch, Gtd_Menu] then
      WindowsManager.ShowActiveWindow;
  end;
  BringToFront;
  // Bring on top of all windows
  SetWindowPos(Handle, Hwnd_TopMost, Left, Top, Width, Height,SWP_NOSIZE + SWP_NOSENDCHANGING);
  if UpdateActivate then TmrUpdate.Enabled:= true;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.WMHotKey(var Msg: TWMHotKey);
// manage hotkey action
var
  DeskNumber: byte;
begin
  case Msg.HotKey of
    PrevDeskHKId     : GotoDesk(WindowsManager.CurrDesktop-1, Gtd_Switch);                // desktop -1
    NextDeskHKId     : GotoDesk(WindowsManager.CurrDesktop+1, Gtd_Switch);                // desktop +1
    DeskUpHKId       : GotoDesk(WindowsManager.CurrDesktop - Config.NbHDesk, Gtd_Switch); // desktop up
    DeskDownHKId     : GotoDesk(WindowsManager.CurrDesktop + Config.NbHDesk, Gtd_Switch); // desktop down
    ToggleStickyHKId : begin
                         WindowsManager.UpdateActiveHandle;
                         WindowsManager.ToggleStickyWindow;
                       end;
  else
    if (Msg.HotKey >= 1000) then
    begin
      DeskNumber:= Msg.HotKey - 1000 ;            // desktop number xx
      GotoDesk(DeskNumber, Gtd_HotKey);
    end;
  end;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.ApplyConfig(FirstTime: boolean);
var
  DoIt: boolean;
  N: integer;
begin
  DoIt:= true;
  // Set pager size
  ClientWidth:= Config.PagerDeskWidth * Config.NbHDesk + 1;
  ClientHeight:= Config.PagerDeskHeight * Config.NbVDesk + 1;
  // Set pager drawing desk buffer size
  BitDesktop.Width:= ClientWidth;
  BitDesktop.Height:= ClientHeight;
  // Set pager visibility
  Visible:= not Config.HidePager;
  // Change current desk if needed
  if WindowsManager.CurrDesktop > Config.LastDesk then
    WindowsManager.CurrDesktop:= Config.LastDesk;
  // Set hide from task bar
  WindowsManager.HideFromTaskBar:= Config.HideApplication;
  // Only the first time
  if FirstTime then
  begin
    // SetLanguage
    LoadLanguage(Config.Language);
    with PopUpMenu.Items[LanguageMnuIndex]do
    begin
      for N:= 0 to pred(Count) do
      begin
        if ClearShortcutText(Items[N].Caption) = Config.Language then
           Items[N].Checked:= true
        else Items[N].Checked:= false;
      end;
    end;
    // Change tray icon hint
    ChangeTrayIconHint;
    // Restore application
    if (Config.RestoreAppli and FileExists(LocationFilename)) then
    begin
      if Config.AskRestore then DoIt:=
        MessageDlg(GetMsg(0110),
        mtConfirmation,[mbYes, mbNo],0) = mrYes;
      if DoIt then
      begin
        TmrUpdate.Enabled:= false;
        WindowsManager.LoadLocation(LocationFilename);
        TmrUpdate.Enabled:= true;
      end;
    end;
  end;
  // Build desktop selection popup menu
  BuildPmnuDesktop;
  // Force redrawing
  Refresh;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.ClearSubMenu(AnIndex: integer);
// Clear the sub menu corresponding to that item index in the popup menu
var
  N: integer;
begin
  if PopupMenu.Items[AnIndex].Count > 0 then
  begin
    for N:= PopupMenu.Items[AnIndex].Count-1 downto 0 do
      PopupMenu.Items[AnIndex].Items[N].Free;
  end;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.BuildSubMenus;
// Build the sub menu 'Goto application' and 'Bring application here'
var
  N: integer;
  AWindow: TWindow;
  AMenuItem: TMenuItem;
  ATitle: string;
begin
  if WindowsManager.MainWindowCount > 0 then
  begin
    for N:= 0 to (WindowsManager.MainWindowCount-1) do
    begin
      // Get window information
      AWindow:= WindowsManager.GetMainWindow(N);
      if (AWindow.Desktop <> WindowsManager.CurrDesktop) then
      begin
        ATitle:= IntToStr(AWindow.Desktop + 1) + ' - ';
        ATitle:= ATitle + GetWindowTitle(AWindow.Handle);
        // Goto application sub menu
        AMenuItem:= TMenuItem.Create(PopupMenu);
        AMenuItem.Caption:= ATitle;
        AMenuItem.Tag:= AWindow.Desktop;
        AMenuItem.OnClick:= MnuGotoAppliClick;
        PopupMenu.Items[GotoAppliMnuIndex].Add(AMenuItem);
        // Bring application here sub menu
        AMenuItem:= TMenuItem.Create(PopupMenu);
        AMenuItem.Caption:= ATitle;
        AMenuItem.Tag:= AWindow.Handle;
        AMenuItem.OnClick:= MnuBringAppliHereClick;
        PopupMenu.Items[BringHereMnuIndex].Add(AMenuItem);
      end;
    end;
  end;
  // Enable Goto application submenu
  PopupMenu.Items[GotoAppliMnuIndex].Enabled:=
    PopupMenu.Items[GotoAppliMnuIndex].Count > 0;
  // Enable bring application here submenu
  PopupMenu.Items[BringHereMnuIndex].Enabled:=
    PopupMenu.Items[BringHereMnuIndex].Count > 0;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.BuildSendToSubMenus;
// Build the send application to menu
var
  N: integer;
  AMenuItem: TMenuItem;
  ATitle: string;
begin
  for N:= 0 to Config.LastDesk do
  begin
    if Config.HotKeys.DeskName[WindowsManager.CurrDesktop] <> '' then
      ATitle:= IntToStr(N + 1) + ' - ' + Config.HotKeys.DeskName[N]
    else
      ATitle:= GetMsg(026)+ ' ' + IntToStr(N + 1);
    AMenuItem:= TMenuItem.Create(PopupMenu);
    AMenuItem.Caption:= ATitle;
    AMenuItem.Tag:= N;
    AMenuItem.OnClick:= MnuSendToClick;
    PopupMenu.Items[SendToMnuIndex].Add(AMenuItem);
  end;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.BuildLanguageMenu;
// Build the language menu
var
  ASearchRec: TSearchRec;
  AText: string;
  Number: integer;
  AMenuItem: TMenuItem;
begin
  Number:= 0;
  if FindFirst(AppliDir + '*' + LngExt, faAnyFile, ASearchRec) = 0 then
  begin
    ClearSubMenu(LanguageMnuIndex);
    inc(Number);
    AText:= ExtractFileName(ASearchRec.Name);
    AText:= copy(AText,1,length(AText)- length(LngExt));
    AText:= FirstUpperText(AText);
    // Add sub menu
    AMenuItem:= TMenuItem.Create(PopupMenu);
    AMenuItem.Caption:= AText;
    AMenuItem.OnClick:= MnuLanguageClick;
    PopupMenu.Items[LanguageMnuIndex].Add(AMenuItem);
    // Find next language
    while FindNext(ASearchRec) = 0 do
    begin
      inc(Number);
      AText:= ExtractFileName(ASearchRec.Name);
      AText:= copy(AText,1,length(AText)-4);
      AText:= FirstUpperText(AText);
      // Add sub menu
      AMenuItem:= TMenuItem.Create(PopupMenu);
      AMenuItem.Caption:= AText;
      AMenuItem.OnClick:= MnuLanguageClick;
      PopupMenu.Items[LanguageMnuIndex].Add(AMenuItem);
    end;
  end;
  with PopUpMenu.Items[LanguageMnuIndex] do
    if Number < 2 then Visible:= false
                  else Visible:= true;
  if Number=0 then CreateLanguageFile;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.BuildPmnuDesktop;
// Build the popup menu with the different desktop
var
  N: integer;
  AMenuItem: TMenuItem;
begin
  // Clear all items
  if PmnuDesktop.Items.Count > 0 then
  begin
    for N:= PmnuDesktop.Items.Count-1 downto 0 do
      PmnuDesktop.Items[N].Free;
  end;
  // Add items
  for N:= 0 to Config.LastDesk do
  begin
    AMenuItem:= TMenuItem.Create(PopupMenu);
    if Config.HotKeys.DeskName[WindowsManager.CurrDesktop] <> '' then
      AMenuItem.Caption:= IntToStr(N + 1) + ' - ' + Config.HotKeys.DeskName[N]
    else
      AMenuItem.Caption:= GetMsg(112) + ' ' + IntToStr(N+1);
    AMenuItem.Tag:= N;
    AMenuItem.Checked:= N = WindowsManager.CurrDesktop;
    AMenuItem.OnClick:= MnuGotoAppliClick;
    PmnuDesktop.Items.Add(AMenuItem);
  end;
end;

{------------------------------------------------------------------------------}

function TFrmMain.WindowsDeskBorder(AMousePos: TPoint; ADeskArea: TRect): byte;
// Return 0 if not on a windows desk border
// 1 = left, 2 = right, 3 = top, 4 = bottom
begin
  if AMousePos.X <= ADeskArea.Left then result:= 1
  else
  if AMousePos.X >= (ADeskArea.Right - 1) then result:= 2
  else
  if AMousePos.Y <= ADeskArea.Top then result:= 3
  else
  if AMousePos.Y >= (ADeskArea.Bottom - 1) then result:= 4
  else
  result:= 0;
end;

{------------------------------------------------------------------------------}

function TFrmMain.PagerDeskNumber(X, Y: integer;
  PagerCoord: boolean): smallint;
// Return -1 if not on pager, desk number if on pager
var
  RelativeX: integer;
  RelativeY: integer;
begin
  // Convert to pager coordinate if needed
  if not PagerCoord then
  begin
    X:= X - Left;
    Y:= Y - Top;
  end;
  // Compute desk number if on pager
  if (X >= 0) and (X < Width) and (Y >= 0) and (Y < Height) then
  begin
    RelativeX:= (X div Config.PagerDeskWidth) + 1;
    RelativeY:= (Y div Config.PagerDeskHeight) + 1;
    result:= (RelativeY - 1) * Config.NbHDesk + RelativeX - 1;
    if ((result < 0) or (result > Config.LastDesk)) then result:= -1;
  end
  else result:= -1;
end;

{------------------------------------------------------------------------------}

function TFrmMain.SwitchFromDeskBorder(AMousePos: TPoint;
  ADeskArea: TRect; ADirection: byte): boolean;
const
  BorderSafe = 10; // To prevent new desk border detection
var
  DeskWidth: integer;
  DeskHeight: integer;
  AHandle: THandle;
  NewDesk: integer;
  WindowPos: TRect;
  NewLeft: integer;
  NewTop: integer;
begin
  Result:= false;
  if Config.BorderSwitching then
  begin
    // More than 0.5 seconde on the same desk border so switch
    if (GetTickCount - StartTimeDelay) >= 500 then
    begin
      // Get window under mouse
      AHandle:= WindowFromPoint(AMousePos);
      // Visible and not JVDesk
      if (IsWindowVisible(AHandle) and (AHandle <> MainFormHandle))then
      begin
        // Active window or windows desk
        if ((AHandle = WindowsDeskHandle)
          or (AHandle = WindowsManager.ActiveHandle)) then
        begin
          AutoSwitching:= true;
          // Windows desk available width and height
          DeskWidth:= ADeskArea.Right - ADeskArea.Left;
          DeskHeight:= ADeskArea.Bottom - ADeskArea.Top;
          // Compute new desk number and mouse position
          NewDesk:= WindowsManager.CurrDesktop;
          case ADirection of
            1: begin
                 NewDesk:= WindowsManager.CurrDesktop - 1;
                 AMousePos.X:= AMousePos.X + DeskWidth - BorderSafe;
               end;
            2: begin
                 NewDesk:= WindowsManager.CurrDesktop + 1;
                 AMousePos.X:= AMousePos.X - DeskWidth + BorderSafe;
               end;
            3: begin
                 NewDesk:= WindowsManager.CurrDesktop - Config.NbHDesk;
                 AMousePos.Y:= AMousePos.Y + DeskHeight - BorderSafe;
               end;
            4: begin
                 NewDesk:= WindowsManager.CurrDesktop + Config.NbHDesk;
                 AMousePos.Y:= AMousePos.Y - DeskHeight + BorderSafe;
               end;
          end;
          NewDesk:= Config.AdaptDeskNumber(NewDesk,WindowsManager.CurrDesktop);

          if NewDesk <> WindowsManager.CurrDesktop then
          begin
            // We have to change desktop
            if (AHandle <> WindowsDeskHandle) then
            // Not Windows desk so have to move it
            begin
              // Compute new window position
              WindowPos:= GetWindowPos(AHandle);
              NewLeft:= WindowPos.Left;
              NewTop:= WindowPos.Top;
              case ADirection of
                1: NewLeft:= NewLeft + DeskWidth;
                2: NewLeft:= NewLeft - DeskWidth;
                3: NewTop:= NewTop + DeskHeight;
                4: NewTop:= NewTop - DeskHeight;
              end;
              // Move window
              with WindowPos do
                MoveWindow(AHandle,NewLeft,NewTop,Right-Left+1,Bottom-Top+1,true);
              // Move mouse
              SetCursorPos(AMousePos.X,AMousePos.Y);
              sleep(1);
              WindowsManager.BringToDesk(AHandle, NewDesk);
              // Change desktop
              GotoDesk(NewDesk, Gtd_Switch);
              WindowsManager.ChangeActiveHandle(AHandle);
            end
            else
            begin
              // On windows desk so move cursor and change desktop only
              SetCursorPos(AMousePos.X,AMousePos.Y);
              sleep(1);
              if (NewDesk <> WindowsManager.CurrDesktop) then
                GotoDesk(NewDesk, Gtd_MouseClick);
            end;
          end
          else beep;
          AutoSwitching:= false;
          Result:= true;
        end;
      end;
    end;
  end;
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.SwitchFileFromPager(ADeskNumber: smallint; ADeskArea: TRect);
begin
  // Move mouse to windows desk center and change desktop
  SetCursorPos((ADeskArea.Left + ADeskArea.Right) div 2,
    (ADeskArea.Top + ADeskArea.Bottom) div 2);
  GotoDesk(ADeskNumber, Gtd_MouseClick);
end;

{------------------------------------------------------------------------------}

procedure TFrmMain.SwitchWindowFromPager(AHandle: THandle; AMousePos: TPoint;
  ADeskNumber: smallint;  ADeskArea: TRect);
var
  DeltaX: integer;
  DeltaY: integer;
  WindowPos: TRect;
  NewLeft: integer;
  NewTop: integer;
begin
  WindowPos:= GetWindowPos(AHandle);
  DeltaX:= AMousePos.X - WindowPos.Left;
  DeltaY:= AMousePos.Y - WindowPos.Top;
  NewLeft:= ((ADeskArea.Left + ADeskArea.Right) div 2) -
    ((WindowPos.Right - WindowPos.Left) div 2);
  NewTop:= ((ADeskArea.Top + ADeskArea.Bottom) div 2) -
    ((WindowPos.Bottom - WindowPos.Top) div 2);
  // Move window
  with WindowPos do
    MoveWindow(AHandle,NewLeft,NewTop,Right-Left+1,Bottom-Top+1,true);
  // Move the mouse
  SetCursorPos(NewLeft + DeltaX,NewTop + DeltaY);
  sleep(1);
  WindowsManager.BringToDesk(AHandle, ADeskNumber);
  // Change desktop
  GotoDesk(ADeskNumber, Gtd_MouseClick);
  WindowsManager.ChangeActiveHandle(AHandle);
end;

{------------------------------------------------------------------------------}

function TFrmMain.SwitchFromPager(AMousePos: TPoint; ADeskNumber: smallint;
  ADeskArea: TRect): boolean;
begin
  Result:= false;
  // do it only if pager is visible and swiching from pager is allowed
  if (not Config.HidePager) and (Config.PagerSwitching) then
  begin
    // More than 0.5 seconde on the same pager desk so switch
    if (GetTickCount - StartTimeDelay) >= 500 then
    begin
      AutoSwitching:= true;
      if IsMouseOnWindow(WindowsManager.ActiveHandle) then
      // Window on pager
        SwitchWindowFromPager(WindowsManager.ActiveHandle,
          AMousePos, ADeskNumber, ADeskArea)
      else
        // File on pager
        SwitchFileFromPager(ADeskNumber, ADeskArea);
      AutoSwitching:= false;
      Result:= true;
    end;
  end;
end;

{------------------------------------------------------------------------------}

function TFrmMain.ConvertScreenToPager(AHandle: THandle; ADesk: byte): TPoint;
// Convert position on a real desktop to position in the pager
var
  HPos: integer;
  VPos: integer;
  TmpRect: TRect;
  DeskArea: TRect;
  DeskWidth: integer;
  DeskHeight: integer;
begin
  // Top left corner of concerned desk on pager (pager coordinate)
  HPos:= (ADesk + 1) mod Config.NbHDesk;
  if HPos = 0 then HPos:= Config.NbHDesk;
  HPos:= (HPos - 1) * Config.PagerDeskWidth;
  VPos:= (ADesk div Config.NbHDesk) + 1;
  if VPos = 0 then VPos:= Config.NbVDesk;
  VPos:= (VPos - 1) * Config.PagerDeskHeight;
  // Top left corner of concerned window (screen coordinate)
  TmpRect:= GetWindowPos(AHandle);
  // Windows desk available width and height
  DeskArea:= GetDeskArea;
  DeskWidth:= DeskArea.Right - DeskArea.Left;
  DeskHeight:= DeskArea.Bottom - DeskArea.Top;
  // Top left corner of concerned window (pager coordinate)
  result.X:= HPos + ((TmpRect.Left * Config.PagerDeskWidth) div DeskWidth);
  result.Y:= VPos + ((TmpRect.Top * Config.PagerDeskHeight) div DeskHeight);
end;

{------------------------------------------------------------------------------}
(*
procedure TFrmMain.DrawAnIcon(ACanvas: TCanvas; AHandle: THandle; ADesk: byte);
// Draw an icon on the pager
var
  TopLeft: TPoint;
  AnIcon: TIcon;
  N: integer;
  ABitmap: TBitmap;
  ARect: TRect;
begin
  //TopLeft:= ConvertScreenToPager(AHandle, ADesk);
  TopLeft.X:= 0;
  TopLeft.Y:= 0;
  N:= GetWindowIcon(AHandle,false);
  if N > 0 then
  begin
    AnIcon:= TIcon.Create;
    ABitmap:= TBitmap.Create;
    try
      AnIcon.Handle:= CopyIcon(N);
      ABitmap.Width:= AnIcon.Width;
      ABitmap.Height:= AnIcon.Height;
      ABitmap.TransparentMode := tmAuto;
      ABitmap.Canvas.Draw(0,0,AnIcon);

      ARect.TopLeft:= TopLeft;
      ARect.Right:= TopLeft.X + Image1.Width;
      ARect.Bottom:= TopLeft.Y + Image1.Height;
      ACanvas.CopyMode:= cmSrcCopy;
      ACanvas.StretchDraw(ARect,ABitmap);
      //ACanvas.Draw(0,0,AnIcon);
    finally
      ABitmap.Free;
      AnIcon.Free;
    end;
  end
  else beep;
//  ACanvas.Brush.Style:= bsSolid;
//  ACanvas.Brush.Color:= clRed;
//  ACanvas.FillRect(Rect(TopLeft.X,TopLeft.Y,TopLeft.X + 10,TopLeft.Y + 10));
end;
*)
{------------------------------------------------------------------------------}
(*
procedure TFrmMain.DrawIcons(ACanvas: TCanvas);
// Draw all icons on the pager
var
  N: integer;
////  AWindow: TAWindow;
begin
  if WindowsList.Count > 0 then
  begin
    for N:= 0 to (WindowsList.Count-1) do
    begin
      // Get window information
      AWindow:= WindowsList.GetItem(N);
      if ((AWindow.Desktop <> CurrDesk) and
        (not IsTaskBarButton(AWindow.Handle))) then
      begin
        DrawAnIcon(ACanvas,AWindow.Handle,AWindow.Desktop);
      end;
    end;
  end;
end;
*)
{------------------------------------------------------------------------------}

procedure TFrmMain.TmrUpdateTimer(Sender: TObject);
begin
  if not AutoSwitching then
  begin
    WindowsManager.UpdateActiveHandle;
  end;
end;

end.
