unit JVDlng;

/////////////////////////////////////////////////////////////////////////////
//                     Part of JVDesk project                              //
//                     Multiple desktop management                         //
//  2003  Main developper Alain JAFFRE         http://jack.r.free.fr       //
//                                                                         //
// Data management for that project                                        //
/////////////////////////////////////////////////////////////////////////////

{***************************************************************************}
{ Ce logiciel est un logiciel libre. Vous pouvez le diffuser et/ou le       }
{ modifier suivant les termes de la GNU General Public License telle que    }
{ publie par la Free Software Foundation, soit la version 2 de cette        }
{ license, soit ( votre convenance) une version ultrieure.                }
{                                                                           }
{ Ce programme est diffus dans l'espoir qu'il sera utile, mais SANS AUCUNE }
{ GARANTIE, sans mme une garantie implicite de COMMERCIALISABILITE ou      }
{ d'ADEQUATION A UN USAGE PARTICULIER. Voyez la GNU General Public License  }
{ pour plus de dtails.                                                     }
{                                                                           }
{ Vous devriez avoir reu une copie de la GNU General Public License avec   }
{ ce programme, sinon, veuillez crire  la Free Software Foundation, Inc., }
{ 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.                  }
{***************************************************************************}

{***************************************************************************}
{ This program is free software. You can redistribute it and/or modify it   }
{ under the terms of the GNU Public License as published by the             }
{ Free Software Foundation, either version 2 of the license, or             }
{ (at your option) any later version.                                       }
{                                                                           }
{ This program is distributed in the hope it will be useful, but WITHOUT    }
{ ANY WARRANTY, without even the implied warranty of MERCHANTABILITY or     }
{ FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for  }
{ more details.                                                             }
{                                                                           }
{ You should have received a copy of the GNU General Public License along   }
{ with this program, if not, write to the Free Software Foundation, Inc.,   }
{ 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.                  }
{***************************************************************************}

interface

const
  RefLng = 'english'; // Default language
  LngExt = '.lng';    // File extension used with language files
  HelpExt = '.hlp';   // File extension used with help files

  MaxMsg = 200;       // Maximum number of stored messages

var
  Msg: array[0..MaxMsg] of string;

  procedure CreateLanguageFile;
  function ExistLanguage(ALanguage: string): boolean;
  procedure LoadLanguage(ALanguage: string);
  function GetMsg(Num: longint): string;

implementation

uses
  Forms, SysUtils, JVDmain, JVDdata, JVDutil;

{*****************************************************************************}
{ Messages management                                                         }
{*****************************************************************************}

procedure ClearMsg;
// Clear all messages
var
  N: integer;
begin
  for N:= 0 to MaxMsg do Msg[N]:= '';
end;

{------------------------------------------------------------------------------}

procedure StoreMsg(ANumber: longint;AText: string);
// Store a new message in the list
begin
  Msg[ANumber]:= AText;
end;

{------------------------------------------------------------------------------}

function GetMsg(Num: longint): string;
begin
  result:= Msg[Num];
end;

{*****************************************************************************}
{ Language file creation                                                      }
{*****************************************************************************}

procedure CreateLanguageFile;
// Create the basic language file
var
  LngFile: textfile;
  LngFilename: TFilename;

  procedure CreateHeader;
  begin
    writeln(LngFile,'{----------------------------------------------------------------------------}');
    writeln(LngFile,'{ JVDesk language file                                                       }');
    writeln(LngFile,'{ Tested version: 0.5.0                                                      }');
    writeln(LngFile,'{ Language: English                                                          }');
    writeln(LngFile,'{                                                                            }');
    writeln(LngFile,'{ For other language, copy that file and rename it with the new language name}');
    writeln(LngFile,'{ but keep the lng extension                                                 }');
    writeln(LngFile,'{ Use only pure ASCII character for the file name                            }');
    writeln(LngFile,'{ Example: for french, the file will be francais.lng                         }');
    writeln(LngFile,'{                                                                            }');
    writeln(LngFile,'{ Lines starting by { are comments.                                          }');
    writeln(LngFile,'{ Do not modify before #.                                                    }');
    writeln(LngFile,'{ Tranlate all the text after #.                                             }');
    writeln(LngFile,'{ The & caracter is put just before the short key which will be used with Alt}');
    writeln(LngFile,'{ If you use apostrophe '', double it.                                        }');
    writeln(LngFile,'{----------------------------------------------------------------------------}');
  end;

  procedure CreatePopUpMenu;
  begin
    writeln(LngFile,'{----------------------------------------------------------------------------}');
    writeln(LngFile,'{ PopUp menu                                                                 }');
    writeln(LngFile,'{----------------------------------------------------------------------------}');
    writeln(LngFile,'0001#Right click for menu');
    writeln(LngFile,'0002#Goto application');
    writeln(LngFile,'0003#Bring application here');
    writeln(LngFile,'0004#Send application there');
    writeln(LngFile,'0005#Windows list');
    writeln(LngFile,'0006#Unmanaged windows');
    writeln(LngFile,'0007#Language');
    writeln(LngFile,'0008#Configuration');
    writeln(LngFile,'0009#Help');
    writeln(LngFile,'0010#About');
    writeln(LngFile,'0011#Exit');
  end;

  procedure CreateConfig;
  begin
    writeln(LngFile,'{----------------------------------------------------------------------------}');
    writeln(LngFile,'{ Configuration                                                              }');
    writeln(LngFile,'{----------------------------------------------------------------------------}');
    writeln(LngFile,'1000#Configuration');
    writeln(LngFile,'1001#&Ok');
    writeln(LngFile,'1002#&Cancel');
    writeln(LngFile,'{--------------------------------------}');
    writeln(LngFile,'1010#General');
    writeln(LngFile,'1011#Pager');
    writeln(LngFile,'1012#Number of desktops');
    writeln(LngFile,'1013#Pager desktop size');
    writeln(LngFile,'1014#Remember pager position');
    writeln(LngFile,'1015#Cycling');
    writeln(LngFile,'1016#None');
    writeln(LngFile,'1017#Line / Column (stay on the same)');
    writeln(LngFile,'1018#Full (Change line or column)');
    writeln(LngFile,'{---------------------------------------}');
    writeln(LngFile,'1020#Desktop hotkey');
    writeln(LngFile,'1021#Desktop -1');
    writeln(LngFile,'1022#Desktop +1');
    writeln(LngFile,'1023#Desktop up');
    writeln(LngFile,'1024#Desktop down');
    writeln(LngFile,'1025#Direct desktop jump hotkey');
    writeln(LngFile,'1026#Desktop');
    writeln(LngFile,'1027#Name');
    writeln(LngFile,'1028#Hotkey');
    writeln(LngFile,'{---------------------------------------}');
    writeln(LngFile,'1030#Pager');
    writeln(LngFile,'1031#Color');
    writeln(LngFile,'1032#Active desk');
    writeln(LngFile,'1033#Inactive desk');
    writeln(LngFile,'1035#Option');
    writeln(LngFile,'1036#Display application icon on pager desk');
    writeln(LngFile,'1037#Continuous pager refresh');
    writeln(LngFile,'{---------------------------------------}');
    writeln(LngFile,'1040#Options');
    writeln(LngFile,'10431#Toggle sticky status');
    writeln(LngFile,'1042#Start up');
    writeln(LngFile,'1043#Restore application on desk at start up');
    writeln(LngFile,'1044#Ask before restoring application');
    writeln(LngFile,'1045#Hide none visible application from task bar');
    writeln(LngFile,'{---------------------------------------}');
    writeln(LngFile,'1050#Launch program');
    writeln(LngFile,'1051#Program');
    writeln(LngFile,'1052#Desk');
    writeln(LngFile,'1053#Sticky');
    writeln(LngFile,'1054#Full path');
    writeln(LngFile,'{---------------------------------------}');
    writeln(LngFile,'1060#Switching');
    writeln(LngFile,'1061#Desk border switching');
    writeln(LngFile,'1062#Do switching from pager');
  end;

  procedure CreateWindowsList;
  begin
    writeln(LngFile,'{----------------------------------------------------------------------------}');
    writeln(LngFile,'{ Window list                                                                }');
    writeln(LngFile,'{----------------------------------------------------------------------------}');
    writeln(LngFile,'1070#Window list');
    writeln(LngFile,'1071#Refresh');
    writeln(LngFile,'1072#Title');
    writeln(LngFile,'1073#Parent');
    writeln(LngFile,'1074#Handle');
    writeln(LngFile,'1075#Pid');
    writeln(LngFile,'1076#Main');
    writeln(LngFile,'1077#Class name');
    writeln(LngFile,'1078#Status');
    writeln(LngFile,'1079#Desktop');
    writeln(LngFile,'1080#Left');
    writeln(LngFile,'1081#Top');
    writeln(LngFile,'1082#Right');
    writeln(LngFile,'1083#Bottom');
    writeln(LngFile,'1084#Active');
    writeln(LngFile,'1085#Sticky');
  end;

  procedure CreateUnmanagedWindow;
  begin
    writeln(LngFile,'{----------------------------------------------------------------------------}');
    writeln(LngFile,'{ Unmanaged window list                                                      }');
    writeln(LngFile,'{----------------------------------------------------------------------------}');
    writeln(LngFile,'1090#Application unmanaged window');
    writeln(LngFile,'1091#Show / hide');
    writeln(LngFile,'1092#Sort order');
    writeln(LngFile,'1093#Visible');
    writeln(LngFile,'1094#Pid');
    writeln(LngFile,'1095#Parent');
    writeln(LngFile,'1096#Handle');
    writeln(LngFile,'1097#Title');
    writeln(LngFile,'1098#Class');
    writeln(LngFile,'1099#Module');
  end;

  procedure CreateOthers;
  begin
    writeln(LngFile,'{----------------------------------------------------------------------------}');
    writeln(LngFile,'{ Others                                                                     }');
    writeln(LngFile,'{----------------------------------------------------------------------------}');
    writeln(LngFile,'1110#Do you want to restore application on their respective desk ?');
    writeln(LngFile,'1111#Right click for menu');
    writeln(LngFile,'1112#Send ''%s'' on');
  end;



begin
  LngFilename:= AppliDir + RefLng + LngExt;
  AssignFile(LngFile,LngFilename);
  rewrite(LngFile);

  CreateHeader;
  CreatePopUpMenu;
  CreateConfig;
  CreateWindowsList;
  CreateUnmanagedWindow;
  CreateOthers;
  closefile(LngFile);
end;

{*****************************************************************************}
{ Language file management                                                    }
{*****************************************************************************}

function ExistLanguage(ALanguage: string): boolean;
var
  LngFilename: TFilename;
begin
  LngFilename:= AppliDir + ALanguage + LngExt;
  result:= FileExists(LngFilename);
end;

{------------------------------------------------------------------------------}

procedure ParseLine(ALine: string; var ANumber: longint; var AText: string);
// Divide a line Number#Text into 2 different entities ANumber and AText
var
  N: integer;
begin
  N:= pos('#',ALine);
  if N <> 0 then
  begin
    ANumber:= StrToInt(copy(ALine,1,N-1));
    delete(ALine,1,N);
    AText:= ALine;
  end
  else
  begin
    ANumber:= 0;
    AText:= '';
  end;
end;

{------------------------------------------------------------------------------}

procedure ProcessLine(ALine: string);
// Process a line of a language file
var
  ANumber: longint;
  AText: string;
begin
  ParseLine(ALine,ANumber,AText);
  case ANumber of
    0001: FrmMain.Hint:= AText;
    0002: FrmMain.PopUpMenu.Items[GotoAppliMnuIndex].Caption:= AText;
    0003: FrmMain.PopUpMenu.Items[BringHereMnuIndex].Caption:= AText;
    0004: FrmMain.PopUpMenu.Items[WindowsListMnuIndex].Caption:= AText + ' ...';
    0005: FrmMain.PopUpMenu.Items[UnmanagedMnuIndex].Caption:= AText + ' ...';
    0006: FrmMain.PopUpMenu.Items[LanguageMnuIndex].Caption:= AText;
    0007: FrmMain.PopUpMenu.Items[ConfigMnuIndex].Caption:= AText + ' ...';
    0008: FrmMain.PopUpMenu.Items[HelpMnuIndex].Caption:= AText;
    0009: FrmMain.PopUpMenu.Items[AboutMnuIndex].Caption:= AText + ' ...';
    0010: FrmMain.PopUpMenu.Items[ExitMnuIndex].Caption:= AText;
  else
    if ANumber > 1000 then StoreMsg(ANumber mod 1000,AText);
  end;
end;

{------------------------------------------------------------------------------}

procedure LoadLanguage(ALanguage: string);
// Load the corresponding language for GUI and help
var
  ALine: string;
  LngFile: textfile;
  LngFilename: TFilename;
  HelpFilename: TFilename;
begin
  // Language file
  ALanguage:= LowerCaseText(ALanguage);
  if not ExistLanguage(ALanguage) then ALanguage:= RefLng;
  LngFilename:= AppliDir + ALanguage + LngExt;
  // Load language data
  AssignFile(LngFile,LngFilename);
  reset(LngFile);
  while not Eof(LngFile) do
  begin
    readln(LngFile,ALine);
    ALine:= trim(ALine);
    if ((ALine<>'') and (ALine[1]<>'{')) then  ProcessLine(ALine);
  end;
  closefile(LngFile);

  // Help file
  HelpFilename:= AppliDir + ALanguage + HelpExt;
  if FileExists(HelpFilename) then
  begin
    Application.HelpFile:= HelpFilename;
    FrmMain.PopupMenu.Items[HelpMnuIndex].Visible:= true;
  end
  else
  begin
    Application.HelpFile:= '';
    FrmMain.PopupMenu.Items[HelpMnuIndex].Visible:= false;
  end;
end;

end.
