unit JVDcfg;

/////////////////////////////////////////////////////////////////////////////
//                     Part of JVDesk project                              //
//                     Multiple desktop management                         //
//  2003  Main developper Alain JAFFRE         http://jack.r.free.fr       //
//                                                                         //
// Configuration window of that project                                    //
/////////////////////////////////////////////////////////////////////////////

{***************************************************************************}
{ Ce logiciel est un logiciel libre. Vous pouvez le diffuser et/ou le       }
{ modifier suivant les termes de la GNU General Public License telle que    }
{ publie par la Free Software Foundation, soit la version 2 de cette        }
{ license, soit ( votre convenance) une version ultrieure.                }
{                                                                           }
{ Ce programme est diffus dans l'espoir qu'il sera utile, mais SANS AUCUNE }
{ GARANTIE, sans mme une garantie implicite de COMMERCIALISABILITE ou      }
{ d'ADEQUATION A UN USAGE PARTICULIER. Voyez la GNU General Public License  }
{ pour plus de dtails.                                                     }
{                                                                           }
{ Vous devriez avoir reu une copie de la GNU General Public License avec   }
{ ce programme, sinon, veuillez crire  la Free Software Foundation, Inc., }
{ 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.                  }
{***************************************************************************}

{***************************************************************************}
{ This program is free software. You can redistribute it and/or modify it   }
{ under the terms of the GNU Public License as published by the             }
{ Free Software Foundation, either version 2 of the license, or             }
{ (at your option) any later version.                                       }
{                                                                           }
{ This program is distributed in the hope it will be useful, but WITHOUT    }
{ ANY WARRANTY, without even the implied warranty of MERCHANTABILITY or     }
{ FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for  }
{ more details.                                                             }
{                                                                           }
{ You should have received a copy of the GNU General Public License along   }
{ with this program, if not, write to the Free Software Foundation, Inc.,   }
{ 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.                  }
{***************************************************************************}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, JvEdit, JvSpin, ExtCtrls, Grids, ShellApi,
  FileCtrl, JvCombobox, JvColorCombo, Mask, JvMaskEdit, JvExStdCtrls,
  JvExMask;

type
  TFrmConfig = class(TForm)
    BtnOk: TButton;
    BtnCancel: TButton;
    PgConfig: TPageControl;
    TshGeneral: TTabSheet;
    GbxPager: TGroupBox;
    LblNbDesk: TLabel;
    LblNbDeskX: TLabel;
    JvSpinEditNbHDesk: TJvSpinEdit;
    JvSpinEditNbVDesk: TJvSpinEdit;
    TshDeskHotKey: TTabSheet;
    LblPreviousDesk: TLabel;
    LblNextDesk: TLabel;
    LblDeskUp: TLabel;
    LblDeskDown: TLabel;
    HkyPreviousDesk: THotKey;
    HkyNextDesk: THotKey;
    HkyDeskUp: THotKey;
    HkyDeskDown: THotKey;
    PnlDivide1: TPanel;
    RgrCycling: TRadioGroup;
    SbxHotKeys: TScrollBox;
    ChbRememberPos: TCheckBox;
    LblDirectHotKeys: TLabel;
    LblPagerDeskSize: TLabel;
    JvSpinEditDeskWidth: TJvSpinEdit;
    LblPagerDeskSizeX: TLabel;
    JvSpinEditDeskHeight: TJvSpinEdit;
    TshOptions: TTabSheet;
    GbxStartUp: TGroupBox;
    ChbRestoreAppli: TCheckBox;
    ChbAskRestore: TCheckBox;
    TshLaunchedPrg: TTabSheet;
    SGrLaunchedPrg: TStringGrid;
    CobDeskNumber: TComboBox;
    LblToggleSticky: TLabel;
    HkyToggleSticky: THotKey;
    ChbHidePager: TCheckBox;
    TshPager: TTabSheet;
    GbxPagerColor: TGroupBox;
    LblActiveDeskColor: TLabel;
    LblInactiveDeskColor: TLabel;
    JvColorCobInactiveDesk: TJvColorComboBox;
    JvColorCobActiveDesk: TJvColorComboBox;
    GbxPagerOption: TGroupBox;
    ChbIconOnPager: TCheckBox;
    ChbPagerRefresh: TCheckBox;
    TshSwitching: TTabSheet;
    ChbHideApplication: TCheckBox;
    ChbBorderSwitching: TCheckBox;
    LblDeskName: TLabel;
    LblDeskHotKey: TLabel;
    ChbPagerSwitching: TCheckBox;
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure PgConfigChange(Sender: TObject);
    procedure ChbRestoreAppliClick(Sender: TObject);
    procedure CobDeskNumberExit(Sender: TObject);
    procedure SGrLaunchedPrgKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure SGrLaunchedPrgSelectCell(Sender: TObject; ACol,
      ARow: Integer; var CanSelect: Boolean);
    procedure BtnOkClick(Sender: TObject);
    procedure BtnCancelClick(Sender: TObject);
    procedure JvSpinEditNbHDeskEnter(Sender: TObject);
    procedure JvSpinEditNbVDeskEnter(Sender: TObject);

  private
    { Dclarations prives }
    NbLaunchedPrg: integer;
    procedure WMDropFiles(var Mesg: TWMDropFiles); message WM_DROPFILES;
    procedure CMDialogKey(var Msg: TCMDialogKey); message CM_DIALOGKEY;
    procedure AddItemToSgrLaunchedPrg(AnItem,
      ADeskNumber,AStickyStatus: string);
    procedure RemoveItemFromSgrLaunchedPrg(AnIndex: integer);

    procedure CreateDirectHotKey;
    procedure GetConfiguration;
    procedure SetConfiguration;
    procedure AdaptLanguage;
  public
    { Dclarations publiques }

  end;

var
  FrmConfig: TFrmConfig;

implementation

{$R *.dfm}

uses
  JVDutil, JVDdata, JVDlng;

var
  LblHkDesk: array [0..MaxDesk] of TLabel;
  EdtHkDesk: array [0..MaxDesk] of TEdit;
  HkDesk: array [0..MaxDesk] of THotKey;

{*****************************************************************************}
{ Form management                                                             }
{*****************************************************************************}

procedure TFrmConfig.FormCreate(Sender: TObject);
begin
  // Accept dropped items
  DragAcceptFiles(handle, true);
  // Prepare launched program string grid
  NbLaunchedPrg:= 0;
  with SGrLaunchedPrg do
  begin
    DefaultRowHeight:= CobDeskNumber.Height;
    ColWidths[3]:= 0;  // make it not visible
    ColWidths[2]:= 20;
    ColWidths[1]:= CobDeskNumber.Width;
    ColWidths[0]:= SgrLaunchedPrg.Width - ColWidths[1] - ColWidths[2] - 22;
    FixedRows:= 1;
    Cells[0,0]:= GetMsg(0051);
    Cells[1,0]:= GetMsg(0052);
    Cells[2,0]:= GetMsg(0053);
    Cells[3,0]:= GetMsg(0054);
  end;
  // Prepare ComboBox
  with CobDeskNumber do
  begin
    Width:= 49;
    Visible:= false;
    Items.Clear;
  end;
  // Display the correct language
  AdaptLanguage;
end;

{------------------------------------------------------------------------------}

procedure TFrmConfig.FormShow(Sender: TObject);
begin
  PgConfig.ActivePage:= TshGeneral; // Be sure to be on the first tab
  CreateDirectHotKey;
  GetConfiguration;
end;

{------------------------------------------------------------------------------}

procedure TFrmConfig.PgConfigChange(Sender: TObject);
var
  N: byte;
  NbDesk: byte;  // Total number of desk
begin
  NbDesk:= round(JvSpinEditNbHDesk.Value) * round(JvSpinEditNbVDesk.Value);
  if PgConfig.ActivePage = TshDeskHotKey then
  begin
    for N:= 0 to MaxDesk do
    begin
      LblHkDesk[N].Visible:= N < NbDesk;
      EdtHkDesk[N].Visible:= N < NbDesk;
      HkDesk[N].Visible:= N < NbDesk;
    end;
  end;

  if PgConfig.ActivePage = TshLaunchedPrg then
  begin
    CobDeskNumber.Items.Clear;
    for N := 1 to NbDesk do
      CobDeskNumber.Items.Add(IntToStr(N));
  end;
end;

{------------------------------------------------------------------------------}

procedure TFrmConfig.ChbRestoreAppliClick(Sender: TObject);
begin
  ChbAskRestore.Enabled:= ChbRestoreAppli.Checked;
end;

{------------------------------------------------------------------------------}

procedure TFrmConfig.CobDeskNumberExit(Sender: TObject);
// Code from Peter Below on borland.public.delphi.vcl.components.using
begin
  with Sender as TComboBox do
  begin
    hide;
    if ItemIndex >=0 then
      with SGrLaunchedPrg do
        Cells[Col,Row]:= Items[ItemIndex];
  end;
end;

{------------------------------------------------------------------------------}

procedure TFrmConfig.SGrLaunchedPrgKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  with Sender as TStringGrid do
  begin
    if (Row <= NbLaunchedPrg) then
    // We are in a used row
    begin
      if (Key = VK_DELETE) then
      // Delete that row
      begin
        RemoveItemFromSgrLaunchedPrg(Row);
        Key:= 0;
      end;
      
      if (Key = VK_SPACE) and (Col = 2) then
      // Change Sticky status
      begin
        if (Cells[Col,Row]='0') then Cells[Col,Row]:= '1'
                                else Cells[Col,Row]:= '0'
      end;
    end;
  end;
end;

{------------------------------------------------------------------------------}

procedure TFrmConfig.SGrLaunchedPrgSelectCell(Sender: TObject; ACol,
  ARow: Integer; var CanSelect: Boolean);
// Code from Peter Below on borland.public.delphi.vcl.components.using
// Adjusted for my needs
var
  R: TRect;
begin
  with Sender as TStringGrid do
  begin
    if (ACol = 1) and (ARow >= FixedRows) and (Cells[0,ARow] <> '') then
    begin
      // Entered the column associated to the ComboBox
      // Get Grid out of selection mode
      perform(WM_CANCELMODE,0,0);
      // Position the control on the top of the cel
      R:= CellRect(ACol, ARow);
      R.Left:= R.Left + Left;
      R.Top:= R.Top + Top;
      R.Right:= R.Right + Left;
      R.Bottom:= R.Bottom + Top;
      with CobDeskNumber do
      begin
        SetBounds(R.Left + 2,R.Top + 2,R.Right - R.Left,Height);
        ItemIndex:= Items.IndexOf(Cells[ACol,ARow]);
        Show;
        BringToFront;
        // Focus the ComboBox and drop down
        SetFocus;
      end;
    end;
  end;
end;

{------------------------------------------------------------------------------}

procedure TFrmConfig.BtnOkClick(Sender: TObject);
begin
  SetConfiguration;
  Config.SaveToFile(ConfigFilename);
  Close;
end;

{------------------------------------------------------------------------------}

procedure TFrmConfig.BtnCancelClick(Sender: TObject);
begin
  Close;
end;

{------------------------------------------------------------------------------}

procedure TFrmConfig.JvSpinEditNbHDeskEnter(Sender: TObject);
begin
  JvSpinEditNbHDesk.MaxValue:= trunc(MaxDesk/JvSpinEditNbVDesk.Value);
end;

{------------------------------------------------------------------------------}

procedure TFrmConfig.JvSpinEditNbVDeskEnter(Sender: TObject);
begin
  JvSpinEditNbVDesk.MaxValue:= trunc(MaxDesk/JvSpinEditNbHDesk.Value);
end;

{*****************************************************************************}
{ Private function                                                            }
{*****************************************************************************}

procedure TFrmConfig.WMDropFiles(var Mesg: TWMDropFiles);
// Manage dropped files
var
  ItemText: array[0..255] of Char;
  NbItems: longint;
  N: longint;
begin
  // Process only if on the Launch Program tab
  if PgConfig.ActivePage = TshLaunchedPrg then
  begin
    // Number of selected items for drag & drop
    NbItems:=DragQueryFile(Mesg.drop, $FFFFFFFF, ItemText, SizeOf(ItemText));
    // For each item
    for N:=0 to NbItems - 1 do
    begin
      // Get ItemText
      DragQueryFile(Mesg.drop, N, ItemText, SizeOf(ItemText));
      // Show ItemText
      AddItemToSGrLaunchedPrg(ItemText,'1','0');
    end;
    // Message process so send 0
    Mesg.result:=0;
  end;
end;

{------------------------------------------------------------------------------}

procedure TFrmConfig.CMDialogKey(var Msg: TCMDialogKey);
// Code from Peter Below on borland.public.delphi.vcl.components.using
begin
  if ActiveControl = CobDeskNumber then
  begin
    if Msg.CharCode = VK_TAB then
    begin
      // Set focus back to the string grid and pass the tab key to it
      SGrLaunchedPrg.SetFocus;
      SGrLaunchedPrg.Perform(WM_KEYDOWN,Msg.CharCode,Msg.KeyData);
      // Swallow this message
      Msg.Result:= 1;
      Exit;
    end;
  end;
  inherited;
end;

{------------------------------------------------------------------------------}

procedure TFrmConfig.AddItemToSgrLaunchedPrg(AnItem,
  ADeskNumber,AStickyStatus: string);
// Add an item to the launched program list
begin
  inc(NbLaunchedPrg);
  with SGrLaunchedPrg do
  begin
    // Add lines if needed
    if RowCount = NbLaunchedPrg then RowCount:= NbLaunchedPrg + 5;
    // Display value
    Cells[0,NbLaunchedPrg]:= MinimizeName(AnItem,Canvas,ColWidths[0]);
    Cells[1,NbLaunchedPrg]:= ADeskNumber;
    Cells[2,NbLaunchedPrg]:= AStickyStatus;
    Cells[3,NbLaunchedPrg]:= AnItem;
  end;
end;

{------------------------------------------------------------------------------}

procedure TFrmConfig.RemoveItemFromSgrLaunchedPrg(AnIndex: integer);
// Remove an item to the launched program list
var
  N: integer;
begin
  dec(NbLaunchedPrg);
  with SGrLaunchedPrg do
  begin
    //Move up
    for N:= AnIndex to NbLaunchedPrg do
    begin
      Cells[0,N]:= Cells[0,N+1];
      Cells[1,N]:= Cells[1,N+1];
      Cells[2,N]:= Cells[2,N+1];
    end;
    // Clear last one
    Cells[0,NbLaunchedPrg+1]:= '';
    Cells[1,NbLaunchedPrg+1]:= '';
    Cells[2,NbLaunchedPrg+1]:= '';
  end;
end;

{------------------------------------------------------------------------------}

procedure TFrmConfig.CreateDirectHotKey;
// Create direct hot key gui
var
  N: byte;
begin
  for N:= 0 to MaxDesk do
  begin
    // Label
    LblHkDesk[N]:= TLabel.Create(self);
    LblHkDesk[N].Parent:= SbxHotKeys;
    LblHkDesk[N].Name:= 'LblDesk' + IntToStr(N);
    LblHkDesk[N].Caption:= GetMsg(026) + ' ' + IntToStr(N+1) + ' : ';
    LblHkDesk[N].AutoSize:= true;
    LblHkDesk[N].Left:= 7;
    LblHkDesk[N].Top:= 25 + (N * (LblHkDesk[N].Height + 10));
    // Edit
    EdtHkDesk[N]:= TEdit.Create(self);
    EdtHkDesk[N].Parent:= SbxHotKeys;
    EdtHkDesk[N].Name:= 'EdtDesk' + IntToStr(N);
    EdtHkDesk[N].Text:= GetMsg(026) + ' ' + IntToStr(N+1);
    EdtHkDesk[N].AutoSize:= true;
    EdtHkDesk[N].Left:= 70;
    EDtHkDesk[N].Top:= 20 + (N * (LblHkDesk[N].Height + 10));
    EdtHkDesk[N].Width:= 85;
    EdtHkDesk[N].MaxLength:= 15;
    // HotKey
    HkDesk[N]:= THotKey.Create(self);
    HkDesk[N].Parent:= SbxHotKeys;
    HkDesk[N].Name:= 'HkyDesk' + IntToStr(N);
    HkDesk[N].Left:= 160;
    HkDesk[N].Top:= 20 + (N * (LblHkDesk[N].Height + 10));
    HkDesk[N].Width:= 97;
  end;
end;

{------------------------------------------------------------------------------}

procedure TFrmConfig.GetConfiguration;
// Setup display with the Config values
var
  HotKeys: TCfgHotKey;
  AStringList: TStringList;
  AnExeName: string;
  ADeskNumber: string;
  AStickyStatus: string;
  N: byte;
begin
  // General
  JvSpinEditNbHDesk.Value:= Config.NbHDesk;
  JvSpinEditNbVDesk.Value:= Config.NbVDesk;
  JvSpinEditDeskWidth.Value:= Config.PagerDeskWidth;
  JvSpinEditDeskHeight.Value:= Config.PagerDeskHeight;
  ChbRememberPos.Checked:= Config.RememberPos;
  ChbHidePager.Checked:= Config.HidePager;
  RGrCycling.ItemIndex:= Config.Cycling;
  // Hot key
  HotKeys:= Config.HotKeys;
  HkyPreviousDesk.HotKey:= HotKeys.PrevDeskHotKey;
  HkyNextDesk.HotKey:= HotKeys.NextDeskHotKey;
  HkyDeskUp.HotKey:= HotKeys.DeskUpHotKey;
  HkyDeskDown.HotKey:= HotKeys.DeskDownHotKey;
  for N:= 0 to MaxDesk do
  begin
    EdtHKDesk[N].Text:= HotKeys.DeskName[N];
    if EdtHkDesk[N].Text = '' then
      EdtHkDesk[N].Text:= GetMsg(026)+' '+IntToStr(N+1);
    HkDesk[N].HotKey:= HotKeys.DeskHotKey[N];
  end;
  HkyToggleSticky.HotKey:= HotKeys.ToggleStickyHotKey;
  // Pager
  JvColorCobActiveDesk.ColorValue:= Config.ActiveDeskColor;
  JvColorCobInactiveDesk.ColorValue:= Config.InactiveDeskColor;
  ChbIconOnPager.Checked:= Config.IconOnPager;
  ChbPagerRefresh.Checked:= Config.PagerRefresh;
  // Option
  ChbRestoreAppli.Checked:= Config.RestoreAppli;
  ChbAskRestore.Enabled:= ChbRestoreAppli.Checked;
  ChbAskRestore.Checked:= Config.AskRestore;
  ChbHideApplication.Checked:= Config.HideApplication;
  // Switching
  ChbBorderSwitching.Checked:= Config.BorderSwitching;
  ChbPagerSwitching.Checked:= Config.PagerSwitching;
  // Launched program
  if FileExists(LocationFilename) then
  begin
    AStringList:= TStringList.Create;
    AStringList.LoadFromFile(LocationFilename);
    NbLaunchedPrg:= AStringList.Count;
    for N:= 1 to NbLaunchedPrg do
    begin
      ExtractPrgString(AStringList.Strings[N-1],AnExeName,ADeskNumber,AStickyStatus);
      with SGrLaunchedPrg do
      begin
        Cells[3,N]:= AnExeName;
        Cells[2,N]:= AStickyStatus;
        Cells[1,N]:= ADeskNumber;
        Cells[0,N]:= MinimizeName(AnExeName,Canvas,ColWidths[0]);
      end;
    end;
    AStringList.Free;
  end;
end;

{------------------------------------------------------------------------------}

procedure TFrmConfig.SetConfiguration;
// Save the setup in the Config storage
var
  HotKeys: TCfgHotKey;
  AStringList: TStringList;
  N: byte;
begin
  // General
  Config.NbHDesk:= round(JvSpinEditNbHDesk.Value);
  Config.NbVDesk:= round(JvSpinEditNbVDesk.Value);
  Config.Cycling:= RgrCycling.ItemIndex;
  Config.PagerDeskWidth:= round(JvSpinEditDeskWidth.Value);
  Config.PagerDeskHeight:= round(JvSpinEditDeskHeight.Value);
  Config.RememberPos:= ChbRememberPos.Checked;
  Config.HidePager:= ChbHidePager.Checked;
  // HotKey
  with HotKeys do
  begin
    PrevDeskHotKey:= HkyPreviousDesk.HotKey;
    NextDeskHotKey:= HkyNextDesk.HotKey;
    DeskUpHotKey:= HkyDeskUp.HotKey;
    DeskDownHotKey:= HkyDeskDown.HotKey;
    for N:= 0 to MaxDesk do
    begin
      DeskName[N]:= EdtHKDesk[N].Text;
      DeskHotKey[N]:= HkDesk[N].HotKey;
    end;
    ToggleStickyHotKey:= HkyToggleSticky.HotKey;
  end;
  Config.HotKeys:= HotKeys;
  // Pager
  Config.ActiveDeskColor:= JvColorCobActiveDesk.ColorValue;
  Config.InactiveDeskColor:= JvColorCobInactiveDesk.ColorValue;
  Config.IconOnPager:= ChbIconOnPager.Checked;
  Config.PagerRefresh:= ChbPagerRefresh.Checked;
  // Option
  Config.RestoreAppli:= ChbRestoreAppli.Checked;
  Config.AskRestore:= ChbAskRestore.Checked;
  Config.HideApplication:= ChbHideApplication.Checked;
  // Switching
  Config.BorderSwitching:= ChbBorderSwitching.Checked;
  Config.PagerSwitching:= ChbPagerSwitching.Checked;
  // Launched program
  AStringList:= TStringList.Create;
  for N:= 1 to NbLaunchedPrg do
  begin
    with SGrLaunchedPrg do
      AStringList.Add(BuildPrgString(Cells[3,N],Cells[1,N],Cells[2,N]));
  end;
  AStringList.SaveToFile(LocationFilename);
  AStringList.Free;
end;

{------------------------------------------------------------------------------}

procedure TFrmConfig.AdaptLanguage;
begin
  FrmConfig.Caption:= GetMsg(000);
  BtnOk.Caption:= GetMsg(001);
  BtnCancel.Caption:= GetMsg(002);

  TshGeneral.Caption:= GetMsg(010);
  GbxPager.Caption:= GetMsg(011);
  LblNbDesk.Caption:= GetMsg(012);
  LblPagerDeskSize.Caption:= GetMsg(013);
  ChbRememberPos.Caption:= GetMsg(014);
  ChbHidePager.Caption:= GetMsg(015);
  RgrCycling.Caption:= GetMsg(016);
  RgrCycling.Items.Clear;
  RgrCycling.Items.Add(GetMsg(017));
  RgrCycling.Items.Add(GetMsg(018));
  RgrCycling.Items.Add(GetMsg(019));

  TshDeskHotKey.Caption:= GetMsg(020);
  LblPreviousDesk.Caption:= GetMsg(021);
  LblNextDesk.Caption:= GetMsg(022);
  LblDeskUp.Caption:= GetMsg(023);
  LblDeskDown.Caption:= GetMsg(024);
  LblDirectHotKeys.Caption:= GetMsg(025);
  LblDeskName.Caption:= GetMsg(027);
  LblDeskHotKey.Caption:= GetMsg(028);

  TshPager.Caption:= GetMsg(030);
  GbxPagerColor.Caption:= GetMsg(031);
  LblActiveDeskColor.Caption:= GetMsg(032);
  LblInactiveDeskColor.Caption:= GetMsg(033);
  GbxPagerOption.Caption:= GetMsg(034);
  ChbIconOnPager.Caption:= GetMsg(035);
  ChbPagerRefresh.Caption:= GetMsg(036);

  TshOptions.Caption:= GetMsg(040);
  LblToggleSticky.Caption:= GetMsg(041);
  GbxStartUp.Caption:= GetMsg(042);
  ChbRestoreAppli.Caption:= GetMsg(043);
  ChbAskRestore.Caption:= GetMsg(044);
  ChbHideApplication.Caption:= GetMsg(045);

  TshLaunchedPrg.Caption:= GetMsg(050);

  TshSwitching.Caption:= GetMsg(060);
  ChbBorderSwitching.Caption:= GetMsg(061);
  ChbPagerSwitching.Caption:= GetMsg(062);
end;

end.

