unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, Menus, ToolWin, ExtCtrls, StdCtrls, Spin, ColorGrd, Buttons,
  Db, DBTables, Grids, DBGrids, ClipBrd, ImgList;

type
  TOutilsGraph = (ogAucun,ogSelection, ogGomme, ogZoom, ogFCanonique,
    ogImpCadre, ogImpEch);
  TOutils= (otAucun,otPoint,otInter,otLigne,otSegment,otCercle,otArc,
    otArc3,otRotation,otSymetrie,otTexte,otCoteH,otCoteV,otCoteRef,otCoteSuiv);
  TFPrincipale = class(TForm)
    MenuPrincipal: TMainMenu;
    Fichier: TMenuItem;
    Nouveau: TMenuItem;
    Ouvrir: TMenuItem;
    Enregistrer: TMenuItem;
    Enregistrersous: TMenuItem;
    N1: TMenuItem;
    Importer: TMenuItem;
    Exporter: TMenuItem;
    N2: TMenuItem;
    Imprimer: TMenuItem;
    Configurationimpression: TMenuItem;
    N5: TMenuItem;
    Quitter: TMenuItem;
    Edition: TMenuItem;
    Defaire: TMenuItem;
    Refaire: TMenuItem;
    N3: TMenuItem;
    Couper: TMenuItem;
    Copier: TMenuItem;
    Coller: TMenuItem;
    Supprimer: TMenuItem;
    N4: TMenuItem;
    Toutselectionner: TMenuItem;
    MnuChercher: TMenuItem;
    Chercher: TMenuItem;
    Remplacer: TMenuItem;
    Poursuivrelarecherche: TMenuItem;
    MnuEcran: TMenuItem;
    ZoomerPlus: TMenuItem;
    ZoomerMoins: TMenuItem;
    N7: TMenuItem;
    Redessiner: TMenuItem;
    MnuExecuter: TMenuItem;
    Executer: TMenuItem;
    N6: TMenuItem;
    PasAPas: TMenuItem;
    Aide: TMenuItem;
    APropos: TMenuItem;
    BarreOutil: TToolBar;
    BarreEtat: TStatusBar;
    ImagesBarreOutil: TImageList;
    BtnNouveau: TToolButton;
    BtnOuvrir: TToolButton;
    BtnSauver: TToolButton;
    BtnSepare1: TToolButton;
    BtnImprimer: TToolButton;
    BtnSepare2: TToolButton;
    BtnDefaire: TToolButton;
    BtnRefaire: TToolButton;
    BtnSepare3: TToolButton;
    BtnCouper: TToolButton;
    BtnCopier: TToolButton;
    BtnColler: TToolButton;
    BtnSupprimer: TToolButton;
    BtnSepare4: TToolButton;
    Fonte: TComboBox;
    BtnSepare5: TToolButton;
    Taille: TSpinEdit;
    DialogOuvrir: TOpenDialog;
    DialogSauverSous: TSaveDialog;
    DialogImprimer: TPrintDialog;
    DialogConfigImpression: TPrinterSetupDialog;
    Dossier: TPageControl;
    OngletGraph: TTabSheet;
    OngletText: TTabSheet;
    OngletProgIso: TTabSheet;
    Editeur: TRichEdit;
    ZoneMenu: TPanel;
    ZoneGraphique: TPanel;
    Dessin: TImage;
    MenuGeneral: TPanel;
    BtnConstruction: TSpeedButton;
    MenuCotation: TPanel;
    MenuChainer: TPanel;
    BtnCotation: TSpeedButton;
    BtnChainer: TSpeedButton;
    BtnSelection1: TSpeedButton;
    BtnGomme1: TSpeedButton;
    BtnCadrage1: TSpeedButton;
    BtnZoom1: TSpeedButton;
    BtnZoomPrecedent1: TSpeedButton;
    BtnZoomSuivant1: TSpeedButton;
    BtnCouleur1: TSpeedButton;
    BtnSelection3: TSpeedButton;
    BtnGomme3: TSpeedButton;
    BtnCadrage3: TSpeedButton;
    BtnZoom3: TSpeedButton;
    BtnZoomPrecedent3: TSpeedButton;
    BtnZoomSuivant3: TSpeedButton;
    BtnCouleur3: TSpeedButton;
    BtnMenuGeneral3: TSpeedButton;
    BtnSelection4: TSpeedButton;
    BtnGomme4: TSpeedButton;
    BtnCadrage4: TSpeedButton;
    BtnZoom4: TSpeedButton;
    BtnZoomPrecedent4: TSpeedButton;
    BtnZoomSuivant4: TSpeedButton;
    BtnCouleur4: TSpeedButton;
    BtnMenuGeneral4: TSpeedButton;
    MenuConstruction: TPanel;
    BtnCouleur2: TSpeedButton;
    BtnMenuGeneral2: TSpeedButton;
    BtnZoomPrecedent2: TSpeedButton;
    BtnCadrage2: TSpeedButton;
    BtnZoomSuivant2: TSpeedButton;
    BtnZoom2: TSpeedButton;
    BtnSelection2: TSpeedButton;
    BtnGomme2: TSpeedButton;
    BtnPoint: TSpeedButton;
    BtnInter: TSpeedButton;
    BtnLigne: TSpeedButton;
    BtnSegment: TSpeedButton;
    BtnCercle: TSpeedButton;
    BtnArc: TSpeedButton;
    BtnArc3: TSpeedButton;
    BtnTexte: TSpeedButton;
    BtnCoteH: TSpeedButton;
    BtnCoteV: TSpeedButton;
    BtnCoteRef: TSpeedButton;
    BtnCoteSuiv: TSpeedButton;
    GrillePoint: TDBGrid;
    GrilleLigne: TDBGrid;
    GrilleCercle: TDBGrid;
    GrilleVariable: TDBGrid;

    TempoSauvegarde: TTimer;
    Outils: TMenuItem;
    Options: TMenuItem;
    ListeMessages: TListBox;
    ZoomerOrigine: TMenuItem;
    ZoneQR: TPanel;
    BtnRotation: TSpeedButton;
    BtnSymetrie: TSpeedButton;
    BtnVisible1: TSpeedButton;
    BtnVisible2: TSpeedButton;
    BtnVisible3: TSpeedButton;
    BtnVisible4: TSpeedButton;
    BtnFCanon1: TSpeedButton;
    BtnFCanon2: TSpeedButton;
    BtnFCanon3: TSpeedButton;
    BtnFCanon4: TSpeedButton;
    DialogRechercher: TFindDialog;
    DialogRemplacer: TReplaceDialog;
    BtnDebutForme: TSpeedButton;
    BtnFinForme: TSpeedButton;


    procedure ShowHint(Sender: TObject);
    procedure AfficheModifie(Modif : boolean);
    procedure AfficheRemplacement;
    procedure MajPositionCurseur;
    procedure InitAppli;

    procedure AProposClick(Sender: TObject);
    procedure QuitterClick(Sender: TObject);
    procedure NouveauClick(Sender: TObject);
    procedure OuvrirClick(Sender: TObject);
    procedure EnregistrerClick(Sender: TObject);
    procedure EnregistrersousClick(Sender: TObject);
    procedure ImprimerClick(Sender: TObject);
    procedure ConfigurationimpressionClick(Sender: TObject);
    procedure DefaireClick(Sender: TObject);
    procedure CouperClick(Sender: TObject);
    procedure CopierClick(Sender: TObject);
    procedure CollerClick(Sender: TObject);
    procedure SupprimerClick(Sender: TObject);
    procedure ToutselectionnerClick(Sender: TObject);
    procedure OptionsClick(Sender: TObject);

    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);

    procedure DossierChange(Sender: TObject);
    procedure DessinMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure DessinMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure DessinMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure OngletTextEnter(Sender: TObject);
    procedure DossierEnter(Sender: TObject);

    procedure BtnConstructionClick(Sender: TObject);
    procedure BtnCotationClick(Sender: TObject);
    procedure BtnChainerClick(Sender: TObject);

    procedure BtnMenuGeneral2Click(Sender: TObject);

    procedure BtnMenuGeneral3Click(Sender: TObject);

    procedure BtnMenuGeneral4Click(Sender: TObject);


    procedure EditeurChange(Sender: TObject);
    procedure EditeurSelectionChange(Sender: TObject);
    procedure FormDestroy(Sender: TObject);

    procedure TempoSauvegardeTimer(Sender: TObject);
    procedure ExecuterClick(Sender: TObject);
    procedure OngletProgIsoEnter(Sender: TObject);
    procedure OngletGraphEnter(Sender: TObject);
    procedure ListeMessagesClick(Sender: TObject);
    procedure ZoneGraphiqueResize(Sender: TObject);
    procedure ZoomerOrigineClick(Sender: TObject);
    procedure ZoomerPlusClick(Sender: TObject);
    procedure RedessinerClick(Sender: TObject);
    procedure ZoomerMoinsClick(Sender: TObject);
    procedure BtnZoom1Click(Sender: TObject);
    procedure BtnZoomPrecedent1Click(Sender: TObject);
    procedure BtnZoomSuivant1Click(Sender: TObject);
    procedure BtnCadrage1Click(Sender: TObject);
    procedure EditeurKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure BtnPointClick(Sender: TObject);
    procedure BtnLigneClick(Sender: TObject);
    procedure BtnSegmentClick(Sender: TObject);
    procedure BtnCercleClick(Sender: TObject);
    procedure BtnArcClick(Sender: TObject);
    procedure BtnArc3Click(Sender: TObject);
    procedure BtnRotationClick(Sender: TObject);
    procedure BtnSymetrieClick(Sender: TObject);
    procedure BtnTexteClick(Sender: TObject);
    procedure BtnCoteHClick(Sender: TObject);
    procedure BtnCoteVClick(Sender: TObject);
    procedure BtnCoteRefClick(Sender: TObject);
    procedure BtnCoteSuivClick(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure BtnInterClick(Sender: TObject);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure BtnGomme1Click(Sender: TObject);
    procedure BtnFCanon1Click(Sender: TObject);
    procedure BtnCouleur1Click(Sender: TObject);
    procedure BtnVisible1Click(Sender: TObject);
    procedure ChercherClick(Sender: TObject);
    procedure DialogRechercherFind(Sender: TObject);
    procedure RemplacerClick(Sender: TObject);
    procedure DialogRemplacerFind(Sender: TObject);
    procedure DialogRemplacerReplace(Sender: TObject);

  private
    { Dclarations prives }
    NomFichier : string;
    PressePapier : HWnd;
    procedure LitFontes;
    procedure DefiniMenu;
    procedure DonneNomFichier(Nom: String);
    procedure LitFichier(NomDuFichier : string);
    procedure ControleFichierSauve;
    procedure RecupereFichierSav;

    procedure AfficheMessage(Num : integer);

    procedure InitZoom(X,Y : integer);
    procedure AffiZoom(X,Y : integer);
    procedure ExecuteZoom(X,Y : integer);

    procedure InitCadreImp(X,Y : integer);
    procedure AffiCadreImp(X,Y : integer);
    procedure ExecuteImp(X,Y : integer);

    procedure TestFonction;
    procedure GestionPointSouris(X,Y : integer);
    procedure GestionInterSouris(X,Y : integer);
    procedure GestionLigneSouris(X,Y : integer);
    procedure GestionSegmentSouris(X,Y : integer);
    procedure GestionCercleSouris(X,Y : integer);
    procedure GestionArcSouris(X,Y : integer);
    procedure GestionArc3Souris(X,Y : integer);
    procedure GestionRotationSouris(X,Y : integer);
    procedure GestionSymetrieSouris(X,Y : integer);
    procedure GestionFCanonSouris(X,Y : integer);

    procedure PressePapierChange;
    procedure WMDropFiles(var Msg: TWMDropFiles); message WM_DROPFILES;
    procedure WMChangeCBChain(var Msg: TWMChangeCBChain); message WM_CHANGECBCHAIN;
    procedure WMDrawClipboard(var Msg: TWMDrawClipboard); message WM_DRAWCLIPBOARD;

    procedure ResetFct;

    procedure GestionPointClavier(Car: char);
    procedure GestionLigneClavier(Car: char);
    procedure GestionCercleClavier(Car: char);

  public
    { Dclarations publiques }
    OutilGraph: TOutilsGraph; {Outil graphique actuel (zoom,cadrage,...)}
    OutilActif: TOutils; {Outil actuel (point,ligne,....)}
    Origin, MovePt: TPoint; {Stockage des points du zoom zone}
    ActionGraph: boolean; {Action graphique (zoom, ...) en cours}
  end;

const
  Version = '1.0';
var
  FPrincipale: TFPrincipale;
  Chemin : string; {Rpertoire de l'application}
  Overwrite : boolean; {Editeur en mode remplacement}
  LgCourante : string; {Ligne de language en cours de construction }
  FctCourante : string; {Fonction en cours de construction }
  FctPrecedente : string; {Fonction precedente de symetrie }
  Discri : char; {Discriminants de la fonction en cours de construction}
  NumCoulActive   : integer;
  NumCoucheActive : integer;

implementation

uses JDAbout, RichEdit, ShellAPI, JDEdit, JDData, JDCalcul, JDOptions, JDGraph,
  JDSaisie, JDChoix1, JDChoix2, JDChoix3, JDColor, JDVisible, JDFCanon;

{$R *.DFM}

const
  LColonne : cardinal = 120; { largeur d'une colonne de grille }

var
  PT1,PT2,PT3 : DefPoint; {Points trouves}
  LT1,LT2,LT3 : DefLigne; {Lignes trouvees lors des recherches}
  CT1,CT2,CT3 : DefCercle; {Cercles trouves lors des recherches}
  D1,D2,D3    : char; {discriminant}
  R           : extended; {rayon}

  PRotation   : integer;
  ARotation   : string;

  PSymetrie   : integer;
  LSymetrie   : integer;

  EchImpression : extended;

// ***********************
// * procedures internes *
// ***********************

procedure TFPrincipale.ShowHint(Sender: TObject);
begin
  if Length(Application.Hint) > 0 then
  begin
    BarreEtat.SimplePanel := True;
    BarreEtat.SimpleText := Application.Hint;
  end
  else BarreEtat.SimplePanel := False;
end;

procedure TFPrincipale.AfficheModifie(Modif : boolean);
begin
  if Modif then BarreEtat.Panels[1].Text := 'Modifi'
           else BarreEtat.Panels[1].Text := '';
end;

procedure TFPrincipale.AfficheRemplacement;
begin
  if Overwrite then BarreEtat.Panels[2].Text := 'Remplacement'
               else BarreEtat.Panels[2].Text := 'Insertion';
end;

function EnumFontsProc(var LogFont: TLogFont; var TextMetric: TTextMetric;
  FontType: Integer; Data: Pointer): Integer; stdcall;
begin
  TStrings(Data).Add(LogFont.lfFaceName);
  Result := 1;
end;

procedure TFPrincipale.LitFontes;
var
  DC: HDC;
begin
  DC := GetDC(0);
  EnumFonts(DC, nil, @EnumFontsProc, Pointer(Fonte.Items));
  ReleaseDC(0, DC);
  Fonte.Sorted := True;
  Fonte.ItemIndex := 0;
end;

procedure TFPrincipale.DefiniMenu;
begin
  MenuGeneral.Parent := ZoneMenu;
  MenuGeneral.Align := alClient;
  MenuGeneral.Visible := true;
  MenuGeneral.BevelOuter := bvNone;

  MenuConstruction.Parent := ZoneMenu;
  MenuConstruction.Align := alClient;
  MenuConstruction.Visible := false;

  MenuCotation.Parent := ZoneMenu;
  MenuCotation.Align := alClient;
  MenuCotation.Visible := false;

  MenuChainer.Parent := ZoneMenu;
  MenuChainer.Align := alClient;
  MenuChainer.Visible := false;
end;

procedure TFPrincipale.MajPositionCurseur;
var
  Position: TPoint;
begin
  Position.Y := SendMessage(Editeur.Handle, EM_EXLINEFROMCHAR, 0,
    Editeur.SelStart);
  Position.X := (Editeur.SelStart -
    SendMessage(Editeur.Handle, EM_LINEINDEX, Position.Y, 0));
  Inc(Position.Y);
  Inc(Position.X);
  BarreEtat.Panels[0].Text := Format('Ligne : %3d   Colonne : %3d',
    [Position.Y, Position.X]);
  {Mise  jour des boutons}
  BtnCouper.Enabled := Editeur.SelLength > 0;
  BtnCopier.Enabled := BtnCouper.Enabled;
  BtnSupprimer.Enabled := BtnCouper.Enabled;
  {Mise  jour des menus}
  Couper.Enabled := BtnCouper.Enabled;
  Copier.Enabled := BtnCopier.Enabled;
  Supprimer.Enabled := BtnSupprimer.Enabled;
end;

procedure TFPrincipale.DonneNomFichier(Nom: String);
begin
  NomFichier := Nom;
  Caption := Format('%s - %s', [Application.Title, ExtractFileName(NomFichier)]);
end;

procedure TFPrincipale.LitFichier(NomDuFichier : string);
begin
  Dossier.ActivePage := OngletText;
  Editeur.Lines.LoadFromFile(NomDuFichier);
  DonneNomFichier(NomDuFichier);
  Editeur.SetFocus;
  Editeur.Modified := false;
  AfficheModifie(false);
  InitAppli;
end;

procedure TFPrincipale.ControleFichierSauve;
var
  Reponse : integer;
begin
  if not Editeur.Modified then exit;
  Reponse := MessageDlg(Format('Enregistrer les modifications dans %s ?',
    [NomFichier]), mtConfirmation, mbYesNoCancel, 0);
  case Reponse of
    idYes    : EnregistrerClick(Self);
    idNo     : Editeur.Modified := false;
    idCancel : Abort;
  end;
end;

procedure TFPrincipale.RecupereFichierSav;
var
  FichierSav : file of char;
begin
  if MessageDlg('Recuprer le fichier de sauvegarde prcdent ?',mtConfirmation,
    [mbYes,mbNo], 0) <> idYes then
    begin
      AssignFile(FichierSav,Chemin + 'JADE.SAV');
      erase(FichierSav);
    end
    else LitFichier(Chemin + 'JADE.SAV');
end;

procedure TFPrincipale.AfficheMessage(Num : integer);
begin
  with ZoneQR do
  case Num of
    0  : Caption := '';
    1  : Caption := ' Encadrez la zone  zoomer ou cliquez le centre puis donnez une chelle';
    2  : Caption := ' Cliquez un point ';
    3  : Caption := ' Cliquez une ligne ';
    4  : Caption := ' Cliquez un cercle ';
    5  : Caption := ' Cliquez un lment de gomtrie ';
    6  : Caption := ' Cliquez un lment de gomtrie ou tapez une valeur';
    7  : Caption := ' Cliquez une intersection, une ligne ou un cercle';
    8  : Caption := ' Cliquez une ligne ou un cercle';
    9  : Caption := ' Tapez la cote en X';
    10 : Caption := ' Tapez la cote en Y';
    11 : Caption := ' Tapez le dcalage en X';
    12 : Caption := ' Tapez le dcalage en Y';
    13 : Caption := ' Faites un choix';
    14 : Caption := ' Entrez un angle';
    15 : Caption := ' Tapez l''ecart';
    16 : Caption := ' Position';
    17 : Caption := ' Cliquez une ligne ou tapez un angle';
    18 : Caption := ' Cliquez un cercle ou tapez un ecart';
    19 : Caption := ' Cliquez un point, un cercle ou tapez une cote';
    20 : Caption := ' Cliquez un point, une ligne ou tapez un decalage';
    21 : Caption := ' Tapez le rayon';
    22 : Caption := ' Cliquez un lment gomtrique tangent ou tapez le rayon';
    23 : Caption := ' Tapez la diffrence de rayon';
    24 : Caption := ' Cliquez un point ou une ligne de symtrie';
    25 : Caption := ' Cliquez le centre de rotation';
    26 : Caption := ' Cliquez l''lment de gomtrie  tourner';
    27 : Caption := ' Cliquez l''lment de gomtrie  symtriser';
    28 : Caption := ' Encadrez la zone  imprimer ou cliquez le centre puis donnez une chelle';
    29 : Caption := ' Tapez l''chelle'; 
  end;
  update;
end;

procedure TFPrincipale.InitAppli;
begin
  case OutilGraph of
    ogZoom : begin
               BtnZoom1.Down := false;
               BtnZoom2.Down := false;
               BtnZoom3.Down := false;
               BtnZoom4.Down := false;
             end;
    ogGomme : begin
                BtnGomme1.Down := false;
                BtnGomme2.Down := false;
                BtnGomme3.Down := false;
                BtnGomme4.Down := false;
              end;
    ogSelection : begin
                    BtnSelection1.Down := false;
                    BtnSelection2.Down := false;
                    BtnSelection3.Down := false;
                    BtnSelection4.Down := false;
                  end;
    ogFCanonique: begin
                    BtnFCanon1.Down := false;
                    BtnFCanon2.Down := false;
                    BtnFCanon3.Down := false;
                    BtnFCanon4.Down := false;
                  end;
  end;
  OutilGraph := ogAucun;

  case OutilActif of
    otPoint   : BtnPoint.Down   := false;
    otInter   : BtnInter.Down   := false;
    otLigne   : BtnLigne.Down  := false;
    otSegment : BtnSegment.Down := false;
    otCercle  : BtnCercle.Down  := false;
    otArc     : BtnArc.Down     := false;
    otArc3    : BtnArc3.Down    := false;

    otRotation: BtnRotation.Down:= false;
    otSymetrie: BtnSymetrie.Down:= false;

    otTexte   : Btntexte.Down   := false;

    otCoteH   : BtnCoteH.Down    := false;
    otCoteV   : BtnCoteV.Down    := false;
    otCoteRef : BtnCoteRef.Down  := false;
    otCoteSuiv: BtnCoteSuiv.Down := false;
  end;
  OutilActif := otAucun;

  ResetFct;
  AfficheMessage(0);
end;

// ******************************
// * gestionnaires d'vnements *
// ******************************


// Menu principal

procedure TFPrincipale.AProposClick(Sender: TObject);
begin
  FAbout.Version := Version;
  FAbout.ShowModal;
end;

procedure TFPrincipale.QuitterClick(Sender: TObject);
begin
  Close;
end;

procedure TFPrincipale.NouveauClick(Sender: TObject);
begin
  InitAppli;
  DonneNomFichier('SansNom');
  Editeur.Lines.Clear;
  AjouteEntete;
  AjouteOrigines;
  Editeur.Modified := false;
  AfficheModifie(false);
  AfficheRemplacement;
  InitGraph;
  EffaceEcran;
  ExecuteTout;
end;

procedure TFPrincipale.OuvrirClick(Sender: TObject);
begin
  ControleFichierSauve;
  if DialogOuvrir.Execute then
  begin
    LitFichier(DialogOuvrir.FileName);
    Editeur.ReadOnly := ofReadOnly in DialogOuvrir.Options;
    InitGraph;
    EffaceEcran;
  end;
end;

procedure TFPrincipale.EnregistrerClick(Sender: TObject);
var
  NomSauvegarde : string;
begin
  if NomFichier = 'SansNom' then EnregistrersousClick(Sender)
  else
  begin
    NomSauvegarde:=ChangeFileExt(NomFichier,'.~ad');
    DeleteFile(NomSauvegarde);
    RenameFile(NomFichier,NomSauvegarde);
    if not EnteteExiste then AjouteEntete
       else AjouteDerniereModif;
    Editeur.Lines.SaveToFile(NomFichier);
    Editeur.Modified := false;
    AfficheModifie(false);
  end;
end;

procedure TFPrincipale.EnregistrersousClick(Sender: TObject);
begin
  DialogSauverSous.FileName := NomFichier;
  if DialogSauverSous.Execute then
  begin
    if FileExists(DialogSauverSous.FileName) then
      if MessageDlg(Format('Remplacer fichier %s ?', [DialogSauverSous.FileName]),
        mtConfirmation, mbYesNoCancel, 0) <> idYes then exit;
    if not EnteteExiste then AjouteEntete
       else AjouteDerniereModif;
    Editeur.Lines.SaveToFile(DialogSauverSous.FileName);
    DonneNomFichier(DialogSauverSous.FileName);
    Editeur.Modified := false;
    AfficheModifie(false);
  end;
end;

procedure TFPrincipale.ImprimerClick(Sender: TObject);
begin
  if DialogImprimer.Execute then
  begin
    if Dossier.ActivePage = OngletGraph then
    begin
      OutilGraph := ogImpCadre;
      AfficheMessage(28);
    end;
    if Dossier.ActivePage = OngletText then Editeur.Print(NomFichier);
    if Dossier.ActivePage = OngletProgIso then ;
  end;
end;

procedure TFPrincipale.ConfigurationimpressionClick(Sender: TObject);
begin
  if DialogConfigImpression.Execute then ;
end;

procedure TFPrincipale.DefaireClick(Sender: TObject);
begin
  with Editeur do
    if HandleAllocated then SendMessage(Handle, EM_UNDO, 0, 0);
end;

procedure TFPrincipale.CouperClick(Sender: TObject);
begin
  if Dossier.ActivePage = OngletText then Editeur.CutToClipboard;
end;

procedure TFPrincipale.CopierClick(Sender: TObject);
begin
  if Dossier.ActivePage = OngletText then Editeur.CopyToClipboard;
end;

procedure TFPrincipale.CollerClick(Sender: TObject);
begin
  if Dossier.ActivePage = OngletText then Editeur.PasteFromClipboard;
end;

procedure TFPrincipale.SupprimerClick(Sender: TObject);
begin
  if Dossier.ActivePage = OngletText then Editeur.ClearSelection;
end;

procedure TFPrincipale.ToutselectionnerClick(Sender: TObject);
begin
  if Dossier.ActivePage = OngletText then Editeur.SelectAll;
end;

procedure TFPrincipale.ExecuterClick(Sender: TObject);
begin
  ExecuteTout;
end;

procedure TFPrincipale.OptionsClick(Sender: TObject);
begin
  FOptions.ShowModal;
end;

// Fiche

procedure TFPrincipale.FormCreate(Sender: TObject);
begin
  Application.OnHint := ShowHint;
  Chemin := ExtractFilePath(Application.ExeName);
  DialogOuvrir.InitialDir := Chemin;
  DialogSauverSous.InitialDir := Chemin;
  DonneNomFichier('SansNom');
  AjouteEntete;
  AjouteOrigines;
  Editeur.Modified := false;
  AfficheModifie(false);
  AfficheRemplacement;

  LitFontes;
  PressePapier := SetClipboardViewer(Handle);
  ZoneMenu.Align := alLeft;
  ZoneGraphique.Align := alClient;
  DefiniMenu;
  DecimalSeparator := '.';
  Overwrite := false;
  NumCoulActive := 0;
  NumCoucheActive := 0;
end;

procedure TFPrincipale.FormShow(Sender: TObject);
begin
  ModuleDonnee.CreeTables;
  MajPositionCurseur;
  DragAcceptFiles(Handle, True);
  EditeurChange(nil);

  FChoixVisible.GenerePalette(8,2,32);
  FChoixVisible.InitVisible;

  InitGraph;
  EffaceEcran;
  ExecuteTout;

  if FileExists(Chemin + 'JADE.SAV') then RecupereFichierSav
  else
    {Verification si fichier dans ligne de commande}
    if (ParamCount > 0) and (FileExists(ParamStr(1))) then
      LitFichier(ParamStr(1));

end;

procedure TFPrincipale.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
var
  FichierSav : file of char;

begin
  try
    ControleFichierSauve;
    if (not Editeur.Modified) and FileExists(Chemin + 'JADE.SAV') then
    begin
      AssignFile(FichierSav,Chemin + 'JADE.SAV');
      erase(FichierSav);
    end;
    TableOk := false;
  except
    CanClose := false;
  end;
end;

procedure TFPrincipale.FormDestroy(Sender: TObject);
begin
  // nous retire de la chaine des editeurs
  ChangeClipboardChain(Handle, PressePapier);
end;

// Dossier

procedure TFPrincipale.DossierChange(Sender: TObject);
begin
  if Dossier.ActivePage = OngletText then
  begin
    MnuChercher.Visible := true;
    MnuEcran.Visible := false;
    Editeur.SetFocus;
    MajPositionCurseur;
  end
  else
  if Dossier.ActivePage = OngletGraph then
  begin
    MnuChercher.Visible := false;
    MnuEcran.Visible := true;
  end
  else
  begin
    MnuChercher.Visible := false;
    MnuEcran.Visible := false;
  end;
end;

// Gestion Zoom

procedure TFPrincipale.InitZoom(X,Y : integer);
begin
  ActionGraph := true;
  Dessin.Canvas.MoveTo(X,Y);
  Origin := Point(X,Y);
  MovePt := Origin;
end;

procedure TFPrincipale.AffiZoom(X,Y : integer);
begin
  with Dessin.Canvas do
  begin
    Pen.Mode := pmNotXor;
    Pen.Color := clGray;
    Brush.Style := bsClear;
    Rectangle(Origin.X,Origin.Y,MovePt.X,MovePt.Y);
    MovePt := Point(X,Y);
    Rectangle(Origin.X,Origin.Y,MovePt.X,MovePt.Y);
  end;
end;

procedure TFPrincipale.ExecuteZoom(X,Y : integer);
var
  Ech: extended;
begin
  with Dessin.Canvas do
  begin
    Pen.Mode := pmNotXor;
    Pen.Color := clGray;
    Rectangle(Origin.X,Origin.Y,MovePt.X,MovePt.Y);
    OutilGraph := ogAucun;
    ActionGraph := false;
    BtnZoom1.Down := false;
    BtnZoom2.Down := false;
    BtnZoom3.Down := false;
    BtnZoom4.Down := false;
    if (Origin.X<>MovePt.X) and (Origin.Y<>MovePt.Y) then ZoomCadre(Origin,MovePt)
    else
    begin
      FSaisie.Texte.Caption := ' Echelle  appliquer :';
      FSaisie.Style := tsReelP;
      FSaisie.EditSaisie.Clear;
      FSaisie.ShowModal;
      if FSaisie.Terminaison = #13 then
      begin
        Ech := StrToFloat(FSaisie.EditSaisie.Text);
        ZoomEchelle(Origin,Ech);
      end;
    end;
    AfficheMessage(0);
  end;
end;

// Gestion Impression

procedure TFPrincipale.InitCadreImp(X,Y : integer);
begin
  ActionGraph := true;
  Dessin.Canvas.MoveTo(X,Y);
  Origin := Point(X,Y);
  MovePt := Origin;
end;

procedure TFPrincipale.AffiCadreImp(X,Y : integer);
begin
  with Dessin.Canvas do
  begin
    Pen.Mode := pmNotXor;
    Pen.Color := clGray;
    Brush.Style := bsClear;
    Rectangle(Origin.X,Origin.Y,MovePt.X,MovePt.Y);
    MovePt := Point(X,Y);
    Rectangle(Origin.X,Origin.Y,MovePt.X,MovePt.Y);
  end;
end;

procedure TFPrincipale.ExecuteImp(X,Y : integer);
var
  X0,Y0,XMin,XMax,YMin,YMax : extended;
  Xc,Yc : extended;
begin
  with Dessin.Canvas do
  begin
    Pen.Mode := pmNotXor;
    Pen.Color := clGray;
    Rectangle(Origin.X,Origin.Y,MovePt.X,MovePt.Y);
    OutilGraph := ogAucun;
    ActionGraph := false;
    if (Origin.X<>MovePt.X) and (Origin.Y<>MovePt.Y) then
    begin
      XMin := XPixelToX(Origin.X,Affichage);
      YMin := YPixelToY(Origin.Y,Affichage);
      XMax := XPixelToX(MovePt.X,Affichage);
      YMax := YPixelToY(MovePt.Y,Affichage);
      if XMin > XMax then
      begin
        X0 := XMin;
        XMin := XMax;
        XMax := X0;
      end;
      if YMin > YMax then
      begin
        Y0 := YMin;
        YMin := YMax;
        YMax := Y0;
      end;
      InitImpCadre(XMin,YMin,XMax,YMax);
      ImprimeTout;
    end
    else
    begin
      AfficheMessage(29);
      FSaisie.Texte.Caption := ' Echelle :';
      FSaisie.Style := tsReelP;
      FSaisie.EditSaisie.Clear;
      FSaisie.ShowModal;
      if FSaisie.Terminaison = #13 then
      begin
        EchImpression := StrToFloat(FSaisie.EditSaisie.Text);
        Xc := XPixelToX(X,Affichage);
        Yc := YPixelToY(Y,Affichage);
        InitImpCentre(Xc,Yc,EchImpression);
        ImprimeTout;
      end;
    end;
    AfficheMessage(0);
  end;
end;

// Gestion souris

procedure TFPrincipale.DessinMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if OutilGraph = ogZoom then InitZoom(X,Y);
  if OutilGraph = ogImpCadre then InitCadreImp(X,Y);
end;

procedure TFPrincipale.DessinMouseMove(Sender: TObject; Shift: TShiftState;
  X, Y: Integer);
var
  Texte: string;
  FormatAffi : string;
begin
  FormatAffi := '##########,0';
  Texte := 'X : ' + FormatFloat(FormatAffi,XPixelToX(X,Affichage)) + '  ';
  Texte := Texte +'Y : ' + FormatFloat(FormatAffi,YPixelToY(Y,Affichage));
  BarreEtat.Panels[0].Text := Texte;
(*  BarreEtat.Panels[0].Text :=Format('X : %10.0f  Y: %10.0f',[XPixelToX(X),YPixelToY(Y)]);*)
  if (OutilGraph = ogZoom) and ActionGraph then AffiZoom(X,Y);
  if (OutilGraph = ogImpCadre) and ActionGraph then AffiCadreImp(X,Y);
end;

procedure TFPrincipale.DessinMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  if (OutilGraph = ogZoom) and ActionGraph then ExecuteZoom(X,Y)
  else
  if (OutilGraph = ogImpCadre) and ActionGraph then ExecuteImp(X,Y)
  else
  if (OutilGraph = ogFCanonique) then GestionFCanonSouris(X,Y)
  else
  case OutilActif of
    otPoint   : GestionPointSouris(X,Y);
    otInter   : GestionInterSouris(X,Y);
    otLigne   : GestionLigneSouris(X,Y);
    otSegment : GestionSegmentSouris(X,Y);
    otCercle  : GestionCercleSouris(X,Y);
    otArc     : GestionArcSouris(X,Y);
    otArc3    : GestionArc3Souris(X,Y);

    otRotation: GestionRotationSouris(X,Y);
    otSymetrie: GestionSymetrieSouris(X,Y);
  end;
  BarreEtat.Panels[3].Text := FctCourante;
end;

// Gestion fonctions souris

procedure TFPrincipale.TestFonction;
var
  Termine : boolean;
begin
  Termine := false;
  if FctCourante = 'PNN' then Termine := true
  else
  if FctCourante = 'PNA' then Termine := true
  else
  if FctCourante = 'PPNN' then Termine := true
  else
  if FctCourante = 'PPNA' then Termine := true
  else
  if FctCourante = 'PC' then Termine := true
  else
  if FctCourante = 'PPPA' then Termine := true
  else
  if FctCourante = 'PPP' then Termine := true
  else
  if FctCourante = 'PPL' then Termine := true
  else
  if FctCourante = 'PLL' then Termine := true
  else
  if FctCourante = 'PLCD' then Termine := true
  else
  if FctCourante = 'PCCD' then Termine := true
  else
  if FctCourante = 'PPPD' then Termine := true

  else
  if FctCourante = 'LNNA' then Termine := true
  else
  if FctCourante = 'LPA' then Termine := true
  else
  if FctCourante = 'LPP' then Termine := true
  else
  if FctCourante = 'LPL' then Termine := true
  else
  if FctCourante = 'LPLD' then Termine := true
  else
  if FctCourante = 'LPCD' then Termine := true
  else
  if FctCourante = 'LND' then Termine := true
  else
  if FctCourante = 'LLND' then Termine := true
  else
  if FctCourante = 'LLCD' then Termine := true
  else
  if FctCourante = 'LLCDD' then Termine := true
  else
  if FctCourante = 'LCCDD' then Termine := true
  else
  if FctCourante = 'LCAD' then Termine := true
  else
  if FctCourante = 'LLP' then Termine := true
  else
  if FctCourante = 'LLL' then Termine := true
  else
  if FctCourante = 'LLPA' then Termine := true
  else
  if FctCourante = 'LLLD' then Termine := true

  else
  if FctCourante = 'CNNN' then Termine := true
  else
  if FctCourante = 'CPN' then Termine := true
  else
  if FctCourante = 'CPP' then Termine := true
  else
  if FctCourante = 'CPL' then Termine := true
  else
  if FctCourante = 'CPCD' then Termine := true
  else
  if FctCourante = 'CCNN' then Termine := true
  else
  if FctCourante = 'CCNA' then Termine := true
  else
  if FctCourante = 'CPPND' then Termine := true
  else
  if FctCourante = 'CPLND' then Termine := true
  else
  if FctCourante = 'CPCNDD' then Termine := true
  else
  if FctCourante = 'CLLNDD' then Termine := true
  else
  if FctCourante = 'CLCNDDD' then Termine := true
  else
  if FctCourante = 'CCCNDDD' then Termine := true
  else
  if FctCourante = 'CCN' then Termine := true
  else
  if FctCourante = 'CCND' then Termine := true
  else
  if FctCourante = 'CPPP' then Termine := true
  else
  if FctCourante = 'CPPL' then Termine := true
  else
  if FctCourante = 'CPPCD' then Termine := true
  else
  if FctCourante = 'CPLL' then Termine := true
  else
  if FctCourante = 'CPLCDD' then Termine := true
  else
  if FctCourante = 'CPCCDD' then Termine := true
  else
  if FctCourante = 'CLLLDDD' then Termine := true
  else
  if FctCourante = 'CLLCDDDD' then Termine := true
  else
  if FctCourante = 'CLCCDDDD' then Termine := true
  else
  if FctCourante = 'CCCCDDD' then Termine := true
  else
  if FctCourante = 'CCPA' then Termine := true
  else
  if FctCourante = 'CCP' then Termine := true
  else
  if FctCourante = 'CCL' then Termine := true;

  if Termine then
  begin
    LgCourante := LgCourante + ',' + IntToStr(NumCoulActive);
    LgCourante := LgCourante + ',' + IntToStr(NumCoucheActive);
    if ExecuteLigne(LgCourante) then
    begin
      AjouteLigne(LgCourante);
      if (FctCourante='PPPA')or(FctCourante='LLPA')or(FctCourante='CCPA') then
      begin
        FctCourante := 'RPA*';
        AfficheMessage(26);
      end
      else
      if (FctCourante='PPP')or(FctCourante='PPL')or(FctCourante='LLP')
        or(FctCourante='LLL')or(FctCourante='CCP')or(FctCourante='CCL') then
      begin
        FctCourante := FctPrecedente;;
        AfficheMessage(27);
      end
      else
      ResetFct;
    end
    else
    begin
      MessageDlg('Construction impossible',mtWarning,[mbOk], 0);
      ResetFct;
    end;
  end;
end;

procedure TFPrincipale.GestionPointSouris(X,Y : integer);
var
  UnObjet : TObjet;
begin
  if (FctCourante = 'P*') and DetectObjets(X,Y,UnObjet) then
  begin
    with UnObjet do
    begin
      if NbPoint > 0 then
      begin
        LgCourante := LgCourante + 'P' + IntToStr(NumPoint) + ',';
        AfficheMessage(20);
        FctCourante := 'PP*'; {PP*}
      end
      else
      if NbCercle = 1 then
      begin
        LgCourante := LgCourante + 'C' + IntToStr(NumCercle[1]);
        FctCourante := 'PC'; {PC}
      end
      else Beep;
    end;
  end
  else
  if (FctCourante = 'PP*') and DetectObjets(X,Y,UnObjet) then
  begin
    with UnObjet do
    begin
      if NbPoint > 0 then
      begin
        LgCourante := LgCourante + 'P' + IntToStr(NumPoint) + ',';
        LgCourante := LgCourante + 'M';
        FctCourante := 'PPPD'; {PPPD}
      end
      else
      if NbLigne > 0 then
      begin
        LgCourante := LgCourante + 'L' + IntToStr(NumLigne[1]);
        FctCourante := 'PPL'; {PPL}
      end
      else Beep;
    end;
  end;
  TestFonction;
end;

procedure TFPrincipale.GestionInterSouris(X,Y : integer);
var
  UnObjet : TObjet;
  LTmp : string;
  PosTmp : integer;
begin
  if (FctCourante = 'P*') and DetectObjets(X,Y,UnObjet) then
  begin
    with UnObjet do
    begin
      if NbLigne = 1 then
      begin
        LgCourante := LgCourante + 'L' + IntToStr(NumLigne[1]) + ',';
        LT1 := LitLigne(NumLigne[1]);
        if NbCercle > 0 then
        begin
          LgCourante := LgCourante + 'C' + IntToStr(NumCercle[1]) + ',';
          CT1 := LitCercle(NumCercle[1]);
          Discri := DetectPos(X,Y,CT1.Xc,CT1.Yc);
          LgCourante := LgCourante + Discri;
          FctCourante := 'PLCD'; {PLCD}
        end
        else
        begin
          AfficheMessage(8);
          FctCourante := 'PL*'; {PL*}
        end;
      end
      else
      if NbLigne = 2 then
      begin
        LgCourante := LgCourante + 'L' + IntToStr(NumLigne[1]) + ',';
        LgCourante := LgCourante + 'L' + IntToStr(NumLigne[2]);
        FctCourante := 'PLL'; {PLL}
      end
      else
      if NbCercle = 1 then
      begin
        LgCourante := LgCourante + 'C' + IntToStr(NumCercle[1]) + ',';
        CT1 := LitCercle(NumCercle[1]);
        AfficheMessage(8);
        FctCourante := 'PC*'; {PC*}
      end
      else
      if NbCercle = 2 then
      begin
        LgCourante := LgCourante + 'C' + IntToStr(NumCercle[1]) + ',';
        LgCourante := LgCourante + 'C' + IntToStr(NumCercle[2]) + ',';
        CT1 := LitCercle(NumCercle[1]);
        CT2 := LitCercle(NumCercle[2]);
        Discri := DetectDG(X,CT1.XC);
        if not (Discri = DetectDG(X,CT2.Xc)) then Discri := DetectHB(Y,CT1.Yc);
        LgCourante := LgCourante + Discri;
        FctCourante := 'PCCD'; {PCCD}
      end
      else Beep;
    end;
  end
  else
  if (FctCourante = 'PL*') and DetectObjets(X,Y,UnObjet) then
  begin
    with UnObjet do
    if NbLigne > 0 then
    begin
      LgCourante := LgCourante + 'L' + IntToStr(NumLigne[1]);
      FctCourante := 'PLL'; {PLL}
    end
    else
    if NbCercle > 0 then
    begin
      LgCourante := LgCourante + 'C' + IntToStr(NumCercle[1]) + ',';
      CT1 := LitCercle(NumCercle[1]);
      Discri := DetectPos(X,Y,CT1.Xc,CT1.Yc);
      LgCourante := LgCourante + Discri;
      FctCourante := 'PLCD'; {PLCD}
    end
    else Beep;
  end
  else
  if (FctCourante = 'PC*') and DetectObjets(X,Y,UnObjet) then
  begin
    with UnObjet do
    if NbLigne > 0 then
    begin
      LTmp := LgCourante;
      PosTmp := pos('=',LTmp);
      LgCourante := copy(LTmp,1,PosTmp);
      delete(LTmp,1,PosTmp);
      LTmp := copy(LTmp,1,length(LTmp)-1);
      LgCourante := LgCourante + 'L' + IntToStr(NumLigne[1]) + ',' + LTmp + ',';
      Discri := DetectPos(X,Y,CT1.Xc,CT1.Yc);
      LgCourante := LgCourante + Discri;
      FctCourante := 'PLCD'; {PLCD}
    end
    else
    if NbCercle > 0 then
    begin
      LgCourante := LgCourante + 'C' + IntToStr(NumCercle[1]) + ',';
      CT2 := LitCercle(NumCercle[1]);
      Discri := DetectDG(X,CT1.XC);
      if not (Discri = DetectDG(X,CT2.Xc)) then Discri := DetectHB(Y,CT1.Yc);
      LgCourante := LgCourante + Discri;
      FctCourante := 'PCCD'; {PCCD}
    end
    else Beep;
  end;
  TestFonction;
end;

procedure TFPrincipale.GestionLigneSouris(X,Y : integer);
var
  UnObjet : TObjet;
begin
  if (FctCourante = 'L*') and DetectObjets(X,Y,UnObjet) then
  begin
    with UnObjet do
    begin
      if NbPoint > 0 then
      begin
        LgCourante := LgCourante + 'P' + IntToStr(NumPoint) + ',';
        AfficheMessage(17);
        FctCourante := 'LP*'; {LP*}
      end
      else
      if NbLigne > 0 then
      begin
        LgCourante := LgCourante + 'L' + IntToStr(NumLigne[1]) + ',';
        LT1 := LitLigne(NumLigne[1]);
        AfficheMessage(18);
        FctCourante := 'LL*'; {LL*}
      end
      else
      if NbCercle > 0 then
      begin
        LgCourante := LgCourante + 'C' + IntToStr(NumCercle[1]) + ',';
        CT1 := LitCercle(NumCercle[1]);
        AfficheMessage(14);
        FSaisie.Texte.Caption := ' Angle (+ - 360) :';
        FSaisie.Style := tsAngle;
        FSaisie.EditSaisie.Clear;
        FSaisie.ShowModal;
        if FSaisie.Terminaison = #13 then
        begin
          Discri := DetectPos(X,Y,CT1.Xc,CT1.Yc);
          LgCourante := LgCourante + 'A' + FSaisie.EditSaisie.Text;
          LgCourante := LgCourante + ',' + Discri;
          FctCourante := 'LCAD'; {LCAD}
        end
        else
        begin
          ResetFct;
          exit;
        end;
      end;
    end;
  end
  else
  if (FctCourante = 'LP*') and DetectObjets(X,Y,UnObjet) then
  begin
    with UnObjet do
    begin
      if NbLigne > 0 then
      begin
        LgCourante := LgCourante + 'L' + IntToStr(NumLigne[1]);
        FctCourante := 'LPL'; {LPL}
      end
      else Beep;
    end;
  end
  else
  if (FctCourante = 'LL*') and DetectObjets(X,Y,UnObjet) then
  begin
    with UnObjet do
    begin
      if NbCercle > 0 then
      begin
        LgCourante := LgCourante + 'C' + IntToStr(NumCercle[1]);
        CT1 := LitCercle(NumCercle[1]);
        Discri := DetectPos(X,Y,CT1.Xc,CT1.Yc);
        LgCourante := LgCourante + ',' + Discri;
        FctCourante := 'LLCD'; {LLCD}
      end
      else Beep;
    end;
  end
  else
  if (FctCourante = 'LLN*') then
  begin
    PT1.X := XPixelToX(X,Affichage);
    PT1.Y := YPixelToY(Y,Affichage);
    PT2 := PointLignePoint(PT1,LT1);
    Discri := DetectPos(X,Y,PT2.X,PT2.Y);
    LgCourante := LgCourante + Discri;
    FctCourante := 'LLND'; {LLND}
  end;
  TestFonction;
end;

procedure TFPrincipale.GestionSegmentSouris(X,Y : integer);
var
  UnObjet : TObjet;
  LTmp : string;
begin
  if (FctCourante = 'L*') and DetectObjets(X,Y,UnObjet) then
  begin
    with UnObjet do
    begin
      if NbPoint > 0 then
      begin
        LgCourante := LgCourante + 'P' + IntToStr(NumPoint) + ',';
        FctCourante := 'LP*'; {LP*}
      end
      else
      if NbLigne > 0 then
      begin
        LgCourante := LgCourante + 'L' + IntToStr(NumLigne[1]) + ',';
        LT1 := LitLigne(NumLigne[1]);
        FctCourante := 'LL*'; {LL*}
      end
      else
      if NbCercle > 0 then
      begin
        LgCourante := LgCourante + 'C' + IntToStr(NumCercle[1]) + ',';
        CT1 := LitCercle(NumCercle[1]);
        Discri := DetectPos(X,Y,CT1.Xc,CT1.Yc);
        LgCourante := LgCourante + Discri;
        AfficheMessage(4);
        FctCourante := 'LC*'; {LC*}
      end;
    end;
  end
  else
  if (FctCourante = 'LP*') and DetectObjets(X,Y,UnObjet) then
  begin
    with UnObjet do
    begin
      if NbPoint > 0 then
      begin
        LgCourante := LgCourante + 'P' + IntToStr(NumPoint);
        FctCourante := 'LPP'; {LPP}
      end
      else
      if NbLigne > 0 then
      begin
        LgCourante := LgCourante + 'L' + IntToStr(NumLigne[1]);
        LgCourante := LgCourante + ',O';
        FctCourante := 'LPLD'; {LPLD}
      end
      else
      if NbCercle > 0 then
      begin
        LgCourante := LgCourante + 'C' + IntToStr(NumCercle[1]);
        CT2 := LitCercle(NumCercle[1]);
        Discri := DetectPos(X,Y,CT2.Xc,CT2.YC);
        LgCourante := LgCourante + ',' + Discri;
        FctCourante := 'LPCD'; {LPCD}
      end;
    end;
  end
  else
  if (FctCourante = 'LL*') and DetectObjets(X,Y,UnObjet) then
  begin
    with UnObjet do
    begin
      if NbLigne > 0 then
      begin
        LgCourante := LgCourante + 'L' + IntToStr(NumLigne[1]);
        LgCourante := LgCourante + ',M';
        FctCourante := 'LLLD'; {LLLD}
      end
      else
      if NbCercle > 0 then
      begin
        LgCourante := LgCourante + 'C' + IntToStr(NumCercle[1]);
        CT1 := LitCercle(NumCercle[1]);
        Discri := DetectPos(X,Y,CT1.Xc,CT1.Yc);
        LgCourante := LgCourante + ',O,' + Discri;
        FctCourante := 'LLCDD'; {LLCDD}
      end
      else
      Beep;
    end;
  end
  else
  if (FctCourante = 'LC*') and DetectObjets(X,Y,UnObjet) then
  begin
    with UnObjet do
    begin
      if NbCercle > 0 then
      begin
        LTmp := LgCourante;
        LgCourante := copy(LTmp,1,length(LTmp)-1);
        delete(LTmp,1,length(LTmp)-1);
        LgCourante := LgCourante + 'C' + IntToStr(NumCercle[1]);
        LgCourante := LgCourante + ',' + LTmp;
        CT2 := LitCercle(NumCercle[1]);
        Discri := DetectPos(X,Y,CT2.Xc,CT2.Yc);
        LgCourante := LgCourante + ',' + Discri;
        FctCourante := 'LCCDD'; {LCCDD}
      end
      else Beep;
    end;
  end;
  TestFonction;
end;

procedure TFPrincipale.GestionCercleSouris(X,Y : integer);
var
  UnObjet : TObjet;
  Dist1,Dist2 : extended;
  LTmp : string;
begin
  if (FctCourante = 'C*') and DetectObjets(X,Y,UnObjet) then
  begin
    with UnObjet do
    begin
      if NbPoint > 0 then
      begin
        LgCourante := LgCourante + 'P' + IntToStr(NumPoint) + ',';
        PT1 := LitPoint(NumPoint);
        AfficheMessage(22);
        FctCourante := 'CP*'; {CP*}
      end
      else
      if NbCercle > 0 then
      begin
        AfficheMessage(13);
        FChoix1.ShowModal;
        if FChoix1.Terminaison = 0 then
        begin
          resetFct;
          exit;
        end;
        LgCourante := LgCourante + 'C' + IntToStr(NumCercle[1]) + ',';
        CT1 := LitCercle(NumCercle[1]);
        case FChoix1.Terminaison of
          1 : begin
                AfficheMessage(21);
                FSaisie.Texte.Caption := ' Rayon :';
                FSaisie.Style := tsReelP;
                FSaisie.EditSaisie.Clear;
                FSaisie.ShowModal;
                if FSaisie.Terminaison = #13 then
                begin
                  LgCourante := LgCourante + FSaisie.EditSaisie.Text;
                  FctCourante := 'CCN'; {CCN}
                end
                else
                begin
                  ResetFct;
                  exit;
                end;
              end;
          2 : begin
                AfficheMessage(23);
                FSaisie.Texte.Caption := ' Diffrence de rayon :';
                FSaisie.Style := tsReel;
                FSaisie.EditSaisie.Clear;
                FSaisie.ShowModal;
                if FSaisie.Terminaison = #13 then
                begin
                  LTmp := FSaisie.EditSaisie.Text;
                  while LTmp[1] = ' ' do delete(LTmp,1,1);
                  if LTmp[1] = '-' then
                  begin
                    delete(LTmp,1,1);
                    Discri := 'I';
                  end
                  else Discri := 'G';
                  LgCourante := LgCourante + LTmp;
                  LgCourante := LgCourante + ',' + Discri;
                  FctCourante := 'CCND'; {CCND}
                end
                else
                begin
                  ResetFct;
                  exit;
                end;
              end;
          3 : begin
                AfficheMessage(11);
                FSaisie.EditSaisie.AutoSelect := true;
                FSaisie.Texte.Caption := ' Dcalage en X :';
                FSaisie.Style := tsReel;
                FSaisie.EditSaisie.Clear;
                FSaisie.ShowModal;
                if FSaisie.Terminaison = #13 then
                begin
                  LgCourante := LgCourante + FSaisie.EditSaisie.Text + ',';
                  AfficheMessage(12);
                  FSaisie.Texte.Caption := ' Dcalage en Y :';
                  FSaisie.Style := tsReel;
                  FSaisie.EditSaisie.Clear;
                  FSaisie.ShowModal;
                  if FSaisie.Terminaison = #13 then
                  begin
                    LgCourante := LgCourante + FSaisie.EditSaisie.Text;
                    FctCourante := 'CCNN'; {CCNN}
                  end
                  else
                  begin
                    ResetFct;
                    exit;
                  end;
                end
                else
                begin
                  ResetFct;
                  exit;
                end;
              end;
        end;
      end
      else
      Beep;
    end;
  end
  else
  if (FctCourante = 'CP*') and DetectObjets(X,Y,UnObjet) then
  begin
    with UnObjet do
    begin
      if NbPoint > 0 then
      begin
        LgCourante := LgCourante + 'P' + IntToStr(NumPoint);
        FctCourante := 'CPP'; {CPP}
      end
      else
      if NbLigne > 0 then
      begin
        LgCourante := LgCourante + 'L' + IntToStr(NumLigne[1]);
        FctCourante := 'CPL'; {CPL}
      end
      else
      if NbCercle > 0 then
      begin
        LgCourante := LgCourante + 'C' + IntToStr(NumCercle[1]);
        CT1 := LitCercle(NumCercle[1]);
        PT2.X := CT1.Xc;
        PT2.Y := CT1.Yc;
        Dist1 := Distance2Points(PT1,PT2);
        if Dist1 > CT1.Rc then
        begin
          PT2.X := XPixelToX(X,Affichage);
          PT2.Y := YPixelToY(Y,Affichage);
          Dist2 := Distance2Points(PT1,PT2);
          if Dist2 > Dist1 then Discri := 'G'
                     else Discri := 'I';
        end
        else Discri := 'I';
        LgCourante := LgCourante + ',' + Discri;
        FctCourante := 'CPCD'; {CPCD}
      end;
    end;
  end;
  TestFonction;
end;


procedure TFPrincipale.GestionArcSouris(X,Y : integer);
var
  UnObjet : TObjet;
  Distance : extended;
  P1,P2,P3 : DefPoint;
begin
  if (FctCourante = 'C*') and DetectObjets(X,Y,UnObjet) then
  begin
    with UnObjet do
    begin
      if NbPoint > 0 then
      begin
        LgCourante := LgCourante + 'P' + IntToStr(NumPoint) + ',';
        PT1 := LitPoint(NumPoint);
        FctCourante := 'CP*'; {CP*}
      end
      else
      if NbLigne > 0 then
      begin
        LgCourante := LgCourante + 'L' + IntToStr(NumLigne[1]) + ',';
        LT1 := LitLigne(NumLigne[1]);
        AfficheMessage(8);
        FctCourante := 'CL*'; {CL*}
      end
      else
      if NbCercle > 0 then
      begin
        LgCourante := LgCourante + 'C' + IntToStr(NumCercle[1]) + ',';
        CT1 := LitCercle(NumCercle[1]);
        {Point clique}
        PT1.X := XPixelToX(X,Affichage);
        PT1.Y := YPixelToY(Y,Affichage);
        AfficheMessage(4);
        FctCourante := 'CC*'; {CC*}
      end;
    end;
  end
  else
  if (FctCourante = 'CP*') and DetectObjets(X,Y,UnObjet) then
  begin
    with UnObjet do
    begin
      if NbPoint > 0 then
      begin
        LgCourante := LgCourante + 'P' + IntToStr(NumPoint) + ',';
        PT2 := LitPoint(NumPoint);
        AfficheMessage(21);
        FSaisie.Texte.Caption := ' Rayon :';
        FSaisie.Style := tsReelP;
        FSaisie.EditSaisie.Clear;
        FSaisie.ShowModal;
        if FSaisie.Terminaison = #13 then
        begin
          LgCourante := LgCourante +  FSaisie.EditSaisie.Text + ',';
          AfficheMessage(16);
          FctCourante := 'CPP*'; {CPP*}
        end
        else
        begin
          ResetFct;
          exit;
        end;
      end
      else
      if NbLigne > 0 then
      begin
        LgCourante := LgCourante + 'L' + IntToStr(NumLigne[1]) + ',';
        LT1 := LitLigne(NumLigne[1]);
        AfficheMessage(21);
        FSaisie.Texte.Caption := ' Rayon :';
        FSaisie.Style := tsReelP;
        FSaisie.EditSaisie.Clear;
        FSaisie.ShowModal;
        if FSaisie.Terminaison = #13 then
        begin
          LgCourante := LgCourante +  FSaisie.EditSaisie.Text + ',';
          AfficheMessage(16);
          FctCourante := 'CPL*'; {CPL*}
        end
        else
        begin
          ResetFct;
          exit;
        end;
      end
      else
      if NbCercle > 0 then
      begin
        LgCourante := LgCourante + 'C' + IntToStr(NumCercle[1]) + ',';
        CT1 := LitCercle(NumCercle[1]);
        {Point clique}
        PT2.X := XPixelToX(X,Affichage);
        PT2.Y := YPixelToY(Y,Affichage);
        AfficheMessage(21);
        FSaisie.Texte.Caption := ' Rayon :';
        FSaisie.Style := tsReelP;
        FSaisie.EditSaisie.Clear;
        FSaisie.ShowModal;
        if FSaisie.Terminaison = #13 then
        begin
          LgCourante := LgCourante +  FSaisie.EditSaisie.Text + ',';
          AfficheMessage(16);
          FctCourante := 'CPC*'; {CPC*}
        end
        else
        begin
          ResetFct;
          exit;
        end;
      end
      else
      Beep;
    end;
  end
  else
  if (FctCourante = 'CL*') and DetectObjets(X,Y,UnObjet) then
  begin
    with UnObjet do
    begin
      if NbLigne > 0 then
      begin
        LgCourante := LgCourante + 'L' + IntToStr(NumLigne[1]) + ',';
        LT2 := LitLigne(NumLigne[1]);
        AfficheMessage(21);
        FSaisie.Texte.Caption := ' Rayon :';
        FSaisie.Style := tsReelP;
        FSaisie.EditSaisie.Clear;
        FSaisie.ShowModal;
        if FSaisie.Terminaison = #13 then
        begin
          LgCourante := LgCourante +  FSaisie.EditSaisie.Text + ',';
          AfficheMessage(16);
          FctCourante := 'CLL*'; {CLL*}
        end
        else
        begin
          ResetFct;
          exit;
        end;
      end
      else
      if NbCercle > 0 then
      begin
        LgCourante := LgCourante + 'C' + IntToStr(NumCercle[1]) + ',';
        CT1 := LitCercle(NumCercle[1]);
        {Point clique}
        PT2.X := XPixelToX(X,Affichage);
        PT2.Y := YPixelToY(Y,Affichage);
        AfficheMessage(21);
        FSaisie.Texte.Caption := ' Rayon :';
        FSaisie.Style := tsReelP;
        FSaisie.EditSaisie.Clear;
        FSaisie.ShowModal;
        if FSaisie.Terminaison = #13 then
        begin
          LgCourante := LgCourante +  FSaisie.EditSaisie.Text + ',';
          AfficheMessage(16);
          FctCourante := 'CLC*'; {CLC*}
        end
        else
        begin
          ResetFct;
          exit;
        end;
      end
      else
      Beep;
    end;
  end
  else
  if (FctCourante = 'CC*') and DetectObjets(X,Y,UnObjet) then
  begin
    with UnObjet do
    begin
      if NbCercle > 0 then
      begin
        LgCourante := LgCourante + 'C' + IntToStr(NumCercle[1]) + ',';
        CT2 := LitCercle(NumCercle[1]);
        {Point clique}
        PT2.X := XPixelToX(X,Affichage);
        PT2.Y := YPixelToY(Y,Affichage);
        AfficheMessage(21);
        FSaisie.Texte.Caption := ' Rayon :';
        FSaisie.Style := tsReelP;
        FSaisie.EditSaisie.Clear;
        FSaisie.ShowModal;
        if FSaisie.Terminaison = #13 then
        begin
          LgCourante := LgCourante +  FSaisie.EditSaisie.Text + ',';
          R := StrToFloat(FSaisie.EditSaisie.Text);
          AfficheMessage(16);
          FctCourante := 'CCC*'; {CCC*}
        end
        else
        begin
          ResetFct;
          exit;
        end;
      end
      else
      Beep;
    end;
  end
  else
  if (FctCourante = 'CPP*') then
  begin
    D1 := DetectDG(X,PT1.X);
    D2 := DetectHB(Y,PT1.Y);
    Discri := DetectDG(X,PT2.X);
    if Discri <> D1 then Discri := D2;
    LgCourante := LgCourante + Discri;
    FctCourante := 'CPPND'; {CPPND}
  end
  else
  if (FctCourante = 'CPL*') then
  begin
    D1 := DetectDG(X,PT1.X);
    D2 := DetectHB(Y,PT1.Y);
    PT2 := PointLignePoint(PT1,LT1);
    D3 := DetectPos(XToXPixel(PT1.X,Affichage),YToYPixel(PT1.Y,Affichage),PT2.X,PT2.Y);
    if D3 in ['D','G'] then Discri := D2
                       else Discri := D1;
    LgCourante := LgCourante + Discri;
    FctCourante := 'CPLND'; {CPLND}
  end
  else
  if (FctCourante = 'CPC*') then
  begin
    PT3.X := CT1.Xc;
    PT3.Y := CT1.Yc;
    Distance := Distance2Points(PT1,PT3);
    if Distance <= CT1.RC then
    begin
      PT2.X := XPixelToX(X,Affichage);
      PT2.Y := YPixelToY(Y,Affichage);
      Distance := Distance2Points(PT2,PT3);
      if Distance <= CT1.RC then Discri := 'I'
                            else Discri := 'E';
      LgCourante := LgCourante + Discri + ',';
      Discri := DetectPos(X,Y,PT1.X,PT1.Y);
      LgCourante := LgCourante + Discri;
      FctCourante := 'CPCNDD'; {CPCNDD}
    end
    else
    begin
      {pt sur cercle/position}
      PT3.X := XPixelToX(X,Affichage);
      PT3.Y := YPixelToY(Y,Affichage);
      Distance := Distance2Points(PT2,PT3);
      {pt centre cercle/position}
      PT2.X := CT1.Xc;
      PT2.Y := CT1.Yc;
      if Distance > Distance2Points(PT2,PT3) then Discri := 'I'
                                             else Discri := 'E';
      LgCourante := LgCourante + Discri + ',';
      Discri := DetectPos(X,Y,PT1.X,PT1.Y);
      LgCourante := LgCourante + Discri;
      FctCourante := 'CPCNDD'; {CPCNDD}
    end;
  end
  else
  if (FctCourante = 'CLL*') then
  begin
    PT3.X := XPixelToX(X,Affichage);
    PT3.Y := YPixelToY(Y,Affichage);
    PT1 := PointLignePoint(PT3,LT1);
    Discri := DetectPos(X,Y,PT1.X,PT1.Y);
    LgCourante := LgCourante + Discri + ',';
    PT2 := PointLignePoint(PT3,LT2);
    Discri := DetectPos(X,Y,PT2.X,PT2.Y);
    LgCourante := LgCourante + Discri;
    FctCourante := 'CLLNDD'; {CLLNDD}
  end
  else
  if (FctCourante = 'CLC*') then
  begin
    {Point clique}
    PT3.X := XPixelToX(X,Affichage);
    PT3.Y := YPixelToY(Y,Affichage);
    PT1 := PointLignePoint(PT3,LT1);
    Discri := DetectPos(X,Y,PT1.X,PT1.Y);
    D1 := Discri;
    LgCourante := LgCourante + Discri + ',';
    PT1.X := CT1.Xc;
    PT1.Y := CT1.Yc;
    Distance := Distance2Points(PT1,PT3);
    if Distance > CT1.Rc then
    begin
      if Distance2Points(PT2,PT3) > Distance then Discri := 'I'
                                             else Discri := 'E';
    end
    else Discri := 'I';
    LgCourante := LgCourante + Discri + ',';
    if D1 in ['H','B'] then Discri := DetectDG(X,CT1.Xc)
                       else Discri := DetectHB(Y,CT1.Yc);
    LgCourante := LgCourante + Discri;
    FctCourante := 'CLLNDD'; {CLLNDD}
  end
  else
  if (FctCourante = 'CCC*') then
  begin
    PT3.X := XPixelToX(X,Affichage);
    PT3.Y := YPixelToY(Y,Affichage);
    P1.X := CT1.Xc;
    P1.Y := CT1.Yc;
    P2.X := CT2.Xc;
    P2.Y := CT2.Yc;
    Distance := Distance2Points(P1,P2);
    if Distance > (CT1.Rc + CT2.Rc) then
    begin
      {les 2 cercles ne se coupent pas}
      Distance := Distance2Points(PT1,PT3);
      if Distance > Distance2Points(P1,PT3) then D1 := 'I'
                                            else D1 := 'E';
      LgCourante := LgCourante + D1 + ',';
      Distance := Distance2Points(PT2,PT3);
      if Distance > Distance2Points(P2,PT3) then D2 := 'I'
                                            else D2 := 'E';
      LgCourante := LgCourante + D2 + ',';
      D3 := DetectPos(XToXPixel(P1.X,Affichage),YToYPixel(P1.Y,Affichage),P2.X,P2.Y);
      if D3 in ['D','G'] then
      begin
        CT3 := CCCNDDD(CT1,CT2,R,D1,D2,'H');
        P3.X := CT3.Xc;
        P3.Y := CT3.Yc;
        Distance := Distance2Points(PT3,P3);
        CT3 := CCCNDDD(CT1,CT2,R,D1,D2,'B');
        P3.X := CT3.Xc;
        P3.Y := CT3.Yc;
        if Distance  > Distance2Points(PT3,P3) then Discri := 'B'
                                               else Discri := 'H';
      end
      else
      begin
        CT3 := CCCNDDD(CT1,CT2,R,D1,D2,'D');
        P3.X := CT3.Xc;
        P3.Y := CT3.Yc;
        Distance := Distance2Points(PT3,P3);
        CT3 := CCCNDDD(CT1,CT2,R,D1,D2,'G');
        P3.X := CT3.Xc;
        P3.Y := CT3.Yc;
        if Distance > Distance2Points(PT3,P3) then Discri := 'G'
                                              else Discri := 'D';
      end;
      LgCourante := LgCourante + Discri;
      FctCourante := 'CCCNDDD'; {CCCNDDD}
    end
    else
    begin
      {les 2 cercles se coupent}
      Distance := Distance2Points(P1,PT3);
      if Distance < CT1.Rc then D1 := 'I'
                           else D1 := 'E';
      LgCourante := LgCourante + D1 + ',';
      Distance := Distance2Points(P2,PT3);
      if Distance < CT2.Rc then D2 := 'I'
                           else D2 := 'E';
      LgCourante := LgCourante + D2 + ',';
      D3 := DetectPos(XToXPixel(P1.X,Affichage),YToYPixel(P1.Y,Affichage),P2.X,P2.Y);
      if D3 in ['D','G'] then
      begin
        CT3 := CCCNDDD(CT1,CT2,R,D1,D2,'H');
        P3.X := CT3.Xc;
        P3.Y := CT3.Yc;
        Distance := Distance2Points(PT3,P3);
        CT3 := CCCNDDD(CT1,CT2,R,D1,D2,'B');
        P3.X := CT3.Xc;
        P3.Y := CT3.Yc;
        if Distance > Distance2Points(PT3,P3) then Discri := 'B'
                                              else Discri := 'H';
      end
      else
      begin
        CT3 := CCCNDDD(CT1,CT2,R,D1,D2,'D');
        P3.X := CT3.Xc;
        P3.Y := CT3.Yc;
        Distance := Distance2Points(PT3,P3);
        CT3 := CCCNDDD(CT1,CT2,R,D1,D2,'G');
        P3.X := CT3.Xc;
        P3.Y := CT3.Yc;
        if Distance > Distance2Points(PT3,P3) then Discri := 'G'
                                              else Discri := 'D';
      end;
      LgCourante := LgCourante + Discri;
      FctCourante := 'CCCNDDD'; {CCCNDDD}
    end;
  end;
  TestFonction;
end;

procedure TFPrincipale.GestionArc3Souris(X,Y : integer);
var
  UnObjet : TObjet;
begin
  if (FctCourante = 'C*') and DetectObjets(X,Y,UnObjet) then
  begin
    with UnObjet do
    begin
      if NbPoint > 0 then
      begin
        LgCourante := LgCourante + 'P' + IntToStr(NumPoint) + ',';
        FctCourante := 'CP*'; {CP*}
      end
      else
      Beep;
    end;
  end
  else
  if (FctCourante = 'CP*') and DetectObjets(X,Y,UnObjet) then
  begin
    with UnObjet do
    begin
      if NbPoint > 0 then
      begin
        LgCourante := LgCourante + 'P' + IntToStr(NumPoint) + ',';
        FctCourante := 'CPP*'; {CPP*}
      end
      else
      Beep;
    end;
  end
  else
  if (FctCourante = 'CPP*') and DetectObjets(X,Y,UnObjet) then
  begin
    with UnObjet do
    begin
      if NbPoint > 0 then
      begin
        LgCourante := LgCourante + 'P' + IntToStr(NumPoint);
        FctCourante := 'CPPP'; {CPPP}
      end
      else
      Beep;
    end;
  end;
  TestFonction;
end;

procedure TFPrincipale.GestionRotationSouris(X,Y : integer);
var
  UnObjet : TObjet;
begin
  if (FctCourante = 'R*') and DetectObjets(X,Y,UnObjet) then
  begin
    with UnObjet do
    begin
      if NbPoint > 0 then
      begin
        PRotation := NumPoint;
        AfficheMessage(14);
        FSaisie.Texte.Caption := ' Angle de rotation :';
        FSaisie.Style := tsAngle;
        FSaisie.EditSaisie.Clear;
        FSaisie.ShowModal;
        if FSaisie.Terminaison = #13 then
        begin
          ARotation := FSaisie.EditSaisie.Text;
          AfficheMessage(26);
          FctCourante := 'RPA*'; {RPA*}
        end
        else
        begin
          ResetFct;
          exit;
        end;
      end
      else
      Beep;
    end;
  end
  else
  if (FctCourante = 'RPA*') and DetectObjets(X,Y,UnObjet) then
  begin
    with UnObjet do
    begin
      if NbPoint > 0 then
      begin
        LgCourante := 'P'+IntToStr(PremierPointLibre)+':=';
        LgCourante := LgCourante + 'P' + IntToStr(NumPoint) + ',';
        LgCourante := LgCourante + 'P' + IntToStr(PRotation) + ',';
        LgCourante := LgCourante + 'A' + ARotation;
        FctCourante := 'PPPA'; {PPPA}
      end
      else
      if NbLigne > 0 then
      begin
        LgCourante := 'L'+IntToStr(PremiereLigneLibre)+':=';
        LgCourante := LgCourante + 'L' + IntToStr(NumLigne[1]) + ',';
        LgCourante := LgCourante + 'P' + IntToStr(PRotation) + ',';
        LgCourante := LgCourante + 'A' + ARotation;
        FctCourante := 'LLPA'; {LLPA}
      end
      else
      if NbCercle > 0 then
      begin
        LgCourante := 'C'+IntToStr(PremierCercleLibre)+':=';
        LgCourante := LgCourante + 'C' + IntToStr(NumCercle[1]) + ',';
        LgCourante := LgCourante + 'P' + IntToStr(PRotation) + ',';
        LgCourante := LgCourante + 'A' + ARotation;
        FctCourante := 'CCPA'; {CCPA}
      end
      else
      Beep;
    end;
  end;
  TestFonction;
end;

procedure TFPrincipale.GestionSymetrieSouris(X,Y : integer);
var
  UnObjet : TObjet;
begin
  if (FctCourante = 'S*') and DetectObjets(X,Y,UnObjet) then
  begin
    with UnObjet do
    begin
      if NbPoint > 0 then
      begin
        PSymetrie := NumPoint;
        AfficheMessage(27);
        FctCourante := 'SP*';
      end
      else
      if NbLigne > 0 then
      begin
        LSymetrie := NumLigne[1];
        AfficheMessage(27);
        FctCourante := 'SL*';
      end
      else
      Beep;
    end;
  end
  else
  if (FctCourante = 'SP*') and DetectObjets(X,Y,UnObjet) then
  begin
    FctPrecedente := 'SP*';
    with UnObjet do
    begin
      if NbPoint > 0 then
      begin
        LgCourante := 'P'+IntToStr(PremierPointLibre)+':=';
        LgCourante := LgCourante + 'P' + IntToStr(NumPoint) + ',';
        LgCourante := LgCourante + 'P' + IntToStr(PSymetrie);
        FctCourante := 'PPP'; {PPP}
      end
      else
      if NbLigne > 0 then
      begin
        LgCourante := 'L'+IntToStr(PremiereLigneLibre)+':=';
        LgCourante := LgCourante + 'L' + IntToStr(NumLigne[1]) + ',';
        LgCourante := LgCourante + 'P' + IntToStr(PSymetrie);
        FctCourante := 'LLP'; {LLP}
      end
      else
      if NbCercle > 0 then
      begin
        LgCourante := 'C'+IntToStr(PremierCercleLibre)+':=';
        LgCourante := LgCourante + 'C' + IntToStr(NumCercle[1]) + ',';
        LgCourante := LgCourante + 'P' + IntToStr(PSymetrie);
        FctCourante := 'CCP'; {CCP}
      end
      else
      Beep;
    end;
  end
  else
  if (FctCourante = 'SL*') and DetectObjets(X,Y,UnObjet) then
  begin
    FctPrecedente := 'SL*';
    with UnObjet do
    begin
      if NbPoint > 0 then
      begin
        LgCourante := 'P'+IntToStr(PremierPointLibre)+':=';
        LgCourante := LgCourante + 'P' + IntToStr(NumPoint) + ',';
        LgCourante := LgCourante + 'L' + IntToStr(LSymetrie);
        FctCourante := 'PPP'; {PPL}
      end
      else
      if NbLigne > 0 then
      begin
        LgCourante := 'L'+IntToStr(PremiereLigneLibre)+':=';
        LgCourante := LgCourante + 'L' + IntToStr(NumLigne[1]) + ',';
        LgCourante := LgCourante + 'L' + IntToStr(LSymetrie);
        FctCourante := 'LLP'; {LLL}
      end
      else
      if NbCercle > 0 then
      begin
        LgCourante := 'C'+IntToStr(PremierCercleLibre)+':=';
        LgCourante := LgCourante + 'C' + IntToStr(NumCercle[1]) + ',';
        LgCourante := LgCourante + 'L' + IntToStr(LSymetrie);
        FctCourante := 'CCL'; {CCL}
      end
      else
      Beep;
    end;
  end;
  TestFonction;
end;

procedure TFPrincipale.GestionFCanonSouris(X,Y : integer);
var
  UnObjet : TObjet;
begin
  if DetectObjets(X,Y,UnObjet) then
  begin
    with UnObjet do
    begin
      if NbPoint > 0 then FFCanon.Execute('P',NumPoint)
      else
      if NbLigne > 0 then FFCanon.Execute('L',NumLigne[1])
      else
      if NbCercle >0 then FFCanon.Execute('C',NumCercle[1])
      else Beep;
    end;
    BtnFCanon1.Down := false;
    BtnFCanon2.Down := false;
    BtnFCanon3.Down := false;
    BtnFCanon4.Down := false;
    OutilGraph := ogAucun;
  end;
  
end;

// Gestion onglets

procedure TFPrincipale.OngletProgIsoEnter(Sender: TObject);
begin
  VerrouilleTables(true);
end;

procedure TFPrincipale.OngletGraphEnter(Sender: TObject);
begin
  VerrouilleTables(false);
end;

procedure TFPrincipale.OngletTextEnter(Sender: TObject);
begin
  VerrouilleTables(false);
  MajPositionCurseur;
end;

procedure TFPrincipale.DossierEnter(Sender: TObject);
begin
  if Dossier.ActivePage = OngletText then Editeur.SetFocus;
end;

// Menu general

procedure TFPrincipale.BtnConstructionClick(Sender: TObject);
begin
  MenuGeneral.Visible := false;
  MenuConstruction.Visible := true;
end;

procedure TFPrincipale.BtnCotationClick(Sender: TObject);
begin
  MenuGeneral.Visible := false;
  MenuCotation.Visible := true;
end;

procedure TFPrincipale.BtnChainerClick(Sender: TObject);
begin
  MenuGeneral.Visible := false;
  MenuChainer.Visible := true;
end;

// Menu construction

procedure TFPrincipale.BtnMenuGeneral2Click(Sender: TObject);
begin
  MenuConstruction.Visible := false;
  MenuGeneral.Visible := true;
  InitAppli;
  ResetFct;
end;

// Menu cotation

procedure TFPrincipale.BtnMenuGeneral3Click(Sender: TObject);
begin
  MenuCotation.Visible := false;
  MenuGeneral.Visible := true;
  InitAppli;
  ResetFct;
end;

// Menu chainer

procedure TFPrincipale.BtnMenuGeneral4Click(Sender: TObject);
begin
  MenuChainer.Visible := false;
  MenuGeneral.Visible := true;
  InitAppli;
  ResetFct;
end;

// Editeur

procedure TFPrincipale.EditeurChange(Sender: TObject);
begin
  AfficheModifie(Editeur.Modified);
  Defaire.Enabled := SendMessage(Editeur.Handle, EM_CANUNDO, 0, 0) <> 0;
  BtnDefaire.Enabled := Defaire.Enabled;
end;

procedure TFPrincipale.EditeurSelectionChange(Sender: TObject);
begin
  MajPositionCurseur;
end;

procedure TFPrincipale.ListeMessagesClick(Sender: TObject);
var
  Ligne : integer;
begin
  Ligne := FPrincipale.ListeMessages.ItemIndex;
  VaLigneErreur(Ligne);
end;

// Presse-papier

procedure TFPrincipale.PressePapierChange;
var
  I: Integer;
  Format: Word;
  Possible: Boolean;
begin
  // verification si l'on peut coller ce qu'il y a dans le presse papier
  Possible := False;
  for I := 0 to Clipboard.FormatCount - 1 do
  begin
    Format := Clipboard.Formats[I];
    if SendMessage(Editeur.Handle, EM_CANPASTE, Format, 0) <> 0 then
    begin
      Possible := True;
      Break;
    end;
  end;
  BtnColler.Enabled := Possible;
  Coller.Enabled := BtnColler.Enabled;
end;

procedure TFPrincipale.WMDropFiles(var Msg: TWMDropFiles);
var
  CFileName: array[0..MAX_PATH] of Char;
begin
  try
    if DragQueryFile(Msg.Drop, 0, CFileName, MAX_PATH) > 0 then
    begin
      ControleFichierSauve;
      LitFichier(CFileName);
      Msg.Result := 0;
    end;
  finally
    DragFinish(Msg.Drop);
  end;
end;

procedure TFPrincipale.WMChangeCBChain(var Msg: TWMChangeCBChain);
begin
  if Msg.Remove = PressePapier then PressePapier := Msg.Next
  else SendMessage(PressePapier, WM_CHANGECBCHAIN, Msg.Remove, Msg.Next);
  Msg.Result := 0;
end;

procedure TFPrincipale.WMDrawClipboard(var Msg: TWMDrawClipboard);
begin
  SendMessage(PressePapier, WM_DRAWCLIPBOARD, 0, 0);
  Msg.Result := 0;
  PressePapierChange;
end;

// Temporisation de sauvegarde

procedure TFPrincipale.TempoSauvegardeTimer(Sender: TObject);
begin
  if Editeur.Modified then
    Editeur.Lines.SaveToFile(Chemin + 'JADE.SAV');
end;

// Zone graphique

procedure TFPrincipale.ZoneGraphiqueResize(Sender: TObject);
begin
  if TableOk then
  begin
    CalculEchelle;
    RedessineEcran;
  end;
end;

procedure TFPrincipale.ZoomerOrigineClick(Sender: TObject);
begin
  ZoomOrigine;
end;

procedure TFPrincipale.ZoomerMoinsClick(Sender: TObject);
begin
  ZoomMoins;
end;

procedure TFPrincipale.ZoomerPlusClick(Sender: TObject);
begin
  ZoomPlus;
end;

procedure TFPrincipale.RedessinerClick(Sender: TObject);
begin
  RedessineEcran;
end;

procedure TFPrincipale.BtnZoom1Click(Sender: TObject);
begin
  if (Sender as TSpeedButton).Down then
  begin
    OutilGraph := ogZoom;
  end
  else
  begin
    OutilGraph := ogAucun;
  end;
end;

procedure TFPrincipale.BtnZoomPrecedent1Click(Sender: TObject);
begin
  ZoomPrecedent;
end;

procedure TFPrincipale.BtnZoomSuivant1Click(Sender: TObject);
begin
  ZoomSuivant;
end;

procedure TFPrincipale.BtnCadrage1Click(Sender: TObject);
begin
  CadrageAuto;
end;

procedure TFPrincipale.EditeurKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if key = vk_insert then
  begin
    Overwrite := not Overwrite;
    AfficheRemplacement;
  end;
end;

procedure TFPrincipale.ResetFct;
begin
  Discri := ' ';
  BarreEtat.Panels[3].Text := '';
  LgCourante := '';
  FctCourante := '';
  FctPrecedente := '';

  case OutilActif of
    otAucun    : AfficheMessage(0);
    otPoint    : begin
                   LgCourante := 'P'+IntToStr(PremierPointLibre)+':=';
                   FctCourante := 'P*';
                   AfficheMessage(19);
                 end;
    otInter    : begin
                   LgCourante := 'P'+IntToStr(PremierPointLibre)+':=';
                   FctCourante := 'P*';
                   AfficheMessage(7);
                 end;
    otLigne    : begin
                   LgCourante := 'L'+IntToStr(PremiereLigneLibre)+':=';
                   FctCourante := 'L*';
                   AfficheMessage(6);
                 end;
    otSegment  : begin
                   LgCourante := 'L'+IntToStr(PremiereLigneLibre)+':=';
                   FctCourante := 'L*';
                   AfficheMessage(5);
                 end;
    otCercle   : begin
                   LgCourante := 'C'+IntToStr(PremierCercleLibre)+':=';
                   FctCourante := 'C*';
                   AfficheMessage(6);
                 end;
    otArc      : begin
                   LgCourante := 'C'+IntToStr(PremierCercleLibre)+':=';
                   FctCourante := 'C*';
                   AfficheMessage(5);
                 end;
    otArc3     : begin
                   LgCourante := 'C'+IntToStr(PremierCercleLibre)+':=';
                   FctCourante := 'C*';
                   AfficheMessage(5);
                 end;
    otRotation : begin
                   LgCourante := '';
                   FctCourante := 'R*';
                   AfficheMessage(25);
                 end;
    otSymetrie : begin
                   LgCourante := '';
                   FctCourante := 'S*';
                   AfficheMessage(24);
                 end;

  end;
end;

procedure TFPrincipale.BtnPointClick(Sender: TObject);
begin
  if BtnPoint.Down then
  begin
    OutilActif := otPoint;
    ResetFct;
  end
  else
  begin
    OutilActif := otAucun;
    ResetFct;
  end;
end;

procedure TFPrincipale.BtnInterClick(Sender: TObject);
begin
  if BtnInter.Down then
  begin
    OutilActif := otInter;
    ResetFct;
  end
  else
  begin
    OutilActif := otAucun;
    ResetFct;
  end;
end;

procedure TFPrincipale.BtnLigneClick(Sender: TObject);
begin
  if BtnLigne.Down then
  begin
    OutilActif := otLigne;
    ResetFct;
  end
  else
  begin
    OutilActif := otAucun;
    ResetFct;
  end;
end;

procedure TFPrincipale.BtnSegmentClick(Sender: TObject);
begin
  if BtnSegment.Down then
  begin
    OutilActif := otSegment;
    ResetFct;
  end
  else
  begin
    OutilActif := otAucun;
    ResetFct;
  end;
end;

procedure TFPrincipale.BtnCercleClick(Sender: TObject);
begin
  if BtnCercle.Down then
  begin
    OutilActif := otCercle;
    ResetFct;
  end
  else
  begin
    OutilActif := otAucun;
    ResetFct;
  end;
end;

procedure TFPrincipale.BtnArcClick(Sender: TObject);
begin
  if BtnArc.Down then
  begin
    OutilActif := otArc;
    ResetFct;
  end
  else
  begin
    OutilActif := otAucun;
    ResetFct;
  end;
end;

procedure TFPrincipale.BtnArc3Click(Sender: TObject);
begin
  if BtnArc3.Down then
  begin
    OutilActif := otArc3;
    ResetFct;
  end
  else
  begin
    OutilActif := otAucun;
    ResetFct;
  end;
end;

procedure TFPrincipale.BtnRotationClick(Sender: TObject);
begin
  if BtnRotation.Down then
  begin
    OutilActif := otRotation;
    ResetFct;
  end
  else
  begin
    OutilActif := otAucun;
    ResetFct;
  end;
end;

procedure TFPrincipale.BtnSymetrieClick(Sender: TObject);
begin
  if BtnSymetrie.Down then
  begin
    OutilActif := otSymetrie;
    ResetFct;
  end
  else
  begin
    OutilActif := otAucun;
    ResetFct;
  end;
end;
procedure TFPrincipale.BtnTexteClick(Sender: TObject);
begin
  if BtnTexte.Down then
  begin
    OutilActif := otTexte;
    ResetFct;
  end
  else
  begin
    OutilActif := otAucun;
    ResetFct;
  end;
end;

procedure TFPrincipale.BtnCoteHClick(Sender: TObject);
begin
  if BtnCoteH.Down then
  begin
    OutilActif := otCoteH;
    ResetFct;
  end
  else
  begin
    OutilActif := otAucun;
    ResetFct;
  end;
end;

procedure TFPrincipale.BtnCoteVClick(Sender: TObject);
begin
  if BtnCoteV.Down then
  begin
    OutilActif := otCoteV;
    ResetFct;
  end
  else
  begin
    OutilActif := otAucun;
    ResetFct;
  end;
end;

procedure TFPrincipale.BtnCoteRefClick(Sender: TObject);
begin
  if BtnCoteRef.Down then
  begin
    OutilActif := otCoteRef;
    ResetFct;
  end
  else
  begin
    OutilActif := otAucun;
    ResetFct;
  end;
end;

procedure TFPrincipale.BtnCoteSuivClick(Sender: TObject);
begin
  if BtnCoteSuiv.Down then
  begin
    OutilActif := otCoteSuiv;
    ResetFct;
  end
  else
  begin
    OutilActif := otAucun;
    ResetFct;
  end;
end;

procedure TFPrincipale.GestionPointClavier(Car: char);
begin
  if (FctCourante = 'P*') then
  begin
    AfficheMessage(9);
    FSaisie.Texte.Caption := ' Cote en X :';
    FSaisie.EditSaisie.AutoSelect := false;
    Fsaisie.EditSaisie.Clear;
    FSaisie.EditSaisie.SelText := Car;
    FSaisie.Style := tsReel;
    FSaisie.ShowModal;
    FSaisie.EditSaisie.AutoSelect := true;
    if FSaisie.Terminaison = #13 then
    begin
      LgCourante := LgCourante + FSaisie.EditSaisie.Text + ',';
      AfficheMessage(10);
      FSaisie.Texte.Caption := ' Cote en Y :';
      FSaisie.Style := tsReel;
      FSaisie.EditSaisie.Clear;
      FSaisie.ShowModal;
      if FSaisie.Terminaison = #13 then
      begin
        LgCourante := LgCourante + FSaisie.EditSaisie.Text;
        FctCourante := 'PNN'; {PNN}
      end
      else
      begin
        ResetFct;
        exit;
      end;
    end
    else
    begin
      ResetFct;
      exit;
    end;
  end
  else
  if (FctCourante = 'PP*') then
  begin
    AfficheMessage(11);
    FSaisie.Texte.Caption := ' Decalage en X :';
    FSaisie.EditSaisie.AutoSelect := false;
    Fsaisie.EditSaisie.Clear;
    FSaisie.EditSaisie.SelText := Car;
    FSaisie.Style := tsReel;
    FSaisie.ShowModal;
    FSaisie.EditSaisie.AutoSelect := true;
    if FSaisie.Terminaison = #13 then
    begin
      LgCourante := LgCourante + FSaisie.EditSaisie.Text + ',';
      AfficheMessage(12);
      FSaisie.Texte.Caption := ' Decalage en Y :';
      FSaisie.Style := tsReel;
      FSaisie.EditSaisie.Clear;
      FSaisie.ShowModal;
      if FSaisie.Terminaison = #13 then
      begin
        LgCourante := LgCourante + FSaisie.EditSaisie.Text;
        FctCourante := 'PPNN'; {PPNN}
      end
      else
      begin
        ResetFct;
        exit;
      end;
    end
    else
    begin
      ResetFct;
      exit;
    end;
  end;
  TestFonction;
end;

procedure TFPrincipale.GestionLigneClavier(Car: char);
begin
  if (FctCourante = 'L*') then
  begin
    AfficheMessage(9);
    FSaisie.Texte.Caption := ' Cote en X :';
    FSaisie.EditSaisie.AutoSelect := false;
    Fsaisie.EditSaisie.Clear;
    FSaisie.EditSaisie.SelText := Car;
    FSaisie.Style := tsReel;
    FSaisie.ShowModal;
    FSaisie.EditSaisie.AutoSelect := true;
    if FSaisie.Terminaison = #13 then
    begin
      LgCourante := LgCourante + FSaisie.EditSaisie.Text + ',';
      AfficheMessage(10);
      FSaisie.Texte.Caption := ' Cote en Y :';
      FSaisie.Style := tsReel;
      FSaisie.EditSaisie.Clear;
      FSaisie.ShowModal;
      if FSaisie.Terminaison = #13 then
      begin
        LgCourante := LgCourante + FSaisie.EditSaisie.Text + ',';
        AfficheMessage(14);
        FSaisie.Texte.Caption := ' Angle (+ - 360) :';
        FSaisie.Style := tsAngle;
        FSaisie.EditSaisie.Clear;
        FSaisie.ShowModal;
        if FSaisie.Terminaison = #13 then
        begin
          LgCourante := LgCourante + 'A' + FSaisie.EditSaisie.Text;
          FctCourante := 'LNNA'; {LNNA}
        end
        else
        begin
          ResetFct;
          exit;
        end;
      end
      else
      begin
        ResetFct;
        exit;
      end;
    end
    else
    begin
      ResetFct;
      exit;
    end;
  end
  else
  if (FctCourante = 'LP*') then
  begin
    AfficheMessage(14);
    FSaisie.Texte.Caption := ' Angle (+ - 360):';
    FSaisie.EditSaisie.AutoSelect := false;
    Fsaisie.EditSaisie.Clear;
    FSaisie.EditSaisie.SelText := Car;
    FSaisie.Style := tsAngle;
    FSaisie.ShowModal;
    FSaisie.EditSaisie.AutoSelect := true;
    if FSaisie.Terminaison = #13 then
    begin
      LgCourante := LgCourante + 'A' + FSaisie.EditSaisie.Text;
      FctCourante := 'LPA'; {LPA}
    end
    else
    begin
      ResetFct;
      exit;
    end;
  end
  else
  if (FctCourante = 'LL*') then
  begin
    AfficheMessage(15);
    FSaisie.Texte.Caption := ' Ecart :';
    FSaisie.EditSaisie.AutoSelect := false;
    Fsaisie.EditSaisie.Clear;
    FSaisie.EditSaisie.SelText := Car;
    FSaisie.Style := tsReel;
    FSaisie.ShowModal;
    FSaisie.EditSaisie.AutoSelect := true;
    if FSaisie.Terminaison = #13 then
    begin
      LgCourante := LgCourante +  FSaisie.EditSaisie.Text + ',';
      AfficheMessage(16);
      FctCourante := 'LLN*'; {LLN*}
    end
    else
    begin
      ResetFct;
      exit;
    end;
  end;
  TestFonction;
end;

procedure TFPrincipale.GestionCercleClavier(Car: char);
begin
  if (FctCourante = 'C*') then
  begin
    AfficheMessage(9);
    FSaisie.Texte.Caption := ' Cote en X :';
    FSaisie.EditSaisie.AutoSelect := false;
    Fsaisie.EditSaisie.Clear;
    FSaisie.EditSaisie.SelText := Car;
    FSaisie.Style := tsReel;
    FSaisie.ShowModal;
    FSaisie.EditSaisie.AutoSelect := true;
    if FSaisie.Terminaison = #13 then
    begin
      LgCourante := LgCourante + FSaisie.EditSaisie.Text + ',';
      AfficheMessage(10);
      FSaisie.Texte.Caption := ' Cote en Y :';
      FSaisie.Style := tsReel;
      FSaisie.EditSaisie.Clear;
      FSaisie.ShowModal;
      if FSaisie.Terminaison = #13 then
      begin
        LgCourante := LgCourante + FSaisie.EditSaisie.Text + ',';
        AfficheMessage(21);
        FSaisie.Texte.Caption := ' Rayon :';
        FSaisie.Style := tsReelP;
        FSaisie.EditSaisie.Clear;
        FSaisie.ShowModal;
        if FSaisie.Terminaison = #13 then
        begin
          LgCourante := LgCourante + FSaisie.EditSaisie.Text;
          FctCourante := 'CNNN'; {CNNN}
        end
        else
        begin
          ResetFct;
          exit;
        end;
      end
      else
      begin
        ResetFct;
        exit;
      end;
    end
    else
    begin
      ResetFct;
      exit;
    end;
  end
  else
  if (FctCourante = 'CP*') then
  begin
    AfficheMessage(21);
    FSaisie.Texte.Caption := ' Rayon :';
    FSaisie.EditSaisie.AutoSelect := false;
    Fsaisie.EditSaisie.Clear;
    FSaisie.EditSaisie.SelText := Car;
    FSaisie.Style := tsReelP;
    FSaisie.ShowModal;
    FSaisie.EditSaisie.AutoSelect := true;
    if FSaisie.Terminaison = #13 then
    begin
      LgCourante := LgCourante + FSaisie.EditSaisie.Text;
      FctCourante := 'CPN'; {CPN}
    end
    else
    begin
      ResetFct;
      exit;
    end;
  end;
  TestFonction;
end;

procedure TFPrincipale.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Dossier.ActivePage = OngletGraph then
  begin
    if Key = 27 then InitAppli;
  end;
end;

procedure TFPrincipale.FormKeyPress(Sender: TObject; var Key: Char);
begin
  if Dossier.ActivePage = OngletGraph then
  begin
    if Key in ['0'..'9','-','+','E','e'] then
    begin
      case OutilActif of
        otPoint : GestionPointClavier(Key);
        otLigne : GestionLigneClavier(Key);
        otCercle: GestionCercleClavier(Key);
      end;
    end;
  end;
end;

procedure TFPrincipale.BtnGomme1Click(Sender: TObject);
begin
  if (Sender as TSpeedButton).Down then
  begin
    OutilGraph := ogGomme;
  end
  else
  begin
    OutilGraph := ogAucun;
  end;
end;

procedure TFPrincipale.BtnFCanon1Click(Sender: TObject);
begin
  if (Sender as TSpeedButton).Down then
  begin
    OutilGraph := ogFCanonique;
  end
  else
  begin
    OutilGraph := ogAucun;
  end;
end;

procedure TFPrincipale.BtnCouleur1Click(Sender: TObject);
begin
  FChoixCouleur.NbCouleurs := 8;
  FChoixCouleur.NbNuances := 2;
  FChoixCouleur.Selected := NumCoulActive;
  FChoixCouleur.Layer := NumCoucheActive;
  if FChoixCouleur.Execute then
  begin
    NumCoulActive := FChoixCouleur.Selected;
    NumCoucheActive := FChoixCouleur.Layer;
  end;
end;

procedure TFPrincipale.BtnVisible1Click(Sender: TObject);
begin
  FChoixVisible.Execute;
  RedessineEcran;
end;

procedure TFPrincipale.ChercherClick(Sender: TObject);
begin
  with Editeur do
    if (SelLength > 0) and (SelLength < 20) then
      DialogRechercher.FindText := SelText;
  DialogRechercher.Execute;
end;


procedure TFPrincipale.DialogRechercherFind(Sender: TObject);
const
  STypes: array[0..3] of TSearchTypes =
  ([],[stMatchCase],[stWholeWord],[stWholeWord,stMatchCase]);
var
  FoundAt: LongInt;
  StartPos, ToEnd: integer;
  N: byte;
begin
  { commence la recherche aprs la slection en cours s'il y en a une }
  { sinon, commence au dbut du texte }

  if Editeur.SelLength<>0 then StartPos := Editeur.SelStart + Editeur.SelLength
                          else StartPos := 0;

  { ToEnd indique la longueur entre StartPos et la fin du texte du contrle }

  ToEnd := Editeur.GetTextLen - StartPos;

  with DialogRechercher do
  begin
    if (frWholeWord in Options) then N := 2
                                else N := 0;
    if (frMatchCase in Options) then inc(N);
    FoundAt := Editeur.FindText(FindText, StartPos, ToEnd, STypes[N]);
  end;

  if FoundAt <> -1 then
  begin
    Editeur.SetFocus;
    Editeur.SelStart := FoundAt;
    Editeur.SelLength := Length(DialogRechercher.FindText);
  end
  else
  begin
    MessageDlg('Chaine '''+ DialogRechercher.FindText +''' non trouve !', mtInformation,[mbOk], 0);
    Editeur.SelLength := 0;
  end;
  DialogRechercher.CloseDialog;
end;

procedure TFPrincipale.RemplacerClick(Sender: TObject);
begin
  with Editeur do
    if (SelLength > 0) and (SelLength < 20) then
      DialogRemplacer.FindText := SelText;
  DialogRemplacer.Execute;
end;

procedure TFPrincipale.DialogRemplacerFind(Sender: TObject);
const
  STypes: array[0..3] of TSearchTypes =
  ([],[stMatchCase],[stWholeWord],[stWholeWord,stMatchCase]);
var
  FoundAt: LongInt;
  StartPos, ToEnd: integer;
  N: byte;
begin
  { commence la recherche aprs la slection en cours s'il y en a une }
  { sinon, commence au dbut du texte }

  if Editeur.SelLength<>0 then StartPos := Editeur.SelStart + Editeur.SelLength
                          else StartPos := 0;

  { ToEnd indique la longueur entre StartPos et la fin du texte du contrle }

  ToEnd := Editeur.GetTextLen - StartPos;

  with DialogRemplacer do
  begin
    if (frWholeWord in Options) then N := 2
                                else N := 0;
    if (frMatchCase in Options) then inc(N);
    FoundAt := Editeur.FindText(FindText, StartPos, ToEnd, STypes[N]);
  end;

  if FoundAt <> -1 then
  begin
    Editeur.SetFocus;
    Editeur.SelStart := FoundAt;
    Editeur.SelLength := Length(DialogRemplacer.FindText);
  end
  else
  begin
    DialogRemplacer.CloseDialog;
    MessageDlg('Remplacement de '''+ DialogRemplacer.FindText +
      ''' par ''' + DialogRemplacer.ReplaceText + ''' termin !', mtInformation,[mbOk], 0);
    Editeur.SelLength := 0;
  end;
end;

procedure TFPrincipale.DialogRemplacerReplace(Sender: TObject);
begin
  Screen.Cursor := crHourGlass;
  Editeur.Perform(WM_SETREDRAW,0,0);
  try
    while true do
    begin
      if Editeur.SelText <> DialogRemplacer.FindText then DialogRemplacerFind(Sender);
      if Editeur.SelLength = 0 then break;
      Editeur.SelText := DialogRemplacer.ReplaceText;
      if not (frReplaceAll in DialogRemplacer.Options) then break;
    end;
  finally
    Screen.Cursor := crDefault;
    Editeur.Perform(WM_SETREDRAW,1,0);
    Editeur.Refresh;
  end;
end;

end.
